/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.sbmlExtension;

import java.util.HashMap;
import java.util.Vector;
import jp.sbi.celldesigner.ComplexProperty;
import jp.sbi.celldesigner.ComplexSpeciesAlias;
import jp.sbi.celldesigner.ComplexSpeciesProperty;
import jp.sbi.celldesigner.MonoSpeciesProperty;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.SpeciesProperty;
import jp.sbi.celldesigner.sbmlExtension.ModelAnnotation;
import jp.sbi.sbml.Any;
import jp.sbi.sbml.util.LibSBMLUtil;
import org.sbml.libsbml.Reaction;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Species;
import org.sbml.libsbml.XMLNamespaces;
import org.sbml.libsbml.XMLNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SpeciesAnnotation
implements Any {
    public static final int POS_NONE = 0;
    public static final int POS_OUTER_SURFACE = 1;
    public static final int POS_TRANSMEMBRANE = 2;
    public static final int POS_INNER_SURFACE = 3;
    public static final int POS_INSIDE = 4;
    public static final int POS_INSIDE_OF_MEMBRANE = 5;
    private SpeciesProperty property = null;
    private int positionToCompartment = 0;
    private String complexSpecies = "";
    private Vector referedAliases = new Vector();
    private Vector catalizedReactions = null;
    private Node nodeForMiriam = null;
    public static final int iClassColDefaultWidth = 60;
    private StringBuffer bufAnnotation = new StringBuffer();
    private HashMap hashLocalNS = new HashMap();

    public SpeciesAnnotation copy() {
        SpeciesAnnotation newSA = new SpeciesAnnotation();
        newSA.setCatalizedReactions(this.catalizedReactions);
        newSA.setComplexSpecies(this.complexSpecies);
        newSA.setPositionToCompartment(this.positionToCompartment);
        newSA.setSpeciesProperty(this.getSpeciesProperty());
        return newSA;
    }

    public void setSpeciesProperty(SpeciesProperty property) {
        this.property = property;
    }

    public SpeciesProperty getSpeciesProperty() {
        return this.property;
    }

    public void addReference(SpeciesAlias alias) {
        if (this.referedAliases.contains(alias)) {
            return;
        }
        this.referedAliases.add(alias);
    }

    public void removeReference(SpeciesAlias alias) {
        this.referedAliases.remove(alias);
    }

    public boolean hasReferences() {
        return this.referedAliases.size() > 0;
    }

    public Vector getReferingAliases() {
        return (Vector)this.referedAliases.clone();
    }

    public void setCatalizedReactions(Vector catalizedReactions) {
        this.catalizedReactions = catalizedReactions;
    }

    public void setPositionToCompartment(int positionToCompartment) {
        this.positionToCompartment = positionToCompartment;
    }

    public int getPositionToCompartment() {
        return this.positionToCompartment;
    }

    public static String getPositionString(int pos) {
        switch (pos) {
            case 0: {
                return "none";
            }
            case 1: {
                return "outerSurface";
            }
            case 2: {
                return "transmembrane";
            }
            case 3: {
                return "innerSurface";
            }
            case 4: {
                return "inside";
            }
            case 5: {
                return "insideOfMembrane";
            }
        }
        return "unknown";
    }

    public void setPositionFromString(String str) {
        this.positionToCompartment = str.equals("none") ? 0 : (str.equals("outerSurface") ? 1 : (str.equals("transmembrane") ? 2 : (str.equals("innerSurface") ? 3 : (str.equals("inside") ? 4 : (str.equals("insideOfMembrane") ? 5 : 0)))));
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{"class", "positionToCompartment", "included"};
    }

    @Override
    public String[] getAttributeShortNames() {
        return new String[]{"class", "positionToCompartment", "included"};
    }

    @Override
    public int[] getAttributeColumnSizes() {
        return new int[]{60, 60, 100};
    }

    @Override
    public String[] getAttributeValues() {
        if (this.property instanceof MonoSpeciesProperty) {
            String strIncluded = "";
            try {
                strIncluded = ComplexSpeciesAlias.getMembersRelationStr(this.getReferingAliases().get(0));
            }
            catch (Exception myErr) {
                strIncluded = "";
            }
            return new String[]{((MonoSpeciesProperty)this.property).getType(), SpeciesAnnotation.getPositionString(this.positionToCompartment), strIncluded};
        }
        return new String[]{"HETERO_DIMER", SpeciesAnnotation.getPositionString(this.positionToCompartment)};
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public void readDOMTree(Element element) throws Exception {
        SpeciesProperty property = null;
        NodeList childlistTop = element.getChildNodes();
        NodeList childlistCellD = null;
        NodeList childlist = null;
        int iLoopMaxTimes = 2;
        int iLoopMax = 2;
        boolean bCellDVerMaxThan401 = false;
        childlist = childlistTop;
        do {
            int childsize = childlist.getLength();
            int i = 0;
            while (i < childsize) {
                String tag;
                Element elem;
                Node node = childlist.item(i);
                if (node.getNodeType() == 1 && ((Element)node).getPrefix() != null && ((Element)node).getPrefix().equals("celldesigner") && ((Element)node).getLocalName() != null && ((Element)node).getLocalName().equals("extension")) {
                    childlistCellD = node.getChildNodes();
                    if (childlistCellD == null || childlist.getLength() <= 0) {
                        throw new Exception();
                    }
                    bCellDVerMaxThan401 = true;
                } else if (node.getNodeName() != null && node.getNodeName().equals("rdf:RDF")) {
                    this.nodeForMiriam = (Element)node;
                } else if (node.getNodeType() == 1 && "http://www.sbml.org/2001/ns/celldesigner".equals(node.getNamespaceURI())) {
                    String s;
                    elem = (Element)node;
                    tag = elem.getLocalName();
                    if (elem.getLocalName().equals("positionToCompartment")) {
                        s = elem.getFirstChild().getNodeValue();
                        this.setPositionFromString(s);
                    } else if (elem.getLocalName().equals("complexSpecies")) {
                        this.complexSpecies = s = elem.getFirstChild().getNodeValue();
                    } else if (elem.getLocalName().equals("speciesIdentity")) {
                        property = new MonoSpeciesProperty();
                        property.readDOMTree(elem);
                        if (((MonoSpeciesProperty)property).getType().equals("COMPLEX") || ((MonoSpeciesProperty)property).getType().equals("COMPLEX_PACKED")) {
                            property = new ComplexProperty((MonoSpeciesProperty)property);
                        }
                    } else if (elem.getLocalName().equals("heterodimerIdentity")) {
                        property = new ComplexSpeciesProperty();
                        property.readDOMTree(elem);
                    }
                } else if (iLoopMax == 2 && node.getNodeType() == 1) {
                    int j = 0;
                    while (j < element.getAttributes().getLength()) {
                        Node n = element.getAttributes().item(j);
                        if (n.getNodeName().indexOf("xmlns:") != -1) {
                            this.hashLocalNS.put(n.getLocalName(), n.getNodeValue());
                        }
                        ++j;
                    }
                    elem = (Element)node;
                    tag = elem.getLocalName();
                    if (elem.getPrefix() != null) {
                        this.bufAnnotation.append("<" + elem.getPrefix() + ":" + tag);
                    } else {
                        this.bufAnnotation.append("<" + tag);
                    }
                    NamedNodeMap map = elem.getAttributes();
                    if (map.getLength() == 0) {
                        this.bufAnnotation.append(">");
                    }
                    int k = 0;
                    while (k < map.getLength()) {
                        Node nodes = map.item(k);
                        this.bufAnnotation.append(" " + nodes.getNodeName() + "=\"" + nodes.getNodeValue() + "\"");
                        if (k + 1 >= map.getLength()) {
                            this.bufAnnotation.append(">\n");
                        }
                        ++k;
                    }
                    this.readSomeAnnotation(elem);
                    if (elem.getPrefix() != null) {
                        this.bufAnnotation.append("</" + elem.getPrefix() + ":" + tag + ">\n");
                    } else {
                        this.bufAnnotation.append("</" + tag + ">\n");
                    }
                }
                ++i;
            }
            if (!bCellDVerMaxThan401) break;
            childlist = childlistCellD;
        } while (--iLoopMax > 0);
        if (property != null) {
            this.setSpeciesProperty(property);
        }
    }

    @Override
    public HashMap getLocalNS() {
        return this.hashLocalNS;
    }

    private void readSomeAnnotation(Element elem) {
        NodeList children = elem.getChildNodes();
        int j = 0;
        while (j < children.getLength()) {
            Node pNode = children.item(j);
            if (pNode.getNodeType() == 1) {
                Element elem2 = (Element)pNode;
                String tag = elem2.getLocalName();
                if (elem2.getPrefix() != null) {
                    this.bufAnnotation.append("<" + elem2.getPrefix() + ":" + tag);
                } else {
                    this.bufAnnotation.append("<" + tag);
                }
                NamedNodeMap map = elem2.getAttributes();
                if (map.getLength() == 0) {
                    this.bufAnnotation.append(">");
                }
                int i = 0;
                while (i < map.getLength()) {
                    Node nodes = map.item(i);
                    this.bufAnnotation.append(" " + nodes.getNodeName() + "=\"" + nodes.getNodeValue() + "\"");
                    if (i + 1 >= map.getLength()) {
                        this.bufAnnotation.append(">\n");
                    }
                    ++i;
                }
                this.readSomeAnnotation((Element)pNode);
                if (elem2.getPrefix() != null) {
                    this.bufAnnotation.append("</" + elem2.getPrefix() + ":" + tag + ">\n");
                } else {
                    this.bufAnnotation.append("</" + tag + ">\n");
                }
            } else if (pNode.getNodeValue() != null && !pNode.getNodeValue().equals("") && !pNode.getNodeValue().equals("\n")) {
                this.bufAnnotation.append(pNode.getNodeValue());
            }
            ++j;
        }
    }

    @Override
    public void writeDOMTree(Node node) {
        Element elem;
        Document doc = node.getOwnerDocument();
        String URI2 = node.getNamespaceURI();
        String ns = ModelAnnotation.getOutputNamespace();
        if (this.positionToCompartment != 0) {
            elem = doc.createElementNS(URI2, String.valueOf(ns) + ":" + "positionToCompartment");
            node.appendChild(elem);
            elem.appendChild(doc.createTextNode(SpeciesAnnotation.getPositionString(this.positionToCompartment)));
        }
        if (!this.complexSpecies.equals("")) {
            elem = doc.createElementNS(URI2, String.valueOf(ns) + ":" + "complexSpecies");
            node.appendChild(elem);
            elem.appendChild(doc.createTextNode(this.complexSpecies));
        }
        if (this.property != null) {
            Element propelem;
            if (this.property instanceof MonoSpeciesProperty) {
                propelem = doc.createElementNS(URI2, String.valueOf(ns) + ":" + "speciesIdentity");
                node.appendChild(propelem);
                this.property.writeDOMTree(propelem);
            } else {
                propelem = doc.createElementNS(URI2, String.valueOf(ns) + ":" + "heterodimerIdentity");
                node.appendChild(propelem);
                this.property.writeDOMTree(propelem);
            }
        }
        if (this.catalizedReactions != null) {
            if (this.catalizedReactions.size() > 0) {
                Element listelem = doc.createElementNS(URI2, String.valueOf(ns) + ":listOfCatalyzedReactions");
                node.appendChild(listelem);
                int i = 0;
                while (i < this.catalizedReactions.size()) {
                    Reaction r = (Reaction)this.catalizedReactions.elementAt(i);
                    Element caelem = doc.createElementNS(URI2, String.valueOf(ns) + ":catalyzed");
                    listelem.appendChild(caelem);
                    caelem.setAttributeNS(null, "reaction", r.getId());
                    ++i;
                }
            }
            this.catalizedReactions.clear();
            this.catalizedReactions = null;
        }
    }

    public void updateAnnotation(StringBuffer buf, SpeciesAnnotation spAnno) {
        if (spAnno.getPositionToCompartment() != 0) {
            buf.append("<celldesigner:positionToCompartment>" + SpeciesAnnotation.getPositionString(spAnno.getPositionToCompartment()) + "</celldesigner:" + "positionToCompartment>\n");
        }
        if (!spAnno.getComplexSpecies().equals("")) {
            buf.append("<celldesigner:complexSpecies>" + spAnno.getComplexSpecies() + "</celldesigner:" + "complexSpecies>\n");
        }
        if (spAnno.getSpeciesProperty() != null) {
            SpeciesProperty property;
            if (spAnno.getSpeciesProperty() instanceof MonoSpeciesProperty) {
                property = (MonoSpeciesProperty)spAnno.getSpeciesProperty();
                ((MonoSpeciesProperty)property).updateAnnotation(buf);
            } else {
                property = (ComplexSpeciesProperty)spAnno.getSpeciesProperty();
                ((ComplexSpeciesProperty)property).updateAnnotation(buf);
            }
        }
        if (spAnno.catalizedReactions != null && spAnno.catalizedReactions.size() > 0) {
            buf.append("<celldesigner:listOfCatalyzedReactions>\n");
            int i = 0;
            while (i < spAnno.catalizedReactions.size()) {
                Reaction r = (Reaction)spAnno.catalizedReactions.elementAt(i);
                buf.append("<celldesigner:catalyzed reaction=\"" + r.getId() + "\"/>\n");
                ++i;
            }
            buf.append("</celldesigner:listOfCatalyzedReactions>\n");
        }
    }

    @Override
    public void releaseAllMembers() {
        this.referedAliases.clear();
        this.referedAliases = null;
        this.property = null;
    }

    public String getComplexSpecies() {
        return this.complexSpecies;
    }

    public void setComplexSpecies(String complexSpecies) {
        this.complexSpecies = complexSpecies;
    }

    @Override
    public void setParentSBase(SBase sbase) {
    }

    public void updateAnnotation(Species species, XMLNamespaces anntXmlNS) {
        Vector vecData = LibSBMLUtil.getMiriamDatasFromAnnotationOfSBase((SBase)species);
        StringBuffer buf = new StringBuffer();
        buf.append("<annotation xmlns:celldesigner=\"http://www.sbml.org/2001/ns/celldesigner\">");
        buf.append("\n");
        buf.append("<celldesigner:extension>");
        if (this.getPositionToCompartment() != 0) {
            buf.append("<celldesigner:");
            buf.append("positionToCompartment");
            buf.append(">");
            buf.append(SpeciesAnnotation.getPositionString(this.getPositionToCompartment()));
            buf.append("</celldesigner:");
            buf.append("positionToCompartment");
            buf.append(">\n");
        }
        if (!this.getComplexSpecies().equals("")) {
            buf.append("<celldesigner:");
            buf.append("complexSpecies");
            buf.append(">");
            buf.append(this.getComplexSpecies());
            buf.append("</celldesigner:");
            buf.append("complexSpecies>\n");
        }
        if (this.getSpeciesProperty() != null) {
            SpeciesProperty property;
            if (this.getSpeciesProperty() instanceof MonoSpeciesProperty) {
                property = (MonoSpeciesProperty)this.getSpeciesProperty();
                ((MonoSpeciesProperty)property).updateAnnotation(buf);
            } else {
                property = (ComplexSpeciesProperty)this.getSpeciesProperty();
                ((ComplexSpeciesProperty)property).updateAnnotation(buf);
            }
        }
        if (this.catalizedReactions != null && this.catalizedReactions.size() > 0) {
            buf.append("<celldesigner:");
            buf.append("listOfCatalyzedReactions>\n");
            int i = 0;
            while (i < this.catalizedReactions.size()) {
                Reaction r = (Reaction)this.catalizedReactions.elementAt(i);
                buf.append("<celldesigner:");
                buf.append("catalyzed reaction=\"");
                buf.append(r.getId());
                buf.append("\"/>\n");
                ++i;
            }
            buf.append("</celldesigner:");
            buf.append("listOfCatalyzedReactions>\n");
        }
        buf.append("</celldesigner:extension>");
        if (vecData != null && vecData.size() > 0) {
            buf = LibSBMLUtil.getMiriamValueFromMiriams(buf, (SBase)species, vecData, true);
        }
        buf.append(this.bufAnnotation.toString());
        buf.append("</annotation>");
        XMLNode annt = XMLNode.convertStringToXMLNode((String)buf.toString(), (XMLNamespaces)anntXmlNS);
        species.setAnnotation(annt);
    }

    public Node getNodeForMiriam() {
        return this.nodeForMiriam;
    }

    public void setNodeForMiriam(Node nodeForMiriam) {
        this.nodeForMiriam = nodeForMiriam;
    }

    public StringBuffer getOtherAnnotation() {
        return this.bufAnnotation;
    }

    public void setOtherAnnotation(StringBuffer strBufAnnotation) {
        this.bufAnnotation = strBufAnnotation;
    }
}

