/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.sbmlExtension;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import jp.co.mki.celldesigner.simulation.util.StringTool;
import jp.fric.graphics.draw.GEditPoint;
import jp.fric.graphics.draw.GEditable;
import jp.fric.graphics.draw.GElement;
import jp.fric.graphics.draw.GLinkConnectSchemeOwner;
import jp.fric.graphics.draw.GLinkPosition;
import jp.fric.graphics.draw.GLinkPositionInfo;
import jp.fric.graphics.draw.GLinkTarget;
import jp.fric.graphics.draw.GLinkedCreaseLine;
import jp.fric.graphics.draw.GLinkedLine;
import jp.fric.graphics.draw.GLinkedLineComplex3;
import jp.fric.graphics.draw.GLinkedLineIndex;
import jp.fric.graphics.draw.GLinkedShape;
import jp.fric.graphics.draw.GLinkedStraightLine;
import jp.sbi.celldesigner.CreasePoint;
import jp.sbi.celldesigner.LinkedCreaseLine;
import jp.sbi.celldesigner.LinkedCreaseLineModification;
import jp.sbi.celldesigner.ReactionLink;
import jp.sbi.celldesigner.ReactionSymbol;
import jp.sbi.celldesigner.SBFactory;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.SBSymbol;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.sbmlExtension.ModelAnnotation;
import jp.sbi.celldesigner.sbmlExtension.SpeciesAnnotation;
import jp.sbi.celldesigner.sbmlExtension.SpeciesReferenceAnnotation;
import jp.sbi.celldesigner.symbol.color.ReactionColorScheme;
import jp.sbi.celldesigner.symbol.reaction.AddProduct;
import jp.sbi.celldesigner.symbol.reaction.AddReactant;
import jp.sbi.celldesigner.symbol.reaction.GLogicGate;
import jp.sbi.celldesigner.symbol.reaction.KnownTransitionOmitted;
import jp.sbi.celldesigner.symbol.reaction.StateTransition;
import jp.sbi.celldesigner.symbol.reaction.mixednotation.LinkedCreaseLineMixedNotation;
import jp.sbi.sbml.Any;
import jp.sbi.sbml.util.LibSBMLUtil;
import org.sbml.libsbml.ListOfSpeciesReferences;
import org.sbml.libsbml.Model;
import org.sbml.libsbml.ModifierSpeciesReference;
import org.sbml.libsbml.Reaction;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Species;
import org.sbml.libsbml.SpeciesReference;
import org.sbml.libsbml.XMLNamespaces;
import org.sbml.libsbml.XMLNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ReactionAnnotation
implements Any {
    public static final String strReactionType = "type";
    public static final int iTypeColDefaultWidth = 110;
    private String reactionName = "";
    private String type = "";
    private ReactionLink baseLink = null;
    private Vector addReactantLinks = new Vector();
    private Vector addProductLinks = new Vector();
    private Vector modificationLinks = new Vector();
    private Node nodeListOfReactantLinks = null;
    private Node nodeListOfProductLinks = null;
    private Node nodeListOfModifications = null;
    private Node nodeResourceOfDescriptionOfReaction = null;
    private Node nodeListOfBaseLinkGate = null;
    private String targetAliasId = null;
    private int oldLineIndex = -1;
    private String editPoints = null;
    private Element elementForEditPoints;
    private Element elementForReactionAnnotation;
    private double offsetX = 0.0;
    private double offsetY = 0.0;
    private double lineWidth = -1.0;
    private long lineColor = -1L;
    private static String RectangleIndexString = "rectangleIndex";
    private Vector baseReactantsIds = null;
    private Element baseReactantsElement = null;
    private Vector baseProductsIds = null;
    private Element baseProductsElements = null;
    private StringBuffer bufAnnotation = new StringBuffer();
    private HashMap hashLocalNS = new HashMap();
    private static String CONNECT_SCHEME_STR = "connectScheme";
    private static String CONNECT_POLICY_STR = "connectPolicy";
    private static String CONNECT_POLICY_SQUARE_STR = "square";
    private static String CONNECT_POLICY_DIRECT_STR = "direct";
    private static final String LISTOF_LINE_DIRECTION_STR = "listOfLineDirection";
    private static final String LINE_DIRECTION_STR = "lineDirection";
    private static final String ARM_ATTR_STR = "arm";
    private static final String INDEX_ATTR_STR = "index";
    private static final String VALUE_ATTR_STR = "value";
    private static final String LINE_DIRECTION_VERTICAL_STR = "vertical";
    private static final String LINE_DIRECTION_HORIZONTAL_STR = "horizontal";

    public void setReactionName(String name) {
        this.reactionName = name;
    }

    public String getReactionName() {
        return this.reactionName;
    }

    public void setType(String type) {
        this.type = type == null ? "" : SBFactory.filterSynonym(type);
    }

    public String getType() {
        return this.type;
    }

    public void setBaseLink(ReactionLink baseLink) {
        this.baseLink = baseLink;
    }

    public ReactionLink getBaseLink() {
        return this.baseLink;
    }

    public void addAddReactantLink(ReactionLink link) {
        this.addReactantLinks.add(link);
    }

    public void removeAddReactantLink(ReactionLink link) {
        this.addReactantLinks.remove(link);
    }

    public void addAddProductLink(ReactionLink link) {
        this.addProductLinks.add(link);
    }

    public void removeAddProductLink(ReactionLink link) {
        this.addProductLinks.remove(link);
    }

    public void addModificationLink(ReactionLink link) {
        this.modificationLinks.add(link);
    }

    public void removeModificationLink(ReactionLink link) {
        this.modificationLinks.remove(link);
    }

    private void setOffset(double x, double y) {
        this.offsetX = x;
        this.offsetY = y;
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{strReactionType};
    }

    @Override
    public String[] getAttributeShortNames() {
        return new String[]{strReactionType};
    }

    @Override
    public int[] getAttributeColumnSizes() {
        return new int[]{110};
    }

    @Override
    public String[] getAttributeValues() {
        return new String[]{this.type};
    }

    @Override
    public boolean hasValue() {
        return !this.type.equals("") && !this.type.equals("(no specified)") && !this.type.equals("");
    }

    @Override
    public void readDOMTree(Element element) throws Exception {
        NodeList childlistTop = element.getChildNodes();
        NodeList childlistCellD = null;
        NodeList childlist = null;
        int iLoopMaxTimes = 2;
        int iLoopMax = 2;
        boolean bCellDVerMaxThan401 = false;
        childlist = childlistTop;
        do {
            int childsize = childlist.getLength();
            int i = 0;
            while (i < childsize) {
                String tag;
                Element elem;
                Node node = childlist.item(i);
                if (node.getNodeType() == 1 && ((Element)node).getPrefix() != null && ((Element)node).getPrefix().equals("celldesigner") && ((Element)node).getLocalName() != null && ((Element)node).getLocalName().equals("extension")) {
                    childlistCellD = node.getChildNodes();
                    if (childlistCellD == null || childlist.getLength() <= 0) {
                        throw new Exception();
                    }
                    bCellDVerMaxThan401 = true;
                } else if (node.getNodeName() != null && node.getNodeName().equals("rdf:RDF")) {
                    this.nodeResourceOfDescriptionOfReaction = (Element)node;
                } else if (node.getNodeType() == 1 && node.getNamespaceURI().equals("http://www.sbml.org/2001/ns/celldesigner")) {
                    String str;
                    elem = (Element)node;
                    tag = elem.getLocalName();
                    if (elem.getLocalName().equals("name")) {
                        str = elem.getFirstChild().getNodeValue();
                        if (!str.equals("")) {
                            try {
                                this.reactionName = str;
                            }
                            catch (Exception exception) {}
                        }
                    } else if (elem.getLocalName().equals("reactionType")) {
                        str = elem.getFirstChild().getNodeValue();
                        this.setType(str);
                    } else if (elem.getLocalName().equals("baseReactants")) {
                        this.baseReactantsElement = elem;
                    } else if (elem.getLocalName().equals("baseProducts")) {
                        this.baseProductsElements = elem;
                    } else if (elem.getLocalName().equals(CONNECT_SCHEME_STR)) {
                        this.elementForReactionAnnotation = (Element)node.getParentNode();
                    } else if (elem.getLocalName().equals("listOfReactantLinks")) {
                        this.nodeListOfReactantLinks = elem;
                    } else if (elem.getLocalName().equals("listOfProductLinks")) {
                        this.nodeListOfProductLinks = elem;
                    } else if (elem.getLocalName().equals("listOfModification")) {
                        this.nodeListOfModifications = elem;
                    } else if (elem.getLocalName().equals("listOfGateMember")) {
                        this.nodeListOfBaseLinkGate = elem;
                    } else if (elem.getLocalName().equals("regulationTarget")) {
                        this.targetAliasId = elem.getFirstChild().getNodeValue();
                    } else if (elem.getLocalName().equals("offset")) {
                        String str_x = elem.getAttributeNS(null, "x");
                        String str_y = elem.getAttributeNS(null, "y");
                        try {
                            double x = Double.parseDouble(str_x);
                            double y = Double.parseDouble(str_y);
                            this.setOffset(x, y);
                        }
                        catch (Exception x) {}
                    } else if (elem.getLocalName().equals("editPoints")) {
                        this.elementForEditPoints = elem;
                        this.editPoints = elem.getFirstChild().getNodeValue();
                    } else if (elem.getLocalName().equals("line")) {
                        String str_width = elem.getAttributeNS(null, "width");
                        String str_color = elem.getAttributeNS(null, "color");
                        this.lineWidth = Double.parseDouble(str_width);
                        this.lineColor = Long.parseLong(str_color, 16);
                        if (this.lineWidth < 1.0) {
                            this.lineWidth = 1.0;
                        }
                    }
                } else if (iLoopMax == 2 && node.getNodeType() == 1) {
                    int j = 0;
                    while (j < element.getAttributes().getLength()) {
                        Node n = element.getAttributes().item(j);
                        if (n.getNodeName().indexOf("xmlns:") != -1) {
                            this.hashLocalNS.put(n.getLocalName(), n.getNodeValue());
                        }
                        ++j;
                    }
                    elem = (Element)node;
                    tag = elem.getLocalName();
                    if (elem.getPrefix() != null) {
                        this.bufAnnotation.append("<" + elem.getPrefix() + ":" + tag);
                    } else {
                        this.bufAnnotation.append("<" + tag);
                    }
                    NamedNodeMap map = elem.getAttributes();
                    if (map.getLength() == 0) {
                        this.bufAnnotation.append(">");
                    }
                    int k = 0;
                    while (k < map.getLength()) {
                        Node nodes = map.item(k);
                        this.bufAnnotation.append(" " + nodes.getNodeName() + "=\"" + nodes.getNodeValue() + "\"");
                        if (k + 1 >= map.getLength()) {
                            this.bufAnnotation.append(">\n");
                        }
                        ++k;
                    }
                    this.readSomeAnnotation(elem);
                    if (elem.getPrefix() != null) {
                        this.bufAnnotation.append("</" + elem.getPrefix() + ":" + tag + ">\n");
                    } else {
                        this.bufAnnotation.append("</" + tag + ">\n");
                    }
                }
                ++i;
            }
            if (!bCellDVerMaxThan401) break;
            childlist = childlistCellD;
        } while (--iLoopMax > 0);
    }

    @Override
    public HashMap getLocalNS() {
        return this.hashLocalNS;
    }

    private void readSomeAnnotation(Element elem) {
        NodeList children = elem.getChildNodes();
        int j = 0;
        while (j < children.getLength()) {
            Node pNode = children.item(j);
            if (pNode.getNodeType() == 1) {
                Element elem2 = (Element)pNode;
                String tag = elem2.getLocalName();
                if (elem2.getPrefix() != null) {
                    this.bufAnnotation.append("<" + elem2.getPrefix() + ":" + tag);
                } else {
                    this.bufAnnotation.append("<" + tag);
                }
                NamedNodeMap map = elem2.getAttributes();
                if (map.getLength() == 0) {
                    this.bufAnnotation.append(">");
                }
                int i = 0;
                while (i < map.getLength()) {
                    Node nodes = map.item(i);
                    this.bufAnnotation.append(" " + nodes.getNodeName() + "=\"" + nodes.getNodeValue() + "\"");
                    if (i + 1 >= map.getLength()) {
                        this.bufAnnotation.append(">\n");
                    }
                    ++i;
                }
                this.readSomeAnnotation((Element)pNode);
                if (elem2.getPrefix() != null) {
                    this.bufAnnotation.append("</" + elem2.getPrefix() + ":" + tag + ">\n");
                } else {
                    this.bufAnnotation.append("</" + tag + ">\n");
                }
            } else if (pNode.getNodeValue() != null && !pNode.getNodeValue().equals("") && !pNode.getNodeValue().equals("\n")) {
                this.bufAnnotation.append(pNode.getNodeValue());
            }
            ++j;
        }
    }

    private void getConnectLineDirVec(Element elem, Vector lineDirVec) {
        NodeList children = elem.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node n = children.item(i);
            if (n.getNodeType() == 1 && n.getNamespaceURI().equals("http://www.sbml.org/2001/ns/celldesigner") && n.getLocalName().equals(LISTOF_LINE_DIRECTION_STR)) {
                Element elem1 = (Element)n;
                NodeList children1 = elem1.getChildNodes();
                int i1 = 0;
                while (i1 < children1.getLength()) {
                    Node n1 = children1.item(i1);
                    if (n1.getNodeType() == 1 && n1.getNamespaceURI().equals("http://www.sbml.org/2001/ns/celldesigner") && n1.getLocalName().equals(LINE_DIRECTION_STR)) {
                        Vector<Integer> v;
                        Element elem2 = (Element)n1;
                        String str1 = elem2.getAttribute(ARM_ATTR_STR);
                        String str2 = elem2.getAttribute(INDEX_ATTR_STR);
                        String str3 = elem2.getAttribute(VALUE_ATTR_STR);
                        int arm = 0;
                        int index = 0;
                        int dir = 0;
                        if (str3.equals(LINE_DIRECTION_VERTICAL_STR)) {
                            dir = 1;
                        } else if (str3.equals(LINE_DIRECTION_HORIZONTAL_STR)) {
                            dir = 2;
                        }
                        try {
                            arm = Integer.parseInt(str1);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            index = Integer.parseInt(str2);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (lineDirVec.size() <= arm) {
                            lineDirVec.setSize(arm + 1);
                        }
                        if ((v = (Vector<Integer>)lineDirVec.get(arm)) == null) {
                            v = new Vector<Integer>();
                            lineDirVec.set(arm, v);
                        }
                        if (v.size() <= index) {
                            v.setSize(index + 1);
                        }
                        v.set(index, new Integer(dir));
                    }
                    ++i1;
                }
                break;
            }
            ++i;
        }
    }

    private int getConnectPolicy(Element elem, Vector lineDirVec) {
        int policy = 0;
        if (elem != null) {
            NodeList children = elem.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node n = children.item(i);
                if (n.getNodeType() == 1 && n.getNamespaceURI().equals("http://www.sbml.org/2001/ns/celldesigner") && n.getLocalName().equals(CONNECT_SCHEME_STR)) {
                    Element elem1 = (Element)n;
                    String str = elem1.getAttribute(CONNECT_POLICY_STR);
                    if (str.equals(CONNECT_POLICY_SQUARE_STR)) {
                        policy = 1;
                    }
                    this.getConnectLineDirVec(elem1, lineDirVec);
                    break;
                }
                ++i;
            }
        }
        return policy;
    }

    public Vector buildReactionLinksByDOMTree(SBModel sbModel, Vector aliases, Reaction reaction, Model model) {
        GLinkedLineIndex lineIndex;
        SpeciesAlias alias;
        String aliasId;
        ReactionLink link;
        SBSymbol sb3;
        String id;
        SpeciesAlias sa;
        SpeciesReferenceAnnotation anno;
        GEditPoint[] editPoints;
        int connectPolicy;
        Vector dirVec;
        Vector v;
        GLinkedLineIndex lineIndex2;
        String str_lineIndex2;
        GLinkPositionInfo lpi;
        SpeciesAlias alias2;
        String aliasId2;
        ReactionLink link2;
        SBSymbol sb2;
        Node n;
        SpeciesAlias alias3;
        SpeciesAlias alias4;
        String aliasId3;
        GLinkPositionInfo lpi2;
        String aid;
        ListIterator it;
        GElement alias5;
        Species species;
        String id2;
        boolean mustChangeCtlInh2PosNeg = false;
        Vector<ReactionLink> createdLinks = new Vector<ReactionLink>();
        String name = this.getReactionName();
        if (name.equals("")) {
            name = reaction.getName();
            if (!name.equals("")) {
                this.setReactionName(name);
            }
        } else if (reaction.getName().equals("")) {
            reaction.setName(name);
        }
        LinkedList<String> reactantAliases = new LinkedList<String>();
        ListOfSpeciesReferences listOfReactants = reaction.getListOfReactants();
        int i = 0;
        while ((long)i < listOfReactants.size()) {
            SpeciesReference ref = (SpeciesReference)listOfReactants.get((long)i);
            String aid2 = ((SpeciesReferenceAnnotation)LibSBMLUtil.getAnnotation(sbModel, reaction, (SBase)ref, "Reactants", i, null)).getTmpAliasId();
            reactantAliases.add(aid2);
            ++i;
        }
        LinkedList<String> productAliases = new LinkedList<String>();
        ListOfSpeciesReferences listOfProducts = reaction.getListOfProducts();
        int i2 = 0;
        while ((long)i2 < listOfProducts.size()) {
            SpeciesReference ref = (SpeciesReference)listOfProducts.get((long)i2);
            String aid3 = ((SpeciesReferenceAnnotation)LibSBMLUtil.getAnnotation(sbModel, reaction, (SBase)ref, "Products", i2, null)).getTmpAliasId();
            productAliases.add(aid3);
            ++i2;
        }
        if ("CATALYSIS".equals(this.type)) {
            mustChangeCtlInh2PosNeg = true;
            this.setType("POSITIVE_INFLUENCE");
        } else if ("INHIBITION".equals(this.type)) {
            mustChangeCtlInh2PosNeg = true;
            this.setType("NEGATIVE_INFLUENCE");
        } else if ("UNKNOWN_CATALYSIS".equals(this.type)) {
            mustChangeCtlInh2PosNeg = true;
            this.setType("UNKNOWN_POSITIVE_INFLUENCE");
        } else if ("UNKNOWN_INHIBITION".equals(this.type)) {
            mustChangeCtlInh2PosNeg = true;
            this.setType("UNKNOWN_NEGATIVE_INFLUENCE");
        } else if (GLogicGate.isMixedNotationModificationType(this.type)) {
            mustChangeCtlInh2PosNeg = true;
        }
        SBSymbol symbol = SBFactory.createSymbol(this.getType());
        if (symbol == null) {
            return createdLinks;
        }
        Vector lineDirVec = new Vector();
        int policy = this.getConnectPolicy(this.elementForReactionAnnotation, lineDirVec);
        if (symbol instanceof GLinkConnectSchemeOwner) {
            ((GLinkConnectSchemeOwner)((Object)symbol)).setConnectPolicy(policy);
        }
        this.buildEditPointsByString(this.elementForEditPoints, this.editPoints, symbol, lineDirVec);
        ReactionLink baseLink = new ReactionLink(((ReactionSymbol)((Object)symbol)).sourceSize(), ((ReactionSymbol)((Object)symbol)).destinationSize());
        try {
            baseLink.setSymbol(symbol);
        }
        catch (Exception exception) {
            // empty catch block
        }
        baseLink.setParentReaction(reaction);
        baseLink.setName(reaction.getId());
        if (this.baseReactantsIds != null) {
            Map lpiMapByAliasId = this.createLPIMapByAliasId(this.baseReactantsElement, "baseReactant");
            int i3 = 0;
            while (i3 < this.baseReactantsIds.size()) {
                id2 = (String)this.baseReactantsIds.elementAt(i3);
                species = model.getSpecies(id2);
                Vector rAliases = ((SpeciesAnnotation)LibSBMLUtil.getAnnotation(sbModel, (SBase)species, null)).getReferingAliases();
                alias5 = null;
                it = reactantAliases.listIterator();
                while (it.hasNext()) {
                    aid = (String)it.next();
                    alias5 = this.getSpeciesAlias(aid, rAliases);
                    if (alias5 == null) continue;
                    it.remove();
                    break;
                }
                if (alias5 != null) {
                    lpi2 = (GLinkPositionInfo)lpiMapByAliasId.get(alias5.getName());
                    baseLink.addSource((GLinkTarget)((Object)alias5), lpi2);
                } else {
                    System.out.println("[ReactionAnnotation]buildReactionLinksByDOMTree()2_1, alias not found, ReactantId=" + id2 + " of Reaction=" + reaction.getId());
                }
                ++i3;
            }
        } else {
            int i4 = 0;
            while ((long)i4 < reaction.getListOfReactants().size()) {
                SpeciesReference ref = (SpeciesReference)reaction.getListOfReactants().get((long)i4);
                aliasId3 = ((SpeciesReferenceAnnotation)LibSBMLUtil.getAnnotation(sbModel, reaction, (SBase)ref, "Reactants", i4, null)).getTmpAliasId();
                alias4 = this.getSpeciesAlias(aliasId3, aliases);
                if (alias4 != null) {
                    baseLink.addSource((GLinkTarget)alias4, (GLinkPositionInfo)null);
                } else {
                    System.out.println("[ReactionAnnotation]buildReactionLinksByDOMTree()2_2,alias==null, aliasId=" + aliasId3);
                }
                ++i4;
            }
        }
        if (this.baseProductsIds != null) {
            Map lpiMapByAliasId = this.createLPIMapByAliasId(this.baseProductsElements, "baseProduct");
            int i5 = 0;
            while (i5 < this.baseProductsIds.size()) {
                id2 = (String)this.baseProductsIds.elementAt(i5);
                species = model.getSpecies(id2);
                Vector pAliases = ((SpeciesAnnotation)LibSBMLUtil.getAnnotation(sbModel, (SBase)species, null)).getReferingAliases();
                alias5 = null;
                it = productAliases.listIterator();
                while (it.hasNext()) {
                    aid = (String)it.next();
                    alias5 = this.getSpeciesAlias(aid, pAliases);
                    if (alias5 == null) continue;
                    it.remove();
                    break;
                }
                if (alias5 != null) {
                    lpi2 = (GLinkPositionInfo)lpiMapByAliasId.get(alias5.getName());
                    baseLink.addDestination((GLinkTarget)((Object)alias5), lpi2);
                } else {
                    System.out.println("[ReactionAnnotation]buildReactionLinksByDOMTree()3_1, alias not found, ProductIds=" + id2 + " of Reaction=" + reaction.getId());
                }
                ++i5;
            }
        } else {
            int i6 = 0;
            while ((long)i6 < reaction.getListOfProducts().size()) {
                SpeciesReference ref = (SpeciesReference)reaction.getListOfProducts().get((long)i6);
                aliasId3 = ((SpeciesReferenceAnnotation)LibSBMLUtil.getAnnotation(sbModel, reaction, (SBase)ref, "Products", i6, null)).getTmpAliasId();
                alias4 = this.getSpeciesAlias(aliasId3, aliases);
                if (alias4 != null) {
                    baseLink.addDestination((GLinkTarget)alias4, (GLinkPositionInfo)null);
                } else {
                    System.out.println("[ReactionAnnotation]buildReactionLinksByDOMTree()3_2,alias==null, aliasId=" + aliasId3);
                }
                ++i6;
            }
        }
        if (this.targetAliasId != null && !this.targetAliasId.equals("") && baseLink.targetSize() > 1 && (alias3 = this.getSpeciesAlias(this.targetAliasId, aliases)) != null) {
            int i7 = 0;
            while (i7 < baseLink.targetSize()) {
                try {
                    GLinkTarget gelem = baseLink.getTargetAt(i7);
                    if (gelem == alias3) {
                        this.oldLineIndex = i7;
                        break;
                    }
                }
                catch (Exception gelem) {
                    // empty catch block
                }
                ++i7;
            }
        }
        if (this.offsetX != 0.0 || this.offsetY != 0.0) {
            ((GLinkedShape)((Object)symbol)).setOffset(this.offsetX, this.offsetY);
        }
        ((ReactionSymbol)((Object)symbol)).setReversible(reaction.getReversible());
        String code = this.getType();
        if (this.lineColor != -1L) {
            ((GLinkedShape)((Object)symbol)).setColor(new Color((int)this.lineColor, true));
        } else {
            ((GLinkedShape)((Object)symbol)).setColor(ReactionColorScheme.getColor(code));
        }
        if (this.lineWidth > 0.0) {
            ((GLinkedShape)((Object)symbol)).setLineWidth(this.lineWidth);
        } else {
            ((GLinkedShape)((Object)symbol)).setLineWidth(ReactionColorScheme.getLineWidth(code));
        }
        this.setBaseLink(baseLink);
        createdLinks.add(baseLink);
        if (this.nodeListOfReactantLinks != null) {
            NodeList children = this.nodeListOfReactantLinks.getChildNodes();
            int i8 = 0;
            while (i8 < children.getLength()) {
                n = children.item(i8);
                if (n.getNodeType() == 1 && n.getNamespaceURI().equals("http://www.sbml.org/2001/ns/celldesigner") && n.getLocalName().equals("reactantLink")) {
                    sb2 = SBFactory.createSymbol("ADD_REACTANT");
                    link2 = new ReactionLink(((ReactionSymbol)((Object)sb2)).sourceSize(), ((ReactionSymbol)((Object)sb2)).destinationSize());
                    try {
                        link2.setSymbol(sb2);
                    }
                    catch (Exception lpi3) {
                        // empty catch block
                    }
                    link2.setParentReaction(reaction);
                    link2.setName(String.valueOf(reaction.getId()) + "r" + i8);
                    aliasId2 = ((Element)n).getAttributeNS(null, "alias");
                    alias2 = this.getSpeciesAlias(aliasId2, aliases);
                    if (alias2 == null) {
                        System.out.println("[ReactionAnnotation]buildReactionLinksByDOMTree()reactant,alias==null, aliasId=" + aliasId2);
                    } else {
                        lpi = this.getLPIFromChildElement((Element)n);
                        link2.addSource((GLinkTarget)alias2, lpi);
                        str_lineIndex2 = ((Element)n).getAttributeNS(null, "targetLineIndex");
                        lineIndex2 = this.createLineIndex(str_lineIndex2);
                        if (lineIndex2 == null) {
                            link2.addDestination((GLinkTarget)baseLink, (GLinkPositionInfo)null);
                        } else {
                            link2.addDestination((GLinkTarget)baseLink, lineIndex2);
                        }
                        this.lineColor = -1L;
                        this.lineWidth = -1.0;
                        v = this.getLWCFromChildElement((Element)n);
                        code = sb2.getCode();
                        if (((String)v.get(0)).length() > 0) {
                            this.lineWidth = Double.parseDouble((String)v.get(0));
                            link2.getGLinkedShape().setLineWidth(this.lineWidth);
                        }
                        if (((String)v.get(1)).length() > 0) {
                            this.lineColor = Long.parseLong((String)v.get(1), 16);
                            link2.getGLinkedShape().setColor(new Color((int)this.lineColor, true));
                        }
                        if (this.lineColor == -1L) {
                            link2.getGLinkedShape().setColor(ReactionColorScheme.getColor(code));
                        }
                        if (this.lineWidth < 0.0) {
                            link2.getGLinkedShape().setLineWidth(ReactionColorScheme.getLineWidth(code));
                        }
                        link2.getGLinkedShape().setLineType(ReactionAnnotation.convertReactionLinkType((String)v.get(2)));
                        dirVec = new Vector();
                        connectPolicy = this.getConnectPolicy((Element)n, dirVec);
                        ((AddReactant)link2.getGLinkedShape()).setConnectPolicy(connectPolicy);
                        if (dirVec.size() > 0) {
                            ((AddReactant)link2.getGLinkedShape()).setlinesDirection((Vector)dirVec.get(0));
                        }
                        editPoints = this.getEditPointsFromChildElement((Element)n);
                        ((AddReactant)link2.getGLinkedShape()).setEditPoints(editPoints);
                        this.addAddReactantLink(link2);
                        createdLinks.add(link2);
                    }
                }
                ++i8;
            }
        } else if (this.baseReactantsIds != null) {
            int i9 = 0;
            while ((long)i9 < reaction.getListOfReactants().size()) {
                SpeciesReference ref = (SpeciesReference)reaction.getListOfReactants().get((long)i9);
                anno = (SpeciesReferenceAnnotation)LibSBMLUtil.getAnnotation(sbModel, reaction, (SBase)ref, "Reactants", i9, null);
                sa = this.getSpeciesAlias(anno.getTmpAliasId(), aliases);
                id = sa.getOriginalSpecies().getId();
                if (!this.baseReactantsIds.contains(id)) {
                    sb3 = SBFactory.createSymbol("ADD_REACTANT");
                    link = new ReactionLink(((ReactionSymbol)((Object)sb3)).sourceSize(), ((ReactionSymbol)((Object)sb3)).destinationSize());
                    try {
                        link.setSymbol(sb3);
                    }
                    catch (Exception str_lineIndex2) {
                        // empty catch block
                    }
                    link.setParentReaction(reaction);
                    link.setName(String.valueOf(reaction.getId()) + "r" + i9);
                    aliasId = ((SpeciesReferenceAnnotation)LibSBMLUtil.getAnnotation(sbModel, reaction, (SBase)ref, "Reactants", i9, null)).getTmpAliasId();
                    alias = this.getSpeciesAlias(aliasId, aliases);
                    if (alias == null) {
                        System.out.println("[ReactionAnnotation]buildReactionLinksByDOMTree()6,alias==null, aliasId=" + aliasId);
                    } else {
                        link.addSource((GLinkTarget)alias, (GLinkPositionInfo)null);
                        lineIndex = this.createLineIndex("");
                        if (lineIndex == null) {
                            link.addDestination((GLinkTarget)baseLink, (GLinkPositionInfo)null);
                        } else {
                            link.addDestination((GLinkTarget)baseLink, lineIndex);
                        }
                        this.addAddReactantLink(link);
                        createdLinks.add(link);
                    }
                }
                ++i9;
            }
        }
        if (this.nodeListOfProductLinks != null) {
            NodeList children = this.nodeListOfProductLinks.getChildNodes();
            int i10 = 0;
            while (i10 < children.getLength()) {
                n = children.item(i10);
                if (n.getNodeType() == 1 && n.getNamespaceURI().equals("http://www.sbml.org/2001/ns/celldesigner") && n.getLocalName().equals("productLink")) {
                    sb2 = SBFactory.createSymbol("ADD_PRODUCT");
                    link2 = new ReactionLink(((ReactionSymbol)((Object)sb2)).sourceSize(), ((ReactionSymbol)((Object)sb2)).destinationSize());
                    try {
                        link2.setSymbol(sb2);
                    }
                    catch (Exception sb3) {
                        // empty catch block
                    }
                    link2.setParentReaction(reaction);
                    link2.setName(String.valueOf(reaction.getId()) + "p" + i10);
                    aliasId2 = ((Element)n).getAttributeNS(null, "alias");
                    alias2 = this.getSpeciesAlias(aliasId2, aliases);
                    if (alias2 == null) {
                        System.out.println("[ReactionAnnotation]buildReactionLinksByDOMTree()product,alias==null, aliasId=" + aliasId2);
                    } else {
                        lpi = this.getLPIFromChildElement((Element)n);
                        link2.addDestination((GLinkTarget)alias2, lpi);
                        str_lineIndex2 = ((Element)n).getAttributeNS(null, "targetLineIndex");
                        lineIndex2 = this.createLineIndex(str_lineIndex2);
                        if (lineIndex2 == null) {
                            link2.addSource((GLinkTarget)baseLink, (GLinkPositionInfo)null);
                        } else {
                            link2.addSource((GLinkTarget)baseLink, lineIndex2);
                        }
                        this.lineColor = -1L;
                        this.lineWidth = -1.0;
                        v = this.getLWCFromChildElement((Element)n);
                        code = sb2.getCode();
                        if (((String)v.get(0)).length() > 0) {
                            this.lineWidth = Double.parseDouble((String)v.get(0));
                            link2.getGLinkedShape().setLineWidth(this.lineWidth);
                        }
                        if (((String)v.get(1)).length() > 0) {
                            this.lineColor = Long.parseLong((String)v.get(1), 16);
                            link2.getGLinkedShape().setColor(new Color((int)this.lineColor, true));
                        }
                        if (this.lineColor == -1L) {
                            link2.getGLinkedShape().setColor(ReactionColorScheme.getColor(code));
                        }
                        if (this.lineWidth < 0.0) {
                            link2.getGLinkedShape().setLineWidth(ReactionColorScheme.getLineWidth(code));
                        }
                        link2.getGLinkedShape().setLineType(ReactionAnnotation.convertReactionLinkType((String)v.get(2)));
                        dirVec = new Vector();
                        connectPolicy = this.getConnectPolicy((Element)n, dirVec);
                        ((AddProduct)link2.getGLinkedShape()).setConnectPolicy(connectPolicy);
                        if (dirVec.size() > 0) {
                            ((AddProduct)link2.getGLinkedShape()).setlinesDirection((Vector)dirVec.get(0));
                        }
                        editPoints = this.getEditPointsFromChildElement((Element)n);
                        ((AddProduct)link2.getGLinkedShape()).setEditPoints(editPoints);
                        this.addAddProductLink(link2);
                        createdLinks.add(link2);
                    }
                }
                ++i10;
            }
        } else if (this.baseProductsIds != null) {
            int i11 = 0;
            while ((long)i11 < reaction.getListOfProducts().size()) {
                SpeciesReference ref = (SpeciesReference)reaction.getListOfProducts().get((long)i11);
                anno = (SpeciesReferenceAnnotation)LibSBMLUtil.getAnnotation(sbModel, reaction, (SBase)ref, "Products", i11, null);
                sa = this.getSpeciesAlias(anno.getTmpAliasId(), aliases);
                id = sa.getOriginalSpecies().getId();
                if (!this.baseProductsIds.contains(id)) {
                    sb3 = SBFactory.createSymbol("ADD_PRODUCT");
                    link = new ReactionLink(((ReactionSymbol)((Object)sb3)).sourceSize(), ((ReactionSymbol)((Object)sb3)).destinationSize());
                    try {
                        link.setSymbol(sb3);
                    }
                    catch (Exception str_lineIndex3) {
                        // empty catch block
                    }
                    link.setParentReaction(reaction);
                    link.setName(String.valueOf(reaction.getId()) + "p" + i11);
                    aliasId = ((SpeciesReferenceAnnotation)LibSBMLUtil.getAnnotation(sbModel, reaction, (SBase)ref, "Products", i11, null)).getTmpAliasId();
                    alias = this.getSpeciesAlias(aliasId, aliases);
                    if (alias == null) {
                        System.out.println("[ReactionAnnotation]buildReactionLinksByDOMTree()6,alias==null, aliasId=" + aliasId);
                    } else {
                        link.addDestination((GLinkTarget)alias, (GLinkPositionInfo)null);
                        lineIndex = this.createLineIndex("");
                        if (lineIndex == null) {
                            link.addSource((GLinkTarget)baseLink, (GLinkPositionInfo)null);
                        } else {
                            link.addSource((GLinkTarget)baseLink, lineIndex);
                        }
                        this.addAddProductLink(link);
                        createdLinks.add(link);
                    }
                }
                ++i11;
            }
        }
        if (this.nodeListOfModifications == null) {
            return createdLinks;
        }
        NodeList children = this.nodeListOfModifications.getChildNodes();
        int i12 = 0;
        while (i12 < children.getLength()) {
            n = children.item(i12);
            if (n.getNodeType() == 1 && n.getNamespaceURI().equals("http://www.sbml.org/2001/ns/celldesigner") && n.getLocalName().equals("modification")) {
                SBSymbol sb4;
                Element elem = (Element)n;
                Map lpiMapByAliasId = this.createLPIMapByAliasId(elem, "linkTarget");
                String mType = elem.getAttributeNS(null, strReactionType);
                if (mustChangeCtlInh2PosNeg) {
                    if ("CATALYSIS".equals(mType)) {
                        mType = "POSITIVE_INFLUENCE";
                    } else if ("INHIBITION".equals(mType)) {
                        mType = "NEGATIVE_INFLUENCE";
                    } else if ("UNKNOWN_CATALYSIS".equals(mType)) {
                        mType = "UNKNOWN_POSITIVE_INFLUENCE";
                    } else if ("UNKNOWN_INHIBITION".equals(mType)) {
                        mType = "UNKNOWN_NEGATIVE_INFLUENCE";
                    }
                }
                if ((sb4 = SBFactory.createSymbol(mType)) == null) {
                    System.out.println("[ReactionAnnotation]buildReactionLinksByDOMTree()4,creageReactionSymbol==null, type=" + mType);
                } else {
                    Vector lineDirVec1 = new Vector();
                    policy = this.getConnectPolicy(elem, lineDirVec1);
                    if (sb4 instanceof GLinkConnectSchemeOwner) {
                        ((GLinkConnectSchemeOwner)((Object)sb4)).setConnectPolicy(policy);
                    }
                    String str_ep = elem.getAttributeNS(null, "editPoints");
                    this.buildEditPointsByString(elem, str_ep, sb4, lineDirVec1);
                    ReactionLink link3 = new ReactionLink(((ReactionSymbol)((Object)sb4)).sourceSize(), ((ReactionSymbol)((Object)sb4)).destinationSize());
                    try {
                        link3.setSymbol(sb4);
                    }
                    catch (Exception dirVec2) {
                        // empty catch block
                    }
                    link3.setParentReaction(reaction);
                    link3.setName(String.valueOf(reaction.getId()) + "m" + i12);
                    String aliasesString = elem.getAttributeNS(null, "aliases");
                    if (!aliasesString.equals("")) {
                        StringTokenizer st = new StringTokenizer(aliasesString, ",");
                        while (st.hasMoreTokens()) {
                            String aliasId4 = st.nextToken();
                            SpeciesAlias alias6 = this.getSpeciesAlias(aliasId4, aliases);
                            if (alias6 == null) {
                                System.out.println("[ReactionAnnotation]buildReactionLinksByDOMTree()6,alias==null, aliasId=" + aliasId4);
                                continue;
                            }
                            GLinkPositionInfo lpi4 = (GLinkPositionInfo)lpiMapByAliasId.get(aliasId4);
                            link3.addSource((GLinkTarget)alias6, lpi4);
                            ListOfSpeciesReferences listOfModifiers = reaction.getListOfModifiers();
                            Species original = alias6.getOriginalSpecies();
                            if (original == null) {
                                System.out.println("[ReactionAnnotation]buildReactionLinksByDOMTree()6,getOriginalSpecies==null, aliasId=" + aliasId4);
                                continue;
                            }
                            boolean exists = false;
                            int k = 0;
                            while ((long)k < listOfModifiers.size()) {
                                ModifierSpeciesReference msr2 = (ModifierSpeciesReference)listOfModifiers.get((long)k);
                                if (msr2.getSpecies().equals(original.getId())) {
                                    exists = true;
                                    break;
                                }
                                ++k;
                            }
                            if (exists) continue;
                            ModifierSpeciesReference msr = new ModifierSpeciesReference();
                            try {
                                msr.setSpecies(original.getId());
                            }
                            catch (Exception msr2) {
                                // empty catch block
                            }
                            ((SpeciesReferenceAnnotation)LibSBMLUtil.getAnnotation(sbModel, reaction, (SBase)msr, null, (int)listOfModifiers.size(), null)).setTmpAliasId(aliasId4);
                            listOfModifiers.appendAndOwn((SBase)msr);
                        }
                    } else {
                        String modifiers = elem.getAttributeNS(null, "modifiers");
                        StringTokenizer st = new StringTokenizer(modifiers, ",");
                        int index = 0;
                        while (st.hasMoreTokens()) {
                            String id3 = st.nextToken();
                            ModifierSpeciesReference ref = reaction.getModifier(id3);
                            if (ref == null) {
                                System.out.println("[ReactionAnnotation]buildReactionLinksByDOMTree()5,ModifierSpeciesReference==null, id=" + id3);
                                continue;
                            }
                            String aliasId5 = ((SpeciesReferenceAnnotation)LibSBMLUtil.getAnnotation(sbModel, reaction, (SBase)ref, null, index, null)).getTmpAliasId();
                            SpeciesAlias alias7 = this.getSpeciesAlias(aliasId5, aliases);
                            ++index;
                            if (alias7 != null) {
                                GLinkPositionInfo lpi5 = (GLinkPositionInfo)lpiMapByAliasId.get(aliasId5);
                                link3.addSource((GLinkTarget)alias7, lpi5);
                                continue;
                            }
                            System.out.println("[ReactionAnnotation]buildReactionLinksByDOMTree()6,alias==null, aliasId=" + aliasId5);
                        }
                    }
                    String str_lineIndex4 = elem.getAttributeNS(null, "targetLineIndex");
                    GLinkedLineIndex lineIndex3 = this.createLineIndex(str_lineIndex4);
                    if (lineIndex3 == null) {
                        link3.addDestination((GLinkTarget)baseLink, (GLinkPositionInfo)null);
                    } else {
                        link3.addDestination((GLinkTarget)baseLink, lineIndex3);
                    }
                    String str_x = elem.getAttributeNS(null, "offsetX");
                    String str_y = elem.getAttributeNS(null, "offsetY");
                    if (!str_x.equals("") || !str_y.equals("")) {
                        try {
                            double x = Double.parseDouble(str_x);
                            double y = Double.parseDouble(str_y);
                            ((GLinkedShape)((Object)sb4)).setOffset(x, y);
                        }
                        catch (Exception x) {
                            // empty catch block
                        }
                    }
                    this.lineColor = -1L;
                    this.lineWidth = -1.0;
                    Vector v2 = this.getLWCFromChildElement((Element)n);
                    code = sb4.getCode();
                    if (((String)v2.get(0)).length() > 0) {
                        this.lineWidth = Double.parseDouble((String)v2.get(0));
                        link3.getGLinkedShape().setLineWidth(this.lineWidth);
                    }
                    if (((String)v2.get(1)).length() > 0) {
                        this.lineColor = Long.parseLong((String)v2.get(1), 16);
                        link3.getGLinkedShape().setColor(new Color((int)this.lineColor, true));
                    }
                    if (this.lineColor == -1L) {
                        link3.getGLinkedShape().setColor(ReactionColorScheme.getColor(code));
                    }
                    if (this.lineWidth < 0.0) {
                        link3.getGLinkedShape().setLineWidth(ReactionColorScheme.getLineWidth(code));
                    }
                    this.addModificationLink(link3);
                    createdLinks.add(link3);
                }
            }
            ++i12;
        }
        return createdLinks;
    }

    private static int convertReactionLinkType(String linkType) {
        if ("Straight".equals(linkType)) {
            return 1;
        }
        if ("Curve".equals(linkType)) {
            return 0;
        }
        return 0;
    }

    private static String convertReactionLinkType(int linkType) {
        switch (linkType) {
            case 1: {
                return "Straight";
            }
            case 0: {
                return "Curve";
            }
        }
        return "Curve";
    }

    public Vector buildReactionLinksByDOMTreeNew(SBModel sbModel, Vector aliases, Reaction reaction) {
        NodeList children;
        boolean mustChangeCtlInh2PosNeg = false;
        Vector<ReactionLink> createdLinks = new Vector<ReactionLink>();
        String code = "";
        int policy = 0;
        String name = this.getReactionName();
        if (name.equals("")) {
            name = reaction.getName();
            if (!name.equals("")) {
                this.setReactionName(name);
            }
        } else if (reaction.getName().equals("")) {
            reaction.setName(name);
        }
        if (!this.getType().equals("BOOLEAN_LOGIC_GATE")) {
            GLinkedLineIndex lineIndex;
            String id;
            GEditPoint[] editPoints;
            int connectPolicy;
            Vector dirVec;
            Vector v;
            GLinkedLineIndex lineIndex2;
            String str_lineIndex;
            GLinkPositionInfo lpi;
            SpeciesAlias alias;
            String aliasId4;
            ReactionLink link;
            SBSymbol sb;
            Node n;
            SpeciesAlias alias2;
            SpeciesAlias alias3;
            String aliasId2;
            SpeciesReference ref;
            GLinkPositionInfo lpi2;
            SpeciesAlias alias4;
            Vector aliasIdVector;
            if ("CATALYSIS".equals(this.type)) {
                mustChangeCtlInh2PosNeg = true;
                this.setType("POSITIVE_INFLUENCE");
            } else if ("INHIBITION".equals(this.type)) {
                mustChangeCtlInh2PosNeg = true;
                this.setType("NEGATIVE_INFLUENCE");
            } else if ("UNKNOWN_CATALYSIS".equals(this.type)) {
                mustChangeCtlInh2PosNeg = true;
                this.setType("UNKNOWN_POSITIVE_INFLUENCE");
            } else if ("UNKNOWN_INHIBITION".equals(this.type)) {
                mustChangeCtlInh2PosNeg = true;
                this.setType("UNKNOWN_NEGATIVE_INFLUENCE");
            } else if (GLogicGate.isMixedNotationModificationType(this.type)) {
                mustChangeCtlInh2PosNeg = true;
            }
            SBSymbol symbol = SBFactory.createSymbol(this.getType());
            if (symbol == null) {
                return createdLinks;
            }
            Vector lineDirVec = new Vector();
            policy = this.getConnectPolicy(this.elementForReactionAnnotation, lineDirVec);
            if (symbol instanceof GLinkConnectSchemeOwner) {
                ((GLinkConnectSchemeOwner)((Object)symbol)).setConnectPolicy(policy);
            }
            this.buildEditPointsByString(this.elementForEditPoints, this.editPoints, symbol, lineDirVec);
            ReactionLink baseLink = new ReactionLink(((ReactionSymbol)((Object)symbol)).sourceSize(), ((ReactionSymbol)((Object)symbol)).destinationSize());
            try {
                baseLink.setSymbol(symbol);
            }
            catch (Exception exception) {
                // empty catch block
            }
            baseLink.setParentReaction(reaction);
            baseLink.setName(reaction.getId());
            try {
                int rectangleIndex = this.getRectangleIndex(this.elementForReactionAnnotation);
                if (symbol instanceof StateTransition) {
                    ((StateTransition)symbol).setRectangleIndex(rectangleIndex);
                }
            }
            catch (Exception rectangleIndex) {
                // empty catch block
            }
            if (this.baseReactantsElement != null) {
                Map lpiMapByAliasId = this.createLPIMapByAliasId(this.baseReactantsElement, "baseReactant");
                aliasIdVector = this.createAliasIdVector(this.baseReactantsElement, "baseReactant");
                for (String aliasId3 : aliasIdVector) {
                    alias4 = this.getSpeciesAlias(aliasId3, aliases);
                    if (alias4 != null) {
                        lpi2 = (GLinkPositionInfo)lpiMapByAliasId.get(aliasId3);
                        baseLink.addSource((GLinkTarget)alias4, lpi2);
                        continue;
                    }
                    System.out.println("[ReactionAnnotation]buildReactionLinksByDOMTreeNew()2_1,alias==null, aliasId=" + aliasId3);
                }
            } else {
                int i = 0;
                while ((long)i < reaction.getListOfReactants().size()) {
                    ref = (SpeciesReference)reaction.getListOfReactants().get((long)i);
                    aliasId2 = ((SpeciesReferenceAnnotation)LibSBMLUtil.getAnnotation(sbModel, reaction, (SBase)ref, "Reactants", i, null)).getTmpAliasId();
                    alias3 = this.getSpeciesAlias(aliasId2, aliases);
                    if (alias3 != null) {
                        baseLink.addSource((GLinkTarget)alias3, (GLinkPositionInfo)null);
                    } else {
                        System.out.println("[ReactionAnnotation]buildReactionLinksByDOMTreeNew()2_2,alias==null, aliasId=" + aliasId2);
                    }
                    ++i;
                }
            }
            if (this.baseProductsElements != null) {
                Map lpiMapByAliasId = this.createLPIMapByAliasId(this.baseProductsElements, "baseProduct");
                aliasIdVector = this.createAliasIdVector(this.baseProductsElements, "baseProduct");
                for (String aliasId3 : aliasIdVector) {
                    alias4 = this.getSpeciesAlias(aliasId3, aliases);
                    if (alias4 != null) {
                        lpi2 = (GLinkPositionInfo)lpiMapByAliasId.get(aliasId3);
                        baseLink.addDestination((GLinkTarget)alias4, lpi2);
                        continue;
                    }
                    System.out.println("[ReactionAnnotation]buildReactionLinksByDOMTreeNew()3_1,alias==null, aliasId=" + aliasId3);
                }
            } else {
                int i = 0;
                while ((long)i < reaction.getListOfProducts().size()) {
                    ref = (SpeciesReference)reaction.getListOfProducts().get((long)i);
                    aliasId2 = ((SpeciesReferenceAnnotation)LibSBMLUtil.getAnnotation(sbModel, reaction, (SBase)ref, "Products", i, null)).getTmpAliasId();
                    alias3 = this.getSpeciesAlias(aliasId2, aliases);
                    if (alias3 != null) {
                        baseLink.addDestination((GLinkTarget)alias3, (GLinkPositionInfo)null);
                    } else {
                        System.out.println("[ReactionAnnotation]buildReactionLinksByDOMTreeNew()3_2,alias==null, aliasId=" + aliasId2);
                    }
                    ++i;
                }
            }
            if (this.targetAliasId != null && !this.targetAliasId.equals("") && baseLink.targetSize() > 1 && (alias2 = this.getSpeciesAlias(this.targetAliasId, aliases)) != null) {
                int i = 0;
                while (i < baseLink.targetSize()) {
                    try {
                        GLinkTarget gelem = baseLink.getTargetAt(i);
                        if (gelem == alias2) {
                            this.oldLineIndex = i;
                            break;
                        }
                    }
                    catch (Exception gelem) {
                        // empty catch block
                    }
                    ++i;
                }
            }
            if (this.offsetX != 0.0 || this.offsetY != 0.0) {
                ((GLinkedShape)((Object)symbol)).setOffset(this.offsetX, this.offsetY);
            }
            if (symbol instanceof LinkedCreaseLineMixedNotation) {
                reaction.setReversible(false);
            }
            ((ReactionSymbol)((Object)symbol)).setReversible(reaction.getReversible());
            code = this.getType();
            if (this.lineColor != -1L) {
                ((GLinkedShape)((Object)symbol)).setColor(new Color((int)this.lineColor, true));
            } else {
                ((GLinkedShape)((Object)symbol)).setColor(ReactionColorScheme.getColor(code));
            }
            if (this.lineWidth > 0.0) {
                ((GLinkedShape)((Object)symbol)).setLineWidth(this.lineWidth);
            } else {
                ((GLinkedShape)((Object)symbol)).setLineWidth(ReactionColorScheme.getLineWidth(code));
            }
            if (symbol instanceof GLinkConnectSchemeOwner) {
                ((GLinkConnectSchemeOwner)((Object)symbol)).setConnectPolicy(policy);
            }
            this.setBaseLink(baseLink);
            createdLinks.add(baseLink);
            if (this.nodeListOfReactantLinks != null) {
                NodeList children2 = this.nodeListOfReactantLinks.getChildNodes();
                int i = 0;
                while (i < children2.getLength()) {
                    n = children2.item(i);
                    if (n.getNodeType() == 1 && n.getNamespaceURI().equals("http://www.sbml.org/2001/ns/celldesigner") && n.getLocalName().equals("reactantLink")) {
                        sb = SBFactory.createSymbol("ADD_REACTANT");
                        link = new ReactionLink(((ReactionSymbol)((Object)sb)).sourceSize(), ((ReactionSymbol)((Object)sb)).destinationSize());
                        try {
                            link.setSymbol(sb);
                        }
                        catch (Exception lpi3) {
                            // empty catch block
                        }
                        link.setParentReaction(reaction);
                        link.setName(String.valueOf(reaction.getId()) + "r" + i);
                        aliasId4 = ((Element)n).getAttributeNS(null, "alias");
                        alias = this.getSpeciesAlias(aliasId4, aliases);
                        if (alias == null) {
                            System.out.println("[ReactionAnnotation]buildReactionLinksByDOMTreeNew()reactant,alias==null, aliasId=" + aliasId4);
                        } else {
                            lpi = this.getLPIFromChildElement((Element)n);
                            link.addSource((GLinkTarget)alias, lpi);
                            str_lineIndex = ((Element)n).getAttributeNS(null, "targetLineIndex");
                            lineIndex2 = this.createLineIndex(str_lineIndex);
                            if (lineIndex2 == null) {
                                link.addDestination((GLinkTarget)baseLink, (GLinkPositionInfo)null);
                            } else {
                                link.addDestination((GLinkTarget)baseLink, lineIndex2);
                            }
                            this.lineColor = -1L;
                            this.lineWidth = -1.0;
                            v = this.getLWCFromChildElement((Element)n);
                            code = sb.getCode();
                            if (((String)v.get(0)).length() > 0) {
                                this.lineWidth = Double.parseDouble((String)v.get(0));
                                link.getGLinkedShape().setLineWidth(this.lineWidth);
                            }
                            if (((String)v.get(1)).length() > 0) {
                                this.lineColor = Long.parseLong((String)v.get(1), 16);
                                link.getGLinkedShape().setColor(new Color((int)this.lineColor, true));
                            }
                            if (this.lineColor == -1L) {
                                link.getGLinkedShape().setColor(ReactionColorScheme.getColor(code));
                            }
                            if (this.lineWidth < 0.0) {
                                link.getGLinkedShape().setLineWidth(ReactionColorScheme.getLineWidth(code));
                            }
                            link.getGLinkedShape().setLineType(ReactionAnnotation.convertReactionLinkType((String)v.get(2)));
                            dirVec = new Vector();
                            connectPolicy = this.getConnectPolicy((Element)n, dirVec);
                            ((AddReactant)link.getGLinkedShape()).setConnectPolicy(connectPolicy);
                            if (dirVec.size() > 0) {
                                ((AddReactant)link.getGLinkedShape()).setlinesDirection((Vector)dirVec.get(0));
                            }
                            editPoints = this.getEditPointsFromChildElement((Element)n);
                            ((AddReactant)link.getGLinkedShape()).setEditPoints(editPoints);
                            this.addAddReactantLink(link);
                            createdLinks.add(link);
                        }
                    }
                    ++i;
                }
            } else if (this.baseReactantsIds != null && this.baseReactantsIds.size() > 0) {
                int i = 0;
                while ((long)i < reaction.getListOfReactants().size()) {
                    SpeciesReference ref2 = (SpeciesReference)reaction.getListOfReactants().get((long)i);
                    id = ref2.getSpecies();
                    if (!this.baseReactantsIds.contains(id)) {
                        sb = SBFactory.createSymbol("ADD_REACTANT");
                        link = new ReactionLink(((ReactionSymbol)((Object)sb)).sourceSize(), ((ReactionSymbol)((Object)sb)).destinationSize());
                        try {
                            link.setSymbol(sb);
                        }
                        catch (Exception aliasId4) {
                            // empty catch block
                        }
                        link.setParentReaction(reaction);
                        link.setName(String.valueOf(reaction.getId()) + "r" + i);
                        aliasId4 = ((SpeciesReferenceAnnotation)LibSBMLUtil.getAnnotation(sbModel, reaction, (SBase)ref2, "Reactants", i, null)).getTmpAliasId();
                        alias = this.getSpeciesAlias(aliasId4, aliases);
                        if (alias == null) {
                            System.out.println("[ReactionAnnotation]buildReactionLinksByDOMTree()6,alias==null, aliasId=" + aliasId4);
                        } else {
                            link.addSource((GLinkTarget)alias, (GLinkPositionInfo)null);
                            lineIndex = this.createLineIndex("");
                            if (lineIndex == null) {
                                link.addDestination((GLinkTarget)baseLink, (GLinkPositionInfo)null);
                            } else {
                                link.addDestination((GLinkTarget)baseLink, lineIndex);
                            }
                            this.addAddReactantLink(link);
                            createdLinks.add(link);
                        }
                    }
                    ++i;
                }
            }
            if (this.nodeListOfProductLinks != null) {
                NodeList children3 = this.nodeListOfProductLinks.getChildNodes();
                int i = 0;
                while (i < children3.getLength()) {
                    n = children3.item(i);
                    if (n.getNodeType() == 1 && n.getNamespaceURI().equals("http://www.sbml.org/2001/ns/celldesigner") && n.getLocalName().equals("productLink")) {
                        sb = SBFactory.createSymbol("ADD_PRODUCT");
                        link = new ReactionLink(((ReactionSymbol)((Object)sb)).sourceSize(), ((ReactionSymbol)((Object)sb)).destinationSize());
                        try {
                            link.setSymbol(sb);
                        }
                        catch (Exception aliasId5) {
                            // empty catch block
                        }
                        link.setParentReaction(reaction);
                        link.setName(String.valueOf(reaction.getId()) + "p" + i);
                        aliasId4 = ((Element)n).getAttributeNS(null, "alias");
                        alias = this.getSpeciesAlias(aliasId4, aliases);
                        if (alias == null) {
                            System.out.println("[ReactionAnnotation]buildReactionLinksByDOMTree()product,alias==null, aliasId=" + aliasId4);
                        } else {
                            lpi = this.getLPIFromChildElement((Element)n);
                            link.addDestination((GLinkTarget)alias, lpi);
                            str_lineIndex = ((Element)n).getAttributeNS(null, "targetLineIndex");
                            lineIndex2 = this.createLineIndex(str_lineIndex);
                            if (lineIndex2 == null) {
                                link.addSource((GLinkTarget)baseLink, (GLinkPositionInfo)null);
                            } else {
                                link.addSource((GLinkTarget)baseLink, lineIndex2);
                            }
                            this.lineColor = -1L;
                            this.lineWidth = -1.0;
                            v = this.getLWCFromChildElement((Element)n);
                            code = sb.getCode();
                            if (((String)v.get(0)).length() > 0) {
                                this.lineWidth = Double.parseDouble((String)v.get(0));
                                link.getGLinkedShape().setLineWidth(this.lineWidth);
                            }
                            if (((String)v.get(1)).length() > 0) {
                                this.lineColor = Long.parseLong((String)v.get(1), 16);
                                link.getGLinkedShape().setColor(new Color((int)this.lineColor, true));
                            }
                            if (this.lineColor == -1L) {
                                link.getGLinkedShape().setColor(ReactionColorScheme.getColor(code));
                            }
                            if (this.lineWidth < 0.0) {
                                link.getGLinkedShape().setLineWidth(ReactionColorScheme.getLineWidth(code));
                            }
                            link.getGLinkedShape().setLineType(ReactionAnnotation.convertReactionLinkType((String)v.get(2)));
                            dirVec = new Vector();
                            connectPolicy = this.getConnectPolicy((Element)n, dirVec);
                            ((AddProduct)link.getGLinkedShape()).setConnectPolicy(connectPolicy);
                            if (dirVec.size() > 0) {
                                ((AddProduct)link.getGLinkedShape()).setlinesDirection((Vector)dirVec.get(0));
                            }
                            editPoints = this.getEditPointsFromChildElement((Element)n);
                            ((AddProduct)link.getGLinkedShape()).setEditPoints(editPoints);
                            this.addAddProductLink(link);
                            createdLinks.add(link);
                        }
                    }
                    ++i;
                }
            } else if (this.baseProductsIds != null && this.baseProductsIds.size() > 0) {
                int i = 0;
                while ((long)i < reaction.getListOfProducts().size()) {
                    SpeciesReference ref3 = (SpeciesReference)reaction.getListOfProducts().get((long)i);
                    id = ref3.getSpecies();
                    if (!this.baseProductsIds.contains(id)) {
                        sb = SBFactory.createSymbol("ADD_PRODUCT");
                        link = new ReactionLink(((ReactionSymbol)((Object)sb)).sourceSize(), ((ReactionSymbol)((Object)sb)).destinationSize());
                        try {
                            link.setSymbol(sb);
                        }
                        catch (Exception aliasId6) {
                            // empty catch block
                        }
                        link.setParentReaction(reaction);
                        link.setName(String.valueOf(reaction.getId()) + "p" + i);
                        aliasId4 = ((SpeciesReferenceAnnotation)LibSBMLUtil.getAnnotation(sbModel, reaction, (SBase)ref3, "Products", i, null)).getTmpAliasId();
                        alias = this.getSpeciesAlias(aliasId4, aliases);
                        if (alias == null) {
                            System.out.println("[ReactionAnnotation]buildReactionLinksByDOMTree()6,alias==null, aliasId=" + aliasId4);
                        } else {
                            link.addDestination((GLinkTarget)alias, (GLinkPositionInfo)null);
                            lineIndex = this.createLineIndex("");
                            if (lineIndex == null) {
                                link.addSource((GLinkTarget)baseLink, (GLinkPositionInfo)null);
                            } else {
                                link.addSource((GLinkTarget)baseLink, lineIndex);
                            }
                            this.addAddProductLink(link);
                            createdLinks.add(link);
                        }
                    }
                    ++i;
                }
            }
            if (this.nodeResourceOfDescriptionOfReaction != null) {
                Element elem0 = (Element)this.nodeResourceOfDescriptionOfReaction;
                Vector veRealation = new Vector();
                veRealation = LibSBMLUtil.getMiriamsFromNode(veRealation, elem0, null);
                String strId = this.baseLink.getParentReaction().getId();
                StringBuffer bufMiriam = LibSBMLUtil.getMiriamValueFromMiriams(new StringBuffer(), (SBase)this.baseLink.getParentReaction(), veRealation, true);
                XMLNode annt = XMLNode.convertStringToXMLNode((String)bufMiriam.toString());
                this.baseLink.getParentReaction().setAnnotation(annt);
                this.baseLink.getParentReaction().setAnnotation(bufMiriam.toString());
            }
        }
        if (this.nodeListOfModifications == null && this.nodeListOfBaseLinkGate == null) {
            return createdLinks;
        }
        boolean isModification = false;
        if (this.nodeListOfBaseLinkGate != null) {
            children = this.nodeListOfBaseLinkGate.getChildNodes();
        } else {
            children = this.nodeListOfModifications.getChildNodes();
            isModification = true;
        }
        int i = 0;
        while (i < children.getLength()) {
            Node n = children.item(i);
            if (n.getNodeType() == 1 && n.getNamespaceURI().equals("http://www.sbml.org/2001/ns/celldesigner") && (n.getLocalName().equals("modification") || n.getLocalName().equals("GateMember"))) {
                Element elem = (Element)n;
                Map lpiMapByAliasId = this.createLPIMapByAliasId(elem, "linkTarget");
                String mType = elem.getAttributeNS(null, strReactionType);
                if (mustChangeCtlInh2PosNeg) {
                    if ("CATALYSIS".equals(mType)) {
                        mType = "POSITIVE_INFLUENCE";
                    } else if ("INHIBITION".equals(mType)) {
                        mType = "NEGATIVE_INFLUENCE";
                    } else if ("UNKNOWN_CATALYSIS".equals(mType)) {
                        mType = "UNKNOWN_POSITIVE_INFLUENCE";
                    } else if ("UNKNOWN_INHIBITION".equals(mType)) {
                        mType = "UNKNOWN_NEGATIVE_INFLUENCE";
                    }
                }
                SBSymbol sb = SBFactory.createSymbol(mType);
                if (!isModification && sb instanceof GLogicGate) {
                    this.setType(mType);
                }
                if (sb == null) {
                    System.out.println("[ReactionAnnotation]buildReactionLinksByDOMTree()4,creageReactionSymbol==null, type=" + mType);
                } else {
                    StringTokenizer st;
                    String modifiers;
                    Vector lineDirVec1 = new Vector();
                    policy = this.getConnectPolicy(elem, lineDirVec1);
                    if (sb instanceof GLinkConnectSchemeOwner) {
                        ((GLinkConnectSchemeOwner)((Object)sb)).setConnectPolicy(policy);
                    }
                    String str_ep = elem.getAttributeNS(null, "editPoints");
                    this.buildEditPointsByString(elem, str_ep, sb, lineDirVec1);
                    ReactionLink link = new ReactionLink(((ReactionSymbol)((Object)sb)).sourceSize(), ((ReactionSymbol)((Object)sb)).destinationSize());
                    try {
                        link.setSymbol(sb);
                    }
                    catch (Exception lineIndex) {
                        // empty catch block
                    }
                    link.setParentReaction(reaction);
                    link.setName(String.valueOf(reaction.getId()) + "m" + i);
                    if (sb instanceof GLogicGate) {
                        String modificationType = elem.getAttributeNS(null, "modificationType");
                        if (!modificationType.equals("")) {
                            ((GLogicGate)sb).setModificationType(GLogicGate.getModificationTypeByString(modificationType));
                            ((GLogicGate)sb).setConnectPolicy(policy);
                            this.buildEditPointsByString(elem, str_ep, sb, lineDirVec1);
                            GLinkPositionInfo pointPointInfo = new GLinkPositionInfo(0, 0.0);
                            pointPointInfo.setElement(((GLogicGate)sb).getHeaderPoint());
                            double x = ((GLogicGate)sb).getHeaderPoint().getLocalPosition().getX();
                            double y = ((GLogicGate)sb).getHeaderPoint().getLocalPosition().getY();
                            ((GLogicGate)sb).getHeaderPoint().setPosition(new Point2D.Double(x, y));
                            try {
                                link.setTargetAt(((GLogicGate)sb).getHeaderPoint(), 0, x, y, pointPointInfo);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        modifiers = elem.getAttributeNS(null, "aliases");
                        st = new StringTokenizer(modifiers, ",");
                        int index = 0;
                        while (st.hasMoreTokens()) {
                            String id = st.nextToken();
                            SpeciesAlias alias = this.getSpeciesAlias(id, aliases);
                            ++index;
                            ((GLogicGate)sb).addSpecies(alias);
                        }
                    } else {
                        String aliasesString = elem.getAttributeNS(null, "aliases");
                        if (!aliasesString.equals("")) {
                            StringTokenizer st2 = new StringTokenizer(aliasesString, ",");
                            while (st2.hasMoreTokens()) {
                                String aliasId = st2.nextToken();
                                SpeciesAlias alias = this.getSpeciesAlias(aliasId, aliases);
                                if (alias == null) continue;
                                GLinkPositionInfo lpi = (GLinkPositionInfo)lpiMapByAliasId.get(aliasId);
                                link.addSource((GLinkTarget)alias, lpi);
                            }
                        } else {
                            modifiers = elem.getAttributeNS(null, "modifiers");
                            st = new StringTokenizer(modifiers, ",");
                            int index = 0;
                            while (st.hasMoreTokens()) {
                                String id = st.nextToken();
                                ModifierSpeciesReference ref = reaction.getModifier(id);
                                if (ref == null) continue;
                                String aliasId = ((SpeciesReferenceAnnotation)LibSBMLUtil.getAnnotation(sbModel, reaction, (SBase)ref, null, index, null)).getTmpAliasId();
                                SpeciesAlias alias = this.getSpeciesAlias(aliasId, aliases);
                                ++index;
                                if (alias == null) continue;
                                GLinkPositionInfo lpi = (GLinkPositionInfo)lpiMapByAliasId.get(aliasId);
                                link.addSource((GLinkTarget)alias, lpi);
                            }
                        }
                    }
                    boolean bAdjustGLinkedLineIndex = false;
                    String str_lineIndex = elem.getAttributeNS(null, "targetLineIndex");
                    GLinkedLineIndex lineIndex = this.createLineIndex(str_lineIndex);
                    if (lineIndex != null) {
                        if (sb instanceof GLogicGate) {
                            GLogicGate gt = (GLogicGate)sb;
                            if (!GLogicGate.isMixedNotationModificationType(this.getType()) && !GLogicGate.isMixedNotationModificationType(gt.getModificationTypeString())) {
                                bAdjustGLinkedLineIndex = true;
                            }
                        } else if (!(sb instanceof LinkedCreaseLineMixedNotation)) {
                            bAdjustGLinkedLineIndex = true;
                        }
                    }
                    if (bAdjustGLinkedLineIndex && (lineIndex.line < 0 || lineIndex.line > 7)) {
                        lineIndex.line = 0;
                    }
                    if (!isModification && sb instanceof GLogicGate) {
                        if (this.baseProductsElements != null) {
                            Map lpiMapByProductId = this.createLPIMapByAliasId(this.baseProductsElements, "baseProduct");
                            Vector aliasIdVector = this.createAliasIdVector(this.baseProductsElements, "baseProduct");
                            String aliasId = (String)aliasIdVector.get(0);
                            SpeciesAlias alias = this.getSpeciesAlias(aliasId, aliases);
                            if (alias != null) {
                                GLinkPositionInfo lpi = (GLinkPositionInfo)lpiMapByProductId.get(aliasId);
                                link.addDestination((GLinkTarget)alias, lpi);
                            }
                        }
                    } else if (lineIndex == null) {
                        link.addDestination((GLinkTarget)this.baseLink, (GLinkPositionInfo)null);
                    } else {
                        link.addDestination((GLinkTarget)this.baseLink, lineIndex);
                    }
                    String str_x = elem.getAttributeNS(null, "offsetX");
                    String str_y = elem.getAttributeNS(null, "offsetY");
                    if (!str_x.equals("") || !str_y.equals("")) {
                        try {
                            double x = Double.parseDouble(str_x);
                            double y = Double.parseDouble(str_y);
                            ((GLinkedShape)((Object)sb)).setOffset(x, y);
                        }
                        catch (Exception x) {
                            // empty catch block
                        }
                    }
                    this.lineColor = -1L;
                    this.lineWidth = -1.0;
                    Vector v = this.getLWCFromChildElement((Element)n);
                    code = sb.getCode();
                    if (((String)v.get(0)).length() > 0) {
                        this.lineWidth = Double.parseDouble((String)v.get(0));
                        link.getGLinkedShape().setLineWidth(this.lineWidth);
                    }
                    if (((String)v.get(1)).length() > 0) {
                        this.lineColor = Long.parseLong((String)v.get(1), 16);
                        link.getGLinkedShape().setColor(new Color((int)this.lineColor, true));
                    }
                    if (this.lineColor == -1L) {
                        link.getGLinkedShape().setColor(ReactionColorScheme.getColor(code));
                    }
                    if (this.lineWidth < 0.0) {
                        link.getGLinkedShape().setLineWidth(ReactionColorScheme.getLineWidth(code));
                    }
                    if (isModification) {
                        this.addModificationLink(link);
                    } else if (sb instanceof GLogicGate) {
                        this.baseLink = link;
                    }
                    createdLinks.add(link);
                }
            }
            ++i;
        }
        this.setLogicGateSubLink(createdLinks);
        return createdLinks;
    }

    private Map createLPIMapByAliasId(Element elem, String expectedName) {
        TreeMap<String, GLinkPositionInfo> map = new TreeMap<String, GLinkPositionInfo>();
        NodeList childlist = elem.getChildNodes();
        int childsize = childlist.getLength();
        int i = 0;
        while (i < childsize) {
            String aliasId;
            Element elem1;
            Node node = childlist.item(i);
            if (node.getNodeType() == 1 && node.getNamespaceURI().equals("http://www.sbml.org/2001/ns/celldesigner") && (elem1 = (Element)node).getLocalName().equals(expectedName) && (aliasId = elem1.getAttribute("alias")) != null) {
                GLinkPositionInfo lpi = this.getLPIFromChildElement(elem1);
                map.put(aliasId, lpi);
            }
            ++i;
        }
        return map;
    }

    private GLinkPositionInfo getLPIFromChildElement(Element elem) {
        NodeList childlist = elem.getChildNodes();
        int childsize = childlist.getLength();
        int i = 0;
        while (i < childsize) {
            Element elem1;
            Node node = childlist.item(i);
            if (node.getNodeType() == 1 && node.getNamespaceURI().equals("http://www.sbml.org/2001/ns/celldesigner") && (elem1 = (Element)node).getLocalName().equals("linkAnchor")) {
                String posStr;
                int pos;
                String innerId = elem1.getAttribute("innerId");
                if (innerId.length() == 0) {
                    innerId = null;
                }
                if ((pos = GLinkPosition.getIndex(posStr = elem1.getAttribute("position"))) != 16) {
                    GLinkPositionInfo lpi = new GLinkPositionInfo(pos, innerId);
                    return lpi;
                }
            }
            ++i;
        }
        return null;
    }

    private Vector createAliasIdVector(Element elem, String expectedName) {
        Vector<String> vec = new Vector<String>();
        NodeList childlist = elem.getChildNodes();
        int childsize = childlist.getLength();
        int i = 0;
        while (i < childsize) {
            String aliasId;
            Element elem1;
            Node node = childlist.item(i);
            if (node.getNodeType() == 1 && node.getNamespaceURI().equals("http://www.sbml.org/2001/ns/celldesigner") && (elem1 = (Element)node).getLocalName().equals(expectedName) && (aliasId = elem1.getAttribute("alias")) != null) {
                vec.addElement(aliasId);
            }
            ++i;
        }
        return vec;
    }

    private Vector getLWCFromChildElement(Element elem) {
        Vector<String> v = new Vector<String>();
        v.add("");
        v.add("");
        v.add("");
        NodeList childlist = elem.getChildNodes();
        int childsize = childlist.getLength();
        int i = 0;
        while (i < childsize) {
            Element elem1;
            Node node = childlist.item(i);
            if (node.getNodeType() == 1 && node.getNamespaceURI().equals("http://www.sbml.org/2001/ns/celldesigner") && (elem1 = (Element)node).getLocalName().equals("line")) {
                v.set(0, elem1.getAttributeNS(null, "width"));
                v.set(1, elem1.getAttributeNS(null, "color"));
                v.set(2, elem1.getAttributeNS(null, strReactionType));
                return v;
            }
            ++i;
        }
        return v;
    }

    private void buildEditPointsByString(Element elem, String editPointsString, SBSymbol sb, Vector lineDirVec) {
        int dir;
        GLinkedStraightLine l1;
        int i;
        int newCreasePointNum;
        StringTokenizer st1;
        if (!(sb instanceof GLinkedCreaseLine || sb instanceof GLinkedLineComplex3 || sb instanceof GLogicGate)) {
            return;
        }
        int[] num = new int[3];
        num[2] = 2;
        num[1] = 2;
        num[0] = 2;
        if (editPointsString == null) {
            st1 = null;
            newCreasePointNum = 0;
        } else {
            st1 = new StringTokenizer(editPointsString, " ");
            newCreasePointNum = st1.countTokens();
        }
        int iProcessNodeIdx = 0;
        if (sb instanceof GLinkedLineComplex3) {
            String str;
            if (elem != null && (str = elem.getAttribute("tShapeIndex")) != null) {
                try {
                    int n;
                    iProcessNodeIdx = n = Integer.parseInt(str);
                }
                catch (NumberFormatException e) {
                    iProcessNodeIdx = 0;
                }
            }
            int j = 0;
            while (j < 3) {
                String str2 = elem.getAttribute("num" + j);
                try {
                    num[j] = Integer.parseInt(str2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                ++j;
            }
            ((GLinkedLineComplex3)((Object)sb)).resetCreaseLineNumber(num[0] + 1, num[1] + 1, num[2] + 1);
            ((GLinkedLineComplex3)((Object)sb)).resetProcessNode(sb, iProcessNodeIdx);
            if (lineDirVec.size() > 0) {
                j = 0;
                while (j < 3) {
                    GLinkedCreaseLine line1 = (GLinkedCreaseLine)((GLinkedLineComplex3)((Object)sb)).getLine(j);
                    Vector v = (Vector)lineDirVec.elementAt(j);
                    int n = line1.getLineSize();
                    i = 0;
                    while (i < n) {
                        l1 = (GLinkedStraightLine)line1.getLine(i);
                        dir = (Integer)v.elementAt(i);
                        l1.setDirection(dir);
                        ++i;
                    }
                    ++j;
                }
            }
            ((GLinkedLineComplex3)((Object)sb)).setCreasePointsInitialized(true);
        } else if (sb instanceof GLinkedLine) {
            ((GLinkedCreaseLine)((Object)sb)).resetCreaseLineNumber(newCreasePointNum + 1);
            int n = ((GLinkedCreaseLine)((Object)sb)).getLineSize();
            if (lineDirVec.size() > 0) {
                Vector v = (Vector)lineDirVec.elementAt(0);
                int i2 = 0;
                while (i2 < n) {
                    GLinkedStraightLine l12 = (GLinkedStraightLine)((GLinkedCreaseLine)((Object)sb)).getLine(i2);
                    int dir2 = (Integer)v.elementAt(i2);
                    l12.setDirection(dir2);
                    ++i2;
                }
            }
            ((GLinkedCreaseLine)((Object)sb)).setCreasePointsInitialized(true);
        } else if (sb instanceof GLogicGate) {
            GLogicGate gate = (GLogicGate)sb;
            LinkedCreaseLine creaseLine = gate.getRealLine();
            creaseLine.resetCreaseLineNumber(newCreasePointNum);
            int n = creaseLine.getLineSize();
            if (lineDirVec.size() > 0) {
                Vector v = (Vector)lineDirVec.elementAt(0);
                i = 0;
                while (i < n) {
                    l1 = (GLinkedStraightLine)creaseLine.getLine(i);
                    dir = (Integer)v.elementAt(i);
                    l1.setDirection(dir);
                    ++i;
                }
            }
            creaseLine.setCreasePointsInitialized(true);
        }
        if (newCreasePointNum > 0) {
            GEditPoint[] ep = ((GEditable)((Object)sb)).getEditPoints();
            int k = 0;
            while (k < ep.length) {
                if (!st1.hasMoreTokens()) break;
                String str_pos = st1.nextToken();
                StringTokenizer st2 = new StringTokenizer(str_pos, ",");
                String str_x = st2.nextToken();
                String str_y = st2.nextToken();
                try {
                    double x = Double.parseDouble(str_x);
                    double y = Double.parseDouble(str_y);
                    Point2D.Double innerPos = new Point2D.Double(x, y);
                    ep[k].setLocalPosition(innerPos);
                    ep[k].setPosition(new Point2D.Double());
                    if (sb instanceof GLogicGate && ep[k] == ((GLogicGate)sb).getHeaderPoint()) {
                        ((GLogicGate)sb).setStartPoint(innerPos);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                ++k;
            }
        }
    }

    private SpeciesAlias getSpeciesAlias(String aliasId, Vector aliases) {
        SpeciesAlias alias = null;
        int j = 0;
        while (j < aliases.size()) {
            SpeciesAlias a = (SpeciesAlias)aliases.elementAt(j);
            if (a.getName().equals(aliasId)) {
                alias = a;
                break;
            }
            ++j;
        }
        return alias;
    }

    private GLinkedLineIndex createLineIndex(String str_lineIndex) {
        GLinkedLineIndex rtn = null;
        if (!str_lineIndex.equals("")) {
            rtn = new GLinkedLineIndex();
            rtn.arm = -1;
            rtn.line = -1;
            try {
                StringTokenizer st = new StringTokenizer(str_lineIndex, ",");
                String str_arm = st.nextToken();
                String str_line = st.nextToken();
                rtn.arm = Integer.parseInt(str_arm);
                rtn.line = Integer.parseInt(str_line);
            }
            catch (Exception exception) {}
        } else if (this.oldLineIndex > -1) {
            rtn = new GLinkedLineIndex();
            rtn.arm = this.oldLineIndex;
            rtn.line = -1;
        }
        return rtn;
    }

    private String concatSpeciesIdString(Vector speciesVec) {
        StringBuffer buf = new StringBuffer();
        int j = 0;
        while (j < speciesVec.size()) {
            if (j > 0) {
                buf.append(',');
            }
            SpeciesAlias alias = (SpeciesAlias)speciesVec.elementAt(j);
            String speciesId = alias.getOriginalSpecies().getId();
            buf.append(speciesId);
            ++j;
        }
        return buf.toString();
    }

    private void setElementForLinkPositionInfo(String uri, String ns, Document doc, Element elem, GLinkPositionInfo lpi) {
        if (lpi != null) {
            Element elem1 = doc.createElementNS(uri, String.valueOf(ns) + ":linkAnchor");
            elem.appendChild(elem1);
            String innerId = lpi.getInnerIdForLink();
            if (!innerId.equals("")) {
                elem1.setAttribute("innerId", innerId);
            }
            elem1.setAttribute("position", lpi.getPositionStringForLink());
        }
    }

    private void setElementsWithLinkPositionInfo(String uri, String ns, Document doc, Element elem, Vector sources, Vector sourcesLpi, String string) {
        int j = 0;
        while (j < sources.size()) {
            Element elem1 = doc.createElementNS(uri, String.valueOf(ns) + string);
            elem.appendChild(elem1);
            SpeciesAlias alias = (SpeciesAlias)sources.elementAt(j);
            String speciesId = alias.getOriginalSpecies().getId();
            elem1.setAttribute("species", speciesId);
            elem1.setAttribute("alias", alias.getName());
            GLinkPositionInfo lpi = (GLinkPositionInfo)sourcesLpi.elementAt(j);
            this.setElementForLinkPositionInfo(uri, ns, doc, elem1, lpi);
            ++j;
        }
    }

    private void setElementForLineWidthColor(String uri, String ns, Document doc, Element elem, double width, Color color) {
        Element elem1 = doc.createElementNS(uri, String.valueOf(ns) + ":line");
        elem.appendChild(elem1);
        elem1.setAttributeNS(null, "width", Double.toString(width));
        elem1.setAttributeNS(null, "color", Integer.toHexString(color.getRGB()));
    }

    private void addElementForLineDirectionForConnectScheme(String uri, String ns, Document doc, Element elem2, int arm, GLinkedCreaseLine line) {
        int n = line.getLineSize();
        int i = 0;
        while (i < n) {
            String str;
            GLinkedStraightLine l1 = (GLinkedStraightLine)line.getLine(i);
            switch (l1.getDirection()) {
                case 2: {
                    str = LINE_DIRECTION_HORIZONTAL_STR;
                    break;
                }
                case 1: {
                    str = LINE_DIRECTION_VERTICAL_STR;
                    break;
                }
                default: {
                    str = "unknown";
                }
            }
            Element elem3 = doc.createElementNS(uri, String.valueOf(ns) + ":" + LINE_DIRECTION_STR);
            elem2.appendChild(elem3);
            if (arm >= 0) {
                elem3.setAttribute(ARM_ATTR_STR, "" + arm);
            }
            elem3.setAttribute(INDEX_ATTR_STR, "" + i);
            elem3.setAttribute(VALUE_ATTR_STR, str);
            ++i;
        }
    }

    private void addElementForConnectScheme(String uri, String ns, Document doc, Element elem, GLinkConnectSchemeOwner owner) {
        Element elem1 = doc.createElementNS(uri, String.valueOf(ns) + ":" + CONNECT_SCHEME_STR);
        elem.appendChild(elem1);
        int policy = owner.getConnectPolicy();
        if (policy == 1) {
            elem1.setAttribute(CONNECT_POLICY_STR, CONNECT_POLICY_SQUARE_STR);
        } else {
            elem1.setAttribute(CONNECT_POLICY_STR, CONNECT_POLICY_DIRECT_STR);
        }
        if (owner instanceof GLinkedCreaseLine) {
            Element elem2 = doc.createElementNS(uri, String.valueOf(ns) + ":" + LISTOF_LINE_DIRECTION_STR);
            elem1.appendChild(elem2);
            int arm = -1;
            this.addElementForLineDirectionForConnectScheme(uri, ns, doc, elem2, arm, (GLinkedCreaseLine)owner);
        } else if (owner instanceof GLinkedLineComplex3) {
            Element elem2 = doc.createElementNS(uri, String.valueOf(ns) + ":" + LISTOF_LINE_DIRECTION_STR);
            elem1.appendChild(elem2);
            int arm = 0;
            while (arm < 3) {
                GLinkedCreaseLine line1 = (GLinkedCreaseLine)((GLinkedLineComplex3)owner).getLine(arm);
                this.addElementForLineDirectionForConnectScheme(uri, ns, doc, elem2, arm, line1);
                ++arm;
            }
        }
    }

    @Override
    public void writeDOMTree(Node node) {
        GEditPoint[] ep;
        GLinkedShape linkedShape;
        GLinkPositionInfo lpi;
        GLinkedLineIndex lineIndex;
        Element elem;
        String aliasId;
        String speciesId;
        SpeciesAlias alias;
        GLinkedLine gline;
        ReactionLink link;
        Element listelem;
        Element elem2;
        Element elem3;
        Element elem4;
        Document doc = node.getOwnerDocument();
        String URI2 = node.getNamespaceURI();
        String ns = ModelAnnotation.getOutputNamespace();
        if (!this.reactionName.equals("")) {
            elem4 = doc.createElementNS(URI2, String.valueOf(ns) + ":name");
            node.appendChild(elem4);
            elem4.appendChild(doc.createTextNode(this.reactionName));
        }
        if (!(this.type.equals("") || this.type.equals("(no specified)") || this.type.equals(""))) {
            elem4 = doc.createElementNS(URI2, String.valueOf(ns) + ":reactionType");
            node.appendChild(elem4);
            elem4.appendChild(doc.createTextNode(this.type));
        }
        if (this.baseLink != null) {
            Vector sources = this.baseLink.getSources();
            Vector sourcesLpi = this.baseLink.getSourcesLinkPositionInfo();
            if (sources.size() > 0) {
                elem3 = doc.createElementNS(URI2, String.valueOf(ns) + ":baseReactants");
                node.appendChild(elem3);
                this.setElementsWithLinkPositionInfo(URI2, ns, doc, elem3, sources, sourcesLpi, ":baseReactant");
            }
            Vector dists = this.baseLink.getDistinations();
            Vector distsLpi = this.baseLink.getDistinationsLinkPositionInfo();
            if (dists.size() > 0) {
                elem2 = doc.createElementNS(URI2, String.valueOf(ns) + ":baseProducts");
                node.appendChild(elem2);
                this.setElementsWithLinkPositionInfo(URI2, ns, doc, elem2, dists, distsLpi, ":baseProduct");
            }
        }
        if (this.addReactantLinks.size() > 0) {
            listelem = doc.createElementNS(URI2, String.valueOf(ns) + ":listOfReactantLinks");
            node.appendChild(listelem);
            int i = 0;
            while (i < this.addReactantLinks.size()) {
                link = (ReactionLink)this.addReactantLinks.elementAt(i);
                gline = (GLinkedLine)((Object)link.getSymbol());
                alias = (SpeciesAlias)gline.getStartTarget();
                speciesId = alias.getOriginalSpecies().getId();
                aliasId = alias.getName();
                elem = doc.createElementNS(URI2, String.valueOf(ns) + ":reactantLink");
                listelem.appendChild(elem);
                elem.setAttributeNS(null, "reactant", speciesId);
                elem.setAttributeNS(null, "alias", aliasId);
                lineIndex = gline.getEndLineIndex();
                if (lineIndex != null) {
                    elem.setAttributeNS(null, "targetLineIndex", String.valueOf(lineIndex.arm) + "," + lineIndex.line);
                }
                lpi = gline.getStartLinkPositionInfo();
                this.setElementForLinkPositionInfo(URI2, ns, doc, elem, lpi);
                this.setElementForLineWidthColor(URI2, ns, doc, elem, gline.getLineWidth(), gline.getColor());
                ++i;
            }
        }
        if (this.addProductLinks.size() > 0) {
            listelem = doc.createElementNS(URI2, String.valueOf(ns) + ":listOfProductLinks");
            node.appendChild(listelem);
            int i = 0;
            while (i < this.addProductLinks.size()) {
                link = (ReactionLink)this.addProductLinks.elementAt(i);
                gline = (GLinkedLine)((Object)link.getSymbol());
                alias = (SpeciesAlias)gline.getEndTarget();
                speciesId = alias.getOriginalSpecies().getId();
                aliasId = alias.getName();
                elem = doc.createElementNS(URI2, String.valueOf(ns) + ":productLink");
                listelem.appendChild(elem);
                elem.setAttributeNS(null, "product", speciesId);
                elem.setAttributeNS(null, "alias", aliasId);
                lineIndex = gline.getStartLineIndex();
                if (lineIndex != null) {
                    elem.setAttributeNS(null, "targetLineIndex", String.valueOf(lineIndex.arm) + "," + lineIndex.line);
                }
                lpi = gline.getEndLinkPositionInfo();
                this.setElementForLinkPositionInfo(URI2, ns, doc, elem, lpi);
                this.setElementForLineWidthColor(URI2, ns, doc, elem, gline.getLineWidth(), gline.getColor());
                ++i;
            }
        }
        if ((linkedShape = (GLinkedShape)((Object)this.baseLink.getSymbol())) instanceof GLinkConnectSchemeOwner) {
            this.addElementForConnectScheme(URI2, ns, doc, (Element)node, (GLinkConnectSchemeOwner)((Object)linkedShape));
        }
        Point2D.Double offset = linkedShape.getOffset();
        if (offset.x != 0.0 || offset.y != 0.0) {
            elem3 = doc.createElementNS(URI2, String.valueOf(ns) + ":offset");
            node.appendChild(elem3);
            elem3.setAttributeNS(null, "x", Double.toString(offset.x));
            elem3.setAttributeNS(null, "y", Double.toString(offset.y));
        }
        if (linkedShape instanceof GEditable && (ep = ((GEditable)((Object)linkedShape)).getEditPoints()).length > 0) {
            String epStr = "";
            int k = 0;
            while (k < ep.length) {
                Point2D.Double innerPos = ep[k].getLocalPosition();
                if (k > 0) {
                    epStr = String.valueOf(epStr) + " ";
                }
                epStr = String.valueOf(epStr) + innerPos.x + "," + innerPos.y;
                ++k;
            }
            elem2 = doc.createElementNS(URI2, String.valueOf(ns) + ":editPoints");
            if (linkedShape instanceof GLinkedLineComplex3) {
                int i = 0;
                while (i < 3) {
                    GLinkedCreaseLine line1 = (GLinkedCreaseLine)((GLinkedLineComplex3)linkedShape).getLine(i);
                    int num = line1.getCreasePointsSize();
                    elem2.setAttribute("num" + i, "" + num);
                    ++i;
                }
                if (linkedShape instanceof GLinkedLineComplex3) {
                    int num = ((GLinkedLineComplex3)linkedShape).getProcessNodeIndex();
                    elem2.setAttribute("tShapeIndex", "" + num);
                }
            } else if (linkedShape instanceof KnownTransitionOmitted) {
                int num = ((KnownTransitionOmitted)linkedShape).getOmittedShapeIndex();
                elem2.setAttribute("omittedShapeIndex", "" + num);
            }
            node.appendChild(elem2);
            elem2.appendChild(doc.createTextNode(epStr));
        }
        double lw = linkedShape.getLineWidth();
        Color color = linkedShape.getColor();
        Element elem5 = doc.createElementNS(URI2, String.valueOf(ns) + ":line");
        node.appendChild(elem5);
        elem5.setAttributeNS(null, "width", Double.toString(lw));
        elem5.setAttributeNS(null, "color", Integer.toHexString(color.getRGB()));
        if (this.modificationLinks.size() > 0) {
            Element listelem2 = doc.createElementNS(URI2, String.valueOf(ns) + ":listOfModification");
            node.appendChild(listelem2);
            int i = 0;
            while (i < this.modificationLinks.size()) {
                GEditPoint[] ep2;
                GLinkTarget lt;
                ReactionLink link2 = (ReactionLink)this.modificationLinks.elementAt(i);
                elem5 = doc.createElementNS(URI2, String.valueOf(ns) + ":modification");
                listelem2.appendChild(elem5);
                elem5.setAttributeNS(null, strReactionType, link2.getSymbol().getCode());
                String s_str = "";
                String a_str = "";
                Vector sources = link2.getSources();
                int j = 0;
                while (j < sources.size()) {
                    if (j > 0) {
                        s_str = String.valueOf(s_str) + ",";
                        a_str = String.valueOf(a_str) + ",";
                    }
                    SpeciesAlias alias2 = (SpeciesAlias)sources.elementAt(j);
                    String speciesId2 = alias2.getOriginalSpecies().getId();
                    s_str = String.valueOf(s_str) + speciesId2;
                    a_str = String.valueOf(a_str) + alias2.getName();
                    ++j;
                }
                elem5.setAttributeNS(null, "modifiers", s_str);
                elem5.setAttributeNS(null, "aliases", a_str);
                GLinkedShape shape = (GLinkedShape)((Object)link2.getSymbol());
                if (shape instanceof GLinkConnectSchemeOwner) {
                    this.addElementForConnectScheme(URI2, ns, doc, elem5, (GLinkConnectSchemeOwner)((Object)shape));
                }
                offset = shape.getOffset();
                if (offset.x != 0.0 || offset.y != 0.0) {
                    elem5.setAttributeNS(null, "offsetX", Double.toString(offset.x));
                    elem5.setAttributeNS(null, "offsetY", Double.toString(offset.y));
                }
                if (shape instanceof GLinkedLine) {
                    GLinkPositionInfo lpi2;
                    GLinkedLineIndex lineIndex2 = ((GLinkedLine)shape).getEndLineIndex();
                    if (lineIndex2 != null) {
                        elem5.setAttributeNS(null, "targetLineIndex", String.valueOf(lineIndex2.arm) + "," + lineIndex2.line);
                    }
                    if ((lpi2 = ((GLinkedLine)shape).getStartLinkPositionInfo()) != null) {
                        Vector<GLinkTarget> speciesVec = new Vector<GLinkTarget>(1);
                        Vector<GLinkPositionInfo> lpiVec = new Vector<GLinkPositionInfo>(1);
                        lt = ((GLinkedLine)shape).getStartTarget();
                        if (lt instanceof SpeciesAlias) {
                            speciesVec.addElement(lt);
                            lpiVec.addElement(lpi2);
                        }
                        this.setElementsWithLinkPositionInfo(URI2, ns, doc, elem5, speciesVec, lpiVec, ":linkTarget");
                    }
                }
                if (shape instanceof GLinkedLineComplex3) {
                    GLinkPositionInfo lpi3;
                    GLinkedLineIndex lineIndex3;
                    GLinkedLine gline2 = ((GLinkedLineComplex3)shape).getLine(2);
                    if (gline2 != null && (lineIndex3 = gline2.getEndLineIndex()) != null) {
                        elem5.setAttributeNS(null, "targetLineIndex", String.valueOf(lineIndex3.arm) + "," + lineIndex3.line);
                    }
                    Vector<GLinkTarget> speciesVec = new Vector<GLinkTarget>(2);
                    Vector<GLinkPositionInfo> lpiVec = new Vector<GLinkPositionInfo>(2);
                    gline2 = ((GLinkedLineComplex3)shape).getLine(0);
                    if (gline2 != null && (lpi3 = gline2.getEndLinkPositionInfo()) != null && (lt = gline2.getEndTarget()) instanceof SpeciesAlias) {
                        speciesVec.addElement(lt);
                        lpiVec.addElement(lpi3);
                    }
                    if ((gline2 = ((GLinkedLineComplex3)shape).getLine(1)) != null && (lpi3 = gline2.getEndLinkPositionInfo()) != null && (lt = gline2.getEndTarget()) instanceof SpeciesAlias) {
                        speciesVec.addElement(lt);
                        lpiVec.addElement(lpi3);
                    }
                    this.setElementsWithLinkPositionInfo(URI2, ns, doc, elem5, speciesVec, lpiVec, ":linkTarget");
                    int j2 = 0;
                    while (j2 < 3) {
                        GLinkedCreaseLine line1 = (GLinkedCreaseLine)((GLinkedLineComplex3)shape).getLine(j2);
                        int num = line1.getCreasePointsSize();
                        elem5.setAttribute("num" + j2, "" + num);
                        ++j2;
                    }
                }
                if (shape instanceof GEditable && (ep2 = ((GEditable)((Object)shape)).getEditPoints()).length > 0) {
                    String ep_Str = "";
                    int k = 0;
                    while (k < ep2.length) {
                        Point2D.Double innerPos = ep2[k].getLocalPosition();
                        if (k > 0) {
                            ep_Str = String.valueOf(ep_Str) + " ";
                        }
                        ep_Str = String.valueOf(ep_Str) + innerPos.x + "," + innerPos.y;
                        ++k;
                    }
                    elem5.setAttributeNS(null, "editPoints", ep_Str);
                }
                if (shape instanceof GLinkedLine || shape instanceof GLinkedLineComplex3) {
                    double lw2 = shape.getLineWidth();
                    Color color2 = shape.getColor();
                    Element elem_wc = doc.createElementNS(URI2, String.valueOf(ns) + ":line");
                    elem5.appendChild(elem_wc);
                    elem_wc.setAttributeNS(null, "width", Double.toString(lw2));
                    elem_wc.setAttributeNS(null, "color", Integer.toHexString(color2.getRGB()));
                }
                ++i;
            }
        }
    }

    @Override
    public void releaseAllMembers() {
        this.modificationLinks.clear();
        this.modificationLinks = null;
        this.baseLink = null;
    }

    public List getModificationLinks() {
        return Collections.unmodifiableList(this.modificationLinks);
    }

    public List getAddReactantLinks() {
        return Collections.unmodifiableList(this.addReactantLinks);
    }

    public List getAddProductLinks() {
        return Collections.unmodifiableList(this.addProductLinks);
    }

    @Override
    public void setParentSBase(SBase sbase) {
    }

    public void updateAnnotation(Reaction reaction, XMLNamespaces anntXmlNS) {
        GEditPoint[] ep;
        GLinkedShape linkedShape;
        Point2D.Double innerPos;
        int k;
        String epStr;
        GEditPoint[] ep2;
        String str;
        int n;
        int policy;
        GLinkedLineIndex lineIndex;
        String aliasId;
        GLinkedLine gline;
        ReactionLink link;
        String innerId;
        GLinkPositionInfo lpi;
        String speciesId;
        SpeciesAlias alias;
        boolean bBaseLinkGate;
        Vector vecData = LibSBMLUtil.getMiriamDatasFromAnnotationOfSBase((SBase)reaction);
        StringBuffer buf = new StringBuffer();
        buf.append("<annotation xmlns:celldesigner=\"http://www.sbml.org/2001/ns/celldesigner\">\n");
        buf.append("<celldesigner:extension>");
        if (!this.reactionName.equals("")) {
            buf.append("<celldesigner:name>" + StringTool.toEscape(this.reactionName) + "</celldesigner:" + "name>\n");
        }
        boolean bl = bBaseLinkGate = this.baseLink != null && this.baseLink.isBaseLinkGate();
        if (bBaseLinkGate) {
            buf.append("<celldesigner:reactionType>BOOLEAN_LOGIC_GATE</celldesigner:reactionType>\n");
        } else if (!(this.type.equals("") || this.type.equals("(no specified)") || this.type.equals(""))) {
            buf.append("<celldesigner:reactionType>" + this.type + "</celldesigner:" + "reactionType>\n");
        }
        if (this.baseLink != null) {
            Vector sources = this.baseLink.getSources();
            Vector sourcesLpi = this.baseLink.getSourcesLinkPositionInfo();
            if (bBaseLinkGate) {
                sources = this.baseLink.getBaseLinkGateSource();
            }
            if (sources.size() > 0) {
                buf.append("<celldesigner:baseReactants>\n");
                int j = 0;
                while (j < sources.size()) {
                    alias = (SpeciesAlias)sources.elementAt(j);
                    speciesId = alias.getOriginalSpecies().getId();
                    buf.append("<celldesigner:baseReactant species=\"" + speciesId + "\" alias=\"" + alias.getName() + "\"");
                    if (!bBaseLinkGate) {
                        GLinkPositionInfo lpi2 = (GLinkPositionInfo)sourcesLpi.elementAt(j);
                        if (lpi2 != null) {
                            buf.append(">\n");
                            buf.append("<celldesigner:linkAnchor ");
                            String innerId2 = lpi2.getInnerIdForLink();
                            if (!innerId2.equals("")) {
                                buf.append("innerId=\"" + innerId2 + "\" ");
                            }
                            buf.append("position=\"" + lpi2.getPositionStringForLink() + "\"/>\n");
                            buf.append("</celldesigner:baseReactant>\n");
                        } else {
                            buf.append("/>\n");
                        }
                    } else {
                        buf.append("/>\n");
                    }
                    ++j;
                }
                buf.append("</celldesigner:baseReactants>\n");
            }
            Vector dists = this.baseLink.getDistinations();
            Vector distsLpi = this.baseLink.getDistinationsLinkPositionInfo();
            if (dists.size() > 0) {
                buf.append("<celldesigner:baseProducts>\n");
                int j = 0;
                while (j < dists.size()) {
                    SpeciesAlias alias2 = (SpeciesAlias)dists.elementAt(j);
                    String speciesId2 = alias2.getOriginalSpecies().getId();
                    buf.append("<celldesigner:baseProduct species=\"" + speciesId2 + "\" alias=\"" + alias2.getName() + "\"");
                    lpi = (GLinkPositionInfo)distsLpi.elementAt(j);
                    if (lpi != null) {
                        buf.append(">\n");
                        buf.append("<celldesigner:linkAnchor ");
                        innerId = lpi.getInnerIdForLink();
                        if (!innerId.equals("")) {
                            buf.append("innerId=\"" + innerId + "\" ");
                        }
                        buf.append("position=\"" + lpi.getPositionStringForLink() + "\"/>\n");
                        buf.append("</celldesigner:baseProduct>\n");
                    } else {
                        buf.append("/>\n");
                    }
                    ++j;
                }
                buf.append("</celldesigner:baseProducts>\n");
            }
        }
        if (this.addReactantLinks.size() > 0) {
            buf.append("<celldesigner:listOfReactantLinks>\n");
            int i = 0;
            while (i < this.addReactantLinks.size()) {
                link = (ReactionLink)this.addReactantLinks.elementAt(i);
                gline = (GLinkedLine)((Object)link.getSymbol());
                alias = (SpeciesAlias)gline.getStartTarget();
                speciesId = alias.getOriginalSpecies().getId();
                aliasId = alias.getName();
                buf.append("<celldesigner:reactantLink reactant=\"" + speciesId + "\" alias=\"" + aliasId + "\"");
                lineIndex = gline.getEndLineIndex();
                if (lineIndex != null) {
                    buf.append(" targetLineIndex=\"" + lineIndex.arm + "," + lineIndex.line + "\">\n");
                } else {
                    buf.append(">\n");
                }
                lpi = gline.getStartLinkPositionInfo();
                if (lpi != null) {
                    buf.append("<celldesigner:linkAnchor ");
                    innerId = lpi.getInnerIdForLink();
                    if (!innerId.equals("")) {
                        buf.append("innerId=\"" + innerId + "\" ");
                    }
                    buf.append("position=\"" + lpi.getPositionStringForLink() + "\"/>\n");
                }
                AddReactant reactant = (AddReactant)gline;
                buf.append("<celldesigner:" + CONNECT_SCHEME_STR + " ");
                policy = reactant.getConnectPolicy();
                if (policy == 1) {
                    buf.append(String.valueOf(CONNECT_POLICY_STR) + "=\"" + CONNECT_POLICY_SQUARE_STR + "\" ");
                } else {
                    buf.append(String.valueOf(CONNECT_POLICY_STR) + "=\"" + CONNECT_POLICY_DIRECT_STR + "\" ");
                }
                buf.append(">\n");
                buf.append("<celldesigner:listOfLineDirection>\n");
                n = reactant.getLines().size();
                int j = 0;
                while (j < n) {
                    switch (reactant.getLineDirectionAt(j)) {
                        case 2: {
                            str = LINE_DIRECTION_HORIZONTAL_STR;
                            break;
                        }
                        case 1: {
                            str = LINE_DIRECTION_VERTICAL_STR;
                            break;
                        }
                        default: {
                            str = "unknown";
                        }
                    }
                    buf.append("<celldesigner:lineDirection");
                    buf.append(" index=\"" + j + "\" " + VALUE_ATTR_STR + "=\"" + str + "\"/>\n");
                    ++j;
                }
                buf.append("</celldesigner:listOfLineDirection>\n");
                buf.append("</celldesigner:" + CONNECT_SCHEME_STR + ">\n");
                ep2 = reactant.getEditPoints();
                if (ep2.length > 0) {
                    epStr = "";
                    k = 0;
                    while (k < ep2.length) {
                        innerPos = ep2[k].getLocalPosition();
                        if (k > 0) {
                            epStr = String.valueOf(epStr) + " ";
                        }
                        epStr = String.valueOf(epStr) + innerPos.x + "," + innerPos.y;
                        ++k;
                    }
                    buf.append("<celldesigner:editPoints");
                    buf.append(">");
                    buf.append(epStr);
                    buf.append("</celldesigner:editPoints>\n");
                }
                buf.append("<celldesigner:line width=\"" + gline.getLineWidth() + "\" color=\"" + Integer.toHexString(gline.getColor().getRGB()) + "\" type=\"" + ReactionAnnotation.convertReactionLinkType(gline.getLineType()) + "\"/>\n");
                buf.append("</celldesigner:reactantLink>\n");
                ++i;
            }
            buf.append("</celldesigner:listOfReactantLinks>\n");
        }
        if (this.addProductLinks.size() > 0) {
            buf.append("<celldesigner:listOfProductLinks>\n");
            int i = 0;
            while (i < this.addProductLinks.size()) {
                link = (ReactionLink)this.addProductLinks.elementAt(i);
                gline = (GLinkedLine)((Object)link.getSymbol());
                alias = (SpeciesAlias)gline.getEndTarget();
                speciesId = alias.getOriginalSpecies().getId();
                aliasId = alias.getName();
                buf.append("<celldesigner:productLink product=\"" + speciesId + "\" alias=\"" + aliasId + "\"");
                lineIndex = gline.getStartLineIndex();
                if (lineIndex != null) {
                    buf.append(" targetLineIndex=\"" + lineIndex.arm + "," + lineIndex.line + "\">\n");
                } else {
                    buf.append(">\n");
                }
                lpi = gline.getEndLinkPositionInfo();
                if (lpi != null) {
                    buf.append("<celldesigner:linkAnchor ");
                    innerId = lpi.getInnerIdForLink();
                    if (!innerId.equals("")) {
                        buf.append("innerId=\"" + innerId + "\" ");
                    }
                    buf.append("position=\"" + lpi.getPositionStringForLink() + "\"/>\n");
                }
                AddProduct product = (AddProduct)gline;
                buf.append("<celldesigner:" + CONNECT_SCHEME_STR + " ");
                policy = product.getConnectPolicy();
                if (policy == 1) {
                    buf.append(String.valueOf(CONNECT_POLICY_STR) + "=\"" + CONNECT_POLICY_SQUARE_STR + "\" ");
                } else {
                    buf.append(String.valueOf(CONNECT_POLICY_STR) + "=\"" + CONNECT_POLICY_DIRECT_STR + "\" ");
                }
                buf.append(">\n");
                buf.append("<celldesigner:listOfLineDirection>\n");
                n = product.getLines().size();
                int j = 0;
                while (j < n) {
                    switch (product.getLineDirectionAt(j)) {
                        case 2: {
                            str = LINE_DIRECTION_HORIZONTAL_STR;
                            break;
                        }
                        case 1: {
                            str = LINE_DIRECTION_VERTICAL_STR;
                            break;
                        }
                        default: {
                            str = "unknown";
                        }
                    }
                    buf.append("<celldesigner:lineDirection");
                    buf.append(" index=\"" + j + "\" " + VALUE_ATTR_STR + "=\"" + str + "\"/>\n");
                    ++j;
                }
                buf.append("</celldesigner:listOfLineDirection>\n");
                buf.append("</celldesigner:" + CONNECT_SCHEME_STR + ">\n");
                ep2 = product.getEditPoints();
                if (ep2.length > 0) {
                    epStr = "";
                    k = 0;
                    while (k < ep2.length) {
                        innerPos = ep2[k].getLocalPosition();
                        if (k > 0) {
                            epStr = String.valueOf(epStr) + " ";
                        }
                        epStr = String.valueOf(epStr) + innerPos.x + "," + innerPos.y;
                        ++k;
                    }
                    buf.append("<celldesigner:editPoints");
                    buf.append(">");
                    buf.append(epStr);
                    buf.append("</celldesigner:editPoints>\n");
                }
                buf.append("<celldesigner:line width=\"" + gline.getLineWidth() + "\" color=\"" + Integer.toHexString(gline.getColor().getRGB()) + "\" type=\"" + ReactionAnnotation.convertReactionLinkType(gline.getLineType()) + "\"/>\n");
                buf.append("</celldesigner:productLink>\n");
                ++i;
            }
            buf.append("</celldesigner:listOfProductLinks>\n");
        }
        if ((linkedShape = (GLinkedShape)((Object)this.baseLink.getSymbol())) instanceof GLinkConnectSchemeOwner) {
            String str2;
            GLinkedStraightLine l1;
            GLinkedCreaseLine line;
            buf.append("<celldesigner:" + CONNECT_SCHEME_STR + " ");
            GLinkConnectSchemeOwner owner = (GLinkConnectSchemeOwner)((Object)linkedShape);
            int policy2 = owner.getConnectPolicy();
            if (policy2 == 1) {
                buf.append(String.valueOf(CONNECT_POLICY_STR) + "=\"" + CONNECT_POLICY_SQUARE_STR + "\" ");
            } else {
                buf.append(String.valueOf(CONNECT_POLICY_STR) + "=\"" + CONNECT_POLICY_DIRECT_STR + "\" ");
            }
            if (linkedShape instanceof StateTransition) {
                StateTransition st = (StateTransition)linkedShape;
                buf.append(String.valueOf(RectangleIndexString) + "=\"" + st.getOmittedShapeIndex() + "\"");
            }
            buf.append(">\n");
            if (owner instanceof GLinkedCreaseLine) {
                buf.append("<celldesigner:listOfLineDirection>\n");
                int arm = -1;
                line = (GLinkedCreaseLine)owner;
                int n2 = line.getLineSize();
                int i = 0;
                while (i < n2) {
                    l1 = (GLinkedStraightLine)line.getLine(i);
                    switch (l1.getDirection()) {
                        case 2: {
                            str2 = LINE_DIRECTION_HORIZONTAL_STR;
                            break;
                        }
                        case 1: {
                            str2 = LINE_DIRECTION_VERTICAL_STR;
                            break;
                        }
                        default: {
                            str2 = "unknown";
                        }
                    }
                    buf.append("<celldesigner:lineDirection");
                    if (arm >= 0) {
                        buf.append(" arm=\"" + arm + "\"");
                    }
                    buf.append(" index=\"" + i + "\" " + VALUE_ATTR_STR + "=\"" + str2 + "\"/>\n");
                    ++i;
                }
                buf.append("</celldesigner:listOfLineDirection>\n");
            } else if (owner instanceof GLinkedLineComplex3) {
                buf.append("<celldesigner:listOfLineDirection>\n");
                int arm = 0;
                while (arm < 3) {
                    line = (GLinkedCreaseLine)((GLinkedLineComplex3)owner).getLine(arm);
                    int n3 = line.getLineSize();
                    int i = 0;
                    while (i < n3) {
                        l1 = (GLinkedStraightLine)line.getLine(i);
                        switch (l1.getDirection()) {
                            case 2: {
                                str2 = LINE_DIRECTION_HORIZONTAL_STR;
                                break;
                            }
                            case 1: {
                                str2 = LINE_DIRECTION_VERTICAL_STR;
                                break;
                            }
                            default: {
                                str2 = "unknown";
                            }
                        }
                        buf.append("<celldesigner:lineDirection");
                        if (arm >= 0) {
                            buf.append(" arm=\"" + arm + "\"");
                        }
                        buf.append(" index=\"" + i + "\" " + VALUE_ATTR_STR + "=\"" + str2 + "\"/>\n");
                        ++i;
                    }
                    ++arm;
                }
                buf.append("</celldesigner:listOfLineDirection>\n");
            }
            buf.append("</celldesigner:" + CONNECT_SCHEME_STR + ">\n");
        }
        Point2D.Double offset = linkedShape.getOffset();
        if (offset.x != 0.0 || offset.y != 0.0) {
            buf.append("<celldesigner:offset x=\"" + offset.x + "\" y=\"" + offset.y + "\"/>\n");
        }
        if (linkedShape instanceof GEditable && (ep = ((GEditable)((Object)linkedShape)).getEditPoints()).length > 0) {
            int num;
            String epStr2 = "";
            int k2 = 0;
            while (k2 < ep.length) {
                Point2D.Double innerPos2 = ep[k2].getLocalPosition();
                if (k2 > 0) {
                    epStr2 = String.valueOf(epStr2) + " ";
                }
                epStr2 = String.valueOf(epStr2) + innerPos2.x + "," + innerPos2.y;
                ++k2;
            }
            buf.append("<celldesigner:editPoints");
            if (linkedShape instanceof GLinkedLineComplex3) {
                int i = 0;
                while (i < 3) {
                    GLinkedCreaseLine line1 = (GLinkedCreaseLine)((GLinkedLineComplex3)linkedShape).getLine(i);
                    int num2 = line1.getCreasePointsSize();
                    buf.append(" num" + i + "=\"" + num2 + "\"");
                    ++i;
                }
                if (linkedShape instanceof GLinkedLineComplex3) {
                    num = ((GLinkedLineComplex3)linkedShape).getProcessNodeIndex();
                    buf.append(" tShapeIndex=\"" + num + "\"");
                }
                buf.append(">");
            } else if (linkedShape instanceof KnownTransitionOmitted) {
                num = ((KnownTransitionOmitted)linkedShape).getOmittedShapeIndex();
                buf.append(" omittedShapeIndex=\"" + num + "\">");
            } else {
                buf.append(">");
            }
            buf.append(epStr2);
            buf.append("</celldesigner:editPoints>\n");
        }
        double lw = linkedShape.getLineWidth();
        Color color = linkedShape.getColor();
        buf.append("<celldesigner:line width=\"" + lw + "\" color=\"" + Integer.toHexString(color.getRGB()) + "\"/>\n");
        if (this.modificationLinks.size() > 0 || bBaseLinkGate) {
            Vector baseLinkGateMemberLinks = new Vector();
            if (bBaseLinkGate) {
                buf.append("<celldesigner:listOfGateMember>\n");
                baseLinkGateMemberLinks.add(this.baseLink);
                baseLinkGateMemberLinks.addAll(this.baseLink.getBaseLinkGateMembers());
            } else {
                buf.append("<celldesigner:listOfModification>\n");
                baseLinkGateMemberLinks = this.modificationLinks;
            }
            int i = 0;
            while (i < baseLinkGateMemberLinks.size()) {
                GLinkPositionInfo lpi3;
                GEditPoint[] ep3;
                GLogicGate blgate;
                GLinkedLineIndex lineIndex2;
                GLinkedLine gline2;
                GLinkedLineIndex lineIndex3;
                ReactionLink link2 = (ReactionLink)baseLinkGateMemberLinks.elementAt(i);
                GLinkedShape shape = (GLinkedShape)((Object)link2.getSymbol());
                if (bBaseLinkGate) {
                    buf.append("<celldesigner:GateMember type=\"" + link2.getSymbol().getCode() + "\"");
                } else {
                    buf.append("<celldesigner:modification type=\"" + link2.getSymbol().getCode() + "\"");
                }
                String a_str = "";
                String s_str = "";
                Vector sources = link2.getSources();
                if (shape instanceof GLogicGate) {
                    sources = ((GLogicGate)shape).getTargetElement();
                }
                int j = 0;
                while (j < sources.size()) {
                    if (j > 0) {
                        s_str = String.valueOf(s_str) + ",";
                        a_str = String.valueOf(a_str) + ",";
                    }
                    SpeciesAlias alias3 = (SpeciesAlias)sources.elementAt(j);
                    String speciesId3 = alias3.getOriginalSpecies().getId();
                    s_str = String.valueOf(s_str) + speciesId3;
                    a_str = String.valueOf(a_str) + alias3.getName();
                    ++j;
                }
                if (!bBaseLinkGate) {
                    buf.append(" modifiers=\"" + s_str + "\"");
                }
                buf.append(" aliases=\"" + a_str + "\"");
                if (shape instanceof GLogicGate) {
                    String modificationType = GLogicGate.getModificationTypeString(((GLogicGate)shape).getModificationType());
                    buf.append(" modificationType=\"" + modificationType + "\"");
                }
                offset = shape.getOffset();
                if (offset.x != 0.0 || offset.y != 0.0) {
                    buf.append(" offsetX=\"" + offset.x + "\"");
                    buf.append(" offsetY=\"" + offset.y + "\"");
                }
                if (shape instanceof GLinkedLine && (lineIndex3 = ((GLinkedLine)shape).getEndLineIndex()) != null) {
                    buf.append(" targetLineIndex=\"" + lineIndex3.arm + "," + lineIndex3.line + "\"");
                }
                if (shape instanceof GLinkedLineComplex3 && (gline2 = ((GLinkedLineComplex3)shape).getLine(2)) != null && (lineIndex2 = gline2.getEndLineIndex()) != null) {
                    buf.append(" targetLineIndex=\"" + lineIndex2.arm + "," + lineIndex2.line + "\"");
                }
                if (shape instanceof GLogicGate && (lineIndex = (blgate = (GLogicGate)shape).getRealLine().getEndLineIndex()) != null) {
                    buf.append(" targetLineIndex=\"" + lineIndex.arm + "," + lineIndex.line + "\"");
                }
                if (shape instanceof GEditable && (ep3 = ((GEditable)((Object)shape)).getEditPoints()).length > 0) {
                    String ep_Str = "";
                    int k3 = 0;
                    while (k3 < ep3.length) {
                        Point2D.Double innerPos3 = ep3[k3].getLocalPosition();
                        if (k3 > 0) {
                            ep_Str = String.valueOf(ep_Str) + " ";
                        }
                        ep_Str = String.valueOf(ep_Str) + innerPos3.x + "," + innerPos3.y;
                        ++k3;
                    }
                    buf.append(" editPoints=\"" + ep_Str + "\"");
                }
                buf.append(">\n");
                if (shape instanceof GLinkConnectSchemeOwner) {
                    String str3;
                    GLinkedStraightLine l1;
                    buf.append("<celldesigner:connectScheme ");
                    GLinkConnectSchemeOwner owner = (GLinkConnectSchemeOwner)((Object)shape);
                    int policy3 = owner.getConnectPolicy();
                    if (policy3 == 1) {
                        buf.append(String.valueOf(CONNECT_POLICY_STR) + "=\"" + CONNECT_POLICY_SQUARE_STR + "\">\n");
                    } else {
                        buf.append(String.valueOf(CONNECT_POLICY_STR) + "=\"" + CONNECT_POLICY_DIRECT_STR + "\">\n");
                    }
                    if (owner instanceof GLinkedCreaseLine) {
                        buf.append("<celldesigner:listOfLineDirection>\n");
                        int arm = -1;
                        GLinkedCreaseLine line = (GLinkedCreaseLine)owner;
                        int n4 = line.getLineSize();
                        int j2 = 0;
                        while (j2 < n4) {
                            l1 = (GLinkedStraightLine)line.getLine(j2);
                            switch (l1.getDirection()) {
                                case 2: {
                                    str3 = LINE_DIRECTION_HORIZONTAL_STR;
                                    break;
                                }
                                case 1: {
                                    str3 = LINE_DIRECTION_VERTICAL_STR;
                                    break;
                                }
                                default: {
                                    str3 = "unknown";
                                }
                            }
                            buf.append("<celldesigner:lineDirection");
                            if (arm >= 0) {
                                buf.append(" arm=\"" + arm + "\"");
                            }
                            buf.append(" index=\"" + j2 + "\" " + VALUE_ATTR_STR + "=\"" + str3 + "\"/>\n");
                            ++j2;
                        }
                        buf.append("</celldesigner:listOfLineDirection>\n");
                    } else if (owner instanceof GLinkedLineComplex3) {
                        buf.append("<celldesigner:listOfLineDirection>\n");
                        int arm = 0;
                        while (arm < 3) {
                            GLinkedCreaseLine line = (GLinkedCreaseLine)((GLinkedLineComplex3)owner).getLine(arm);
                            int n5 = line.getLineSize();
                            int j3 = 0;
                            while (j3 < n5) {
                                l1 = (GLinkedStraightLine)line.getLine(j3);
                                switch (l1.getDirection()) {
                                    case 2: {
                                        str3 = LINE_DIRECTION_HORIZONTAL_STR;
                                        break;
                                    }
                                    case 1: {
                                        str3 = LINE_DIRECTION_VERTICAL_STR;
                                        break;
                                    }
                                    default: {
                                        str3 = "unknown";
                                    }
                                }
                                buf.append("<celldesigner:lineDirection");
                                if (arm >= 0) {
                                    buf.append(" arm=\"" + arm + "\"");
                                }
                                buf.append(" index=\"" + j3 + "\" " + VALUE_ATTR_STR + "=\"" + str3 + "\"/>\n");
                                ++j3;
                            }
                            ++arm;
                        }
                        buf.append("</celldesigner:listOfLineDirection>\n");
                    } else if (owner instanceof GLogicGate) {
                        buf.append("<celldesigner:listOfLineDirection>\n");
                        int arm = -1;
                        LinkedCreaseLine line = ((GLogicGate)owner).getRealLine();
                        int n6 = line.getLineSize();
                        int j4 = 0;
                        while (j4 < n6) {
                            l1 = (GLinkedStraightLine)line.getLine(j4);
                            switch (l1.getDirection()) {
                                case 2: {
                                    str3 = LINE_DIRECTION_HORIZONTAL_STR;
                                    break;
                                }
                                case 1: {
                                    str3 = LINE_DIRECTION_VERTICAL_STR;
                                    break;
                                }
                                default: {
                                    str3 = "unknown";
                                }
                            }
                            buf.append("<celldesigner:lineDirection");
                            if (arm >= 0) {
                                buf.append(" arm=\"" + arm + "\"");
                            }
                            buf.append(" index=\"" + j4 + "\" " + VALUE_ATTR_STR + "=\"" + str3 + "\"/>\n");
                            ++j4;
                        }
                        buf.append("</celldesigner:listOfLineDirection>\n");
                    }
                    buf.append("</celldesigner:" + CONNECT_SCHEME_STR + ">\n");
                }
                if (shape instanceof GLinkedLine && (lpi3 = ((GLinkedLine)shape).getStartLinkPositionInfo()) != null) {
                    Vector<GLinkTarget> speciesVec = new Vector<GLinkTarget>(1);
                    Vector<GLinkPositionInfo> lpiVec = new Vector<GLinkPositionInfo>(1);
                    GLinkTarget lt = ((GLinkedLine)shape).getStartTarget();
                    if (lt instanceof SpeciesAlias) {
                        speciesVec.addElement(lt);
                        lpiVec.addElement(lpi3);
                    }
                    int j5 = 0;
                    while (j5 < sources.size()) {
                        SpeciesAlias alias4 = (SpeciesAlias)sources.elementAt(j5);
                        String speciesId4 = alias4.getOriginalSpecies().getId();
                        buf.append("<celldesigner:linkTarget species=\"" + speciesId4 + "\" alias=\"" + alias4.getName() + "\">\n");
                        GLinkPositionInfo lpi2 = (GLinkPositionInfo)lpiVec.elementAt(j5);
                        if (lpi2 != null) {
                            buf.append("<celldesigner:linkAnchor ");
                            String innerId3 = lpi2.getInnerIdForLink();
                            if (!innerId3.equals("")) {
                                buf.append("innerId=\"" + innerId3 + "\" ");
                            }
                            buf.append("position=\"" + lpi2.getPositionStringForLink() + "\"/>\n");
                        }
                        buf.append("</celldesigner:linkTarget>\n");
                        ++j5;
                    }
                }
                if (shape instanceof GLinkedLineComplex3) {
                    GLinkTarget lt;
                    GLinkPositionInfo lpi4;
                    gline = ((GLinkedLineComplex3)shape).getLine(2);
                    Vector<GLinkTarget> speciesVec = new Vector<GLinkTarget>(2);
                    Vector<GLinkPositionInfo> lpiVec = new Vector<GLinkPositionInfo>(2);
                    gline = ((GLinkedLineComplex3)shape).getLine(0);
                    if (gline != null && (lpi4 = gline.getEndLinkPositionInfo()) != null && (lt = gline.getEndTarget()) instanceof SpeciesAlias) {
                        speciesVec.addElement(lt);
                        lpiVec.addElement(lpi4);
                    }
                    if ((gline = ((GLinkedLineComplex3)shape).getLine(1)) != null && (lpi = gline.getEndLinkPositionInfo()) != null && (lt = gline.getEndTarget()) instanceof SpeciesAlias) {
                        speciesVec.addElement(lt);
                        lpiVec.addElement(lpi);
                    }
                    int j6 = 0;
                    while (j6 < speciesVec.size()) {
                        SpeciesAlias alias5 = (SpeciesAlias)speciesVec.elementAt(j6);
                        String speciesId5 = alias5.getOriginalSpecies().getId();
                        buf.append("<celldesigner:linkTarget species=\"" + speciesId5 + "\" alias=\"" + alias5.getName() + "\">\n");
                        GLinkPositionInfo lpi5 = (GLinkPositionInfo)lpiVec.elementAt(j6);
                        if (lpi5 != null) {
                            buf.append("<celldesigner:linkAnchor ");
                            String innerId4 = lpi5.getInnerIdForLink();
                            if (!innerId4.equals("")) {
                                buf.append("innerId=\"" + innerId4 + "\" ");
                            }
                            buf.append("position=\"" + lpi5.getPositionStringForLink() + "\"/>\n");
                        }
                        buf.append("</celldesigner:linkTarget>\n");
                        ++j6;
                    }
                    j6 = 0;
                    while (j6 < 3) {
                        GLinkedCreaseLine line1 = (GLinkedCreaseLine)((GLinkedLineComplex3)shape).getLine(j6);
                        int num = line1.getCreasePointsSize();
                        buf.append("num" + j6 + "=\"" + num + "\"");
                        ++j6;
                    }
                }
                if (shape instanceof GLinkedLine || shape instanceof GLinkedLineComplex3 || shape instanceof GLogicGate) {
                    double lw2 = shape.getLineWidth();
                    Color color2 = shape.getColor();
                    buf.append("<celldesigner:line width=\"" + lw2 + "\" color=\"" + Integer.toHexString(color2.getRGB()) + "\"/>\n");
                }
                if (bBaseLinkGate) {
                    buf.append("</celldesigner:GateMember>\n");
                } else {
                    buf.append("</celldesigner:modification>\n");
                }
                ++i;
            }
            if (bBaseLinkGate) {
                buf.append("</celldesigner:listOfGateMember>\n");
            } else {
                buf.append("</celldesigner:listOfModification>\n");
            }
        }
        buf.append("</celldesigner:extension>");
        if (vecData != null && vecData.size() > 0) {
            buf = LibSBMLUtil.getMiriamValueFromMiriams(buf, (SBase)reaction, vecData, true);
        }
        buf.append(this.bufAnnotation.toString());
        buf.append("</annotation>");
        XMLNode annt = XMLNode.convertStringToXMLNode((String)buf.toString(), (XMLNamespaces)anntXmlNS);
        reaction.setAnnotation(annt);
    }

    private void reSetLogicGateRelaction(ReactionLink logicLinks, SpeciesAlias alias, ReactionLink link) {
        GLinkedShape gshape = null;
        gshape = logicLinks.getGLinkedShape();
        if (((GLogicGate)gshape).containSpecies(alias)) {
            GLinkPositionInfo gatePointInfo = new GLinkPositionInfo(0, 0.0);
            gatePointInfo.setElement(logicLinks);
            try {
                link.setTargetAt(logicLinks, 1, 0.0, 0.0, gatePointInfo);
                ((GLogicGate)gshape).addChildLink(link);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setLogicGateSubLink(Vector createLinks) {
        Vector vc = new Vector();
        int i = 0;
        while (i < createLinks.size()) {
            if (((ReactionLink)createLinks.get(i)).getGLinkedShape() instanceof GLogicGate) {
                vc.add(createLinks.get(i));
            }
            ++i;
        }
        GLinkedShape gshape = null;
        Object alias = null;
        int j = 0;
        while (j < vc.size()) {
            int k = 0;
            while (k < createLinks.size()) {
                gshape = ((ReactionLink)createLinks.get(k)).getGLinkedShape();
                if ((gshape instanceof LinkedCreaseLineModification || gshape instanceof LinkedCreaseLineMixedNotation) && ((GLinkedLine)gshape).getStartTarget() instanceof SpeciesAlias) {
                    this.reSetLogicGateRelaction((ReactionLink)vc.get(j), (SpeciesAlias)((GLinkedLine)gshape).getStartTarget(), (ReactionLink)createLinks.get(k));
                }
                ++k;
            }
            ++j;
        }
        int h = 0;
        while (h < vc.size()) {
            GLogicGate.changeLinkOrder(createLinks, (ReactionLink)vc.get(h));
            GLogicGate.changeLinkOrder(this.modificationLinks, (ReactionLink)vc.get(h));
            ++h;
        }
    }

    private int getRectangleIndex(Element elem) throws Exception {
        if (elem != null) {
            NodeList children = elem.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node n = children.item(i);
                if (n.getNodeType() == 1 && n.getNamespaceURI().equals("http://www.sbml.org/2001/ns/celldesigner") && n.getLocalName().equals(CONNECT_SCHEME_STR)) {
                    Element elem1 = (Element)n;
                    String str = elem1.getAttribute(RectangleIndexString);
                    return Integer.parseInt(str);
                }
                ++i;
            }
        }
        throw new Exception();
    }

    public Node getnodesResourceOfDescription() {
        return this.nodeResourceOfDescriptionOfReaction;
    }

    public StringBuffer getOtherAnnotation() {
        return this.bufAnnotation;
    }

    public void setOtherAnnotation(StringBuffer strBufAnnotation) {
        this.bufAnnotation = strBufAnnotation;
    }

    private GEditPoint[] getEditPointsFromChildElement(Element elem) {
        NodeList childlist = elem.getChildNodes();
        int childsize = childlist.getLength();
        int i = 0;
        while (i < childsize) {
            Element elem1;
            Node node = childlist.item(i);
            if (node.getNodeType() == 1 && node.getNamespaceURI().equals("http://www.sbml.org/2001/ns/celldesigner") && (elem1 = (Element)node).getLocalName().equals("editPoints")) {
                Vector<CreasePoint> list = new Vector<CreasePoint>();
                String editPointsString = elem1.getFirstChild().getNodeValue();
                StringTokenizer st1 = new StringTokenizer(editPointsString, " ");
                while (st1.hasMoreTokens()) {
                    String str_pos = st1.nextToken();
                    StringTokenizer st2 = new StringTokenizer(str_pos, ",");
                    String str_x = st2.nextToken();
                    String str_y = st2.nextToken();
                    try {
                        double x = Double.parseDouble(str_x);
                        double y = Double.parseDouble(str_y);
                        Point2D.Double innerPos = new Point2D.Double(x, y);
                        CreasePoint newPoint = new CreasePoint();
                        newPoint.setLocalPosition(innerPos);
                        newPoint.setPosition(new Point2D.Double());
                        list.add(newPoint);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return list.toArray(new CreasePoint[0]);
            }
            ++i;
        }
        return new CreasePoint[0];
    }

    private class MyMap
    extends LinkedList {
        private MyMap() {
        }

        public synchronized String findValueOfKey(String key) {
            String value = "";
            int i = 0;
            while (i < this.size()) {
                String[] set = (String[])this.get(i);
                if (key.equals(set[0])) {
                    return set[1];
                }
                ++i;
            }
            return value;
        }

        public synchronized String removeKey(String key) {
            String value = "";
            int i = 0;
            while (i < this.size()) {
                String[] set = (String[])this.get(i);
                if (key.equals(set[0])) {
                    value = set[1];
                    this.remove(i);
                    return value;
                }
                ++i;
            }
            return value;
        }
    }
}

