/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.sbmlExtension;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MouseInputAdapter;
import jp.fric.graphics.draw.PaintScheme;
import jp.sbi.celldesigner.Preference;
import jp.sbi.celldesigner.SBFactory;
import jp.sbi.celldesigner.SpeciesSymbol;
import jp.sbi.celldesigner.sbmlExtension.MRShapesPanel;
import jp.sbi.celldesigner.sbmlExtension.Modification;
import jp.sbi.celldesigner.sbmlExtension.ModificationRegion;
import jp.sbi.celldesigner.sbmlExtension.ModificationRegionDialog2;
import jp.sbi.celldesigner.sbmlExtension.ModificationShape;
import jp.sbi.celldesigner.sbmlExtension.RNA;
import jp.sbi.celldesigner.sbmlExtension.RNAPanelListener;
import jp.sbi.celldesigner.symbol.color.SpeciesColorScheme;

public class RNAPanel
extends JPanel
implements ActionListener {
    Dialog pDialog;
    ModificationRegionDialog2 mDialog;
    RNAPanelListener listener = null;
    private JTextField rnaNameField;
    private JComboBox rnaTypeCombo;
    private JButton addResidueButton;
    private JButton editResidueButton;
    private JButton removeResidueButton;
    private MRShapesPanel mShapesPanel;
    private RNA editingRNA = null;
    private Vector editingModifications = new Vector();
    private Vector mShapes = new Vector();
    private ModificationShape selected = null;
    private boolean isEnabled = true;
    private boolean isEditable = true;
    private ResidueNamespace residueNamespace = new ResidueNamespace();
    private MyMouseListener myMouseListener;
    private MyKeyListener myKeyListener;
    private PaintScheme painter = null;

    public RNAPanel(JDialog pDialog, ModificationRegionDialog2 mDialog) {
        JLabel labelMax = new JLabel("residues/regions");
        int maxWidth = (int)labelMax.getPreferredSize().getWidth();
        int inputX = maxWidth + 20;
        this.pDialog = pDialog;
        this.mDialog = mDialog;
        this.setLayout(null);
        this.setSize(inputX + 200, 160);
        JLabel labelRNAName = new JLabel("name");
        labelRNAName.setBounds(new Rectangle(10, 4, maxWidth, 20));
        this.add((Component)labelRNAName, null);
        this.rnaNameField = new JTextField();
        this.rnaNameField.setBounds(new Rectangle(inputX, 4, 200, 20));
        this.rnaNameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (RNAPanel.this.listener != null) {
                    RNAPanel.this.listener.panelStateChanged();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (RNAPanel.this.listener != null) {
                    RNAPanel.this.listener.panelStateChanged();
                }
            }
        });
        this.add((Component)this.rnaNameField, null);
        JLabel labelRNAType = new JLabel("type");
        labelRNAType.setBounds(new Rectangle(10, 28, maxWidth, 20));
        this.add((Component)labelRNAType, null);
        this.rnaTypeCombo = new JComboBox();
        this.rnaTypeCombo.setBounds(new Rectangle(inputX, 28, 200, 20));
        this.add((Component)this.rnaTypeCombo, null);
        JLabel labelResidue = new JLabel("regions");
        labelResidue.setBounds(new Rectangle(10, 52, maxWidth, 20));
        this.add((Component)labelResidue, null);
        this.addResidueButton = new JButton("add..");
        this.addResidueButton.setBounds(new Rectangle(10, 76, maxWidth, 20));
        this.add((Component)this.addResidueButton, null);
        this.editResidueButton = new JButton("edit..");
        this.editResidueButton.setBounds(new Rectangle(10, 100, maxWidth, 20));
        this.add((Component)this.editResidueButton, null);
        this.removeResidueButton = new JButton("del..");
        this.removeResidueButton.setBounds(new Rectangle(10, 128, maxWidth, 20));
        this.add((Component)this.removeResidueButton, null);
        this.mShapesPanel = new MRShapesPanel(200, 100);
        this.mShapesPanel.setBounds(new Rectangle(inputX, 56, 200, 100));
        this.add((Component)this.mShapesPanel, null);
        Vector codes = SBFactory.getCompatibleSymbolCodes("RNA");
        int s = 0;
        int i = 0;
        while (i < codes.size()) {
            String code = (String)codes.elementAt(i);
            if (SBFactory.isRNA(code)) {
                this.rnaTypeCombo.insertItemAt(code, s++);
            }
            ++i;
        }
        this.myKeyListener = new MyKeyListener();
        pDialog.addKeyListener(this.myKeyListener);
        this.rnaTypeCombo.addActionListener(this);
        this.addResidueButton.addActionListener(this);
        this.editResidueButton.addActionListener(this);
        this.removeResidueButton.addActionListener(this);
        this.myMouseListener = new MyMouseListener(this.mShapesPanel);
        this.mShapesPanel.addMouseListener(this.myMouseListener);
        this.mShapesPanel.addMouseMotionListener(this.myMouseListener);
    }

    public void setRNAName(String name) {
        this.rnaNameField.setText(name);
    }

    public void setPaintScheme(PaintScheme scheme) {
        this.painter = scheme;
        this.mShapesPanel.setPaintScheme(scheme);
    }

    public void releaseAll() {
        this.mShapesPanel.removeMouseListener(this.myMouseListener);
        this.mShapesPanel.removeMouseMotionListener(this.myMouseListener);
        this.myMouseListener = null;
        this.removeResidueButton.removeActionListener(this);
        this.editResidueButton.removeActionListener(this);
        this.addResidueButton.removeActionListener(this);
        this.rnaTypeCombo.removeActionListener(this);
        this.pDialog.removeKeyListener(this.myKeyListener);
        this.myKeyListener = null;
        this.selected = null;
        this.residueNamespace = null;
        this.editingRNA = null;
        this.mShapes.clear();
        this.mShapes = null;
        this.mShapesPanel.releaseAll();
        this.mShapesPanel = null;
        this.mDialog = null;
        this.pDialog = null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.rnaTypeCombo)) {
            this.rnaTypeCombo_performed();
        }
        if (e.getSource().equals(this.addResidueButton)) {
            this.addResidue_performed();
        }
        if (e.getSource().equals(this.editResidueButton)) {
            this.editResidue_performed();
        }
        if (e.getSource().equals(this.removeResidueButton)) {
            this.removeResidue_performed();
        }
    }

    public void setRNAPanelListener(RNAPanelListener listener) {
        this.listener = listener;
    }

    public void setSymbolBounds(Rectangle2D.Double bounds) {
        this.mShapesPanel.buildSymbolBounds(bounds);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        this.rnaNameField.setEnabled(isEnabled);
        this.rnaTypeCombo.setEnabled(isEnabled);
        if (!isEnabled) {
            this.rnaNameField.setText("");
            this.rnaTypeCombo.setSelectedItem("RNA");
            this.mShapesPanel.setSpeciesSymbol(null);
            this.setEditable(false);
        }
    }

    public void setEditable(boolean isEditable) {
        this.isEditable = isEditable;
        this.rnaNameField.setEnabled(isEditable);
        this.rnaTypeCombo.setEnabled(isEditable);
        this.setResidueRelatedEnability();
    }

    private void setResidueRelatedEnability() {
        this.addResidueButton.setEnabled(this.isEditable);
        this.editResidueButton.setEnabled(this.isEditable && this.selected != null);
        this.removeResidueButton.setEnabled(this.isEditable && this.selected != null);
    }

    public void setRNA(RNA rna) {
        int debug = rna.getListOfRegions().size();
        this.editingRNA = rna;
        this.initPanel(null);
    }

    public void setRNA(RNA rna, Vector initial_modifications) {
        int debug = rna.getListOfRegions().size();
        this.editingRNA = rna;
        this.initPanel(initial_modifications);
    }

    private void initPanel(Vector initial_modifications) {
        if (this.editingRNA == null) {
            return;
        }
        String name = this.editingRNA.getName();
        this.rnaNameField.setText(name);
        String type = this.editingRNA.getType();
        this.rnaTypeCombo.setSelectedItem(type);
        SpeciesSymbol symbol = (SpeciesSymbol)((Object)SBFactory.createSymbol(type));
        if (this.painter == null) {
            if (Preference.isDebug) {
                System.out.println("ERROR : RNAPanel.initPanel() : painter == null");
            }
            Color color = SpeciesColorScheme.getColor(type);
            this.painter = SpeciesColorScheme.getScheme(type);
            this.painter.setColor(color);
            this.mShapesPanel.setPaintScheme(this.painter);
        }
        this.mShapesPanel.setSpeciesSymbol(symbol);
        this.editingModifications = new Vector();
        this.mShapes = new Vector();
        Vector transcripts = this.editingRNA.getListOfRegions();
        int debug = transcripts.size();
        int i = 0;
        while (i < transcripts.size()) {
            ModificationRegion transcript = (ModificationRegion)transcripts.get(i);
            String transcriptId = transcript.getId();
            Modification m = null;
            if (initial_modifications != null) {
                int k = 0;
                while (k < initial_modifications.size()) {
                    Modification modification = (Modification)initial_modifications.elementAt(k);
                    if (modification.getResidue().equals(transcriptId)) {
                        m = modification;
                        break;
                    }
                    ++k;
                }
            }
            if (m == null) {
                m = new Modification(transcriptId);
            }
            this.editingModifications.add(m);
            ModificationShape mShape = new ModificationShape();
            mShape.setModificationRegion(transcript);
            mShape.setModification(m);
            this.mShapes.add(mShape);
            ++i;
        }
        this.mShapesPanel.setModificationShapes(this.mShapes);
        this.residueNamespace.initResidueMaxId(transcripts);
        this.selected = null;
        this.setResidueRelatedEnability();
        this.pDialog.repaint();
    }

    public RNA getRNA() {
        String newName = this.rnaNameField.getText();
        this.editingRNA.setName(newName);
        String type = (String)this.rnaTypeCombo.getSelectedItem();
        this.editingRNA.setType(type);
        return this.editingRNA;
    }

    public Vector getModifications() {
        return this.editingModifications;
    }

    private void rnaTypeCombo_performed() {
        if (this.isEnabled && this.isEditable) {
            String type = (String)this.rnaTypeCombo.getSelectedItem();
            if (type == null) {
                return;
            }
            SpeciesSymbol symbol = (SpeciesSymbol)((Object)SBFactory.createSymbol(type));
            this.mShapesPanel.setSpeciesSymbol(symbol);
            this.pDialog.repaint();
            if (this.listener != null) {
                this.listener.panelStateChanged();
            }
        }
    }

    private void addResidue_performed() {
        if (this.isEnabled && this.isEditable) {
            ModificationRegion rs = new ModificationRegion();
            String transcriptId = this.residueNamespace.createNewResidueId();
            try {
                rs.setId(transcriptId);
            }
            catch (Exception exception) {
                // empty catch block
            }
            rs.setType("CodingRegion");
            rs.setSize(0.3);
            rs.setPos(0.3);
            this.editingRNA.getListOfRegions().add(rs);
            Modification m = new Modification(transcriptId);
            this.editingModifications.add(m);
            ModificationShape mShape = new ModificationShape();
            mShape.setModificationRegion(rs);
            mShape.setModification(m);
            this.mShapes.add(mShape);
            this.mShapesPanel.setModificationShapes(this.mShapes);
            if (this.selected != null) {
                this.selected.setSoloHighlighted(false);
                if (this.listener != null) {
                    this.listener.mShapeDeselected(this.selected);
                }
            }
            this.selected = mShape;
            this.selected.setSoloHighlighted(true);
            if (this.listener != null) {
                this.listener.mShapeSelected(this.selected);
            }
            this.setResidueRelatedEnability();
            this.pDialog.repaint();
            this.editResidue_performed();
        }
    }

    private void editResidue_performed() {
        if (this.selected != null && this.isEnabled && this.isEditable) {
            this.mDialog.setComboItemForRNA();
            ModificationRegion region = this.selected.getModificationRegion();
            this.mDialog.setModificationRegion(region);
            this.mDialog.show();
            if (this.listener != null) {
                this.listener.panelStateChanged();
            }
        }
    }

    private void removeResidue_performed() {
        if (this.selected != null && this.isEnabled && this.isEditable) {
            this.mShapes.remove(this.selected);
            ModificationRegion rs = this.selected.getModificationRegion();
            this.editingRNA.getListOfRegions().remove(rs);
            if (this.editingModifications != null) {
                int i = 0;
                while (i < this.editingModifications.size()) {
                    Modification m = (Modification)this.editingModifications.elementAt(i);
                    if (m.getResidue().equals(rs.getId())) {
                        this.editingModifications.remove(m);
                        break;
                    }
                    ++i;
                }
            }
            this.mShapesPanel.setModificationShapes(this.mShapes);
            if (this.listener != null) {
                this.listener.mShapeDeselected(this.selected);
            }
            this.selected = null;
            this.setResidueRelatedEnability();
            this.pDialog.repaint();
            if (this.mDialog.isShowing()) {
                this.mDialog.setModificationRegion(null);
            }
            if (this.listener != null) {
                this.listener.panelStateChanged();
            }
        }
    }

    private class MyKeyListener
    extends KeyAdapter {
        private MyKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (RNAPanel.this.selected != null && RNAPanel.this.isEnabled && RNAPanel.this.isEditable && (e.getKeyCode() == 127 || e.getKeyCode() == 8)) {
                RNAPanel.this.removeResidue_performed();
            }
        }
    }

    private class MyMouseListener
    extends MouseInputAdapter {
        int downX = 0;
        int downY = 0;
        MRShapesPanel mShapesPanel;

        public MyMouseListener(MRShapesPanel mShapesPanel) {
            this.mShapesPanel = mShapesPanel;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (RNAPanel.this.isEnabled) {
                this.downX = e.getX();
                this.downY = e.getY();
                ModificationShape prevSelected = RNAPanel.this.selected;
                if (RNAPanel.this.selected != null) {
                    RNAPanel.this.selected.setSoloHighlighted(false);
                    RNAPanel.this.selected = null;
                }
                int i = RNAPanel.this.mShapes.size() - 1;
                while (i >= 0) {
                    ModificationShape mShape = (ModificationShape)RNAPanel.this.mShapes.elementAt(i);
                    if (mShape.inShape(this.downX, this.downY)) {
                        RNAPanel.this.selected = mShape;
                        RNAPanel.this.selected.setSoloHighlighted(true);
                        break;
                    }
                    --i;
                }
                RNAPanel.this.setResidueRelatedEnability();
                RNAPanel.this.pDialog.repaint();
                if (RNAPanel.this.selected != null && RNAPanel.this.isEditable) {
                    ModificationRegion rs = RNAPanel.this.selected.getModificationRegion();
                    if (RNAPanel.this.mDialog.isShowing()) {
                        RNAPanel.this.mDialog.setModificationRegion(rs);
                    } else if (e.getClickCount() > 1) {
                        RNAPanel.this.editResidue_performed();
                    }
                }
                if (RNAPanel.this.listener != null) {
                    if (prevSelected != null && RNAPanel.this.selected == null) {
                        RNAPanel.this.listener.mShapeDeselected(prevSelected);
                    } else if (prevSelected == null && RNAPanel.this.selected != null) {
                        RNAPanel.this.listener.mShapeSelected(RNAPanel.this.selected);
                    } else if (prevSelected != null && RNAPanel.this.selected != null && prevSelected != RNAPanel.this.selected) {
                        RNAPanel.this.listener.mShapeDeselected(prevSelected);
                        RNAPanel.this.listener.mShapeSelected(RNAPanel.this.selected);
                    }
                }
                Object var2_2 = null;
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (RNAPanel.this.selected != null && RNAPanel.this.isEnabled && RNAPanel.this.isEditable) {
                Point2D.Double[] range = this.mShapesPanel.getMovingRange();
                double w = range[1].x - range[0].x;
                double size = RNAPanel.this.selected.getModificationRegion().getSize();
                double maxPos = 1.0 - size;
                double pos = 0.0;
                pos = ((double)e.getX() - range[0].x) / w - size / 2.0;
                if (pos > maxPos) {
                    pos = maxPos;
                }
                if (pos < 0.0) {
                    pos = 0.0;
                }
                RNAPanel.this.selected.getModificationRegion().setPos(pos);
                RNAPanel.this.pDialog.repaint();
                if (RNAPanel.this.listener != null) {
                    RNAPanel.this.listener.panelStateChanged();
                }
            }
        }
    }

    private class ResidueNamespace {
        private int residueCnt = 0;
        private String residueNametag = "tr";

        private ResidueNamespace() {
        }

        public String createNewResidueId() {
            ++this.residueCnt;
            return String.valueOf(this.residueNametag) + this.residueCnt;
        }

        private void initResidueMaxId(Vector list) {
            this.residueCnt = 0;
            int maxCnt = 0;
            int i = 0;
            while (i < list.size()) {
                ModificationRegion r = (ModificationRegion)list.get(i);
                ++this.residueCnt;
                String id = r.getId();
                String cntStr = id.substring(this.residueNametag.length());
                if (!cntStr.equals("")) {
                    try {
                        int cnt = Integer.parseInt(cntStr);
                        if (cnt > maxCnt) {
                            maxCnt = cnt;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++i;
            }
            if (this.residueCnt < maxCnt) {
                this.residueCnt = maxCnt;
            }
        }
    }
}

