/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.sbmlExtension;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jp.fric.graphics.draw.PaintScheme;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.sbmlExtension.ModificationRegionDialog2;
import jp.sbi.celldesigner.sbmlExtension.ModificationShape;
import jp.sbi.celldesigner.sbmlExtension.RNA;
import jp.sbi.celldesigner.sbmlExtension.RNAPanel;
import jp.sbi.celldesigner.sbmlExtension.RNAPanelListener;
import jp.sbi.celldesigner.symbol.color.SpeciesColorScheme;
import jp.sbi.sbml.SId;
import jp.sbi.sbml.SIdFormatException;
import jp.sbi.sbml.util.SBaseDialog;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Species;

public class RNADialog2
extends SBaseDialog
implements RNAPanelListener {
    private RNAPanel rnaPanel;
    protected ModificationRegionDialog2 mDialog;
    SBModel sbmodel = null;

    public RNADialog2() {
    }

    public RNADialog2(Dialog owner) {
        super(owner);
    }

    public RNADialog2(Frame owner) {
        super(owner);
    }

    public void setDialogByArg(String name) {
        this.rnaPanel.setRNAName(name);
    }

    @Override
    protected JPanel createDialogPanel() {
        this.mDialog = new ModificationRegionDialog2(this);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(null);
        this.rnaPanel = new RNAPanel(this, this.mDialog);
        this.rnaPanel.setBounds(new Rectangle(0, 0, this.rnaPanel.getWidth(), this.rnaPanel.getHeight()));
        this.mainPanel.add(this.rnaPanel);
        this.rnaPanel.setRNAPanelListener(this);
        this.LABEL_WIDTH = 90;
        this.TEXT_WIDTH = 200;
        this.setLayoutConstants();
        this.BUTTON_POSITION_Y = 10 + 7 * this.BASELINE_SKIP;
        this.DIALOG_WIDTH = this.rnaPanel.getWidth() + 10;
        this.setDefaultButtonsLayout();
        this.addDefaultButtonsToPanel();
        return this.mainPanel;
    }

    @Override
    protected SBase createInitialObject() {
        return new RNA();
    }

    @Override
    protected void setDialogFromObject(SBase sbase) {
        if (sbase == null) {
            return;
        }
        RNA rna = null;
        if (sbase instanceof RNA) {
            rna = (RNA)sbase;
        } else if (sbase instanceof Species) {
            Species sp = (Species)sbase;
            rna = this.sbmodel.getRNA(sp.getId());
        }
        RNA copy = rna.deepClone();
        String code = rna.getType();
        Color color = SpeciesColorScheme.getColor(code);
        BasicStroke stroke = new BasicStroke((float)SpeciesColorScheme.getLineWidth(code), 0, 1);
        PaintScheme scheme = SpeciesColorScheme.getScheme(code);
        scheme.setColor(color);
        scheme.setStroke(stroke);
        this.rnaPanel.setPaintScheme(scheme);
        this.rnaPanel.setRNA(copy);
    }

    @Override
    protected void setObjectFromDialog(SBase sbase) throws Exception {
        if (sbase == null) {
            return;
        }
        RNA rna = (RNA)sbase;
        RNA edited = this.rnaPanel.getRNA();
        try {
            SId.check(edited.getId());
            rna.setId(edited.getId());
        }
        catch (SIdFormatException e) {
            throw new Exception("malformed id string");
        }
        rna.setName(edited.getName());
        rna.setType(edited.getType());
        Vector rnaResidues = rna.getListOfRegions();
        Vector editedResidues = edited.getListOfRegions();
        rnaResidues.clear();
        int i = 0;
        while (i < editedResidues.size()) {
            SBase residue = (SBase)editedResidues.get(i);
            rnaResidues.add(residue);
            ++i;
        }
    }

    @Override
    protected void setComponentsEnabled(boolean isEnabled) {
        this.rnaPanel.setEnabled(isEnabled);
        this.rnaPanel.setEditable(isEnabled);
        this.okButton.setEnabled(isEnabled);
    }

    @Override
    protected void releaseAllMembers() {
    }

    @Override
    protected boolean hasChildListDialog() {
        return false;
    }

    @Override
    protected void setChildDialogMode(int mode) {
    }

    @Override
    protected void updateChildDialog() {
    }

    @Override
    public void mShapeSelected(ModificationShape mShape) {
    }

    @Override
    public void mShapeDeselected(ModificationShape mShape) {
    }

    @Override
    public void panelStateChanged() {
        super.someFieldIsEdited();
    }

    @Override
    public void setObject(SBase sbase) {
        super.setObject(sbase);
        this.updateApproveLabel();
    }

    @Override
    public void setNewObject() {
        super.setNewObject();
        this.updateApproveLabel();
    }

    @Override
    public void show() {
        this.updateApproveLabel();
        super.show();
    }

    @Override
    protected void okButton_actionPerformed() {
        try {
            if (this.sbmodel != null) {
                RNA p = new RNA();
                this.setObjectFromDialog((SBase)p);
                if (!(this.getObject() instanceof RNA) && this.getObject() instanceof Species) {
                    this.setObject((SBase)this.sbmodel.getRNA(((Species)this.getObject()).getId()));
                    this.sbmodel.rnaUpdated((RNA)super.getObject(), p);
                } else {
                    this.sbmodel.rnaUpdated((RNA)this.getObject(), p);
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Confirmation", 2);
        }
        this.updateApproveLabel();
    }

    @Override
    public boolean update_actionPerformed() {
        boolean returnval;
        try {
            if (this.sbmodel != null) {
                RNA p = new RNA();
                this.setObjectFromDialog((SBase)p);
                if (!(this.getObject() instanceof RNA) && this.getObject() instanceof Species) {
                    this.setObject((SBase)this.sbmodel.getRNA(((Species)this.getObject()).getId()));
                }
                this.sbmodel.rnaUpdated((RNA)super.getObject(), p);
                MainWindow.getLastInstance().SBaseChanged(this.getObject());
            }
            returnval = true;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Confirmation", 2);
            returnval = false;
        }
        this.updateApproveLabel();
        return returnval;
    }

    @Override
    protected void cancelButton_actionPerformed() {
        super.cancelDialog();
    }

    public void setSBModel(SBModel sbmodel) {
        this.sbmodel = sbmodel;
    }
}

