/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.sbmlExtension;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MouseInputAdapter;
import jp.fric.graphics.draw.PaintScheme;
import jp.sbi.celldesigner.Preference;
import jp.sbi.celldesigner.SBFactory;
import jp.sbi.celldesigner.SpeciesSymbol;
import jp.sbi.celldesigner.sbmlExtension.BindingRegion;
import jp.sbi.celldesigner.sbmlExtension.MShapesPanel;
import jp.sbi.celldesigner.sbmlExtension.Modification;
import jp.sbi.celldesigner.sbmlExtension.ModificationResidue;
import jp.sbi.celldesigner.sbmlExtension.ModificationResidueDialog2;
import jp.sbi.celldesigner.sbmlExtension.ModificationShape;
import jp.sbi.celldesigner.sbmlExtension.Protein;
import jp.sbi.celldesigner.sbmlExtension.ProteinPanelListener;
import jp.sbi.celldesigner.sbmlExtension.SameIDAutoTag;
import jp.sbi.celldesigner.sbmlExtension.StructuralState;
import jp.sbi.celldesigner.symbol.color.SpeciesColorScheme;

public class ProteinPanel
extends JPanel
implements ActionListener {
    Dialog pDialog;
    ModificationResidueDialog2 mDialog;
    ProteinPanelListener listener = null;
    private JTextField proteinNameField;
    private JComboBox proteinTypeCombo;
    private JButton addResidueButton;
    private JButton editResidueButton;
    private JButton removeResidueButton;
    private MShapesPanel mShapesPanel;
    private Protein editingProtein = null;
    private Vector editingModifications = new Vector();
    private Vector editingStructuralStates = new Vector();
    private Vector mShapes = new Vector();
    private ModificationShape selected = null;
    private boolean isEnabled = true;
    private boolean isEditable = true;
    private ResidueNamespace residueNamespace = new ResidueNamespace();
    private MyMouseListener myMouseListener;
    private MyKeyListener myKeyListener;
    private PaintScheme painter = null;
    private static final double MAXVERSIZE = 0.42;
    private SameIDAutoTag autotag = null;
    private SameIDAutoTag autotagselected = null;
    private boolean isState = false;
    private boolean isAutoTag = false;

    public SameIDAutoTag getSameIDAutoTag() {
        return this.autotag;
    }

    public ProteinPanel(JDialog pDialog, ModificationResidueDialog2 mDialog) {
        JLabel labelMax = new JLabel("residues/regions");
        int maxWidth = (int)labelMax.getPreferredSize().getWidth();
        int inputX = maxWidth + 20;
        this.pDialog = pDialog;
        this.mDialog = mDialog;
        this.setLayout(null);
        this.setSize(inputX + 200, 160);
        JLabel labelProteinName = new JLabel("name");
        labelProteinName.setBounds(new Rectangle(10, 4, maxWidth, 20));
        this.add((Component)labelProteinName, null);
        this.proteinNameField = new JTextField();
        this.proteinNameField.setBounds(new Rectangle(inputX, 4, 200, 20));
        this.proteinNameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (ProteinPanel.this.listener != null) {
                    ProteinPanel.this.listener.panelStateChanged();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (ProteinPanel.this.listener != null) {
                    ProteinPanel.this.listener.panelStateChanged();
                }
            }
        });
        this.add((Component)this.proteinNameField, null);
        JLabel labelProteinType = new JLabel("type");
        labelProteinType.setBounds(new Rectangle(10, 28, maxWidth, 20));
        this.add((Component)labelProteinType, null);
        this.proteinTypeCombo = new JComboBox();
        this.proteinTypeCombo.setBounds(new Rectangle(inputX, 28, 200, 20));
        this.add((Component)this.proteinTypeCombo, null);
        JLabel labelResidue = new JLabel("residues/regions");
        labelResidue.setBounds(new Rectangle(10, 52, maxWidth, 20));
        this.add((Component)labelResidue, null);
        this.addResidueButton = new JButton("add..");
        this.addResidueButton.setBounds(new Rectangle(10, 76, maxWidth, 20));
        this.add((Component)this.addResidueButton, null);
        this.editResidueButton = new JButton("edit..");
        this.editResidueButton.setBounds(new Rectangle(10, 100, maxWidth, 20));
        this.add((Component)this.editResidueButton, null);
        this.removeResidueButton = new JButton("del..");
        this.removeResidueButton.setBounds(new Rectangle(10, 128, maxWidth, 20));
        this.add((Component)this.removeResidueButton, null);
        this.mShapesPanel = new MShapesPanel(200, 100);
        this.mShapesPanel.setBounds(new Rectangle(inputX, 56, 200, 100));
        this.add((Component)this.mShapesPanel, null);
        Vector codes = SBFactory.getCompatibleSymbolCodes("GENERIC");
        int s = 0;
        int i = 0;
        while (i < codes.size()) {
            String code = (String)codes.elementAt(i);
            if (SBFactory.isProtein(code)) {
                this.proteinTypeCombo.insertItemAt(code, s++);
            }
            ++i;
        }
        this.myKeyListener = new MyKeyListener();
        pDialog.addKeyListener(this.myKeyListener);
        this.proteinTypeCombo.addActionListener(this);
        this.addResidueButton.addActionListener(this);
        this.editResidueButton.addActionListener(this);
        this.removeResidueButton.addActionListener(this);
        this.myMouseListener = new MyMouseListener(this.mShapesPanel);
        this.mShapesPanel.addMouseListener(this.myMouseListener);
        this.mShapesPanel.addMouseMotionListener(this.myMouseListener);
    }

    public void setProteinName(String name) {
        this.proteinNameField.setText(name);
    }

    public void setPaintScheme(PaintScheme scheme) {
        this.painter = scheme;
        this.mShapesPanel.setPaintScheme(scheme);
    }

    public void releaseAll() {
        this.mShapesPanel.removeMouseListener(this.myMouseListener);
        this.mShapesPanel.removeMouseMotionListener(this.myMouseListener);
        this.myMouseListener = null;
        this.removeResidueButton.removeActionListener(this);
        this.editResidueButton.removeActionListener(this);
        this.addResidueButton.removeActionListener(this);
        this.proteinTypeCombo.removeActionListener(this);
        this.pDialog.removeKeyListener(this.myKeyListener);
        this.myKeyListener = null;
        this.selected = null;
        this.autotagselected = null;
        this.residueNamespace = null;
        this.editingProtein = null;
        this.mShapes.clear();
        this.mShapes = null;
        this.mShapesPanel.releaseAll();
        this.mShapesPanel = null;
        this.mDialog = null;
        this.pDialog = null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.proteinTypeCombo)) {
            this.proteinTypeCombo_performed();
        }
        if (e.getSource().equals(this.addResidueButton)) {
            this.addResidue_performed();
        }
        if (e.getSource().equals(this.editResidueButton)) {
            this.editResidue_performed();
        }
        if (e.getSource().equals(this.removeResidueButton)) {
            this.removeResidue_performed();
        }
    }

    public void setProteinPanelListener(ProteinPanelListener listener) {
        this.listener = listener;
    }

    public ModificationResidueDialog2 getModificationResidueDialog2() {
        return this.mDialog;
    }

    public void readdBindingRegion_performed() {
        BindingRegion br = new BindingRegion();
        br.setName(this.mDialog.getCurName());
        br.setSize(0.1);
        String bindingRegionId = this.residueNamespace.getCurrentResidueId();
        try {
            br.setId(bindingRegionId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.editingProtein.getListOfBindingRegiones().add(br);
        int index = this.editingProtein.getListOfModificationResidues().size() - 1;
        if (index >= 0) {
            this.editingProtein.getListOfModificationResidues().remove(index);
        }
        Modification m = new Modification(bindingRegionId);
        this.editingModifications.remove(this.editingModifications.size() - 1);
        this.editingModifications.add(m);
        ModificationShape mShape = new ModificationShape();
        mShape.setBindingRegion(br);
        mShape.setModificationResidue(null);
        mShape.setModification(m);
        this.mShapes.remove(this.mShapes.size() - 1);
        this.mShapes.add(mShape);
        this.mShapesPanel.setModificationShapes(this.mShapes);
        if (this.selected != null) {
            this.selected.setSoloHighlighted(false);
            if (this.listener != null) {
                this.listener.mShapeDeselected(this.selected);
            }
        }
        this.selected = mShape;
        this.selected.setSoloHighlighted(true);
        if (this.listener != null) {
            this.listener.mShapeSelected(this.selected);
        }
        this.pDialog.repaint();
        if (this.selected != null && this.isEnabled && this.isEditable) {
            BindingRegion bindingRegion = this.selected.getBindingRegion();
            String proteinType = (String)this.proteinTypeCombo.getSelectedItem();
            bindingRegion.setProteinType(proteinType);
            this.mDialog.setBindingRegion(bindingRegion);
            this.mDialog.setIsEdit(false);
            this.mDialog.show();
            if (this.listener != null) {
                this.listener.panelStateChanged();
            }
        }
    }

    public void readdResidue_performed() {
        ModificationResidue rs = new ModificationResidue();
        rs.setName(this.mDialog.getCurName());
        String residueId = this.residueNamespace.getCurrentResidueId();
        try {
            rs.setId(residueId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        rs.setAngle(this.changeAngle(rs));
        this.editingProtein.getListOfModificationResidues().add(rs);
        int index = this.editingProtein.getListOfBindingRegiones().size() - 1;
        if (index >= 0) {
            this.editingProtein.getListOfBindingRegiones().remove(index);
        }
        Modification m = new Modification(residueId);
        this.editingModifications.remove(this.editingModifications.size() - 1);
        this.editingModifications.add(m);
        ModificationShape mShape = new ModificationShape();
        mShape.setModificationResidue(rs);
        mShape.setBindingRegion(null);
        mShape.setModification(m);
        this.mShapes.remove(this.mShapes.size() - 1);
        this.mShapes.add(mShape);
        this.mShapesPanel.setModificationShapes(this.mShapes);
        if (this.selected != null) {
            this.selected.setSoloHighlighted(false);
            if (this.listener != null) {
                this.listener.mShapeDeselected(this.selected);
            }
        }
        this.selected = mShape;
        this.selected.setSoloHighlighted(true);
        if (this.listener != null) {
            this.listener.mShapeSelected(this.selected);
        }
        this.setResidueRelatedEnability();
        this.pDialog.repaint();
        this.mDialog.setIsAdd(false);
        if (this.selected != null && this.isEnabled && this.isEditable) {
            ModificationResidue residue = this.selected.getModificationResidue();
            this.mDialog.setModificationResidue(residue);
            this.mDialog.setIsEdit(false);
            this.mDialog.show();
            if (this.listener != null) {
                this.listener.panelStateChanged();
            }
        }
    }

    public void CheckMaxSize() {
        int i = 0;
        while (i < this.mShapes.size()) {
            ModificationShape mShape = (ModificationShape)this.mShapes.elementAt(i);
            BindingRegion br = mShape.getBindingRegion();
            String proteinType = (String)this.proteinTypeCombo.getSelectedItem();
            if (br != null) {
                ProteinPanel.resetAngle(mShape, proteinType);
            }
            ++i;
        }
    }

    public static boolean resetAngle(ModificationShape selected, String proteinType) {
        if (selected == null || selected.getBindingRegion() == null) {
            return false;
        }
        double angle = selected.getBindingRegion().getAngle();
        double newAngle = 0.0;
        double size = selected.getBindingRegion().getSize();
        int ret = ProteinPanel.checkSize(angle, size, proteinType);
        if (ret == 0) {
            return false;
        }
        double angle0 = 0.0;
        double angle1 = 0.0;
        double k = 1.0;
        double k2 = 1.0;
        double k3 = 1.0;
        if (angle > 0.7853981633974483 && angle < 2.356194490192345) {
            angle0 = 0.7853981633974483;
            angle1 = 2.356194490192345;
            if (proteinType.equals("RECEPTOR")) {
                if (size >= 0.99) {
                    selected.getBindingRegion().setAngle(1.5707963267948966);
                    selected.getBindingRegion().setSize(1.0);
                    return true;
                }
                k2 = 1.0131712259371835;
            }
        } else if (angle > 2.356194490192345 && angle < 3.6128315516282616 && proteinType.equals("RECEPTOR")) {
            angle0 = 2.356194490192345;
            angle1 = 3.6128315516282616;
            k = 2.380952380952381;
            if (size >= 0.336) {
                selected.getBindingRegion().setAngle(2.9845130209103035);
                selected.getBindingRegion().setSize(0.336);
                return true;
            }
        } else if (angle > 3.6128315516282616 && angle < 5.811946409141117 && proteinType.equals("RECEPTOR")) {
            if (size >= 0.99) {
                selected.getBindingRegion().setAngle(4.71238898038469);
                selected.getBindingRegion().setSize(1.0);
                return true;
            }
            angle0 = 3.6128315516282616;
            angle1 = 5.811946409141117;
            k2 = 1.0131712259371835;
            k3 = 1.4;
        } else if (angle > 5.811946409141117 && angle <= Math.PI * 2 && proteinType.equals("RECEPTOR")) {
            angle0 = 5.811946409141117;
            angle1 = Math.PI * 2;
            k = 2.380952380952381;
            if (size >= 0.42) {
                selected.getBindingRegion().setAngle(0.0);
                selected.getBindingRegion().setSize(0.336);
                return true;
            }
        } else if (angle <= 0.7853981633974483 && proteinType.equals("RECEPTOR")) {
            angle0 = 0.0;
            angle1 = 0.7853981633974483;
            k = 2.380952380952381;
            if (size >= 0.336) {
                selected.getBindingRegion().setAngle(0.15707963267948966);
                selected.getBindingRegion().setSize(0.336);
                return true;
            }
        } else if (angle > 3.9269908169872414 && angle < 5.183627878423159 && proteinType.equals("TRUNCATED")) {
            if (size >= 0.8) {
                selected.getBindingRegion().setAngle(4.5553093477052);
                selected.getBindingRegion().setSize(0.8);
                return true;
            }
            angle0 = 3.9269908169872414;
            angle1 = 5.183627878423159;
        } else {
            if (angle > 5.183627878423159 && proteinType.equals("TRUNCATED")) {
                angle0 = 5.183627878423159;
                angle1 = Math.PI * 2;
                k = 4.761904761904762;
                k2 = 0.5;
                if (size >= 0.252) {
                    selected.getBindingRegion().setAngle(5.827654372409066);
                    selected.getBindingRegion().setSize(0.252);
                    return true;
                }
                if (ret == -1) {
                    newAngle = angle1 - 0.5 * k * size * (angle1 - angle0) + 0.2198;
                }
                if (ret == 1) {
                    newAngle = angle0 + 0.5 * k * size * (angle1 - angle0);
                }
                selected.getBindingRegion().setAngle(newAngle);
                return true;
            }
            if (angle < 0.7853981633974483 && proteinType.equals("TRUNCATED")) {
                angle0 = 0.0;
                angle1 = 0.7853981633974483;
                k = 4.8076923076923075;
                k = 4.960317460317461;
                if (size >= 0.252) {
                    selected.getBindingRegion().setAngle(0.2827433388230814);
                    selected.getBindingRegion().setSize(0.252);
                    return true;
                }
                k2 = 0.5;
            } else if (angle > 2.356194490192345 && angle < 3.9269908169872414) {
                angle0 = 2.356194490192345;
                angle1 = 3.9269908169872414;
                k = 2.380952380952381;
                if (size >= 0.42) {
                    selected.getBindingRegion().setAngle(Math.PI);
                    selected.getBindingRegion().setSize(0.42);
                    return true;
                }
            } else if (angle > 3.9269908169872414 && angle < 5.497787143782138) {
                angle0 = 3.9269908169872414;
                angle1 = 5.497787143782138;
            } else if (angle < 0.7853981633974483 || angle > 5.497787143782138) {
                angle0 = 5.497787143782138;
                angle1 = 0.7853981633974483;
                k = 2.380952380952381;
                if (size >= 0.42) {
                    selected.getBindingRegion().setAngle(Math.PI * 2);
                    selected.getBindingRegion().setSize(0.42);
                    return true;
                }
            }
        }
        if ((newAngle = ret == -1 ? angle1 - 0.25 * size * k2 * Math.PI * k * k3 : (angle0 == 0.0 && proteinType.equals("TRUNCATED") ? angle0 + 0.25 * size * k2 * Math.PI * k * k3 - 0.18 : angle0 + 0.25 * size * k2 * Math.PI * k * k3)) < 0.0 || newAngle > Math.PI * 2) {
            if (proteinType.equals("RECEPTOR")) {
                selected.getBindingRegion().setAngle(0.15707963267948966);
            }
            return true;
        }
        selected.getBindingRegion().setAngle(newAngle);
        return true;
    }

    protected static int checkSize(double angle, double size, String proteinType) {
        double maxSize = 0.0;
        double angle0 = 0.0;
        double angle1 = 0.0;
        double k1 = 1.0;
        double k2 = 1.0;
        double k3 = 1.0;
        if (angle > 0.7853981633974483 && angle < 2.356194490192345) {
            angle0 = 0.7853981633974483;
            angle1 = 2.356194490192345;
            if (proteinType.equals("RECEPTOR")) {
                k2 = 0.987;
            }
        } else if (angle > 2.356194490192345 && angle < 3.6128315516282616 && proteinType.equals("RECEPTOR")) {
            angle0 = 2.356194490192345;
            angle1 = 3.6128315516282616;
            k1 = 0.42;
        } else if (angle > 3.6128315516282616 && angle < 5.811946409141117 && proteinType.equals("RECEPTOR")) {
            angle0 = 3.6128315516282616;
            angle1 = 5.811946409141117;
            k2 = 1.0309278350515465;
            k2 = 0.987;
            k3 = 1.4;
        } else {
            if (angle > 5.811946409141117 && angle <= Math.PI * 2 && proteinType.equals("RECEPTOR")) {
                k1 = 0.42;
                angle0 = 5.811946409141117;
                maxSize = k1 * k2 * 4.0 * (angle - angle0) / (k3 * Math.PI);
                if (size > maxSize) {
                    return 1;
                }
                return 0;
            }
            if (angle <= 0.7853981633974483 && proteinType.equals("RECEPTOR")) {
                k1 = 0.42;
                k2 = 0.987;
                angle1 = 0.7853981633974483;
                maxSize = k1 * k2 * 4.0 * (angle1 - angle) / (k3 * Math.PI);
                if (size > maxSize) {
                    return -1;
                }
                return 0;
            }
            if (angle > 3.9269908169872414 && angle < 5.183627878423159 && proteinType.equals("TRUNCATED")) {
                angle0 = 3.9269908169872414;
                angle1 = 5.183627878423159;
            } else {
                if (angle > 5.183627878423159 && proteinType.equals("TRUNCATED")) {
                    k1 = 0.21;
                    angle1 = Math.PI * 2;
                    angle0 = 5.183627878423159;
                    maxSize = k1 * 2.0 * (angle1 - angle + 0.23) / (angle1 - angle0);
                    if (maxSize < 0.1) {
                        maxSize = 0.099;
                    }
                    if (size > maxSize) {
                        return -1;
                    }
                    maxSize = k1 * 2.0 * (angle - angle0) / (angle1 - angle0);
                    if (maxSize < 0.1) {
                        maxSize = 0.099;
                    }
                    if (size > maxSize) {
                        return 1;
                    }
                    return 0;
                }
                if (angle <= 0.7853981633974483 && proteinType.equals("TRUNCATED")) {
                    angle0 = 0.0;
                    angle1 = 0.7853981633974483;
                    k1 = 0.20159999999999997;
                    k2 = 2.0;
                } else if (angle > 2.356194490192345 && angle < 3.9269908169872414) {
                    angle0 = 2.356194490192345;
                    angle1 = 3.9269908169872414;
                    k1 = 0.42;
                } else if (angle > 3.9269908169872414 && angle < 5.497787143782138) {
                    angle0 = 3.9269908169872414;
                    angle1 = 5.497787143782138;
                } else {
                    if (angle < 0.7853981633974483) {
                        angle1 = 0.7853981633974483;
                        k1 = 0.42;
                        if (proteinType.equals("RECEPTOR")) {
                            k1 *= 0.8;
                        }
                        if (size > (maxSize = k1 * 4.0 * (angle1 - angle) / Math.PI)) {
                            return -1;
                        }
                        return 0;
                    }
                    if (angle > 5.497787143782138) {
                        angle0 = 5.497787143782138;
                        k1 = 0.42;
                        if (proteinType.equals("RECEPTOR")) {
                            k1 *= 0.8;
                        }
                        if (size > (maxSize = k1 * 4.0 * (angle - angle0) / Math.PI)) {
                            return 1;
                        }
                        return 0;
                    }
                }
            }
        }
        if ((maxSize = k1 * k2 * 4.0 * (angle1 - angle) / (k3 * Math.PI)) < 0.1) {
            maxSize = 0.099;
        }
        if (size > maxSize) {
            return -1;
        }
        maxSize = k1 * k2 * 4.0 * (angle - angle0) / (k3 * Math.PI);
        if (maxSize < 0.1) {
            maxSize = 0.099;
        }
        if (size > maxSize) {
            return 1;
        }
        return 0;
    }

    public void setSymbolBounds(Rectangle2D.Double bounds) {
        this.mShapesPanel.buildSymbolBounds(bounds);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        this.proteinNameField.setEnabled(isEnabled);
        this.proteinTypeCombo.setEnabled(isEnabled);
        if (!isEnabled) {
            this.proteinNameField.setText("");
            this.proteinTypeCombo.setSelectedItem("GENERIC");
            this.mShapesPanel.setSpeciesSymbol(null);
            this.setEditable(false);
        }
    }

    public void setEditable(boolean isEditable) {
        this.isEditable = isEditable;
        this.proteinNameField.setEnabled(isEditable);
        this.proteinTypeCombo.setEnabled(isEditable);
        this.setResidueRelatedEnability();
    }

    private void setResidueRelatedEnability() {
        this.addResidueButton.setEnabled(this.isEditable);
        this.editResidueButton.setEnabled(this.isEditable && this.selected != null);
        this.removeResidueButton.setEnabled(this.isEditable && this.selected != null);
    }

    public void setProtein(Protein protein) {
        int debug = protein.getListOfModificationResidues().size();
        this.editingProtein = protein;
        this.initPanel(null, null, null);
    }

    public void setProtein(Protein protein, Vector initial_modifications, Vector initial_structuralStates, SameIDAutoTag tag) {
        this.editingProtein = protein;
        this.initPanel(initial_modifications, initial_structuralStates, tag);
    }

    private void initPanel(Vector initial_modifications, Vector initial_structuralStates, SameIDAutoTag tag) {
        if (this.editingProtein == null) {
            return;
        }
        String name = this.editingProtein.getName();
        this.proteinNameField.setText(name);
        String type = this.editingProtein.getType();
        this.proteinTypeCombo.setSelectedItem(type);
        SpeciesSymbol symbol = (SpeciesSymbol)((Object)SBFactory.createSymbol(type));
        if (this.painter == null) {
            if (Preference.isDebug) {
                System.out.println("ERROR : ProteinPanel.initPanel() : painter == null");
            }
            Color color = SpeciesColorScheme.getColor(type);
            this.painter = SpeciesColorScheme.getScheme(type);
            this.painter.setColor(color);
            this.mShapesPanel.setPaintScheme(this.painter);
        }
        this.mShapesPanel.setSpeciesSymbol(symbol);
        this.editingModifications = new Vector();
        this.mShapes = new Vector();
        Vector residues = this.editingProtein.getListOfModificationResidues();
        int debug = residues.size();
        int i = 0;
        while (i < residues.size()) {
            ModificationResidue residue = (ModificationResidue)residues.get(i);
            String residueId = residue.getId();
            Modification m = null;
            if (initial_modifications != null) {
                int k = 0;
                while (k < initial_modifications.size()) {
                    Modification modification = (Modification)initial_modifications.elementAt(k);
                    if (modification.getResidue().equals(residueId)) {
                        m = modification;
                        break;
                    }
                    ++k;
                }
            }
            if (m == null) {
                m = new Modification(residueId);
            }
            this.editingModifications.add(m);
            ModificationShape mShape = new ModificationShape();
            mShape.setModificationResidue(residue);
            mShape.setModification(m);
            this.mShapes.add(mShape);
            ++i;
        }
        Vector<ModificationShape> structuralStateShapes = new Vector<ModificationShape>();
        this.editingStructuralStates = new Vector();
        if (initial_structuralStates != null && initial_structuralStates.size() > 0) {
            int i2 = 0;
            while (i2 < initial_structuralStates.size()) {
                StructuralState structuralState = (StructuralState)initial_structuralStates.get(i2);
                ModificationShape mShape = new ModificationShape();
                mShape.setStructuralState(structuralState);
                structuralStateShapes.add(mShape);
                this.editingStructuralStates.add(structuralState);
                ++i2;
            }
        }
        this.mShapesPanel.setStructuralStateShapes(structuralStateShapes);
        this.residueNamespace.initResidueMaxId(residues);
        this.selected = null;
        this.setResidueRelatedEnability();
        Vector bindingRegiones = this.editingProtein.getListOfBindingRegiones();
        debug = bindingRegiones.size();
        int i3 = 0;
        while (i3 < bindingRegiones.size()) {
            BindingRegion bindingRegion = (BindingRegion)bindingRegiones.get(i3);
            String bindingRegionId = bindingRegion.getId();
            Modification m = null;
            if (initial_modifications != null) {
                int k = 0;
                while (k < initial_modifications.size()) {
                    Modification modification = (Modification)initial_modifications.elementAt(k);
                    if (modification.getBindingRegion().equals(bindingRegionId)) {
                        m = modification;
                        break;
                    }
                    ++k;
                }
            }
            if (m == null) {
                m = new Modification(bindingRegionId);
            }
            this.editingModifications.add(m);
            ModificationShape mShape = new ModificationShape();
            mShape.setBindingRegion(bindingRegion);
            mShape.setModification(m);
            this.mShapes.add(mShape);
            ++i3;
        }
        this.residueNamespace.initBindingRegionMaxId(bindingRegiones);
        this.mShapesPanel.setModificationShapes(this.mShapes);
        this.mShapesPanel.setSameIDAutoTag(symbol, tag);
        this.autotag = this.mShapesPanel.getSameIDAutoTag();
        this.autotagselected = null;
        this.pDialog.repaint();
    }

    public Protein getProtein() {
        String newName = this.proteinNameField.getText();
        this.editingProtein.setName(newName);
        String type = (String)this.proteinTypeCombo.getSelectedItem();
        this.editingProtein.setType(type);
        return this.editingProtein;
    }

    public Vector getModifications() {
        return this.editingModifications;
    }

    public Vector getStructuralStates() {
        return this.editingStructuralStates;
    }

    private void proteinTypeCombo_performed() {
        if (this.isEnabled && this.isEditable) {
            String type = (String)this.proteinTypeCombo.getSelectedItem();
            if (type == null) {
                return;
            }
            SpeciesSymbol symbol = (SpeciesSymbol)((Object)SBFactory.createSymbol(type));
            this.mShapesPanel.setSpeciesSymbol(symbol);
            this.pDialog.repaint();
            if (this.listener != null) {
                this.listener.panelStateChanged();
            }
        }
    }

    private void addResidue_performed() {
        if (this.isEnabled && this.isEditable) {
            ModificationResidue rs = new ModificationResidue();
            String residueId = this.residueNamespace.createNewResidueId();
            try {
                rs.setId(residueId);
            }
            catch (Exception exception) {
                // empty catch block
            }
            rs.setAngle(this.changeAngle(rs));
            this.editingProtein.getListOfModificationResidues().add(rs);
            Modification m = new Modification(residueId);
            this.editingModifications.add(m);
            ModificationShape mShape = new ModificationShape();
            mShape.setModificationResidue(rs);
            mShape.setBindingRegion(null);
            mShape.setModification(m);
            this.mShapes.add(mShape);
            this.mShapesPanel.setModificationShapes(this.mShapes);
            if (this.selected != null) {
                this.selected.setSoloHighlighted(false);
                if (this.listener != null) {
                    this.listener.mShapeDeselected(this.selected);
                }
            }
            this.selected = mShape;
            this.selected.setSoloHighlighted(true);
            if (this.listener != null) {
                this.listener.mShapeSelected(this.selected);
            }
            this.setResidueRelatedEnability();
            this.pDialog.repaint();
            if (this.selected != null && this.isEnabled && this.isEditable) {
                ModificationResidue residue = this.selected.getModificationResidue();
                this.mDialog.setIsAdd(true);
                this.mDialog.setIsEdit(false);
                this.mDialog.setModificationResidue(residue);
                this.mDialog.show();
                if (this.listener != null) {
                    this.listener.panelStateChanged();
                }
            }
        }
    }

    private double changeAngle(ModificationResidue rs) {
        double initialAngle;
        double d = initialAngle = rs.getAngle();
        while (d > 0.0) {
            if (!this.soNear(d)) {
                return d;
            }
            d -= 0.1;
        }
        d = initialAngle;
        while (d < Math.PI * 2) {
            if (!this.soNear(d)) {
                return d;
            }
            d += 0.1;
        }
        return initialAngle;
    }

    private boolean soNear(double angle) {
        Vector list = this.editingProtein.getListOfModificationResidues();
        int i = 0;
        while (i < list.size()) {
            ModificationResidue rs = (ModificationResidue)list.get(i);
            double a = rs.getAngle();
            if (Math.abs(angle - a) < 0.09) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void editResidue_performed() {
        if (this.selected != null && this.isEnabled && this.isEditable) {
            this.mDialog.setIsEdit(true);
            ModificationResidue residue = this.selected.getModificationResidue();
            if (residue != null) {
                residue.setType("residue");
                this.mDialog.setModificationResidue(residue);
            } else {
                BindingRegion bindingRegion = this.selected.getBindingRegion();
                String proteinType = (String)this.proteinTypeCombo.getSelectedItem();
                bindingRegion.setProteinType(proteinType);
                bindingRegion.setType("binding region");
                this.mDialog.setBindingRegion(bindingRegion);
            }
            this.mDialog.show();
            if (this.listener != null) {
                this.listener.panelStateChanged();
            }
        }
    }

    private void removeResidue_performed() {
        if (this.selected != null && this.isEnabled && this.isEditable) {
            this.mShapes.remove(this.selected);
            ModificationResidue rs = this.selected.getModificationResidue();
            this.editingProtein.getListOfModificationResidues().remove(rs);
            BindingRegion br = this.selected.getBindingRegion();
            this.editingProtein.getListOfBindingRegiones().remove(br);
            if (this.editingModifications != null) {
                int i = 0;
                while (i < this.editingModifications.size()) {
                    Modification m = (Modification)this.editingModifications.elementAt(i);
                    if (rs != null && m.getResidue().equals(rs.getId())) {
                        this.editingModifications.remove(m);
                        break;
                    }
                    if (br != null && m.getBindingRegion().equals(br.getId())) {
                        this.editingModifications.remove(m);
                        break;
                    }
                    ++i;
                }
            }
            this.mShapesPanel.setModificationShapes(this.mShapes);
            if (this.listener != null) {
                this.listener.mShapeDeselected(this.selected);
            }
            this.selected = null;
            this.setResidueRelatedEnability();
            this.pDialog.repaint();
            if (this.mDialog.isShowing()) {
                this.mDialog.setModificationResidue(null);
            }
            if (this.listener != null) {
                this.listener.panelStateChanged();
            }
        }
    }

    public void setStructuralStateShapes(Vector structuralStateShapes) {
        this.mShapesPanel.setStructuralStateShapes(structuralStateShapes);
    }

    private class MyKeyListener
    extends KeyAdapter {
        private MyKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (ProteinPanel.this.selected != null && ProteinPanel.this.isEnabled && ProteinPanel.this.isEditable && (e.getKeyCode() == 127 || e.getKeyCode() == 8)) {
                ProteinPanel.this.removeResidue_performed();
            }
        }
    }

    private class MyMouseListener
    extends MouseInputAdapter {
        int downX = 0;
        int downY = 0;
        MShapesPanel mShapesPanel;

        public MyMouseListener(MShapesPanel mShapesPanel) {
            this.mShapesPanel = mShapesPanel;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (ProteinPanel.this.isEnabled) {
                ModificationShape mShape;
                this.downX = e.getX();
                this.downY = e.getY();
                ProteinPanel.this.selected = null;
                ProteinPanel.this.autotagselected = null;
                ProteinPanel.this.isAutoTag = false;
                if (this.mShapesPanel.getSameIDAutoTag() != null && this.mShapesPanel.getSameIDAutoTag().getPaintPath().getBounds2D().contains(this.downX, this.downY)) {
                    ProteinPanel.this.autotagselected = this.mShapesPanel.getSameIDAutoTag();
                    ProteinPanel.this.isAutoTag = true;
                    ProteinPanel.this.pDialog.repaint();
                    return;
                }
                ModificationShape prevSelected = ProteinPanel.this.selected;
                if (ProteinPanel.this.selected != null) {
                    ProteinPanel.this.selected.setSoloHighlighted(false);
                    ProteinPanel.this.selected = null;
                }
                boolean isInShape = false;
                ProteinPanel.this.isState = false;
                int i = ProteinPanel.this.mShapes.size() - 1;
                while (i >= 0) {
                    mShape = (ModificationShape)ProteinPanel.this.mShapes.elementAt(i);
                    if (mShape.inShape(this.downX, this.downY)) {
                        ProteinPanel.this.selected = mShape;
                        ProteinPanel.this.selected.setSoloHighlighted(true);
                        isInShape = true;
                        break;
                    }
                    --i;
                }
                if (!isInShape) {
                    i = this.mShapesPanel.structuralStateShapes.size() - 1;
                    while (i >= 0) {
                        mShape = (ModificationShape)this.mShapesPanel.structuralStateShapes.elementAt(i);
                        if (mShape.getStructuralState().getState().equals("empty")) {
                            ProteinPanel.this.selected = null;
                            return;
                        }
                        if (mShape.inShape(this.downX, this.downY)) {
                            ProteinPanel.this.selected = mShape;
                            ProteinPanel.this.isState = true;
                            break;
                        }
                        --i;
                    }
                }
                ProteinPanel.this.setResidueRelatedEnability();
                ProteinPanel.this.pDialog.repaint();
                if (ProteinPanel.this.selected != null && ProteinPanel.this.isEditable) {
                    ModificationResidue rs = ProteinPanel.this.selected.getModificationResidue();
                    if (ProteinPanel.this.mDialog.isShowing()) {
                        if (rs != null) {
                            rs.setType("residue");
                            ProteinPanel.this.mDialog.setModificationResidue(rs);
                        } else {
                            BindingRegion br = ProteinPanel.this.selected.getBindingRegion();
                            br.setType("binding region");
                            ProteinPanel.this.mDialog.setBindingRegion(br);
                        }
                    } else if (e.getClickCount() > 1) {
                        ProteinPanel.this.editResidue_performed();
                    }
                }
                if (ProteinPanel.this.listener != null) {
                    if (prevSelected != null && ProteinPanel.this.selected == null) {
                        ProteinPanel.this.listener.mShapeDeselected(prevSelected);
                    } else if (prevSelected == null && ProteinPanel.this.selected != null) {
                        ProteinPanel.this.listener.mShapeSelected(ProteinPanel.this.selected);
                    } else if (prevSelected != null && ProteinPanel.this.selected != null && prevSelected != ProteinPanel.this.selected) {
                        ProteinPanel.this.listener.mShapeDeselected(prevSelected);
                        ProteinPanel.this.listener.mShapeSelected(ProteinPanel.this.selected);
                    }
                }
                Object var2_2 = null;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (ProteinPanel.this.selected != null && ProteinPanel.this.selected.getBindingRegion() != null) {
                String proteinType = (String)ProteinPanel.this.proteinTypeCombo.getSelectedItem();
                if (ProteinPanel.resetAngle(ProteinPanel.this.selected, proteinType)) {
                    ProteinPanel.this.pDialog.repaint();
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if ((ProteinPanel.this.selected != null || ProteinPanel.this.autotagselected != null) && ProteinPanel.this.isEnabled && (ProteinPanel.this.isEditable || ProteinPanel.this.isState || ProteinPanel.this.isAutoTag)) {
                Point2D.Double c = this.mShapesPanel.getSymbolCenter();
                double vx = (double)e.getX() - c.x;
                double vy = (double)e.getY() - c.y;
                Rectangle2D.Double rect = this.mShapesPanel.getSymbolFrame();
                double width = rect.width;
                double height = rect.height;
                double angle = 0.0;
                if (vx == 0.0 && vy == 0.0) {
                    return;
                }
                if (vx > 0.0 && vy <= 0.0 && -vy * width < vx * height) {
                    angle = -vy * width / (4.0 * vx * height);
                } else if (vy < 0.0 && vy * width < vx * height && vx * height <= -vy * width) {
                    angle = vx * height / (4.0 * vy * width) + 0.5;
                } else if (vx < 0.0 && vx * height <= vy * width && vy * width < -vx * height) {
                    angle = -vy * width / (4.0 * vx * height) + 1.0;
                } else if (vy > 0.0 && -vy * width <= vx * height && vx * height < vy * width) {
                    angle = vx * height / (4.0 * vy * width) + 1.5;
                } else if (vx > 0.0 && vx >= 0.0 && vy * width <= vx * height) {
                    angle = -vy * width / (4.0 * vx * height) + 2.0;
                } else {
                    return;
                }
                angle *= Math.PI;
                if (ProteinPanel.this.autotagselected != null) {
                    ProteinPanel.this.autotagselected.setAngle(angle);
                } else if (ProteinPanel.this.selected.getStructuralState() != null) {
                    ProteinPanel.this.selected.getStructuralState().setAngle(angle);
                } else if (ProteinPanel.this.selected.getModificationResidue() == null) {
                    ProteinPanel.this.selected.getBindingRegion().setAngle(angle);
                } else {
                    ProteinPanel.this.selected.getModificationResidue().setAngle(angle);
                }
                ProteinPanel.this.pDialog.repaint();
                if (ProteinPanel.this.listener != null) {
                    ProteinPanel.this.listener.panelStateChanged();
                }
            }
        }
    }

    private class ResidueNamespace {
        private int residueCnt = 0;
        private String residueNametag = "rs";

        private ResidueNamespace() {
        }

        public String createNewResidueId() {
            ++this.residueCnt;
            return String.valueOf(this.residueNametag) + this.residueCnt;
        }

        public String getCurrentResidueId() {
            return String.valueOf(this.residueNametag) + this.residueCnt;
        }

        private void initResidueMaxId(Vector list) {
            this.residueCnt = 0;
            int maxCnt = 0;
            int i = 0;
            while (i < list.size()) {
                ModificationResidue r = (ModificationResidue)list.get(i);
                ++this.residueCnt;
                String id = r.getId();
                String cntStr = id.substring(this.residueNametag.length());
                if (!cntStr.equals("")) {
                    try {
                        int cnt = Integer.parseInt(cntStr);
                        if (cnt > maxCnt) {
                            maxCnt = cnt;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++i;
            }
            if (this.residueCnt < maxCnt) {
                this.residueCnt = maxCnt;
            }
        }

        private void initBindingRegionMaxId(Vector list) {
            int maxCnt = 0;
            int i = 0;
            while (i < list.size()) {
                BindingRegion r = (BindingRegion)list.get(i);
                ++this.residueCnt;
                String id = r.getId();
                String cntStr = id.substring(this.residueNametag.length());
                if (!cntStr.equals("")) {
                    try {
                        int cnt = Integer.parseInt(cntStr);
                        if (cnt > maxCnt) {
                            maxCnt = cnt;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++i;
            }
            if (this.residueCnt < maxCnt) {
                this.residueCnt = maxCnt;
            }
        }
    }
}

