/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.sbmlExtension;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jp.fric.graphics.draw.PaintScheme;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.sbmlExtension.ModelAnnotation;
import jp.sbi.celldesigner.sbmlExtension.ModificationResidueDialog2;
import jp.sbi.celldesigner.sbmlExtension.ModificationShape;
import jp.sbi.celldesigner.sbmlExtension.Protein;
import jp.sbi.celldesigner.sbmlExtension.ProteinPanel;
import jp.sbi.celldesigner.sbmlExtension.ProteinPanelListener;
import jp.sbi.celldesigner.symbol.color.SpeciesColorScheme;
import jp.sbi.sbml.SId;
import jp.sbi.sbml.SIdFormatException;
import jp.sbi.sbml.util.LibSBMLUtil;
import jp.sbi.sbml.util.SBaseDialog;
import org.sbml.libsbml.ListOf;
import org.sbml.libsbml.ListOfReactions;
import org.sbml.libsbml.ListOfSpecies;
import org.sbml.libsbml.Model;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Species;

public class ProteinDialog2
extends SBaseDialog
implements ProteinPanelListener,
ActionListener {
    private ProteinPanel proteinPanel;
    protected ModificationResidueDialog2 mDialog;
    SBModel sbmodel = null;
    protected JButton editBlockDiagramButton;

    public ProteinDialog2() {
    }

    public ProteinDialog2(Dialog owner) {
        super(owner);
    }

    public ProteinDialog2(Frame owner) {
        super(owner);
    }

    public void setDialogByArg(String name) {
        this.proteinPanel.setProteinName(name);
    }

    @Override
    protected JPanel createDialogPanel() {
        this.mDialog = new ModificationResidueDialog2(this);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(null);
        this.proteinPanel = new ProteinPanel(this, this.mDialog);
        this.proteinPanel.setBounds(new Rectangle(0, 0, this.proteinPanel.getWidth(), this.proteinPanel.getHeight()));
        this.mainPanel.add(this.proteinPanel);
        this.proteinPanel.setProteinPanelListener(this);
        try {
            Class.forName("jp.sbi.celldesigner.blockDiagram.BlockDiagramDialog");
            this.editBlockDiagramButton = new JButton("edit block diagram...");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (this.editBlockDiagramButton != null) {
            int y = 164;
            this.editBlockDiagramButton.setBounds(new Rectangle(10, y, 180, 20));
            this.mainPanel.add(this.editBlockDiagramButton);
            this.editBlockDiagramButton.addActionListener(this);
        }
        this.LABEL_WIDTH = 90;
        this.TEXT_WIDTH = 200;
        this.setLayoutConstants();
        this.BUTTON_POSITION_Y = this.editBlockDiagramButton != null ? 10 + 8 * this.BASELINE_SKIP : 10 + 7 * this.BASELINE_SKIP;
        this.setDefaultButtonsLayout();
        this.addDefaultButtonsToPanel();
        this.DIALOG_WIDTH = this.proteinPanel.getWidth() + 10;
        return this.mainPanel;
    }

    @Override
    protected SBase createInitialObject() {
        return new Protein();
    }

    @Override
    protected void setDialogFromObject(SBase sbase) {
        if (sbase == null) {
            return;
        }
        Protein protein = null;
        if (sbase instanceof Protein) {
            protein = (Protein)sbase;
        } else if (sbase instanceof Species) {
            Species sp = (Species)sbase;
            protein = this.sbmodel.getProtein(sp.getId());
        }
        Protein copy = protein.deepClone();
        String code = protein.getType();
        Color color = SpeciesColorScheme.getColor(code);
        BasicStroke stroke = new BasicStroke((float)SpeciesColorScheme.getLineWidth(code), 0, 1);
        PaintScheme scheme = SpeciesColorScheme.getScheme(code);
        scheme.setColor(color);
        scheme.setStroke(stroke);
        this.proteinPanel.setPaintScheme(scheme);
        this.proteinPanel.setProtein(copy);
    }

    @Override
    protected void setObjectFromDialog(SBase sbase) throws Exception {
        if (sbase == null) {
            return;
        }
        Protein protein = (Protein)sbase;
        this.proteinPanel.CheckMaxSize();
        Protein edited = this.proteinPanel.getProtein();
        try {
            SId.check(edited.getId());
            protein.setId(edited.getId());
        }
        catch (SIdFormatException e) {
            throw new Exception("malformed id string");
        }
        protein.setName(edited.getName());
        protein.setType(edited.getType());
        Vector proteinResidues = protein.getListOfModificationResidues();
        Vector editedResidues = edited.getListOfModificationResidues();
        proteinResidues.clear();
        int i = 0;
        while (i < editedResidues.size()) {
            SBase residue = (SBase)editedResidues.get(i);
            proteinResidues.add(residue);
            ++i;
        }
        Vector proteinBindingRegiones = protein.getListOfBindingRegiones();
        Vector editedesBindingRegiones = edited.getListOfBindingRegiones();
        proteinBindingRegiones.clear();
        int i2 = 0;
        while (i2 < editedesBindingRegiones.size()) {
            SBase bindingRegion = (SBase)editedesBindingRegiones.get(i2);
            proteinBindingRegiones.add(bindingRegion);
            ++i2;
        }
    }

    @Override
    protected void setComponentsEnabled(boolean isEnabled) {
        this.proteinPanel.setEnabled(isEnabled);
        this.proteinPanel.setEditable(isEnabled);
        this.okButton.setEnabled(isEnabled);
        if (this.editBlockDiagramButton != null) {
            this.editBlockDiagramButton.setEnabled(isEnabled);
        }
    }

    @Override
    protected void releaseAllMembers() {
    }

    @Override
    protected boolean hasChildListDialog() {
        return false;
    }

    @Override
    protected void setChildDialogMode(int mode) {
    }

    @Override
    protected void updateChildDialog() {
    }

    @Override
    public void mShapeSelected(ModificationShape mShape) {
    }

    @Override
    public void mShapeDeselected(ModificationShape mShape) {
    }

    @Override
    public void panelStateChanged() {
        super.someFieldIsEdited();
    }

    @Override
    public void setObject(SBase sbase) {
        super.setObject(sbase);
        this.updateApproveLabel();
    }

    @Override
    public void setNewObject() {
        super.setNewObject();
        this.updateApproveLabel();
    }

    @Override
    public void show() {
        this.updateApproveLabel();
        super.show();
    }

    @Override
    protected void okButton_actionPerformed() {
        try {
            if (this.sbmodel != null) {
                Protein p = new Protein();
                this.setObjectFromDialog((SBase)p);
                if (!(this.getObject() instanceof Protein) && this.getObject() instanceof Species) {
                    this.setObject((SBase)this.sbmodel.getProtein(((Species)this.getObject()).getId()));
                    this.sbmodel.proteinUpdated((Protein)super.getObject(), p);
                } else {
                    this.sbmodel.proteinUpdated((Protein)this.getObject(), p);
                }
                if (this.sbmodel.getGStructure() != null) {
                    try {
                        this.sbmodel.getGStructure().reconfirmSameIDAutoTagNeedToPaint();
                        this.sbmodel.getSbframe().repaintLogicalArea(this.sbmodel.getSbframe().getLogicalViewArea());
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Confirmation", 2);
        }
        this.updateApproveLabel();
    }

    @Override
    public boolean update_actionPerformed() {
        boolean returnval;
        try {
            if (this.sbmodel != null) {
                Protein p = new Protein();
                this.setObjectFromDialog((SBase)p);
                if (!(this.getObject() instanceof Protein) && this.getObject() instanceof Species) {
                    this.setObject((SBase)this.sbmodel.getProtein(((Species)this.getObject()).getId()));
                }
                this.sbmodel.proteinUpdated((Protein)this.getObject(), p);
            }
            returnval = true;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Confirmation", 2);
            returnval = false;
        }
        this.updateApproveLabel();
        MainWindow.getLastInstance().SBaseChanged(this.getObject());
        return returnval;
    }

    @Override
    protected void cancelButton_actionPerformed() {
        super.cancelDialog();
    }

    public void setSBModel(SBModel sbmodel) {
        this.sbmodel = sbmodel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object s = e.getSource();
        if (this.editBlockDiagramButton != null && s == this.editBlockDiagramButton) {
            this.openBlockDiagramDialog();
        }
    }

    protected void openBlockDiagramDialog() {
        SBase sb = this.getObject();
        if (!(sb instanceof Protein) && sb instanceof Species) {
            this.setObject((SBase)this.sbmodel.getProtein(((Species)this.getObject()).getId()));
            sb = this.getObject();
        }
        Model model = this.sbmodel.getModel();
        ListOfReactions reactions = model.getListOfReactions();
        ListOfSpecies sl = model.getListOfSpecies();
        ModelAnnotation annotation = (ModelAnnotation)LibSBMLUtil.getAnnotation((SBase)model, null);
        try {
            Object tv = null;
            Class<?> clazz = Class.forName("jp.sbi.celldesigner.blockDiagram.table.TableValuesFactory");
            Class[] paramTypes = new Class[]{SBase.class, ListOf.class, ListOf.class, SBModel.class};
            Method m = clazz.getMethod("createTableValues", paramTypes);
            Object[] params = new Object[]{sb, reactions, sl, this.sbmodel};
            tv = m.invoke(null, params);
            JDialog dialog = annotation.getBlockDiagramDialogByProteinId(((Protein)sb).getId());
            if (dialog == null) {
                Window ownerOfProteinDialog2 = this.getOwner();
                Class<?> clazz2 = Class.forName("jp.sbi.celldesigner.blockDiagram.BlockDiagramDialog");
                Class[] paramTypes2 = new Class[]{ownerOfProteinDialog2 instanceof Frame ? Frame.class : (ownerOfProteinDialog2 instanceof Dialog ? Dialog.class : ownerOfProteinDialog2.getClass()), tv.getClass(), annotation.getClass(), SBase.class, this.sbmodel.getClass()};
                Constructor<?> c = clazz2.getConstructor(paramTypes2);
                Object[] params2 = new Object[]{ownerOfProteinDialog2, tv, annotation, sb, this.sbmodel};
                dialog = c.newInstance(params2);
                annotation.setBlockDiagramDialogByProteinId(((Species)sb).getId(), dialog);
            }
            dialog.show();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
    }

    public ProteinPanel getProteinPanel() {
        return this.proteinPanel;
    }
}

