/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.sbmlExtension;

import java.util.Vector;
import jp.co.mki.celldesigner.simulation.util.StringTool;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.plugin.PluginBindingRegion;
import jp.sbi.celldesigner.plugin.PluginListOf;
import jp.sbi.celldesigner.plugin.PluginModificationResidue;
import jp.sbi.celldesigner.plugin.PluginProtein;
import jp.sbi.celldesigner.plugin.PluginSBase;
import jp.sbi.celldesigner.sbmlExtension.BindingRegion;
import jp.sbi.celldesigner.sbmlExtension.Biomolecule;
import jp.sbi.celldesigner.sbmlExtension.ModificationResidue;
import jp.sbi.celldesigner.sbmlExtension.Notes;
import jp.sbi.celldesigner.sbmlExtension.StructuralState;
import jp.sbi.sbml.SId;
import jp.sbi.sbml.SIdFormatException;
import jp.sbi.sbml.SpecInfo;
import jp.sbi.sbml.debug.DebugPrinter;
import jp.sbi.sbml.util.LibSBMLUtil;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Species;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Protein
extends Species
implements Biomolecule {
    public static final int LIST_OF_MODIFICATION_RESIDUES = 0;
    public static final int LIST_OF_MODIFICATION_BINDINGREGIONES = 1;
    public static final int LIST_OF_STRUCTURALSTATE = 2;
    public static final int SIZE_OF_LISTS = 3;
    private Vector referedSpeciesAliases = new Vector();
    public static final String NAMESPACE = "celldesigner";
    private String name;
    private String type;
    private Vector[] lists = new Vector[3];
    private static final String[] nospaceListTagName = new String[]{"listOfModificationResidues", "listOfBindingRegions", "listOfStructuralState"};
    private static final String[] nospaceElementTagName = new String[]{"modificationResidue", "bindingRegion", "structuralState"};
    private static final String[] nospaceElementTagNameAsLevel1 = new String[]{"modificationResidue"};
    private static final String[] elementClassName = new String[]{"ModificationResidue", "BindingRegion", "StructuralState"};

    public Protein() {
        this.initAttributes();
        int i = 0;
        while (i < 3) {
            this.lists[i] = new Vector();
            ++i;
        }
    }

    private void initAttributes() {
        try {
            SId.check("");
            super.setId("");
        }
        catch (SIdFormatException sIdFormatException) {
            // empty catch block
        }
        this.name = "";
        this.type = "";
    }

    public Protein deepClone() {
        Protein p = new Protein();
        try {
            p.setId(this.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        p.setName(this.name);
        p.setType(this.type);
        Vector list = this.getListOfModificationResidues();
        int i = 0;
        while (i < list.size()) {
            ModificationResidue residue = (ModificationResidue)list.get(i);
            ModificationResidue r = (ModificationResidue)residue.clone();
            p.getListOfModificationResidues().add(r);
            ++i;
        }
        list = this.getListOfBindingRegiones();
        i = 0;
        while (i < list.size()) {
            BindingRegion bindingRegion = (BindingRegion)list.get(i);
            BindingRegion br = (BindingRegion)bindingRegion.clone();
            p.getListOfBindingRegiones().add(br);
            ++i;
        }
        list = this.getListOfStructuralStates();
        i = 0;
        while (i < list.size()) {
            StructuralState structuralState = (StructuralState)list.get(i);
            StructuralState s = (StructuralState)structuralState.clone();
            p.getListOfStructuralStates().add(s);
            ++i;
        }
        p.setAnnotation(this.getAnnotation());
        return p;
    }

    public boolean equals(Protein target) {
        Species rs;
        int k;
        ModificationResidue rs2;
        Species rs1;
        if (!target.getId().equals(this.getId())) {
            return false;
        }
        if (!target.getName().equals(this.name)) {
            return false;
        }
        if (!target.getType().equals(this.type)) {
            return false;
        }
        Vector targetList = target.getListOfModificationResidues();
        Vector myList = this.getListOfModificationResidues();
        if (targetList.size() != myList.size()) {
            return false;
        }
        int i = 0;
        while (i < myList.size()) {
            rs1 = (ModificationResidue)myList.get(i);
            rs2 = null;
            k = 0;
            while (k < targetList.size()) {
                rs = (ModificationResidue)targetList.get(k);
                if (rs1.getId().equals(rs.getId())) {
                    rs2 = rs;
                    break;
                }
                ++k;
            }
            if (rs2 == null) {
                return false;
            }
            if (!rs1.equals(rs2)) {
                return false;
            }
            ++i;
        }
        targetList = target.getListOfBindingRegiones();
        myList = this.getListOfBindingRegiones();
        if (targetList.size() != myList.size()) {
            return false;
        }
        i = 0;
        while (i < myList.size()) {
            rs1 = (BindingRegion)myList.get(i);
            rs2 = null;
            k = 0;
            while (k < targetList.size()) {
                rs = (BindingRegion)targetList.get(k);
                if (rs1.getId().equals(rs.getId())) {
                    rs2 = rs;
                    break;
                }
                ++k;
            }
            if (rs2 == null) {
                return false;
            }
            if (!rs1.equals((BindingRegion)((Object)rs2))) {
                return false;
            }
            ++i;
        }
        targetList = target.getListOfStructuralStates();
        myList = this.getListOfStructuralStates();
        if (targetList.size() != myList.size()) {
            return false;
        }
        i = 0;
        while (i < myList.size()) {
            StructuralState s2;
            StructuralState s1 = (StructuralState)myList.get(i);
            if (!s1.equals(s2 = (StructuralState)targetList.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(PluginProtein target) {
        PluginSBase rs;
        int k;
        PluginSBase rs2;
        Species rs1;
        if (!target.getExtensionId().equals(this.getId())) {
            return false;
        }
        if (!target.getName().equals(this.name)) {
            return false;
        }
        if (!target.getType().equals(this.type)) {
            return false;
        }
        PluginListOf targetList = target.getListOfPluginResidue();
        Vector myList = this.getListOfModificationResidues();
        if (targetList.size() != myList.size()) {
            return false;
        }
        int i = 0;
        while (i < myList.size()) {
            rs1 = (ModificationResidue)myList.get(i);
            rs2 = null;
            k = 0;
            while (k < targetList.size()) {
                rs = (PluginModificationResidue)targetList.get(k);
                if (rs1.getId().equals(((PluginModificationResidue)rs).getId()) && rs1.getAnnotationString() != null && rs1.getAnnotationString().equals(rs.getAnnotationString())) {
                    rs2 = rs;
                    break;
                }
                ++k;
            }
            if (rs2 == null) {
                return false;
            }
            if (!rs1.equals((PluginModificationResidue)rs2)) {
                return false;
            }
            ++i;
        }
        targetList = target.getListOfPluginBindingRegion();
        myList = this.getListOfBindingRegiones();
        if (targetList.size() != myList.size()) {
            return false;
        }
        i = 0;
        while (i < myList.size()) {
            rs1 = (BindingRegion)myList.get(i);
            rs2 = null;
            k = 0;
            while (k < targetList.size()) {
                rs = (PluginBindingRegion)targetList.get(k);
                if (rs1.getId().equals(((PluginBindingRegion)rs).getId()) && rs1.getAnnotationString() != null && rs1.getAnnotationString().equals(rs.getAnnotationString())) {
                    rs2 = rs;
                    break;
                }
                ++k;
            }
            if (rs2 == null) {
                return false;
            }
            if (!rs1.equals((PluginBindingRegion)rs2)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public void addReference(SpeciesAlias alias) {
        this.referedSpeciesAliases.add(alias);
    }

    @Override
    public void removeReference(SpeciesAlias alias) {
        this.referedSpeciesAliases.remove(alias);
    }

    @Override
    public boolean hasReferences() {
        return this.referedSpeciesAliases.size() > 0;
    }

    @Override
    public Vector getReferences() {
        return (Vector)this.referedSpeciesAliases.clone();
    }

    @Override
    public void setName(String name) {
        this.name = name == null ? "" : name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setType(String type) {
        this.type = type == null ? "GENERIC" : (type.equals("") ? "GENERIC" : type);
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void clear() {
        int i = 0;
        while (i < 3) {
            if (this.lists[i] != null) {
                this.lists[i].clear();
            }
            ++i;
        }
    }

    public Vector getList(int list_const) {
        if (list_const < 0 || list_const >= 3) {
            return null;
        }
        return this.lists[list_const];
    }

    public Vector getListOfModificationResidues() {
        return this.lists[0];
    }

    public Vector getListOfBindingRegiones() {
        return this.lists[1];
    }

    public Vector getListOfStructuralStates() {
        return this.lists[2];
    }

    public static String getListTagName(int list_const) {
        if (list_const < 0 || list_const >= 3) {
            return "";
        }
        return "celldesigner:" + nospaceListTagName[list_const];
    }

    public static String getElementTagName(int list_const) {
        if (list_const < 0 || list_const >= 3) {
            return "";
        }
        return "celldesigner:" + nospaceElementTagName[list_const];
    }

    public static String getElementClassName(int list_const) {
        if (list_const < 0 || list_const >= 3) {
            return "";
        }
        return elementClassName[list_const];
    }

    protected String getTagName(SpecInfo spec) {
        return "celldesigner:protein";
    }

    protected String[] getAttributeNames(SpecInfo spec) {
        return new String[]{"id", "type", "name"};
    }

    protected String[] getAttributeShortNames() {
        return new String[]{"id", "type", "name"};
    }

    protected int[] getAttributeColumnSizes() {
        return new int[]{40, 120, 200};
    }

    protected String[] getAttributeValues(SpecInfo spec) {
        return new String[]{this.getId(), this.getType(), this.getName()};
    }

    protected String[] getDefaultValues(SpecInfo spec) {
        Protein initialProtein = new Protein();
        return initialProtein.getAttributeValues(spec);
    }

    protected void setAttributeValues(String[] values, SpecInfo spec) throws Exception {
        this.initAttributes();
        if (!values[0].equals("")) {
            SId.check(values[0]);
            super.setId(values[0]);
        }
        if (!values[1].equals("")) {
            this.setType(values[1]);
        }
        if (!values[2].equals("")) {
            this.setName(values[2]);
        }
    }

    protected void releaseAllMembers() {
        this.clear();
        int i = 0;
        while (i < 3) {
            this.lists[i] = null;
            ++i;
        }
    }

    protected boolean hasChildNodes() {
        return true;
    }

    public void readChildNodesDOMTree(Element element, SpecInfo spec) throws Exception {
        String URI2 = element.getNamespaceURI();
        NodeList childlist = element.getChildNodes();
        int childsize = childlist.getLength();
        String packageName = this.getClass().getPackage().getName();
        int i = 0;
        while (i < 3) {
            Node listNode = null;
            int j = 0;
            while (j < childsize) {
                Node temp = childlist.item(j);
                if (temp.getNodeType() == 1 && temp.getNamespaceURI().equals(URI2) && temp.getLocalName().equals(nospaceListTagName[i])) {
                    listNode = temp;
                }
                ++j;
            }
            if (listNode != null && this.lists[i] != null) {
                Vector list = this.lists[i];
                String className = elementClassName[i];
                String tagName = nospaceElementTagName[i];
                NodeList children = listNode.getChildNodes();
                int j2 = 0;
                while (j2 < children.getLength()) {
                    block10: {
                        Node n = children.item(j2);
                        if (n.getNodeType() == 1 && n.getNamespaceURI().equals(URI2) && n.getLocalName().equals(tagName)) {
                            SBase sbase;
                            try {
                                sbase = (SBase)Class.forName(String.valueOf(packageName) + "." + className).newInstance();
                            }
                            catch (ClassNotFoundException ce) {
                                DebugPrinter.println(1, "Protein-readingList-ClassNotFound for <" + tagName + ">: " + ce.getMessage() + ", skip");
                                break block10;
                            }
                            try {
                                LibSBMLUtil.readDOMTree(sbase, (Element)n, spec);
                            }
                            catch (Exception e) {
                                DebugPrinter.println(1, "Protein-readingList-catch reading < " + tagName + "> : " + e.getMessage() + ", skip");
                                break block10;
                            }
                            list.add(sbase);
                        }
                    }
                    ++j2;
                }
            }
            ++i;
        }
    }

    protected void writeChildNodesDOMTree(Node node, SpecInfo spec) throws Exception {
        Document doc = node.getOwnerDocument();
        String URI2 = node.getNamespaceURI();
        int listCount = 3;
        int i = 0;
        while (i < listCount) {
            if (this.lists[i] != null) {
                Vector list = this.lists[i];
                String tagName = "celldesigner:" + nospaceListTagName[i];
                if (list.size() > 0) {
                    Element elem = doc.createElementNS(URI2, tagName);
                    node.appendChild(elem);
                    int j = 0;
                    while (j < list.size()) {
                        SBase sBase = (SBase)list.get(j);
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    public static void updateAnnotation(StringBuffer buf, Protein p) {
        if (p.getListOfModificationResidues() == null && p.getListOfModificationResidues().size() == 0 && p.getListOfBindingRegiones() == null && p.getListOfBindingRegiones().size() == 0) {
            buf.append("<celldesigner:protein id=\"" + p.getId() + "\" name=\"" + StringTool.toEscape(p.getName()) + "\" type=\"" + p.getType() + "\"");
            if (p.getNotes() != null && !p.getNotesString().equals("")) {
                buf.append(">\n");
                buf.append("<celldesigner:notes>\n");
                buf.append("<html xmlns=\"http://www.w3.org/1999/xhtml\">\n");
                buf.append("<head> <title/> </head>\n");
                buf.append("<!--Notes by CellDesigner-->\n");
                buf.append("<body>\n");
                Notes note = (Notes)LibSBMLUtil.getNotes((SBase)p, null);
                buf.append(String.valueOf(StringTool.toEscape(StringTool.toNonEscape(note.getText()))) + "\n");
                buf.append("</body>\n");
                buf.append("</html>\n");
                buf.append("</celldesigner:notes>\n");
                buf.append("</celldesigner:protein>\n");
            } else {
                buf.append("/>\n");
            }
        } else {
            StringBuffer bufBindingRegiones;
            StringBuffer bufRediues;
            buf.append("<celldesigner:protein id=\"" + p.getId() + "\" name=\"" + StringTool.toEscape(p.getName()) + "\" type=\"" + p.getType() + "\">\n");
            if (p.getNotes() != null && !p.getNotesString().equals("")) {
                buf.append("<celldesigner:notes>\n");
                buf.append("<html xmlns=\"http://www.w3.org/1999/xhtml\">\n");
                buf.append("<head> <title/> </head>\n");
                buf.append("<!--Notes by CellDesigner-->\n");
                buf.append("<body>\n");
                Notes note = (Notes)LibSBMLUtil.getNotes((SBase)p, null);
                buf.append(String.valueOf(StringTool.toEscape(StringTool.toNonEscape(note.getText()))) + "\n");
                buf.append("</body>\n");
                buf.append("</html>\n");
                buf.append("</celldesigner:notes>\n");
            }
            if ((bufRediues = Protein.getRediues(p)).toString().length() > 0) {
                buf.append("<celldesigner:listOfModificationResidues>\n");
                buf.append(bufRediues);
                buf.append("</celldesigner:listOfModificationResidues>\n");
            }
            if ((bufBindingRegiones = Protein.getBindingRegiones(p)).toString().length() > 0) {
                buf.append("<celldesigner:listOfBindingRegions>\n");
                buf.append(bufBindingRegiones);
                buf.append("</celldesigner:listOfBindingRegions>\n");
            }
            buf.append("</celldesigner:protein>\n");
        }
    }

    private static StringBuffer getRediues(Protein p) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < p.getListOfModificationResidues().size()) {
            ModificationResidue res = (ModificationResidue)p.getListOfModificationResidues().get(i);
            buf.append("<celldesigner:modificationResidue angle=\"" + res.getAngle() + "\" id=\"" + res.getId() + "\" name=\"" + StringTool.toEscape(res.getName()) + "\" side=\"" + res.getSide() + "\"/>\n");
            ++i;
        }
        return buf;
    }

    private static StringBuffer getBindingRegiones(Protein p) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < p.getListOfBindingRegiones().size()) {
            BindingRegion br = (BindingRegion)p.getListOfBindingRegiones().get(i);
            buf.append("<celldesigner:bindingRegion angle=\"" + br.getAngle() + "\" id=\"" + br.getId() + "\" name=\"" + StringTool.toEscape(br.getName()) + "\" size=\"" + br.getSize() + "\"/>\n");
            ++i;
        }
        return buf;
    }
}

