/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.sbmlExtension;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jp.sbi.sbml.util.LibSBMLUtil;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.XMLNode;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Notes
extends jp.sbi.sbml.Notes {
    private static final String CellDesignersNotesDeclaration = "Notes by CellDesigner";
    private static final String xhtmlHints = "Hints for the correct XHTML: \nCharacters \"&\", \"<\"(not for tags), and \">\"(not for tags) should be written as \"&amp;\", \"&lt;\", and \"&gt;\" respectively.\nOther issues related to XHTML tags and attributes are found in the XHTML 1.0 specification at http://www.w3.org/TR/xhtml1/.";
    private String otherText = "";

    @Override
    public boolean hasValue() {
        return !this.text.equals("") || !this.otherText.equals("");
    }

    @Override
    public void readDOMTree(Element element) throws Exception {
        Node temp;
        String URI2 = element.getNamespaceURI();
        NodeList childlist = element.getChildNodes();
        int childsize = childlist.getLength();
        Node listNode = null;
        boolean existElement = false;
        int j = 0;
        while (j < childsize) {
            temp = childlist.item(j);
            if (temp.getNodeType() == 1) {
                existElement = true;
                if (temp.getNamespaceURI().equals("http://www.w3.org/1999/xhtml") && temp.getLocalName() == "html") {
                    Element elem = (Element)temp;
                    listNode = temp;
                }
            }
            ++j;
        }
        if (existElement) {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            int j2 = 0;
            while (j2 < childsize) {
                Node temp2 = childlist.item(j2);
                if (temp2.getNodeType() == 1) {
                    Element tempelem = (Element)temp2;
                    Node serializedNode = null;
                    if (temp2 == listNode) {
                        NodeList bodyelem = tempelem.getElementsByTagNameNS("http://www.w3.org/1999/xhtml", "body");
                        serializedNode = bodyelem.item(0);
                    } else {
                        serializedNode = temp2;
                    }
                    DOMSource domsrc = new DOMSource(serializedNode);
                    StringWriter sw = new StringWriter();
                    transformer.transform(domsrc, new StreamResult(sw));
                    String serialized = sw.toString();
                    serialized = serialized.replaceFirst("<\\?[^<]*?<", "<");
                    if (temp2 == listNode) {
                        serialized = serialized.replaceFirst("<body>\\s*", "");
                        serialized = serialized.replaceFirst("</body>\\s*", "");
                        this.text = serialized.trim();
                        serialized = serialized.replaceFirst("<body xmlns=\"http://www.w3.org/1999/xhtml\"\\s*/>", "");
                        serialized = serialized.replaceFirst("<body xmlns=\"http://www.w3.org/1999/xhtml\">", "");
                        serialized = serialized.replaceFirst("</body>\\s*", "");
                        serialized = serialized.replaceAll("\\s+<br/>", "<br/>");
                        serialized = serialized.replaceAll("\\s+<a", "<a");
                        this.text = serialized.trim();
                    } else {
                        this.otherText = String.valueOf(this.otherText) + serialized.trim();
                    }
                }
                ++j2;
            }
        } else {
            j = 0;
            while (j < childsize) {
                temp = childlist.item(j);
                if (temp.getNodeType() == 3) {
                    listNode = temp;
                    break;
                }
                ++j;
            }
            if (listNode != null) {
                this.text = listNode.getNodeValue();
            }
        }
    }

    @Override
    public String readDOMTreeReturnString(Element element) throws Exception {
        Node temp;
        String URI2 = element.getNamespaceURI();
        NodeList childlist = element.getChildNodes();
        int childsize = childlist.getLength();
        Node listNode = null;
        boolean existElement = false;
        int j = 0;
        while (j < childsize) {
            temp = childlist.item(j);
            if (temp.getNodeType() == 1) {
                existElement = true;
                if (temp.getNamespaceURI().equals("http://www.w3.org/1999/xhtml") && temp.getLocalName() == "html") {
                    Element elem = (Element)temp;
                    NodeList childs = elem.getChildNodes();
                    int k = 0;
                    while (k < childs.getLength()) {
                        Node nn = childs.item(k);
                        if (nn.getNodeType() == 8 && nn.getNodeValue().equals(CellDesignersNotesDeclaration)) {
                            listNode = temp;
                            break;
                        }
                        ++k;
                    }
                }
            }
            ++j;
        }
        if (existElement) {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            int j2 = 0;
            while (j2 < childsize) {
                Node temp2 = childlist.item(j2);
                if (temp2.getNodeType() == 1) {
                    Element tempelem = (Element)temp2;
                    Node serializedNode = null;
                    if (temp2 == listNode) {
                        NodeList bodyelem = tempelem.getElementsByTagNameNS("http://www.w3.org/1999/xhtml", "body");
                        serializedNode = bodyelem.item(0);
                    } else {
                        serializedNode = temp2;
                    }
                    DOMSource domsrc = new DOMSource(serializedNode);
                    StringWriter sw = new StringWriter();
                    transformer.transform(domsrc, new StreamResult(sw));
                    String serialized = sw.toString();
                    serialized = serialized.replaceFirst("<\\?[^<]*?<", "<");
                    if (temp2 == listNode) {
                        serialized = serialized.replaceFirst("<body>\\s*", "");
                        serialized = serialized.replaceFirst("</body>\\s*", "");
                        this.text = serialized.trim();
                    } else {
                        this.otherText = String.valueOf(this.otherText) + serialized.trim();
                    }
                }
                ++j2;
            }
        } else {
            j = 0;
            while (j < childsize) {
                temp = childlist.item(j);
                if (temp.getNodeType() == 3) {
                    listNode = temp;
                    break;
                }
                ++j;
            }
            if (listNode != null) {
                this.text = listNode.getNodeValue();
            }
        }
        return this.otherText;
    }

    @Override
    public void writeDOMTree(Node node) throws Exception {
        Document doc = node.getOwnerDocument();
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        if (!this.text.equals("")) {
            bw.write("<html xmlns=\"http://www.w3.org/1999/xhtml\">");
            bw.newLine();
            bw.write("<head> <title/> </head>\n");
            bw.newLine();
            bw.write("<!--Notes by CellDesigner-->");
            bw.newLine();
            bw.write("<body>");
            bw.newLine();
            bw.write(this.text.trim());
            bw.newLine();
            bw.write("</body>");
            bw.newLine();
            bw.write("</html>");
            bw.newLine();
        }
        if (!this.otherText.equals("")) {
            bw.write(this.otherText.trim());
            bw.newLine();
        }
        bw.flush();
        DocumentFragment docfrag = null;
        String fragment = "<fragments>" + sw.toString() + "</fragments>";
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Document d = factory.newDocumentBuilder().parse(new InputSource(new StringReader(fragment)));
            Node fnode = doc.importNode(d.getDocumentElement(), true);
            docfrag = doc.createDocumentFragment();
            while (fnode.hasChildNodes()) {
                docfrag.appendChild(fnode.removeChild(fnode.getFirstChild()));
            }
        }
        catch (SAXException e) {
            String errorMsg = "Invalid Notes text: (Notes text should be XHTML elements.)\n" + e.getMessage();
            throw new Exception(String.valueOf(errorMsg) + "\n" + xhtmlHints);
        }
        catch (ParserConfigurationException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        node.appendChild(docfrag);
    }

    public void mergeText(String text) {
        super.setText(text);
        this.otherText = "";
    }

    @Override
    public jp.sbi.sbml.Notes createCopy() {
        return (Notes)this.clone();
    }

    @Override
    public Object clone() {
        Notes n = new Notes();
        n.setText(this.text);
        n.setOtherText(this.otherText);
        return n;
    }

    private void setOtherText(String otherText) {
        this.otherText = otherText;
    }

    public void copyContentsOf(Notes n) {
        this.setText(n.text);
        this.setOtherText(n.otherText);
    }

    @Override
    public void updateNotes(SBase sbase) {
        sbase.setNotes(this.getCDNotes(sbase));
    }

    @Override
    public XMLNode getCDNotes(SBase sbase) {
        if (sbase == null) {
            return null;
        }
        XMLNode cdnotes = super.getCDNotes(sbase);
        if (this.otherText != null && !this.otherText.equals("")) {
            XMLNode other_xn = XMLNode.convertStringToXMLNode((String)this.otherText);
            if (other_xn == null) {
                return cdnotes;
            }
            if (cdnotes == null) {
                StringBuffer buf = new StringBuffer();
                buf.append("<notes>");
                buf.append("<html xmlns=\"http://www.w3.org/1999/xhtml\">");
                buf.append("<head> <title/> </head>\n");
                buf.append("<!--Notes by CellDesigner-->");
                buf.append("<body>\n");
                buf.append("</body>");
                buf.append("</html>");
                buf.append("</notes>");
                cdnotes = XMLNode.convertStringToXMLNode((String)buf.toString());
            }
            LibSBMLUtil.mergeNotesToCDNotes(other_xn, cdnotes);
            sbase.setNotes(cdnotes);
            sbase.setNotes(XMLNode.convertXMLNodeToString((XMLNode)cdnotes));
            this.setOtherText("");
        }
        return cdnotes;
    }
}

