/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.sbmlExtension;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import jp.fric.graphics.draw.GColor;
import jp.fric.graphics.draw.GUtil;
import jp.sbi.celldesigner.Preference;
import jp.sbi.celldesigner.SBSymbol;
import jp.sbi.celldesigner.SpeciesSymbol;
import jp.sbi.celldesigner.sbmlExtension.BindingRegion;
import jp.sbi.celldesigner.sbmlExtension.Modification;
import jp.sbi.celldesigner.sbmlExtension.ModificationImpl;
import jp.sbi.celldesigner.sbmlExtension.ModificationRegion;
import jp.sbi.celldesigner.sbmlExtension.ModificationResidue;
import jp.sbi.celldesigner.sbmlExtension.SameIDAutoTag;
import jp.sbi.celldesigner.sbmlExtension.StructuralState;
import jp.sbi.celldesigner.symbol.species.IonChannel;
import jp.sbi.celldesigner.symbol.species.SpeciesSymbolImpl;

public class ModificationShape {
    private SpeciesSymbol symbol = null;
    private Modification modification = null;
    private ModificationResidue residue = null;
    private ModificationRegion region = null;
    private BindingRegion bindingRegion = null;
    private StructuralState structuralState = null;
    private ModificationImpl modificationIns = null;
    private SameIDAutoTag autoTag = null;
    private Rectangle2D.Double rectAutoTag = null;
    public static final double R = 8.0;
    public static final double H = 8.0;
    Ellipse2D.Double ellipse = new Ellipse2D.Double();
    Ellipse2D.Double ellipse2 = new Ellipse2D.Double();
    Rectangle2D.Double rect = new Rectangle2D.Double();
    Polygon tri_start = new Polygon();
    Point2D.Double triPoint1 = new Point2D.Double();
    Point2D.Double triPoint2 = new Point2D.Double();
    Point2D.Double triPoint3 = new Point2D.Double();
    Font font = null;
    Font fontOutside = null;
    public static String DEFAULT_FONTNAME = "Times New Roman";
    private static String CODINGREGION_SBGN = "ct:coding";
    private static String REGULATORYREGION_SBGN = "ct:regulatory";
    private static String TRANSCRIPTIONSTARTINGSITEL_SBGN = "ct:tssL";
    private static String TRANSCRIPTIONSTARTINGSITER_SBGN = "ct:tssR";
    private static String PROTEINBINDINGDOMAIN_SBGN = "ct:proteinBindingDomain";
    private static String PHOSPHORYLATED_SBGN = "P";
    private static String ACETYLATED_SBGN = "Ac";
    private static String METHYLATED_SBGN = "Me";
    private static String DONT_CARE_SBGN = "*";
    private static String UNKNOWN_SBGN = "?";
    private static String UBIQUITINATED_SBGN = "Ub";
    private static String HYDROXYLATED_SBGN = "OH";
    private static String GLYCOSYLATED_SBGN = "G";
    private static String MYRISTOYLATED_SBGN = "My";
    private static String PALMYTOYLATED_SBGN = "Pa";
    private static String PRENYLATED_SBGN = "Pr";
    private static String PROTONATED_SBGN = "H";
    private static String SULFATED_SBGN = "S";
    private static String EMPTY_SBGN = "";
    private static String BINDINGREGION_SBGN = "&nbsp&nbsp&nbsp&nbsp";
    Point2D.Double dif = null;
    protected static Color COLOR_SOLO_HIGHLIGHT = GColor.navy;
    protected static Color COLOR_SOLO_NORMAL = Color.black;
    private boolean isSoloHighlighted = false;
    private Rectangle2D.Double namePaintBounds = null;
    private Rectangle2D.Double monoShapeNameImageBounds = null;

    public ModificationShape() {
        this.rectAutoTag = new Rectangle2D.Double();
    }

    public void setSpeciesSymbol(SpeciesSymbol symbol) {
        this.symbol = symbol;
    }

    public void setModificationResidue(ModificationResidue residue) {
        this.residue = residue;
        if (residue != null) {
            this.modificationIns = residue;
        }
    }

    public void setBindingRegion(BindingRegion bindingRegion) {
        this.bindingRegion = bindingRegion;
        if (bindingRegion != null) {
            this.modificationIns = bindingRegion;
        }
    }

    public void setModificationRegion(ModificationRegion region) {
        this.region = region;
        if (region != null) {
            this.modificationIns = region;
        }
    }

    public void setStructuralState(StructuralState structuralState) {
        this.structuralState = structuralState;
        if (structuralState != null) {
            this.modificationIns = structuralState;
        }
    }

    public void setModification(Modification modification) {
        this.modification = modification;
    }

    public ModificationResidue getModificationResidue() {
        return this.residue;
    }

    public BindingRegion getBindingRegion() {
        return this.bindingRegion;
    }

    public ModificationRegion getModificationRegion() {
        return this.region;
    }

    public Modification getModification() {
        return this.modification;
    }

    public StructuralState getStructuralState() {
        return this.structuralState;
    }

    public boolean inShape(double x, double y) {
        if (this.region != null) {
            if (this.region.getType().equals("RegulatoryRegion") || this.region.getType().equals("CodingRegion")) {
                return this.rect.contains(x, y);
            }
            if (this.region.getType().equals("Modification Site")) {
                if (((SpeciesSymbolImpl)this.symbol).isInSBGNViewer()) {
                    return this.rect.contains(x, y);
                }
                if ((int)x == (int)this.ellipse.getCenterX() && (int)y <= (int)(this.ellipse.getY() + this.ellipse.getHeight() + 8.0) && (int)y >= (int)(this.ellipse.getY() + this.ellipse.getHeight())) {
                    return true;
                }
                if (this.modification.getState() == "histone2") {
                    return this.ellipse.contains(x, y) || this.ellipse2.contains(x, y);
                }
                return this.ellipse.contains(x, y);
            }
            if (this.region.getType().equals("transcriptionStartingSiteL") || this.region.getType().equals("transcriptionStartingSiteR")) {
                if (this.getTriangle(this.region.getType()).contains(x, y)) {
                    return true;
                }
                return this.rect.contains(x, y);
            }
            return this.rect.contains(x, y);
        }
        if (this.bindingRegion != null) {
            return this.rect.contains(x, y);
        }
        if (this.autoTag != null) {
            return this.rectAutoTag.contains(x, y);
        }
        return this.ellipse.contains(x, y);
    }

    public void setSoloHighlighted(boolean isSoloHighlighted) {
        this.isSoloHighlighted = isSoloHighlighted;
    }

    public boolean isSoloHighlighted() {
        return this.isSoloHighlighted;
    }

    public Rectangle2D.Double getCircleBounds() {
        if (this.region != null) {
            if (this.region.getType().equals("RegulatoryRegion") || this.region.getType().equals("CodingRegion")) {
                return new Rectangle2D.Double(this.rect.getX(), this.rect.getY(), this.rect.getWidth(), this.rect.getHeight());
            }
            if (this.region.getType().equals("Modification Site")) {
                if (((SpeciesSymbolImpl)this.symbol).isInSBGNViewer()) {
                    return new Rectangle2D.Double(this.rect.getX(), this.rect.getY(), this.rect.getWidth(), this.rect.getHeight());
                }
                if (this.modification.getState() == "histone2") {
                    return new Rectangle2D.Double(this.ellipse.getX(), this.ellipse2.getY(), this.ellipse2.getWidth() + this.ellipse2.getX() - this.ellipse.getX(), this.ellipse.getHeight() + this.ellipse.getY() - this.ellipse2.getY() + 8.0);
                }
                return new Rectangle2D.Double(this.ellipse.getX(), this.ellipse.getY(), this.ellipse.getWidth(), this.ellipse.getHeight() + 8.0);
            }
            if (this.region.getType().equals("transcriptionStartingSiteL") || this.region.getType().equals("transcriptionStartingSiteR")) {
                return new Rectangle2D.Double(this.rect.getX(), this.rect.getY() - 4.8, this.rect.getWidth(), this.rect.getHeight() + 4.8);
            }
            return new Rectangle2D.Double(this.rect.getX(), this.rect.getY(), this.rect.getWidth(), this.rect.getHeight());
        }
        if (this.bindingRegion != null) {
            return new Rectangle2D.Double(this.rect.getX(), this.rect.getY(), this.rect.getWidth(), this.rect.getHeight());
        }
        if (this.autoTag != null) {
            return (Rectangle2D.Double)this.rectAutoTag.clone();
        }
        return new Rectangle2D.Double(this.ellipse.getX(), this.ellipse.getY(), this.ellipse.getWidth(), this.ellipse.getHeight());
    }

    public Rectangle2D.Double updateCircleBounds() {
        if (this.symbol == null || this.residue == null && this.region == null && this.structuralState == null && this.bindingRegion == null && this.autoTag == null) {
            return null;
        }
        if (this.structuralState != null) {
            return this.updateCircleBounds(this.symbol);
        }
        if (this.region != null) {
            Rectangle2D.Double bounds = this.symbol.getSymbolBounds();
            double x = bounds.x + bounds.width * this.region.getPos();
            double y = bounds.y;
            double w = bounds.width * this.region.getSize();
            Point2D.Double[] edgePoints = this.symbol.getEdgePoints();
            if (this.symbol.isGene()) {
                double range = edgePoints[2].x - edgePoints[0].x;
                x = edgePoints[0].x + range * this.region.getPos();
                y = edgePoints[0].y;
                w = range * this.region.getSize();
            } else if (this.symbol.isRNA() && !((SpeciesSymbolImpl)this.symbol).isInSBGNViewer()) {
                double range = edgePoints[6].x - edgePoints[0].x;
                x = edgePoints[0].x + range * this.region.getPos();
                y = edgePoints[0].y;
                w = range * this.region.getSize();
            } else if (this.symbol.isAntiSenseRNA() && !((SpeciesSymbolImpl)this.symbol).isInSBGNViewer()) {
                double range = edgePoints[6].x - edgePoints[0].x;
                x = edgePoints[0].x + range * this.region.getPos();
                y = edgePoints[0].y;
                w = range * this.region.getSize();
            }
            if (this.region.getType().equals("RegulatoryRegion") || this.region.getType().equals("CodingRegion") || this.region.getType().equals("proteinBindingDomain")) {
                this.rect.setFrame(x, y - 8.0, w, 16.0);
                return new Rectangle2D.Double(this.rect.getX(), this.rect.getY(), this.rect.getWidth(), this.rect.getHeight());
            }
            if (this.region.getType().equals("Modification Site")) {
                this.ellipse.setFrame(x - 8.0, y - 24.0, 16.0, 16.0);
                this.ellipse2.setFrame(x + 4.0 - 8.0, y - 4.0 - 24.0, 16.0, 16.0);
                if (((SpeciesSymbolImpl)this.symbol).isInSBGNViewer()) {
                    if (x + 17.6 >= this.symbol.getSymbolBounds().getMaxX()) {
                        this.rect.setFrame(this.symbol.getSymbolBounds().getMaxX() - 16.0, y - 8.0, 17.6, 16.0);
                        return new Rectangle2D.Double(this.rect.getX(), this.rect.getY(), this.rect.getWidth(), this.rect.getHeight());
                    }
                    this.rect.setFrame(x, y - 8.0, 17.6, 16.0);
                    return new Rectangle2D.Double(this.rect.getX(), this.rect.getY(), this.rect.getWidth(), this.rect.getHeight());
                }
                if (this.modification.getState() == "histone2") {
                    return new Rectangle2D.Double(x - 8.0, y - 4.0 - 24.0, this.ellipse2.getWidth() + this.ellipse2.getX() - this.ellipse.getX(), this.ellipse.getHeight() + this.ellipse.getY() - this.ellipse2.getY());
                }
                return new Rectangle2D.Double(x - 8.0, y - 24.0, 16.0, 16.0);
            }
            if (this.region.getType().equals("transcriptionStartingSiteL") || this.region.getType().equals("transcriptionStartingSiteR")) {
                if (((SpeciesSymbolImpl)this.symbol).isInSBGNViewer()) {
                    this.rect.setFrame(x, y - 8.0, w, 16.0);
                    return new Rectangle2D.Double(this.rect.getX(), this.rect.getY(), this.rect.getWidth(), this.rect.getHeight());
                }
                this.rect.setFrame(x, y - 16.0, w, 16.0);
                return new Rectangle2D.Double(this.rect.getX(), this.rect.getY(), this.rect.getWidth(), this.rect.getHeight());
            }
            this.rect.setFrame(x, y - 8.0, w, 16.0);
            this.tri_start.reset();
            if (this.region.getType().equals("transcriptionStartingSiteL")) {
                this.triPoint1.setLocation(this.rect.getX() + 16.0, y);
                this.triPoint2.setLocation(this.rect.getX(), this.rect.getY());
                this.triPoint3.setLocation(this.rect.getX(), this.rect.getY() + this.rect.getHeight());
            }
            if (this.region.getType().equals("transcriptionStartingSiteR")) {
                this.triPoint1.setLocation(this.rect.getX() + this.rect.getWidth() - 16.0, y);
                this.triPoint2.setLocation(this.rect.getX() + this.rect.getWidth(), this.rect.getY());
                this.triPoint3.setLocation(this.rect.getX() + this.rect.getWidth(), this.rect.getY() + this.rect.getHeight());
            }
            this.tri_start.addPoint((int)this.triPoint1.x, (int)this.triPoint1.y);
            this.tri_start.addPoint((int)this.triPoint2.x, (int)this.triPoint2.y);
            this.tri_start.addPoint((int)this.triPoint3.x, (int)this.triPoint3.y);
            this.tri_start.addPoint((int)this.triPoint1.x, (int)this.triPoint1.y);
            return new Rectangle2D.Double(this.rect.getX(), this.rect.getY(), this.rect.getWidth(), this.rect.getHeight());
        }
        double angle = 0.0;
        if (this.residue != null) {
            angle = this.residue.getAngle();
        }
        if (this.bindingRegion != null && "binding region".equals(this.bindingRegion.getType())) {
            angle = this.bindingRegion.getAngle();
        }
        if (this.autoTag != null) {
            angle = this.autoTag.getAngle();
        }
        double realAngle = angle;
        Rectangle2D.Double bounds = this.symbol.getSymbolBounds();
        if (((SBSymbol)((Object)this.symbol)).getCode().equals("ION_CHANNEL")) {
            bounds = !((SpeciesSymbolImpl)this.symbol).isInSBGNViewer() ? (0.0 <= angle && angle < 0.7853981633974483 || 5.497787143782138 <= angle && angle <= Math.PI * 2 ? ((IonChannel)this.symbol).getRightBounds() : ((IonChannel)this.symbol).getLeftBounds()) : ((IonChannel)this.symbol).getModificatinSBGNViewerBounds();
        }
        angle = this.getRealAngle(angle);
        double x = bounds.x + bounds.width / 2.0;
        double y = bounds.y + bounds.height / 2.0;
        this.dif = this.createDif(angle);
        double dx = this.dif.x;
        double dy = this.dif.y;
        while (this.symbol.inInner(x, y)) {
            x += dx;
            y += dy;
        }
        if (this.bindingRegion != null) {
            this.setRec(realAngle, this.dif, x, y);
            return new Rectangle2D.Double(this.rect.getX(), this.rect.getY(), this.rect.getWidth(), this.rect.getHeight());
        }
        if (this.autoTag != null) {
            return (Rectangle2D.Double)this.autoTag.buildShapeUsingCenterPoint(x, y).clone();
        }
        this.ellipse.setFrame(x - 8.0, y - 8.0, 16.0, 16.0);
        return new Rectangle2D.Double(x - 8.0, y - 8.0, 16.0, 16.0);
    }

    private Graphics2D getGraphics2D() {
        BufferedImage img = new BufferedImage(1, 1, 1);
        Graphics2D g2 = img.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (this.fontOutside == null) {
            String family = g2.getFont().getFamily();
            this.fontOutside = new Font(family, 0, 10);
        }
        g2.setFont(this.fontOutside);
        return g2;
    }

    public Rectangle2D.Double getNameBounds(Rectangle2D.Double nameImageBounds) {
        Graphics2D g2 = this.getGraphics2D();
        return this.getNameBounds(nameImageBounds, g2);
    }

    public Rectangle2D.Double getNameBounds(Rectangle2D.Double nameImageBounds, Graphics2D g2) {
        if (this.symbol == null || this.residue == null && this.region == null && this.structuralState == null && this.bindingRegion == null && this.autoTag == null) {
            return null;
        }
        if (g2 == null) {
            g2 = this.getGraphics2D();
        }
        this.monoShapeNameImageBounds = nameImageBounds;
        Rectangle2D.Double circleBounds = this.getCircleBounds();
        Ellipse2D.Double ellipseBounds = new Ellipse2D.Double();
        ellipseBounds.setFrame(circleBounds.x, circleBounds.y, circleBounds.width, circleBounds.height);
        this.namePaintBounds = this.modificationIns.getNameBounds(this, g2, ellipseBounds, this.rect);
        return this.namePaintBounds;
    }

    private void setRec(double angle, Point2D.Double dif, double oldX0, double oldY0) {
        Rectangle2D.Double bounds = this.symbol.getSymbolBounds();
        double x0 = bounds.x;
        double y0 = bounds.y;
        double x = dif.x;
        double y = dif.y;
        double w = bounds.width;
        double h = bounds.height;
        double dAngle = 0.0;
        double newW = bounds.width * this.bindingRegion.getSize();
        double k = 2.4285714285714284;
        String symbolCode = ((SBSymbol)((Object)this.symbol)).getCode();
        if (symbolCode.equals("TRUNCATED") && !((SpeciesSymbolImpl)this.symbol).isInSBGNViewer()) {
            if (angle >= 0.7853981633974483 && angle < 1.5707963267948966) {
                dAngle = 0.25;
                x = x0 + w / 2.0 + w * 0.5 * (1.5707963267948966 - angle) / (dAngle * Math.PI);
                y = y0;
                this.rect.setFrame(x - newW / 2.0, y - 8.0, newW, 16.0);
            } else if (angle >= 1.5707963267948966 && angle < 2.356194490192345) {
                dAngle = 0.25;
                x = x0 + w * 0.5 * (2.356194490192345 - angle) / (dAngle * Math.PI);
                y = y0;
                this.rect.setFrame(x - newW / 2.0, y - 8.0, newW, 16.0);
            } else if (angle >= 2.356194490192345 && angle < 3.9269908169872414) {
                newW = bounds.getHeight() * this.bindingRegion.getSize() * k;
                dAngle = 0.5;
                x = x0;
                y = y0 + h * (angle - 2.356194490192345) / (dAngle * Math.PI);
                if (newW > h) {
                    newW = h;
                }
                this.rect.setFrame(x - 8.0, y - newW / 2.0, 16.0, newW);
            } else if (angle >= 3.9269908169872414 && angle < 4.71238898038469) {
                dAngle = 0.25;
                x = x0 + w / 2.0 - w * 0.5 * (4.71238898038469 - angle) / (dAngle * Math.PI);
                y = y0 + h;
                this.rect.setFrame(x - newW / 2.0, y - 8.0, newW, 16.0);
            } else if (angle >= 4.71238898038469 && angle < 5.183627878423159) {
                dAngle = 0.1499999999999999;
                x = x0 + w * 0.8 - w * 0.5 * 0.6 * (5.183627878423159 - angle) / (dAngle * Math.PI);
                y = y0 + h;
                this.rect.setFrame(x - newW / 2.0, y - 8.0, newW, 16.0);
            } else if (angle >= 5.183627878423159) {
                newW = bounds.getHeight() * this.bindingRegion.getSize() * k;
                dAngle = 0.3500000000000001;
                x = x0 + w / 2.0 + w * 0.5 * 0.6;
                y = y0 + h - h * 0.47 * (angle - 5.183627878423159) / (dAngle * Math.PI);
                if (newW > h * 0.6) {
                    newW = h * 0.6;
                }
                this.rect.setFrame(x - 8.0, y - newW / 2.0, 16.0, newW);
            } else if (angle <= 0.7853981633974483) {
                newW = bounds.getHeight() * this.bindingRegion.getSize() * k;
                dAngle = 0.25;
                x = x0 + w;
                y = y0 + h * 0.48 * (0.7853981633974483 - angle) / (dAngle * Math.PI);
                if (newW > h * 0.6) {
                    newW = h * 0.6;
                }
                this.rect.setFrame(x - 8.0, y - newW / 2.0, 16.0, newW);
            }
        } else if (symbolCode.equals("RECEPTOR") && !((SpeciesSymbolImpl)this.symbol).isInSBGNViewer()) {
            if (angle >= 0.7853981633974483 && angle < 1.5707963267948966) {
                dAngle = 0.25;
                x = x0 + w / 2.0 + w * 0.5 * (1.5707963267948966 - angle) / (dAngle * Math.PI);
                y = y0 + h * 0.2 * (angle - 0.7853981633974483) / (dAngle * Math.PI);
                this.rect.setFrame(x - newW / 2.0, y - 8.0, newW, 16.0);
            } else if (angle >= 1.5707963267948966 && angle < 2.356194490192345) {
                dAngle = 0.25;
                x = x0 + w * 0.5 * (2.356194490192345 - angle) / (dAngle * Math.PI);
                y = y0 + h * 0.2 * (2.356194490192345 - angle) / (dAngle * Math.PI);
                this.rect.setFrame(x - newW / 2.0, y - 8.0, newW, 16.0);
            } else if (angle >= 2.356194490192345 && angle < 3.6128315516282616) {
                newW = bounds.getHeight() * this.bindingRegion.getSize() * k;
                dAngle = 0.3999999999999999;
                x = x0;
                y = y0 + h * 0.8 * (angle - 2.356194490192345) / (dAngle * Math.PI);
                this.rect.setFrame(x - 8.0, y - newW / 2.0, 16.0, newW);
            } else if (angle >= 3.6128315516282616 && angle < 4.71238898038469) {
                dAngle = 0.3500000000000001;
                x = x0 + w / 2.0 - w * 0.5 * (4.71238898038469 - angle) / (dAngle * Math.PI);
                y = y0 + h - h * 0.2 * (4.71238898038469 - angle) / (dAngle * Math.PI);
                this.rect.setFrame(x - newW / 2.0, y - 8.0, newW, 16.0);
            } else if (angle >= 4.71238898038469 && angle < 5.811946409141117) {
                dAngle = 0.3500000000000001;
                x = x0 + w - w * 0.5 * (5.811946409141117 - angle) / (dAngle * Math.PI);
                y = y0 + h * 0.8 + h * 0.2 * (5.811946409141117 - angle) / (dAngle * Math.PI);
                this.rect.setFrame(x - newW / 2.0, y - 8.0, newW, 16.0);
            } else if (angle >= 5.811946409141117 && angle < Math.PI * 2) {
                newW = bounds.getHeight() * this.bindingRegion.getSize() * k;
                dAngle = 0.1499999999999999;
                x = x0 + w;
                y = y0 + h * 0.8 - h * 0.3 * (angle - 5.811946409141117) / (dAngle * Math.PI);
                if (newW > h * 0.8) {
                    newW = h * 0.8;
                }
                this.rect.setFrame(x - 8.0, y - newW / 2.0, 16.0, newW);
            } else if (angle < 0.7853981633974483) {
                newW = bounds.getHeight() * this.bindingRegion.getSize() * k;
                dAngle = 0.25;
                x = x0 + w;
                y = y0 + h * 0.5 * (0.7853981633974483 - angle) / (dAngle * Math.PI);
                if (newW > 0.8 * h) {
                    newW = 0.8 * h;
                }
                this.rect.setFrame(x - 8.0, y - newW / 2.0, 16.0, newW);
            }
        } else if (angle >= 0.7853981633974483 && angle < 1.5707963267948966) {
            dAngle = 0.25;
            x = x0 + w / 2.0 + w * 0.5 * (1.5707963267948966 - angle) / (dAngle * Math.PI);
            y = y0;
            this.rect.setFrame(x - newW / 2.0, y - 8.0, newW, 16.0);
        } else if (angle >= 1.5707963267948966 && angle < 2.356194490192345) {
            dAngle = 0.25;
            x = x0 + w * 0.5 * (2.356194490192345 - angle) / (dAngle * Math.PI);
            y = y0;
            this.rect.setFrame(x - newW / 2.0, y - 8.0, newW, 16.0);
        } else if (angle >= 2.356194490192345 && angle < 3.9269908169872414) {
            newW = bounds.getHeight() * this.bindingRegion.getSize() * k;
            dAngle = 0.5;
            x = x0;
            y = y0 + h * (angle - 2.356194490192345) / (dAngle * Math.PI);
            if (newW > h) {
                newW = h;
            }
            this.rect.setFrame(x - 8.0, y - newW / 2.0, 16.0, newW);
        } else if (angle >= 3.9269908169872414 && angle < 4.71238898038469) {
            dAngle = 0.25;
            x = x0 + w / 2.0 - w * 0.5 * (4.71238898038469 - angle) / (dAngle * Math.PI);
            y = y0 + h;
            this.rect.setFrame(x - newW / 2.0, y - 8.0, newW, 16.0);
        } else if (angle >= 4.71238898038469 && angle < 5.497787143782138) {
            dAngle = 0.25;
            x = x0 + w - w * 0.5 * (5.497787143782138 - angle) / (dAngle * Math.PI);
            y = y0 + h;
            this.rect.setFrame(x - newW / 2.0, y - 8.0, newW, 16.0);
        } else if (angle >= 5.497787143782138) {
            newW = bounds.getHeight() * this.bindingRegion.getSize() * k;
            dAngle = 0.25;
            x = x0 + w;
            y = y0 + h - h * 0.5 * (angle - 5.497787143782138) / (dAngle * Math.PI);
            if (newW > h) {
                newW = h;
            }
            this.rect.setFrame(x - 8.0, y - newW / 2.0, 16.0, newW);
        } else if (angle <= 0.7853981633974483) {
            newW = bounds.getHeight() * this.bindingRegion.getSize() * k;
            dAngle = 0.25;
            x = x0 + w;
            y = y0 + h * 0.5 * (0.7853981633974483 - angle) / (dAngle * Math.PI);
            if (newW > h) {
                newW = h;
            }
            this.rect.setFrame(x - 8.0, y - newW / 2.0, 16.0, newW);
        }
    }

    public void draw(Graphics2D g2) {
        if (this.residue != null) {
            this.drawResidue(g2);
        }
        if (this.region != null) {
            this.drawRegion(g2);
        }
        if (this.bindingRegion != null) {
            this.drawBindingRegion(g2);
        }
        if (this.structuralState != null) {
            this.drawStructuralState(g2, this.symbol);
        }
        if (this.autoTag != null && this.autoTag.getSID() != null && !this.autoTag.getSID().trim().equals("")) {
            this.drawAutoTag(g2, this.symbol);
        }
    }

    private void drawRegion(Graphics2D g2) {
        if (this.symbol == null || this.region == null) {
            return;
        }
        if (this.region.getType().equals("RegulatoryRegion") || this.region.getType().equals("CodingRegion")) {
            this.drawRegulatoryRegion(g2);
        } else if (this.region.getType().equals("Modification Site")) {
            this.drawModificationSite(g2);
        } else if (this.region.getType().equals("CodingRegion") || this.region.getType().equals("proteinBindingDomain")) {
            this.drawTranscriptPromotor(g2, "N");
        }
        if (this.region.getType().equals("transcriptionStartingSiteL")) {
            this.drawTranscriptionStartingSite(g2, "L");
        }
        if (this.region.getType().equals("transcriptionStartingSiteR")) {
            this.drawTranscriptionStartingSite(g2, "R");
        }
    }

    private void drawTranscriptPromotor(Graphics2D g2, String start) {
        Color myColor = COLOR_SOLO_NORMAL;
        Color myFillColor = Color.WHITE;
        if (this.isSoloHighlighted) {
            myFillColor = myFillColor.darker();
        }
        g2.setColor(myFillColor);
        g2.fill(this.rect);
        if (start.equals("L") || start.equals("R")) {
            g2.setColor(Color.LIGHT_GRAY);
            g2.fill(this.tri_start);
        }
        g2.setColor(myColor);
        g2.draw(this.rect);
        RenderingHints originalHints = g2.getRenderingHints();
        Font originalFont = g2.getFont();
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (this.fontOutside == null) {
            String family = g2.getFont().getFamily();
            this.fontOutside = new Font(family, 0, 10);
        }
        g2.setFont(this.fontOutside);
        String name = this.region.getName();
        if (!name.equals("")) {
            name = " " + name + " ";
            g2.setColor(Color.BLACK);
            g2.drawString(name, (int)this.namePaintBounds.x, (int)(this.namePaintBounds.y + this.namePaintBounds.height));
        }
        if (((SpeciesSymbolImpl)this.symbol).isInSBGNViewer()) {
            String label = PROTEINBINDINGDOMAIN_SBGN;
            label = this.getInfoBoxShowingString(label, this.rect, this.fontOutside);
            Rectangle2D.Double labelPaintBounds = new Rectangle2D.Double(this.rect.getX(), this.rect.getY(), this.rect.getWidth(), this.rect.getHeight());
            g2.drawString(label, (int)labelPaintBounds.x, (int)(labelPaintBounds.y + labelPaintBounds.height * 2.0 / 3.0));
        }
        g2.setRenderingHints(originalHints);
        g2.setFont(originalFont);
        this.dif = null;
    }

    private void drawResidue(Graphics2D g2) {
        String name;
        if (this.symbol == null || this.residue == null) {
            return;
        }
        Color myColor = COLOR_SOLO_NORMAL;
        Color myFillColor = Color.WHITE;
        if (this.isSoloHighlighted) {
            myFillColor = myFillColor.darker();
        }
        g2.setColor(myFillColor);
        g2.fill(this.ellipse);
        g2.setColor(myColor);
        g2.draw(this.ellipse);
        RenderingHints originalHints = g2.getRenderingHints();
        Font originalFont = g2.getFont();
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setFont(ModificationShape.getResidueInnerLableFont(g2));
        FontMetrics fm = g2.getFontMetrics();
        String label = this.modification.getLabel();
        if (!label.equals("")) {
            g2.setColor(Color.BLACK);
            int w = fm.stringWidth(label);
            int h = fm.getAscent() - fm.getDescent();
            g2.drawString(label, (int)(this.ellipse.getX() + (this.ellipse.getWidth() - (double)w) / 2.0), (int)(this.ellipse.getY() + (this.ellipse.getHeight() + (double)h) / 2.0));
        }
        if (!(name = this.residue.getName()).equals("")) {
            name = " " + name + " ";
            if (this.fontOutside == null) {
                String family = g2.getFont().getFamily();
                this.fontOutside = new Font(family, 0, 10);
            }
            g2.setFont(this.fontOutside);
            g2.setColor(Color.BLACK);
            g2.drawString(name, (int)this.namePaintBounds.x, (int)(this.namePaintBounds.y + this.namePaintBounds.height));
        }
        g2.setRenderingHints(originalHints);
        g2.setFont(originalFont);
        this.dif = null;
    }

    public Point2D.Double createDifForTranscript(double pos) {
        double dx = 1.0;
        double dy = -1.0;
        dx = -1.0 + pos * 2.0;
        return new Point2D.Double(dx, dy);
    }

    public Point2D.Double createDif(double angle) {
        double dx = 1.0;
        double dy = 0.0;
        if (angle == 0.0 || angle == Math.PI * 2) {
            dx = 1.0;
            dy = 0.0;
        } else if (0.0 < angle && angle < 0.7853981633974483) {
            dx = 1.0;
            dy = -Math.tan(angle);
        } else if (angle == 0.7853981633974483) {
            dx = 1.0;
            dy = -1.0;
        } else if (0.7853981633974483 < angle && angle < 1.5707963267948966) {
            dx = 1.0 / Math.tan(angle);
            dy = -1.0;
        } else if (angle == 1.5707963267948966) {
            dx = 0.0;
            dy = -1.0;
        } else if (1.5707963267948966 < angle && angle < 2.356194490192345) {
            dx = 1.0 / Math.tan(angle);
            dy = -1.0;
        } else if (angle == 2.356194490192345) {
            dx = -1.0;
            dy = -1.0;
        } else if (2.356194490192345 < angle && angle < Math.PI) {
            dx = -1.0;
            dy = Math.tan(angle);
        } else if (angle == Math.PI) {
            dx = -1.0;
            dy = 0.0;
        } else if (Math.PI < angle && angle < 3.9269908169872414) {
            dx = -1.0;
            dy = Math.tan(angle);
        } else if (angle == 3.9269908169872414) {
            dx = -1.0;
            dy = 1.0;
        } else if (3.9269908169872414 < angle && angle < 4.71238898038469) {
            dx = -1.0 / Math.tan(angle);
            dy = 1.0;
        } else if (angle == 4.71238898038469) {
            dx = 0.0;
            dy = 1.0;
        } else if (4.71238898038469 < angle && angle < 5.497787143782138) {
            dx = -1.0 / Math.tan(angle);
            dy = 1.0;
        } else if (angle == 5.497787143782138) {
            dx = 1.0;
            dy = 1.0;
        } else if (5.497787143782138 < angle && angle < Math.PI * 2) {
            dx = 1.0;
            dy = -Math.tan(angle);
        }
        return new Point2D.Double(dx, dy);
    }

    public double getRealAngle(double logicalAngle) {
        if (this.symbol == null) {
            return 0.0;
        }
        double piInv = 0.3183098861837907;
        double x = logicalAngle * 0.3183098861837907;
        double f = 0.0;
        if (((SBSymbol)((Object)this.symbol)).getCode().equals("ION_CHANNEL")) {
            Rectangle2D.Double leftbounds = ((IonChannel)this.symbol).getModificatinSBGNViewerLeftBounds();
            Rectangle2D.Double rightbounds = ((IonChannel)this.symbol).getRightBounds();
            if (0.0 <= x && x < 0.25) {
                f = Math.atan(4.0 * x * rightbounds.height / rightbounds.width);
            } else if (0.25 <= x && x < 0.75) {
                f = 1.5707963267948966 + Math.atan(2.0 * (2.0 * x - 1.0) * leftbounds.width / leftbounds.height);
            } else if (0.75 <= x && x < 1.25) {
                f = Math.PI + Math.atan(4.0 * (x - 1.0) * leftbounds.height / leftbounds.width);
            } else if (1.25 <= x && x < 1.75) {
                f = 4.71238898038469 + Math.atan(2.0 * (2.0 * x - 3.0) * leftbounds.width / leftbounds.height);
            } else if (1.75 <= x && x <= 2.0) {
                f = Math.PI * 2 + Math.atan(4.0 * (x - 2.0) * rightbounds.height / rightbounds.width);
            }
        } else {
            Rectangle2D.Double bounds = this.symbol.getSymbolBounds();
            if (0.0 <= x && x < 0.25) {
                f = Math.atan(4.0 * x * bounds.height / bounds.width);
            } else if (0.25 <= x && x < 0.75) {
                f = 1.5707963267948966 + Math.atan(2.0 * (2.0 * x - 1.0) * bounds.width / bounds.height);
            } else if (0.75 <= x && x < 1.25) {
                f = Math.PI + Math.atan(4.0 * (x - 1.0) * bounds.height / bounds.width);
            } else if (1.25 <= x && x < 1.75) {
                f = 4.71238898038469 + Math.atan(2.0 * (2.0 * x - 3.0) * bounds.width / bounds.height);
            } else if (1.75 <= x && x <= 2.0) {
                f = Math.PI * 2 + Math.atan(4.0 * (x - 2.0) * bounds.height / bounds.width);
            }
        }
        if (Preference.isDebug && (f < 0.0 || Math.PI * 2 < f)) {
            System.err.println("Angle out of resion " + f / Math.PI + "*PI");
        }
        return f;
    }

    public void adjustNameBoundsPosition(FontMetrics fmMonoName, Rectangle2D.Double nameBounds) {
        if (this.monoShapeNameImageBounds != null && nameBounds != null && !((SpeciesSymbolImpl)this.symbol).isInSBGNViewer()) {
            Rectangle2D.Double tempMonoNameBounds;
            Rectangle2D.Double tempNameBounds;
            if (fmMonoName == null) {
                fmMonoName = this.getGraphics2D().getFontMetrics();
            }
            if ((tempNameBounds = (Rectangle2D.Double)nameBounds.clone()).intersects(tempMonoNameBounds = (Rectangle2D.Double)this.monoShapeNameImageBounds.clone())) {
                ModificationShape.calcBoundsXYWithWidthAndHeight(nameBounds, this.rect);
            }
        }
    }

    public static void calcBoundsXYWithWidthAndHeight(RectangularShape bounds, RectangularShape another) {
        if (bounds != null && another != null && (bounds instanceof Rectangle2D.Double && another instanceof Rectangle2D.Double || bounds instanceof Ellipse2D.Double && another instanceof Ellipse2D.Double)) {
            double x = another.getX() + (another.getWidth() - bounds.getWidth()) / 2.0;
            double y = another.getY() + (another.getHeight() - bounds.getHeight()) / 2.0;
            bounds.setFrame(x, y, bounds.getWidth(), bounds.getHeight());
        }
    }

    private void drawRegulatoryRegion(Graphics2D g2) {
        Color myColor = COLOR_SOLO_NORMAL;
        Color myFillColor = Color.WHITE;
        if (this.isSoloHighlighted) {
            myFillColor = myFillColor.darker();
        }
        g2.setColor(myFillColor);
        g2.fill(this.rect);
        g2.setColor(myColor);
        g2.draw(this.rect);
        RenderingHints originalHints = g2.getRenderingHints();
        Font originalFont = g2.getFont();
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (this.fontOutside == null) {
            String family = g2.getFont().getFamily();
            this.fontOutside = new Font(family, 0, 10);
        }
        g2.setFont(this.fontOutside);
        String name = this.region.getName();
        if (!name.equals("")) {
            name = " " + name + " ";
            g2.setColor(Color.BLACK);
            g2.drawString(name, (int)this.namePaintBounds.x, (int)(this.namePaintBounds.y + this.namePaintBounds.height));
        }
        if (((SpeciesSymbolImpl)this.symbol).isInSBGNViewer()) {
            String label = null;
            if (this.region.getType().equals("CodingRegion")) {
                label = CODINGREGION_SBGN;
            } else if (this.region.getType().equals("RegulatoryRegion")) {
                label = REGULATORYREGION_SBGN;
            }
            label = this.getInfoBoxShowingString(label, this.rect, this.fontOutside);
            Rectangle2D.Double labelPaintBounds = new Rectangle2D.Double(this.rect.getX(), this.rect.getY(), this.rect.getWidth(), this.rect.getHeight());
            g2.drawString(label, (int)labelPaintBounds.x, (int)(labelPaintBounds.y + labelPaintBounds.height * 2.0 / 3.0));
        }
        g2.setRenderingHints(originalHints);
        g2.setFont(originalFont);
        this.dif = null;
    }

    private void drawModificationSite(Graphics2D g2) {
        Color myColor = COLOR_SOLO_NORMAL;
        Color myFillColor = Color.WHITE;
        if (this.isSoloHighlighted) {
            myFillColor = myFillColor.darker();
        }
        RenderingHints originalHints = g2.getRenderingHints();
        Font originalFont = g2.getFont();
        if (((SpeciesSymbolImpl)this.symbol).isInSBGNViewer()) {
            g2.setColor(myFillColor);
            g2.fill(this.rect);
            if (this.fontOutside == null) {
                String family = g2.getFont().getFamily();
                this.fontOutside = new Font(family, 0, 10);
            }
            g2.setFont(this.fontOutside);
            g2.setColor(myColor);
            g2.draw(this.rect);
            String label = this.getLabel();
            label = this.getInfoBoxShowingString(label, this.rect, this.fontOutside);
            Rectangle2D.Double labelPaintBounds = new Rectangle2D.Double(this.rect.getX(), this.rect.getY(), this.rect.getWidth(), this.rect.getHeight());
            g2.drawString(label, (int)labelPaintBounds.x, (int)(labelPaintBounds.y + labelPaintBounds.height * 2.0 / 3.0));
        } else {
            g2.setColor(myFillColor);
            g2.fill(this.ellipse);
            if ("empty".equals(this.modification.getState())) {
                myColor = Color.WHITE.darker();
            }
            g2.setColor(myColor);
            g2.draw(this.ellipse);
            if ("empty".equals(this.modification.getState())) {
                myColor = COLOR_SOLO_NORMAL;
            }
            g2.setColor(myColor);
            if ("histone2".equals(this.modification.getState())) {
                g2.setColor(myFillColor);
                g2.fill(this.ellipse2);
                g2.setColor(myColor);
                g2.draw(this.ellipse2);
            }
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2.setFont(ModificationShape.getModificationSiteInnerLableFont(g2));
            FontMetrics fm = g2.getFontMetrics();
            String label = this.modification.getLabel();
            g2.setColor(Color.BLACK);
            int mw = fm.stringWidth(label);
            int mh = fm.getAscent() - fm.getDescent();
            g2.drawString(label, (int)(this.ellipse.getX() + (this.ellipse.getWidth() - (double)mw) / 2.0), (int)(this.ellipse.getY() + (this.ellipse.getHeight() + (double)mh) / 2.0));
            g2.setColor(Color.BLACK);
            g2.drawLine((int)this.ellipse.getCenterX(), (int)(this.ellipse.getY() + this.ellipse.getHeight()), (int)this.ellipse.getCenterX(), (int)(this.ellipse.getY() + this.ellipse.getHeight() + 8.0));
        }
        String name = this.region.getName();
        if (!name.equals("")) {
            name = " " + name + " ";
            if (this.fontOutside == null) {
                String family = g2.getFont().getFamily();
                this.fontOutside = new Font(family, 0, 10);
            }
            g2.setFont(this.fontOutside);
            g2.setColor(Color.BLACK);
            g2.drawString(name, (int)this.namePaintBounds.x, (int)(this.namePaintBounds.y + this.namePaintBounds.height));
        }
        g2.setRenderingHints(originalHints);
        g2.setFont(originalFont);
        this.dif = null;
    }

    private void drawTranscriptionStartingSite(Graphics2D g2, String start) {
        Color backupColor = g2.getColor();
        Color myColor = COLOR_SOLO_NORMAL;
        if (this.isSoloHighlighted) {
            myColor = Color.WHITE.darker();
        } else if (this.region.getActive()) {
            myColor = Color.RED;
        }
        if (((SpeciesSymbolImpl)this.symbol).isInSBGNViewer()) {
            Color myFillColor = Color.WHITE;
            g2.setColor(myFillColor);
            g2.fill(this.rect);
            g2.setColor(myColor);
            g2.draw(this.rect);
        } else {
            g2.setColor(myColor);
            g2.drawLine((int)this.rect.getX(), (int)this.rect.getY(), (int)(this.rect.getX() + this.rect.getWidth()), (int)this.rect.getY());
            double x = this.rect.getX();
            if ("L".equals(start)) {
                x = this.rect.getX();
            } else if ("R".equals(start)) {
                x = this.rect.getX() + this.rect.getWidth();
            }
            g2.drawLine((int)x, (int)this.rect.getY(), (int)x, (int)(this.rect.getY() + this.rect.getHeight()));
            Polygon triangle = this.getTriangle(this.region.getType());
            g2.fillPolygon(triangle);
        }
        RenderingHints originalHints = g2.getRenderingHints();
        Font originalFont = g2.getFont();
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (this.fontOutside == null) {
            String family = g2.getFont().getFamily();
            this.fontOutside = new Font(family, 0, 10);
        }
        g2.setFont(this.fontOutside);
        String name = this.region.getName();
        if (!name.equals("")) {
            name = " " + name + " ";
            g2.setColor(Color.BLACK);
            g2.drawString(name, (int)this.namePaintBounds.x, (int)(this.namePaintBounds.y + this.namePaintBounds.height));
        }
        if (((SpeciesSymbolImpl)this.symbol).isInSBGNViewer()) {
            String label = null;
            if (this.region.getType().equals("transcriptionStartingSiteL")) {
                label = TRANSCRIPTIONSTARTINGSITEL_SBGN;
            } else if (this.region.getType().equals("transcriptionStartingSiteR")) {
                label = TRANSCRIPTIONSTARTINGSITER_SBGN;
            }
            label = this.getInfoBoxShowingString(label, this.rect, this.fontOutside);
            Rectangle2D.Double labelPaintBounds = new Rectangle2D.Double(this.rect.getX(), this.rect.getY(), this.rect.getWidth(), this.rect.getHeight());
            g2.drawString(label, (int)labelPaintBounds.x, (int)(labelPaintBounds.y + labelPaintBounds.height * 2.0 / 3.0));
        }
        g2.setRenderingHints(originalHints);
        g2.setFont(originalFont);
        g2.setColor(backupColor);
        this.dif = null;
    }

    private Polygon getTriangle(String type) {
        double x1 = this.rect.getX();
        double y1 = this.rect.getY();
        double x2 = this.rect.getX() + 8.0;
        double y2 = this.rect.getY() - 4.8;
        if (type.equals("transcriptionStartingSiteR")) {
            x1 = this.rect.getX();
            y1 = this.rect.getY();
            x2 = this.rect.getX() + 8.0;
            y2 = this.rect.getY() - 4.8;
        } else if (type.equals("transcriptionStartingSiteL")) {
            x1 = this.rect.getX() + this.rect.getWidth();
            y1 = this.rect.getY();
            x2 = this.rect.getX() + this.rect.getWidth() - 8.0;
            y2 = this.rect.getY() - 4.8;
        }
        double x3 = x2;
        double y3 = y2 + 9.6;
        Polygon triangle = new Polygon();
        triangle.addPoint((int)x1, (int)y1);
        triangle.addPoint((int)x2, (int)y2);
        triangle.addPoint((int)x3, (int)y3);
        return triangle;
    }

    public Rectangle2D.Double updateCircleBounds(SpeciesSymbol symbol) {
        double w2;
        if (symbol == null) {
            return null;
        }
        double angle = 0.0;
        angle = this.structuralState != null ? this.structuralState.getAngle() : 1.5707963267948966;
        Rectangle2D.Double bounds = symbol.getSymbolBounds();
        if (((SBSymbol)((Object)symbol)).getCode().equals("ION_CHANNEL")) {
            bounds = !((SpeciesSymbolImpl)symbol).isInSBGNViewer() ? (0.0 <= angle && angle < 0.7853981633974483 || 5.497787143782138 <= angle && angle <= Math.PI * 2 ? ((IonChannel)symbol).getRightBounds() : ((IonChannel)symbol).getLeftBounds()) : ((IonChannel)symbol).getModificatinSBGNViewerBounds();
        }
        angle = this.getRealAngle(angle);
        double x = bounds.x + bounds.width / 2.0;
        double y = bounds.y + bounds.height / 2.0;
        this.dif = this.createDif(angle);
        double dx = this.dif.x;
        double dy = this.dif.y;
        while (symbol.inInner(x, y)) {
            x += dx;
            y += dy;
        }
        String label = this.structuralState.getState().trim();
        double w1 = label.getBytes().length * 7;
        if (w1 < 50.0) {
            w1 = 50.0;
        }
        if (((SBSymbol)((Object)symbol)).getCode().equals("ION_CHANNEL")) {
            bounds = symbol.getSymbolBounds();
        }
        if ((w2 = w1) > bounds.getWidth()) {
            w2 = bounds.getWidth();
        }
        double x1 = x - w2 / 2.0;
        this.ellipse.setFrame(x1, y - 8.0, w2, 16.0);
        return new Rectangle2D.Double(x1, y - 8.0, w2, 16.0);
    }

    public void drawStructuralState(Graphics2D g2, SpeciesSymbol symbol) {
        if (symbol == null || this.structuralState == null) {
            return;
        }
        if ("empty".equals(this.structuralState.getState())) {
            return;
        }
        Color myColor = COLOR_SOLO_NORMAL;
        Color myFillColor = Color.WHITE;
        if (this.isSoloHighlighted) {
            myFillColor = myFillColor.darker();
        }
        g2.setColor(myFillColor);
        g2.fill(this.ellipse);
        g2.setColor(myColor);
        g2.draw(this.ellipse);
        RenderingHints originalHints = g2.getRenderingHints();
        Font originalFont = g2.getFont();
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setFont(ModificationShape.getStructuralStateInnerLableFont(g2));
        String label = this.structuralState.getState();
        if (label != null && !label.equals("")) {
            g2.setColor(Color.BLACK);
            g2.drawString(label, (int)this.namePaintBounds.x, (int)(this.namePaintBounds.y + this.namePaintBounds.height));
        }
        g2.setRenderingHints(originalHints);
        g2.setFont(originalFont);
        this.dif = null;
    }

    private void drawBindingRegion(Graphics2D g2) {
        Color myColor = COLOR_SOLO_NORMAL;
        Color myFillColor = Color.WHITE;
        if (this.isSoloHighlighted) {
            myFillColor = myFillColor.darker();
        }
        g2.setColor(myFillColor);
        g2.fill(this.rect);
        g2.setColor(myColor);
        g2.draw(this.rect);
        RenderingHints originalHints = g2.getRenderingHints();
        Font originalFont = g2.getFont();
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (this.fontOutside == null) {
            String family = g2.getFont().getFamily();
            this.fontOutside = new Font(family, 0, 10);
        }
        g2.setFont(this.fontOutside);
        String name = this.bindingRegion.getName();
        if (!name.equals("")) {
            name = " " + name + " ";
            g2.setColor(Color.BLACK);
            g2.drawString(name, (int)this.namePaintBounds.x, (int)(this.namePaintBounds.y + this.namePaintBounds.height));
        }
        g2.setRenderingHints(originalHints);
        g2.setFont(originalFont);
        this.dif = null;
    }

    public static Font getResidueInnerLableFont(Graphics2D g2) {
        return ModificationShape.getInnerLableFont_Size09(g2);
    }

    public static Font getModificationSiteInnerLableFont(Graphics2D g2) {
        return ModificationShape.getInnerLableFont_Size09(g2);
    }

    public static Font getStructuralStateInnerLableFont(Graphics2D g2) {
        return ModificationShape.getInnerLableFont_Size09(g2);
    }

    public static Font getInnerLableFont_Size09(Graphics2D g2) {
        if (g2 == null || g2.getFont() == null) {
            return new Font(DEFAULT_FONTNAME, 0, 9);
        }
        return new Font(g2.getFont().getFamily(), 0, 9);
    }

    public static Font getOutterLableFont_Size10(Graphics2D g2) {
        if (g2 == null || g2.getFont() == null) {
            return new Font(DEFAULT_FONTNAME, 0, 10);
        }
        return new Font(g2.getFont().getFamily(), 0, 10);
    }

    public SpeciesSymbol getSpeciesSymbol() {
        return this.symbol;
    }

    public void setSameIDAutoTag(SameIDAutoTag tag) {
        this.autoTag = tag;
        if (this.autoTag != null) {
            this.modificationIns = this.autoTag;
        }
    }

    public SameIDAutoTag getSameIDAutoTag() {
        return this.autoTag;
    }

    public static Font getSameIDAutoTagInnerLableFont(Graphics2D g2) {
        return ModificationShape.getInnerLableFont_Size08(g2);
    }

    public static Font getInnerLableFont_Size08(Graphics2D g2) {
        if (g2 == null || g2.getFont() == null) {
            return new Font(DEFAULT_FONTNAME, 0, 8);
        }
        return new Font(g2.getFont().getFamily(), 0, 8);
    }

    public Rectangle2D.Double rebulidTagShape() {
        try {
            Rectangle2D.Double rectTagFrame = this.updateCircleBounds();
            Rectangle rect = this.autoTag.getPaintPath().getBounds();
            Rectangle2D.Double rectNameBounds = this.getNameBounds(new Rectangle2D.Double(rect.x, rect.y, rect.width, rect.height));
            return GUtil.union(rectTagFrame, rectNameBounds);
        }
        catch (Exception myErr) {
            return null;
        }
    }

    public void drawAutoTag(Graphics2D g2, SpeciesSymbol symb) {
        if (!Preference.isAutoTagShowing) {
            return;
        }
        if (symb == null || this.autoTag == null) {
            return;
        }
        String label = this.autoTag.getSID();
        if (label == null || label.trim().equals("")) {
            return;
        }
        if (this.namePaintBounds == null) {
            this.rebulidTagShape();
            if (this.namePaintBounds == null) {
                return;
            }
        }
        Color myFillColor = SameIDAutoTag.colorTagInner;
        if (this.isSoloHighlighted) {
            myFillColor = myFillColor.darker();
        }
        g2.setColor(myFillColor);
        g2.fill(this.autoTag.getPaintPath());
        Color myColor = SameIDAutoTag.colorTagOutterLine;
        g2.setColor(myColor);
        g2.draw(this.autoTag.getPaintPath());
        RenderingHints originalHints = g2.getRenderingHints();
        Font originalFont = g2.getFont();
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setFont(ModificationShape.getSameIDAutoTagInnerLableFont(g2));
        g2.setColor(SameIDAutoTag.colorTagSID);
        g2.drawString(label, (int)this.namePaintBounds.x, (int)(this.namePaintBounds.y + this.namePaintBounds.height));
        g2.setRenderingHints(originalHints);
        g2.setFont(originalFont);
        this.dif = null;
    }

    private String getInfoBoxShowingString(String s, Rectangle2D.Double rect, Font font) {
        int susPoint;
        String rtn = s;
        String omitPoint = "...";
        String forGetSpaceLength = "-";
        TextLayout layout = new TextLayout(String.valueOf(forGetSpaceLength) + s, font, new FontRenderContext(new AffineTransform(), false, false));
        TextLayout omit = new TextLayout(omitPoint, font, new FontRenderContext(new AffineTransform(), false, false));
        int strWidth = (int)layout.getBounds().getWidth();
        int displayWidth = (int)rect.getWidth();
        if (displayWidth <= (susPoint = (int)omit.getBounds().getWidth())) {
            String tempOmitPoint = omitPoint.toString();
            while (displayWidth <= susPoint && !tempOmitPoint.equals("")) {
                omitPoint = tempOmitPoint.toString();
                omit = new TextLayout(tempOmitPoint, font, new FontRenderContext(new AffineTransform(), false, false));
                susPoint = (int)omit.getBounds().getWidth();
                tempOmitPoint = tempOmitPoint.substring(0, tempOmitPoint.length() - 1);
            }
            return omitPoint;
        }
        if (displayWidth >= strWidth) {
            String tempRtn = s.toString();
            rtn = s.toString();
            while (displayWidth >= strWidth) {
                tempRtn = String.valueOf(forGetSpaceLength) + tempRtn + forGetSpaceLength;
                layout = new TextLayout(tempRtn, font, new FontRenderContext(new AffineTransform(), false, false));
                strWidth = (int)layout.getBounds().getWidth();
                rtn = " " + rtn + " ";
            }
            return rtn;
        }
        rtn = " " + rtn;
        while (strWidth > displayWidth - susPoint) {
            if (rtn.length() <= 2) break;
            rtn = rtn.substring(0, rtn.length() - 1);
            layout = new TextLayout(rtn, font, new FontRenderContext(new AffineTransform(), false, false));
            strWidth = (int)layout.getBounds().getWidth();
        }
        return String.valueOf(rtn.substring(0, rtn.length() - 2)) + omitPoint;
    }

    public static final String[][] getSpeciesInformatShowingInMouseTooltip(ModificationShape mshape) {
        if (mshape == null) {
            return null;
        }
        if (mshape.region != null) {
            String strRegionType = mshape.region.getType();
            if (strRegionType.equals("CodingRegion")) {
                return new String[][]{{CODINGREGION_SBGN}};
            }
            if (strRegionType.equals("RegulatoryRegion")) {
                return new String[][]{{REGULATORYREGION_SBGN}};
            }
            if (strRegionType.equals("transcriptionStartingSiteL")) {
                return new String[][]{{TRANSCRIPTIONSTARTINGSITEL_SBGN}};
            }
            if (strRegionType.equals("transcriptionStartingSiteR")) {
                return new String[][]{{TRANSCRIPTIONSTARTINGSITER_SBGN}};
            }
            if (strRegionType.equals("proteinBindingDomain")) {
                return new String[][]{{PROTEINBINDINGDOMAIN_SBGN}};
            }
            if (strRegionType.equals("Modification Site")) {
                String state = mshape.modification.getState();
                if (state.equals("phosphorylated")) {
                    return new String[][]{{"phosphorylated"}};
                }
                if (state.equals("acetylated")) {
                    return new String[][]{{"acetylated"}};
                }
                if (state.equals("methylated")) {
                    return new String[][]{{"methylated"}};
                }
                if (state.equals("don't care")) {
                    return new String[][]{{"don't care"}};
                }
                if (state.equals("unknown")) {
                    return new String[][]{{"unknown"}};
                }
                if (state.equals("ubiquitinated")) {
                    return new String[][]{{"ubiquitinated"}};
                }
                if (state.equals("hydroxylated")) {
                    return new String[][]{{"hydroxylated"}};
                }
                if (state.equals("empty")) {
                    return new String[][]{{"empty"}};
                }
                if (state.equals("glycosylated")) {
                    return new String[][]{{"glycosylated"}};
                }
                if (state.equals("myristoylated")) {
                    return new String[][]{{"myristoylated"}};
                }
                if (state.equals("palmytoylated")) {
                    return new String[][]{{"palmytoylated"}};
                }
                if (state.equals("prenylated")) {
                    return new String[][]{{"prenylated"}};
                }
                if (state.equals("protonated")) {
                    return new String[][]{{"protonated"}};
                }
                if (state.equals("sulfated")) {
                    return new String[][]{{"sulfated"}};
                }
                return null;
            }
            return null;
        }
        if (mshape.bindingRegion != null) {
            return new String[][]{{BINDINGREGION_SBGN}};
        }
        if (mshape.structuralState != null) {
            return null;
        }
        if (mshape.autoTag != null) {
            return null;
        }
        return null;
    }

    private String getLabel() {
        try {
            String state = this.modification.getState();
            if (state.equals("phosphorylated")) {
                return PHOSPHORYLATED_SBGN;
            }
            if (state.equals("acetylated")) {
                return ACETYLATED_SBGN;
            }
            if (state.equals("methylated")) {
                return METHYLATED_SBGN;
            }
            if (state.equals("don't care")) {
                return DONT_CARE_SBGN;
            }
            if (state.equals("unknown")) {
                return String.valueOf(UNKNOWN_SBGN) + " ";
            }
            if (state.equals("ubiquitinated")) {
                return UBIQUITINATED_SBGN;
            }
            if (state.equals("hydroxylated")) {
                return HYDROXYLATED_SBGN;
            }
            if (state.equals("empty")) {
                return EMPTY_SBGN;
            }
            if (state.equals("glycosylated")) {
                return GLYCOSYLATED_SBGN;
            }
            if (state.equals("myristoylated")) {
                return MYRISTOYLATED_SBGN;
            }
            if (state.equals("palmytoylated")) {
                return PALMYTOYLATED_SBGN;
            }
            if (state.equals("prenylated")) {
                return PRENYLATED_SBGN;
            }
            if (state.equals("protonated")) {
                return PROTONATED_SBGN;
            }
            if (state.equals("sulfated")) {
                return SULFATED_SBGN;
            }
            return "";
        }
        catch (Exception myErr) {
            return "";
        }
    }

    public boolean isDotInShapeOfSpeciesInformatBox(Point2D pointA) {
        if (((SpeciesSymbolImpl)this.symbol).isInSBGNViewer()) {
            block12: {
                if (pointA == null) {
                    return false;
                }
                try {
                    double x = ((Point2D.Double)pointA).x;
                    double y = ((Point2D.Double)pointA).y;
                    if (this.residue != null) {
                        return this.ellipse.contains(x, y);
                    }
                    if (this.region != null) {
                        String strRegionType = this.region.getType();
                        if (strRegionType.equals("RegulatoryRegion") || strRegionType.equals("CodingRegion")) {
                            return this.rect.contains(x, y);
                        }
                        if (strRegionType.equals("Modification Site")) {
                            return this.rect.contains(x, y);
                        }
                        if (strRegionType.equals("transcriptionStartingSiteL") || strRegionType.equals("transcriptionStartingSiteR")) {
                            return this.rect.contains(x, y);
                        }
                        return this.rect.contains(x, y);
                    }
                    if (this.bindingRegion != null) {
                        return this.rect.contains(x, y);
                    }
                    if (this.structuralState == null) break block12;
                    return false;
                }
                catch (Exception myErr) {
                    return false;
                }
            }
            if (this.autoTag != null) {
                return false;
            }
            return false;
        }
        return false;
    }
}

