/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.sbmlExtension;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.sbi.celldesigner.MonoSpeciesPropertyDialog;
import jp.sbi.celldesigner.sbmlExtension.BindingRegion;
import jp.sbi.celldesigner.sbmlExtension.ModificationResidue;
import jp.sbi.celldesigner.sbmlExtension.ProteinDialog2;

public class ModificationResidueDialog2
extends JDialog
implements ChangeListener,
ActionListener,
ItemListener {
    JDialog pDialog;
    ModificationResidue residue;
    BindingRegion bindingRegion;
    private String[] sideStrs = new String[]{"none", "inside", "outside"};
    private String[] typeStrs = new String[]{"residue", "binding region"};
    private JTextField idTextField;
    private JTextField nameTextField;
    private JComboBox sideCombo;
    private JSlider angleSlider;
    private JButton closeButton;
    JRootPane rootPane;
    private boolean isFirst = true;
    private TextFieldKeyListener textFieldKeyListener;
    private JSlider sizeSlider;
    private JComboBox typeCombo;
    private boolean isAdd = false;
    private boolean isEdit = false;
    public static final double MAXVERSIZE = 0.42;

    public ModificationResidueDialog2(JDialog pDialog) {
        super(pDialog);
        this.setTitle("ModificationResidue/BindingRegion");
        this.pDialog = pDialog;
        this.setModal(true);
        JPanel panel = this.createDialogPanel();
        this.getContentPane().add(panel);
        this.setSize(new Dimension(panel.getWidth() + 20, panel.getHeight() + 45));
    }

    protected JPanel createDialogPanel() {
        this.rootPane = this.getRootPane();
        JPanel panel = new JPanel();
        panel.setLayout(null);
        JLabel idLabel = new JLabel("id");
        idLabel.setBounds(new Rectangle(10, 4, 60, 20));
        panel.add((Component)idLabel, null);
        this.idTextField = new JTextField();
        this.idTextField.setBounds(new Rectangle(75, 4, 200, 20));
        this.idTextField.setEditable(false);
        this.idTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ModificationResidueDialog2.this.rootPane.setDefaultButton(ModificationResidueDialog2.this.closeButton);
            }
        });
        panel.add((Component)this.idTextField, null);
        JLabel nameLabel = new JLabel("name");
        nameLabel.setBounds(new Rectangle(10, 28, 120, 20));
        panel.add((Component)nameLabel, null);
        this.nameTextField = new JTextField();
        this.nameTextField.setBounds(new Rectangle(75, 28, 200, 20));
        this.nameTextField.setEditable(true);
        this.nameTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ModificationResidueDialog2.this.rootPane.setDefaultButton(ModificationResidueDialog2.this.closeButton);
            }
        });
        this.textFieldKeyListener = new TextFieldKeyListener();
        this.nameTextField.addKeyListener(this.textFieldKeyListener);
        panel.add((Component)this.nameTextField, null);
        int y1 = 24;
        JLabel regionLabel = new JLabel("type");
        int typeY = 52;
        regionLabel.setBounds(new Rectangle(10, typeY, 120, 20));
        panel.add((Component)regionLabel, null);
        this.typeCombo = new JComboBox<String>(this.typeStrs);
        this.typeCombo.setBounds(new Rectangle(75, 52, 200, 20));
        this.typeCombo.setSelectedIndex(0);
        this.typeCombo.addItemListener(this);
        panel.add((Component)this.typeCombo, null);
        int typeHeight = (int)this.typeCombo.getPreferredSize().getHeight();
        JLabel sizeLabel = new JLabel("size");
        int sizeY = typeY + typeHeight + 5;
        sizeLabel.setBounds(new Rectangle(10, sizeY, 120, 20));
        panel.add((Component)sizeLabel, null);
        this.sizeSlider = new JSlider(0, 0, 100, 0);
        this.sizeSlider.setPaintTicks(false);
        this.sizeSlider.setValue(0);
        int w = this.sizeSlider.getPreferredSize().width;
        int h = this.sizeSlider.getPreferredSize().height;
        this.sizeSlider.setBounds(new Rectangle(75, sizeY, w, h));
        this.sizeSlider.addChangeListener(this);
        this.sizeSlider.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ModificationResidueDialog2.this.resetSizeSlider();
            }
        });
        this.sizeSlider.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                ModificationResidueDialog2.this.resetSizeSlider();
            }
        });
        this.sizeSlider.setEnabled(false);
        this.sizeSlider.setMinimum(10);
        panel.add((Component)this.sizeSlider, null);
        int sizeSliderHeight = (int)this.sizeSlider.getPreferredSize().getHeight();
        JLabel sideLabel = new JLabel("side");
        int sideLabelY = sizeY + sizeSliderHeight + 5;
        sideLabel.setBounds(new Rectangle(10, sideLabelY, 120, 20));
        panel.add((Component)sideLabel, null);
        this.sideCombo = new JComboBox<String>(this.sideStrs);
        this.sideCombo.setBounds(new Rectangle(75, sideLabelY, 200, 20));
        this.sideCombo.setSelectedIndex(0);
        this.sideCombo.addActionListener(this);
        panel.add((Component)this.sideCombo, null);
        int sideHeight = (int)this.sideCombo.getPreferredSize().getHeight();
        JLabel angleLabel = new JLabel("angle");
        int angleLabelY = sideLabelY + sideHeight + 5;
        angleLabel.setBounds(new Rectangle(10, angleLabelY, 120, 20));
        panel.add((Component)angleLabel, null);
        this.angleSlider = new JSlider(0, 0, 628, 0);
        this.angleSlider.setPaintTicks(false);
        this.angleSlider.setValue(314);
        w = this.angleSlider.getPreferredSize().width;
        h = this.angleSlider.getPreferredSize().height;
        this.angleSlider.setBounds(new Rectangle(75, angleLabelY, w, h));
        this.angleSlider.addChangeListener(this);
        this.angleSlider.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                ModificationResidueDialog2.this.resetAngleSlider();
            }
        });
        this.angleSlider.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ModificationResidueDialog2.this.resetAngleSlider();
            }
        });
        panel.add((Component)this.angleSlider, null);
        int angleSliderHeight = (int)this.angleSlider.getPreferredSize().getHeight();
        this.closeButton = new JButton("Close");
        int closeY = angleLabelY + angleSliderHeight + 10;
        this.closeButton.setMnemonic(67);
        this.closeButton.setBounds(new Rectangle(110, closeY, 80, 25));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModificationResidueDialog2.this.closeButton_actionPerformed();
            }
        });
        this.closeButton.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ModificationResidueDialog2.this.rootPane.setDefaultButton(ModificationResidueDialog2.this.closeButton);
            }
        });
        panel.add((Component)this.closeButton, null);
        panel.setSize(this.angleSlider.getX() + this.angleSlider.getWidth(), this.closeButton.getY() + this.closeButton.getHeight());
        return panel;
    }

    public void initDialog() {
        this.idTextField.setText("");
        this.nameTextField.setText("");
        this.sideCombo.setSelectedIndex(0);
        this.angleSlider.setValue(0);
        this.typeCombo.setSelectedIndex(0);
        this.typeCombo.setEnabled(true);
    }

    public void enableDialog(boolean isEnabled) {
        this.nameTextField.setEnabled(isEnabled);
        this.sideCombo.setEnabled(isEnabled);
        this.angleSlider.setEnabled(isEnabled);
        this.typeCombo.setEditable(isEnabled);
    }

    public void releaseAll() {
        this.nameTextField.removeKeyListener(this.textFieldKeyListener);
        this.pDialog = null;
        this.residue = null;
        this.nameTextField.setText("");
        this.bindingRegion = null;
    }

    @Override
    public void show() {
        if (this.isFirst) {
            Point p = this.pDialog.getLocation();
            Dimension d = this.pDialog.getSize();
            this.setLocation(p.x, p.y + (int)((double)d.height * 0.7));
            this.isFirst = false;
        }
        super.show();
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            this.pDialog.repaint();
        }
    }

    protected void setModificationResidue(ModificationResidue residue) {
        if (residue == null) {
            this.residue = null;
            this.initDialog();
            this.enableDialog(false);
            return;
        }
        this.enableDialog(true);
        this.residue = residue;
        String id = residue.getId();
        this.idTextField.setText(id);
        this.idTextField.setCaretPosition(id.length());
        String type = residue.getType();
        if (this.typeCombo.getSelectedIndex() != 0) {
            this.typeCombo.setSelectedIndex(0);
        }
        if (type == null || "".equals(type)) {
            this.typeCombo.setEnabled(true);
        } else {
            this.typeCombo.setEnabled(false);
        }
        this.sizeSlider.setValue(0);
        this.sizeSlider.setEnabled(false);
        String name = residue.getName();
        this.nameTextField.setText(name);
        this.nameTextField.setCaretPosition(name.length());
        String side = residue.getSide();
        this.sideCombo.setEnabled(true);
        int i = 0;
        while (i < this.sideStrs.length) {
            if (side.equals(this.sideStrs[i])) {
                this.sideCombo.setSelectedIndex(i);
                break;
            }
            ++i;
        }
        double angle = residue.getAngle();
        this.angleSlider.setValue((int)(angle * 100.0));
    }

    protected void setBindingRegion(BindingRegion bindingRegion) {
        if (bindingRegion == null) {
            this.bindingRegion = new BindingRegion();
            return;
        }
        this.enableDialog(true);
        this.bindingRegion = bindingRegion;
        String id = bindingRegion.getId();
        this.idTextField.setText(id);
        this.idTextField.setCaretPosition(id.length());
        String name = bindingRegion.getName();
        this.nameTextField.setText(name);
        this.nameTextField.setCaretPosition(name.length());
        String type = bindingRegion.getType();
        if (this.typeCombo.getSelectedIndex() != 1) {
            this.typeCombo.setSelectedIndex(1);
        }
        if (type == null || "".equals(type)) {
            this.typeCombo.setEnabled(true);
        } else {
            this.typeCombo.setEnabled(false);
        }
        double size = bindingRegion.getSize();
        this.sizeSlider.setEnabled(true);
        this.sizeSlider.setValue((int)(size * 100.0));
        this.sideCombo.setSelectedIndex(0);
        this.sideCombo.setEnabled(false);
        double angle = bindingRegion.getAngle();
        this.angleSlider.setValue((int)(angle * 100.0));
    }

    public boolean isAdd() {
        return this.isAdd;
    }

    public void setIsAdd(boolean isAdd) {
        this.isAdd = isAdd;
    }

    public boolean isEdit() {
        return this.isEdit;
    }

    public void setIsEdit(boolean isEdit) {
        this.isEdit = isEdit;
    }

    public String getCurName() {
        return this.nameTextField.getText();
    }

    private boolean checkVerMaxSize() {
        double k;
        String type = (String)this.typeCombo.getSelectedItem();
        if (type.equals("") || "residue".equals(type)) {
            return false;
        }
        double halfSize = (double)(this.sizeSlider.getValue() / 2) / 100.0;
        double oldAngle = this.bindingRegion.getAngle();
        String proteinType = this.bindingRegion.getProteinType();
        if (proteinType.equals("RECEPTOR")) {
            if (oldAngle > 2.356194490192345 && oldAngle < 3.6128315516282616 || oldAngle < 0.7853981633974483 || oldAngle > 5.811946409141117) {
                double k2 = 0.42;
                k2 = 0.336;
                if ((int)(halfSize * 2.0 * 100.0) >= (int)(k2 * 100.0)) {
                    return true;
                }
            }
        } else if (proteinType.equals("TRUNCATED")) {
            double k3;
            if (oldAngle < 0.7853981633974483 || oldAngle > 5.183627878423159) {
                k3 = 0.42;
                k3 = 0.252;
                if ((int)(halfSize * 2.0 * 100.0) >= (int)(k3 * 100.0)) {
                    return true;
                }
            }
            if (oldAngle > 2.356194490192345 && oldAngle < 3.9269908169872414 && halfSize * 2.0 >= (k3 = 0.42)) {
                return true;
            }
        } else if ((oldAngle > 2.356194490192345 && oldAngle < 3.9269908169872414 || oldAngle < 0.7853981633974483 || oldAngle > 5.497787143782138) && halfSize * 2.0 >= (k = 0.42)) {
            return true;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.residue != null && e.getSource().equals(this.sideCombo)) {
            String side = (String)this.sideCombo.getSelectedItem();
            this.residue.setSide(side);
            this.pDialog.repaint();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int angle;
        String type = (String)this.typeCombo.getSelectedItem();
        if (type == null || "".equals(type)) {
            return;
        }
        if ("residue".equals(type) && e.getSource().equals(this.angleSlider)) {
            angle = this.angleSlider.getValue();
            this.residue.setAngle((double)angle / 100.0);
            this.pDialog.repaint();
        }
        if ("binding region".equals(type)) {
            if (e.getSource().equals(this.angleSlider)) {
                angle = this.angleSlider.getValue();
                this.bindingRegion.setAngle((double)angle / 100.0);
                this.pDialog.repaint();
            }
            if (e.getSource().equals(this.sizeSlider)) {
                if (this.checkVerMaxSize()) {
                    return;
                }
                double oldHalfSize = this.bindingRegion.getSize() / 2.0;
                double halfSize = (double)this.sizeSlider.getValue() / 2.0 / 100.0;
                double oldAngle = this.bindingRegion.getAngle();
                this.bindingRegion.setSize(2.0 * halfSize);
                if (halfSize > oldHalfSize) {
                    this.resetAngle(oldAngle, oldHalfSize * 2.0);
                }
                this.pDialog.repaint();
            }
        }
    }

    private boolean resetAngle(double angle, double oldSizes) {
        if (this.bindingRegion == null) {
            return false;
        }
        int ret = this.checkSize(angle);
        if (ret == 0) {
            return false;
        }
        double newSize = this.bindingRegion.getSize();
        double newAngle = angle;
        double angle0 = 0.0;
        double angle1 = 0.0;
        double k = 1.0;
        double k2 = 1.0;
        double k3 = 1.0;
        String proteinType = this.bindingRegion.getProteinType();
        if (angle > 0.7853981633974483 && angle < 2.356194490192345) {
            angle0 = 0.7853981633974483;
            angle1 = 2.356194490192345;
            if (proteinType.equals("RECEPTOR")) {
                k2 = 1.0131712259371835;
            }
        } else if (angle > 2.356194490192345 && angle < 3.6128315516282616 && proteinType.equals("RECEPTOR")) {
            angle0 = 2.356194490192345;
            angle1 = 3.6128315516282616;
            k = 2.380952380952381;
        } else if (angle > 3.6128315516282616 && angle < 5.811946409141117 && proteinType.equals("RECEPTOR")) {
            angle0 = 3.6128315516282616;
            angle1 = 5.811946409141117;
            k2 = 1.0131712259371835;
            k3 = 1.4;
        } else if (angle > 5.811946409141117 && angle <= Math.PI * 2 && proteinType.equals("RECEPTOR")) {
            angle0 = 5.811946409141117;
            angle1 = Math.PI * 2;
            k = 2.380952380952381;
        } else if (angle <= 0.7853981633974483 && proteinType.equals("RECEPTOR")) {
            angle0 = 0.0;
            angle1 = 0.7853981633974483;
            k = 2.380952380952381;
        } else if (angle > 3.9269908169872414 && angle < 5.183627878423159 && proteinType.equals("TRUNCATED")) {
            if (newSize >= 0.8) {
                this.angleSlider.setValue(455);
                this.bindingRegion.setAngle(4.5553093477052);
                this.bindingRegion.setSize(0.8);
                return true;
            }
            angle0 = 3.9269908169872414;
            angle1 = 5.183627878423159;
        } else {
            if (angle > 5.183627878423159 && proteinType.equals("TRUNCATED")) {
                angle0 = 5.183627878423159;
                angle1 = Math.PI * 2;
                k = 4.761904761904762;
                k2 = 0.5;
                if (ret == -1) {
                    newAngle = angle1 - 0.5 * k * newSize * (angle1 - angle0) + 0.2198;
                }
                if (ret == 1) {
                    newAngle = angle0 + 0.5 * k * newSize * (angle1 - angle0);
                }
                this.angleSlider.setValue((int)(newAngle * 100.0));
                this.bindingRegion.setAngle(newAngle);
                return true;
            }
            if (angle < 0.7853981633974483 && proteinType.equals("TRUNCATED")) {
                angle0 = 0.0;
                angle1 = 0.7853981633974483;
                k = 4.8076923076923075;
                k = 4.960317460317461;
                k2 = 0.5;
            } else if (angle > 2.356194490192345 && angle < 3.9269908169872414) {
                angle0 = 2.356194490192345;
                angle1 = 3.9269908169872414;
                k = 2.380952380952381;
            } else if (angle > 3.9269908169872414 && angle < 5.497787143782138) {
                angle0 = 3.9269908169872414;
                angle1 = 5.497787143782138;
            } else if (angle < 0.7853981633974483 || angle > 5.497787143782138) {
                angle0 = 5.497787143782138;
                angle1 = 0.7853981633974483;
                k = 2.380952380952381;
                if (proteinType.equals("RECEPTOR")) {
                    k = 2.976190476190476;
                }
            }
        }
        if ((newAngle = ret == -1 ? angle1 - 0.25 * newSize * k2 * Math.PI * k * k3 : (angle0 == 0.0 && proteinType.equals("TRUNCATED") ? angle0 + 0.25 * newSize * k2 * Math.PI * k * k3 - 0.18 : angle0 + 0.25 * newSize * k2 * Math.PI * k * k3)) < 0.0 || newAngle > Math.PI * 2) {
            if (proteinType.equals("RECEPTOR")) {
                this.sizeSlider.setValue(33);
                this.bindingRegion.setSize(0.336);
                this.angleSlider.setValue(15);
                this.bindingRegion.setAngle(0.15707963267948966);
            }
            return true;
        }
        this.angleSlider.setValue((int)(newAngle * 100.0));
        this.bindingRegion.setAngle(newAngle);
        return true;
    }

    private int checkSize(double angle) {
        if (this.bindingRegion == null) {
            return 0;
        }
        String type = (String)this.typeCombo.getSelectedItem();
        if (type.equals("") || "residue".equals(type)) {
            return 0;
        }
        double maxSize = 0.0;
        double newSize = this.bindingRegion.getSize();
        double angle0 = 0.0;
        double angle1 = 0.0;
        double k1 = 1.0;
        double k2 = 1.0;
        double k3 = 1.0;
        String proteinType = this.bindingRegion.getProteinType();
        if (angle > 0.7853981633974483 && angle < 2.356194490192345) {
            angle0 = 0.7853981633974483;
            angle1 = 2.356194490192345;
            if (proteinType.equals("RECEPTOR")) {
                k2 = 0.987;
            }
        } else if (angle > 2.356194490192345 && angle < 3.6128315516282616 && proteinType.equals("RECEPTOR")) {
            angle0 = 2.356194490192345;
            angle1 = 3.6128315516282616;
            k1 = 0.42;
        } else if (angle > 3.6128315516282616 && angle < 5.811946409141117 && proteinType.equals("RECEPTOR")) {
            angle0 = 3.6128315516282616;
            angle1 = 5.811946409141117;
            k2 = 1.0309278350515465;
            k2 = 0.987;
            k3 = 1.4;
        } else {
            if (angle > 5.811946409141117 && angle <= Math.PI * 2 && proteinType.equals("RECEPTOR")) {
                k1 = 0.42;
                angle0 = 5.811946409141117;
                maxSize = k1 * k2 * 4.0 * (angle - angle0) / (k3 * Math.PI);
                if (newSize > maxSize) {
                    return 1;
                }
                return 0;
            }
            if (angle <= 0.7853981633974483 && proteinType.equals("RECEPTOR")) {
                k1 = 0.42;
                angle1 = 0.7853981633974483;
                maxSize = k1 * k2 * 4.0 * (angle1 - angle) / (k3 * Math.PI);
                if (newSize > maxSize) {
                    return -1;
                }
                return 0;
            }
            if (angle > 3.9269908169872414 && angle < 5.183627878423159 && proteinType.equals("TRUNCATED")) {
                angle0 = 3.9269908169872414;
                angle1 = 5.183627878423159;
            } else {
                if (angle > 5.183627878423159 && proteinType.equals("TRUNCATED")) {
                    k1 = 0.21;
                    angle1 = Math.PI * 2;
                    angle0 = 5.183627878423159;
                    maxSize = k1 * 2.0 * (angle1 - angle + 0.23) / (angle1 - angle0);
                    if (maxSize < 0.1) {
                        maxSize = 0.099;
                    }
                    if (newSize > maxSize) {
                        return -1;
                    }
                    maxSize = k1 * 2.0 * (angle - angle0) / (angle1 - angle0);
                    if (maxSize < 0.1) {
                        maxSize = 0.099;
                    }
                    if (newSize > maxSize) {
                        return 1;
                    }
                    return 0;
                }
                if (angle <= 0.7853981633974483 && proteinType.equals("TRUNCATED")) {
                    angle0 = 0.0;
                    angle1 = 0.7853981633974483;
                    k1 = 0.20159999999999997;
                    k2 = 2.0;
                } else if (angle > 2.356194490192345 && angle < 3.9269908169872414) {
                    angle0 = 2.356194490192345;
                    angle1 = 3.9269908169872414;
                    k1 = 0.42;
                } else if (angle > 3.9269908169872414 && angle < 5.497787143782138) {
                    angle0 = 3.9269908169872414;
                    angle1 = 5.497787143782138;
                } else {
                    if (angle < 0.7853981633974483) {
                        angle1 = 0.7853981633974483;
                        k1 = 0.42;
                        if (proteinType.equals("RECEPTOR")) {
                            k1 *= 0.8;
                        }
                        if (newSize > (maxSize = k1 * 4.0 * (angle1 - angle) / Math.PI)) {
                            return -1;
                        }
                        return 0;
                    }
                    if (angle > 5.497787143782138) {
                        angle0 = 5.497787143782138;
                        k1 = 0.42;
                        if (proteinType.equals("RECEPTOR")) {
                            k1 *= 0.8;
                        }
                        if (newSize > (maxSize = k1 * 4.0 * (angle - angle0) / Math.PI)) {
                            return 1;
                        }
                        return 0;
                    }
                }
            }
        }
        if ((maxSize = k1 * k2 * 4.0 * (angle1 - angle) / (k3 * Math.PI)) < 0.1) {
            maxSize = 0.099;
        }
        if (newSize > maxSize) {
            return -1;
        }
        maxSize = k1 * k2 * 4.0 * (angle - angle0) / (k3 * Math.PI);
        if (maxSize < 0.1) {
            maxSize = 0.099;
        }
        if (newSize > maxSize) {
            return 1;
        }
        return 0;
    }

    private void resetSizeSlider() {
        double size;
        if (this.bindingRegion == null) {
            return;
        }
        double oldAngle = this.bindingRegion.getAngle();
        String proteinType = this.bindingRegion.getProteinType();
        if (this.checkVerMaxSize()) {
            double k = 0.42;
            if (proteinType.equals("RECEPTOR")) {
                k *= 0.8;
                if (oldAngle < 0.7853981633974483 || oldAngle > 5.811946409141117) {
                    this.angleSlider.setValue(15);
                    this.bindingRegion.setAngle(0.15707963267948966);
                } else if (oldAngle > 2.356194490192345 && oldAngle < 3.6128315516282616) {
                    this.angleSlider.setValue(298);
                    this.bindingRegion.setAngle(2.9845130209103035);
                }
            } else if (proteinType.equals("TRUNCATED")) {
                if (oldAngle < 0.7853981633974483) {
                    k *= 0.6;
                    this.angleSlider.setValue(28);
                    this.bindingRegion.setAngle(0.2827433388230814);
                } else if (oldAngle > 5.183627878423159) {
                    k *= 0.6;
                    this.angleSlider.setValue(582);
                    this.bindingRegion.setAngle(5.827654372409066);
                } else if (oldAngle > 2.356194490192345 && oldAngle < 3.9269908169872414) {
                    k = 0.42;
                }
            }
            this.bindingRegion.setSize(k);
            if (proteinType.equals("RECEPTOR")) {
                this.sizeSlider.setValue((int)(k * 100.0 + 0.5));
            } else if (!proteinType.equals("TRUNCATED")) {
                this.sizeSlider.setValue((int)(k * 100.0));
                if (oldAngle < 0.7853981633974483) {
                    this.angleSlider.setValue(0);
                    this.bindingRegion.setAngle(0.0);
                } else if (oldAngle > 5.497787143782138) {
                    this.angleSlider.setValue(628);
                    this.bindingRegion.setAngle(Math.PI * 2);
                } else {
                    this.angleSlider.setValue(314);
                    this.bindingRegion.setAngle(Math.PI);
                }
            }
        }
        if (oldAngle > 3.9269908169872414 && oldAngle < 5.183627878423159 && proteinType.equals("TRUNCATED") && (size = (double)this.sizeSlider.getValue() / 100.0) > 0.8) {
            this.bindingRegion.setSize(0.8);
            this.sizeSlider.setValue(80);
        }
        if (oldAngle > 0.7853981633974483 && oldAngle < 2.356194490192345 && proteinType.equals("RECEPTOR")) {
            size = (double)this.sizeSlider.getValue() / 100.0;
            if (size >= 0.99) {
                this.bindingRegion.setSize(1.0);
                this.angleSlider.setValue(157);
                this.bindingRegion.setAngle(1.5707963267948966);
            }
        } else if (oldAngle > 3.6128315516282616 && oldAngle < 5.811946409141117 && proteinType.equals("RECEPTOR") && (size = (double)this.sizeSlider.getValue() / 100.0) >= 0.99) {
            this.bindingRegion.setSize(1.0);
            this.angleSlider.setValue(471);
            this.bindingRegion.setAngle(4.71238898038469);
        }
        this.pDialog.repaint();
    }

    private void resetAngleSlider() {
        if (this.bindingRegion == null) {
            return;
        }
        double angle = (double)this.angleSlider.getValue() / 100.0;
        double k = 0.42;
        String proteinType = this.bindingRegion.getProteinType();
        if (this.checkVerMaxSize()) {
            double size;
            double oldAngle = this.bindingRegion.getAngle();
            if (oldAngle > 2.356194490192345 && oldAngle < 3.6128315516282616 && proteinType.equals("RECEPTOR")) {
                k *= 0.8;
                this.angleSlider.setValue(298);
                this.bindingRegion.setAngle(2.9845130209103035);
            } else if ((oldAngle < 0.7853981633974483 || oldAngle > 5.811946409141117) && proteinType.equals("RECEPTOR")) {
                k *= 0.8;
                this.angleSlider.setValue(15);
                this.bindingRegion.setAngle(0.15707963267948966);
            } else if (oldAngle < 0.7853981633974483 && proteinType.equals("TRUNCATED")) {
                k *= 0.6;
                this.angleSlider.setValue(28);
                this.bindingRegion.setAngle(0.2827433388230814);
            } else if (oldAngle > 5.183627878423159 && proteinType.equals("TRUNCATED")) {
                k *= 0.6;
                this.angleSlider.setValue(582);
                this.bindingRegion.setAngle(5.827654372409066);
            } else if (oldAngle > 2.356194490192345 && oldAngle < 3.9269908169872414) {
                this.angleSlider.setValue(314);
                this.bindingRegion.setAngle(Math.PI);
            } else if (oldAngle < 0.7853981633974483) {
                this.angleSlider.setValue(0);
                this.bindingRegion.setAngle(0.0);
            } else {
                this.angleSlider.setValue(628);
                this.bindingRegion.setAngle(Math.PI * 2);
            }
            this.bindingRegion.setSize(k);
            if (proteinType.equals("RECEPTOR")) {
                this.sizeSlider.setValue((int)(k * 100.0 + 0.5));
            } else {
                this.sizeSlider.setValue((int)(k * 100.0));
            }
            if (oldAngle > 0.7853981633974483 && oldAngle < 2.356194490192345 && proteinType.equals("RECEPTOR")) {
                double size2 = (double)this.sizeSlider.getValue() / 100.0;
                if (size2 >= 0.99) {
                    this.bindingRegion.setSize(1.0);
                    this.angleSlider.setValue(157);
                    this.bindingRegion.setAngle(1.5707963267948966);
                }
            } else if (oldAngle > 3.6128315516282616 && oldAngle < 5.811946409141117 && proteinType.equals("RECEPTOR") && (size = (double)this.sizeSlider.getValue() / 100.0) >= 0.99) {
                this.bindingRegion.setSize(1.0);
                this.angleSlider.setValue(471);
                this.bindingRegion.setAngle(4.71238898038469);
            }
            this.pDialog.repaint();
            return;
        }
        if (!this.resetAngle(angle, this.bindingRegion.getSize())) {
            return;
        }
        this.pDialog.repaint();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.actionPerformed(e);
    }

    private void actionPerformed(ItemEvent e) {
        if (this.isEdit) {
            return;
        }
        if (e.getStateChange() != 1) {
            return;
        }
        String type = (String)this.typeCombo.getSelectedItem();
        if (type == null) {
            return;
        }
        if (type.equals("residue")) {
            if (this.isAdd) {
                this.isAdd = false;
                this.residue.setType(type);
                return;
            }
            if (this.pDialog instanceof ProteinDialog2) {
                ((ProteinDialog2)this.pDialog).getProteinPanel().readdResidue_performed();
                this.residue.setType(type);
            } else if (this.pDialog instanceof MonoSpeciesPropertyDialog) {
                ((MonoSpeciesPropertyDialog)this.pDialog).getProteinPanel().readdResidue_performed();
                this.residue.setType(type);
            }
        } else {
            this.sizeSlider.setEnabled(true);
            this.isAdd = false;
            if (this.pDialog instanceof ProteinDialog2) {
                if (this.bindingRegion == null) {
                    ((ProteinDialog2)this.pDialog).getProteinPanel().getModificationResidueDialog2().setBindingRegion(this.bindingRegion);
                }
                ((ProteinDialog2)this.pDialog).getProteinPanel().readdBindingRegion_performed();
                this.bindingRegion.setType(type);
            } else if (this.pDialog instanceof MonoSpeciesPropertyDialog) {
                if (this.bindingRegion == null) {
                    ((MonoSpeciesPropertyDialog)this.pDialog).getProteinPanel().getModificationResidueDialog2().setBindingRegion(this.bindingRegion);
                }
                ((MonoSpeciesPropertyDialog)this.pDialog).getProteinPanel().readdBindingRegion_performed();
                this.bindingRegion.setType(type);
            }
        }
    }

    private void closeButton_actionPerformed() {
        this.dispose();
    }

    private class TextFieldKeyListener
    extends KeyAdapter {
        private TextFieldKeyListener() {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            String name;
            String type = (String)ModificationResidueDialog2.this.typeCombo.getSelectedItem();
            if (ModificationResidueDialog2.this.residue != null && type.equals("residue")) {
                name = ModificationResidueDialog2.this.nameTextField.getText();
                ModificationResidueDialog2.this.residue.setName(name);
                ModificationResidueDialog2.this.pDialog.repaint();
            }
            if (ModificationResidueDialog2.this.bindingRegion != null && type.equals("binding region")) {
                name = ModificationResidueDialog2.this.nameTextField.getText();
                ModificationResidueDialog2.this.bindingRegion.setName(name);
                ModificationResidueDialog2.this.pDialog.repaint();
            }
        }
    }
}

