/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.sbmlExtension;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.PrintWriter;
import jp.sbi.celldesigner.plugin.PluginModificationResidue;
import jp.sbi.celldesigner.sbmlExtension.ModificationImpl;
import jp.sbi.celldesigner.sbmlExtension.ModificationShape;
import jp.sbi.sbml.SId;
import jp.sbi.sbml.SIdFormatException;
import jp.sbi.sbml.SpecInfo;
import org.sbml.libsbml.Species;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ModificationResidue
extends Species
implements ModificationImpl {
    public static final String SIDE_NONE = "none";
    public static final String SIDE_INSIDE = "inside";
    public static final String SIDE_OUTSIDE = "outside";
    public static final String TYPE_RESIDUE = "residue";
    public static final String TYPE_BINDINGREGION = "binding region";
    private String name;
    private String side;
    private double angle;
    private String type;
    private double size;

    public ModificationResidue() {
        this.initAttributes();
    }

    private void initAttributes() {
        try {
            SId.check("");
            super.setId("");
        }
        catch (SIdFormatException sIdFormatException) {
            // empty catch block
        }
        this.name = "";
        this.side = SIDE_NONE;
        this.angle = Math.PI;
        this.type = "";
        this.size = 0.0;
    }

    public Object clone() {
        ModificationResidue r = new ModificationResidue();
        try {
            r.setId(this.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        r.setName(this.name);
        r.setSide(this.side);
        r.setAngle(this.angle);
        r.setType(this.type);
        r.setSize(this.size);
        r.setAnnotation(this.getAnnotation());
        return r;
    }

    public boolean equals(ModificationResidue target) {
        if (!target.getId().equals(this.getId())) {
            return false;
        }
        if (!target.getName().equals(this.name)) {
            return false;
        }
        if (!target.getSide().equals(this.side)) {
            return false;
        }
        if (target.getAngle() != this.angle) {
            return false;
        }
        if (!target.getType().equals(this.type)) {
            return false;
        }
        return target.getSize() == this.size;
    }

    public boolean equals(PluginModificationResidue target) {
        if (!target.getId().equals(this.getId())) {
            return false;
        }
        if (!target.getName().equals(this.name)) {
            return false;
        }
        if (!target.getSide().equals(this.side)) {
            return false;
        }
        if (target.getAngle() != this.angle) {
            return false;
        }
        if (!target.getType().equals(this.type)) {
            return false;
        }
        return target.getSize() == this.size;
    }

    public void setName(String name) {
        this.name = name == null ? "" : name;
    }

    public String getName() {
        return this.name;
    }

    public void setType(String type) {
        this.type = type == null ? "" : type;
    }

    public String getType() {
        return this.type;
    }

    public void setSize(double size) {
        this.size = size;
    }

    public double getSize() {
        return this.size;
    }

    public void setSide(String side) {
        this.side = side == null ? "" : side;
    }

    public String getSide() {
        return this.side;
    }

    public void setAngle(double angle) {
        this.angle = angle;
    }

    public double getAngle() {
        return this.angle;
    }

    protected String getTagName(SpecInfo spec) {
        return "celldesigner:modificationResidue";
    }

    protected String[] getAttributeNames(SpecInfo spec) {
        return new String[]{"id", "name", "type", "size", "side", "angle"};
    }

    protected String[] getAttributeShortNames() {
        return new String[]{"id", "name", "type", "size", "side", "angle"};
    }

    protected int[] getAttributeColumnSizes() {
        return new int[]{70, 150, 85, 10, 10};
    }

    protected String[] getAttributeValues(SpecInfo spec) {
        return new String[]{this.getId(), this.getName(), this.getType(), Double.toString(this.getSize()), this.getSide(), Double.toString(this.getAngle())};
    }

    protected String[] getDefaultValues(SpecInfo spec) {
        ModificationResidue initialResidue = new ModificationResidue();
        return initialResidue.getAttributeValues(spec);
    }

    protected void setAttributeValues(String[] values, SpecInfo spec) throws Exception {
        String str;
        this.initAttributes();
        if (!values[0].equals("")) {
            SId.check(values[0]);
            super.setId(values[0]);
        }
        if (!values[1].equals("")) {
            this.setName(values[1]);
        }
        if (!values[2].equals("")) {
            this.setSide(values[2]);
        }
        if (!values[3].equals("")) {
            str = values[3];
            double size = Double.parseDouble(str);
            this.setSize(size);
        }
        if (!values[4].equals("")) {
            this.setSide(values[4]);
        }
        if (!values[5].equals("")) {
            str = values[5];
            double angle = Double.parseDouble(str);
            this.setAngle(angle);
        }
    }

    protected void releaseAllMembers() {
    }

    protected boolean hasChildNodes() {
        return false;
    }

    protected void readChildNodes(Node node, SpecInfo spec) throws Exception {
    }

    protected void readChildNodesDOMTree(Element element, SpecInfo spec) throws Exception {
    }

    protected void writeChildNodes(String indent, PrintWriter pw, SpecInfo spec) {
    }

    protected void writeChildNodesDOMTree(Node node, SpecInfo spec) {
    }

    @Override
    public Rectangle2D.Double getNameBounds(ModificationShape mShape, Graphics2D g2, Ellipse2D.Double ellipse, Rectangle2D.Double rect) {
        FontMetrics fmOutside = g2.getFontMetrics();
        if (this.name != null && !this.name.equals("")) {
            String name = " " + this.name + " ";
            int w = fmOutside.stringWidth(name);
            int h = (int)((double)fmOutside.getAscent() - (double)fmOutside.getDescent() * 0.5);
            Rectangle2D.Double nameBounds = new Rectangle2D.Double(0.0, 0.0, w, h);
            ModificationShape.calcBoundsXYWithWidthAndHeight(nameBounds, ellipse.getBounds2D());
            double angle = mShape.getRealAngle(this.angle);
            Point2D.Double dif = mShape.createDif(angle);
            double dx = dif.x;
            double dy = dif.y;
            while (ellipse.intersects(nameBounds)) {
                nameBounds.x -= dx;
                nameBounds.y -= dy;
            }
            return (Rectangle2D.Double)nameBounds.clone();
        }
        return null;
    }
}

