/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.sbmlExtension;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.sbi.celldesigner.sbmlExtension.AntiSenseRNADialog2;
import jp.sbi.celldesigner.sbmlExtension.GeneDialog2;
import jp.sbi.celldesigner.sbmlExtension.ModificationRegion;
import jp.sbi.celldesigner.sbmlExtension.RNADialog2;

public class ModificationRegionDialog2
extends JDialog
implements ChangeListener,
ItemListener {
    JDialog pDialog;
    ModificationRegion region;
    private String[] typeStrsForGene = new String[]{"Modification Site", "CodingRegion", "RegulatoryRegion", "transcriptionStartingSiteL", "transcriptionStartingSiteR"};
    private JRadioButton activeTrueRadio;
    private JRadioButton activeFalseRadio;
    private String[] typeStrsForRNA = new String[]{"CodingRegion", "proteinBindingDomain", "Modification Site"};
    private JPanel panel;
    private JTextField idTextField;
    private JTextField nameTextField;
    private JComboBox typeCombo = null;
    private JComboBox typeComboGene;
    private JComboBox typeComboRNA;
    private JSlider sizeSlider;
    private JSlider posSlider;
    private JButton closeButton;
    JRootPane rootPane;
    private boolean isFirst = true;
    private TextFieldKeyListener textFieldKeyListener;

    public ModificationRegionDialog2(JDialog pDialog) {
        super(pDialog);
        this.setTitle("Modification Region");
        this.pDialog = pDialog;
        this.setModal(true);
        JPanel panel = this.createDialogPanel();
        this.getContentPane().add(panel);
        this.setSize(new Dimension(panel.getWidth() + 20, panel.getHeight() + 45));
    }

    protected JPanel createDialogPanel() {
        this.rootPane = this.getRootPane();
        this.panel = new JPanel();
        this.panel.setLayout(null);
        JLabel idLabel = new JLabel("id");
        idLabel.setBounds(new Rectangle(10, 4, 60, 20));
        this.panel.add((Component)idLabel, null);
        this.idTextField = new JTextField();
        this.idTextField.setBounds(new Rectangle(75, 4, 220, 20));
        this.idTextField.setEditable(false);
        this.idTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ModificationRegionDialog2.this.rootPane.setDefaultButton(ModificationRegionDialog2.this.closeButton);
            }
        });
        this.panel.add((Component)this.idTextField, null);
        JLabel nameLabel = new JLabel("name");
        nameLabel.setBounds(new Rectangle(10, 28, 120, 20));
        this.panel.add((Component)nameLabel, null);
        this.nameTextField = new JTextField();
        this.nameTextField.setBounds(new Rectangle(75, 28, 220, 20));
        this.nameTextField.setEditable(true);
        this.nameTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ModificationRegionDialog2.this.rootPane.setDefaultButton(ModificationRegionDialog2.this.closeButton);
            }
        });
        this.textFieldKeyListener = new TextFieldKeyListener();
        this.nameTextField.addKeyListener(this.textFieldKeyListener);
        this.panel.add((Component)this.nameTextField, null);
        JLabel sideLabel = new JLabel("type");
        sideLabel.setBounds(new Rectangle(10, 52, 120, 20));
        this.panel.add((Component)sideLabel, null);
        this.typeComboGene = new JComboBox<String>(this.typeStrsForGene);
        this.typeComboGene.setBounds(new Rectangle(75, 52, 220, 20));
        this.typeComboGene.setSelectedIndex(0);
        this.typeComboGene.addItemListener(this);
        this.typeComboRNA = new JComboBox<String>(this.typeStrsForRNA);
        this.typeComboRNA.setBounds(new Rectangle(75, 52, 220, 20));
        this.typeComboRNA.setSelectedIndex(0);
        this.typeComboRNA.addItemListener(this);
        this.typeCombo = this.typeComboGene;
        this.panel.add((Component)this.typeCombo, null);
        JLabel activeLabel = new JLabel("active");
        activeLabel.setBounds(new Rectangle(10, 76, 120, 20));
        this.panel.add((Component)activeLabel, null);
        this.activeTrueRadio = new JRadioButton("True");
        this.activeFalseRadio = new JRadioButton("False");
        this.activeTrueRadio.setBounds(75, 76, 70, 20);
        this.activeFalseRadio.setBounds(165, 76, 70, 20);
        ButtonGroup activeGroup = new ButtonGroup();
        activeGroup.add(this.activeTrueRadio);
        activeGroup.add(this.activeFalseRadio);
        MyRadioButtonListener listener = new MyRadioButtonListener();
        this.activeTrueRadio.addActionListener(listener);
        this.activeFalseRadio.addActionListener(listener);
        this.panel.add((Component)this.activeTrueRadio, null);
        this.panel.add((Component)this.activeFalseRadio, null);
        JLabel sizeLabel = new JLabel("size");
        sizeLabel.setBounds(new Rectangle(10, 100, 120, 20));
        this.panel.add((Component)sizeLabel, null);
        this.sizeSlider = new JSlider(0, 0, 100, 0);
        this.sizeSlider.setPaintTicks(false);
        int sizeSliderHeight = (int)this.sizeSlider.getPreferredSize().getHeight();
        this.sizeSlider.setValue(40);
        this.sizeSlider.setBounds(new Rectangle(75, 100, 220, sizeSliderHeight));
        this.sizeSlider.addChangeListener(this);
        this.panel.add((Component)this.sizeSlider, null);
        int posY = 100 + sizeSliderHeight + 5;
        JLabel posLabel = new JLabel("position");
        posLabel.setBounds(new Rectangle(10, posY, 120, 20));
        this.panel.add((Component)posLabel, null);
        this.posSlider = new JSlider(0, 0, 100, 0);
        this.posSlider.setPaintTicks(false);
        int posSliderHeight = (int)this.posSlider.getPreferredSize().getHeight();
        this.posSlider.setValue(30);
        int w = this.posSlider.getPreferredSize().width;
        int h = this.posSlider.getPreferredSize().height;
        this.posSlider.setBounds(new Rectangle(75, posY, 220, h));
        this.posSlider.addChangeListener(this);
        this.panel.add((Component)this.posSlider, null);
        int closeY = posY + posSliderHeight + 5;
        this.closeButton = new JButton("Close");
        this.closeButton.setMnemonic(67);
        this.closeButton.setBounds(new Rectangle(110, closeY, 80, 25));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModificationRegionDialog2.this.closeButton_actionPerformed();
            }
        });
        this.closeButton.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ModificationRegionDialog2.this.rootPane.setDefaultButton(ModificationRegionDialog2.this.closeButton);
            }
        });
        this.panel.add((Component)this.closeButton, null);
        this.panel.setSize(this.posSlider.getX() + this.posSlider.getWidth(), this.closeButton.getY() + this.closeButton.getHeight());
        return this.panel;
    }

    public void initDialog() {
        this.idTextField.setText("");
        this.nameTextField.setText("");
        this.sizeSlider.setValue(40);
        this.posSlider.setValue(30);
    }

    public void enableDialog(boolean isEnabled) {
        this.nameTextField.setEnabled(isEnabled);
        this.typeCombo.setEnabled(isEnabled);
        this.sizeSlider.setEnabled(isEnabled);
        this.posSlider.setEnabled(isEnabled);
    }

    public void releaseAll() {
        this.nameTextField.removeKeyListener(this.textFieldKeyListener);
        this.pDialog = null;
        this.region = null;
    }

    @Override
    public void show() {
        if (this.isFirst) {
            Point p = this.pDialog.getLocation();
            Dimension d = this.pDialog.getSize();
            this.setLocation(p.x, p.y + (int)((double)d.height * 0.7));
            this.isFirst = false;
        }
        super.show();
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            this.pDialog.repaint();
        }
    }

    public void setComboItemForGene() {
        this.panel.remove(this.typeCombo);
        this.typeCombo = this.typeComboGene;
        this.panel.add((Component)this.typeCombo, null);
    }

    public void setComboItemForRNA() {
        this.panel.remove(this.typeCombo);
        this.typeCombo = this.typeComboRNA;
        this.panel.add((Component)this.typeCombo, null);
    }

    protected void setModificationRegion(ModificationRegion region) {
        if (region == null) {
            this.region = null;
            this.initDialog();
            this.enableDialog(false);
            return;
        }
        this.enableDialog(true);
        this.region = region;
        String id = region.getId();
        this.idTextField.setText(id);
        this.idTextField.setCaretPosition(id.length());
        String name = region.getName();
        this.nameTextField.setText(name);
        this.nameTextField.setCaretPosition(name.length());
        String type = region.getType();
        double size = region.getSize();
        this.activeTrueRadio.setSelected(region.getActive());
        this.activeFalseRadio.setSelected(!region.getActive());
        if (type.equals("RegulatoryRegion") || type.equals("CodingRegion")) {
            this.sizeSlider.setMinimum(10);
            this.sizeSlider.setValue((int)(size * 100.0));
            this.sizeSlider.setEnabled(true);
            this.activeTrueRadio.setEnabled(false);
            this.activeFalseRadio.setEnabled(false);
        } else if (type.equals("Modification Site")) {
            this.sizeSlider.setMinimum(0);
            this.sizeSlider.setValue((int)(size * 100.0));
            this.sizeSlider.setEnabled(false);
            this.activeTrueRadio.setEnabled(false);
            this.activeFalseRadio.setEnabled(false);
        } else if (region.getType().equals("transcriptionStartingSiteL") || region.getType().equals("transcriptionStartingSiteR")) {
            this.sizeSlider.setMinimum(10);
            this.sizeSlider.setValue((int)(size * 100.0));
            this.sizeSlider.setEnabled(true);
            this.activeTrueRadio.setEnabled(true);
            this.activeFalseRadio.setEnabled(true);
        } else {
            this.sizeSlider.setMinimum(10);
            this.sizeSlider.setValue((int)(size * 100.0));
            this.sizeSlider.setEnabled(true);
        }
        double pos = region.getPos();
        double halfSize = region.getSize() / 2.0;
        this.posSlider.setValue((int)(100.0 * (pos + halfSize)));
        if (this.pDialog instanceof GeneDialog2) {
            int i = 0;
            while (i < this.typeStrsForGene.length) {
                if (type.equals(this.typeStrsForGene[i])) {
                    this.typeCombo.setSelectedIndex(i);
                    break;
                }
                ++i;
            }
        } else if (this.pDialog instanceof RNADialog2 || this.pDialog instanceof AntiSenseRNADialog2) {
            int i = 0;
            while (i < this.typeStrsForRNA.length) {
                if (type.equals(this.typeStrsForRNA[i])) {
                    this.typeCombo.setSelectedIndex(i);
                    break;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.typeStrsForGene.length) {
                if (type.equals(this.typeStrsForGene[i])) {
                    this.typeCombo.setSelectedIndex(i);
                    break;
                }
                ++i;
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.actionPerformed(e);
    }

    private void actionPerformed(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        String type = (String)this.typeCombo.getSelectedItem();
        if (type == null) {
            return;
        }
        if (type.equals("RegulatoryRegion") || type.equals("CodingRegion")) {
            this.sizeSlider.setMinimum(10);
            if ((this.pDialog instanceof RNADialog2 || this.pDialog instanceof AntiSenseRNADialog2) && this.region != null && this.region.getSize() < 0.3) {
                this.region.setSize(0.3);
                this.sizeSlider.setValue((int)(this.region.getSize() * 100.0));
            }
            this.sizeSlider.setEnabled(true);
            this.activeTrueRadio.setEnabled(false);
            this.activeFalseRadio.setEnabled(false);
            this.activeTrueRadio.setSelected(false);
            this.activeFalseRadio.setSelected(true);
        } else if (type.equals("Modification Site")) {
            this.sizeSlider.setEnabled(false);
            this.sizeSlider.setMinimum(0);
            this.sizeSlider.setValue(0);
            this.activeTrueRadio.setEnabled(false);
            this.activeFalseRadio.setEnabled(false);
            this.activeTrueRadio.setSelected(false);
            this.activeFalseRadio.setSelected(true);
        } else if (type.equals("transcriptionStartingSiteL") || type.equals("transcriptionStartingSiteR")) {
            this.sizeSlider.setMinimum(10);
            this.sizeSlider.setEnabled(true);
            this.activeTrueRadio.setEnabled(true);
            this.activeFalseRadio.setEnabled(true);
            if (this.region != null) {
                this.activeTrueRadio.setSelected(this.region.getActive());
                this.activeFalseRadio.setSelected(!this.region.getActive());
            } else {
                this.activeTrueRadio.setSelected(false);
                this.activeFalseRadio.setSelected(true);
            }
        } else {
            this.sizeSlider.setEnabled(true);
            this.sizeSlider.setMinimum(10);
        }
        if (this.region != null && e.getSource().equals(this.typeCombo)) {
            this.region.setType(type);
            this.pDialog.repaint();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.region != null) {
            double halfSize;
            if (e.getSource().equals(this.sizeSlider)) {
                double oldHalfSize = this.region.getSize() / 2.0;
                halfSize = (double)(this.sizeSlider.getValue() / 2) / 100.0;
                this.region.setSize(2.0 * halfSize);
                double maxPos = 1.0 - 2.0 * halfSize;
                double pos = this.region.getPos() + oldHalfSize - halfSize;
                if (pos > maxPos) {
                    pos = maxPos;
                } else if (pos < 0.0) {
                    pos = 0.0;
                }
                this.posSlider.setValue((int)(100.0 * (pos + halfSize)));
                this.region.setPos(pos);
                this.pDialog.repaint();
            }
            if (e.getSource().equals(this.posSlider)) {
                double centerpos = (double)this.posSlider.getValue() / 100.0;
                double pos = centerpos - (halfSize = this.region.getSize() / 2.0);
                if (pos < 0.0) {
                    pos = 0.0;
                } else if (pos > 1.0 - 2.0 * halfSize) {
                    pos = 1.0 - 2.0 * halfSize;
                }
                this.region.setPos(pos);
                this.pDialog.repaint();
            }
        }
    }

    private void closeButton_actionPerformed() {
        this.dispose();
    }

    protected class MyRadioButtonListener
    implements ActionListener {
        protected MyRadioButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ModificationRegionDialog2.this.region == null) {
                return;
            }
            if (e.getSource() == ModificationRegionDialog2.this.activeTrueRadio) {
                ModificationRegionDialog2.this.region.setActive(true);
                ModificationRegionDialog2.this.pDialog.repaint();
            } else if (e.getSource() == ModificationRegionDialog2.this.activeFalseRadio) {
                ModificationRegionDialog2.this.region.setActive(false);
                ModificationRegionDialog2.this.pDialog.repaint();
            }
        }
    }

    private class TextFieldKeyListener
    extends KeyAdapter {
        private TextFieldKeyListener() {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (ModificationRegionDialog2.this.region != null) {
                String name = ModificationRegionDialog2.this.nameTextField.getText();
                ModificationRegionDialog2.this.region.setName(name);
                ModificationRegionDialog2.this.pDialog.repaint();
            }
        }
    }
}

