/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.sbmlExtension;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.PrintWriter;
import jp.sbi.celldesigner.plugin.PluginModificationRegion;
import jp.sbi.celldesigner.sbmlExtension.ModificationImpl;
import jp.sbi.celldesigner.sbmlExtension.ModificationShape;
import jp.sbi.celldesigner.symbol.species.SpeciesSymbolImpl;
import jp.sbi.sbml.SId;
import jp.sbi.sbml.SIdFormatException;
import jp.sbi.sbml.SpecInfo;
import org.sbml.libsbml.Species;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ModificationRegion
extends Species
implements ModificationImpl {
    public static final String TYPE_PROTEIN_BINDING_DOMAIN = "proteinBindingDomain";
    public static final String TYPE_EMPTY = "empty";
    public static final String TYPE_PROMOTOR = "promotor";
    public static final String TYPE_CODING_REGION_OLD = "codingRegion";
    public static final String TYPE_TRANSCRIPTION_STARTING_POINT_L = "transcriptionStartingPointL";
    public static final String TYPE_TRANSCRIPTION_STARTING_POINT_R = "transcriptionStartingPointR";
    public static final String TYPE_EXON = "exon";
    public static final String TYPE_MODIFICATION_SITE = "Modification Site";
    public static final String TYPE_CODING_REGION = "CodingRegion";
    public static final String TYPE_REGULATORY_REGION = "RegulatoryRegion";
    public static final String TYPE_TRANSCRIPTION_STARTING_SITE_L = "transcriptionStartingSiteL";
    public static final String TYPE_TRANSCRIPTION_STARTING_SITE_R = "transcriptionStartingSiteR";
    public static final double MINIMUM_SIZE_DNAMETYLATION = 0.0;
    private boolean active;
    public static final double MINIMUM_SIZE_ANY = 0.1;
    private String name;
    private String type;
    private double size;
    private double pos;

    public ModificationRegion() {
        this.initAttributes();
    }

    private void initAttributes() {
        try {
            SId.check("");
            super.setId("");
        }
        catch (SIdFormatException sIdFormatException) {
            // empty catch block
        }
        this.name = "";
        this.type = TYPE_EMPTY;
        this.size = 0.4;
        this.pos = 0.3;
        this.active = false;
    }

    public Object clone() {
        ModificationRegion r = new ModificationRegion();
        try {
            r.setId(this.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        r.setName(this.name);
        r.setType(this.type);
        r.setSize(this.size);
        r.setPos(this.pos);
        r.setActive(this.active);
        return r;
    }

    public boolean equals(ModificationRegion target) {
        if (!target.getId().equals(this.getId())) {
            return false;
        }
        if (!target.getName().equals(this.name)) {
            return false;
        }
        if (!target.getType().equals(this.type)) {
            return false;
        }
        if (target.getSize() != this.size) {
            return false;
        }
        if (target.getPos() != this.pos) {
            return false;
        }
        return target.getActive() == this.active;
    }

    public boolean equals(PluginModificationRegion target) {
        if (!target.getId().equals(this.getId())) {
            return false;
        }
        if (!target.getName().equals(this.name)) {
            return false;
        }
        if (!target.getType().equals(this.type)) {
            return false;
        }
        if (target.getSize() != this.size) {
            return false;
        }
        return target.getPos() == this.pos;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean getActive() {
        return this.active;
    }

    public void setName(String name) {
        this.name = name == null ? "" : name;
    }

    public String getName() {
        return this.name;
    }

    public void setType(String type) {
        this.type = this.name == null ? "" : type;
    }

    public String getType() {
        return this.type;
    }

    public void setSize(double size) {
        this.size = size;
    }

    public double getSize() {
        return this.size;
    }

    public void setPos(double pos) {
        this.pos = pos;
    }

    public double getPos() {
        return this.pos;
    }

    protected String getTagName(SpecInfo spec) {
        return "celldesigner:region";
    }

    protected String[] getAttributeNames(SpecInfo spec) {
        return new String[]{"id", "name", "type", "size", "pos", "active"};
    }

    protected String[] getAttributeShortNames() {
        return new String[]{"id", "name", "type", "size", "pos", "active"};
    }

    protected int[] getAttributeColumnSizes() {
        return new int[]{70, 150, 85, 10, 10, 20};
    }

    protected String[] getAttributeValues(SpecInfo spec) {
        return new String[]{this.getId(), this.getName(), this.getType(), Double.toString(this.getSize()), Double.toString(this.getPos()), Boolean.toString(this.getActive())};
    }

    protected String[] getDefaultValues(SpecInfo spec) {
        ModificationRegion initialRegion = new ModificationRegion();
        return initialRegion.getAttributeValues(spec);
    }

    protected void setAttributeValues(String[] values, SpecInfo spec) throws Exception {
        String str;
        this.initAttributes();
        if (!values[0].equals("")) {
            SId.check(values[0]);
            super.setId(values[0]);
        }
        if (!values[1].equals("")) {
            this.setName(values[1]);
        }
        if (!values[2].equals("")) {
            this.setType(values[2]);
        }
        if (!values[3].equals("")) {
            str = values[3];
            double size = Double.parseDouble(str);
            this.setSize(size);
        }
        if (!values[4].equals("")) {
            str = values[4];
            double pos = Double.parseDouble(str);
            this.setPos(pos);
        }
        if (values.length > 5 && !values[5].equals("")) {
            str = values[5];
            boolean active = Boolean.valueOf(str);
            this.setActive(active);
        }
    }

    protected void releaseAllMembers() {
    }

    protected boolean hasChildNodes() {
        return false;
    }

    protected void readChildNodes(Node node, SpecInfo spec) throws Exception {
    }

    protected void readChildNodesDOMTree(Element element, SpecInfo spec) throws Exception {
    }

    protected void writeChildNodes(String indent, PrintWriter pw, SpecInfo spec) {
    }

    protected void writeChildNodesDOMTree(Node node, SpecInfo spec) {
    }

    @Override
    public Rectangle2D.Double getNameBounds(ModificationShape mShape, Graphics2D g2, Ellipse2D.Double ellipse, Rectangle2D.Double rect) {
        FontMetrics fmOutside = g2.getFontMetrics();
        if (TYPE_MODIFICATION_SITE.equals(this.type)) {
            return this.getModificationSiteNameBounds(fmOutside, ellipse);
        }
        if (TYPE_CODING_REGION.equals(this.type) || TYPE_REGULATORY_REGION.equals(this.type) || TYPE_PROTEIN_BINDING_DOMAIN.equals(this.type)) {
            return this.getAdjustedRegionNameBounds(mShape, fmOutside, rect);
        }
        if (TYPE_TRANSCRIPTION_STARTING_SITE_L.equals(this.type) || TYPE_TRANSCRIPTION_STARTING_SITE_R.equals(this.type)) {
            return this.getTranscriptionNameBounds(mShape, fmOutside, rect);
        }
        return null;
    }

    private Rectangle2D.Double getModificationSiteNameBounds(FontMetrics fmOutside, Ellipse2D.Double ellipse) {
        if (this.name != null && !this.name.equals("")) {
            String name = " " + this.name + " ";
            int w = fmOutside.stringWidth(name);
            int h = (int)((double)fmOutside.getAscent() - (double)fmOutside.getDescent() * 0.5);
            Rectangle2D.Double nameBounds = new Rectangle2D.Double(ellipse.getX() - ((double)w - ellipse.getWidth()) / 2.0, ellipse.getY() - (double)h, w, h);
            nameBounds.y -= (double)fmOutside.getDescent() * 0.5;
            return (Rectangle2D.Double)nameBounds.clone();
        }
        return null;
    }

    private Rectangle2D.Double getOtherRegionNameBounds(ModificationShape mShape, FontMetrics fmOutside, Rectangle2D.Double rect) {
        if (this.name != null && !this.name.equals("")) {
            String name = " " + this.name + " ";
            int w = fmOutside.stringWidth(name);
            int h = (int)((double)fmOutside.getAscent() - (double)fmOutside.getDescent() * 0.5);
            Rectangle2D.Double nameBounds = new Rectangle2D.Double(0.0, 0.0, w, h);
            ModificationShape.calcBoundsXYWithWidthAndHeight(nameBounds, rect);
            Point2D.Double dif = mShape.createDifForTranscript(this.pos);
            double dx = dif.x;
            double dy = dif.y;
            while (rect.intersects(nameBounds)) {
                nameBounds.x -= dx;
                nameBounds.y -= dy;
            }
            return (Rectangle2D.Double)nameBounds.clone();
        }
        return null;
    }

    private Rectangle2D.Double getAdjustedRegionNameBounds(ModificationShape mShape, FontMetrics fmOutside, Rectangle2D.Double rect) {
        Rectangle2D.Double bounds = this.getOtherRegionNameBounds(mShape, fmOutside, rect);
        if (bounds != null) {
            mShape.adjustNameBoundsPosition(fmOutside, bounds);
            return (Rectangle2D.Double)bounds.clone();
        }
        return null;
    }

    private Rectangle2D.Double getTranscriptionNameBounds(ModificationShape mShape, FontMetrics fmOutside, Rectangle2D.Double rect) {
        if (mShape == null) {
            return null;
        }
        if (fmOutside == null) {
            return null;
        }
        if (rect == null) {
            return null;
        }
        if (this.name != null && !this.name.equals("")) {
            String name = " " + this.name + " ";
            int w = fmOutside.stringWidth(name);
            int h = (int)((double)fmOutside.getAscent() - (double)fmOutside.getDescent() * 0.5);
            Rectangle2D.Double nameBounds = new Rectangle2D.Double(rect.getX() - ((double)w - rect.getWidth()) / 2.0, rect.getY() - (double)h, w, h);
            if (mShape.getSpeciesSymbol() != null) {
                nameBounds.y = ((SpeciesSymbolImpl)mShape.getSpeciesSymbol()).isInSBGNViewer() ? (nameBounds.y -= (double)fmOutside.getDescent() * 0.5) : nameBounds.y - 8.0 - (double)fmOutside.getDescent() * 0.5;
            }
            return (Rectangle2D.Double)nameBounds.clone();
        }
        return null;
    }
}

