/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.sbmlExtension;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ModelNotesDialog
extends JDialog {
    public static final int APPROVE_OPTION = 1;
    public static final int CANCEL_OPTION = 2;
    private Frame owner;
    private boolean isFirstShowing = true;
    private int lastOption = 0;
    private JTextArea textArea;
    private JButton okButton;
    private JButton cancelButton;
    private String notesString = "";

    public ModelNotesDialog(Frame owner, String title) {
        super(owner);
        super.setTitle(title);
        this.owner = owner;
        this.setModal(true);
        this.initDialog();
    }

    private void initDialog() {
        final JRootPane rootPane = this.getRootPane();
        JPanel panel = new JPanel();
        this.textArea = new JTextArea();
        this.textArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                rootPane.setDefaultButton(ModelNotesDialog.this.okButton);
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.textArea);
        scrollPane.setAutoscrolls(true);
        this.okButton = new JButton("OK");
        this.okButton.setMnemonic(79);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelNotesDialog.this.okButton_selected();
            }
        });
        this.okButton.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                rootPane.setDefaultButton(ModelNotesDialog.this.okButton);
            }
        });
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setMnemonic(67);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelNotesDialog.this.cancelButton_selected();
            }
        });
        this.cancelButton.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                rootPane.setDefaultButton(ModelNotesDialog.this.cancelButton);
            }
        });
        JPanel buttonPane = new JPanel();
        buttonPane.add((Component)this.okButton, null);
        buttonPane.add((Component)this.cancelButton, null);
        Container contentPane = this.getContentPane();
        contentPane.add((Component)scrollPane, "Center");
        contentPane.add((Component)buttonPane, "South");
        this.setSize(400, 270);
    }

    public void releaseAll() {
        this.owner = null;
    }

    public void setText(String notesString) {
        this.notesString = notesString;
    }

    public String getText() {
        return this.notesString;
    }

    public int showDialog() {
        this.textArea.setText(this.notesString);
        if (this.isFirstShowing) {
            Point p = this.owner.getLocation();
            Dimension he = this.owner.getSize();
            Dimension me = this.getSize();
            int x = p.x + (he.width - me.width) / 2;
            int y = p.y + (he.height - me.height) / 2;
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            this.setLocation(x, y);
            this.isFirstShowing = false;
        }
        this.show();
        return this.lastOption;
    }

    @Override
    public void show() {
        this.getRootPane().setDefaultButton(this.okButton);
        super.show();
    }

    private void okButton_selected() {
        this.notesString = this.textArea.getText();
        this.lastOption = 1;
        this.dispose();
    }

    private void cancelButton_selected() {
        this.lastOption = 2;
        this.dispose();
    }
}

