/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.sbmlExtension;

import java.io.PrintWriter;
import java.util.HashMap;
import jp.sbi.sbml.Any;
import jp.sbi.sbml.util.XMLUtil;
import org.sbml.libsbml.SBase;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ModelNotes
implements Any {
    private String text = "";

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public String[] getAttributeNames() {
        return new String[0];
    }

    @Override
    public String[] getAttributeShortNames() {
        return new String[0];
    }

    @Override
    public int[] getAttributeColumnSizes() {
        return new int[0];
    }

    @Override
    public String[] getAttributeValues() {
        return new String[0];
    }

    @Override
    public boolean hasValue() {
        return !this.text.equals("");
    }

    public void readXML(Node node) throws Exception {
        char c;
        String tabedText = XMLUtil.getValue(node);
        char[] original = tabedText.toCharArray();
        int startIndex = 0;
        int endIndex = original.length;
        int i = 0;
        while (i < original.length) {
            c = original[i];
            if (c != '\t' && c != '\n' && c != '\r') break;
            ++i;
        }
        startIndex = i;
        i = original.length - 1;
        while (-1 < i) {
            c = original[i];
            if (c != '\t' && c != '\n' && c != '\r') break;
            --i;
        }
        endIndex = i + 1;
        if (startIndex < endIndex) {
            this.text = tabedText.substring(startIndex, endIndex);
        }
    }

    @Override
    public void readDOMTree(Element element) throws Exception {
        String URI2 = element.getNamespaceURI();
        NodeList childlist = element.getChildNodes();
        int childsize = childlist.getLength();
        Node listNode = null;
        int j = 0;
        while (j < childsize) {
            Node temp = childlist.item(j);
            if (temp.getNodeType() == 3) {
                listNode = temp;
                break;
            }
            ++j;
        }
        if (listNode != null) {
            this.text = listNode.getNodeValue();
        }
    }

    public void writeXML(String indent, PrintWriter pw) {
        pw.println(String.valueOf(indent) + this.text);
    }

    @Override
    public void writeDOMTree(Node node) {
        Document doc = node.getOwnerDocument();
        node.appendChild(doc.createTextNode(this.text));
    }

    @Override
    public void releaseAllMembers() {
    }

    @Override
    public void setParentSBase(SBase sbase) {
    }

    @Override
    public HashMap getLocalNS() {
        return null;
    }
}

