/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.sbmlExtension;

import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JDialog;
import jp.co.mki.celldesigner.simulation.util.StringTool;
import jp.fric.graphics.draw.GContainer;
import jp.fric.graphics.draw.GEditPoint;
import jp.fric.graphics.draw.GElement;
import jp.fric.graphics.draw.GElementImpl;
import jp.fric.graphics.draw.GFramedContainer;
import jp.fric.graphics.draw.GGroup;
import jp.fric.graphics.draw.GLinkPositionInfo;
import jp.fric.graphics.draw.GLinkTarget;
import jp.fric.graphics.draw.GLinkedCreaseLine;
import jp.fric.graphics.draw.GLinkedLine;
import jp.fric.graphics.draw.GLinkedLineComplex3;
import jp.fric.graphics.draw.GLinkedShape;
import jp.fric.graphics.draw.GPointedContainer;
import jp.fric.graphics.draw.GStructure;
import jp.fric.graphics.draw.ShapeUtil;
import jp.fric.util.Debug;
import jp.fric.util.NameSpace;
import jp.sbi.celldesigner.ClosedCompartmentAlias;
import jp.sbi.celldesigner.CompartmentAlias;
import jp.sbi.celldesigner.ComplexProperty;
import jp.sbi.celldesigner.ComplexSpeciesAlias;
import jp.sbi.celldesigner.ComplexSpeciesProperty;
import jp.sbi.celldesigner.ComplexSpeciesShape;
import jp.sbi.celldesigner.ElementSpeciesAlias;
import jp.sbi.celldesigner.LinkedCreaseLine;
import jp.sbi.celldesigner.MiriamMainPanel;
import jp.sbi.celldesigner.ModelDescription;
import jp.sbi.celldesigner.MonoSpeciesProperty;
import jp.sbi.celldesigner.MonoSpeciesShape;
import jp.sbi.celldesigner.OpenedCompartmentAlias;
import jp.sbi.celldesigner.Preference;
import jp.sbi.celldesigner.ReactionLink;
import jp.sbi.celldesigner.ReactionSymbol;
import jp.sbi.celldesigner.SBFactory;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.SBSymbol;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.SpeciesProperty;
import jp.sbi.celldesigner.SpeciesShape;
import jp.sbi.celldesigner.SpeciesSymbol;
import jp.sbi.celldesigner.blockDiagram.diagram.Annotation;
import jp.sbi.celldesigner.layer.LayerManager;
import jp.sbi.celldesigner.layer.LayerManagerBuilder;
import jp.sbi.celldesigner.miriam.MIRIAM;
import jp.sbi.celldesigner.plugin.PluginKineticLaw;
import jp.sbi.celldesigner.plugin.PluginParameter;
import jp.sbi.celldesigner.plugin.PluginSBase;
import jp.sbi.celldesigner.sbmlExtension.AntiSenseRNA;
import jp.sbi.celldesigner.sbmlExtension.BindingRegion;
import jp.sbi.celldesigner.sbmlExtension.Biomolecule;
import jp.sbi.celldesigner.sbmlExtension.BlockDiagramAnnotation;
import jp.sbi.celldesigner.sbmlExtension.BlockDiagramAnnotationBuilder;
import jp.sbi.celldesigner.sbmlExtension.CompartmentAnnotation;
import jp.sbi.celldesigner.sbmlExtension.Gene;
import jp.sbi.celldesigner.sbmlExtension.ModificationRegion;
import jp.sbi.celldesigner.sbmlExtension.ModificationResidue;
import jp.sbi.celldesigner.sbmlExtension.Notes;
import jp.sbi.celldesigner.sbmlExtension.Protein;
import jp.sbi.celldesigner.sbmlExtension.RNA;
import jp.sbi.celldesigner.sbmlExtension.ReactionAnnotation;
import jp.sbi.celldesigner.sbmlExtension.SpeciesAnnotation;
import jp.sbi.celldesigner.sbmlExtension.SpeciesReferenceAnnotation;
import jp.sbi.celldesigner.symbol.color.ReactionColorScheme;
import jp.sbi.celldesigner.symbol.reaction.AddProduct;
import jp.sbi.celldesigner.symbol.reaction.AddReactant;
import jp.sbi.celldesigner.symbol.reaction.GLogicGate;
import jp.sbi.celldesigner.symbol.reaction.StateTransition;
import jp.sbi.celldesigner.symbol.reaction.mixednotation.LinkedCreaseLineMixedNotation;
import jp.sbi.celldesigner.symbol.species.Tag;
import jp.sbi.celldesigner.util.CelldUtil;
import jp.sbi.sbml.Any;
import jp.sbi.sbml.SId;
import jp.sbi.sbml.SIdFormatException;
import jp.sbi.sbml.SpecInfo;
import jp.sbi.sbml.autoLayout.AutoLayout;
import jp.sbi.sbml.autoLayout.AutoLayoutResult;
import jp.sbi.sbml.autoLayout.GraphLayout;
import jp.sbi.sbml.autoLayout.y.YAutoLayout;
import jp.sbi.sbml.autoLayout.y.option.DefaultAutoLayoutDialog;
import jp.sbi.sbml.autoLayout.y.runtime.IProgressMonitor;
import jp.sbi.sbml.autoLayout.y.runtime.IRunnableWithProgress;
import jp.sbi.sbml.autoLayout.y.runtime.LayoutProgressMonitor;
import jp.sbi.sbml.autoLayout.y.runtime.ProgressMonitorDialog;
import jp.sbi.sbml.debug.DebugPrinter;
import jp.sbi.sbml.util.LibSBMLUtil;
import org.sbml.libsbml.Compartment;
import org.sbml.libsbml.KineticLaw;
import org.sbml.libsbml.ListOf;
import org.sbml.libsbml.ListOfReactions;
import org.sbml.libsbml.ListOfSpecies;
import org.sbml.libsbml.ListOfSpeciesReferences;
import org.sbml.libsbml.Model;
import org.sbml.libsbml.ModifierSpeciesReference;
import org.sbml.libsbml.Parameter;
import org.sbml.libsbml.Reaction;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Species;
import org.sbml.libsbml.SpeciesReference;
import org.sbml.libsbml.XMLNamespaces;
import org.sbml.libsbml.XMLNode;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ModelAnnotation
implements Any {
    public static final String strXmlTagPrefixvCard = "vCard";
    public static final String strXmlTagFamilyName = "Family";
    public static final String strXmlTagGivenName = "Given";
    public static final String strXmlTagEMAIL = "EMAIL";
    public static final String strXmlTagOrgname = "Orgname";
    public static final String strXmlTagW3CDTF = "W3CDTF";
    public static final String strXmlTagPrefixDcterms = "dcterms";
    public static final String strXmlTagCreatedDate = "created";
    public static final String strXmlTagModifiedDate = "modified";
    public static final String[][] arrXmlTag_ModelDescriptionAnnotation = new String[][]{{"annotation", ""}, {"RDF", ""}, {"Description", ""}, {"creator", ""}, {"Bag", ""}, {"li", ""}, {"N", ""}, {"Family", ""}, {"Given", ""}, {"EMAIL", ""}, {"ORG", ""}, {"Orgname", ""}, {"created", ""}, {"W3CDTF", ""}, {"modified", ""}, {"W3CDTF", ""}};
    public static final int iMaxNest = arrXmlTag_ModelDescriptionAnnotation.length + 3;
    public static final int iBadXmlTag = -1;
    private double modelVersion = 0.0;
    private Dimension size = new Dimension(0, 0);
    private GStructure gStructure = null;
    private Model parentModel = null;
    private static final SpecInfo sbmlSpec = new SpecInfo();
    private ListOf listOfProteins;
    private ListOf listOfGenes;
    private ListOf listOfRNAs;
    private ListOf listOfAntiSenseRNAs;
    private HashMap hashProtein;
    private HashMap hashRNA;
    private HashMap hashGene;
    private HashMap hashAntiSenseRNA;
    private Node nodeListOfIncludedSpecies = null;
    private Node nodeListOfComplexSpeciesAliases = null;
    private Node nodeListOfAliases = null;
    private Node nodeListOfCompartmentAliases = null;
    private Node nodeListOfGroups = null;
    private Node nodeLayers = null;
    private TreeMap blockDialogMapByProteinId;
    private BlockDiagramAnnotation blockDiagramAnnotation;
    public static final double MODEL_VERSION = 4.0;
    public static final String NS_CELLDESIGNER = "celldesigner";
    public static String inputNamespace = "celldesigner";
    public static String outputNamespace = "celldesigner";
    public static final String URI_CELLDESIGNER = "http://www.sbml.org/2001/ns/celldesigner";
    private ModelDescription modeldescription = new ModelDescription();
    private Vector<String> vectPKList = new Vector();
    private static SpecInfo specInfo = new SpecInfo();
    private StringBuffer bufAnnotation = new StringBuffer();
    private HashMap hashLocalNS = new HashMap();
    private Exception exception = null;
    private boolean isProgressShowing = true;
    private int newId = 0;

    public ModelAnnotation() {
        this.listOfProteins = new ListOf();
        this.listOfGenes = new ListOf();
        this.listOfRNAs = new ListOf();
        this.listOfAntiSenseRNAs = new ListOf();
        this.hashProtein = new HashMap();
        this.hashGene = new HashMap();
        this.hashRNA = new HashMap();
        this.hashAntiSenseRNA = new HashMap();
        this.reInitModelDescription();
    }

    public static String getInputNamespace() {
        return inputNamespace;
    }

    public static String getOutputNamespace() {
        return outputNamespace;
    }

    public GStructure getGStructure() {
        return this.gStructure;
    }

    public void setModelDisplaySize(Dimension size) {
        this.size = size;
    }

    public Dimension getModelDisplaySize() {
        return this.size;
    }

    public void setModelVersion(double version) {
        this.modelVersion = version;
    }

    public double getModelVersion() {
        return this.modelVersion;
    }

    public ListOf getListOfProteins() {
        return this.listOfProteins;
    }

    public ListOf getListOfGenes() {
        return this.listOfGenes;
    }

    public ListOf getListOfRNAs() {
        return this.listOfRNAs;
    }

    public ListOf getListOfAntiSenseRNAs() {
        return this.listOfAntiSenseRNAs;
    }

    public HashMap getHashAntiSenseRNA() {
        return this.hashAntiSenseRNA;
    }

    public void setHashAntiSenseRNA(HashMap hashAntiSenseRNA) {
        this.hashAntiSenseRNA = hashAntiSenseRNA;
    }

    public HashMap getHashGene() {
        return this.hashGene;
    }

    public void setHashGene(HashMap hashGENE) {
        this.hashGene = hashGENE;
    }

    public HashMap getHashProtein() {
        return this.hashProtein;
    }

    public void setHashProtein(HashMap hashProtein) {
        this.hashProtein = hashProtein;
    }

    public HashMap getHashRNA() {
        return this.hashRNA;
    }

    public void setHashRNA(HashMap hashRNA) {
        this.hashRNA = hashRNA;
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{"sizeX", "sizeY"};
    }

    @Override
    public String[] getAttributeShortNames() {
        return new String[]{"sizeX", "sizeY"};
    }

    @Override
    public int[] getAttributeColumnSizes() {
        return new int[]{10, 10};
    }

    @Override
    public String[] getAttributeValues() {
        return new String[]{String.valueOf(this.size.width), String.valueOf(this.size.height)};
    }

    @Override
    public boolean hasValue() {
        if (this.gStructure == null) {
            return this.size.width != 0 && this.size.height != 0;
        }
        return this.size.width != 0 && this.size.height != 0 || this.gStructure.getAtoms().size() > 0;
    }

    @Override
    public void readDOMTree(Element element) throws Exception {
        this.reInitModelDescription();
        String ns = ModelAnnotation.getOutputNamespace();
        NodeList childlistTop = element.getChildNodes();
        NodeList childlistCellD = null;
        NodeList childlist = null;
        int iLoopMaxTimes = 2;
        int iLoopMax = 2;
        boolean bCellDVerMaxThan401 = false;
        childlist = childlistTop;
        do {
            int childsize = childlist.getLength();
            int i = 0;
            while (i < childsize) {
                String tag;
                Element elem;
                Node node = childlist.item(i);
                if (node.getNodeType() == 1 && ((Element)node).getPrefix() != null && ((Element)node).getPrefix().equals(NS_CELLDESIGNER) && ((Element)node).getLocalName() != null && ((Element)node).getLocalName().equals("extension")) {
                    childlistCellD = node.getChildNodes();
                    if (childlistCellD == null || childlist.getLength() <= 0) {
                        throw new Exception();
                    }
                    bCellDVerMaxThan401 = true;
                } else if (node.getNodeType() == 1 && URI_CELLDESIGNER.equals(node.getNamespaceURI())) {
                    Species p;
                    Node pNode;
                    NodeList children;
                    elem = (Element)node;
                    tag = elem.getLocalName();
                    if (tag.equals("modelVersion")) {
                        String str = elem.getFirstChild().getNodeValue();
                        if (!str.equals("")) {
                            try {
                                this.modelVersion = Double.parseDouble(str);
                            }
                            catch (Exception exception) {}
                        }
                    } else if (tag.equals("modelDisplay")) {
                        String strX = elem.getAttributeNS(null, "sizeX");
                        this.size.width = !strX.equals("") ? Integer.parseInt(strX) : 0;
                        String strY = elem.getAttributeNS(null, "sizeY");
                        this.size.height = !strY.equals("") ? Integer.parseInt(strY) : 0;
                    } else if (tag.equals("listOfIncludedSpecies")) {
                        this.nodeListOfIncludedSpecies = elem;
                    } else if (tag.equals("listOfCompartmentAliases")) {
                        this.nodeListOfCompartmentAliases = elem;
                    } else if (tag.equals("listOfComplexSpeciesAliases")) {
                        this.nodeListOfComplexSpeciesAliases = elem;
                    } else if (tag.equals("listOfSpeciesAliases")) {
                        this.nodeListOfAliases = elem;
                    } else if (tag.equals("listOfGroups")) {
                        this.nodeListOfGroups = elem;
                    } else if (tag.equals("listOfProteins")) {
                        children = elem.getChildNodes();
                        int j = 0;
                        while (j < children.getLength()) {
                            pNode = children.item(j);
                            if (pNode.getNodeType() == 1 && pNode.getNamespaceURI().equals(URI_CELLDESIGNER) && pNode.getLocalName().equals("protein")) {
                                p = new Protein();
                                LibSBMLUtil.readDOMTree((SBase)p, (Element)pNode, specInfo);
                                if (Preference.isDebug) {
                                    System.out.println("\nlistOfProteins append p = " + p.getId());
                                    System.out.println("listOfProteins append p = " + p.getName());
                                    System.out.println("listOfProteins append p annotation= " + p.getAnnotationString());
                                }
                                this.listOfProteins.appendAndOwn((SBase)p);
                                this.hashProtein.put(p.getId(), p);
                            }
                            ++j;
                        }
                    } else if (tag.equals("listOfGenes")) {
                        children = elem.getChildNodes();
                        int j = 0;
                        while (j < children.getLength()) {
                            pNode = children.item(j);
                            if (pNode.getNodeType() == 1 && pNode.getNamespaceURI().equals(URI_CELLDESIGNER) && pNode.getLocalName().equals("gene")) {
                                p = new Gene();
                                LibSBMLUtil.readDOMTree((SBase)p, (Element)pNode, specInfo);
                                if (Preference.isDebug) {
                                    System.out.println("\nlistOfGenes append g = " + p.getId());
                                    System.out.println("listOfGenes append g = " + p.getName());
                                    System.out.println("listOfGenes append g annotation= " + p.getAnnotationString());
                                }
                                this.listOfGenes.appendAndOwn((SBase)p);
                                this.hashGene.put(p.getId(), p);
                            }
                            ++j;
                        }
                    } else if (tag.equals("listOfRNAs")) {
                        children = elem.getChildNodes();
                        int j = 0;
                        while (j < children.getLength()) {
                            pNode = children.item(j);
                            if (pNode.getNodeType() == 1 && pNode.getNamespaceURI().equals(URI_CELLDESIGNER) && pNode.getLocalName().equals("RNA")) {
                                p = new RNA();
                                LibSBMLUtil.readDOMTree((SBase)p, (Element)pNode, specInfo);
                                if (Preference.isDebug) {
                                    System.out.println("\nlistOfRNAs append p = " + p.getId());
                                    System.out.println("listOfRNAs append p = " + p.getName());
                                    System.out.println("listOfRNAs append p annotation= " + p.getAnnotationString());
                                }
                                this.listOfRNAs.appendAndOwn((SBase)p);
                                this.hashRNA.put(p.getId(), p);
                            }
                            ++j;
                        }
                    } else if (tag.equals("listOfAntisenseRNAs")) {
                        children = elem.getChildNodes();
                        int j = 0;
                        while (j < children.getLength()) {
                            pNode = children.item(j);
                            if (pNode.getNodeType() == 1 && pNode.getNamespaceURI().equals(URI_CELLDESIGNER) && pNode.getLocalName().equals("AntisenseRNA")) {
                                p = new AntiSenseRNA();
                                LibSBMLUtil.readDOMTree((SBase)p, (Element)pNode, specInfo);
                                if (Preference.isDebug) {
                                    System.out.println("\nlistOfAntiSenseRNAs append p = " + p.getId());
                                    System.out.println("listOfAntiSenseRNAs append p = " + p.getName());
                                    System.out.println("listOfAntiSenseRNAs append p annotation= " + p.getAnnotationString());
                                }
                                this.listOfAntiSenseRNAs.appendAndOwn((SBase)p);
                                this.hashAntiSenseRNA.put(p.getId(), p);
                            }
                            ++j;
                        }
                    } else if (tag.equals("listOfLayers")) {
                        this.nodeLayers = node;
                    }
                } else if (iLoopMax == 2 && node.getNodeType() == 1) {
                    int j = 0;
                    while (j < element.getAttributes().getLength()) {
                        Node n = element.getAttributes().item(j);
                        if (n.getNodeName().indexOf("xmlns:") != -1) {
                            this.hashLocalNS.put(n.getLocalName(), n.getNodeValue());
                        }
                        ++j;
                    }
                    elem = (Element)node;
                    tag = elem.getLocalName();
                    if (elem.getPrefix() != null) {
                        this.bufAnnotation.append("<" + elem.getPrefix() + ":" + tag);
                    } else {
                        this.bufAnnotation.append("<" + tag);
                    }
                    NamedNodeMap map = elem.getAttributes();
                    if (map.getLength() == 0) {
                        this.bufAnnotation.append(">");
                    }
                    int k = 0;
                    while (k < map.getLength()) {
                        Node nodes = map.item(k);
                        this.bufAnnotation.append(" " + nodes.getNodeName() + "=\"" + nodes.getNodeValue() + "\"");
                        if (k + 1 >= map.getLength()) {
                            this.bufAnnotation.append(">\n");
                        }
                        ++k;
                    }
                    this.readSomeAnnotation(elem);
                    if (elem.getPrefix() != null) {
                        this.bufAnnotation.append("</" + elem.getPrefix() + ":" + tag + ">\n");
                    } else {
                        this.bufAnnotation.append("</" + tag + ">\n");
                    }
                }
                ++i;
            }
            if (!bCellDVerMaxThan401) break;
            childlist = childlistCellD;
        } while (--iLoopMax > 0);
        this.blockDiagramAnnotation = bCellDVerMaxThan401 ? BlockDiagramAnnotationBuilder.build(childlistCellD) : BlockDiagramAnnotationBuilder.build(childlistTop);
    }

    @Override
    public HashMap getLocalNS() {
        return this.hashLocalNS;
    }

    private void readSomeAnnotation(Element elem) {
        NodeList children = elem.getChildNodes();
        int j = 0;
        while (j < children.getLength()) {
            Node pNode = children.item(j);
            if (pNode.getNodeType() == 1) {
                Element elem2 = (Element)pNode;
                String tag = elem2.getLocalName();
                if (elem2.getPrefix() != null) {
                    this.bufAnnotation.append("<" + elem2.getPrefix() + ":" + tag);
                } else {
                    this.bufAnnotation.append("<" + tag);
                }
                NamedNodeMap map = elem2.getAttributes();
                if (map.getLength() == 0) {
                    this.bufAnnotation.append(">");
                }
                int i = 0;
                while (i < map.getLength()) {
                    Node nodes = map.item(i);
                    this.bufAnnotation.append(" " + nodes.getNodeName() + "=\"" + nodes.getNodeValue() + "\"");
                    if (i + 1 >= map.getLength()) {
                        this.bufAnnotation.append(">\n");
                    }
                    ++i;
                }
                if (elem2.getPrefix() != null) {
                    Vector<String> vectPKlist = this.getVectPKList();
                    String strPrefixLowerCase = elem2.getPrefix().trim().toLowerCase();
                    String strTagLowerCase = tag.trim().toLowerCase();
                    if (strXmlTagPrefixvCard.toLowerCase().equals(strPrefixLowerCase)) {
                        if (strXmlTagFamilyName.toLowerCase().equals(strTagLowerCase)) {
                            vectPKlist.add(strXmlTagFamilyName);
                        } else if (strXmlTagGivenName.toLowerCase().equals(strTagLowerCase)) {
                            vectPKlist.add(strXmlTagGivenName);
                        } else if (strXmlTagEMAIL.toLowerCase().equals(strTagLowerCase)) {
                            vectPKlist.add(strXmlTagEMAIL);
                        } else if (strXmlTagOrgname.toLowerCase().equals(strTagLowerCase)) {
                            vectPKlist.add(strXmlTagOrgname);
                        }
                    } else if (strXmlTagPrefixDcterms.toLowerCase().equals(strPrefixLowerCase)) {
                        if (strXmlTagCreatedDate.toLowerCase().equals(strTagLowerCase)) {
                            vectPKlist.add(strXmlTagCreatedDate);
                        } else if (strXmlTagModifiedDate.toLowerCase().equals(strTagLowerCase)) {
                            vectPKlist.add(strXmlTagModifiedDate);
                        } else if (strXmlTagW3CDTF.toLowerCase().equals(strTagLowerCase)) {
                            vectPKlist.add(strXmlTagW3CDTF);
                        }
                    }
                }
                this.readSomeAnnotation((Element)pNode);
                if (elem2.getPrefix() != null) {
                    this.bufAnnotation.append("</" + elem2.getPrefix() + ":" + tag + ">\n");
                } else {
                    this.bufAnnotation.append("</" + tag + ">\n");
                }
            } else if (pNode.getNodeValue() != null && !pNode.getNodeValue().equals("") && !pNode.getNodeValue().equals("\n")) {
                int s;
                String o;
                Vector<String> vectPKlist = this.getVectPKList();
                if (vectPKlist != null && vectPKlist.size() > 0 && (o = vectPKlist.get((s = vectPKlist.size()) - 1)) instanceof String) {
                    String k = o;
                    if (k.equals(strXmlTagFamilyName)) {
                        this.modeldescription.setCreatorFamilyName(pNode.getNodeValue());
                        vectPKlist.remove(s - 1);
                    } else if (k.equals(strXmlTagGivenName)) {
                        this.modeldescription.setCreatorGivenName(pNode.getNodeValue());
                        vectPKlist.remove(s - 1);
                    } else if (k.equals(strXmlTagEMAIL)) {
                        this.modeldescription.setCreatorEMAIL(pNode.getNodeValue());
                        vectPKlist.remove(s - 1);
                    } else if (k.equals(strXmlTagOrgname)) {
                        this.modeldescription.setCreatorOrganization(pNode.getNodeValue());
                        vectPKlist.remove(s - 1);
                    } else if (k.equals(strXmlTagW3CDTF)) {
                        String o2;
                        vectPKlist.remove(s - 1);
                        if (s >= 2 && (o2 = vectPKlist.get(s - 2)) instanceof String) {
                            String k2 = o2;
                            if (k2.equals(strXmlTagCreatedDate)) {
                                this.modeldescription.setFileCreatedDate(pNode.getNodeValue());
                                vectPKlist.remove(s - 2);
                            } else if (k2.equals(strXmlTagModifiedDate)) {
                                this.modeldescription.setFileModifiedDate(pNode.getNodeValue());
                                vectPKlist.remove(s - 2);
                            }
                        }
                    }
                }
                this.bufAnnotation.append(pNode.getNodeValue());
            }
            ++j;
        }
    }

    @Override
    public void writeDOMTree(Node node) throws Exception {
    }

    public void updateAnnotation(SBModel sbModel, Model m, XMLNamespaces anntXmlNS) {
        Species r;
        Notes notes;
        Species p;
        Species sp;
        Vector vecData = LibSBMLUtil.getMiriamDatasFromAnnotationOfSBase((SBase)m);
        if (sbModel != null) {
            sbModel.setSBOTerm(sbModel.getModel());
            CelldUtil.resetMetaidAndAnnotationOfMiriam(sbModel);
        }
        StringBuffer buf = new StringBuffer();
        buf.append("<annotation xmlns:celldesigner=\"http://www.sbml.org/2001/ns/celldesigner\">\n");
        buf.append("<celldesigner:extension>");
        buf.append("<celldesigner:modelVersion>" + this.getModelVersion() + "</celldesigner:" + "modelVersion>\n");
        buf.append("<celldesigner:modelDisplay sizeX=\"" + (int)this.getModelDisplaySize().getWidth() + "\" sizeY=\"" + (int)this.getModelDisplaySize().getHeight() + "\"/>\n");
        if (sbModel.getGStructure() != null) {
            ArrayList includedSpecies = LibSBMLUtil.getListOfIncludedSpecies((ListOf)m.getListOfSpecies());
            if (includedSpecies.size() != 0) {
                buf.append("<celldesigner:listOfIncludedSpecies>\n");
                int i = 0;
                while (i < includedSpecies.size()) {
                    Species species = (Species)includedSpecies.get(i);
                    buf.append("<celldesigner:species id=\"" + species.getId() + "\" name=\"" + StringTool.toEscape(species.getName()) + "\">\n");
                    Notes spNotes = (Notes)sbModel.getHashSpeciesNotes().get(species.getId());
                    if (spNotes != null) {
                        buf.append("<celldesigner:notes>\n");
                        buf.append("<html xmlns=\"http://www.w3.org/1999/xhtml\">\n");
                        buf.append("<head> <title/> </head>\n");
                        buf.append("<!--Notes by CellDesigner-->\n");
                        buf.append("<body>\n");
                        buf.append(spNotes.getText());
                        buf.append("\n");
                        buf.append("</body>\n");
                        buf.append("</html>");
                        buf.append("</celldesigner:notes>\n");
                    }
                    buf.append("<celldesigner:annotation>\n");
                    SpeciesAnnotation spAnno = (SpeciesAnnotation)sbModel.getHashSpeciesAnnotation().get(species.getId());
                    spAnno.updateAnnotation(buf, spAnno);
                    buf.append("</celldesigner:annotation>\n");
                    buf.append("</celldesigner:species>\n");
                    ++i;
                }
                buf.append("</celldesigner:listOfIncludedSpecies>\n");
            }
            Vector caVector = sbModel.getGStructure().getContainers();
            buf.append("<celldesigner:listOfCompartmentAliases>\n");
            int i = 0;
            while (i < caVector.size()) {
                CompartmentAlias alias = (CompartmentAlias)caVector.elementAt(i);
                if (alias instanceof OpenedCompartmentAlias) {
                    OpenedCompartmentAlias.updateAnnotation(buf, (OpenedCompartmentAlias)alias);
                } else if (alias instanceof ClosedCompartmentAlias) {
                    ClosedCompartmentAlias.updateAnnotation(buf, (ClosedCompartmentAlias)alias);
                }
                ++i;
            }
            buf.append("</celldesigner:listOfCompartmentAliases>\n");
            buf.append("<celldesigner:listOfComplexSpeciesAliases>\n");
            Vector complexAliasVector = sbModel.getGStructure().getContainableAtoms();
            int i2 = 0;
            while (i2 < complexAliasVector.size()) {
                SpeciesAlias alias = (SpeciesAlias)complexAliasVector.elementAt(i2);
                if (alias instanceof ElementSpeciesAlias) {
                    ElementSpeciesAlias.updateAnnotation(buf, (ElementSpeciesAlias)alias, sbModel.getGStructure().getLayerTagLinkLinesWhichLinksTo(alias));
                } else if (alias instanceof ComplexSpeciesAlias) {
                    ComplexSpeciesAlias.updateAnnotation(buf, (ComplexSpeciesAlias)alias, sbModel.getGStructure().getLayerTagLinkLinesWhichLinksTo(alias));
                }
                ++i2;
            }
            buf.append("</celldesigner:listOfComplexSpeciesAliases>\n");
            Vector aliasVector = sbModel.getGStructure().getAtoms();
            buf.append("<celldesigner:listOfSpeciesAliases>\n");
            int i3 = 0;
            while (i3 < aliasVector.size()) {
                SpeciesAlias alias = (SpeciesAlias)aliasVector.elementAt(i3);
                if (alias instanceof ElementSpeciesAlias) {
                    SpeciesSymbol symb;
                    MonoSpeciesShape mshape = (MonoSpeciesShape)alias.getGFramedShape();
                    if (mshape != null && !((symb = mshape.getSpeciesSymbol()) instanceof Tag)) {
                        ElementSpeciesAlias.updateAnnotation(buf, (ElementSpeciesAlias)alias, sbModel.getGStructure().getLayerTagLinkLinesWhichLinksTo(alias));
                    }
                } else if (alias instanceof ComplexSpeciesAlias) {
                    ComplexSpeciesAlias.updateAnnotation(buf, (ComplexSpeciesAlias)alias, sbModel.getGStructure().getLayerTagLinkLinesWhichLinksTo(alias));
                }
                ++i3;
            }
            buf.append("</celldesigner:listOfSpeciesAliases>\n");
            Vector groupVector = sbModel.getGStructure().getGroups();
            if (groupVector == null || groupVector.size() == 0) {
                buf.append("<celldesigner:listOfGroups/>\n");
            } else {
                buf.append("<celldesigner:listOfGroups>\n");
                int i4 = 0;
                while (i4 < groupVector.size()) {
                    GGroup group = (GGroup)groupVector.elementAt(i4);
                    String gname = group.getName();
                    String memberStr = "";
                    Vector members = group.getMembers();
                    int k = 0;
                    while (k < members.size()) {
                        if (members.elementAt(k) instanceof SpeciesAlias) {
                            SpeciesAlias alias = (SpeciesAlias)members.elementAt(k);
                            if (k != 0) {
                                memberStr = String.valueOf(memberStr) + ",";
                            }
                            memberStr = String.valueOf(memberStr) + alias.getName();
                        }
                        ++k;
                    }
                    buf.append("<celldesigner:group id=\"" + gname + "\" members=\"" + memberStr + "\"/>\n");
                    ++i4;
                }
                buf.append("</celldesigner:listOfGroups>\n");
            }
        } else {
            Debug.println("[ModelAnnotation]writeDOMTree(), gStructure=null");
        }
        if (sbModel.getListOfProteins().size() == 0L) {
            buf.append("<celldesigner:listOfProteins/>\n");
        } else {
            buf.append("<celldesigner:listOfProteins>\n");
            int i = 0;
            while ((long)i < sbModel.getListOfProteins().size()) {
                sp = (Species)sbModel.getListOfProteins().get((long)i);
                p = sbModel.getProtein(sp.getId());
                if (sbModel.getHashProteinNotes().get(sp.getId()) != null) {
                    notes = (Notes)sbModel.getHashProteinNotes().get(p.getId());
                    p.setNotes(notes.getText());
                }
                Protein.updateAnnotation(buf, p);
                ++i;
            }
            buf.append("</celldesigner:listOfProteins>\n");
        }
        if (sbModel.getListOfGenes().size() == 0L) {
            buf.append("<celldesigner:listOfGenes/>\n");
        } else {
            buf.append("<celldesigner:listOfGenes>\n");
            int i = 0;
            while ((long)i < sbModel.getListOfGenes().size()) {
                sp = (Species)sbModel.getListOfGenes().get((long)i);
                p = sbModel.getGene(sp.getId());
                if (sbModel.getHashGeneNotes().get(sp.getId()) != null) {
                    notes = (Notes)sbModel.getHashGeneNotes().get(p.getId());
                    p.setNotes(notes.getText());
                }
                Gene.updateAnnotation(buf, (Gene)p);
                ++i;
            }
            buf.append("</celldesigner:listOfGenes>\n");
        }
        if (sbModel.getListOfRNAs().size() == 0L) {
            buf.append("<celldesigner:listOfRNAs/>\n");
        } else {
            buf.append("<celldesigner:listOfRNAs>\n");
            int i = 0;
            while ((long)i < sbModel.getListOfRNAs().size()) {
                sp = (Species)sbModel.getListOfRNAs().get((long)i);
                r = sbModel.getRNA(sp.getId());
                if (sbModel.getHashRNANotes().get(r.getId()) != null) {
                    notes = (Notes)sbModel.getHashRNANotes().get(r.getId());
                    r.setNotes(notes.getText());
                }
                RNA.updateAnnotation(buf, r);
                ++i;
            }
            buf.append("</celldesigner:listOfRNAs>\n");
        }
        if (sbModel.getListOfAntiSenseRNAs().size() == 0L) {
            buf.append("<celldesigner:listOfAntisenseRNAs/>\n");
        } else {
            buf.append("<celldesigner:listOfAntisenseRNAs>\n");
            int i = 0;
            while ((long)i < sbModel.getListOfAntiSenseRNAs().size()) {
                sp = (Species)sbModel.getListOfAntiSenseRNAs().get((long)i);
                r = sbModel.getAntiSenseRNA(sp.getId());
                if (sbModel.getHashAntiSenseRNANotes().get(r.getId()) != null) {
                    notes = (Notes)sbModel.getHashAntiSenseRNANotes().get(r.getId());
                    r.setNotes(notes.getText());
                }
                AntiSenseRNA.updateAnnotation(buf, (AntiSenseRNA)r);
                ++i;
            }
            buf.append("</celldesigner:listOfAntisenseRNAs>\n");
        }
        this.createLayerTag(buf);
        if (this.blockDiagramAnnotation != null) {
            Annotation.updateAnnotation(buf, (Annotation)this.blockDiagramAnnotation, sbModel.getListOfProteins());
        } else {
            buf.append("<celldesigner:listOfBlockDiagrams/>\n");
        }
        buf.append("</celldesigner:extension>");
        ModelAnnotation.resetModelDescriptionAnnotation(m, buf, this.bufAnnotation, this.modeldescription, vecData);
        buf.append("</annotation>\n");
        XMLNode annt = XMLNode.convertStringToXMLNode((String)buf.toString(), (XMLNamespaces)anntXmlNS);
        m.setAnnotation(annt);
    }

    private void createLayerTag(StringBuffer buf) {
        if (this.gStructure != null) {
            Vector listOfLayersTemp = this.gStructure.getLayers();
            Vector listOfLayers = null;
            if (listOfLayersTemp != null && listOfLayersTemp.size() > 0) {
                listOfLayers = new Vector();
                LayerManager lm = this.gStructure.getTaglayer();
                int i = 0;
                while (i < listOfLayersTemp.size()) {
                    if (listOfLayersTemp.get(i) != lm) {
                        listOfLayers.add(listOfLayersTemp.get(i));
                    }
                    ++i;
                }
            }
            if (listOfLayers == null || listOfLayers.size() == 0) {
                buf.append("<celldesigner:listOfLayers/>\n");
            } else {
                buf.append("<celldesigner:listOfLayers>\n");
                int i = 0;
                while (i < listOfLayers.size()) {
                    LayerManager m = (LayerManager)listOfLayers.get(i);
                    buf.append(m.toSBML());
                    ++i;
                }
                buf.append("</celldesigner:listOfLayers>\n");
            }
        }
    }

    @Override
    public void releaseAllMembers() {
        this.size = null;
        if (this.gStructure != null) {
            this.gStructure.dispose();
            this.gStructure = null;
        }
        this.listOfProteins = null;
        this.listOfGenes = null;
        this.listOfRNAs = null;
        this.listOfAntiSenseRNAs = null;
        this.hashProtein.clear();
        this.hashProtein = null;
        this.hashGene.clear();
        this.hashGene = null;
        this.hashRNA.clear();
        this.hashRNA = null;
        this.hashAntiSenseRNA.clear();
        this.hashAntiSenseRNA = null;
    }

    public void releaseAll() {
        this.listOfProteins = null;
        this.listOfGenes = null;
        this.listOfRNAs = null;
        this.listOfAntiSenseRNAs = null;
        this.hashProtein.clear();
        this.hashProtein = null;
        this.hashGene.clear();
        this.hashGene = null;
        this.hashRNA.clear();
        this.hashRNA = null;
        this.hashAntiSenseRNA.clear();
        this.hashAntiSenseRNA = null;
    }

    public void buildGStructureByDOMTree(SBModel sbModel, Model model) throws Exception {
        this.gStructure = new GStructure();
        this.gStructure.setAtomNametag("sa");
        this.gStructure.setContainableAtomNametag("csa");
        this.gStructure.setLinkNametag("re");
        this.gStructure.setContainerNametag("ca");
        this.gStructure.setGroupNametag("g");
        this.gStructure.setMaxDrawSize(new Rectangle2D.Double(0.0, 0.0, this.size.width, this.size.height));
        if (this.modelVersion < 2.5) {
            this.buildGStructureByDOMTreeOld(sbModel, model);
        } else {
            this.buildGStructureByDOMTreeNew(sbModel, model);
        }
        LayerManager taglmg = this.gStructure.getTaglayer();
        this.buildLayers();
        this.gStructure.setTaglayer(taglmg);
    }

    private void buildLayers() {
        if (this.nodeLayers == null) {
            return;
        }
        Element elem = (Element)this.nodeLayers;
        NodeList children = elem.getChildNodes();
        Vector listOfLayers = LayerManagerBuilder.build(children, this.gStructure);
        this.gStructure.setLayers(listOfLayers);
    }

    public void setProgressShowing(boolean isProgressShowing) {
        this.isProgressShowing = isProgressShowing;
    }

    private String getOriginalAnnotation(Species sp) {
        XMLNode annt = sp.getAnnotation();
        if (annt == null) {
            return "";
        }
        return XMLNode.convertXMLNodeToString((XMLNode)annt.getChild(0L));
    }

    private void buildGStructureByDOMTreeOld(SBModel sbModel, Model model) throws Exception {
        boolean isInitialModel = false;
        boolean isAutoLayout = false;
        boolean autoCreateSpeciesAnnotation = false;
        if (this.nodeListOfAliases == null) {
            if (model.getListOfSpecies().size() == 0L && model.getListOfCompartments().size() == 0L && model.getListOfReactions().size() == 0L) {
                isInitialModel = true;
            } else {
                isAutoLayout = true;
                autoCreateSpeciesAnnotation = true;
            }
        }
        AutoLayoutResult auto = null;
        Vector<Rectangle2D.Double> vectDummySpeciesBounds = new Vector<Rectangle2D.Double>();
        if (autoCreateSpeciesAnnotation) {
            AutoLayout al;
            int id = 1;
            ListOfSpecies listOfSpecies = model.getListOfSpecies();
            int i = 0;
            while ((long)i < listOfSpecies.size()) {
                Species sp = (Species)listOfSpecies.get((long)i);
                HashMap hashRepairSpecies = sbModel.getHashRepairSpecies();
                if (sp.getId() != null && hashRepairSpecies != null && hashRepairSpecies.containsKey(sp.getId())) {
                    sp.setAnnotation("<annotation xmlns:celldesigner=\"http://www.sbml.org/2001/ns/celldesigner\"><celldesigner:positionToCompartment>inside</celldesigner:positionToCompartment>\n<celldesigner:speciesIdentity>\n<celldesigner:class>DEGRADED</celldesigner:class>\n</celldesigner:speciesIdentity>\n" + this.getOriginalAnnotation(sp) + "</annotation>");
                    SpeciesSymbol briefSymbol01 = (SpeciesSymbol)((Object)SBFactory.createSymbol("DEGRADED"));
                    double w = briefSymbol01.defaultSize().width;
                    double h = briefSymbol01.defaultSize().height;
                    vectDummySpeciesBounds.add(new Rectangle2D.Double(0.0, 0.0, w, h));
                } else {
                    Protein protein = new Protein();
                    protein.setId("pr" + id);
                    if (sp.getName().equals("")) {
                        protein.setName(sp.getId());
                    } else {
                        protein.setName(sp.getName());
                    }
                    protein.setType("GENERIC");
                    sp.setAnnotation("<annotation xmlns:celldesigner=\"http://www.sbml.org/2001/ns/celldesigner\"><celldesigner:positionToCompartment>inside</celldesigner:positionToCompartment>\n<celldesigner:speciesIdentity>\n<celldesigner:class>PROTEIN</celldesigner:class>\n<celldesigner:proteinReference>" + protein.getId() + "</celldesigner:proteinReference>\n" + "</celldesigner:speciesIdentity>\n" + this.getOriginalAnnotation(sp) + "</annotation>");
                    SpeciesSymbol briefSymbol01 = (SpeciesSymbol)((Object)SBFactory.createSymbol("GENERIC"));
                    double w = briefSymbol01.defaultSize().width;
                    double h = briefSymbol01.defaultSize().height;
                    vectDummySpeciesBounds.add(new Rectangle2D.Double(0.0, 0.0, w, h));
                    this.listOfProteins.appendAndOwn((SBase)protein);
                    this.hashProtein.put(protein.getId(), protein);
                    ++id;
                }
                ++i;
            }
            if (Preference.AUTO_LAYOUT_MODE && !DefaultAutoLayoutDialog.isOldVersionLayout()) {
                al = DefaultAutoLayoutDialog.createLayoutModule();
                auto = al.doLayout(model);
                if (vectDummySpeciesBounds.size() > 0) {
                    auto.setSpeciesBounds(vectDummySpeciesBounds);
                }
            } else {
                al = new GraphLayout();
                auto = al.doLayout(model);
                this.setModelDisplaySize(auto.getDocumentSize());
            }
        }
        if (!isInitialModel) {
            if (!isAutoLayout && this.modelVersion < 2.5) {
                this.buildListOfGeneEtcByDOMTree(sbModel, (ListOf)model.getListOfSpecies());
            }
            Vector createdCompartmentAliases = isAutoLayout ? this.createCompartmentAliases(sbModel, this.gStructure.containerNametag(), (ListOf)model.getListOfCompartments(), auto.getCompartmentBounds()) : this.buildCompartmentAliasesByDOMTree(sbModel, model);
            this.gStructure.setContainers(createdCompartmentAliases);
            int i = 0;
            while (i < createdCompartmentAliases.size()) {
                OpenedCompartmentAlias compartment;
                CompartmentAlias alias = (CompartmentAlias)createdCompartmentAliases.elementAt(i);
                alias.buildOutside(this.gStructure);
                if (alias instanceof OpenedCompartmentAlias && !(compartment = (OpenedCompartmentAlias)alias).isNamePositionBuilded()) {
                    Point2D.Double namePoint = compartment.getDefaultCompartmentNamePostion();
                    compartment.setNameImagePosition(namePoint.x, namePoint.y);
                }
                ++i;
            }
            Vector createdComplexSpeciesAlias = new Vector();
            Vector createdSpeciesAliases = new Vector();
            if (isAutoLayout) {
                createdSpeciesAliases = this.createSpeciesAliases(sbModel, this.gStructure.atomNametag(), (ListOf)model.getListOfSpecies(), createdCompartmentAliases, auto.getSpeciesBounds());
            } else if (this.modelVersion < 2.5) {
                Vector[] aliasVecs = this.buildSpeciesAliasesByDOMTreeConvertTo25(sbModel, model, createdCompartmentAliases);
                createdComplexSpeciesAlias = aliasVecs[0];
                this.gStructure.setContainableAtoms(createdComplexSpeciesAlias);
                createdSpeciesAliases = aliasVecs[1];
            }
            this.gStructure.setAtoms(createdSpeciesAliases);
            this.reassignReferredSpeciesAliasesToBiomolecules(sbModel, this.listOfProteins, this.listOfGenes, this.listOfRNAs, this.listOfAntiSenseRNAs, createdSpeciesAliases);
            Vector createdAliases = new Vector(createdComplexSpeciesAlias.size() + createdSpeciesAliases.size());
            createdAliases.addAll(createdComplexSpeciesAlias);
            createdAliases.addAll(createdSpeciesAliases);
            Vector links = new Vector();
            ListOfReactions listOfReactions = model.getListOfReactions();
            int i2 = 0;
            while ((long)i2 < listOfReactions.size()) {
                Reaction r = (Reaction)listOfReactions.get((long)i2);
                ReactionAnnotation rExt = (ReactionAnnotation)LibSBMLUtil.getAnnotation(sbModel, (SBase)r, null);
                Vector createdLinks = new Vector();
                if (isAutoLayout) {
                    int policy = GLinkedLine.getDefaultConnectPolicy();
                    GLinkedLine.setDefaultConnectPolicy(0);
                    createdLinks = this.createReactionLinks(sbModel, this.gStructure.linkNametag(), createdAliases, r);
                    GLinkedLine.setDefaultConnectPolicy(policy);
                } else if (this.modelVersion < 2.5) {
                    createdLinks = rExt.buildReactionLinksByDOMTree(sbModel, createdAliases, r, model);
                }
                links.addAll(createdLinks);
                ++i2;
            }
            this.attachSpeciesReferenceAnnotationsToSpeciesAlias(sbModel, model, (ListOf)model.getListOfReactions(), createdAliases);
            this.gStructure.setLinks(links);
            this.gStructure.updateLinks();
            this.resetLinksPositionForVersion4(links);
            this.autoCalcPositionInfoFormVer4(links, this.gStructure);
            this.gStructure.updateLinks(true);
            Vector<GGroup> groups = new Vector<GGroup>();
            if (this.nodeListOfGroups != null) {
                NodeList children = this.nodeListOfGroups.getChildNodes();
                int i3 = 0;
                while (i3 < children.getLength()) {
                    Node n = children.item(i3);
                    if (n.getNodeType() == 1 && n.getNamespaceURI().equals(URI_CELLDESIGNER) && n.getLocalName().equals("group")) {
                        Element nelem = (Element)n;
                        String gid = nelem.getAttributeNS(null, "id");
                        String members = nelem.getAttributeNS(null, "members");
                        StringTokenizer st = new StringTokenizer(members, ",");
                        Vector<GElement> v = new Vector<GElement>();
                        while (st.hasMoreTokens()) {
                            String aid = st.nextToken();
                            GElement a = this.getGElement(aid, this.gStructure.getAtoms());
                            if (a == null) continue;
                            v.add(a);
                        }
                        GGroup group = new GGroup(v);
                        group.addCreasePointMember(this.gStructure);
                        group.setName(gid);
                        group.update();
                        groups.add(group);
                    }
                    ++i3;
                }
            }
            this.gStructure.setGroups(groups);
        }
        if (isAutoLayout && Preference.AUTO_LAYOUT_MODE && !DefaultAutoLayoutDialog.isOldVersionLayout()) {
            final YAutoLayout layout = (YAutoLayout)DefaultAutoLayoutDialog.createLayoutModule();
            this.exception = null;
            if (!this.isProgressShowing) {
                AutoLayoutResult result = layout.doLayout(null, this.gStructure);
                this.setModelDisplaySize(result.getDocumentSize());
            } else {
                ProgressMonitorDialog dialog = new ProgressMonitorDialog((JComponent)sbModel.getSbframe(), "Automatic Graph Layout");
                dialog.setMonitor((IProgressMonitor)new LayoutProgressMonitor(dialog));
                dialog.run(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        try {
                            try {
                                layout.setMonitor(monitor);
                                AutoLayoutResult result = layout.doLayout(null, ModelAnnotation.this.gStructure);
                                ModelAnnotation.this.setModelDisplaySize(result.getDocumentSize());
                            }
                            catch (InterruptedException result) {
                                monitor.done();
                            }
                            catch (Exception e) {
                                ModelAnnotation.this.exception = e;
                                monitor.done();
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                });
            }
            if (this.exception != null) {
                throw this.exception;
            }
        }
        if (isInitialModel || isAutoLayout) {
            this.setModelVersion(4.0);
        }
    }

    private void buildGStructureByDOMTreeNew(SBModel sbModel, Model model) throws Exception {
        boolean isInitialModel = false;
        boolean isAutoLayout = false;
        if (this.nodeListOfAliases == null) {
            if (model.getListOfSpecies().size() == 0L && model.getListOfCompartments().size() == 0L && model.getListOfReactions().size() == 0L) {
                isInitialModel = true;
            } else {
                isAutoLayout = true;
            }
        }
        AutoLayoutResult auto = null;
        if (isAutoLayout) {
            AutoLayout al;
            if (Preference.AUTO_LAYOUT_MODE && !DefaultAutoLayoutDialog.isOldVersionLayout()) {
                al = DefaultAutoLayoutDialog.createLayoutModule();
                auto = al.doLayout(model);
            } else {
                al = new GraphLayout();
                auto = al.doLayout(model);
                this.setModelDisplaySize(auto.getDocumentSize());
            }
        }
        if (!isInitialModel) {
            if (!isAutoLayout) {
                this.buildlIncludedSpeciesByDOMTree(model);
            }
            if (!isAutoLayout) {
                this.buildSpeciesProperty(sbModel, model);
            }
            Vector createdCompartmentAliases = isAutoLayout ? this.createCompartmentAliases(sbModel, this.gStructure.containerNametag(), (ListOf)model.getListOfCompartments(), auto.getCompartmentBounds()) : this.buildCompartmentAliasesByDOMTree(sbModel, model);
            this.gStructure.setContainers(createdCompartmentAliases);
            int i = 0;
            while (i < createdCompartmentAliases.size()) {
                OpenedCompartmentAlias compartment;
                CompartmentAlias alias = (CompartmentAlias)createdCompartmentAliases.elementAt(i);
                alias.buildOutside(this.gStructure);
                if (alias instanceof OpenedCompartmentAlias && !(compartment = (OpenedCompartmentAlias)alias).isNamePositionBuilded()) {
                    Point2D.Double namePoint = compartment.getDefaultCompartmentNamePostion();
                    compartment.setNameImagePosition(namePoint.x, namePoint.y);
                }
                ++i;
            }
            Vector createdComplexSpeciesAlias = new Vector();
            Vector createdTagsWhichLinkingToComplexSpeciesAlias = new Vector();
            if (!isAutoLayout) {
                createdComplexSpeciesAlias = this.buildComplexSpeciesAliasesByDOMTree(sbModel, model, createdCompartmentAliases, createdTagsWhichLinkingToComplexSpeciesAlias);
            }
            this.gStructure.setContainableAtoms(createdComplexSpeciesAlias);
            Vector createdSpeciesAliases = isAutoLayout ? this.createSpeciesAliases(sbModel, this.gStructure.atomNametag(), (ListOf)model.getListOfSpecies(), createdCompartmentAliases, auto.getSpeciesBounds()) : this.buildSpeciesAliasesByDOMTreeNew(this.gStructure, sbModel, model, createdCompartmentAliases, createdComplexSpeciesAlias);
            this.gStructure.setAtoms(createdSpeciesAliases);
            Vector createdAliases = new Vector(createdComplexSpeciesAlias.size() + createdSpeciesAliases.size());
            createdAliases.addAll(createdComplexSpeciesAlias);
            createdAliases.addAll(createdSpeciesAliases);
            Vector links = new Vector();
            ListOfReactions listOfReactions = model.getListOfReactions();
            int i2 = 0;
            while ((long)i2 < listOfReactions.size()) {
                Reaction r = (Reaction)listOfReactions.get((long)i2);
                ReactionAnnotation rExt = (ReactionAnnotation)LibSBMLUtil.getAnnotation(sbModel, (SBase)r, null);
                Vector createdLinks = isAutoLayout ? this.createReactionLinks(sbModel, this.gStructure.linkNametag(), createdAliases, r) : rExt.buildReactionLinksByDOMTreeNew(sbModel, createdAliases, r);
                links.addAll(createdLinks);
                ++i2;
            }
            this.attachSpeciesReferenceAnnotationsToSpeciesAlias(sbModel, model, (ListOf)model.getListOfReactions(), createdAliases);
            this.gStructure.setLinks(links);
            this.gStructure.updateLinks();
            this.resetLinksPositionForVersion4(links);
            this.autoCalcPositionInfoFormVer4(links, this.gStructure);
            this.gStructure.updateLinks(true);
            Vector<GGroup> groups = new Vector<GGroup>();
            if (this.nodeListOfGroups != null) {
                NodeList children = this.nodeListOfGroups.getChildNodes();
                int i3 = 0;
                while (i3 < children.getLength()) {
                    Node n = children.item(i3);
                    if (n.getNodeType() == 1 && n.getNamespaceURI().equals(URI_CELLDESIGNER) && n.getLocalName().equals("group")) {
                        Element nelem = (Element)n;
                        String gid = nelem.getAttributeNS(null, "id");
                        String members = nelem.getAttributeNS(null, "members");
                        StringTokenizer st = new StringTokenizer(members, ",");
                        Vector<GElement> v = new Vector<GElement>();
                        while (st.hasMoreTokens()) {
                            String aid = st.nextToken();
                            GElement a = this.getGElement(aid, this.gStructure.getAtoms());
                            if (a != null) {
                                v.add(a);
                                continue;
                            }
                            a = this.getGElement(aid, this.gStructure.getContainableAtoms());
                            if (a == null) continue;
                            v.add(a);
                        }
                        if (v.size() > 0) {
                            GGroup group = new GGroup(v);
                            group.addCreasePointMember(this.gStructure);
                            group.setName(gid);
                            group.update();
                            groups.add(group);
                        }
                    }
                    ++i3;
                }
            }
            this.gStructure.setGroups(groups);
        }
        if (isAutoLayout && Preference.AUTO_LAYOUT_MODE && !DefaultAutoLayoutDialog.isOldVersionLayout()) {
            final YAutoLayout layout = (YAutoLayout)DefaultAutoLayoutDialog.createLayoutModule();
            this.exception = null;
            if (!this.isProgressShowing) {
                AutoLayoutResult result = layout.doLayout(null, this.gStructure);
                this.setModelDisplaySize(result.getDocumentSize());
            } else {
                ProgressMonitorDialog dialog = new ProgressMonitorDialog((JComponent)sbModel.getSbframe(), "Automatic Graph Layout");
                dialog.setMonitor((IProgressMonitor)new LayoutProgressMonitor(dialog));
                dialog.run(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        try {
                            try {
                                layout.setMonitor(monitor);
                                AutoLayoutResult result = layout.doLayout(null, ModelAnnotation.this.gStructure);
                                ModelAnnotation.this.setModelDisplaySize(result.getDocumentSize());
                            }
                            catch (InterruptedException result) {
                                monitor.done();
                            }
                            catch (Exception e) {
                                ModelAnnotation.this.exception = e;
                                monitor.done();
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                });
            }
            if (this.exception != null) {
                throw this.exception;
            }
        }
        if (isInitialModel || isAutoLayout) {
            this.setModelVersion(4.0);
        }
    }

    private void resetLinksPositionForVersion4(Vector links) {
        int size = links.size();
        int i = 0;
        while (i < size) {
            block19: {
                GLinkPositionInfo pInfo2;
                ReactionLink link;
                block16: {
                    StateTransition stateTransition;
                    Point2D.Double[] anchors;
                    GLinkedShape shape;
                    LinkedCreaseLine line;
                    block18: {
                        block17: {
                            link = (ReactionLink)links.elementAt(i);
                            if (!GLogicGate.isModification(link.getGLinkedShape()) && !(link.getGLinkedShape() instanceof GLogicGate)) break block16;
                            line = null;
                            if (!GLogicGate.isModification(link.getGLinkedShape())) break block17;
                            line = (LinkedCreaseLine)link.getGLinkedShape();
                            if (line.isSingleLine()) break block18;
                            break block19;
                        }
                        line = ((GLogicGate)link.getGLinkedShape()).getRealLine();
                    }
                    if (line.getEndTarget() instanceof ReactionLink && (line.getEndLinkPositionInfo() == null || line.getEndLinkPositionInfo().getPosition() < 2 || line.getEndLinkPositionInfo().getPosition() > 7) && (shape = ((ReactionLink)line.getEndTarget()).getGLinkedShape()) instanceof StateTransition && !(shape instanceof LinkedCreaseLineMixedNotation) && (anchors = (stateTransition = (StateTransition)shape).getOmittedShape().getAnchors(true)) != null && anchors.length == 8) {
                        Point2D.Double startPoint = line.getLines()[line.getLineSize() - 1].getStartPoint();
                        double distance = Math.pow(Math.pow(startPoint.x - anchors[2].x, 2.0) + Math.pow(startPoint.y - anchors[2].y, 2.0), 0.5);
                        double tempDistance = 0.0;
                        int minDistanceIndex = 2;
                        int k = 3;
                        while (k < 8) {
                            tempDistance = Math.pow(Math.pow(startPoint.x - anchors[k].x, 2.0) + Math.pow(startPoint.y - anchors[k].y, 2.0), 0.5);
                            if (tempDistance < distance) {
                                minDistanceIndex = k;
                                distance = tempDistance;
                            }
                            ++k;
                        }
                        if (minDistanceIndex != 2 && minDistanceIndex != 3) {
                            minDistanceIndex = minDistanceIndex == 4 || minDistanceIndex == 5 ? 2 : (minDistanceIndex == 6 || minDistanceIndex == 7 ? 3 : 2);
                        }
                        try {
                            GLinkPositionInfo gPosInf = new GLinkPositionInfo(minDistanceIndex, 0.0);
                            gPosInf.setElement((GElement)((Object)line.getEndTarget()));
                            link.setTargetAt(line.getEndTarget(), 1, gPosInf);
                        }
                        catch (Exception e) {}
                    }
                    break block19;
                }
                if (link.getGLinkedShape() instanceof AddReactant) {
                    ReactionLink reactant = link;
                    boolean bMustresetPostionInfo = false;
                    bMustresetPostionInfo = reactant.getLinkPositionInfos() == null || reactant.getLinkPositionInfos()[1] == null ? true : reactant.getLinkPositionInfos()[1].getPosition() != 0;
                    if (bMustresetPostionInfo) {
                        try {
                            pInfo2 = new GLinkPositionInfo(0, 0.0);
                            pInfo2.setElement((GElement)((Object)link.getTargetAt(1)));
                            reactant.setTargetAt(link.getTargetAt(1), 1, pInfo2);
                            reactant.update();
                        }
                        catch (Exception pInfo2) {}
                    }
                } else if (link.getGLinkedShape() instanceof AddProduct) {
                    ReactionLink productor = link;
                    boolean bMustresetPostionInfo = false;
                    bMustresetPostionInfo = productor.getLinkPositionInfos() == null || productor.getLinkPositionInfos()[0] == null ? true : productor.getLinkPositionInfos()[0].getPosition() != 1;
                    if (bMustresetPostionInfo) {
                        try {
                            pInfo2 = new GLinkPositionInfo(1, 0.0);
                            pInfo2.setElement((GElement)((Object)link.getTargetAt(0)));
                            productor.setTargetAt(link.getTargetAt(0), 0, pInfo2);
                            productor.update();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            ++i;
        }
    }

    private void autoCalcPositionInfoFormVer4(Vector links, GStructure gstructure) {
        int i = 0;
        while (i < links.size()) {
            ReactionLink link = (ReactionLink)links.elementAt(i);
            if (link.isBaseLink() && link.getGLinkedShape() instanceof GLinkedLineComplex3) {
                Vector vReactants = gstructure.getReactantsWhichislinkingtoME(link);
                int iReactant = 0;
                while (iReactant < vReactants.size()) {
                    ReactionLink reactant = (ReactionLink)vReactants.elementAt(iReactant);
                    boolean bMustresetPostionInfo = false;
                    bMustresetPostionInfo = reactant.getLinkPositionInfos() == null || reactant.getLinkPositionInfos()[1] == null ? true : reactant.getLinkPositionInfos()[1].getPosition() != 0;
                    if (bMustresetPostionInfo) {
                        GLinkPositionInfo pInfo = new GLinkPositionInfo(0, 0.0);
                        pInfo.setElement(link);
                        try {
                            reactant.setTargetAt((GLinkTarget)link, 1, pInfo);
                            reactant.update();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ++iReactant;
                }
                Vector vProductors = gstructure.getProductorWhichislinkingtoME(link);
                int iProductor = 0;
                while (iProductor < vProductors.size()) {
                    ReactionLink productor = (ReactionLink)vProductors.elementAt(iProductor);
                    boolean bMustresetPostionInfo = false;
                    bMustresetPostionInfo = productor.getLinkPositionInfos() == null || productor.getLinkPositionInfos()[0] == null ? true : productor.getLinkPositionInfos()[0].getPosition() != 1;
                    if (bMustresetPostionInfo) {
                        GLinkPositionInfo pInfo = new GLinkPositionInfo(1, 0.0);
                        pInfo.setElement(link);
                        try {
                            productor.setTargetAt((GLinkTarget)link, 0, pInfo);
                            productor.update();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ++iProductor;
                }
                Vector vModifications = gstructure.getModificationsWhichislinkingtoME(link);
                int iModification = 0;
                while (iModification < vModifications.size()) {
                    GLinkedLine lnklineModification;
                    ReactionLink modification = (ReactionLink)vModifications.elementAt(iModification);
                    boolean bMustresetPostionInfo = false;
                    bMustresetPostionInfo = modification.getLinkPositionInfos() == null || modification.getLinkPositionInfos()[1] == null ? true : modification.getLinkPositionInfos()[1].getPosition() < 2 || modification.getLinkPositionInfos()[1].getPosition() > 7;
                    if (bMustresetPostionInfo && (lnklineModification = (GLinkedLine)modification.getGLinkedShape()).getEndLinkPositionInfo() != null) {
                        try {
                            GLinkPositionInfo glpiClone = (GLinkPositionInfo)lnklineModification.getEndLinkPositionInfo().clone();
                            if (glpiClone.getPosition() < 2 || glpiClone.getPosition() > 7) {
                                bMustresetPostionInfo = true;
                            } else {
                                modification.setTargetAt((GLinkTarget)link, 1, glpiClone);
                                bMustresetPostionInfo = false;
                            }
                        }
                        catch (Exception e) {
                            bMustresetPostionInfo = true;
                        }
                    }
                    if (bMustresetPostionInfo) {
                        try {
                            GLinkPositionInfo pInfo = new GLinkPositionInfo(2, 0.0);
                            GLinkedLineComplex3 compx3 = (GLinkedLineComplex3)link.getGLinkedShape();
                            Point2D.Double[] arrAll = compx3.setupLinkAnchorCoord();
                            Point2D.Double[] arrModifications = new Point2D.Double[6];
                            if (arrAll.length >= 8) {
                                int n = 0;
                                while (n < arrModifications.length) {
                                    arrModifications[n] = arrAll[n + 2];
                                    ++n;
                                }
                                Point2D.Double pointLineStart = ((GLinkedCreaseLine)modification.getGLinkedShape()).getStartPoint();
                                pInfo = ShapeUtil.getNearLinkAnchorPositionForLink(arrModifications, pointLineStart.x, pointLineStart.y);
                                pInfo.setPosition(pInfo.getPosition() + 2);
                                if (pInfo.getPosition() != 2 && pInfo.getPosition() != 3) {
                                    if (pInfo.getPosition() == 4 || pInfo.getPosition() == 5) {
                                        pInfo.setPosition(2);
                                    } else if (pInfo.getPosition() == 6 || pInfo.getPosition() == 7) {
                                        pInfo.setPosition(3);
                                    } else {
                                        pInfo.setPosition(2);
                                    }
                                }
                            }
                            pInfo.setElement(link);
                            modification.setTargetAt((GLinkTarget)link, 1, pInfo);
                        }
                        catch (Exception e) {
                            try {
                                modification.setTargetAt((GLinkTarget)link, 1, new GLinkPositionInfo(2, 0.0));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        modification.update();
                    }
                    ++iModification;
                }
            }
            ++i;
        }
    }

    private GElement getGElement(String id, Vector elements) {
        GElement rtn = null;
        int j = 0;
        while (j < elements.size()) {
            GElement elem = (GElement)elements.elementAt(j);
            if (elem.getName().equals(id)) {
                rtn = elem;
                break;
            }
            ++j;
        }
        return rtn;
    }

    private Vector createCompartmentAliases(SBModel sbModel, String tagName, ListOf listOfCompartments, Vector cBounds) {
        Vector<ClosedCompartmentAlias> createdAliases = new Vector<ClosedCompartmentAlias>();
        int i = 0;
        while ((long)i < listOfCompartments.size()) {
            Compartment c = (Compartment)listOfCompartments.get((long)i);
            if (!c.getId().equals("default")) {
                CompartmentAnnotation cExt = (CompartmentAnnotation)LibSBMLUtil.getAnnotation(sbModel, (SBase)c, null);
                Rectangle2D.Double bounds = (Rectangle2D.Double)cBounds.elementAt(i);
                ClosedCompartmentAlias alias = new ClosedCompartmentAlias();
                alias.setName(String.valueOf(tagName) + i);
                alias.setOriginalCompartment(c);
                String name = c.getName();
                if (name.equals("")) {
                    name = c.getId();
                    c.setName(name);
                }
                alias.setCompartmentName(name);
                cExt.setCompartmentName(name);
                SBSymbol symbol = SBFactory.createSymbol("SQUARE");
                if (symbol != null) {
                    try {
                        alias.setSymbol(symbol);
                    }
                    catch (Exception e) {
                        Debug.println("[ModelAnnotaion]createCompartmentAliases()," + e.getMessage());
                    }
                }
                alias.setFramePosition(bounds.x, bounds.y);
                alias.setFrameSize(bounds.width, bounds.height);
                alias.update();
                cExt.addReference(alias);
                createdAliases.add(alias);
            }
            ++i;
        }
        return createdAliases;
    }

    private Vector createSpeciesAliases(SBModel sbModel, String tagName, ListOf listOfSpecies, Vector compartmentAliases, Vector sBounds) {
        Vector<ElementSpeciesAlias> createdAliases = new Vector<ElementSpeciesAlias>();
        int i = 0;
        while ((long)i < listOfSpecies.size()) {
            Species s = (Species)listOfSpecies.get((long)i);
            SpeciesAnnotation sExt = (SpeciesAnnotation)LibSBMLUtil.getAnnotation(sbModel, (SBase)s, null);
            Rectangle2D.Double bounds = (Rectangle2D.Double)sBounds.elementAt(i);
            ElementSpeciesAlias alias = new ElementSpeciesAlias();
            alias.setName(String.valueOf(tagName) + i);
            alias.setOriginalSpecies(s);
            String name = s.getName();
            if (name.equals("")) {
                name = s.getId();
                s.setName(name);
            }
            MonoSpeciesProperty property = new MonoSpeciesProperty();
            HashMap hashRepairSpecies = sbModel.getHashRepairSpecies();
            if (s.getId() != null && hashRepairSpecies != null && hashRepairSpecies.containsKey(s.getId())) {
                property.setType("DEGRADED");
            } else {
                property.setType("PROTEIN");
            }
            property.setName(name);
            property.setHomodimer(1);
            MonoSpeciesShape mono = new MonoSpeciesShape();
            mono.setProperty(property);
            alias.setGFramedShape(mono);
            alias.setFramePosition(bounds.x, bounds.y);
            alias.setFrameSize(bounds.width, bounds.height);
            String code = property.getType();
            if (s.getId() == null || hashRepairSpecies == null || !hashRepairSpecies.containsKey(s.getId())) {
                Protein p = (Protein)this.hashProtein.get("pr" + (i + 1));
                property.setProtein(p);
                if (property.getProtein() != null) {
                    code = property.getProtein().getType();
                }
            }
            mono.buildPaintingsForType(code);
            mono.changeView(new Integer(0));
            String briefType = SBFactory.getBriefViewType(code);
            Dimension d = (Dimension)Preference.defaultSpeciesSize.get(briefType);
            if (d == null) {
                SpeciesSymbol briefSymbol = (SpeciesSymbol)((Object)SBFactory.createSymbol(briefType));
                d = briefSymbol.defaultSize();
            }
            alias.setFrameSize(1, d.width, d.height);
            alias.update();
            String compartment = s.getCompartment();
            int position = 4;
            if (!compartment.equals("") && !compartment.equals("default")) {
                ClosedCompartmentAlias matched = null;
                int k = 0;
                while (k < compartmentAliases.size()) {
                    ClosedCompartmentAlias calias = (ClosedCompartmentAlias)compartmentAliases.elementAt(k);
                    Compartment c = calias.getOriginalCompartment();
                    if (c.getId().equals(compartment)) {
                        matched = calias;
                        break;
                    }
                    ++k;
                }
                if (matched != null) {
                    GStructure.setContainerTarget(matched, alias);
                    position = ((GContainer)matched).includes(alias);
                    if (position == 0) {
                        position = 4;
                    }
                }
            }
            sExt.addReference(alias);
            sExt.setSpeciesProperty(property.deepClone());
            sExt.setPositionToCompartment(position);
            createdAliases.add(alias);
            ++i;
        }
        return createdAliases;
    }

    private Vector createReactionLinks(SBModel sbModel, String tagName, Vector createdSpeciesAliases, Reaction r) {
        Vector<ReactionLink> createdLinks = new Vector<ReactionLink>();
        ReactionAnnotation rExt = (ReactionAnnotation)LibSBMLUtil.getAnnotation(sbModel, (SBase)r, null);
        String name = r.getName();
        if (name.equals("")) {
            name = r.getId();
            r.setName(name);
        }
        rExt.setReactionName(name);
        ListOfSpeciesReferences listOfReactants = r.getListOfReactants();
        ListOfSpeciesReferences listOfProducts = r.getListOfProducts();
        ListOfSpeciesReferences listOfModifiers = r.getListOfModifiers();
        if (listOfReactants.size() > 0L && listOfProducts.size() > 0L) {
            ReactionLink link;
            SpeciesAlias alias;
            String id;
            SpeciesReference ref;
            SpeciesReference rref = (SpeciesReference)listOfReactants.get(0L);
            String rId = rref.getSpecies();
            SpeciesAlias ralias = this.getSpeciesAlias(rId, createdSpeciesAliases);
            SpeciesReference pref = (SpeciesReference)listOfProducts.get(0L);
            String pId = pref.getSpecies();
            SpeciesAlias palias = this.getSpeciesAlias(pId, createdSpeciesAliases);
            boolean cyclic = false;
            int originalDefaultCreasePoints = GLinkedLine.getDefaultCreasePointNumber();
            if (ralias != null && ralias == palias) {
                cyclic = true;
                GLinkedLine.setDefaultCreasePointNumber(3);
            }
            ReactionLink baseLink = new ReactionLink(1, 1);
            SBSymbol symbol = SBFactory.createSymbol("STATE_TRANSITION");
            if (cyclic) {
                GLinkedLine.setDefaultCreasePointNumber(originalDefaultCreasePoints);
            }
            if (symbol != null) {
                try {
                    baseLink.setSymbol(symbol);
                }
                catch (Exception e) {
                    Debug.println("[ModelAnnotaion]createReactionLinks()," + e.getMessage());
                }
            }
            baseLink.setParentReaction(r);
            baseLink.setName(r.getId());
            String code = symbol.getCode();
            GLinkedShape linkedShape = (GLinkedShape)((Object)baseLink.getSymbol());
            linkedShape.setColor(ReactionColorScheme.getColor(code));
            linkedShape.setLineWidth(ReactionColorScheme.getLineWidth(code));
            if (ralias != null) {
                baseLink.addSource((GLinkTarget)ralias, (GLinkPositionInfo)null);
                ((SpeciesReferenceAnnotation)LibSBMLUtil.getAnnotation(sbModel, r, (SBase)rref, "Reactants", 0, null)).setTmpAliasId(ralias.getName());
            }
            if (palias != null) {
                baseLink.addDestination((GLinkTarget)palias, (GLinkPositionInfo)null);
                ((SpeciesReferenceAnnotation)LibSBMLUtil.getAnnotation(sbModel, r, (SBase)pref, "Products", 0, null)).setTmpAliasId(palias.getName());
            }
            ((ReactionSymbol)((Object)symbol)).setReversible(r.getReversible());
            Node tempNode = rExt.getnodesResourceOfDescription();
            if (tempNode != null) {
                Vector vecResource = LibSBMLUtil.getMiriamsFromNode(new Vector(), (Element)tempNode, null);
                StringBuffer buf = LibSBMLUtil.getMiriamValueFromMiriams(new StringBuffer(), (SBase)r, vecResource, true);
                XMLNode annotation = XMLNode.convertStringToXMLNode((String)buf.toString());
                r.setAnnotation(annotation);
                r.setAnnotation(buf.toString());
            }
            rExt.setType("STATE_TRANSITION");
            rExt.setBaseLink(baseLink);
            createdLinks.add(baseLink);
            if (cyclic) {
                GEditPoint[] editPoints = ((GLinkedCreaseLine)linkedShape).getEditPoints();
                Rectangle2D.Double aliasPoint = ralias.getFrameBounds();
                double acx = aliasPoint.x + aliasPoint.width / 2.0;
                double acy = aliasPoint.y + aliasPoint.height / 2.0;
                double dx = 60.0;
                double dy = 40.0;
                ((GLinkedCreaseLine)linkedShape).updateLine();
                ((GLinkedCreaseLine)linkedShape).moveEditPoint(editPoints[0], acx + 60.0, acy);
                ((GLinkedCreaseLine)linkedShape).moveEditPoint(editPoints[1], acx + 60.0, acy - 40.0);
                ((GLinkedCreaseLine)linkedShape).moveEditPoint(editPoints[2], acx, acy - 40.0);
            }
            int i = 1;
            while ((long)i < listOfReactants.size()) {
                ref = (SpeciesReference)listOfReactants.get((long)i);
                id = ref.getSpecies();
                alias = this.getSpeciesAlias(id, createdSpeciesAliases);
                if (alias != null) {
                    ((SpeciesReferenceAnnotation)LibSBMLUtil.getAnnotation(sbModel, r, (SBase)ref, "Reactants", i, null)).setTmpAliasId(alias.getName());
                    SBSymbol sb = SBFactory.createSymbol("ADD_REACTANT");
                    link = new ReactionLink(((ReactionSymbol)((Object)sb)).sourceSize(), ((ReactionSymbol)((Object)sb)).destinationSize());
                    try {
                        link.setSymbol(sb);
                    }
                    catch (Exception dx) {
                        // empty catch block
                    }
                    link.setParentReaction(r);
                    link.setName(String.valueOf(r.getId()) + "r" + i);
                    link.addSource((GLinkTarget)alias, (GLinkPositionInfo)null);
                    link.addDestination((GLinkTarget)baseLink, (GLinkPositionInfo)null);
                    GLinkedShape linkedShape1 = (GLinkedShape)((Object)link.getSymbol());
                    linkedShape1.setColor(ReactionColorScheme.getColor(sb.getCode()));
                    linkedShape1.setLineWidth(ReactionColorScheme.getLineWidth(sb.getCode()));
                    linkedShape1.setLineType(ReactionColorScheme.getLineType(sb.getCode()));
                    rExt.addAddReactantLink(link);
                    createdLinks.add(link);
                }
                ++i;
            }
            i = 1;
            while ((long)i < listOfProducts.size()) {
                ref = (SpeciesReference)listOfProducts.get((long)i);
                id = ref.getSpecies();
                alias = this.getSpeciesAlias(id, createdSpeciesAliases);
                if (alias != null) {
                    ((SpeciesReferenceAnnotation)LibSBMLUtil.getAnnotation(sbModel, r, (SBase)ref, "Products", i, null)).setTmpAliasId(alias.getName());
                    SBSymbol sb = SBFactory.createSymbol("ADD_PRODUCT");
                    link = new ReactionLink(((ReactionSymbol)((Object)sb)).sourceSize(), ((ReactionSymbol)((Object)sb)).destinationSize());
                    try {
                        link.setSymbol(sb);
                    }
                    catch (Exception linkedShape1) {
                        // empty catch block
                    }
                    link.setParentReaction(r);
                    link.setName(String.valueOf(r.getId()) + "p" + i);
                    link.addSource((GLinkTarget)baseLink, (GLinkPositionInfo)null);
                    link.addDestination((GLinkTarget)alias, (GLinkPositionInfo)null);
                    GLinkedShape linkedShape1 = (GLinkedShape)((Object)link.getSymbol());
                    linkedShape1.setColor(ReactionColorScheme.getColor(sb.getCode()));
                    linkedShape1.setLineWidth(ReactionColorScheme.getLineWidth(sb.getCode()));
                    linkedShape1.setLineType(ReactionColorScheme.getLineType(sb.getCode()));
                    rExt.addAddProductLink(link);
                    createdLinks.add(link);
                }
                ++i;
            }
            i = 0;
            while ((long)i < listOfModifiers.size()) {
                ref = (ModifierSpeciesReference)listOfModifiers.get((long)i);
                id = ref.getSpecies();
                alias = this.getSpeciesAlias(id, createdSpeciesAliases);
                if (alias != null) {
                    ((SpeciesReferenceAnnotation)LibSBMLUtil.getAnnotation(sbModel, r, (SBase)ref, null, i, null)).setTmpAliasId(alias.getName());
                    SBSymbol sb = SBFactory.createSymbol("CATALYSIS");
                    link = new ReactionLink(((ReactionSymbol)((Object)sb)).sourceSize(), ((ReactionSymbol)((Object)sb)).destinationSize());
                    try {
                        link.setSymbol(sb);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    link.setParentReaction(r);
                    link.setName(String.valueOf(r.getId()) + "m" + i);
                    link.addSource((GLinkTarget)alias, (GLinkPositionInfo)null);
                    link.addDestination((GLinkTarget)baseLink, (GLinkPositionInfo)null);
                    rExt.addModificationLink(link);
                    createdLinks.add(link);
                }
                ++i;
            }
        }
        return createdLinks;
    }

    private SpeciesAlias getSpeciesAlias(String speciesId, Vector aliases) {
        SpeciesAlias alias = null;
        int j = 0;
        while (j < aliases.size()) {
            SpeciesAlias a = (SpeciesAlias)aliases.elementAt(j);
            Species s = a.getOriginalSpecies();
            if (s.getId().equals(speciesId)) {
                alias = a;
                break;
            }
            ++j;
        }
        return alias;
    }

    private void buildListOfGeneEtcByDOMTree(SBModel sbModel, ListOf listOfSpecies) throws Exception {
        HashMap<String, String> geneMap = new HashMap<String, String>();
        HashMap<String, String> rnaMap = new HashMap<String, String>();
        HashMap<String, String> aRnaMap = new HashMap<String, String>();
        NameSpace gns = new NameSpace(Gene.class);
        gns.setPrefix("gn");
        gns.setGetName("getId");
        gns.setSetName("setId");
        gns.parse(new Vector());
        NameSpace rns = new NameSpace(RNA.class);
        rns.setPrefix("rn");
        rns.setGetName("getId");
        rns.setSetName("setId");
        rns.parse(new Vector());
        NameSpace arns = new NameSpace(AntiSenseRNA.class);
        arns.setPrefix("arn");
        arns.setGetName("getId");
        arns.setSetName("setId");
        arns.parse(new Vector());
        int i = 0;
        while ((long)i < listOfSpecies.size()) {
            block28: {
                SpeciesProperty property;
                Species species;
                block26: {
                    String subType;
                    String id;
                    String name;
                    String type;
                    MonoSpeciesProperty monoProperty;
                    block29: {
                        block27: {
                            species = (Species)listOfSpecies.get((long)i);
                            SpeciesAnnotation spanno = (SpeciesAnnotation)LibSBMLUtil.getAnnotation(sbModel, (SBase)species, null);
                            property = spanno.getSpeciesProperty();
                            if (!(property instanceof MonoSpeciesProperty)) break block26;
                            monoProperty = (MonoSpeciesProperty)property;
                            type = monoProperty.getType();
                            name = monoProperty.getName();
                            if (!type.equals("GENE")) break block27;
                            if (name.equals("")) {
                                throw new Exception("[" + this + ".buildListOfGeneEtcByDOMTree()]: name of property is \"\" for " + "Species=" + species.getId());
                            }
                            id = null;
                            if (!geneMap.containsKey(name)) {
                                Gene gene = new Gene();
                                subType = "GENE";
                                gene.setType(subType);
                                gene.setName(name);
                                gns.assignNameTo(gene);
                                id = gene.getId();
                                geneMap.put(name, id);
                                this.listOfGenes.appendAndOwn((SBase)gene);
                                this.hashGene.put(gene.getId(), gene);
                            } else {
                                id = (String)geneMap.get(name);
                            }
                            monoProperty.setReadingSomeId(id);
                            break block28;
                        }
                        if (!type.equals("RNA")) break block29;
                        if (name.equals("")) {
                            throw new Exception("[" + this + ".buildListOfGeneEtcByDOMTree()]: name of property is \"\" for " + "Species=" + species.getId());
                        }
                        id = null;
                        if (!rnaMap.containsKey(name)) {
                            RNA rna = new RNA();
                            subType = "RNA";
                            rna.setType(subType);
                            rna.setName(name);
                            rns.assignNameTo(rna);
                            id = rna.getId();
                            rnaMap.put(name, id);
                            this.listOfRNAs.appendAndOwn((SBase)rna);
                            this.hashRNA.put(rna.getId(), rna);
                        } else {
                            id = (String)rnaMap.get(name);
                        }
                        monoProperty.setReadingSomeId(id);
                        break block28;
                    }
                    if (!type.equals("ANTISENSE_RNA")) break block28;
                    if (name.equals("")) {
                        throw new Exception("[" + this + ".buildListOfGeneEtcByDOMTree()]: name of property is \"\" for " + "Species=" + species.getId());
                    }
                    id = null;
                    if (!aRnaMap.containsKey(name)) {
                        AntiSenseRNA arna = new AntiSenseRNA();
                        subType = "ANTISENSE_RNA";
                        arna.setType(subType);
                        arna.setName(name);
                        arns.assignNameTo(arna);
                        id = arna.getId();
                        aRnaMap.put(name, id);
                        this.listOfAntiSenseRNAs.appendAndOwn((SBase)arna);
                        this.hashAntiSenseRNA.put(arna.getId(), arna);
                    } else {
                        id = (String)aRnaMap.get(name);
                    }
                    monoProperty.setReadingSomeId(id);
                    break block28;
                }
                if (property instanceof ComplexSpeciesProperty) {
                    Vector entries = ((ComplexSpeciesProperty)property).getReadingEntries();
                    int j = 0;
                    while (j < entries.size()) {
                        String subType;
                        String id;
                        Object[] entry = (Object[])entries.elementAt(j);
                        MonoSpeciesProperty monoProperty = (MonoSpeciesProperty)entry[2];
                        String type = monoProperty.getType();
                        String name = monoProperty.getName();
                        if (type.equals("GENE")) {
                            if (name.equals("")) {
                                throw new Exception("[" + this + ".buildListOfGeneEtcByDOMTree()]: name of property is \"\" for " + "Species=" + species.getId());
                            }
                            id = null;
                            if (!geneMap.containsKey(name)) {
                                Gene gene = new Gene();
                                subType = "GENE";
                                gene.setType(subType);
                                gene.setName(name);
                                gns.assignNameTo(gene);
                                id = gene.getId();
                                geneMap.put(name, id);
                                this.listOfGenes.appendAndOwn((SBase)gene);
                                this.hashGene.put(gene.getId(), gene);
                            } else {
                                id = (String)geneMap.get(name);
                            }
                            monoProperty.setReadingSomeId(id);
                        } else if (type.equals("RNA")) {
                            if (name.equals("")) {
                                throw new Exception("[" + this + ".buildListOfGeneEtcByDOMTree()]: name of property is \"\" for " + "Species=" + species.getId());
                            }
                            id = null;
                            if (!rnaMap.containsKey(name)) {
                                RNA rna = new RNA();
                                subType = "RNA";
                                rna.setType(subType);
                                rna.setName(name);
                                rns.assignNameTo(rna);
                                id = rna.getId();
                                rnaMap.put(name, id);
                                this.listOfRNAs.appendAndOwn((SBase)rna);
                                this.hashRNA.put(rna.getId(), rna);
                            } else {
                                id = (String)rnaMap.get(name);
                            }
                            monoProperty.setReadingSomeId(id);
                        } else if (type.equals("ANTISENSE_RNA")) {
                            if (name.equals("")) {
                                throw new Exception("[" + this + ".buildListOfGeneEtcByDOMTree()]: name of property is \"\" for " + "Species=" + species.getId());
                            }
                            id = null;
                            if (!aRnaMap.containsKey(name)) {
                                AntiSenseRNA arna = new AntiSenseRNA();
                                subType = "ANTISENSE_RNA";
                                arna.setType(subType);
                                arna.setName(name);
                                arns.assignNameTo(arna);
                                id = arna.getId();
                                aRnaMap.put(name, id);
                                this.listOfAntiSenseRNAs.appendAndOwn((SBase)arna);
                                this.hashAntiSenseRNA.put(arna.getId(), arna);
                            } else {
                                id = (String)aRnaMap.get(name);
                            }
                            monoProperty.setReadingSomeId(id);
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    private void buildlIncludedSpeciesByDOMTree(Model model) {
        if (Preference.isDebug) {
            System.out.println("\n+++buildlIncludedSpeciesByDOMTree");
        }
        if (this.nodeListOfIncludedSpecies == null) {
            return;
        }
        NodeList children = this.nodeListOfIncludedSpecies.getChildNodes();
        int j = 0;
        while (j < children.getLength()) {
            Node n = children.item(j);
            if (n.getNodeType() == 1 && n.getNamespaceURI().equals(URI_CELLDESIGNER) && n.getLocalName().equals("species")) {
                Species species = model.createSpecies();
                try {
                    LibSBMLUtil.readDOMTree((SBase)species, (Element)n, sbmlSpec);
                }
                catch (Exception e) {
                    DebugPrinter.println(1, "ModelAnnotation-readingList-catch reading <species> : " + e.getMessage() + ", skip");
                }
            }
            ++j;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void buildSpeciesProperty(SBModel sbModel, Model model) throws Exception {
        complexToElements = new HashMap<String, Vector<E>>();
        listOfSpecies = model.getListOfSpecies();
        i = 0;
        while ((long)i < listOfSpecies.size()) {
            s = (Species)listOfSpecies.get((long)i);
            sa = (SpeciesAnnotation)LibSBMLUtil.getAnnotation(sbModel, (SBase)s, null);
            if (sa == null) {
                throw new Exception("[" + this + ".buildSpeciesProperty()]: SpeciesAnnotation is null " + "for Species (id=" + s.getId() + ")");
            }
            sp = (MonoSpeciesProperty)sa.getSpeciesProperty();
            type = sp.getType();
            if (type.equals("COMPLEX")) {
                complexToElements.put(s.getId(), new Vector<E>());
            }
            ++i;
        }
        i = 0;
        while ((long)i < listOfSpecies.size()) {
            s = (Species)listOfSpecies.get((long)i);
            sa = (SpeciesAnnotation)LibSBMLUtil.getAnnotation(sbModel, (SBase)s, null);
            complexId = sa.getComplexSpecies();
            if (complexId.equals("")) ** GOTO lbl29
            v = (Vector)complexToElements.get(complexId);
            if (v != null) ** GOTO lbl28
            if (Preference.isDebug) {
                System.err.println("[" + this + ".buildSpeciesProperty()]: Complex (id=" + complexId + ") does not exist for " + "element Species (id=" + s.getId() + ")");
            } else {
                throw new Exception("[" + this + ".buildSpeciesProperty()]: Complex (id=" + complexId + ") does not exist for " + "element Species (id=" + s.getId() + ")");
lbl28:
                // 1 sources

                v.addElement(s);
lbl29:
                // 2 sources

                sp = (MonoSpeciesProperty)sa.getSpeciesProperty();
                type = sp.getType();
                someId = sp.getReadingSomeId();
                if (someId.equals("") && (type.equals("PROTEIN") || type.equals("GENE") || type.equals("RNA") || type.equals("ANTISENSE_RNA"))) {
                    throw new Exception("[" + this + ".buildSpeciesProperty()]: Reading (protein, gene, RNA, or asRNA) " + "reference is null for Species(id=" + s.getId() + ")");
                }
                if (type.equals("PROTEIN")) {
                    p = sbModel.getProtein(someId);
                    sp.setProtein(p);
                } else if (type.equals("GENE")) {
                    g = sbModel.getGene(someId);
                    sp.setGene(g);
                } else if (type.equals("RNA")) {
                    r = sbModel.getRNA(someId);
                    sp.setRNA(r);
                } else if (type.equals("ANTISENSE_RNA")) {
                    asr = sbModel.getAntiSenseRNA(someId);
                    sp.setAntiSenseRNA(asr);
                }
                sp.clearReadingSomeId();
            }
            ++i;
        }
        tmpComplexToElements = (HashMap)complexToElements.clone();
        i = false;
        while (!tmpComplexToElements.keySet().isEmpty()) {
            it = tmpComplexToElements.keySet().iterator();
            id = (String)it.next();
            this.updateComplexMonoProperties(sbModel, model, tmpComplexToElements, id);
        }
    }

    private void updateComplexMonoProperties(SBModel sbModel, Model model, HashMap tmpElements, String id) {
        Species s = model.getSpecies(id);
        SpeciesAnnotation sa = (SpeciesAnnotation)LibSBMLUtil.getAnnotation(sbModel, (SBase)s, null);
        ComplexProperty sp = (ComplexProperty)sa.getSpeciesProperty();
        Vector elements = (Vector)tmpElements.get(id);
        Vector<MonoSpeciesProperty> monoProps = new Vector<MonoSpeciesProperty>();
        int i = 0;
        while (i < elements.size()) {
            Species selem = (Species)elements.elementAt(i);
            if (tmpElements.keySet().contains(selem.getId())) {
                this.updateComplexMonoProperties(sbModel, model, tmpElements, selem.getId());
            }
            SpeciesAnnotation selema = (SpeciesAnnotation)LibSBMLUtil.getAnnotation(sbModel, (SBase)selem, null);
            MonoSpeciesProperty msp = (MonoSpeciesProperty)selema.getSpeciesProperty().deepClone();
            monoProps.addElement(msp);
            ++i;
        }
        sp.setMonoProperties(monoProps);
        if (tmpElements.keySet().contains(id)) {
            tmpElements.remove(id);
        }
    }

    private Vector buildCompartmentAliasesByDOMTree(SBModel sbModel, Model model) {
        Vector<GElementImpl> createdAliases = new Vector<GElementImpl>();
        if (this.nodeListOfCompartmentAliases == null) {
            return createdAliases;
        }
        NodeList children = this.nodeListOfCompartmentAliases.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node n = children.item(i);
            if (n.getNodeType() == 1 && n.getNamespaceURI().equals(URI_CELLDESIGNER) && n.getLocalName().equals("compartmentAlias")) {
                XMLNode annt;
                StringBuffer bufMiriam;
                Vector veRealation;
                Element elem0;
                Node annotationNode;
                CompartmentAnnotation cm;
                String strSID;
                Rectangle2D.Double maxarea;
                GElementImpl alias;
                NodeList nchild = n.getChildNodes();
                Node boundsNode = null;
                int j = 0;
                while (j < nchild.getLength()) {
                    Node temp = nchild.item(j);
                    if (temp.getNodeType() == 1 && temp.getNamespaceURI().equals(URI_CELLDESIGNER) && temp.getLocalName().equals("bounds")) {
                        boundsNode = temp;
                        break;
                    }
                    ++j;
                }
                if (boundsNode != null) {
                    alias = new ClosedCompartmentAlias();
                    if (this.gStructure != null && (maxarea = this.gStructure.getMaxDrawSize()) != null) {
                        ((GFramedContainer)alias).setMaxArea(maxarea);
                    }
                    ((ClosedCompartmentAlias)alias).readDOMTree(sbModel, (Element)n, model);
                    strSID = ((ClosedCompartmentAlias)alias).getOriginalCompartment().getId();
                    cm = (CompartmentAnnotation)sbModel.getHashCompartmentAnnotation().get(strSID);
                    if (cm != null && (annotationNode = cm.getNodeForMiriam()) != null) {
                        elem0 = (Element)annotationNode;
                        veRealation = new Vector();
                        veRealation = LibSBMLUtil.getMiriamsFromNode(veRealation, elem0, null);
                        bufMiriam = LibSBMLUtil.getMiriamValueFromMiriams(new StringBuffer(), (SBase)((ClosedCompartmentAlias)alias).getOriginalCompartment(), veRealation, true);
                        annt = XMLNode.convertStringToXMLNode((String)bufMiriam.toString());
                        ((ClosedCompartmentAlias)alias).getOriginalCompartment().setAnnotation(annt);
                        ((ClosedCompartmentAlias)alias).getOriginalCompartment().setAnnotation(bufMiriam.toString());
                    }
                    createdAliases.add(alias);
                } else {
                    alias = new OpenedCompartmentAlias();
                    if (this.gStructure != null && (maxarea = this.gStructure.getMaxDrawSize()) != null) {
                        ((GPointedContainer)alias).setMaxArea(maxarea);
                    }
                    ((OpenedCompartmentAlias)alias).readDOMTree(sbModel, (Element)n, model);
                    strSID = ((OpenedCompartmentAlias)alias).getOriginalCompartment().getId();
                    cm = (CompartmentAnnotation)sbModel.getHashCompartmentAnnotation().get(strSID);
                    if (cm != null && (annotationNode = cm.getNodeForMiriam()) != null) {
                        elem0 = (Element)annotationNode;
                        veRealation = new Vector();
                        veRealation = LibSBMLUtil.getMiriamsFromNode(veRealation, elem0, null);
                        bufMiriam = LibSBMLUtil.getMiriamValueFromMiriams(new StringBuffer(), (SBase)((OpenedCompartmentAlias)alias).getOriginalCompartment(), veRealation, true);
                        annt = XMLNode.convertStringToXMLNode((String)bufMiriam.toString());
                        ((OpenedCompartmentAlias)alias).getOriginalCompartment().setAnnotation(annt);
                        ((OpenedCompartmentAlias)alias).getOriginalCompartment().setAnnotation(bufMiriam.toString());
                    }
                    createdAliases.add(alias);
                }
            }
            ++i;
        }
        return createdAliases;
    }

    private Vector buildComplexSpeciesAliasesByDOMTree(SBModel sbModel, Model model, Vector compartmentAliases, Vector createdTagsWhichLinkingToComplexSpeciesAlias) {
        Vector<ComplexSpeciesAlias> createdAliases = new Vector<ComplexSpeciesAlias>();
        if (this.nodeListOfComplexSpeciesAliases == null) {
            return createdAliases;
        }
        NodeList children = this.nodeListOfComplexSpeciesAliases.getChildNodes();
        int childsize = children.getLength();
        Vector<Element> elementVector = new Vector<Element>();
        int i = 0;
        while (i < childsize) {
            Node n = children.item(i);
            if (n.getNodeType() == 1 && n.getNamespaceURI().equals(URI_CELLDESIGNER) && n.getLocalName().equals("complexSpeciesAlias")) {
                Node annotationNode;
                ComplexSpeciesAlias alias = new ComplexSpeciesAlias();
                alias.readDOMTree(sbModel, (Element)n, model, this.listOfProteins, this.listOfGenes, this.listOfRNAs, this.listOfAntiSenseRNAs, compartmentAliases);
                Vector vTmpTags = alias.getVectTagAliasUsingOnlyWhenBuidTagByReadFromDOMTree();
                String strSID = alias.getOriginalSpecies().getId();
                SpeciesAnnotation speciesAnnotation = (SpeciesAnnotation)sbModel.getHashSpeciesAnnotation().get(strSID);
                if (speciesAnnotation != null && (annotationNode = speciesAnnotation.getNodeForMiriam()) != null) {
                    Element elem0 = (Element)annotationNode;
                    Vector veRealation = new Vector();
                    veRealation = LibSBMLUtil.getMiriamsFromNode(veRealation, elem0, null);
                    StringBuffer bufMiriam = LibSBMLUtil.getMiriamValueFromMiriams(new StringBuffer(), (SBase)alias.getOriginalSpecies(), veRealation, true);
                    XMLNode annt = XMLNode.convertStringToXMLNode((String)bufMiriam.toString());
                    alias.getOriginalSpecies().setAnnotation(annt);
                    alias.getOriginalSpecies().setAnnotation(bufMiriam.toString());
                }
                createdAliases.add(alias);
                if (vTmpTags != null && vTmpTags.size() > 0) {
                    this.gStructure.getTaglayer().getListOfTexts().addAll(vTmpTags);
                    this.gStructure.getTaglayer().getListOfFreeLines().addAll(alias.getVectTagLinkUsingOnlyWhenBuidTagByReadFromDOMTree());
                    alias.clearVectTagAliasUsingOnlyWhenBuidTagByReadFromDOMTree();
                    alias.clearVectTagLinkUsingOnlyWhenBuidTagByReadFromDOMTree();
                }
                elementVector.add((Element)n);
            }
            ++i;
        }
        i = 0;
        while (i < createdAliases.size()) {
            ((ComplexSpeciesAlias)createdAliases.elementAt(i)).buildComplexContainer((Element)elementVector.elementAt(i), createdAliases);
            ++i;
        }
        i = 0;
        while (i < createdAliases.size()) {
            ComplexSpeciesAlias complex = (ComplexSpeciesAlias)createdAliases.elementAt(i);
            if (complex.getCurrentView() != 3) {
                complex.changeComplexView(new Integer(complex.getCurrentView()));
                complex.update();
            }
            ++i;
        }
        return createdAliases;
    }

    private Vector[] buildSpeciesAliasesByDOMTreeConvertTo25(SBModel sbModel, Model model, Vector compartmentAliases) throws Exception {
        Vector<ComplexSpeciesAlias> createdComplex = new Vector<ComplexSpeciesAlias>();
        Vector<SpeciesAlias> createdAliases = new Vector<SpeciesAlias>();
        if (this.nodeListOfAliases == null) {
            return new Vector[]{createdComplex, createdAliases};
        }
        NodeList children = this.nodeListOfAliases.getChildNodes();
        int childsize = children.getLength();
        int i = 0;
        while (i < childsize) {
            Node n = children.item(i);
            if (n.getNodeType() == 1 && n.getNamespaceURI().equals(URI_CELLDESIGNER) && n.getLocalName().equals("speciesAlias")) {
                Node annotationNode;
                ElementSpeciesAlias alias = new ElementSpeciesAlias();
                alias.readDOMTree(sbModel, (Element)n, model, this.listOfProteins, this.listOfGenes, this.listOfRNAs, this.listOfAntiSenseRNAs, compartmentAliases);
                String strSID = alias.getOriginalSpecies().getId();
                SpeciesAnnotation speciesAnnotation = (SpeciesAnnotation)sbModel.getHashSpeciesAnnotation().get(strSID);
                if (speciesAnnotation != null && (annotationNode = speciesAnnotation.getNodeForMiriam()) != null) {
                    Element elem0 = (Element)annotationNode;
                    Vector veRealation = new Vector();
                    veRealation = LibSBMLUtil.getMiriamsFromNode(veRealation, elem0, null);
                    StringBuffer bufMiriam = LibSBMLUtil.getMiriamValueFromMiriams(new StringBuffer(), (SBase)alias.getOriginalSpecies(), veRealation, true);
                    XMLNode annt = XMLNode.convertStringToXMLNode((String)bufMiriam.toString());
                    alias.getOriginalSpecies().setAnnotation(annt);
                    alias.getOriginalSpecies().setAnnotation(bufMiriam.toString());
                }
                createdAliases.add(alias);
            }
            ++i;
        }
        Vector<Species> createdIncludedSpecies = new Vector<Species>();
        ListOfSpecies listOfSpecies = model.getListOfSpecies();
        int i2 = 0;
        while ((long)i2 < listOfSpecies.size()) {
            Species s = (Species)listOfSpecies.get((long)i2);
            SpeciesAnnotation annot = (SpeciesAnnotation)LibSBMLUtil.getAnnotation(sbModel, (SBase)s, null);
            SpeciesProperty oldProperty = annot.getSpeciesProperty();
            if (oldProperty instanceof ComplexSpeciesProperty) {
                Vector<MonoSpeciesProperty> propVec = new Vector<MonoSpeciesProperty>();
                Vector oldPropAlias = ((ComplexSpeciesProperty)oldProperty).getSpeciesAliases();
                int j = 0;
                while (j < oldPropAlias.size()) {
                    SpeciesAlias sa = (SpeciesAlias)oldPropAlias.elementAt(j);
                    MonoSpeciesProperty prop = (MonoSpeciesProperty)((MonoSpeciesShape)sa.getGFramedShape()).getProperty();
                    propVec.addElement(prop);
                    Species si = sa.getOriginalSpecies();
                    SpeciesAnnotation sia = ((ElementSpeciesAlias)sa).getOriginSpeciesAnnotation();
                    sa.setOriginalSpecies(null);
                    sia.removeReference(sa);
                    try {
                        SId.check(String.valueOf(s.getId()) + "_" + sa.getInnerId());
                        si.setId(String.valueOf(s.getId()) + "_" + sa.getInnerId());
                        sbModel.getHashSpeciesAnnotation().put(si.getId(), sia);
                    }
                    catch (SIdFormatException sIdFormatException) {
                        // empty catch block
                    }
                    si.setName(prop.getName());
                    sia.setComplexSpecies(s.getId());
                    createdIncludedSpecies.addElement(si);
                    ++j;
                }
                String newname = this.complexNameBreakLine(s.getName());
                s.setName(newname);
                ComplexProperty newProperty = new ComplexProperty();
                newProperty.setType("COMPLEX");
                newProperty.setName(s.getName());
                newProperty.setMonoProperties(propVec);
                annot.setSpeciesProperty(newProperty);
            }
            ++i2;
        }
        Vector<ElementSpeciesAlias> oldComplex = new Vector<ElementSpeciesAlias>();
        Iterator it = createdAliases.iterator();
        while (it.hasNext()) {
            ElementSpeciesAlias alias = (ElementSpeciesAlias)it.next();
            SpeciesShape shape = (SpeciesShape)((Object)alias.getGFramedShape());
            if (!(shape instanceof ComplexSpeciesShape)) continue;
            oldComplex.addElement(alias);
            it.remove();
        }
        NameSpace nsa = new NameSpace(SpeciesAlias.class);
        nsa.setPrefix("sa");
        nsa.setStartNumber(1);
        nsa.setGetName("getName");
        nsa.setSetName("setName");
        nsa.parse(createdAliases);
        int i3 = 0;
        while (i3 < oldComplex.size()) {
            ElementSpeciesAlias alias = (ElementSpeciesAlias)oldComplex.elementAt(i3);
            ComplexSpeciesShape oldShape = (ComplexSpeciesShape)alias.getGFramedShape();
            ComplexSpeciesProperty oldProperty = (ComplexSpeciesProperty)oldShape.getProperty();
            Species species = alias.getOriginalSpecies();
            SpeciesAnnotation annot = (SpeciesAnnotation)LibSBMLUtil.getAnnotation(sbModel, (SBase)species, null);
            ComplexProperty updatedProperty = (ComplexProperty)annot.getSpeciesProperty();
            GContainer container = alias.getContainer();
            if (container != null) {
                container.removeTarget(alias);
                alias.setContainer(null);
                alias.setInnerPosition(null);
            }
            annot.removeReference(alias);
            alias.setOriginalSpecies(null);
            ComplexSpeciesAlias newAlias = new ComplexSpeciesAlias();
            MonoSpeciesShape newShape = new MonoSpeciesShape();
            ComplexProperty newProperty = (ComplexProperty)updatedProperty.deepClone();
            newShape.setProperty(newProperty);
            newShape.buildPaintingsForType("COMPLEX");
            newShape.changeView(new Integer(0));
            String briefType = SBFactory.getBriefViewType("COMPLEX");
            Dimension d = (Dimension)Preference.defaultSpeciesSize.get(briefType);
            if (d == null) {
                SpeciesSymbol briefSymbol = (SpeciesSymbol)((Object)SBFactory.createSymbol(briefType));
                d = briefSymbol.defaultSize();
            }
            newAlias.setFrameSize(1, d.width, d.height);
            newAlias.setGFramedShape(newShape);
            newAlias.setActive(alias.isActive());
            newAlias.setName(alias.getName());
            Rectangle2D.Double oldbounds = alias.getBounds();
            double margin = (newAlias.isActive() ? 2.0 : 0.0) + 1.25;
            newAlias.setFramePosition(oldbounds.x - margin, oldbounds.y - margin);
            newAlias.setFrameSize(oldbounds.width + 2.0 * margin, oldbounds.height + 2.0 * margin);
            if (container != null) {
                GStructure.setContainerTarget(container, newAlias);
            }
            newAlias.update();
            annot.addReference(newAlias);
            newAlias.setOriginalSpecies(species);
            String parentSId = species.getId();
            Vector included = oldProperty.getSpeciesAliases();
            int j = 0;
            while (j < included.size()) {
                SpeciesAlias sa = (SpeciesAlias)included.elementAt(j);
                String tempID = String.valueOf(parentSId) + "_" + sa.getInnerId();
                Species sp = null;
                int k = 0;
                while (k < createdIncludedSpecies.size()) {
                    Species stemp = (Species)createdIncludedSpecies.elementAt(k);
                    if (stemp.getId().equals(tempID)) {
                        sp = stemp;
                        break;
                    }
                    ++k;
                }
                if (sp == null) {
                    throw new Exception("[" + this + ".buildSpeciesAliasesByDOMTreeConvertTo25()]: " + "Cannot find internal Species. Parent Complex=" + parentSId + " Internal Alias=" + sa.getInnerId());
                }
                ((SpeciesAnnotation)LibSBMLUtil.getAnnotation(sbModel, sp, null)).addReference(sa);
                sa.setOriginalSpecies(sp);
                nsa.assignNameTo(sa);
                sa.setInnerId("");
                GStructure.setContainerTarget(newAlias, sa);
                sa.update();
                createdAliases.addElement(sa);
                ++j;
            }
            createdComplex.addElement(newAlias);
            ++i3;
        }
        List<SBase> speciesList = Arrays.asList(LibSBMLUtil.toArray((ListOf)listOfSpecies));
        NameSpace ns = new NameSpace(Species.class);
        ns.setPrefix("s");
        ns.setStartNumber(1);
        ns.setGetName("getId");
        ns.setSetName("setId");
        ns.parse(speciesList);
        int i4 = 0;
        while (i4 < createdIncludedSpecies.size()) {
            Species species = (Species)createdIncludedSpecies.elementAt(i4);
            SpeciesAnnotation sia = (SpeciesAnnotation)LibSBMLUtil.getAnnotation(sbModel, (SBase)species, null);
            String oldID = species.getId();
            ns.assignNameTo(species);
            listOfSpecies.appendAndOwn((SBase)species);
            sbModel.getHashSpeciesAnnotation().put(species.getId(), sia);
            sbModel.getHashSpeciesAnnotation().remove(oldID);
            ++i4;
        }
        return new Vector[]{createdComplex, createdAliases};
    }

    private String complexNameBreakLine(String original) {
        if (original.matches("Complex\\([^/]+(/[^/]+)+\\)")) {
            String brPlus = original.replaceFirst("\\(", "_br_(");
            String[] splitted = brPlus.split("/");
            StringBuffer strbuff = new StringBuffer();
            int i = 0;
            while (i < splitted.length) {
                strbuff.append(splitted[i]);
                if (i < splitted.length - 1) {
                    if (i % 2 == 0) {
                        strbuff.append("/");
                    } else {
                        strbuff.append("/_br_");
                    }
                }
                ++i;
            }
            return strbuff.toString();
        }
        return original;
    }

    private Vector buildSpeciesAliasesByDOMTreeNew(GStructure gStructure, SBModel sbModel, Model model, Vector compartmentAliases, Vector complexSpeciesAliases) {
        Vector<ElementSpeciesAlias> createdAliases = new Vector<ElementSpeciesAlias>();
        if (this.nodeListOfAliases == null) {
            return createdAliases;
        }
        NodeList children = this.nodeListOfAliases.getChildNodes();
        int childsize = children.getLength();
        int i = 0;
        while (i < childsize) {
            Node n = children.item(i);
            if (n.getNodeType() == 1 && n.getNamespaceURI().equals(URI_CELLDESIGNER) && n.getLocalName().equals("speciesAlias")) {
                Node annotationNode;
                ElementSpeciesAlias alias = new ElementSpeciesAlias();
                alias.readDOMTreeNew(sbModel, (Element)n, model, this.listOfProteins, this.listOfGenes, this.listOfRNAs, this.listOfAntiSenseRNAs, compartmentAliases, complexSpeciesAliases);
                Vector vTags = alias.getVectTagAliasUsingOnlyWhenBuidTagByReadFromDOMTree();
                createdAliases.add(alias);
                if (vTags != null && vTags.size() > 0) {
                    gStructure.getTaglayer().getListOfTexts().addAll(vTags);
                    gStructure.getTaglayer().getListOfFreeLines().addAll(alias.getVectTagLinkUsingOnlyWhenBuidTagByReadFromDOMTree());
                    alias.clearVectTagAliasUsingOnlyWhenBuidTagByReadFromDOMTree();
                    alias.clearVectTagLinkUsingOnlyWhenBuidTagByReadFromDOMTree();
                }
                String strSID = alias.getOriginalSpecies().getId();
                SpeciesAnnotation speciesAnnotation = (SpeciesAnnotation)sbModel.getHashSpeciesAnnotation().get(strSID);
                if (speciesAnnotation != null && (annotationNode = speciesAnnotation.getNodeForMiriam()) != null) {
                    Element elem0 = (Element)annotationNode;
                    Vector veRealation = new Vector();
                    veRealation = LibSBMLUtil.getMiriamsFromNode(veRealation, elem0, null);
                    StringBuffer bufMiriam = LibSBMLUtil.getMiriamValueFromMiriams(new StringBuffer(), (SBase)alias.getOriginalSpecies(), veRealation, true);
                    XMLNode annt = XMLNode.convertStringToXMLNode((String)bufMiriam.toString());
                    alias.getOriginalSpecies().setAnnotation(annt);
                    alias.getOriginalSpecies().setAnnotation(bufMiriam.toString());
                }
            }
            ++i;
        }
        return createdAliases;
    }

    private void reassignReferredSpeciesAliasesToBiomolecules(SBModel sbModel, ListOf listOfProteins, ListOf listOfGenes, ListOf listOfRNAs, ListOf listOfAsRNAs, Vector aliases) throws Exception {
        ListOf[] listOfBiomolecules = new ListOf[]{listOfProteins, listOfGenes, listOfRNAs, listOfAsRNAs};
        int k = 0;
        while (k < listOfBiomolecules.length) {
            int i = 0;
            while ((long)i < listOfBiomolecules[k].size()) {
                Object p = listOfBiomolecules[k].get((long)i);
                Vector reference = null;
                if (k == 0) {
                    p = sbModel.getProtein(((Species)p).getId());
                    reference = ((Biomolecule)p).getReferences();
                } else if (k == 1) {
                    p = sbModel.getGene(((Species)p).getId());
                    reference = ((Biomolecule)p).getReferences();
                } else if (k == 2) {
                    p = sbModel.getRNA(((Species)p).getId());
                    reference = ((Biomolecule)p).getReferences();
                } else if (k == 3) {
                    p = sbModel.getAntiSenseRNA(((Species)p).getId());
                    reference = ((Biomolecule)p).getReferences();
                }
                int j = 0;
                while (j < reference.size()) {
                    ((Biomolecule)p).removeReference((SpeciesAlias)reference.elementAt(j));
                    ++j;
                }
                ++i;
            }
            ++k;
        }
        int i = 0;
        while (i < aliases.size()) {
            block21: {
                Species bm;
                String type;
                SpeciesAlias alias;
                block18: {
                    MonoSpeciesProperty monoProp;
                    block20: {
                        block19: {
                            block17: {
                                alias = (SpeciesAlias)aliases.elementAt(i);
                                MonoSpeciesShape monoShape = (MonoSpeciesShape)alias.getGFramedShape();
                                monoProp = (MonoSpeciesProperty)monoShape.getProperty();
                                type = monoProp.getType();
                                bm = null;
                                if (!type.equals("PROTEIN")) break block17;
                                bm = monoProp.getProtein();
                                break block18;
                            }
                            if (!type.equals("GENE")) break block19;
                            bm = monoProp.getGene();
                            break block18;
                        }
                        if (!type.equals("RNA")) break block20;
                        bm = monoProp.getRNA();
                        break block18;
                    }
                    if (!type.equals("ANTISENSE_RNA")) break block21;
                    bm = monoProp.getAntiSenseRNA();
                }
                if (bm == null) {
                    String message = "[" + this + ".reassignReferredSpeciesAliasesToBiomolecules()]: " + "Attached Biomolecule is null for id=" + alias.getName() + " type=" + type + ".";
                    if (Preference.isDebug) {
                        System.err.println(message);
                    } else {
                        throw new Exception(message);
                    }
                }
                bm.addReference(alias);
            }
            ++i;
        }
    }

    private void attachSpeciesReferenceAnnotationsToSpeciesAlias(SBModel sbModel, Model model, ListOf listOfReactions, Vector aliases) throws Exception {
        Vector duplicates = this.checkUniquenessOfIds(aliases);
        if (duplicates.size() > 0) {
            String message = "[" + this + ".attachSpeciesReferenceAnnotationsToSpeciesAlias] " + "ID(Name)s of elements are not unique. \n" + "Duplicates are: " + duplicates;
            if (Preference.isDebug) {
                System.err.println(message);
            } else {
                throw new Exception(message);
            }
        }
        int i = 0;
        while ((long)i < listOfReactions.size()) {
            SpeciesReference ref;
            SpeciesReference ref2;
            ListIterator it;
            Reaction r = (Reaction)listOfReactions.get((long)i);
            ReactionAnnotation anno = (ReactionAnnotation)LibSBMLUtil.getAnnotation(sbModel, (SBase)r, null);
            ReactionLink baseLink = anno.getBaseLink();
            if (baseLink == null) {
                SpeciesReference ref3;
                Species sp;
                if (r.getNumReactants() == 0L) {
                    sp = model.createSpecies();
                    sp.setId("newID_" + this.newId++);
                    ref3 = r.createReactant();
                    ref3.setSpecies(sp.getId());
                }
                if (r.getNumProducts() == 0L) {
                    sp = model.createSpecies();
                    sp.setId("newID_" + this.newId++);
                    ref3 = r.createProduct();
                    ref3.setSpecies(sp.getId());
                }
                sbModel.getHashReactionAnnotation().remove(r.getId());
                anno = (ReactionAnnotation)LibSBMLUtil.getAnnotation(sbModel, (SBase)r, null);
                baseLink = anno.getBaseLink();
            }
            Vector reactants = (Vector)baseLink.getSources().clone();
            if (baseLink.isBaseLinkGate()) {
                reactants = (Vector)baseLink.getBaseLinkGateSource().clone();
            }
            Vector products = (Vector)baseLink.getDistinations().clone();
            List addReactantLinks = anno.getAddReactantLinks();
            int j = 0;
            while (j < addReactantLinks.size()) {
                ReactionLink link = (ReactionLink)addReactantLinks.get(j);
                GLinkedLine gline = (GLinkedLine)((Object)link.getSymbol());
                SpeciesAlias alias = (SpeciesAlias)gline.getStartTarget();
                reactants.add(alias);
                ++j;
            }
            List addProductLinks = anno.getAddProductLinks();
            int j2 = 0;
            while (j2 < addProductLinks.size()) {
                ReactionLink link = (ReactionLink)addProductLinks.get(j2);
                GLinkedLine gline = (GLinkedLine)((Object)link.getSymbol());
                SpeciesAlias alias = (SpeciesAlias)gline.getEndTarget();
                products.add(alias);
                ++j2;
            }
            Vector modifiers = new Vector();
            List modificationLinks = anno.getModificationLinks();
            int j3 = 0;
            while (j3 < modificationLinks.size()) {
                ReactionLink link = (ReactionLink)modificationLinks.get(j3);
                Vector sources = link.getSources();
                modifiers.addAll(sources);
                ++j3;
            }
            LinkedList<SBase> sbaseReactants = new LinkedList<SBase>(Arrays.asList(LibSBMLUtil.toArray((ListOf)r.getListOfReactants())));
            if (reactants.size() != sbaseReactants.size()) {
                String message = "[ModelAnnotation.attachSpeciesReferenceAnnotationsToSpeciesAlias()] Inconsistency in the number of reactants. In (Reaction annotation, SpeciesReference)=(" + reactants.size() + "," + sbaseReactants.size() + ") in reaction (id=" + r.getId() + ").";
                System.err.println(message);
                reactants.size();
                sbaseReactants.size();
            }
            HashMap<Object, Integer> tempmap = new HashMap<Object, Integer>();
            ListIterator tempit = sbaseReactants.listIterator(sbaseReactants.size());
            int tempitindex = sbaseReactants.size() - 1;
            while (tempit.hasPrevious()) {
                SpeciesReference ref4 = (SpeciesReference)tempit.previous();
                tempmap.put(ref4, new Integer(tempitindex));
                --tempitindex;
            }
            int j4 = reactants.size() - 1;
            while (j4 >= 0) {
                SpeciesAlias alias = (SpeciesAlias)reactants.get(j4);
                it = sbaseReactants.listIterator(sbaseReactants.size());
                boolean found = false;
                while (it.hasPrevious()) {
                    ref2 = (SpeciesReference)it.previous();
                    SpeciesReferenceAnnotation refExt = (SpeciesReferenceAnnotation)LibSBMLUtil.getAnnotation(sbModel, r, (SBase)ref2, "Reactants", (Integer)tempmap.get(ref2), null);
                    String tmpId = refExt.getTmpAliasId();
                    SpeciesAlias aliasRef = (SpeciesAlias)this.getGElement(tmpId, aliases);
                    if (aliasRef == null) {
                        throw new Exception("[" + this + ".attachSpeciesReferenceAnnotationsToSpeciesAlias] " + "Could not find SpeciesAlias id(name)= " + tmpId + " .");
                    }
                    Vector vecContainers = CelldUtil.foundAllParentComplexNodes(alias);
                    if (alias != aliasRef && (!alias.isIncludedInComplex() || !vecContainers.contains(aliasRef))) continue;
                    alias.addObserver(refExt);
                    refExt.setTmpAliasId("");
                    it.remove();
                    found = true;
                    break;
                }
                if (!found) {
                    SpeciesReference sr = r.createReactant();
                    Species original = alias.isIncludedInComplex() ? ((SpeciesAlias)((Object)alias.getContainer())).getOriginalSpecies() : alias.getOriginalSpecies();
                    try {
                        sr.setSpecies(original.getId());
                    }
                    catch (Exception tmpId) {
                        // empty catch block
                    }
                    alias.addObserver((SpeciesReferenceAnnotation)LibSBMLUtil.getAnnotation(sbModel, r, (SBase)sr, "Reactants", (int)r.getListOfReactants().size(), null));
                }
                --j4;
            }
            if (sbaseReactants.size() > 0) {
                ListOfSpeciesReferences listOfReactants = r.getListOfReactants();
                ListIterator it2 = sbaseReactants.listIterator(sbaseReactants.size());
                HashMap hashSpeciesReferenceReactantsAnnotation = sbModel.getHashSpeciesReferenceReactantsAnnotation();
                int originCount = (int)r.getNumReactants();
                while (it2.hasPrevious()) {
                    ref2 = (SpeciesReference)it2.previous();
                    int index = (Integer)tempmap.get(ref2);
                    int count = 0;
                    int k = 0;
                    while ((long)count < listOfReactants.size()) {
                        if (k == index) {
                            ++k;
                        } else if (k > index) {
                            SpeciesReferenceAnnotation an = (SpeciesReferenceAnnotation)hashSpeciesReferenceReactantsAnnotation.get(LibSBMLUtil.getSpeciesReferenceReactantKey(r.getId(), k));
                            if (an == null) {
                                throw new Exception(ModelAnnotation.getSpeciesReferenceBuildErrMsg(r.getId(), "ReactantSpeciesReference", k));
                            }
                            hashSpeciesReferenceReactantsAnnotation.put(LibSBMLUtil.getSpeciesReferenceReactantKey(r.getId(), k - 1), an);
                            ++k;
                        } else {
                            ++k;
                        }
                        ++count;
                    }
                    listOfReactants.remove((long)index);
                    hashSpeciesReferenceReactantsAnnotation.remove(LibSBMLUtil.getSpeciesReferenceReactantKey(r.getId(), listOfReactants.size() - 1L));
                }
                int startIndex = 0;
                int k = 0;
                while (k < originCount) {
                    Object obj = hashSpeciesReferenceReactantsAnnotation.get(LibSBMLUtil.getSpeciesReferenceReactantKey(r.getId(), k));
                    if (obj == null) {
                        if (startIndex < k) {
                            startIndex = k;
                        }
                        int j5 = startIndex;
                        while (j5 < originCount) {
                            Object obj2 = hashSpeciesReferenceReactantsAnnotation.get(LibSBMLUtil.getSpeciesReferenceReactantKey(r.getId(), j5));
                            if (obj2 != null) {
                                hashSpeciesReferenceReactantsAnnotation.put(LibSBMLUtil.getSpeciesReferenceReactantKey(r.getId(), k), obj2);
                                hashSpeciesReferenceReactantsAnnotation.remove(LibSBMLUtil.getSpeciesReferenceReactantKey(r.getId(), j5));
                                startIndex = j5;
                                break;
                            }
                            ++j5;
                        }
                    }
                    ++k;
                }
            }
            LinkedList<SBase> sbaseProducts = new LinkedList<SBase>(Arrays.asList(LibSBMLUtil.toArray((ListOf)r.getListOfProducts())));
            if (products.size() != sbaseProducts.size()) {
                String message = "[ModelAnnotation.attachSpeciesReferenceAnnotationsToSpeciesAlias()] Inconsistency in the number of products. In (Reaction annotation, SpeciesReference)=(" + products.size() + "," + sbaseProducts.size() + ") in reaction (id=" + r.getId() + ").";
                System.err.println(message);
                products.size();
                sbaseProducts.size();
            }
            tempmap = new HashMap();
            tempit = sbaseProducts.listIterator(sbaseProducts.size());
            tempitindex = sbaseProducts.size() - 1;
            while (tempit.hasPrevious()) {
                SpeciesReference ref5 = (SpeciesReference)tempit.previous();
                tempmap.put(ref5, new Integer(tempitindex));
                --tempitindex;
            }
            int j6 = products.size() - 1;
            while (j6 >= 0) {
                SpeciesAlias alias = (SpeciesAlias)products.get(j6);
                ListIterator it3 = sbaseProducts.listIterator(sbaseProducts.size());
                boolean found = false;
                while (it3.hasPrevious()) {
                    ref = (SpeciesReference)it3.previous();
                    SpeciesReferenceAnnotation refExt = (SpeciesReferenceAnnotation)LibSBMLUtil.getAnnotation(sbModel, r, (SBase)ref, "Products", (Integer)tempmap.get(ref), null);
                    String tmpId = refExt.getTmpAliasId();
                    SpeciesAlias aliasRef = (SpeciesAlias)this.getGElement(tmpId, aliases);
                    if (aliasRef == null) {
                        throw new Exception("[" + this + ".attachSpeciesReferenceAnnotationsToSpeciesAlias] " + "Could not find SpeciesAlias id(name)= " + tmpId + " .");
                    }
                    Vector vecContainers = CelldUtil.foundAllParentComplexNodes(alias);
                    if (alias != aliasRef && (!alias.isIncludedInComplex() || !vecContainers.contains(aliasRef))) continue;
                    alias.addObserver(refExt);
                    refExt.setTmpAliasId("");
                    it3.remove();
                    found = true;
                    break;
                }
                if (!found) {
                    SpeciesReference sr = r.createProduct();
                    Species original = alias.isIncludedInComplex() ? ((SpeciesAlias)((Object)alias.getContainer())).getOriginalSpecies() : alias.getOriginalSpecies();
                    try {
                        sr.setSpecies(original.getId());
                    }
                    catch (Exception tmpId) {
                        // empty catch block
                    }
                    alias.addObserver((SpeciesReferenceAnnotation)LibSBMLUtil.getAnnotation(sbModel, r, (SBase)sr, "Products", (int)r.getListOfProducts().size(), null));
                }
                --j6;
            }
            if (sbaseProducts.size() > 0) {
                ListOfSpeciesReferences listOfProducts = r.getListOfProducts();
                it = sbaseProducts.listIterator(sbaseProducts.size());
                HashMap hashSpeciesReferenceProductsAnnotation = sbModel.getHashSpeciesReferenceProductsAnnotation();
                int originCount = (int)r.getNumProducts();
                while (it.hasPrevious()) {
                    ref = (SpeciesReference)it.previous();
                    int index = (Integer)tempmap.get(ref);
                    int count = 0;
                    int k = 0;
                    while ((long)count < listOfProducts.size()) {
                        if (k == index) {
                            ++k;
                        } else if (k > index) {
                            SpeciesReferenceAnnotation an = (SpeciesReferenceAnnotation)hashSpeciesReferenceProductsAnnotation.get(LibSBMLUtil.getSpeciesReferenceProductKey(r.getId(), k));
                            if (an == null) {
                                throw new Exception(ModelAnnotation.getSpeciesReferenceBuildErrMsg(r.getId(), "ProductSpeciesReference", k));
                            }
                            hashSpeciesReferenceProductsAnnotation.put(LibSBMLUtil.getSpeciesReferenceProductKey(r.getId(), k - 1), an);
                            ++k;
                        } else {
                            ++k;
                        }
                        ++count;
                    }
                    listOfProducts.remove((long)index);
                    hashSpeciesReferenceProductsAnnotation.remove(LibSBMLUtil.getSpeciesReferenceProductKey(r.getId(), listOfProducts.size() - 1L));
                }
                int startIndex = 0;
                int k = 0;
                while (k < originCount) {
                    Object obj = hashSpeciesReferenceProductsAnnotation.get(LibSBMLUtil.getSpeciesReferenceProductKey(r.getId(), k));
                    if (obj == null) {
                        if (startIndex < k) {
                            startIndex = k;
                        }
                        int j7 = startIndex;
                        while (j7 < originCount) {
                            Object obj2 = hashSpeciesReferenceProductsAnnotation.get(LibSBMLUtil.getSpeciesReferenceProductKey(r.getId(), j7));
                            if (obj2 != null) {
                                hashSpeciesReferenceProductsAnnotation.put(LibSBMLUtil.getSpeciesReferenceProductKey(r.getId(), k), obj2);
                                hashSpeciesReferenceProductsAnnotation.remove(LibSBMLUtil.getSpeciesReferenceProductKey(r.getId(), j7));
                                startIndex = j7;
                                break;
                            }
                            ++j7;
                        }
                    }
                    ++k;
                }
            }
            LinkedList<SBase> sbaseModifiers = new LinkedList<SBase>(Arrays.asList(LibSBMLUtil.toArray((ListOf)r.getListOfModifiers())));
            if (modifiers.size() != sbaseModifiers.size()) {
                String message = "[ModelAnnotation.attachSpeciesReferenceAnnotationsToSpeciesAlias()] Inconsistency in the number of modifiers. In (Reaction annotation, ModifierSpeciesReference)=(" + modifiers.size() + "," + sbaseModifiers.size() + ") in reaction (id=" + r.getId() + ").";
                System.err.println(message);
                modifiers.size();
                sbaseModifiers.size();
            }
            tempmap = new HashMap();
            tempit = sbaseModifiers.listIterator(sbaseModifiers.size());
            tempitindex = sbaseModifiers.size() - 1;
            while (tempit.hasPrevious()) {
                ModifierSpeciesReference ref6 = (ModifierSpeciesReference)tempit.previous();
                tempmap.put(ref6, new Integer(tempitindex));
                --tempitindex;
            }
            SpeciesReferenceAnnotation refExt = null;
            int j8 = modifiers.size() - 1;
            while (j8 >= 0) {
                ref2 = null;
                SpeciesAlias alias = (SpeciesAlias)modifiers.get(j8);
                ListIterator it4 = sbaseModifiers.listIterator(sbaseModifiers.size());
                boolean found = false;
                while (it4.hasPrevious()) {
                    ref2 = (ModifierSpeciesReference)it4.previous();
                    refExt = (SpeciesReferenceAnnotation)LibSBMLUtil.getAnnotation(sbModel, r, (SBase)ref2, null, (Integer)tempmap.get(ref2), null);
                    String tmpId = refExt.getTmpAliasId();
                    SpeciesAlias aliasRef = (SpeciesAlias)this.getGElement(tmpId, aliases);
                    if (aliasRef == null) {
                        throw new Exception("[" + this + ".attachSpeciesReferenceAnnotationsToSpeciesAlias] " + "Could not find SpeciesAlias id(name)= " + tmpId + " .");
                    }
                    Vector vecContainers = CelldUtil.foundAllParentComplexNodes(alias);
                    if (alias != aliasRef && (!alias.isIncludedInComplex() || !vecContainers.contains(aliasRef))) continue;
                    alias.addObserver(refExt);
                    refExt.setTmpAliasId("");
                    it4.remove();
                    found = true;
                    break;
                }
                if (!found) {
                    SpeciesReference msr = ref2;
                    Species original = alias.isIncludedInComplex() ? ((SpeciesAlias)((Object)alias.getContainer())).getOriginalSpecies() : alias.getOriginalSpecies();
                    try {
                        msr.setSpecies(original.getId());
                    }
                    catch (Exception vecContainers) {
                        // empty catch block
                    }
                    alias.addObserver(refExt);
                }
                --j8;
            }
            if (sbaseModifiers.size() > 0) {
                ListOfSpeciesReferences listOfModifiers = r.getListOfModifiers();
                ListIterator it5 = sbaseModifiers.listIterator(sbaseModifiers.size());
                HashMap hashModifierSpeciesReferenceAnnotation = sbModel.getHashModifierSpeciesReferenceAnnotation();
                int originCount = (int)r.getNumModifiers();
                while (it5.hasPrevious()) {
                    ModifierSpeciesReference ref7 = (ModifierSpeciesReference)it5.previous();
                    int index = (Integer)tempmap.get(ref7);
                    int count = 0;
                    int k = 0;
                    while ((long)count < listOfModifiers.size()) {
                        if (k == index) {
                            ++k;
                        } else if (k > index) {
                            SpeciesReferenceAnnotation an = (SpeciesReferenceAnnotation)hashModifierSpeciesReferenceAnnotation.get(LibSBMLUtil.getSpeciesReferenceModifierKey(r.getId(), k));
                            if (an == null) {
                                throw new Exception(ModelAnnotation.getSpeciesReferenceBuildErrMsg(r.getId(), "ModifierSpeciesReference", k));
                            }
                            hashModifierSpeciesReferenceAnnotation.put(LibSBMLUtil.getSpeciesReferenceModifierKey(r.getId(), k - 1), an);
                            ++k;
                        } else {
                            ++k;
                        }
                        ++count;
                    }
                    listOfModifiers.remove((long)index);
                    hashModifierSpeciesReferenceAnnotation.remove(LibSBMLUtil.getSpeciesReferenceModifierKey(r.getId(), listOfModifiers.size() - 1L));
                }
                int startIndex = 0;
                int k = 0;
                while (k < originCount) {
                    Object obj = hashModifierSpeciesReferenceAnnotation.get(LibSBMLUtil.getSpeciesReferenceModifierKey(r.getId(), k));
                    if (obj == null) {
                        if (startIndex < k) {
                            startIndex = k;
                        }
                        int j9 = startIndex;
                        while (j9 < originCount) {
                            Object obj2 = hashModifierSpeciesReferenceAnnotation.get(LibSBMLUtil.getSpeciesReferenceModifierKey(r.getId(), j9));
                            if (obj2 != null) {
                                hashModifierSpeciesReferenceAnnotation.put(LibSBMLUtil.getSpeciesReferenceModifierKey(r.getId(), k), obj2);
                                hashModifierSpeciesReferenceAnnotation.remove(LibSBMLUtil.getSpeciesReferenceModifierKey(r.getId(), j9));
                                startIndex = j9;
                                break;
                            }
                            ++j9;
                        }
                    }
                    ++k;
                }
            }
            tempmap.clear();
            ++i;
        }
        i = 0;
        while (i < aliases.size()) {
            SpeciesAlias alias = (SpeciesAlias)aliases.elementAt(i);
            alias.notifyObserver();
            ++i;
        }
    }

    private Vector checkUniquenessOfIds(Vector elements) {
        HashSet<String> ids = new HashSet<String>();
        Vector<String> duplicates = new Vector<String>();
        int i = 0;
        while (i < elements.size()) {
            GElement element = (GElement)elements.elementAt(i);
            String id = element.getName();
            if (ids.contains(id)) {
                duplicates.addElement(id);
            }
            ids.add(id);
            ++i;
        }
        return duplicates;
    }

    public JDialog getBlockDiagramDialogByProteinId(String proteinId) {
        if (this.blockDialogMapByProteinId != null) {
            return (JDialog)this.blockDialogMapByProteinId.get(proteinId);
        }
        return null;
    }

    public void setBlockDiagramDialogByProteinId(String proteinId, JDialog dialog) {
        if (this.blockDialogMapByProteinId == null) {
            this.blockDialogMapByProteinId = new TreeMap();
        }
        this.blockDialogMapByProteinId.put(proteinId, dialog);
    }

    public void removeBlockDiagramDialog(String proteinId) {
        if (this.blockDialogMapByProteinId != null) {
            this.blockDialogMapByProteinId.remove(proteinId);
        }
    }

    public BlockDiagramAnnotation getBlockDiagramAnnotation() {
        if (this.blockDiagramAnnotation == null) {
            this.blockDiagramAnnotation = BlockDiagramAnnotationBuilder.build(null);
        }
        return this.blockDiagramAnnotation;
    }

    @Override
    public void setParentSBase(SBase sbase) {
        this.parentModel = (Model)sbase;
    }

    public ModelDescription getModelDescription() {
        return this.modeldescription;
    }

    public void setModelDescription(ModelDescription description) {
        this.modeldescription = description == null ? new ModelDescription() : description;
    }

    public void reInitModelDescription() {
        this.setModelDescription(null);
    }

    public void updateModelDescriptionToCurrDataTimeInfo(boolean needCreated, boolean needModified) {
        String strNow = ModelDescription.getCurrentTimeChangeToW3CDTF(null);
        if (needCreated) {
            this.modeldescription.setFileCreatedDate(strNow);
        }
        if (needModified) {
            this.modeldescription.setFileModifiedDate(strNow);
        }
    }

    private Vector<String> getVectPKList() {
        if (this.vectPKList == null) {
            this.vectPKList = new Vector();
        }
        return this.vectPKList;
    }

    public static final String makeModelDescriptionAnnotation(Model mdl, ModelDescription modelDescription, Vector vecMiriamDatas) {
        String strtAnnotationTmp = "";
        if (mdl == null) {
            return strtAnnotationTmp;
        }
        if (ModelDescription.isThisDataCanSeemAsNull(modelDescription) && (vecMiriamDatas == null || vecMiriamDatas.size() <= 0)) {
            return strtAnnotationTmp;
        }
        String strMiriamInfo = LibSBMLUtil.getMiriamValueFromMiriams(new StringBuffer(), (SBase)mdl, vecMiriamDatas, false).toString();
        String metaid = mdl.getMetaId();
        strtAnnotationTmp = String.valueOf(strtAnnotationTmp) + "\n\t<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\" >";
        strtAnnotationTmp = String.valueOf(strtAnnotationTmp) + "\n\t\t<rdf:Description rdf:about=\"#" + metaid + "\">";
        if (!ModelDescription.isThisDataCanSeemAsNull(modelDescription)) {
            strtAnnotationTmp = String.valueOf(strtAnnotationTmp) + ModelAnnotation.makeModelCreatorDescription(modelDescription);
            strtAnnotationTmp = String.valueOf(strtAnnotationTmp) + ModelAnnotation.makeModelCreatedModifiedDescription(modelDescription);
        }
        if (vecMiriamDatas != null && vecMiriamDatas.size() > 0) {
            strtAnnotationTmp = String.valueOf(strtAnnotationTmp) + strMiriamInfo;
        }
        strtAnnotationTmp = String.valueOf(strtAnnotationTmp) + "\n\t\t</rdf:Description>";
        strtAnnotationTmp = String.valueOf(strtAnnotationTmp) + "\n\t</rdf:RDF>";
        return strtAnnotationTmp;
    }

    public static final String makeModelCreatorDescription(ModelDescription modelDescription) {
        String strtAnnotationTmp = "";
        if (ModelDescription.isCreatorDescriptionOfThisDataCanSeemAsNull(modelDescription)) {
            return strtAnnotationTmp;
        }
        strtAnnotationTmp = String.valueOf(strtAnnotationTmp) + "\n\t\t\t<dc:creator rdf:parseType=\"Resource\">";
        strtAnnotationTmp = String.valueOf(strtAnnotationTmp) + "\n\t\t\t\t<rdf:Bag>";
        strtAnnotationTmp = String.valueOf(strtAnnotationTmp) + "\n\t\t\t\t\t<rdf:li rdf:parseType=\"Resource\">";
        strtAnnotationTmp = String.valueOf(strtAnnotationTmp) + "\n\t\t\t\t\t\t<vCard:N rdf:parseType=\"Resource\">";
        strtAnnotationTmp = String.valueOf(strtAnnotationTmp) + "\n\t\t\t\t\t\t\t<vCard:Family>" + modelDescription.getCreatorFamilyName() + "</vCard:Family>";
        strtAnnotationTmp = String.valueOf(strtAnnotationTmp) + "\n\t\t\t\t\t\t\t<vCard:Given>" + modelDescription.getCreatorGivenName() + "</vCard:Given>";
        strtAnnotationTmp = String.valueOf(strtAnnotationTmp) + "\n\t\t\t\t\t\t</vCard:N>";
        strtAnnotationTmp = String.valueOf(strtAnnotationTmp) + "\n\t\t\t\t\t\t<vCard:EMAIL>" + modelDescription.getCreatorEMAIL() + "</vCard:EMAIL>";
        strtAnnotationTmp = String.valueOf(strtAnnotationTmp) + "\n\t\t\t\t\t\t<vCard:ORG>";
        strtAnnotationTmp = String.valueOf(strtAnnotationTmp) + "\n\t\t\t\t\t\t\t<vCard:Orgname>" + modelDescription.getCreatorOrganization() + "</vCard:Orgname>";
        strtAnnotationTmp = String.valueOf(strtAnnotationTmp) + "\n\t\t\t\t\t\t</vCard:ORG>";
        strtAnnotationTmp = String.valueOf(strtAnnotationTmp) + "\n\t\t\t\t\t</rdf:li>";
        strtAnnotationTmp = String.valueOf(strtAnnotationTmp) + "\n\t\t\t\t</rdf:Bag>";
        strtAnnotationTmp = String.valueOf(strtAnnotationTmp) + "\n\t\t\t</dc:creator>";
        return strtAnnotationTmp;
    }

    public static final String makeModelCreatedModifiedDescription(ModelDescription modelDescription) {
        String strtAnnotationTmp = "";
        if (ModelDescription.isCreatedModifiedDescriptionOfThisDataCanSeemAsNull(modelDescription)) {
            return strtAnnotationTmp;
        }
        strtAnnotationTmp = String.valueOf(strtAnnotationTmp) + "\n\t\t\t<dcterms:created rdf:parseType=\"Resource\">";
        strtAnnotationTmp = String.valueOf(strtAnnotationTmp) + "\n\t\t\t\t<dcterms:W3CDTF>" + modelDescription.getFileCreatedDate() + "</dcterms:W3CDTF>";
        strtAnnotationTmp = String.valueOf(strtAnnotationTmp) + "\n\t\t\t</dcterms:created>";
        strtAnnotationTmp = String.valueOf(strtAnnotationTmp) + "\n\t\t\t<dcterms:modified rdf:parseType=\"Resource\">";
        strtAnnotationTmp = String.valueOf(strtAnnotationTmp) + "\n\t\t\t\t<dcterms:W3CDTF>" + modelDescription.getFileModifiedDate() + "</dcterms:W3CDTF>";
        strtAnnotationTmp = String.valueOf(strtAnnotationTmp) + "\n\t\t\t</dcterms:modified>";
        return strtAnnotationTmp;
    }

    public static final XMLNode getChildNodeUsingTagName(XMLNode node, String tagname) {
        return ModelAnnotation.getChildNodeUsingTagName(node, tagname, 0);
    }

    public static final XMLNode getChildNodeUsingTagName(XMLNode node, String tagname, int cnt) {
        if (cnt >= iMaxNest) {
            return null;
        }
        if (node == null) {
            return null;
        }
        if (tagname == null || tagname.trim().equals("")) {
            return null;
        }
        if (ModelAnnotation.checkXmlTagOfModelAnnotation(node.getName()) != -1 && tagname.toLowerCase().equals(node.getName().toLowerCase())) {
            return node;
        }
        int icnt = cnt++;
        int i = 0;
        while ((long)i < node.getNumChildren()) {
            XMLNode rtnNodeTmp = ModelAnnotation.getChildNodeUsingTagName(node.getChild((long)i), tagname, icnt);
            if (rtnNodeTmp != null) {
                return rtnNodeTmp;
            }
            ++i;
        }
        return null;
    }

    public static final int checkXmlTagOfModelAnnotation(String tag) {
        if (tag == null) {
            return -1;
        }
        int i = 0;
        while (i < arrXmlTag_ModelDescriptionAnnotation.length) {
            if (tag.toLowerCase().equals(arrXmlTag_ModelDescriptionAnnotation[i][0].toLowerCase())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final boolean resetModelDescriptionAnnotation(Model mdl, StringBuffer buf, StringBuffer bufAnnotationOld, ModelDescription mdscrpt, Vector vecMiriamDatas) {
        block38: {
            block37: {
                block36: {
                    if (mdl != null) break block36;
                    return false;
                }
                if (buf != null) break block37;
                return false;
            }
            if (mdscrpt != null) break block38;
            return false;
        }
        try {
            int iDescriptionAnnotationStart = -1;
            int iDescriptionAnnotationEnd = -1;
            String strRdfAnnotationOld = null;
            String strXmlNodeNew = "";
            if (bufAnnotationOld == null || bufAnnotationOld.toString().trim().equals("")) {
                if (!ModelDescription.isThisDataCanSeemAsNull(mdscrpt) || vecMiriamDatas != null && vecMiriamDatas.size() > 0) {
                    buf.append(ModelAnnotation.makeModelDescriptionAnnotation(mdl, mdscrpt, vecMiriamDatas));
                }
            } else {
                String strBufAnnotationOld = new String(bufAnnotationOld.toString());
                XMLNode xmlnodeRootOld = XMLNode.convertStringToXMLNode((String)strBufAnnotationOld);
                if (xmlnodeRootOld == null) {
                    iDescriptionAnnotationStart = strBufAnnotationOld.indexOf("<rdf:RDF");
                    iDescriptionAnnotationEnd = strBufAnnotationOld.indexOf("</rdf:RDF>");
                    if (iDescriptionAnnotationStart != -1 && iDescriptionAnnotationEnd != -1) {
                        strRdfAnnotationOld = strBufAnnotationOld.substring(iDescriptionAnnotationStart, iDescriptionAnnotationEnd + "</rdf:RDF>".length());
                        xmlnodeRootOld = XMLNode.convertStringToXMLNode((String)strRdfAnnotationOld);
                    }
                }
                XMLNode xmlnodeChildDescription = ModelAnnotation.getChildNodeUsingTagName(xmlnodeRootOld, "Description");
                XMLNode nodeOldChildrenBak = new XMLNode();
                if (xmlnodeChildDescription != null) {
                    XMLNode xmlnodeChildCreator = ModelAnnotation.getChildNodeUsingTagName(xmlnodeChildDescription, "creator");
                    XMLNode xmlnodeChildCreated = ModelAnnotation.getChildNodeUsingTagName(xmlnodeChildDescription, strXmlTagCreatedDate);
                    XMLNode xmlnodeChildModified = ModelAnnotation.getChildNodeUsingTagName(xmlnodeChildDescription, strXmlTagModifiedDate);
                    String strXmlNodeCreatorTmp = "";
                    String strXmlNodeCreatedTmp = "";
                    String strXmlNodeModifiedTmp = "";
                    if (xmlnodeChildCreator != null) {
                        strXmlNodeCreatorTmp = XMLNode.convertXMLNodeToString((XMLNode)xmlnodeChildCreator);
                    }
                    if (xmlnodeChildCreated != null) {
                        strXmlNodeCreatedTmp = XMLNode.convertXMLNodeToString((XMLNode)xmlnodeChildCreated);
                    }
                    if (xmlnodeChildModified != null) {
                        strXmlNodeModifiedTmp = XMLNode.convertXMLNodeToString((XMLNode)xmlnodeChildModified);
                    }
                    long i = xmlnodeChildDescription.getNumChildren() - 1L;
                    while (i >= 0L) {
                        XMLNode child;
                        String strTagName;
                        String strXmlNodeCurrTmp = XMLNode.convertXMLNodeToString((XMLNode)xmlnodeChildDescription.getChild(i));
                        if (!(strXmlNodeCreatorTmp.equals(strXmlNodeCurrTmp) || strXmlNodeCreatedTmp.equals(strXmlNodeCurrTmp) || strXmlNodeModifiedTmp.equals(strXmlNodeCurrTmp) || MIRIAM.vectEnumerationRelationOfMIRIAM.contains(strTagName = String.valueOf((child = xmlnodeChildDescription.getChild(i)).getPrefix()) + ":" + child.getName()))) {
                            nodeOldChildrenBak.addChild(xmlnodeChildDescription.getChild(i));
                        }
                        --i;
                    }
                }
                if (ModelDescription.isThisDataCanSeemAsNull(mdscrpt) && (vecMiriamDatas == null || vecMiriamDatas.size() <= 0)) {
                    if (xmlnodeChildDescription == null) {
                        buf.append(bufAnnotationOld.toString());
                    } else if (nodeOldChildrenBak.getNumChildren() > 0L) {
                        xmlnodeChildDescription.removeChildren();
                        int i = 0;
                        while ((long)i < nodeOldChildrenBak.getNumChildren()) {
                            try {
                                xmlnodeChildDescription.addChild(nodeOldChildrenBak.getChild((long)i));
                            }
                            catch (Exception xmlnodeChildCreated) {
                                // empty catch block
                            }
                            ++i;
                        }
                        strXmlNodeNew = XMLNode.convertXMLNodeToString((XMLNode)xmlnodeRootOld);
                        if (iDescriptionAnnotationStart != -1 && iDescriptionAnnotationEnd != -1) {
                            strXmlNodeNew = strBufAnnotationOld.replaceAll(strRdfAnnotationOld, strXmlNodeNew);
                        }
                        buf.append(strXmlNodeNew);
                    }
                } else {
                    XMLNode xmlnodeRootNew = XMLNode.convertStringToXMLNode((String)ModelAnnotation.makeModelDescriptionAnnotation(mdl, mdscrpt, vecMiriamDatas));
                    if (xmlnodeChildDescription == null) {
                        xmlnodeRootOld.addChild(ModelAnnotation.getChildNodeUsingTagName(xmlnodeRootNew, "Description"));
                    } else {
                        xmlnodeChildDescription.removeChildren();
                        XMLNode nodeTmp = ModelAnnotation.getChildNodeUsingTagName(xmlnodeRootNew, "creator");
                        if (nodeTmp != null) {
                            xmlnodeChildDescription.addChild(nodeTmp);
                        }
                        if ((nodeTmp = ModelAnnotation.getChildNodeUsingTagName(xmlnodeRootNew, strXmlTagCreatedDate)) != null) {
                            xmlnodeChildDescription.addChild(nodeTmp);
                        }
                        if ((nodeTmp = ModelAnnotation.getChildNodeUsingTagName(xmlnodeRootNew, strXmlTagModifiedDate)) != null) {
                            xmlnodeChildDescription.addChild(nodeTmp);
                        }
                        XMLNode newxmlnodeChildDescription = ModelAnnotation.getChildNodeUsingTagName(xmlnodeRootNew, "Description");
                        long i = 0L;
                        while (i < newxmlnodeChildDescription.getNumChildren()) {
                            XMLNode childnode = newxmlnodeChildDescription.getChild(i);
                            String strTagname1 = String.valueOf(childnode.getPrefix()) + ":" + childnode.getName();
                            if (MIRIAM.vectEnumerationRelationOfMIRIAM.contains(strTagname1)) {
                                xmlnodeChildDescription.addChild(childnode);
                            }
                            ++i;
                        }
                        int i2 = 0;
                        while ((long)i2 < nodeOldChildrenBak.getNumChildren()) {
                            try {
                                xmlnodeChildDescription.addChild(nodeOldChildrenBak.getChild((long)i2));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            ++i2;
                        }
                    }
                    strXmlNodeNew = XMLNode.convertXMLNodeToString((XMLNode)xmlnodeRootOld);
                    if (iDescriptionAnnotationStart != -1 && iDescriptionAnnotationEnd != -1) {
                        strXmlNodeNew = strBufAnnotationOld.replaceAll(strRdfAnnotationOld, strXmlNodeNew);
                    }
                    buf.append(strXmlNodeNew);
                }
            }
            return true;
        }
        catch (Exception myErr) {
            return false;
        }
    }

    private static final String getSpeciesReferenceBuildErrMsg(String reactionId, String type, long index) {
        return "Invalid [" + type + "] (index:" + index + ") information of Reaction(id:" + reactionId + ") .";
    }

    public static final String getAnnotationOfSBase(SBase sbase) {
        if (sbase == null) {
            return "";
        }
        if (sbase instanceof Model) {
            ModelAnnotation ma = (ModelAnnotation)LibSBMLUtil.getAnnotation(sbase, null);
            Vector vecData = LibSBMLUtil.getMiriamDatasFromAnnotationOfSBase((SBase)((Model)sbase));
            StringBuffer strBuf = new StringBuffer();
            ModelAnnotation.resetModelDescriptionAnnotation((Model)sbase, strBuf, ma.bufAnnotation, ma.modeldescription, vecData);
            if (strBuf == null) {
                strBuf = new StringBuffer();
            }
            return strBuf.toString();
        }
        if (sbase instanceof Compartment) {
            CompartmentAnnotation ca = (CompartmentAnnotation)LibSBMLUtil.getAnnotation(sbase, null);
            StringBuffer strBuf = new StringBuffer();
            if (ca != null) {
                strBuf.append(ca.getOtherAnnotation());
            }
            Vector vecData = LibSBMLUtil.getMiriamDatasFromAnnotationOfSBase((SBase)((Compartment)sbase));
            strBuf.append(LibSBMLUtil.getMiriamValueFromMiriams(new StringBuffer(), (SBase)((Compartment)sbase), vecData, true));
            if (strBuf == null) {
                strBuf = new StringBuffer();
            }
            return strBuf.toString();
        }
        if (sbase instanceof Species) {
            SpeciesAnnotation ca = (SpeciesAnnotation)LibSBMLUtil.getAnnotation(sbase, null);
            StringBuffer strBuf = new StringBuffer();
            if (ca != null) {
                strBuf.append(ca.getOtherAnnotation());
            }
            Vector vecData = LibSBMLUtil.getMiriamDatasFromAnnotationOfSBase((SBase)((Species)sbase));
            strBuf.append(LibSBMLUtil.getMiriamValueFromMiriams(new StringBuffer(), (SBase)((Species)sbase), vecData, true));
            if (strBuf == null) {
                strBuf = new StringBuffer();
            }
            return strBuf.toString();
        }
        if (sbase instanceof Reaction) {
            ReactionAnnotation ca = (ReactionAnnotation)LibSBMLUtil.getAnnotation(sbase, null);
            StringBuffer strBuf = new StringBuffer();
            if (ca != null) {
                strBuf.append(ca.getOtherAnnotation());
            }
            Vector vecData = LibSBMLUtil.getMiriamDatasFromAnnotationOfSBase((SBase)((Reaction)sbase));
            strBuf.append(LibSBMLUtil.getMiriamValueFromMiriams(new StringBuffer(), (SBase)((Reaction)sbase), vecData, true));
            if (strBuf == null) {
                strBuf = new StringBuffer();
            }
            return strBuf.toString();
        }
        String strStrAnno = sbase.getAnnotationString();
        Any ca = LibSBMLUtil.getAnnotation(sbase, null);
        String celldExt = LibSBMLUtil.removeCelldExtAnno(strStrAnno);
        return celldExt;
    }

    public static final void setAnnotationOfSBase(PluginSBase psbase, SBase sbase, PluginKineticLaw parent) {
        if (psbase == null || sbase == null) {
            return;
        }
        if (sbase instanceof Model) {
            String strAnnotation = psbase.getAnnotationString();
            ModelAnnotation ma = (ModelAnnotation)LibSBMLUtil.getAnnotation(sbase, null);
            if (ma == null) {
                return;
            }
            if (strAnnotation == null || "".equals(strAnnotation.trim())) {
                ma.setModelDescription(new ModelDescription());
                ma.bufAnnotation = new StringBuffer();
                sbase.setAnnotation("");
                return;
            }
            ModelDescription des = ModelAnnotation.getDescriptionFromXMLNode(strAnnotation);
            ma.setModelDescription(des);
            Vector vecMiriam = MiriamMainPanel.getMiriamsFromXMLNode(new Vector(), psbase.getAnnotation(), null);
            if (vecMiriam == null) {
                vecMiriam = new Vector();
            }
            StringBuffer bufMiriam = LibSBMLUtil.getMiriamValueFromMiriams(new StringBuffer(), sbase, vecMiriam, true);
            sbase.setAnnotation(bufMiriam.toString());
            ma.bufAnnotation = new StringBuffer(ModelAnnotation.getOtherAnnotation(strAnnotation));
        } else if (sbase instanceof Compartment) {
            String strAnnotation = psbase.getAnnotationString();
            CompartmentAnnotation ma = (CompartmentAnnotation)LibSBMLUtil.getAnnotation(sbase, null);
            if (ma == null) {
                return;
            }
            if (strAnnotation == null || "".equals(strAnnotation.trim())) {
                ma.setOtherAnnotation(new StringBuffer());
                sbase.setAnnotation("");
                return;
            }
            Vector vecMiriam = MiriamMainPanel.getMiriamsFromXMLNode(new Vector(), psbase.getAnnotation(), null);
            if (vecMiriam == null) {
                vecMiriam = new Vector();
            }
            StringBuffer bufMiriam = LibSBMLUtil.getMiriamValueFromMiriams(new StringBuffer(), sbase, vecMiriam, true);
            sbase.setAnnotation(bufMiriam.toString());
            ma.setOtherAnnotation(new StringBuffer(ModelAnnotation.getOtherAnnotation(strAnnotation)));
        } else if (sbase instanceof ModificationResidue) {
            Vector vecMiriam = MiriamMainPanel.getMiriamsFromXMLNode(new Vector(), psbase.getAnnotation(), null);
            if (vecMiriam == null) {
                vecMiriam = new Vector();
            }
            StringBuffer bufMiriam = LibSBMLUtil.getMiriamValueFromMiriams(new StringBuffer(), sbase, vecMiriam, true);
            sbase.setAnnotation(bufMiriam.toString());
        } else if (sbase instanceof Species) {
            if (sbase instanceof ModificationResidue || sbase instanceof BindingRegion || sbase instanceof ModificationRegion) {
                Vector vecMiriam = MiriamMainPanel.getMiriamsFromXMLNode(new Vector(), psbase.getAnnotation(), null);
                if (vecMiriam == null) {
                    vecMiriam = new Vector();
                }
                StringBuffer bufMiriam = LibSBMLUtil.getMiriamValueFromMiriams(new StringBuffer(), sbase, vecMiriam, true);
                sbase.setAnnotation(bufMiriam.toString());
            } else {
                String strAnnotation = psbase.getAnnotationString();
                SpeciesAnnotation ma = (SpeciesAnnotation)LibSBMLUtil.getAnnotation(sbase, null);
                if (ma == null) {
                    return;
                }
                if (strAnnotation == null || "".equals(strAnnotation.trim())) {
                    ma.setOtherAnnotation(new StringBuffer());
                    sbase.setAnnotation("");
                    return;
                }
                Vector vecMiriam = MiriamMainPanel.getMiriamsFromXMLNode(new Vector(), psbase.getAnnotation(), null);
                if (vecMiriam == null) {
                    vecMiriam = new Vector();
                }
                StringBuffer bufMiriam = LibSBMLUtil.getMiriamValueFromMiriams(new StringBuffer(), sbase, vecMiriam, true);
                sbase.setAnnotation(bufMiriam.toString());
                ma.setOtherAnnotation(new StringBuffer(ModelAnnotation.getOtherAnnotation(strAnnotation)));
            }
        } else if (sbase instanceof Reaction) {
            String strAnnotation = psbase.getAnnotationString();
            ReactionAnnotation ma = (ReactionAnnotation)LibSBMLUtil.getAnnotation(sbase, null);
            if (ma == null) {
                return;
            }
            if (strAnnotation == null || "".equals(strAnnotation.trim())) {
                ma.setOtherAnnotation(new StringBuffer());
                sbase.setAnnotation("");
                return;
            }
            Vector vecMiriam = MiriamMainPanel.getMiriamsFromXMLNode(new Vector(), psbase.getAnnotation(), null);
            if (vecMiriam == null) {
                vecMiriam = new Vector();
            }
            StringBuffer bufMiriam = LibSBMLUtil.getMiriamValueFromMiriams(new StringBuffer(), sbase, vecMiriam, true);
            sbase.setAnnotation(bufMiriam.toString());
            ma.setOtherAnnotation(new StringBuffer(ModelAnnotation.getOtherAnnotation(strAnnotation)));
        } else if (sbase instanceof KineticLaw) {
            if (psbase instanceof PluginKineticLaw) {
                Vector vecMiriam = MiriamMainPanel.getMiriamsFromXMLNode(new Vector(), psbase.getAnnotation(), null);
                if (vecMiriam == null) {
                    vecMiriam = new Vector();
                }
                StringBuffer bufMiriam = LibSBMLUtil.getMiriamValueFromMiriams(new StringBuffer(), sbase, vecMiriam, true);
                String strReactionID = ((PluginKineticLaw)psbase).getParentReactionID();
                String rtn = LibSBMLUtil.addEnclosedAnnotationTags(strReactionID, bufMiriam.toString());
                sbase.setAnnotation(rtn);
            }
        } else if (sbase instanceof Parameter && parent != null) {
            Vector vecMiriam = MiriamMainPanel.getMiriamsFromXMLNode(new Vector(), psbase.getAnnotation(), null);
            if (vecMiriam == null) {
                vecMiriam = new Vector();
            }
            StringBuffer bufMiriam = LibSBMLUtil.getMiriamValueFromMiriams(new StringBuffer(), sbase, vecMiriam, true);
            String strReactionID = parent.getParentReactionID();
            String rtn = LibSBMLUtil.addEnclosedAnnotationTags(strReactionID, bufMiriam.toString());
            sbase.setAnnotation(rtn);
        } else if (sbase instanceof Parameter) {
            if (psbase instanceof PluginParameter) {
                Vector vecMiriam = MiriamMainPanel.getMiriamsFromXMLNode(new Vector(), psbase.getAnnotation(), null);
                if (vecMiriam == null) {
                    vecMiriam = new Vector();
                }
                StringBuffer bufMiriam = LibSBMLUtil.getMiriamValueFromMiriams(new StringBuffer(), sbase, vecMiriam, true);
                if (((PluginParameter)psbase).getParentReaction() != null) {
                    String strReactionID = ((PluginParameter)psbase).getParentSBaseID();
                    String rtn = LibSBMLUtil.addEnclosedAnnotationTags(strReactionID, bufMiriam.toString());
                    sbase.setAnnotation(rtn);
                } else {
                    sbase.setAnnotation(bufMiriam.toString());
                }
            }
        } else {
            Vector vecMiriam = MiriamMainPanel.getMiriamsFromXMLNode(new Vector(), psbase.getAnnotation(), null);
            if (vecMiriam == null) {
                vecMiriam = new Vector();
            }
            StringBuffer bufMiriam = LibSBMLUtil.getMiriamValueFromMiriams(new StringBuffer(), sbase, vecMiriam, true);
            sbase.setAnnotation(bufMiriam.toString());
        }
    }

    public static final ModelDescription getDescriptionFromXMLNode(String strNode) {
        if (strNode == null || "".equals(strNode)) {
            return null;
        }
        ModelDescription newDes = new ModelDescription();
        String strFamily = ModelAnnotation.getVaule(strNode, "<vCard:Family>", "</vCard:Family>");
        newDes.setCreatorFamilyName(strFamily);
        String strGiven = ModelAnnotation.getVaule(strNode, "<vCard:Given>", "</vCard:Given>");
        newDes.setCreatorGivenName(strGiven);
        String strOrgname = ModelAnnotation.getVaule(strNode, "<vCard:Orgname>", "</vCard:Orgname>");
        newDes.setCreatorOrganization(strOrgname);
        String strEmail = ModelAnnotation.getVaule(strNode, "<vCard:EMAIL>", "</vCard:EMAIL>");
        newDes.setCreatorEMAIL(strEmail);
        String strCreateTime = ModelAnnotation.getVaule(strNode, "<dcterms:created rdf:parseType=\"Resource\">", "</dcterms:created>");
        String strCreateTimeValue = ModelAnnotation.getVaule(strCreateTime, "<dcterms:W3CDTF>", "</dcterms:W3CDTF>");
        newDes.setFileCreatedDate(strCreateTimeValue);
        String strModifiedTime = ModelAnnotation.getVaule(strNode, "<dcterms:modified rdf:parseType=\"Resource\">", "</dcterms:modified>");
        String strModifiedTimeValue = ModelAnnotation.getVaule(strModifiedTime, "<dcterms:W3CDTF>", "</dcterms:W3CDTF>");
        newDes.setFileModifiedDate(strModifiedTimeValue);
        return newDes;
    }

    private static String getVaule(String strAnnotation, String splitValue1, String splitValue2) {
        if (strAnnotation == null || "".equals(strAnnotation) || splitValue1 == null || "".equals(splitValue1) || splitValue2 == null || "".equals(splitValue2)) {
            return "";
        }
        if (strAnnotation.contains(splitValue1) && strAnnotation.contains(splitValue2)) {
            String[] str1 = strAnnotation.split(splitValue1);
            if (str1.length > 1) {
                String[] str2 = str1[1].split(splitValue2);
                return str2[0];
            }
            return "";
        }
        return "";
    }

    public static String getOtherAnnotation(String strAnnotation) {
        String[] annotationsEnd;
        if (strAnnotation == null || "".equals(strAnnotation.trim())) {
            return "";
        }
        String strOtherAnnotation = "";
        String[] annotationsStart = strAnnotation.split("<rdf:RDF");
        if (annotationsStart != null && annotationsStart.length > 0) {
            strOtherAnnotation = annotationsStart[0];
        }
        if ((annotationsEnd = strAnnotation.split("</rdf:RDF>")).length >= 2) {
            String strOtherAnnotationTem = annotationsEnd[1];
            strOtherAnnotation = String.valueOf(strOtherAnnotation) + strOtherAnnotationTem;
        }
        return strOtherAnnotation;
    }
}

