/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.sbmlExtension;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import javax.swing.JPanel;
import jp.fric.graphics.draw.PaintScheme;
import jp.sbi.celldesigner.MonoSpeciesShape;
import jp.sbi.celldesigner.Preference;
import jp.sbi.celldesigner.SpeciesSymbol;
import jp.sbi.celldesigner.sbmlExtension.ModificationShape;

class MRShapesPanel
extends JPanel {
    SpeciesSymbol symbol = null;
    Vector mShapes = new Vector();
    int W;
    int H;
    private static final double SPACE = 15.0;
    double sx;
    double sy;
    double sw;
    double sh;
    Point2D.Double[] edgePoints;
    private PaintScheme painter = null;

    public MRShapesPanel(int width, int height) {
        this.W = width;
        this.H = height;
        this.setBackground(Color.lightGray);
        this.setSize(this.W, this.H);
        this.sx = 15.0;
        this.sy = 37.5;
        this.sw = (double)this.W - 30.0;
        this.sh = (double)this.H - 52.5;
    }

    public void setPaintScheme(PaintScheme scheme) {
        this.painter = scheme;
    }

    public void releaseAll() {
        this.mShapes.clear();
        this.mShapes = null;
        this.symbol = null;
    }

    public Dimension getPrefferedSize() {
        return new Dimension(this.W, this.H);
    }

    public void buildSymbolBounds(Rectangle2D.Double bounds) {
        double maxHeight = (double)this.H - 30.0;
        double maxWidth = (double)this.W - 30.0;
        if (bounds.height / bounds.width < maxHeight / maxWidth) {
            this.sw = maxWidth;
            this.sh = bounds.height * this.sw / bounds.width;
        } else {
            this.sh = maxHeight;
            this.sw = bounds.width * this.sh / bounds.height;
        }
        this.sx = ((double)this.W - this.sw) / 2.0;
        this.sy = ((double)this.H - this.sh) / 2.0;
        if (this.symbol != null) {
            this.symbol.setSymbolBounds(this.sx, this.sy, this.sw, this.sh);
        }
    }

    public Point2D.Double getSymbolCenter() {
        return new Point2D.Double(this.sx + this.sw / 2.0, this.sy + this.sh / 2.0);
    }

    public Rectangle2D.Double getSymbolFrame() {
        return new Rectangle2D.Double(this.sx, this.sy, this.sw, this.sh);
    }

    public Point2D.Double[] getMovingRange() {
        Point2D.Double[] movingRange = new Point2D.Double[]{this.edgePoints[0], this.edgePoints[6]};
        return movingRange;
    }

    public void setSpeciesSymbol(SpeciesSymbol symbol) {
        this.symbol = symbol;
        if (symbol != null) {
            if (this.painter == null) {
                if (Preference.isDebug) {
                    System.err.println("ERROR: MShapesPanel.setSpeciesSymbol() : painter == null");
                }
            } else {
                symbol.setPaintScheme(this.painter);
            }
            this.setBackground(Color.white);
            symbol.setSymbolBounds(this.sx, this.sy, this.sw, this.sh);
            this.edgePoints = symbol.getEdgePoints();
            this.resetMShapes();
        } else {
            this.setBackground(Color.lightGray);
        }
    }

    public void setModificationShapes(Vector mShapes) {
        int debug = mShapes.size();
        this.mShapes = mShapes;
        this.resetMShapes();
    }

    private void resetMShapes() {
        if (this.symbol != null && this.mShapes != null) {
            int i = 0;
            while (i < this.mShapes.size()) {
                ModificationShape mShape = (ModificationShape)this.mShapes.elementAt(i);
                mShape.setSpeciesSymbol(this.symbol);
                ++i;
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.symbol != null) {
            Graphics2D g2 = (Graphics2D)g;
            if (Preference.antialias) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            } else {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            this.symbol.drawInner(g2, 1);
            if (this.mShapes != null) {
                g2.setColor(MonoSpeciesShape.residueColor);
                g2.setStroke(MonoSpeciesShape.residueStroke);
                int i = 0;
                while (i < this.mShapes.size()) {
                    ModificationShape mShape = (ModificationShape)this.mShapes.elementAt(i);
                    mShape.updateCircleBounds();
                    mShape.getNameBounds(null);
                    mShape.draw(g2);
                    ++i;
                }
            }
        }
    }
}

