/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.sbmlExtension;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MouseInputAdapter;
import jp.fric.graphics.draw.PaintScheme;
import jp.sbi.celldesigner.Preference;
import jp.sbi.celldesigner.SBFactory;
import jp.sbi.celldesigner.SpeciesSymbol;
import jp.sbi.celldesigner.sbmlExtension.Gene;
import jp.sbi.celldesigner.sbmlExtension.GenePanelListener;
import jp.sbi.celldesigner.sbmlExtension.MGShapesPanel;
import jp.sbi.celldesigner.sbmlExtension.Modification;
import jp.sbi.celldesigner.sbmlExtension.ModificationRegion;
import jp.sbi.celldesigner.sbmlExtension.ModificationRegionDialog2;
import jp.sbi.celldesigner.sbmlExtension.ModificationShape;
import jp.sbi.celldesigner.symbol.color.SpeciesColorScheme;

public class GenePanel
extends JPanel
implements ActionListener {
    Dialog pDialog;
    ModificationRegionDialog2 mDialog;
    GenePanelListener listener = null;
    private JTextField geneNameField;
    private JComboBox geneTypeCombo;
    private JButton addResidueButton;
    private JButton editResidueButton;
    private JButton removeResidueButton;
    private MGShapesPanel mShapesPanel;
    private Gene editingGene = null;
    private Vector editingModifications = new Vector();
    private Vector mShapes = new Vector();
    private ModificationShape selected = null;
    private boolean isEnabled = true;
    private boolean isEditable = true;
    private ResidueNamespace residueNamespace = new ResidueNamespace();
    private MyMouseListener myMouseListener;
    private MyKeyListener myKeyListener;
    private PaintScheme painter = null;
    private static Vector tempVector = new Vector();
    private static String[] types = new String[]{"CodingRegion", "RegulatoryRegion", "Modification Site", "transcriptionStartingSiteL", "transcriptionStartingSiteR"};

    public GenePanel(JDialog pDialog, ModificationRegionDialog2 mDialog) {
        JLabel labelMax = new JLabel("residues/regions");
        int maxWidth = (int)labelMax.getPreferredSize().getWidth();
        int inputX = maxWidth + 20;
        this.pDialog = pDialog;
        this.mDialog = mDialog;
        this.setLayout(null);
        this.setSize(inputX + 200, 160);
        JLabel labelGeneName = new JLabel("name");
        labelGeneName.setBounds(new Rectangle(10, 4, maxWidth, 20));
        this.add((Component)labelGeneName, null);
        this.geneNameField = new JTextField();
        this.geneNameField.setBounds(new Rectangle(inputX, 4, 200, 20));
        this.geneNameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (GenePanel.this.listener != null) {
                    GenePanel.this.listener.panelStateChanged();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (GenePanel.this.listener != null) {
                    GenePanel.this.listener.panelStateChanged();
                }
            }
        });
        this.add((Component)this.geneNameField, null);
        JLabel labelGeneType = new JLabel("type");
        labelGeneType.setBounds(new Rectangle(10, 28, maxWidth, 20));
        this.add((Component)labelGeneType, null);
        this.geneTypeCombo = new JComboBox();
        this.geneTypeCombo.setBounds(new Rectangle(inputX, 28, 200, 20));
        this.add((Component)this.geneTypeCombo, null);
        JLabel labelResidue = new JLabel("regions");
        labelResidue.setBounds(new Rectangle(10, 52, maxWidth, 20));
        this.add((Component)labelResidue, null);
        this.addResidueButton = new JButton("add..");
        this.addResidueButton.setBounds(new Rectangle(10, 76, maxWidth, 20));
        this.add((Component)this.addResidueButton, null);
        this.editResidueButton = new JButton("edit..");
        this.editResidueButton.setBounds(new Rectangle(10, 100, maxWidth, 20));
        this.add((Component)this.editResidueButton, null);
        this.removeResidueButton = new JButton("del..");
        this.removeResidueButton.setBounds(new Rectangle(10, 128, maxWidth, 20));
        this.add((Component)this.removeResidueButton, null);
        this.mShapesPanel = new MGShapesPanel(200, 100);
        this.mShapesPanel.setBounds(new Rectangle(inputX, 56, 200, 100));
        this.add((Component)this.mShapesPanel, null);
        Vector codes = SBFactory.getCompatibleSymbolCodes("GENE");
        int s = 0;
        int i = 0;
        while (i < codes.size()) {
            String code = (String)codes.elementAt(i);
            if (SBFactory.isGene(code)) {
                this.geneTypeCombo.insertItemAt(code, s++);
            }
            ++i;
        }
        this.myKeyListener = new MyKeyListener();
        pDialog.addKeyListener(this.myKeyListener);
        this.geneTypeCombo.addActionListener(this);
        this.addResidueButton.addActionListener(this);
        this.editResidueButton.addActionListener(this);
        this.removeResidueButton.addActionListener(this);
        this.myMouseListener = new MyMouseListener(this.mShapesPanel);
        this.mShapesPanel.addMouseListener(this.myMouseListener);
        this.mShapesPanel.addMouseMotionListener(this.myMouseListener);
    }

    public void setGeneName(String name) {
        this.geneNameField.setText(name);
    }

    public void setPaintScheme(PaintScheme scheme) {
        this.painter = scheme;
        this.mShapesPanel.setPaintScheme(scheme);
    }

    public void releaseAll() {
        this.mShapesPanel.removeMouseListener(this.myMouseListener);
        this.mShapesPanel.removeMouseMotionListener(this.myMouseListener);
        this.myMouseListener = null;
        this.removeResidueButton.removeActionListener(this);
        this.editResidueButton.removeActionListener(this);
        this.addResidueButton.removeActionListener(this);
        this.geneTypeCombo.removeActionListener(this);
        this.pDialog.removeKeyListener(this.myKeyListener);
        this.myKeyListener = null;
        this.selected = null;
        this.residueNamespace = null;
        this.editingGene = null;
        this.mShapes.clear();
        this.mShapes = null;
        this.mShapesPanel.releaseAll();
        this.mShapesPanel = null;
        this.mDialog = null;
        this.pDialog = null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.geneTypeCombo)) {
            this.geneTypeCombo_performed();
        }
        if (e.getSource().equals(this.addResidueButton)) {
            this.addResidue_performed();
        }
        if (e.getSource().equals(this.editResidueButton)) {
            this.editResidue_performed();
        }
        if (e.getSource().equals(this.removeResidueButton)) {
            this.removeResidue_performed();
        }
    }

    public void setGenePanelListener(GenePanelListener listener) {
        this.listener = listener;
    }

    public void setSymbolBounds(Rectangle2D.Double bounds) {
        this.mShapesPanel.buildSymbolBounds(bounds);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        this.geneNameField.setEnabled(isEnabled);
        this.geneTypeCombo.setEnabled(isEnabled);
        if (!isEnabled) {
            this.geneNameField.setText("");
            this.geneTypeCombo.setSelectedItem("GENE");
            this.mShapesPanel.setSpeciesSymbol(null);
            this.setEditable(false);
        }
    }

    public void setEditable(boolean isEditable) {
        this.isEditable = isEditable;
        this.geneNameField.setEnabled(isEditable);
        this.geneTypeCombo.setEnabled(isEditable);
        this.setResidueRelatedEnability();
    }

    private void setResidueRelatedEnability() {
        this.addResidueButton.setEnabled(this.isEditable);
        this.editResidueButton.setEnabled(this.isEditable && this.selected != null);
        this.removeResidueButton.setEnabled(this.isEditable && this.selected != null);
    }

    public void setGene(Gene gene) {
        int debug = gene.getListOfRegions().size();
        this.editingGene = gene;
        this.initPanel(null);
    }

    public void setGene(Gene gene, Vector initial_modifications) {
        int debug = gene.getListOfRegions().size();
        this.editingGene = gene;
        this.initPanel(initial_modifications);
    }

    private void initPanel(Vector initial_modifications) {
        if (this.editingGene == null) {
            return;
        }
        String name = this.editingGene.getName();
        this.geneNameField.setText(name);
        String type = this.editingGene.getType();
        this.geneTypeCombo.setSelectedItem(type);
        SpeciesSymbol symbol = (SpeciesSymbol)((Object)SBFactory.createSymbol(type));
        if (this.painter == null) {
            if (Preference.isDebug) {
                System.out.println("ERROR : GenePanel.initPanel() : painter == null");
            }
            Color color = SpeciesColorScheme.getColor(type);
            this.painter = SpeciesColorScheme.getScheme(type);
            this.painter.setColor(color);
            this.mShapesPanel.setPaintScheme(this.painter);
        }
        this.mShapesPanel.setSpeciesSymbol(symbol);
        this.editingModifications = new Vector();
        this.mShapes = new Vector();
        Vector regions = this.editingGene.getListOfRegions();
        int debug = regions.size();
        int i = 0;
        while (i < regions.size()) {
            ModificationRegion region = (ModificationRegion)regions.get(i);
            String regionId = region.getId();
            Modification m = null;
            if (initial_modifications != null) {
                int k = 0;
                while (k < initial_modifications.size()) {
                    Modification modification = (Modification)initial_modifications.elementAt(k);
                    if (modification.getResidue().equals(regionId)) {
                        m = modification;
                        break;
                    }
                    ++k;
                }
            }
            if (m == null) {
                m = new Modification(regionId);
            }
            this.editingModifications.add(m);
            ModificationShape mShape = new ModificationShape();
            mShape.setModificationRegion(region);
            mShape.setModification(m);
            this.mShapes.add(mShape);
            ++i;
        }
        this.mShapesPanel.setModificationShapes(this.mShapes);
        this.residueNamespace.initResidueMaxId(regions);
        this.selected = null;
        this.setResidueRelatedEnability();
        this.pDialog.repaint();
    }

    public Gene getGene() {
        String newName = this.geneNameField.getText();
        this.editingGene.setName(newName);
        String type = (String)this.geneTypeCombo.getSelectedItem();
        this.editingGene.setType(type);
        return this.editingGene;
    }

    public Vector getModifications() {
        return this.editingModifications;
    }

    private void geneTypeCombo_performed() {
        if (this.isEnabled && this.isEditable) {
            String type = (String)this.geneTypeCombo.getSelectedItem();
            if (type == null) {
                return;
            }
            SpeciesSymbol symbol = (SpeciesSymbol)((Object)SBFactory.createSymbol(type));
            this.mShapesPanel.setSpeciesSymbol(symbol);
            this.pDialog.repaint();
            if (this.listener != null) {
                this.listener.panelStateChanged();
            }
        }
    }

    private void addResidue_performed() {
        if (this.isEnabled && this.isEditable) {
            ModificationRegion rs = new ModificationRegion();
            String regionId = this.residueNamespace.createNewResidueId();
            try {
                rs.setId(regionId);
            }
            catch (Exception exception) {
                // empty catch block
            }
            rs.setType("Modification Site");
            rs.setSize(0.0);
            rs.setPos(0.3);
            this.editingGene.getListOfRegions().add(rs);
            Modification m = new Modification(regionId);
            this.editingModifications.add(m);
            ModificationShape mShape = new ModificationShape();
            mShape.setModificationRegion(rs);
            m.setState("empty");
            mShape.setModification(m);
            this.mShapes.add(mShape);
            this.mShapesPanel.setModificationShapes(this.mShapes);
            if (this.selected != null) {
                this.selected.setSoloHighlighted(false);
                if (this.listener != null) {
                    this.listener.mShapeDeselected(this.selected);
                }
            }
            this.selected = mShape;
            this.selected.setSoloHighlighted(true);
            if (this.listener != null) {
                this.listener.mShapeSelected(this.selected);
            }
            this.setResidueRelatedEnability();
            this.pDialog.repaint();
            this.editResidue_performed();
        }
    }

    private void editResidue_performed() {
        if (this.selected != null && this.isEnabled && this.isEditable) {
            this.mDialog.setComboItemForGene();
            ModificationRegion region = this.selected.getModificationRegion();
            this.mDialog.setModificationRegion(region);
            this.mDialog.show();
            if (this.listener != null) {
                this.listener.panelStateChanged();
            }
        }
    }

    private void removeResidue_performed() {
        if (this.selected != null && this.isEnabled && this.isEditable) {
            this.mShapes.remove(this.selected);
            ModificationRegion rs = this.selected.getModificationRegion();
            this.editingGene.getListOfRegions().remove(rs);
            if (this.editingModifications != null) {
                int i = 0;
                while (i < this.editingModifications.size()) {
                    Modification m = (Modification)this.editingModifications.elementAt(i);
                    if (m.getResidue().equals(rs.getId())) {
                        this.editingModifications.remove(m);
                        break;
                    }
                    ++i;
                }
            }
            this.mShapesPanel.setModificationShapes(this.mShapes);
            if (this.listener != null) {
                this.listener.mShapeDeselected(this.selected);
            }
            this.selected = null;
            this.setResidueRelatedEnability();
            this.pDialog.repaint();
            if (this.mDialog.isShowing()) {
                this.mDialog.setModificationRegion(null);
            }
            if (this.listener != null) {
                this.listener.panelStateChanged();
            }
        }
    }

    public static void sortModificationShapes(Vector modificationShapes) {
        GenePanel.sortModificationShapes(types, modificationShapes);
    }

    public static void sortModificationShapes(String[] types, Vector modificationShapes) {
        if (types == null) {
            return;
        }
        if (modificationShapes == null) {
            return;
        }
        tempVector.clear();
        tempVector.addAll(modificationShapes);
        modificationShapes.clear();
        int typeIndex = 0;
        while (typeIndex < types.length) {
            int size = tempVector.size();
            int i = 0;
            while (i < size) {
                ModificationShape mShape = (ModificationShape)tempVector.elementAt(i);
                if (mShape.getModificationRegion() != null && types[typeIndex].equals(mShape.getModificationRegion().getType())) {
                    modificationShapes.addElement(mShape);
                }
                ++i;
            }
            ++typeIndex;
        }
        int i = 0;
        while (i < tempVector.size()) {
            ModificationShape mShape = (ModificationShape)tempVector.elementAt(i);
            if (mShape.getModificationRegion() == null) {
                modificationShapes.addElement(mShape);
            } else {
                boolean typeInArray = false;
                int k = 0;
                while (k < types.length) {
                    if (types[k].equals(mShape.getModificationRegion().getType())) {
                        typeInArray = true;
                        break;
                    }
                    ++k;
                }
                if (!typeInArray) {
                    modificationShapes.addElement(mShape);
                }
            }
            ++i;
        }
    }

    private class MyKeyListener
    extends KeyAdapter {
        private MyKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (GenePanel.this.selected != null && GenePanel.this.isEnabled && GenePanel.this.isEditable && (e.getKeyCode() == 127 || e.getKeyCode() == 8)) {
                GenePanel.this.removeResidue_performed();
            }
        }
    }

    private class MyMouseListener
    extends MouseInputAdapter {
        int downX = 0;
        int downY = 0;
        MGShapesPanel mShapesPanel;

        public MyMouseListener(MGShapesPanel mShapesPanel) {
            this.mShapesPanel = mShapesPanel;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (GenePanel.this.isEnabled) {
                this.downX = e.getX();
                this.downY = e.getY();
                ModificationShape prevSelected = GenePanel.this.selected;
                if (GenePanel.this.selected != null) {
                    GenePanel.this.selected.setSoloHighlighted(false);
                    GenePanel.this.selected = null;
                }
                int i = GenePanel.this.mShapes.size() - 1;
                while (i >= 0) {
                    ModificationShape mShape = (ModificationShape)GenePanel.this.mShapes.elementAt(i);
                    if (mShape.inShape(this.downX, this.downY)) {
                        GenePanel.this.selected = mShape;
                        GenePanel.this.selected.setSoloHighlighted(true);
                        break;
                    }
                    --i;
                }
                GenePanel.this.setResidueRelatedEnability();
                GenePanel.this.pDialog.repaint();
                if (GenePanel.this.selected != null && GenePanel.this.isEditable) {
                    ModificationRegion rs = GenePanel.this.selected.getModificationRegion();
                    if (GenePanel.this.mDialog.isShowing()) {
                        GenePanel.this.mDialog.setModificationRegion(rs);
                    } else if (e.getClickCount() > 1) {
                        GenePanel.this.editResidue_performed();
                    }
                }
                if (GenePanel.this.listener != null) {
                    if (prevSelected != null && GenePanel.this.selected == null) {
                        GenePanel.this.listener.mShapeDeselected(prevSelected);
                    } else if (prevSelected == null && GenePanel.this.selected != null) {
                        GenePanel.this.listener.mShapeSelected(GenePanel.this.selected);
                    } else if (prevSelected != null && GenePanel.this.selected != null && prevSelected != GenePanel.this.selected) {
                        GenePanel.this.listener.mShapeDeselected(prevSelected);
                        GenePanel.this.listener.mShapeSelected(GenePanel.this.selected);
                    }
                }
                Object var2_2 = null;
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (GenePanel.this.selected != null && GenePanel.this.isEnabled && GenePanel.this.isEditable) {
                Point2D.Double[] range = this.mShapesPanel.getMovingRange();
                double w = range[1].x - range[0].x;
                double size = GenePanel.this.selected.getModificationRegion().getSize();
                double maxPos = 1.0 - size;
                double pos = 0.0;
                pos = ((double)e.getX() - range[0].x) / w - size / 2.0;
                if ((pos = 50.0 * pos / 50.0) > maxPos) {
                    pos = maxPos;
                }
                if (pos < 0.0) {
                    pos = 0.0;
                }
                GenePanel.this.selected.getModificationRegion().setPos(pos);
                GenePanel.this.pDialog.repaint();
                if (GenePanel.this.listener != null) {
                    GenePanel.this.listener.panelStateChanged();
                }
            }
        }
    }

    private class ResidueNamespace {
        private int residueCnt = 0;
        private String residueNametag = "tr";

        private ResidueNamespace() {
        }

        public String createNewResidueId() {
            ++this.residueCnt;
            return String.valueOf(this.residueNametag) + this.residueCnt;
        }

        private void initResidueMaxId(Vector list) {
            this.residueCnt = 0;
            int maxCnt = 0;
            int i = 0;
            while (i < list.size()) {
                ModificationRegion r = (ModificationRegion)list.get(i);
                ++this.residueCnt;
                String id = r.getId();
                String cntStr = id.substring(this.residueNametag.length());
                if (!cntStr.equals("")) {
                    try {
                        int cnt = Integer.parseInt(cntStr);
                        if (cnt > maxCnt) {
                            maxCnt = cnt;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++i;
            }
            if (this.residueCnt < maxCnt) {
                this.residueCnt = maxCnt;
            }
        }
    }
}

