/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.sbmlExtension;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jp.fric.graphics.draw.PaintScheme;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.sbmlExtension.Gene;
import jp.sbi.celldesigner.sbmlExtension.GenePanel;
import jp.sbi.celldesigner.sbmlExtension.GenePanelListener;
import jp.sbi.celldesigner.sbmlExtension.ModificationRegionDialog2;
import jp.sbi.celldesigner.sbmlExtension.ModificationShape;
import jp.sbi.celldesigner.symbol.color.SpeciesColorScheme;
import jp.sbi.sbml.SId;
import jp.sbi.sbml.SIdFormatException;
import jp.sbi.sbml.util.SBaseDialog;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Species;

public class GeneDialog2
extends SBaseDialog
implements GenePanelListener {
    private GenePanel genePanel;
    protected ModificationRegionDialog2 mDialog;
    SBModel sbmodel = null;

    public GeneDialog2() {
    }

    public GeneDialog2(Dialog owner) {
        super(owner);
    }

    public GeneDialog2(Frame owner) {
        super(owner);
    }

    public void setDialogByArg(String name) {
        this.genePanel.setGeneName(name);
    }

    @Override
    protected JPanel createDialogPanel() {
        this.mDialog = new ModificationRegionDialog2(this);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(null);
        this.genePanel = new GenePanel(this, this.mDialog);
        this.genePanel.setBounds(new Rectangle(0, 0, this.genePanel.getWidth(), this.genePanel.getHeight()));
        this.mainPanel.add(this.genePanel);
        this.genePanel.setGenePanelListener(this);
        this.LABEL_WIDTH = 90;
        this.TEXT_WIDTH = 200;
        this.setLayoutConstants();
        this.BUTTON_POSITION_Y = 10 + 7 * this.BASELINE_SKIP;
        this.DIALOG_WIDTH = this.genePanel.getWidth() + 10;
        this.setDefaultButtonsLayout();
        this.addDefaultButtonsToPanel();
        return this.mainPanel;
    }

    @Override
    protected SBase createInitialObject() {
        return new Gene();
    }

    @Override
    protected void setDialogFromObject(SBase sbase) {
        if (sbase == null) {
            return;
        }
        Gene gene = null;
        if (sbase instanceof Gene) {
            gene = (Gene)sbase;
        } else if (sbase instanceof Species) {
            Species sp = (Species)sbase;
            gene = this.sbmodel.getGene(sp.getId());
        }
        Gene copy = gene.deepClone();
        String code = gene.getType();
        Color color = SpeciesColorScheme.getColor(code);
        BasicStroke stroke = new BasicStroke((float)SpeciesColorScheme.getLineWidth(code), 0, 1);
        PaintScheme scheme = SpeciesColorScheme.getScheme(code);
        scheme.setColor(color);
        scheme.setStroke(stroke);
        this.genePanel.setPaintScheme(scheme);
        this.genePanel.setGene(copy);
    }

    @Override
    protected void setObjectFromDialog(SBase sbase) throws Exception {
        if (sbase == null) {
            return;
        }
        Gene gene = (Gene)sbase;
        Gene edited = this.genePanel.getGene();
        try {
            SId.check(edited.getId());
            gene.setId(edited.getId());
        }
        catch (SIdFormatException e) {
            throw new Exception("malformed id string");
        }
        gene.setName(edited.getName());
        gene.setType(edited.getType());
        Vector geneResidues = gene.getListOfRegions();
        Vector editedResidues = edited.getListOfRegions();
        geneResidues.clear();
        int i = 0;
        while (i < editedResidues.size()) {
            SBase residue = (SBase)editedResidues.get(i);
            geneResidues.add(residue);
            ++i;
        }
    }

    @Override
    protected void setComponentsEnabled(boolean isEnabled) {
        this.genePanel.setEnabled(isEnabled);
        this.genePanel.setEditable(isEnabled);
        this.okButton.setEnabled(isEnabled);
    }

    @Override
    protected void releaseAllMembers() {
    }

    @Override
    protected boolean hasChildListDialog() {
        return false;
    }

    @Override
    protected void setChildDialogMode(int mode) {
    }

    @Override
    protected void updateChildDialog() {
    }

    @Override
    public void mShapeSelected(ModificationShape mShape) {
    }

    @Override
    public void mShapeDeselected(ModificationShape mShape) {
    }

    @Override
    public void panelStateChanged() {
        super.someFieldIsEdited();
    }

    @Override
    public void setObject(SBase sbase) {
        super.setObject(sbase);
        this.updateApproveLabel();
    }

    @Override
    public void setNewObject() {
        super.setNewObject();
        this.updateApproveLabel();
    }

    @Override
    public void show() {
        this.updateApproveLabel();
        super.show();
    }

    @Override
    protected void okButton_actionPerformed() {
        try {
            if (this.sbmodel != null) {
                Gene p = new Gene();
                this.setObjectFromDialog((SBase)p);
                if (!(this.getObject() instanceof Gene) && this.getObject() instanceof Species) {
                    this.setObject((SBase)this.sbmodel.getGene(((Species)this.getObject()).getId()));
                    this.sbmodel.geneUpdated((Gene)super.getObject(), p);
                } else {
                    this.sbmodel.geneUpdated((Gene)this.getObject(), p);
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Confirmation", 2);
        }
        this.updateApproveLabel();
    }

    @Override
    public boolean update_actionPerformed() {
        boolean returnval;
        try {
            if (this.sbmodel != null) {
                Gene p = new Gene();
                this.setObjectFromDialog((SBase)p);
                if (!(this.getObject() instanceof Gene) && this.getObject() instanceof Species) {
                    this.setObject((SBase)this.sbmodel.getGene(((Species)this.getObject()).getId()));
                }
                this.sbmodel.geneUpdated((Gene)super.getObject(), p);
                MainWindow.getLastInstance().SBaseChanged(this.getObject());
            }
            returnval = true;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Confirmation", 2);
            returnval = false;
        }
        this.updateApproveLabel();
        return returnval;
    }

    @Override
    protected void cancelButton_actionPerformed() {
        super.cancelDialog();
    }

    public void setSBModel(SBModel sbmodel) {
        this.sbmodel = sbmodel;
    }
}

