/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.sbmlExtension;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;
import jp.fric.graphics.draw.PaintScheme;
import jp.sbi.celldesigner.ComplexProperty;
import jp.sbi.celldesigner.SBFactory;
import jp.sbi.celldesigner.SpeciesSymbol;
import jp.sbi.celldesigner.sbmlExtension.ComplexPanelListener;
import jp.sbi.celldesigner.sbmlExtension.MCShapesPanel;
import jp.sbi.celldesigner.sbmlExtension.ModificationShape;
import jp.sbi.celldesigner.sbmlExtension.SameIDAutoTag;
import jp.sbi.celldesigner.sbmlExtension.StructuralState;
import jp.sbi.celldesigner.symbol.color.SpeciesColorScheme;

public class ComplexPanel
extends JPanel
implements ActionListener {
    Dialog pDialog;
    ComplexPanelListener listener = null;
    private MCShapesPanel mShapesPanel;
    private ComplexProperty editingComplexProperty = null;
    private Vector editingStructuralStates = new Vector();
    private ModificationShape selected = null;
    private MyMouseListener myMouseListener;
    private SameIDAutoTag autotag = null;
    private SameIDAutoTag autotagselected = null;
    private PaintScheme painter = null;

    public SameIDAutoTag getSameIDAutoTag() {
        return this.autotag;
    }

    public ComplexPanel(JDialog pDialog) {
        this.pDialog = pDialog;
        this.setLayout(null);
        JLabel labelState = new JLabel("structuralstate");
        int maxWidth = (int)labelState.getPreferredSize().getWidth();
        int inputX = maxWidth + 31;
        this.setSize(inputX + 200, 105);
        labelState.setBounds(new Rectangle(10, 5, maxWidth, 20));
        this.add((Component)labelState, null);
        this.mShapesPanel = new MCShapesPanel(200, 100);
        this.mShapesPanel.setBounds(new Rectangle(inputX, 5, 200, 100));
        this.add((Component)this.mShapesPanel, null);
        this.myMouseListener = new MyMouseListener(this.mShapesPanel);
        this.mShapesPanel.addMouseListener(this.myMouseListener);
        this.mShapesPanel.addMouseMotionListener(this.myMouseListener);
    }

    public void setPaintScheme(PaintScheme scheme) {
        this.painter = scheme;
        this.mShapesPanel.setPaintScheme(scheme);
    }

    public void releaseAll() {
        this.mShapesPanel.removeMouseListener(this.myMouseListener);
        this.mShapesPanel.removeMouseMotionListener(this.myMouseListener);
        this.myMouseListener = null;
        this.selected = null;
        this.autotagselected = null;
        this.editingComplexProperty = null;
        this.mShapesPanel.releaseAll();
        this.mShapesPanel = null;
        this.pDialog = null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public void setComplexPanelListener(ComplexPanelListener listener) {
        this.listener = listener;
    }

    public void setSymbolBounds(Rectangle2D.Double bounds) {
        this.mShapesPanel.buildSymbolBounds(bounds);
    }

    public void setComplexProperty(ComplexProperty complexProperty, Vector initial_structuralStates, SameIDAutoTag tag) {
        this.editingComplexProperty = complexProperty;
        this.initPanel(initial_structuralStates, tag);
    }

    private void initPanel(Vector initial_structuralStates, SameIDAutoTag tag) {
        if (this.editingComplexProperty == null) {
            return;
        }
        String type = this.editingComplexProperty.getType();
        SpeciesSymbol symbol = (SpeciesSymbol)((Object)SBFactory.createSymbol(type));
        if (this.painter == null) {
            Color color = SpeciesColorScheme.getColor(type);
            this.painter = SpeciesColorScheme.getScheme(type);
            this.painter.setColor(color);
            this.mShapesPanel.setPaintScheme(this.painter);
        }
        this.mShapesPanel.setSpeciesSymbol(symbol);
        Vector<ModificationShape> structuralStateShapes = new Vector<ModificationShape>();
        this.editingStructuralStates = new Vector();
        if (initial_structuralStates != null && initial_structuralStates.size() > 0) {
            int i = 0;
            while (i < initial_structuralStates.size()) {
                StructuralState structuralState = (StructuralState)initial_structuralStates.get(i);
                ModificationShape mShape = new ModificationShape();
                mShape.setStructuralState(structuralState);
                structuralStateShapes.add(mShape);
                this.editingStructuralStates.add(structuralState);
                ++i;
            }
        }
        this.mShapesPanel.setStructuralStateShapes(structuralStateShapes);
        this.mShapesPanel.setSameIDAutoTag(symbol, tag);
        this.autotag = this.mShapesPanel.getSameIDAutoTag();
        this.selected = null;
        this.autotagselected = null;
        this.pDialog.repaint();
    }

    public Vector getStructuralStates() {
        return this.editingStructuralStates;
    }

    public void setStructuralStateShapes(Vector structuralStateShapes) {
        this.mShapesPanel.setStructuralStateShapes(structuralStateShapes);
    }

    private class MyMouseListener
    extends MouseInputAdapter {
        int downX = 0;
        int downY = 0;
        MCShapesPanel mShapesPanel;

        public MyMouseListener(MCShapesPanel mShapesPanel) {
            this.mShapesPanel = mShapesPanel;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.downX = e.getX();
            this.downY = e.getY();
            ComplexPanel.this.selected = null;
            ComplexPanel.this.autotagselected = null;
            if (this.mShapesPanel.getSameIDAutoTag() != null && this.mShapesPanel.getSameIDAutoTag().getPaintPath().getBounds2D().contains(this.downX, this.downY)) {
                ComplexPanel.this.autotagselected = this.mShapesPanel.getSameIDAutoTag();
                ComplexPanel.this.pDialog.repaint();
                return;
            }
            int i = this.mShapesPanel.structuralStateShapes.size() - 1;
            while (i >= 0) {
                ModificationShape mShape = (ModificationShape)this.mShapesPanel.structuralStateShapes.elementAt(i);
                if (mShape.getStructuralState().getState().equals("empty")) {
                    ComplexPanel.this.selected = null;
                    return;
                }
                if (mShape.inShape(this.downX, this.downY)) {
                    ComplexPanel.this.selected = mShape;
                    break;
                }
                --i;
            }
            ComplexPanel.this.pDialog.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (ComplexPanel.this.selected != null || ComplexPanel.this.autotagselected != null) {
                Point2D.Double c = this.mShapesPanel.getSymbolCenter();
                double vx = (double)e.getX() - c.x;
                double vy = (double)e.getY() - c.y;
                Rectangle2D.Double rect = this.mShapesPanel.getSymbolFrame();
                double width = rect.width;
                double height = rect.height;
                double angle = 0.0;
                if (vx == 0.0 && vy == 0.0) {
                    return;
                }
                if (vx > 0.0 && vy <= 0.0 && -vy * width < vx * height) {
                    angle = -vy * width / (4.0 * vx * height);
                } else if (vy < 0.0 && vy * width < vx * height && vx * height <= -vy * width) {
                    angle = vx * height / (4.0 * vy * width) + 0.5;
                } else if (vx < 0.0 && vx * height <= vy * width && vy * width < -vx * height) {
                    angle = -vy * width / (4.0 * vx * height) + 1.0;
                } else if (vy > 0.0 && -vy * width <= vx * height && vx * height < vy * width) {
                    angle = vx * height / (4.0 * vy * width) + 1.5;
                } else if (vx > 0.0 && vx >= 0.0 && vy * width <= vx * height) {
                    angle = -vy * width / (4.0 * vx * height) + 2.0;
                } else {
                    return;
                }
                angle *= Math.PI;
                if (ComplexPanel.this.selected != null && ComplexPanel.this.selected.getStructuralState() != null) {
                    ComplexPanel.this.selected.getStructuralState().setAngle(angle);
                } else if (ComplexPanel.this.autotagselected != null) {
                    ComplexPanel.this.autotagselected.setAngle(angle);
                }
                ComplexPanel.this.pDialog.repaint();
            }
        }
    }
}

