/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.sbmlExtension;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Vector;
import jp.co.mki.celldesigner.simulation.util.StringTool;
import jp.sbi.celldesigner.CompartmentAlias;
import jp.sbi.celldesigner.sbmlExtension.ModelAnnotation;
import jp.sbi.sbml.Any;
import jp.sbi.sbml.util.LibSBMLUtil;
import jp.sbi.sbml.util.XMLUtil;
import org.sbml.libsbml.Compartment;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.XMLNamespaces;
import org.sbml.libsbml.XMLNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CompartmentAnnotation
implements Any {
    private String compartmentName = "";
    private Vector referedAliases = new Vector();
    private Node nodeForMiriam = null;
    private StringBuffer bufAnnotation = new StringBuffer();
    private HashMap hashLocalNS = new HashMap();

    public void setCompartmentName(String name) {
        this.compartmentName = name;
    }

    public String getCompartmentName() {
        return this.compartmentName;
    }

    public void addReference(CompartmentAlias alias) {
        this.referedAliases.add(alias);
    }

    public void removeReference(CompartmentAlias alias) {
        this.referedAliases.remove(alias);
    }

    public boolean hasReferences() {
        return this.referedAliases.size() > 0;
    }

    public Vector getReferingAliases() {
        return (Vector)this.referedAliases.clone();
    }

    @Override
    public String[] getAttributeNames() {
        return new String[0];
    }

    @Override
    public String[] getAttributeShortNames() {
        return new String[0];
    }

    @Override
    public int[] getAttributeColumnSizes() {
        return new int[0];
    }

    @Override
    public String[] getAttributeValues() {
        return new String[0];
    }

    @Override
    public boolean hasValue() {
        return !this.compartmentName.equals("");
    }

    public void readXML(Node node) throws Exception {
        String str;
        String ns = ModelAnnotation.getInputNamespace();
        String tag = String.valueOf(ns) + ":name";
        Node nameNode = XMLUtil.getChildNode(node, tag);
        if (nameNode != null && !(str = nameNode.getFirstChild().getNodeValue()).equals("")) {
            try {
                this.compartmentName = str;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void readDOMTree(Element element) throws Exception {
        NodeList childlistTop = element.getChildNodes();
        NodeList childlistCellD = null;
        NodeList childlist = null;
        int iLoopMaxTimes = 2;
        int iLoopMax = 2;
        boolean bCellDVerMaxThan401 = false;
        childlist = childlistTop;
        do {
            int childsize = childlist.getLength();
            int i = 0;
            while (i < childsize) {
                Node node = childlist.item(i);
                if (node.getNodeType() == 1 && ((Element)node).getPrefix() != null && ((Element)node).getPrefix().equals("celldesigner") && ((Element)node).getLocalName() != null && ((Element)node).getLocalName().equals("extension")) {
                    childlistCellD = node.getChildNodes();
                    if (childlistCellD == null || childlist.getLength() <= 0) {
                        throw new Exception();
                    }
                    bCellDVerMaxThan401 = true;
                } else if (node.getNodeName() != null && node.getNodeName().equals("rdf:RDF")) {
                    this.nodeForMiriam = (Element)node;
                } else if (node.getNodeType() == 1 && "http://www.sbml.org/2001/ns/celldesigner".equals(node.getNamespaceURI())) {
                    if (node.getLocalName().equals("name")) {
                        String str = "";
                        Node fchild = node.getFirstChild();
                        if (fchild != null) {
                            str = fchild.getNodeValue();
                        }
                        if (!str.equals("")) {
                            try {
                                this.compartmentName = str;
                            }
                            catch (Exception exception) {}
                        }
                    }
                } else if (iLoopMax == 2 && node.getNodeType() == 1) {
                    int j = 0;
                    while (j < element.getAttributes().getLength()) {
                        Node n = element.getAttributes().item(j);
                        if (n.getNodeName().indexOf("xmlns:") != -1) {
                            this.hashLocalNS.put(n.getLocalName(), n.getNodeValue());
                        }
                        ++j;
                    }
                    Element elem = (Element)node;
                    String tag = elem.getLocalName();
                    if (elem.getPrefix() != null) {
                        this.bufAnnotation.append("<" + elem.getPrefix() + ":" + tag);
                    } else {
                        this.bufAnnotation.append("<" + tag);
                    }
                    NamedNodeMap map = elem.getAttributes();
                    if (map.getLength() == 0) {
                        this.bufAnnotation.append(">");
                    }
                    int k = 0;
                    while (k < map.getLength()) {
                        Node nodes = map.item(k);
                        this.bufAnnotation.append(" " + nodes.getNodeName() + "=\"" + nodes.getNodeValue() + "\"");
                        if (k + 1 >= map.getLength()) {
                            this.bufAnnotation.append(">\n");
                        }
                        ++k;
                    }
                    this.readSomeAnnotation(elem);
                    if (elem.getPrefix() != null) {
                        this.bufAnnotation.append("</" + elem.getPrefix() + ":" + tag + ">\n");
                    } else {
                        this.bufAnnotation.append("</" + tag + ">\n");
                    }
                }
                ++i;
            }
            if (!bCellDVerMaxThan401) break;
            childlist = childlistCellD;
        } while (--iLoopMax > 0);
    }

    @Override
    public HashMap getLocalNS() {
        return this.hashLocalNS;
    }

    private void readSomeAnnotation(Element elem) {
        NodeList children = elem.getChildNodes();
        int j = 0;
        while (j < children.getLength()) {
            Node pNode = children.item(j);
            if (pNode.getNodeType() == 1) {
                Element elem2 = (Element)pNode;
                String tag = elem2.getLocalName();
                if (elem2.getPrefix() != null) {
                    this.bufAnnotation.append("<" + elem2.getPrefix() + ":" + tag);
                } else {
                    this.bufAnnotation.append("<" + tag);
                }
                NamedNodeMap map = elem2.getAttributes();
                if (map.getLength() == 0) {
                    this.bufAnnotation.append(">");
                }
                int i = 0;
                while (i < map.getLength()) {
                    Node nodes = map.item(i);
                    this.bufAnnotation.append(" " + nodes.getNodeName() + "=\"" + nodes.getNodeValue() + "\"");
                    if (i + 1 >= map.getLength()) {
                        this.bufAnnotation.append(">\n");
                    }
                    ++i;
                }
                this.readSomeAnnotation((Element)pNode);
                if (elem2.getPrefix() != null) {
                    this.bufAnnotation.append("</" + elem2.getPrefix() + ":" + tag + ">\n");
                } else {
                    this.bufAnnotation.append("</" + tag + ">\n");
                }
            } else if (pNode.getNodeValue() != null && !pNode.getNodeValue().equals("") && !pNode.getNodeValue().equals("\n")) {
                this.bufAnnotation.append(pNode.getNodeValue());
            }
            ++j;
        }
    }

    public void writeXML(String indent, PrintWriter pw) {
        String ns = ModelAnnotation.getOutputNamespace();
        String tag = String.valueOf(ns) + ":name";
        String s = "<" + tag + ">" + this.compartmentName + "</" + tag + ">";
        pw.println(String.valueOf(indent) + s);
    }

    @Override
    public void writeDOMTree(Node node) {
        Document doc = node.getOwnerDocument();
        String URI2 = node.getNamespaceURI();
        String ns = ModelAnnotation.getOutputNamespace();
        Element elem = doc.createElementNS(URI2, String.valueOf(ns) + ":name");
        node.appendChild(elem);
        elem.appendChild(doc.createTextNode(this.compartmentName));
    }

    @Override
    public void releaseAllMembers() {
        this.referedAliases.clear();
        this.referedAliases = null;
    }

    @Override
    public void setParentSBase(SBase sbase) {
    }

    public void updateAnnotation(Compartment com, XMLNamespaces anntXmlNS) {
        if (this.compartmentName == null || this.compartmentName.equals("")) {
            return;
        }
        Vector vecData = LibSBMLUtil.getMiriamDatasFromAnnotationOfSBase((SBase)com);
        StringBuffer buf = new StringBuffer();
        buf.append("<annotation xmlns:celldesigner=\"http://www.sbml.org/2001/ns/celldesigner\">");
        buf.append("\n");
        buf.append("<celldesigner:extension>");
        buf.append("<celldesigner:");
        buf.append("name>");
        buf.append(StringTool.toEscape(this.compartmentName));
        buf.append("</celldesigner:");
        buf.append("name>\n");
        buf.append("</celldesigner:extension>");
        if (vecData != null && vecData.size() > 0) {
            buf = LibSBMLUtil.getMiriamValueFromMiriams(buf, (SBase)com, vecData, true);
        }
        buf.append(this.bufAnnotation.toString());
        buf.append("</annotation>");
        XMLNode annt = XMLNode.convertStringToXMLNode((String)buf.toString(), (XMLNamespaces)anntXmlNS);
        com.setAnnotation(annt);
    }

    public Node getNodeForMiriam() {
        return this.nodeForMiriam;
    }

    public void setNodeForMiriam(Node nodeForMiriam) {
        this.nodeForMiriam = nodeForMiriam;
    }

    public StringBuffer getOtherAnnotation() {
        return this.bufAnnotation;
    }

    public void setOtherAnnotation(StringBuffer strBufAnnotation) {
        this.bufAnnotation = strBufAnnotation;
    }
}

