/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.sbmlExtension;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MouseInputAdapter;
import jp.fric.graphics.draw.PaintScheme;
import jp.sbi.celldesigner.Preference;
import jp.sbi.celldesigner.SBFactory;
import jp.sbi.celldesigner.SpeciesSymbol;
import jp.sbi.celldesigner.sbmlExtension.AntiSenseRNA;
import jp.sbi.celldesigner.sbmlExtension.AntiSenseRNAPanelListener;
import jp.sbi.celldesigner.sbmlExtension.MASRShapesPanel;
import jp.sbi.celldesigner.sbmlExtension.Modification;
import jp.sbi.celldesigner.sbmlExtension.ModificationRegion;
import jp.sbi.celldesigner.sbmlExtension.ModificationRegionDialog2;
import jp.sbi.celldesigner.sbmlExtension.ModificationShape;
import jp.sbi.celldesigner.symbol.color.SpeciesColorScheme;

public class AntiSenseRNAPanel
extends JPanel
implements ActionListener {
    Dialog pDialog;
    ModificationRegionDialog2 mDialog;
    AntiSenseRNAPanelListener listener = null;
    private JTextField antisensernaNameField;
    private JComboBox antisensernaTypeCombo;
    private JButton addResidueButton;
    private JButton editResidueButton;
    private JButton removeResidueButton;
    private MASRShapesPanel mShapesPanel;
    private AntiSenseRNA editingAntiSenseRNA = null;
    private Vector editingModifications = new Vector();
    private Vector mShapes = new Vector();
    private ModificationShape selected = null;
    private boolean isEnabled = true;
    private boolean isEditable = true;
    private ResidueNamespace residueNamespace = new ResidueNamespace();
    private MyMouseListener myMouseListener;
    private MyKeyListener myKeyListener;
    private PaintScheme painter = null;

    public AntiSenseRNAPanel(JDialog pDialog, ModificationRegionDialog2 mDialog) {
        JLabel labelMax = new JLabel("residues/regions");
        int maxWidth = (int)labelMax.getPreferredSize().getWidth();
        int inputX = maxWidth + 20;
        this.pDialog = pDialog;
        this.mDialog = mDialog;
        this.setLayout(null);
        this.setSize(inputX + 200, 160);
        JLabel labelAntiSenseRNAName = new JLabel("name");
        labelAntiSenseRNAName.setBounds(new Rectangle(10, 4, maxWidth, 20));
        this.add((Component)labelAntiSenseRNAName, null);
        this.antisensernaNameField = new JTextField();
        this.antisensernaNameField.setBounds(new Rectangle(inputX, 4, 200, 20));
        this.antisensernaNameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (AntiSenseRNAPanel.this.listener != null) {
                    AntiSenseRNAPanel.this.listener.panelStateChanged();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (AntiSenseRNAPanel.this.listener != null) {
                    AntiSenseRNAPanel.this.listener.panelStateChanged();
                }
            }
        });
        this.add((Component)this.antisensernaNameField, null);
        JLabel labelAntiSenseRNAType = new JLabel("type");
        labelAntiSenseRNAType.setBounds(new Rectangle(10, 28, maxWidth, 20));
        this.add((Component)labelAntiSenseRNAType, null);
        this.antisensernaTypeCombo = new JComboBox();
        this.antisensernaTypeCombo.setBounds(new Rectangle(inputX, 28, 200, 20));
        this.add((Component)this.antisensernaTypeCombo, null);
        JLabel labelResidue = new JLabel("regions");
        labelResidue.setBounds(new Rectangle(10, 52, maxWidth, 20));
        this.add((Component)labelResidue, null);
        this.addResidueButton = new JButton("add..");
        this.addResidueButton.setBounds(new Rectangle(10, 76, maxWidth, 20));
        this.add((Component)this.addResidueButton, null);
        this.editResidueButton = new JButton("edit..");
        this.editResidueButton.setBounds(new Rectangle(10, 100, maxWidth, 20));
        this.add((Component)this.editResidueButton, null);
        this.removeResidueButton = new JButton("del..");
        this.removeResidueButton.setBounds(new Rectangle(10, 128, maxWidth, 20));
        this.add((Component)this.removeResidueButton, null);
        this.mShapesPanel = new MASRShapesPanel(200, 100);
        this.mShapesPanel.setBounds(new Rectangle(inputX, 56, 200, 100));
        this.add((Component)this.mShapesPanel, null);
        Vector codes = SBFactory.getCompatibleSymbolCodes("ANTISENSE_RNA");
        int s = 0;
        int i = 0;
        while (i < codes.size()) {
            String code = (String)codes.elementAt(i);
            if (SBFactory.isAntiSenseRNA(code)) {
                this.antisensernaTypeCombo.insertItemAt(code, s++);
            }
            ++i;
        }
        this.myKeyListener = new MyKeyListener();
        pDialog.addKeyListener(this.myKeyListener);
        this.antisensernaTypeCombo.addActionListener(this);
        this.addResidueButton.addActionListener(this);
        this.editResidueButton.addActionListener(this);
        this.removeResidueButton.addActionListener(this);
        this.myMouseListener = new MyMouseListener(this.mShapesPanel);
        this.mShapesPanel.addMouseListener(this.myMouseListener);
        this.mShapesPanel.addMouseMotionListener(this.myMouseListener);
    }

    public void setAntiSenseRNAName(String name) {
        this.antisensernaNameField.setText(name);
    }

    public void setPaintScheme(PaintScheme scheme) {
        this.painter = scheme;
        this.mShapesPanel.setPaintScheme(scheme);
    }

    public void releaseAll() {
        this.mShapesPanel.removeMouseListener(this.myMouseListener);
        this.mShapesPanel.removeMouseMotionListener(this.myMouseListener);
        this.myMouseListener = null;
        this.removeResidueButton.removeActionListener(this);
        this.editResidueButton.removeActionListener(this);
        this.addResidueButton.removeActionListener(this);
        this.antisensernaTypeCombo.removeActionListener(this);
        this.pDialog.removeKeyListener(this.myKeyListener);
        this.myKeyListener = null;
        this.selected = null;
        this.residueNamespace = null;
        this.editingAntiSenseRNA = null;
        this.mShapes.clear();
        this.mShapes = null;
        this.mShapesPanel.releaseAll();
        this.mShapesPanel = null;
        this.mDialog = null;
        this.pDialog = null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.antisensernaTypeCombo)) {
            this.antisensernaTypeCombo_performed();
        }
        if (e.getSource().equals(this.addResidueButton)) {
            this.addResidue_performed();
        }
        if (e.getSource().equals(this.editResidueButton)) {
            this.editResidue_performed();
        }
        if (e.getSource().equals(this.removeResidueButton)) {
            this.removeResidue_performed();
        }
    }

    public void setAntiSenseRNAPanelListener(AntiSenseRNAPanelListener listener) {
        this.listener = listener;
    }

    public void setSymbolBounds(Rectangle2D.Double bounds) {
        this.mShapesPanel.buildSymbolBounds(bounds);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        this.antisensernaNameField.setEnabled(isEnabled);
        this.antisensernaTypeCombo.setEnabled(isEnabled);
        if (!isEnabled) {
            this.antisensernaNameField.setText("");
            this.antisensernaTypeCombo.setSelectedItem("ANTISENSE_RNA");
            this.mShapesPanel.setSpeciesSymbol(null);
            this.setEditable(false);
        }
    }

    public void setEditable(boolean isEditable) {
        this.isEditable = isEditable;
        this.antisensernaNameField.setEnabled(isEditable);
        this.antisensernaTypeCombo.setEnabled(isEditable);
        this.setResidueRelatedEnability();
    }

    private void setResidueRelatedEnability() {
        this.addResidueButton.setEnabled(this.isEditable);
        this.editResidueButton.setEnabled(this.isEditable && this.selected != null);
        this.removeResidueButton.setEnabled(this.isEditable && this.selected != null);
    }

    public void setAntiSenseRNA(AntiSenseRNA rna) {
        int debug = rna.getListOfRegions().size();
        this.editingAntiSenseRNA = rna;
        this.initPanel(null);
    }

    public void setAntiSenseRNA(AntiSenseRNA rna, Vector initial_modifications) {
        int debug = rna.getListOfRegions().size();
        this.editingAntiSenseRNA = rna;
        this.initPanel(initial_modifications);
    }

    private void initPanel(Vector initial_modifications) {
        if (this.editingAntiSenseRNA == null) {
            return;
        }
        String name = this.editingAntiSenseRNA.getName();
        this.antisensernaNameField.setText(name);
        String type = this.editingAntiSenseRNA.getType();
        this.antisensernaTypeCombo.setSelectedItem(type);
        SpeciesSymbol symbol = (SpeciesSymbol)((Object)SBFactory.createSymbol(type));
        if (this.painter == null) {
            if (Preference.isDebug) {
                System.out.println("ERROR : AntiSenseRNAPanel.initPanel() : painter == null");
            }
            Color color = SpeciesColorScheme.getColor(type);
            this.painter = SpeciesColorScheme.getScheme(type);
            this.painter.setColor(color);
            this.mShapesPanel.setPaintScheme(this.painter);
        }
        this.mShapesPanel.setSpeciesSymbol(symbol);
        this.editingModifications = new Vector();
        this.mShapes = new Vector();
        Vector regions = this.editingAntiSenseRNA.getListOfRegions();
        int debug = regions.size();
        int i = 0;
        while (i < regions.size()) {
            ModificationRegion region = (ModificationRegion)regions.get(i);
            String regionId = region.getId();
            Modification m = null;
            if (initial_modifications != null) {
                int k = 0;
                while (k < initial_modifications.size()) {
                    Modification modification = (Modification)initial_modifications.elementAt(k);
                    if (modification.getResidue().equals(regionId)) {
                        m = modification;
                        break;
                    }
                    ++k;
                }
            }
            if (m == null) {
                m = new Modification(regionId);
            }
            this.editingModifications.add(m);
            ModificationShape mShape = new ModificationShape();
            mShape.setModificationRegion(region);
            mShape.setModification(m);
            this.mShapes.add(mShape);
            ++i;
        }
        this.mShapesPanel.setModificationShapes(this.mShapes);
        this.residueNamespace.initResidueMaxId(regions);
        this.selected = null;
        this.setResidueRelatedEnability();
        this.pDialog.repaint();
    }

    public AntiSenseRNA getAntiSenseRNA() {
        String newName = this.antisensernaNameField.getText();
        this.editingAntiSenseRNA.setName(newName);
        String type = (String)this.antisensernaTypeCombo.getSelectedItem();
        this.editingAntiSenseRNA.setType(type);
        return this.editingAntiSenseRNA;
    }

    public Vector getModifications() {
        return this.editingModifications;
    }

    private void antisensernaTypeCombo_performed() {
        if (this.isEnabled && this.isEditable) {
            String type = (String)this.antisensernaTypeCombo.getSelectedItem();
            if (type == null) {
                return;
            }
            SpeciesSymbol symbol = (SpeciesSymbol)((Object)SBFactory.createSymbol(type));
            this.mShapesPanel.setSpeciesSymbol(symbol);
            this.pDialog.repaint();
            if (this.listener != null) {
                this.listener.panelStateChanged();
            }
        }
    }

    private void addResidue_performed() {
        if (this.isEnabled && this.isEditable) {
            ModificationRegion rs = new ModificationRegion();
            String regionId = this.residueNamespace.createNewResidueId();
            try {
                rs.setId(regionId);
            }
            catch (Exception exception) {
                // empty catch block
            }
            rs.setType("CodingRegion");
            rs.setSize(0.3);
            rs.setPos(0.3);
            this.editingAntiSenseRNA.getListOfRegions().add(rs);
            Modification m = new Modification(regionId);
            this.editingModifications.add(m);
            ModificationShape mShape = new ModificationShape();
            mShape.setModificationRegion(rs);
            mShape.setModification(m);
            this.mShapes.add(mShape);
            this.mShapesPanel.setModificationShapes(this.mShapes);
            if (this.selected != null) {
                this.selected.setSoloHighlighted(false);
                if (this.listener != null) {
                    this.listener.mShapeDeselected(this.selected);
                }
            }
            this.selected = mShape;
            this.selected.setSoloHighlighted(true);
            if (this.listener != null) {
                this.listener.mShapeSelected(this.selected);
            }
            this.setResidueRelatedEnability();
            this.pDialog.repaint();
            this.editResidue_performed();
        }
    }

    private void editResidue_performed() {
        if (this.selected != null && this.isEnabled && this.isEditable) {
            this.mDialog.setComboItemForRNA();
            ModificationRegion region = this.selected.getModificationRegion();
            this.mDialog.setModificationRegion(region);
            this.mDialog.show();
            if (this.listener != null) {
                this.listener.panelStateChanged();
            }
        }
    }

    private void removeResidue_performed() {
        if (this.selected != null && this.isEnabled && this.isEditable) {
            this.mShapes.remove(this.selected);
            ModificationRegion rs = this.selected.getModificationRegion();
            this.editingAntiSenseRNA.getListOfRegions().remove(rs);
            if (this.editingModifications != null) {
                int i = 0;
                while (i < this.editingModifications.size()) {
                    Modification m = (Modification)this.editingModifications.elementAt(i);
                    if (m.getResidue().equals(rs.getId())) {
                        this.editingModifications.remove(m);
                        break;
                    }
                    ++i;
                }
            }
            this.mShapesPanel.setModificationShapes(this.mShapes);
            if (this.listener != null) {
                this.listener.mShapeDeselected(this.selected);
            }
            this.selected = null;
            this.setResidueRelatedEnability();
            this.pDialog.repaint();
            if (this.mDialog.isShowing()) {
                this.mDialog.setModificationRegion(null);
            }
            if (this.listener != null) {
                this.listener.panelStateChanged();
            }
        }
    }

    private class MyKeyListener
    extends KeyAdapter {
        private MyKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (AntiSenseRNAPanel.this.selected != null && AntiSenseRNAPanel.this.isEnabled && AntiSenseRNAPanel.this.isEditable && (e.getKeyCode() == 127 || e.getKeyCode() == 8)) {
                AntiSenseRNAPanel.this.removeResidue_performed();
            }
        }
    }

    private class MyMouseListener
    extends MouseInputAdapter {
        int downX = 0;
        int downY = 0;
        MASRShapesPanel mShapesPanel;

        public MyMouseListener(MASRShapesPanel mShapesPanel) {
            this.mShapesPanel = mShapesPanel;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (AntiSenseRNAPanel.this.isEnabled) {
                this.downX = e.getX();
                this.downY = e.getY();
                ModificationShape prevSelected = AntiSenseRNAPanel.this.selected;
                if (AntiSenseRNAPanel.this.selected != null) {
                    AntiSenseRNAPanel.this.selected.setSoloHighlighted(false);
                    AntiSenseRNAPanel.this.selected = null;
                }
                int i = AntiSenseRNAPanel.this.mShapes.size() - 1;
                while (i >= 0) {
                    ModificationShape mShape = (ModificationShape)AntiSenseRNAPanel.this.mShapes.elementAt(i);
                    if (mShape.inShape(this.downX, this.downY)) {
                        AntiSenseRNAPanel.this.selected = mShape;
                        AntiSenseRNAPanel.this.selected.setSoloHighlighted(true);
                        break;
                    }
                    --i;
                }
                AntiSenseRNAPanel.this.setResidueRelatedEnability();
                AntiSenseRNAPanel.this.pDialog.repaint();
                if (AntiSenseRNAPanel.this.selected != null && AntiSenseRNAPanel.this.isEditable) {
                    ModificationRegion rs = AntiSenseRNAPanel.this.selected.getModificationRegion();
                    if (AntiSenseRNAPanel.this.mDialog.isShowing()) {
                        AntiSenseRNAPanel.this.mDialog.setModificationRegion(rs);
                    } else if (e.getClickCount() > 1) {
                        AntiSenseRNAPanel.this.editResidue_performed();
                    }
                }
                if (AntiSenseRNAPanel.this.listener != null) {
                    if (prevSelected != null && AntiSenseRNAPanel.this.selected == null) {
                        AntiSenseRNAPanel.this.listener.mShapeDeselected(prevSelected);
                    } else if (prevSelected == null && AntiSenseRNAPanel.this.selected != null) {
                        AntiSenseRNAPanel.this.listener.mShapeSelected(AntiSenseRNAPanel.this.selected);
                    } else if (prevSelected != null && AntiSenseRNAPanel.this.selected != null && prevSelected != AntiSenseRNAPanel.this.selected) {
                        AntiSenseRNAPanel.this.listener.mShapeDeselected(prevSelected);
                        AntiSenseRNAPanel.this.listener.mShapeSelected(AntiSenseRNAPanel.this.selected);
                    }
                }
                Object var2_2 = null;
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (AntiSenseRNAPanel.this.selected != null && AntiSenseRNAPanel.this.isEnabled && AntiSenseRNAPanel.this.isEditable) {
                Point2D.Double[] range = this.mShapesPanel.getMovingRange();
                double w = range[1].x - range[0].x;
                double size = AntiSenseRNAPanel.this.selected.getModificationRegion().getSize();
                double maxPos = 1.0 - size;
                double pos = 0.0;
                pos = ((double)e.getX() - range[0].x) / w - size / 2.0;
                if (pos > maxPos) {
                    pos = maxPos;
                }
                if (pos < 0.0) {
                    pos = 0.0;
                }
                AntiSenseRNAPanel.this.selected.getModificationRegion().setPos(pos);
                AntiSenseRNAPanel.this.pDialog.repaint();
                if (AntiSenseRNAPanel.this.listener != null) {
                    AntiSenseRNAPanel.this.listener.panelStateChanged();
                }
            }
        }
    }

    private class ResidueNamespace {
        private int residueCnt = 0;
        private String residueNametag = "tr";

        private ResidueNamespace() {
        }

        public String createNewResidueId() {
            ++this.residueCnt;
            return String.valueOf(this.residueNametag) + this.residueCnt;
        }

        private void initResidueMaxId(Vector list) {
            this.residueCnt = 0;
            int maxCnt = 0;
            int i = 0;
            while (i < list.size()) {
                ModificationRegion r = (ModificationRegion)list.get(i);
                ++this.residueCnt;
                String id = r.getId();
                String cntStr = id.substring(this.residueNametag.length());
                if (!cntStr.equals("")) {
                    try {
                        int cnt = Integer.parseInt(cntStr);
                        if (cnt > maxCnt) {
                            maxCnt = cnt;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++i;
            }
            if (this.residueCnt < maxCnt) {
                this.residueCnt = maxCnt;
            }
        }
    }
}

