/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.sbmlExtension;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jp.fric.graphics.draw.PaintScheme;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.sbmlExtension.AntiSenseRNA;
import jp.sbi.celldesigner.sbmlExtension.AntiSenseRNAPanel;
import jp.sbi.celldesigner.sbmlExtension.AntiSenseRNAPanelListener;
import jp.sbi.celldesigner.sbmlExtension.ModificationRegionDialog2;
import jp.sbi.celldesigner.sbmlExtension.ModificationShape;
import jp.sbi.celldesigner.symbol.color.SpeciesColorScheme;
import jp.sbi.sbml.SId;
import jp.sbi.sbml.SIdFormatException;
import jp.sbi.sbml.util.SBaseDialog;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Species;

public class AntiSenseRNADialog2
extends SBaseDialog
implements AntiSenseRNAPanelListener {
    private AntiSenseRNAPanel antisensernaPanel;
    protected ModificationRegionDialog2 mDialog;
    SBModel sbmodel = null;

    public AntiSenseRNADialog2() {
    }

    public AntiSenseRNADialog2(Dialog owner) {
        super(owner);
    }

    public AntiSenseRNADialog2(Frame owner) {
        super(owner);
    }

    public void setDialogByArg(String name) {
        this.antisensernaPanel.setAntiSenseRNAName(name);
    }

    @Override
    protected JPanel createDialogPanel() {
        this.mDialog = new ModificationRegionDialog2(this);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(null);
        this.antisensernaPanel = new AntiSenseRNAPanel(this, this.mDialog);
        this.antisensernaPanel.setBounds(new Rectangle(0, 0, this.antisensernaPanel.getWidth(), this.antisensernaPanel.getHeight()));
        this.mainPanel.add(this.antisensernaPanel);
        this.antisensernaPanel.setAntiSenseRNAPanelListener(this);
        this.LABEL_WIDTH = 90;
        this.TEXT_WIDTH = 200;
        this.setLayoutConstants();
        this.BUTTON_POSITION_Y = 10 + 7 * this.BASELINE_SKIP;
        this.DIALOG_WIDTH = this.antisensernaPanel.getWidth() + 10;
        this.setDefaultButtonsLayout();
        this.addDefaultButtonsToPanel();
        return this.mainPanel;
    }

    @Override
    protected SBase createInitialObject() {
        return new AntiSenseRNA();
    }

    @Override
    protected void setDialogFromObject(SBase sbase) {
        if (sbase == null) {
            return;
        }
        AntiSenseRNA rna = null;
        if (sbase instanceof AntiSenseRNA) {
            rna = (AntiSenseRNA)sbase;
        } else if (sbase instanceof Species) {
            Species sp = (Species)sbase;
            rna = this.sbmodel.getAntiSenseRNA(sp.getId());
        }
        AntiSenseRNA copy = rna.deepClone();
        String code = rna.getType();
        Color color = SpeciesColorScheme.getColor(code);
        BasicStroke stroke = new BasicStroke((float)SpeciesColorScheme.getLineWidth(code), 0, 1);
        PaintScheme scheme = SpeciesColorScheme.getScheme(code);
        scheme.setColor(color);
        scheme.setStroke(stroke);
        this.antisensernaPanel.setPaintScheme(scheme);
        this.antisensernaPanel.setAntiSenseRNA(copy);
    }

    @Override
    protected void setObjectFromDialog(SBase sbase) throws Exception {
        if (sbase == null) {
            return;
        }
        AntiSenseRNA rna = (AntiSenseRNA)sbase;
        AntiSenseRNA edited = this.antisensernaPanel.getAntiSenseRNA();
        try {
            SId.check(edited.getId());
            rna.setId(edited.getId());
        }
        catch (SIdFormatException e) {
            throw new Exception("malformed id string");
        }
        rna.setName(edited.getName());
        rna.setType(edited.getType());
        Vector rnaResidues = rna.getListOfRegions();
        Vector editedResidues = edited.getListOfRegions();
        rnaResidues.clear();
        int i = 0;
        while (i < editedResidues.size()) {
            SBase residue = (SBase)editedResidues.get(i);
            rnaResidues.add(residue);
            ++i;
        }
    }

    @Override
    protected void setComponentsEnabled(boolean isEnabled) {
        this.antisensernaPanel.setEnabled(isEnabled);
        this.antisensernaPanel.setEditable(isEnabled);
        this.okButton.setEnabled(isEnabled);
    }

    @Override
    protected void releaseAllMembers() {
    }

    @Override
    protected boolean hasChildListDialog() {
        return false;
    }

    @Override
    protected void setChildDialogMode(int mode) {
    }

    @Override
    protected void updateChildDialog() {
    }

    @Override
    public void mShapeSelected(ModificationShape mShape) {
    }

    @Override
    public void mShapeDeselected(ModificationShape mShape) {
    }

    @Override
    public void panelStateChanged() {
        super.someFieldIsEdited();
    }

    @Override
    public void setObject(SBase sbase) {
        super.setObject(sbase);
        this.updateApproveLabel();
    }

    @Override
    public void setNewObject() {
        super.setNewObject();
        this.updateApproveLabel();
    }

    @Override
    public void show() {
        this.updateApproveLabel();
        super.show();
    }

    @Override
    protected void okButton_actionPerformed() {
        try {
            if (this.sbmodel != null) {
                AntiSenseRNA p = new AntiSenseRNA();
                this.setObjectFromDialog((SBase)p);
                if (!(this.getObject() instanceof AntiSenseRNA) && this.getObject() instanceof Species) {
                    this.setObject((SBase)this.sbmodel.getAntiSenseRNA(((Species)this.getObject()).getId()));
                    this.sbmodel.antisensernaUpdated((AntiSenseRNA)super.getObject(), p);
                } else {
                    this.sbmodel.antisensernaUpdated((AntiSenseRNA)this.getObject(), p);
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Confirmation", 2);
        }
        this.updateApproveLabel();
    }

    @Override
    public boolean update_actionPerformed() {
        boolean returnval;
        try {
            if (this.sbmodel != null) {
                AntiSenseRNA p = new AntiSenseRNA();
                this.setObjectFromDialog((SBase)p);
                if (!(this.getObject() instanceof AntiSenseRNA) && this.getObject() instanceof Species) {
                    this.setObject((SBase)this.sbmodel.getAntiSenseRNA(((Species)this.getObject()).getId()));
                }
                this.sbmodel.antisensernaUpdated((AntiSenseRNA)super.getObject(), p);
                MainWindow.getLastInstance().SBaseChanged((SBase)p);
            }
            returnval = true;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Confirmation", 2);
            returnval = false;
        }
        this.updateApproveLabel();
        return returnval;
    }

    @Override
    protected void cancelButton_actionPerformed() {
        super.cancelDialog();
    }

    public void setSBModel(SBModel sbmodel) {
        this.sbmodel = sbmodel;
    }
}

