/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.sbmlExtension;

import java.util.Vector;
import jp.co.mki.celldesigner.simulation.util.StringTool;
import jp.sbi.celldesigner.SBFactory;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.plugin.PluginAntiSenseRNA;
import jp.sbi.celldesigner.plugin.PluginListOf;
import jp.sbi.celldesigner.plugin.PluginModificationRegion;
import jp.sbi.celldesigner.sbmlExtension.Biomolecule;
import jp.sbi.celldesigner.sbmlExtension.ModificationRegion;
import jp.sbi.celldesigner.sbmlExtension.Notes;
import jp.sbi.sbml.SId;
import jp.sbi.sbml.SIdFormatException;
import jp.sbi.sbml.SpecInfo;
import jp.sbi.sbml.debug.DebugPrinter;
import jp.sbi.sbml.util.LibSBMLUtil;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Species;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AntiSenseRNA
extends Species
implements Biomolecule {
    public static final int LIST_OF_REGIONS = 0;
    public static final int SIZE_OF_LISTS = 1;
    private Vector referedSpeciesAliases = new Vector();
    public static final String NAMESPACE = "celldesigner";
    private String name;
    private String type;
    private Vector[] lists = new Vector[1];
    private static final String[] nospaceListTagName = new String[]{"listOfRegions"};
    private static final String[] nospaceElementTagName = new String[]{"region"};
    private static final String[] nospaceElementTagNameAsLevel1 = new String[]{"region"};
    private static final String[] elementClassName = new String[]{"ModificationRegion"};

    public AntiSenseRNA() {
        this.initAttributes();
        int i = 0;
        while (i < 1) {
            this.lists[i] = new Vector();
            ++i;
        }
    }

    private void initAttributes() {
        try {
            SId.check("");
            super.setId("");
        }
        catch (SIdFormatException sIdFormatException) {
            // empty catch block
        }
        this.name = "";
        this.type = "";
    }

    public AntiSenseRNA deepClone() {
        AntiSenseRNA p = new AntiSenseRNA();
        try {
            p.setId(this.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        p.setName(this.name);
        p.setType(this.type);
        Vector list = this.getListOfRegions();
        int i = 0;
        while (i < list.size()) {
            ModificationRegion region = (ModificationRegion)list.get(i);
            ModificationRegion t = (ModificationRegion)region.clone();
            p.getListOfRegions().add(t);
            ++i;
        }
        p.setAnnotation(this.getAnnotation());
        return p;
    }

    public boolean equals(AntiSenseRNA target) {
        if (!target.getId().equals(this.getId())) {
            return false;
        }
        if (!target.getName().equals(this.name)) {
            return false;
        }
        if (!target.getType().equals(this.type)) {
            return false;
        }
        Vector targetList = target.getListOfRegions();
        Vector myList = this.getListOfRegions();
        if (targetList.size() != myList.size()) {
            return false;
        }
        int i = 0;
        while (i < myList.size()) {
            ModificationRegion tr1 = (ModificationRegion)myList.get(i);
            ModificationRegion tr2 = null;
            int k = 0;
            while (k < targetList.size()) {
                ModificationRegion tr = (ModificationRegion)targetList.get(k);
                if (tr1.getId().equals(tr.getId())) {
                    tr2 = tr;
                    break;
                }
                ++k;
            }
            if (tr2 == null) {
                return false;
            }
            if (!tr1.equals(tr2)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(PluginAntiSenseRNA target) {
        if (!target.getExtensionId().equals(this.getId())) {
            return false;
        }
        if (!target.getName().equals(this.name)) {
            return false;
        }
        if (!target.getType().equals(this.type)) {
            return false;
        }
        PluginListOf targetList = target.getListOfPluginRegion();
        Vector myList = this.getListOfRegions();
        if (targetList.size() != myList.size()) {
            return false;
        }
        int i = 0;
        while (i < myList.size()) {
            ModificationRegion tr1 = (ModificationRegion)myList.get(i);
            PluginModificationRegion tr2 = null;
            int k = 0;
            while (k < targetList.size()) {
                PluginModificationRegion tr = (PluginModificationRegion)targetList.get(k);
                if (tr1.getId().equals(tr.getId()) && tr1.getAnnotationString() != null && tr1.getAnnotationString().equals(tr.getAnnotationString())) {
                    tr2 = tr;
                    break;
                }
                ++k;
            }
            if (tr2 == null) {
                return false;
            }
            if (!tr1.equals(tr2)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public void addReference(SpeciesAlias alias) {
        this.referedSpeciesAliases.add(alias);
    }

    @Override
    public void removeReference(SpeciesAlias alias) {
        this.referedSpeciesAliases.remove(alias);
    }

    @Override
    public boolean hasReferences() {
        return this.referedSpeciesAliases.size() > 0;
    }

    @Override
    public Vector getReferences() {
        return (Vector)this.referedSpeciesAliases.clone();
    }

    @Override
    public void setName(String name) {
        this.name = name == null ? "" : name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setType(String type) {
        this.type = type == null ? "ANTISENSE_RNA" : (type.equals("") ? "ANTISENSE_RNA" : SBFactory.filterSynonym(type));
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void clear() {
        int i = 0;
        while (i < 1) {
            if (this.lists[i] != null) {
                this.lists[i].clear();
            }
            ++i;
        }
    }

    public Vector getList(int list_const) {
        if (list_const < 0 || list_const >= 1) {
            return null;
        }
        return this.lists[list_const];
    }

    public Vector getListOfRegions() {
        return this.lists[0];
    }

    public static String getListTagName(int list_const) {
        if (list_const < 0 || list_const >= 1) {
            return "";
        }
        return "celldesigner:" + nospaceListTagName[list_const];
    }

    public static String getElementTagName(int list_const) {
        if (list_const < 0 || list_const >= 1) {
            return "";
        }
        return "celldesigner:" + nospaceElementTagName[list_const];
    }

    public static String getElementClassName(int list_const) {
        if (list_const < 0 || list_const >= 1) {
            return "";
        }
        return elementClassName[list_const];
    }

    protected String getTagName(SpecInfo spec) {
        return "celldesigner:AntisenseRNA";
    }

    protected String[] getAttributeNames(SpecInfo spec) {
        return new String[]{"id", "type", "name"};
    }

    protected String[] getAttributeShortNames() {
        return new String[]{"id", "type", "name"};
    }

    protected int[] getAttributeColumnSizes() {
        return new int[]{40, 120, 200};
    }

    protected String[] getAttributeValues(SpecInfo spec) {
        return new String[]{this.getId(), this.getType(), this.getName()};
    }

    protected String[] getDefaultValues(SpecInfo spec) {
        AntiSenseRNA initialRNA = new AntiSenseRNA();
        return initialRNA.getAttributeValues(spec);
    }

    protected void setAttributeValues(String[] values, SpecInfo spec) throws Exception {
        this.initAttributes();
        if (!values[0].equals("")) {
            SId.check(values[0]);
            super.setId(values[0]);
        }
        if (!values[1].equals("")) {
            this.setType(values[1]);
        }
        if (!values[2].equals("")) {
            this.setName(values[2]);
        }
    }

    protected void releaseAllMembers() {
        this.clear();
        int i = 0;
        while (i < 1) {
            this.lists[i] = null;
            ++i;
        }
    }

    protected boolean hasChildNodes() {
        return true;
    }

    public void readChildNodesDOMTree(Element element, SpecInfo spec) throws Exception {
        String URI2 = element.getNamespaceURI();
        NodeList childlist = element.getChildNodes();
        int childsize = childlist.getLength();
        String packageName = this.getClass().getPackage().getName();
        int i = 0;
        while (i < 1) {
            Node listNode = null;
            int j = 0;
            while (j < childsize) {
                Node temp = childlist.item(j);
                if (temp.getNodeType() == 1 && temp.getNamespaceURI().equals(URI2) && temp.getLocalName().equals(nospaceListTagName[i])) {
                    listNode = temp;
                    break;
                }
                ++j;
            }
            if (listNode != null && this.lists[i] != null) {
                Vector list = this.lists[i];
                String className = elementClassName[i];
                String tagName = nospaceElementTagName[i];
                NodeList children = listNode.getChildNodes();
                int j2 = 0;
                while (j2 < children.getLength()) {
                    block11: {
                        Node n = children.item(j2);
                        if (n.getNodeType() == 1 && n.getNamespaceURI().equals(URI2) && n.getLocalName().equals(tagName)) {
                            SBase sbase;
                            try {
                                sbase = (SBase)Class.forName(String.valueOf(packageName) + "." + className).newInstance();
                            }
                            catch (ClassNotFoundException ce) {
                                DebugPrinter.println(1, "RNA-readingList-ClassNotFound for <" + tagName + ">: " + ce.getMessage() + ", skip");
                                break block11;
                            }
                            try {
                                LibSBMLUtil.readDOMTree(sbase, (Element)n, spec);
                            }
                            catch (Exception e) {
                                DebugPrinter.println(1, "RNA-readingList-catch reading < " + tagName + "> : " + e.getMessage() + ", skip");
                                break block11;
                            }
                            if (sbase instanceof ModificationRegion) {
                                this.updateTypeToNewVersion((ModificationRegion)sbase);
                            }
                            list.add(sbase);
                        }
                    }
                    ++j2;
                }
            }
            ++i;
        }
    }

    protected void writeChildNodesDOMTree(Node node, SpecInfo spec) throws Exception {
        Document doc = node.getOwnerDocument();
        String URI2 = node.getNamespaceURI();
        int listCount = 1;
        int i = 0;
        while (i < listCount) {
            if (this.lists[i] != null) {
                Vector list = this.lists[i];
                String tagName = "celldesigner:" + nospaceListTagName[i];
                if (list.size() > 0) {
                    Element elem = doc.createElementNS(URI2, tagName);
                    node.appendChild(elem);
                    int j = 0;
                    while (j < list.size()) {
                        SBase sBase = (SBase)list.get(j);
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    protected void updateTypeToNewVersion(ModificationRegion sbase) {
        if ("exon".equals(sbase.getType())) {
            sbase.setType("CodingRegion");
        }
    }

    public static void updateAnnotation(StringBuffer buf, AntiSenseRNA r) {
        if (r.getListOfRegions() == null || r.getListOfRegions().size() == 0) {
            buf.append("<celldesigner:AntisenseRNA id=\"" + r.getId() + "\" name=\"" + StringTool.toEscape(r.getName()) + "\" type=\"" + r.getType() + "\"");
            if (r.getNotes() != null && !r.getNotesString().equals("")) {
                buf.append(">\n");
                buf.append("<celldesigner:notes>\n");
                buf.append("<html xmlns=\"http://www.w3.org/1999/xhtml\">\n");
                buf.append("<head> <title/> </head>\n");
                buf.append("<!--Notes by CellDesigner-->\n");
                buf.append("<body>\n");
                Notes note = (Notes)LibSBMLUtil.getNotes((SBase)r, null);
                buf.append(String.valueOf(note.getText()) + "\n");
                buf.append("</body>\n");
                buf.append("</html>\n");
                buf.append("</celldesigner:notes>\n");
                buf.append("</celldesigner:AntisenseRNA>\n");
            } else {
                buf.append("/>\n");
            }
        } else {
            buf.append("<celldesigner:AntisenseRNA id=\"" + r.getId() + "\" name=\"" + StringTool.toEscape(r.getName()) + "\" type=\"" + r.getType() + "\">\n");
            if (r.getNotes() != null && !r.getNotesString().equals("")) {
                buf.append("<celldesigner:notes>\n");
                buf.append("<html xmlns=\"http://www.w3.org/1999/xhtml\">\n");
                buf.append("<head> <title/> </head>\n");
                buf.append("<!--Notes by CellDesigner-->\n");
                buf.append("<body>\n");
                Notes note = (Notes)LibSBMLUtil.getNotes((SBase)r, null);
                buf.append(String.valueOf(note.getText()) + "\n");
                buf.append("</body>\n");
                buf.append("</html>\n");
                buf.append("</celldesigner:notes>\n");
            }
            buf.append("<celldesigner:listOfRegions>\n");
            int i = 0;
            while (i < r.getListOfRegions().size()) {
                ModificationRegion res = (ModificationRegion)r.getListOfRegions().get(i);
                buf.append("<celldesigner:region id=\"" + res.getId() + "\" name=\"" + StringTool.toEscape(res.getName()) + "\" size=\"" + res.getSize() + "\" pos=\"" + res.getPos() + "\" type=\"" + res.getType() + "\"/>\n");
                ++i;
            }
            buf.append("</celldesigner:listOfRegions>\n");
            buf.append("</celldesigner:AntisenseRNA>\n");
        }
    }
}

