/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.sbgnml;

import java.awt.Polygon;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import jp.fric.graphics.draw.GEditPoint;
import jp.fric.graphics.draw.GEditable;
import jp.fric.graphics.draw.GElement;
import jp.fric.graphics.draw.GLinkedCreaseLine;
import jp.fric.graphics.draw.GLinkedLine;
import jp.fric.graphics.draw.GLinkedLineComplex3;
import jp.fric.graphics.draw.GLinkedShape;
import jp.fric.graphics.draw.GLinkedStraightLine;
import jp.fric.graphics.draw.GStructure;
import jp.sbi.celldesigner.ClosedCompartmentAlias;
import jp.sbi.celldesigner.ComplexSpeciesAlias;
import jp.sbi.celldesigner.MonoSpeciesProperty;
import jp.sbi.celldesigner.MonoSpeciesShape;
import jp.sbi.celldesigner.ReactionLink;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.symbol.reaction.DimerFormation;
import jp.sbi.celldesigner.symbol.reaction.Dissociation;
import jp.sbi.celldesigner.symbol.reaction.StateTransition;
import jp.sbi.celldesigner.symbol.reaction.Truncation;
import jp.sbi.celldesigner.symbol.species.Degraded;
import jp.sbi.celldesigner.symbol.species.Drug;
import jp.sbi.celldesigner.symbol.species.Ion;
import jp.sbi.celldesigner.symbol.species.SimpleMolecule;
import jp.sbi.celldesigner.symbol.species.Tag;
import jp.sbi.celldesigner.symbol.species.Unknown;
import jp.sbi.celldesigner.util.PoliteFileDialog;
import org.sbgn.SbgnUtil;
import org.sbgn.bindings.Arc;
import org.sbgn.bindings.Bbox;
import org.sbgn.bindings.Glyph;
import org.sbgn.bindings.Label;
import org.sbgn.bindings.Map;
import org.sbgn.bindings.Port;
import org.sbgn.bindings.Sbgn;
import org.sbgn.schematron.Issue;
import org.sbgn.schematron.SchematronValidator;
import org.sbml.libsbml.Reaction;
import org.xml.sax.SAXException;

public class CDtoSBGNML {
    private File file;
    private Sbgn sbgn;
    private Map map;
    private SBModel sbModel;
    Vector<?> atoms;
    Vector<?> links;
    Vector<?> containers;
    Vector<?> contAtoms;
    public final String logfilename = "sbgn-log.txt";
    public final float CP_W = 10.0f;
    public final float CP_H = 10.0f;
    public final int UNDEFINED_PORT = -1;
    public final int LEFT_PORT = 0;
    public final int RIGHT_PORT = 1;
    private HashMap<String, SbgnReaction> reacHash;
    private ArrayList<String> logExport;

    public CDtoSBGNML(SBModel sbmdl) {
        this.sbModel = sbmdl;
        this.sbgn = new Sbgn();
        this.map = new Map();
        this.map.setLanguage("process description");
        this.sbgn.setMap(this.map);
        GStructure gs = this.sbModel.getGStructure();
        this.atoms = gs.getAtoms();
        this.links = gs.getLinks();
        this.containers = gs.getContainers();
        this.contAtoms = gs.getContainableAtoms();
        this.reacHash = new HashMap();
        this.logExport = new ArrayList();
        int i = 0;
        while (i < this.links.size()) {
            ReactionLink link = (ReactionLink)this.links.elementAt(i);
            Reaction r = link.getParentReaction();
            if (!this.reacHash.containsKey(r.getId())) {
                SbgnReaction sr;
                Glyph cp;
                if (link.getSymbol() instanceof GLinkedLineComplex3) {
                    GLinkedLineComplex3 gl3 = (GLinkedLineComplex3)((Object)link.getSymbol());
                    cp = this.createConnectionPoint(gl3.getProcessNode().getModificationBounds(), link);
                    GLinkedCreaseLine gcl = (GLinkedCreaseLine)gl3.getLine(0);
                    sr = new SbgnReaction(r, cp, gcl);
                    this.reacHash.put(sr.getId(), sr);
                } else if (link.getSymbol() instanceof GLinkedLine) {
                    System.out.println(String.valueOf(r.getId()) + ":" + link.getSymbol().getClass());
                    if (!(link.getSymbol() instanceof StateTransition)) {
                        System.out.println("  is not StateTransition");
                    } else {
                        StateTransition st = (StateTransition)link.getSymbol();
                        cp = st.getLineSize() == 1 ? this.createConnectionPoint(link) : this.createConnectionPoint(st.getOmittedShape().getModificationBounds(), link);
                        System.err.println("Create CP: " + cp.getId());
                        sr = new SbgnReaction(r, cp, st);
                        this.reacHash.put(sr.getId(), sr);
                    }
                }
            }
            ++i;
        }
    }

    public void export() {
        String path = PoliteFileDialog.getSelectedFilePath("Select file", ".sbgn", 1);
        if (path == null) {
            return;
        }
        this.file = new File(path);
        File logfile = new File(String.valueOf(this.file.getParent()) + File.separator + "sbgn-log.txt");
        this.exportCompartments();
        this.exportSpeciesAliases();
        int i = 0;
        while (i < this.map.getGlyph().size()) {
            System.err.println("DEBUG: listOfGlyphs: " + ((Glyph)this.map.getGlyph().get(i)).getId());
            ++i;
        }
        this.exportComplexSpeciesAliases();
        boolean hasReducedNotation = this.exportReactions();
        if (hasReducedNotation) {
            this.sbModel.getSbframe().showErrorMessage("Reduced Notation is not exported as SBGN-PD.\nPlease see \"sbgn-log.txt\" for deail.");
        }
        try {
            SbgnUtil.writeToFile((Sbgn)this.sbgn, (File)this.file);
        }
        catch (JAXBException e1) {
            e1.printStackTrace();
        }
        if (this.logExport.size() > 0) {
            Iterator<String> it = this.logExport.iterator();
            try {
                PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(logfile)));
                pw.println(new Date() + ": Exporting " + this.sbModel.getSbframe().getFilename() + " to " + this.file);
                while (it.hasNext()) {
                    pw.println(it.next());
                }
                pw.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        this.lowLevelValidation(this.file);
    }

    private void lowLevelValidation(File f) {
        try {
            boolean isValid = SbgnUtil.isValid((File)f, (File)new File("lib/SBGN.xsd"));
            if (isValid) {
                System.out.println("Validation succeeded");
            } else {
                System.out.println("Validation failed");
            }
        }
        catch (JAXBException e1) {
            e1.printStackTrace();
        }
        catch (SAXException e1) {
            e1.printStackTrace();
        }
    }

    private void highLevelValidation(File f) {
        try {
            List issues = SchematronValidator.validate((File)f, (File)new File("lib/sbgn_pd.sch"));
            System.out.println("There are " + issues.size() + " validation problems");
            int i = 0;
            while (i < issues.size()) {
                Issue issue = (Issue)issues.get(i);
                System.out.println(issue);
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    private void setArcStart(Arc arc, Point2D.Double p) {
        Arc.Start arcs = new Arc.Start();
        arcs.setX((float)p.getX());
        arcs.setY((float)p.getY());
        arc.setStart(arcs);
    }

    private void setArcStart(Arc arc, Bbox bb) {
        Arc.Start arcs = new Arc.Start();
        arcs.setX(bb.getX());
        arcs.setY(bb.getY());
        arc.setStart(arcs);
    }

    private void setArcStart(Arc arc, Port port) {
        Arc.Start arcs = new Arc.Start();
        arcs.setX(port.getX());
        arcs.setY(port.getY());
        arc.setStart(arcs);
    }

    private void setArcNext(Arc arc, Point2D.Double p) {
        Arc.Next arcn = new Arc.Next();
        arcn.setX((float)p.getX());
        arcn.setY((float)p.getY());
        arc.getNext().add(arcn);
    }

    private void setArcEnd(Arc arc, Point2D.Double p) {
        Arc.End arce = new Arc.End();
        arce.setX((float)p.getX());
        arce.setY((float)p.getY());
        arc.setEnd(arce);
    }

    private void setArcEnd(Arc arc, Bbox bb) {
        Arc.End arce = new Arc.End();
        arce.setX(bb.getX());
        arce.setY(bb.getY());
        arc.setEnd(arce);
    }

    private void setArcEnd(Arc arc, Port port) {
        Arc.End arce = new Arc.End();
        arce.setX(port.getX());
        arce.setY(port.getY());
        arc.setEnd(arce);
    }

    private SpeciesAlias getSourceSpeciesAlias(ReactionLink link, int index) {
        int n = 0;
        int i = 0;
        while (i < link.getSources().size()) {
            if (link.getSources().get(i) instanceof SpeciesAlias) {
                if (index == n) {
                    return (SpeciesAlias)link.getSources().get(i);
                }
                ++n;
            }
            ++i;
        }
        return null;
    }

    private SpeciesAlias getTargetSpeciesAlias(ReactionLink link, int index) {
        int n = 0;
        int i = 0;
        while (i < link.getDistinations().size()) {
            if (link.getDistinations().get(i) instanceof SpeciesAlias) {
                if (index == n) {
                    return (SpeciesAlias)link.getDistinations().get(i);
                }
                ++n;
            }
            ++i;
        }
        return null;
    }

    private boolean isPointLeftOfCP(Point2D.Double point, Glyph cp) {
        return point.getX() < (double)(cp.getBbox().getX() + cp.getBbox().getW() / 2.0f);
    }

    private Point2D.Double getIntersectionPoint(Glyph g, Point2D.Double startPoint, Point2D.Double endPoint) {
        Bbox b = g.getBbox();
        Polygon poly = new Polygon();
        poly.addPoint((int)b.getX(), (int)b.getY());
        poly.addPoint((int)(b.getX() + b.getW()), (int)b.getY());
        poly.addPoint((int)(b.getX() + b.getW()), (int)(b.getY() + b.getH()));
        poly.addPoint((int)b.getX(), (int)(b.getY() + b.getH()));
        Point2D.Double arrowPoint = endPoint;
        double minDistance = startPoint.distance(endPoint);
        Line2D.Double l2d = new Line2D.Double(startPoint, endPoint);
        try {
            Set<Point2D> intersections = CDtoSBGNML.getIntersections(poly, l2d);
            for (Point2D point : intersections) {
                if (!(startPoint.distance(point) < minDistance)) continue;
                arrowPoint = (Point2D.Double)point;
                minDistance = startPoint.distance(point);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return arrowPoint;
    }

    private void addReactantArc(GLinkedCreaseLine gcl, SbgnReaction sr) {
        Point2D.Double lastPoint = gcl.getEndPoint();
        Arc arc = new Arc();
        arc.setId(String.valueOf(sr.getId()) + "-react" + sr.numReactantArc);
        arc.setClazz("consumption");
        this.setArcStart(arc, lastPoint);
        GLinkedStraightLine[] gsl = gcl.getLines();
        int j = gcl.getLines().length - 1;
        while (j >= 0) {
            lastPoint = gsl[j].getStartPoint();
            this.setArcNext(arc, lastPoint);
            --j;
        }
        arc.setSource((Object)this.findGlyph((SpeciesAlias)gcl.getEndTarget()));
        arc.setTarget(sr.getCp().getPort().get(sr.getPortPositionIn()));
        this.setArcEnd(arc, (Port)sr.getCp().getPort().get(sr.getPortPositionIn()));
        SbgnReaction sbgnReaction = sr;
        sbgnReaction.numReactantArc = sbgnReaction.numReactantArc + 1;
        this.map.getArc().add(arc);
    }

    private void addProductArc(GLinkedCreaseLine gcl, SbgnReaction sr) {
        Arc arc = new Arc();
        arc.setId(String.valueOf(sr.getId()) + "-product" + sr.numProductArc);
        arc.setClazz("production");
        this.setArcStart(arc, (Port)sr.getCp().getPort().get(sr.getPortPositionOut()));
        GLinkedStraightLine[] gsl = gcl.getLines();
        int j = 0;
        while (j < gcl.getLines().length - 1) {
            this.setArcNext(arc, gsl[j].getEndPoint());
            ++j;
        }
        System.err.println("DEBUG complex: " + (SpeciesAlias)gcl.getEndTarget());
        Glyph targetSpeciesGlyph = this.findGlyph((SpeciesAlias)gcl.getEndTarget());
        Point2D.Double p1 = gsl[gsl.length - 1].getStartPoint();
        Point2D.Double p2 = gcl.getEndPoint();
        Point2D.Double arrowPoint = this.getIntersectionPoint(targetSpeciesGlyph, p1, p2);
        System.err.println("Correct Intersection: " + arrowPoint.toString());
        arc.setSource(sr.getCp().getPort().get(sr.getPortPositionOut()));
        arc.setTarget((Object)this.findGlyph((SpeciesAlias)gcl.getEndTarget()));
        this.setArcEnd(arc, arrowPoint);
        SbgnReaction sbgnReaction = sr;
        sbgnReaction.numProductArc = sbgnReaction.numProductArc + 1;
        this.map.getArc().add(arc);
    }

    public boolean isReducedNotation(ReactionLink link) {
        String code = link.getSymbol().getCode();
        return code.contains("REDUCED") || code.equals("POSITIVE_INFLUENCE") || code.equals("UNKNOWN_POSITIVE_INFLUENCE") || code.equals("NEGATIVE_INFLUENCE") || code.equals("UNKNOWN_NEGATIVE_INFLUENCE");
    }

    private boolean exportReactions() {
        boolean rtn = false;
        int i = 0;
        while (i < this.links.size()) {
            ReactionLink link = (ReactionLink)this.links.elementAt(i);
            System.out.println("Reaction " + link.getName());
            System.out.println("  Type   " + link.getSymbol().getCode());
            Reaction r = link.getParentReaction();
            if (this.isReducedNotation(link)) {
                rtn = true;
                this.logExport.add("Skipped " + r.getId() + " because its symbol is " + link.getSymbol().getCode());
            } else {
                SbgnReaction sbgnReac = this.reacHash.get(r.getId());
                SpeciesAlias reactant = this.getSourceSpeciesAlias(link, 0);
                SpeciesAlias product = this.getTargetSpeciesAlias(link, 0);
                if (link.getSymbol() instanceof GLinkedLine) {
                    Arc arc;
                    Glyph cp;
                    Point2D.Double lastPoint;
                    GLinkedLine gl = (GLinkedLine)((Object)link.getSymbol());
                    System.out.println("  " + gl.getStartPoint() + "->" + gl.getEndPoint());
                    GLinkedShape shape = link.getGLinkedShape();
                    GEditPoint[] ep = null;
                    if (shape instanceof GEditable) {
                        ep = ((GEditable)((Object)shape)).getEditPoints();
                    }
                    if (link.getSymbol() instanceof StateTransition) {
                        StateTransition st = (StateTransition)gl;
                        GLinkedStraightLine[] gsl = st.getLines();
                        if (link.isBaseLink()) {
                            Arc arc2 = new Arc();
                            arc2.setId(String.valueOf(r.getId()) + "-react" + sbgnReac.getNumReactantArc());
                            arc2.setClazz("consumption");
                            lastPoint = gl.getStartPoint();
                            this.setArcStart(arc2, lastPoint);
                            int j = 0;
                            while (j < st.getOmittedShapeIndex()) {
                                lastPoint = gsl[j].getEndPoint();
                                this.setArcNext(arc2, lastPoint);
                                ++j;
                            }
                            if (this.findGlyph(reactant) == null) {
                                System.err.println("Can't find Glyph for " + reactant);
                            }
                            arc2.setSource((Object)this.findGlyph(reactant));
                            arc2.setTarget(sbgnReac.getCp().getPort().get(sbgnReac.getPortPositionIn()));
                            this.setArcEnd(arc2, (Port)sbgnReac.getCp().getPort().get(sbgnReac.getPortPositionIn()));
                            SbgnReaction sbgnReaction = sbgnReac;
                            sbgnReaction.numReactantArc = sbgnReaction.numReactantArc + 1;
                            this.map.getArc().add(arc2);
                            arc2 = new Arc();
                            arc2.setId(String.valueOf(r.getId()) + "-product" + sbgnReac.getNumProductArc());
                            arc2.setClazz("production");
                            this.setArcStart(arc2, (Port)sbgnReac.getCp().getPort().get(sbgnReac.getPortPositionOut()));
                            j = st.getOmittedShapeIndex();
                            while (j < st.getLineSize() - 1) {
                                lastPoint = gsl[j].getEndPoint();
                                this.setArcNext(arc2, lastPoint);
                                ++j;
                            }
                            this.setArcEnd(arc2, gl.getEndPoint());
                            arc2.setSource(sbgnReac.getCp().getPort().get(sbgnReac.getPortPositionOut()));
                            arc2.setTarget((Object)this.findGlyph(product));
                            SbgnReaction sbgnReaction2 = sbgnReac;
                            sbgnReaction2.numProductArc = sbgnReaction2.numProductArc + 1;
                            this.map.getArc().add(arc2);
                        }
                    } else if (link.isAddReactantLink()) {
                        Arc arc3 = new Arc();
                        arc3.setId(String.valueOf(r.getId()) + "-addReact" + sbgnReac.getNumReactantArc());
                        arc3.setClazz("consumption");
                        lastPoint = gl.getStartPoint();
                        this.setArcStart(arc3, lastPoint);
                        this.setArcEnd(arc3, (Port)sbgnReac.getCp().getPort().get(sbgnReac.getPortPositionIn()));
                        arc3.setSource((Object)this.findGlyph(reactant));
                        arc3.setTarget(sbgnReac.getCp().getPort().get(sbgnReac.getPortPositionIn()));
                        SbgnReaction sbgnReaction = sbgnReac;
                        sbgnReaction.numReactantArc = sbgnReaction.numReactantArc + 1;
                        this.map.getArc().add(arc3);
                    } else if (link.isAddProductLink()) {
                        cp = this.findGlyph(this.getConnectionPointName(link));
                        arc = new Arc();
                        arc.setId(String.valueOf(r.getId()) + "-addProduct" + sbgnReac.getNumProductArc());
                        arc.setClazz("production");
                        lastPoint = gl.getStartPoint();
                        this.setArcStart(arc, (Port)cp.getPort().get(sbgnReac.getPortPositionOut()));
                        this.setArcEnd(arc, gl.getEndPoint());
                        arc.setSource(cp.getPort().get(sbgnReac.getPortPositionOut()));
                        arc.setTarget((Object)this.findGlyph(product));
                        SbgnReaction sbgnReaction = sbgnReac;
                        sbgnReaction.numProductArc = sbgnReaction.numProductArc + 1;
                        this.map.getArc().add(arc);
                    } else if (link.isModificationLink()) {
                        cp = this.findGlyph(this.getConnectionPointName(link));
                        arc = new Arc();
                        arc.setId(String.valueOf(r.getId()) + "-mod" + sbgnReac.getNumModifierArc());
                        this.setReactionClazz(arc, link);
                        this.setArcStart(arc, gl.getStartPoint());
                        arc.setSource((Object)this.findGlyph(reactant));
                        int j = 0;
                        while (j < ep.length) {
                            GEditPoint gep = ep[j];
                            this.setArcNext(arc, gep.getPosition());
                            ++j;
                        }
                        this.setArcEnd(arc, gl.getEndPoint());
                        arc.setTarget((Object)this.findGlyph(cp.getId()));
                        SbgnReaction sbgnReaction = sbgnReac;
                        sbgnReaction.numModifierArc = sbgnReaction.numModifierArc + 1;
                        this.map.getArc().add(arc);
                    }
                } else if (link.getSymbol() instanceof GLinkedLineComplex3) {
                    System.out.println("  Reaction symbol is GLinkedLineComplex3");
                    GLinkedLineComplex3 gl3 = (GLinkedLineComplex3)((Object)link.getSymbol());
                    GLinkedCreaseLine gcl = (GLinkedCreaseLine)gl3.getLine(0);
                    this.addReactantArc(gcl, sbgnReac);
                    gcl = (GLinkedCreaseLine)gl3.getLine(2);
                    this.addProductArc(gcl, sbgnReac);
                    gcl = (GLinkedCreaseLine)gl3.getLine(1);
                    if (gl3 instanceof DimerFormation) {
                        this.addReactantArc(gcl, sbgnReac);
                    } else if (gl3 instanceof Dissociation || gl3 instanceof Truncation) {
                        this.addProductArc(gcl, sbgnReac);
                    }
                }
            }
            ++i;
        }
        return rtn;
    }

    public static Set<Point2D> getIntersections(Polygon poly, Line2D.Double line) throws Exception {
        PathIterator polyIt = poly.getPathIterator(null);
        double[] coords = new double[6];
        double[] firstCoords = new double[2];
        double[] lastCoords = new double[2];
        HashSet<Point2D> intersections = new HashSet<Point2D>();
        polyIt.currentSegment(firstCoords);
        lastCoords[0] = firstCoords[0];
        lastCoords[1] = firstCoords[1];
        polyIt.next();
        while (!polyIt.isDone()) {
            int type = polyIt.currentSegment(coords);
            switch (type) {
                case 1: {
                    Line2D.Double currentLine = new Line2D.Double(lastCoords[0], lastCoords[1], coords[0], coords[1]);
                    if (currentLine.intersectsLine(line)) {
                        intersections.add(CDtoSBGNML.getIntersection(currentLine, line));
                    }
                    lastCoords[0] = coords[0];
                    lastCoords[1] = coords[1];
                    break;
                }
                case 4: {
                    Line2D.Double currentLine = new Line2D.Double(coords[0], coords[1], firstCoords[0], firstCoords[1]);
                    if (!currentLine.intersectsLine(line)) break;
                    intersections.add(CDtoSBGNML.getIntersection(currentLine, line));
                    break;
                }
                default: {
                    throw new Exception("Unsupported PathIterator segment type.");
                }
            }
            polyIt.next();
        }
        return intersections;
    }

    public static Point2D getIntersection(Line2D.Double line1, Line2D.Double line2) {
        double x1 = line1.x1;
        double y1 = line1.y1;
        double x2 = line1.x2;
        double y2 = line1.y2;
        double x3 = line2.x1;
        double y3 = line2.y1;
        double x4 = line2.x2;
        double y4 = line2.y2;
        double x = ((x2 - x1) * (x3 * y4 - x4 * y3) - (x4 - x3) * (x1 * y2 - x2 * y1)) / ((x1 - x2) * (y3 - y4) - (y1 - y2) * (x3 - x4));
        double y = ((y3 - y4) * (x1 * y2 - x2 * y1) - (y1 - y2) * (x3 * y4 - x4 * y3)) / ((x1 - x2) * (y3 - y4) - (y1 - y2) * (x3 - x4));
        return new Point2D.Double(x, y);
    }

    private Arc setReactionClazz(Arc arc, ReactionLink link) {
        String type = link.getSymbol().getCode();
        if (type.equals("CATALYSIS")) {
            arc.setClazz("catalysis");
        } else if (type.equals("MODULATION")) {
            arc.setClazz("modulation");
        } else if (type.equals("PHYSICAL_STIMULATION")) {
            arc.setClazz("stimulation");
        } else if (type.equals("INHIBITION")) {
            arc.setClazz("inhibition");
        } else if (type.startsWith("BOOLEAN_LOGIC_GATE")) {
            arc.setClazz("logic arc");
        } else {
            arc.setClazz("modulation");
        }
        return arc;
    }

    private Glyph createConnectionPoint(Rectangle2D.Double rect, ReactionLink rl) {
        Bbox bbox = new Bbox();
        bbox.setX((float)rect.getX() + 2.0f);
        bbox.setY((float)rect.getY() + 2.0f);
        bbox.setW(10.0f);
        bbox.setH(10.0f);
        return this.createConnectionPoint(bbox, rl);
    }

    private double halfUp(double d) {
        BigDecimal bi = new BigDecimal(d);
        return bi.setScale(1, 4).doubleValue();
    }

    private Bbox halfUp(Bbox bbox) {
        bbox.setX((float)this.halfUp(bbox.getX()));
        bbox.setY((float)this.halfUp(bbox.getY()));
        return bbox;
    }

    private Glyph createConnectionPoint(ReactionLink rl) {
        Point2D.Double cp = this.getCenterPoint(rl);
        Bbox bbox = new Bbox();
        bbox.setX((float)this.halfUp(cp.getX() - 5.0));
        bbox.setY((float)this.halfUp(cp.getY() - 5.0));
        bbox.setW(10.0f);
        bbox.setH(10.0f);
        return this.createConnectionPoint(bbox, rl);
    }

    private Glyph createConnectionPoint(Bbox bbox, ReactionLink rl) {
        Glyph glyph = new Glyph();
        glyph.setClazz("process");
        glyph.setOrientation("horizontal");
        glyph.setId(this.getConnectionPointName(rl));
        glyph.setBbox(this.halfUp(bbox));
        Port portL = new Port();
        portL.setId(String.valueOf(glyph.getId()) + ".L");
        portL.setX(bbox.getX());
        portL.setY(bbox.getY() + 5.0f);
        glyph.getPort().add(portL);
        Port portR = new Port();
        portR.setId(String.valueOf(glyph.getId()) + ".R");
        portR.setX(bbox.getX() + 10.0f);
        portR.setY(bbox.getY() + 5.0f);
        glyph.getPort().add(portR);
        this.map.getGlyph().add(glyph);
        return glyph;
    }

    private String getConnectionPointName(ReactionLink rl) {
        return "pn" + rl.getParentReaction().getId();
    }

    private Point2D.Double getCenterPoint(ReactionLink rl) {
        if (rl.getSymbol() instanceof GLinkedLine) {
            return this.getCenterPoint((GLinkedLine)((Object)rl.getSymbol()));
        }
        if (rl.getSymbol() instanceof GLinkedLineComplex3) {
            return this.getCenterPoint((GLinkedLineComplex3)((Object)rl.getSymbol()));
        }
        return null;
    }

    private Point2D.Double getCenterPoint(GLinkedLine gl) {
        double x = (gl.getStartPoint().getX() + gl.getEndPoint().getX()) / 2.0;
        double y = (gl.getStartPoint().getY() + gl.getEndPoint().getY()) / 2.0;
        return new Point2D.Double(x, y);
    }

    private Point2D.Double getCenterPoint(GLinkedLineComplex3 gl3) {
        double x = gl3.getMidPoint().getX();
        double y = gl3.getMidPoint().getY();
        return new Point2D.Double(x, y);
    }

    private Glyph findGlyph(String id) {
        int i = 0;
        while (i < this.map.getGlyph().size()) {
            Glyph g = (Glyph)this.map.getGlyph().get(i);
            if (g.getId().equals(id)) {
                return g;
            }
            ++i;
        }
        return null;
    }

    private Glyph findGlyph(SpeciesAlias sa) {
        int i = 0;
        while (i < this.map.getGlyph().size()) {
            Glyph g = (Glyph)this.map.getGlyph().get(i);
            if (g.getId().equals(sa.getName())) {
                return g;
            }
            ++i;
        }
        return null;
    }

    private SpeciesAlias findSpeciesAlias(String saId) {
        int i = 0;
        while (i < this.atoms.size()) {
            SpeciesAlias sa = (SpeciesAlias)this.atoms.get(i);
            if (sa.getName().equals(saId)) {
                return sa;
            }
            ++i;
        }
        System.err.println("Can't find SpeciesAlias: " + saId);
        return null;
    }

    private ComplexSpeciesAlias findComplexSpeciesAlias(String saId) {
        int i = 0;
        while (i < this.contAtoms.size()) {
            ComplexSpeciesAlias sa = (ComplexSpeciesAlias)this.contAtoms.get(i);
            if (sa.getName().equals(saId)) {
                return sa;
            }
            ++i;
        }
        System.err.println("Can't find ComplexSpeciesAlias: " + saId);
        return null;
    }

    private void exportSpeciesAliases() {
        int i = 0;
        while (i < this.atoms.size()) {
            SpeciesAlias alias = (SpeciesAlias)this.atoms.elementAt(i);
            System.out.print(String.valueOf(this.getSpeciesAliasClass(alias)) + " : ");
            String str = "  " + alias.getOriginalSpecies().getName() + "\nX: " + alias.getFrameBounds().getX() + "\nY: " + alias.getFrameBounds().getY();
            System.out.println(str);
            Glyph glyph = new Glyph();
            glyph.setId(alias.getName());
            if (alias.getSpeciesSymbol().isProtein()) {
                glyph.setClazz("macromolecule");
            } else if (alias.isMonoAntiSenseRNA() || alias.isMonoGene() || alias.isMonoRNA()) {
                glyph.setClazz("nucleic acid feature");
            } else if (alias.isPhenotype()) {
                glyph.setClazz("phenotype");
            } else if (this.isSimpleMolecule(alias) || this.isIon(alias) || this.isDrug(alias)) {
                glyph.setClazz("simple chemical");
            } else if (this.isDegraded(alias)) {
                glyph.setClazz("source and sink");
            } else if (this.isTag(alias)) {
                glyph.setClazz("tag");
            } else if (this.isUnknown(alias)) {
                glyph.setClazz("unspecified entity");
            } else if (this.isComplex(alias)) {
                System.err.println("Found complex: " + alias);
                glyph.setClazz("complex");
            } else {
                glyph.setClazz("unspecified entity");
            }
            this.map.getGlyph().add(glyph);
            Bbox bbox = new Bbox();
            bbox.setX((float)alias.getFrameBounds().getX());
            bbox.setY((float)alias.getFrameBounds().getY());
            bbox.setW((float)alias.getFrameBounds().getWidth());
            bbox.setH((float)alias.getFrameBounds().getHeight());
            glyph.setBbox(bbox);
            Label label = new Label();
            label.setText(alias.getOriginalSpecies().getName());
            glyph.setLabel(label);
            ++i;
        }
        i = 0;
        while (i < this.map.getGlyph().size()) {
            Glyph g1 = (Glyph)this.map.getGlyph().get(i);
            SpeciesAlias sa1 = this.findSpeciesAlias(g1.getId());
            int j = i + 1;
            while (j < this.map.getGlyph().size()) {
                Glyph g2 = (Glyph)this.map.getGlyph().get(j);
                SpeciesAlias sa2 = this.findSpeciesAlias(g2.getId());
                if (sa1 != null && sa2 != null && sa1.getOriginalSpecies().getId().equals(sa2.getOriginalSpecies().getId())) {
                    g1.setClone(new Glyph.Clone());
                    g2.setClone(new Glyph.Clone());
                }
                ++j;
            }
            ++i;
        }
    }

    private void exportComplexSpeciesAliases() {
        System.out.println("ContainableAtoms: " + this.contAtoms.size());
        int i = 0;
        while (i < this.contAtoms.size()) {
            System.out.println("ContAtoms: " + this.contAtoms.elementAt(i));
            ComplexSpeciesAlias alias = (ComplexSpeciesAlias)this.contAtoms.elementAt(i);
            System.out.print(String.valueOf(this.getSpeciesAliasClass(alias)) + " : ");
            String str = "  " + alias.getOriginalSpecies().getName() + "\nX: " + alias.getFrameBounds().getX() + "\nY: " + alias.getFrameBounds().getY();
            System.out.println(str);
            Glyph glyph = new Glyph();
            glyph.setId(alias.getName());
            glyph.setClazz("complex");
            this.map.getGlyph().add(glyph);
            Bbox bbox = new Bbox();
            bbox.setX((float)alias.getFrameBounds().getX());
            bbox.setY((float)alias.getFrameBounds().getY());
            bbox.setW((float)alias.getFrameBounds().getWidth());
            bbox.setH((float)alias.getFrameBounds().getHeight());
            glyph.setBbox(bbox);
            Label label = new Label();
            label.setText(alias.getOriginalSpecies().getName());
            glyph.setLabel(label);
            ++i;
        }
        i = 0;
        while (i < this.map.getGlyph().size()) {
            Glyph g1 = (Glyph)this.map.getGlyph().get(i);
            ComplexSpeciesAlias sa1 = this.findComplexSpeciesAlias(g1.getId());
            int j = i + 1;
            while (j < this.map.getGlyph().size()) {
                Glyph g2 = (Glyph)this.map.getGlyph().get(j);
                ComplexSpeciesAlias sa2 = this.findComplexSpeciesAlias(g2.getId());
                if (sa1 != null && sa2 != null && sa1.getOriginalSpecies().getId().equals(sa2.getOriginalSpecies().getId())) {
                    g1.setClone(new Glyph.Clone());
                    g2.setClone(new Glyph.Clone());
                }
                ++j;
            }
            ++i;
        }
    }

    public String getSpeciesAliasClass(SpeciesAlias sa) {
        MonoSpeciesShape mono = (MonoSpeciesShape)sa.getGFramedShape();
        MonoSpeciesProperty monoprop = (MonoSpeciesProperty)mono.getProperty();
        return monoprop.getType();
    }

    private void exportCompartments() {
        int i = 0;
        while (i < this.containers.size()) {
            GElement container = (GElement)this.containers.elementAt(i);
            if (container instanceof ClosedCompartmentAlias) {
                ClosedCompartmentAlias ca = (ClosedCompartmentAlias)container;
                System.out.println("Id:   " + ca.getName());
                System.out.println("Name: " + ca.getOriginalCompartment().getName());
                System.out.println("Pos:  " + ca.getFramePosition());
                System.out.println("Size: " + ca.getFrameSize());
                System.out.println(ca.getCompartmentNameDefaultDisplayPostion());
                Glyph glyph = new Glyph();
                glyph.setId(ca.getName());
                glyph.setClazz("compartment");
                this.map.getGlyph().add(glyph);
                Bbox bbox = new Bbox();
                bbox.setX((float)ca.getFrameBounds().getX());
                bbox.setY((float)ca.getFrameBounds().getY());
                bbox.setW((float)ca.getFrameBounds().getWidth());
                bbox.setH((float)ca.getFrameBounds().getHeight());
                glyph.setBbox(bbox);
                Label label = new Label();
                label.setText(ca.getOriginalCompartment().getName());
                Bbox lbox = new Bbox();
                lbox.setX((float)ca.getCompartmentNameDefaultDisplayPostion().getX());
                lbox.setY((float)ca.getCompartmentNameDefaultDisplayPostion().getY());
                lbox.setW((float)(8 * ca.getCompartmentName().length()));
                lbox.setH(12.0f);
                label.setBbox(lbox);
                glyph.setLabel(label);
            }
            ++i;
        }
    }

    public boolean isSimpleMolecule(SpeciesAlias sa) {
        return sa.getSpeciesSymbol() instanceof SimpleMolecule;
    }

    public boolean isIon(SpeciesAlias sa) {
        return sa.getSpeciesSymbol() instanceof Ion;
    }

    public boolean isDegraded(SpeciesAlias sa) {
        return sa.getSpeciesSymbol() instanceof Degraded;
    }

    public boolean isDrug(SpeciesAlias sa) {
        return sa.getSpeciesSymbol() instanceof Drug;
    }

    public boolean isComplex(SpeciesAlias sa) {
        return sa.getSpeciesSymbol() instanceof ComplexSpeciesAlias;
    }

    public boolean isTag(SpeciesAlias sa) {
        return sa.getSpeciesSymbol() instanceof Tag;
    }

    public boolean isUnknown(SpeciesAlias sa) {
        return sa.getSpeciesSymbol() instanceof Unknown;
    }

    public class SbgnReaction {
        public final int UNDEFINED_PORT = -1;
        public final int LEFT_PORT = 0;
        public final int RIGHT_PORT = 1;
        private int portPositionIn = -1;
        private int portPositionOut = -1;
        private Reaction reaction;
        private String id;
        private Glyph cp;
        private int numReactantArc = 0;
        private int numProductArc = 0;
        private int numModifierArc = 0;

        public SbgnReaction(Reaction r) {
            this.reaction = r;
            this.id = r.getId();
        }

        public SbgnReaction(Reaction r, Glyph cp, GLinkedCreaseLine gcl) {
            this(r);
            this.cp = cp;
            GLinkedStraightLine[] gsl = gcl.getLines();
            Point2D.Double lastPoint = gsl[gsl.length - 1].getStartPoint();
            if (cDtoSBGNML.isPointLeftOfCP(lastPoint, cp)) {
                this.portPositionIn = 0;
                this.portPositionOut = 1;
            } else {
                this.portPositionIn = 1;
                this.portPositionOut = 0;
            }
        }

        public int getNumReactantArc() {
            return this.numReactantArc;
        }

        public int getNumProductArc() {
            return this.numProductArc;
        }

        public int getNumModifierArc() {
            return this.numModifierArc;
        }

        public int getPortPositionIn() {
            return this.portPositionIn;
        }

        public int getPortPositionOut() {
            return this.portPositionOut;
        }

        public Glyph getCp() {
            return this.cp;
        }

        public Reaction getReaction() {
            return this.reaction;
        }

        public void setReaction(Reaction reaction) {
            this.reaction = reaction;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }
    }
}

