/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.plugin.util;

import java.awt.Color;
import java.awt.Dimension;
import jp.sbi.celldesigner.SBFactory;
import jp.sbi.celldesigner.SpeciesSymbol;
import jp.sbi.celldesigner.plugin.PluginProtein;
import jp.sbi.celldesigner.plugin.PluginSpecies;
import jp.sbi.celldesigner.plugin.PluginSpeciesAlias;
import jp.sbi.celldesigner.symbol.color.SpeciesColorScheme;

public class PluginSpeciesSymbolType {
    public static final String PROTEIN = "PROTEIN";
    public static final String PROTEIN_GENERIC = "GENERIC";
    public static final String PROTEIN_RECEPTOR = "RECEPTOR";
    public static final String PROTEIN_ION_CHANNEL = "ION_CHANNEL";
    public static final String PROTEIN_TRUNCATED = "TRUNCATED";
    public static final String GENE = "GENE";
    public static final String RNA = "RNA";
    public static final String ANTISENSE_RNA = "ANTISENSE_RNA";
    public static final String PHENOTYPE = "PHENOTYPE";
    public static final String ION = "ION";
    public static final String SIMPLE_MOLECULE = "SIMPLE_MOLECULE";
    public static final String UNKNOWN = "UNKNOWN";
    public static final String COMPLEX = "COMPLEX";
    public static final String DEGRADED = "DEGRADED";
    public static final String DRUG = "DRUG";

    public static boolean isValidSpeciesAliasType(PluginSpeciesAlias sp) {
        if (sp.getType() == null) {
            return false;
        }
        return sp.getType().equals(ANTISENSE_RNA) || sp.getType().equals(COMPLEX) || sp.getType().equals(GENE) || sp.getType().equals(ION) || sp.getType().equals(PHENOTYPE) || sp.getType().equals(RNA) || sp.getType().equals(SIMPLE_MOLECULE) || sp.getType().equals(UNKNOWN) || sp.getType().equals(PROTEIN) || sp.getType().equals(PROTEIN_GENERIC) || sp.getType().equals(PROTEIN_ION_CHANNEL) || sp.getType().equals(PROTEIN_RECEPTOR) || sp.getType().equals(PROTEIN_TRUNCATED) || sp.getType().equals(DEGRADED);
    }

    public static boolean isValidSpeciesType(PluginSpecies sp) {
        String type = sp.getSpeciesAlias(0).getExtensionType();
        if (type == null) {
            return false;
        }
        if (type.equals(PROTEIN_GENERIC) || type.equals(PROTEIN_ION_CHANNEL) || type.equals(PROTEIN_RECEPTOR) || type.equals(PROTEIN_TRUNCATED)) {
            type = PROTEIN;
        }
        return type.equals(ANTISENSE_RNA) || type.equals(COMPLEX) || type.equals(GENE) || type.equals(ION) || type.equals(PHENOTYPE) || type.equals(RNA) || type.equals(SIMPLE_MOLECULE) || type.equals(PROTEIN) || type.equals(UNKNOWN) || type.equals(DEGRADED) || type.equals(DRUG);
    }

    public static boolean isValidProteinsType(PluginProtein sp) {
        if (sp.getType() == null) {
            return false;
        }
        return sp.getType().equals(PROTEIN_GENERIC) || sp.getType().equals(PROTEIN_ION_CHANNEL) || sp.getType().equals(PROTEIN_RECEPTOR) || sp.getType().equals(PROTEIN_TRUNCATED);
    }

    public static Dimension getDefaultSize(String speciesType) {
        SpeciesSymbol briefSymbol = (SpeciesSymbol)((Object)SBFactory.createSymbol(speciesType));
        return briefSymbol.defaultSize();
    }

    public static Color getDefaultColor(String speciesType) {
        return SpeciesColorScheme.getDefaultColor(speciesType);
    }

    public static double getDefaultLineWidth(String speciesType) {
        return SpeciesColorScheme.getDefaultLineWidth(speciesType);
    }
}

