/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.plugin.util;

import jp.sbi.celldesigner.plugin.PluginModifierSpeciesReference;
import jp.sbi.celldesigner.plugin.PluginReaction;
import jp.sbi.celldesigner.plugin.PluginSimpleSpeciesReference;

public class PluginReactionSymbolType {
    public static final String STATE_TRANSITION = "STATE_TRANSITION";
    public static final String KNOWN_TRANSITION_OMITTED = "KNOWN_TRANSITION_OMITTED";
    public static final String UNKNOWN_TRANSITION = "UNKNOWN_TRANSITION";
    public static final String CATALYSIS = "CATALYSIS";
    public static final String UNKNOWN_CATALYSIS = "UNKNOWN_CATALYSIS";
    public static final String INHIBITION = "INHIBITION";
    public static final String UNKNOWN_INHIBITION = "UNKNOWN_INHIBITION";
    public static final String TRANSPORT = "TRANSPORT";
    public static final String TRANSCRIPTION = "TRANSCRIPTION";
    public static final String TRANSLATION = "TRANSLATION";
    public static final String ADD_REACTANT = "ADD_REACTANT";
    public static final String ADD_PRODUCT = "ADD_PRODUCT";
    public static final String HETERODIMER_ASSOCIATION = "HETERODIMER_ASSOCIATION";
    public static final String DISSOCIATION = "DISSOCIATION";
    public static final String TRUNCATION = "TRUNCATION";
    public static final String HOMODIMER_FORMATION = "HOMODIMER_FORMATION";
    public static final String DEGRADATION = "DEGRADATION";
    public static final String BOOLEAN_LOGIC_GATE_AND = "BOOLEAN_LOGIC_GATE_AND";
    public static final String BOOLEAN_LOGIC_GATE_OR = "BOOLEAN_LOGIC_GATE_OR";
    public static final String BOOLEAN_LOGIC_GATE_UNKNOWN = "BOOLEAN_LOGIC_GATE_UNKNOWN";
    public static final String BOOLEAN_LOGIC_GATE_NOT = "BOOLEAN_LOGIC_GATE_NOT";
    public static final String TRIGGER = "TRIGGER";
    public static final String PHYSICAL_STIMULATION = "PHYSICAL_STIMULATION";
    public static final String MODULATION = "MODULATION";
    public static final String NEGATIVE_INFLUENCE = "NEGATIVE_INFLUENCE";
    public static final String POSITIVE_INFLUENCE = "POSITIVE_INFLUENCE";
    public static final String REDUCED_MODULATION = "REDUCED_MODULATION";
    public static final String REDUCED_PHYSICAL_STIMULATION = "REDUCED_PHYSICAL_STIMULATION";
    public static final String REDUCED_TRIGGER = "REDUCED_TRIGGER";
    public static final String UNKNOWN_NEGATIVE_INFLUENCE = "UNKNOWN_NEGATIVE_INFLUENCE";
    public static final String UNKNOWN_POSITIVE_INFLUENCE = "UNKNOWN_POSITIVE_INFLUENCE";
    public static final String UNKNOWN_REDUCED_MODULATION = "UNKNOWN_REDUCED_MODULATION";
    public static final String UNKNOWN_REDUCED_PHYSICAL_STIMULATION = "UNKNOWN_REDUCED_PHYSICAL_STIMULATION";
    public static final String UNKNOWN_REDUCED_TRIGGER = "UNKNOWN_REDUCED_TRIGGER";

    public static boolean isValidReaction(PluginReaction re) {
        if (!PluginReactionSymbolType.isValidReactionType(re)) {
            return false;
        }
        return !(re.getReactionType().equals(HETERODIMER_ASSOCIATION) ? re.getNumReactants() < 2 || re.getNumProducts() < 1 : (re.getReactionType().equals(DISSOCIATION) || re.getReactionType().equals(TRUNCATION) ? re.getNumReactants() < 1 || re.getNumProducts() < 2 : re.getNumReactants() < 1 || re.getNumProducts() < 1));
    }

    public static boolean isValidModifierType(PluginSimpleSpeciesReference sp) {
        if (sp instanceof PluginModifierSpeciesReference) {
            PluginModifierSpeciesReference ref = (PluginModifierSpeciesReference)sp;
            if (ref.getModificationType() == null) {
                return false;
            }
            return ref.getModificationType().equals(CATALYSIS) || ref.getModificationType().equals(NEGATIVE_INFLUENCE) || ref.getModificationType().equals(POSITIVE_INFLUENCE) || ref.getModificationType().equals(REDUCED_MODULATION) || ref.getModificationType().equals(REDUCED_PHYSICAL_STIMULATION) || ref.getModificationType().equals(REDUCED_TRIGGER) || ref.getModificationType().equals(UNKNOWN_NEGATIVE_INFLUENCE) || ref.getModificationType().equals(UNKNOWN_POSITIVE_INFLUENCE) || ref.getModificationType().equals(UNKNOWN_REDUCED_MODULATION) || ref.getModificationType().equals(UNKNOWN_REDUCED_PHYSICAL_STIMULATION) || ref.getModificationType().equals(UNKNOWN_REDUCED_TRIGGER) || ref.getModificationType().equals(INHIBITION) || ref.getModificationType().equals(KNOWN_TRANSITION_OMITTED) || ref.getModificationType().equals(STATE_TRANSITION) || ref.getModificationType().equals(TRANSCRIPTION) || ref.getModificationType().equals(TRANSLATION) || ref.getModificationType().equals(TRANSPORT) || ref.getModificationType().equals(UNKNOWN_CATALYSIS) || ref.getModificationType().equals(UNKNOWN_INHIBITION) || ref.getModificationType().equals(TRIGGER) || ref.getModificationType().equals(BOOLEAN_LOGIC_GATE_NOT) || ref.getModificationType().equals(PHYSICAL_STIMULATION) || ref.getModificationType().equals(MODULATION) || ref.getModificationType().equals(UNKNOWN_TRANSITION) || ref.getModificationType().equals(BOOLEAN_LOGIC_GATE_AND) || ref.getModificationType().equals(BOOLEAN_LOGIC_GATE_OR) || ref.getModificationType().equals(BOOLEAN_LOGIC_GATE_UNKNOWN);
        }
        return true;
    }

    public static boolean isValidReactionType(PluginReaction sp) {
        int i = 0;
        while (i < sp.getNumModifiers()) {
            PluginModifierSpeciesReference ref = sp.getModifier(i);
            if (!PluginReactionSymbolType.isValidModifierType(ref)) {
                return false;
            }
            ++i;
        }
        if (sp.getReactionType() == null) {
            return false;
        }
        if (sp.getReactionType().equals(CATALYSIS) || sp.getReactionType().equals(NEGATIVE_INFLUENCE) || sp.getReactionType().equals(POSITIVE_INFLUENCE) || sp.getReactionType().equals(REDUCED_MODULATION) || sp.getReactionType().equals(REDUCED_PHYSICAL_STIMULATION) || sp.getReactionType().equals(REDUCED_TRIGGER) || sp.getReactionType().equals(UNKNOWN_NEGATIVE_INFLUENCE) || sp.getReactionType().equals(UNKNOWN_POSITIVE_INFLUENCE) || sp.getReactionType().equals(UNKNOWN_REDUCED_MODULATION) || sp.getReactionType().equals(UNKNOWN_REDUCED_PHYSICAL_STIMULATION) || sp.getReactionType().equals(UNKNOWN_REDUCED_TRIGGER) || sp.getReactionType().equals(DEGRADATION) || sp.getReactionType().equals(DISSOCIATION) || sp.getReactionType().equals(HETERODIMER_ASSOCIATION) || sp.getReactionType().equals(HOMODIMER_FORMATION) || sp.getReactionType().equals(INHIBITION) || sp.getReactionType().equals(KNOWN_TRANSITION_OMITTED) || sp.getReactionType().equals(STATE_TRANSITION) || sp.getReactionType().equals(TRANSCRIPTION) || sp.getReactionType().equals(TRANSLATION) || sp.getReactionType().equals(TRIGGER) || sp.getReactionType().equals(TRANSPORT) || sp.getReactionType().equals(TRUNCATION) || sp.getReactionType().equals(UNKNOWN_CATALYSIS) || sp.getReactionType().equals(UNKNOWN_INHIBITION) || sp.getReactionType().equals(UNKNOWN_TRANSITION)) {
            return true;
        }
        if (sp.getReactionType().equals(PHYSICAL_STIMULATION)) {
            String recatanttype = sp.getReactant(0).getAlias().getType();
            String producttype = sp.getProduct(0).getAlias().getType();
            if (!recatanttype.equals("PHENOTYPE") && producttype.equals("PHENOTYPE")) {
                return true;
            }
        }
        return false;
    }
}

