/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.plugin.simulation;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import jp.co.mki.celldesigner.simulation.SBMLResults;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.SBMLFiler;
import jp.sbi.celldesigner.plugin.PluginModel;
import jp.sbi.celldesigner.soslib.SOSlib;
import jp.sbi.celldesigner.soslib.SOSlibException;
import org.sbml.libsbml.SBMLDocument;
import org.sbml.libsbml.SBMLWriter;

public class PluginSimulation {
    private File tmpFile;
    private PluginModel model;
    private double endTime = 100.0;
    private long numOfSteps = 20L;
    private String relativeTolerance = "1e-10";
    private String outputFile = "plugin_simulation_result.txt";
    private SBMLResults simResults;

    public PluginSimulation(PluginModel m) {
        this.model = m;
    }

    public PluginSimulation(PluginModel m, double endtime, long numstep) {
        this.model = m;
        this.endTime = endtime;
        this.numOfSteps = numstep;
    }

    private String[] generateSettings() {
        String[] cvodeSet = new String[15];
        cvodeSet[0] = "dummy";
        cvodeSet[1] = this.tmpFile.getPath();
        cvodeSet[2] = String.valueOf(this.endTime);
        cvodeSet[3] = String.valueOf(this.numOfSteps);
        cvodeSet[4] = this.relativeTolerance;
        return cvodeSet;
    }

    private void generateInputFile() {
        try {
            this.tmpFile = File.createTempFile("plugSim", ".xml");
            SBMLDocument d = MainWindow.getTargetSBModelFrame(this.model).getSBModel().getSBMLDocument();
            if (!SBMLFiler.isAllowedFileName(this.tmpFile.getAbsolutePath())) {
                try {
                    OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(this.tmpFile.getAbsolutePath()), "UTF-8");
                    SBMLWriter writer = new SBMLWriter();
                    out.write(writer.writeToString(d));
                    out.close();
                    out = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                SBMLWriter writer = new SBMLWriter();
                writer.writeSBML(d, this.tmpFile.getAbsolutePath());
                writer.delete();
                Object var2_5 = null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.tmpFile.deleteOnExit();
    }

    public void runSimulation() {
        try {
            this.generateInputFile();
            String[] cvodeSet = this.generateSettings();
            this.simResults = SOSlib.solveOde2(cvodeSet);
            this.simResults.outputFile(this.outputFile);
            this.simResults.printSpeciesConcentration();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SOSlibException e) {
            e.printStackTrace();
        }
    }

    public double getEndTime() {
        return this.endTime;
    }

    public void setEndTime(double endTime) {
        this.endTime = endTime;
    }

    public long getNumOfSteps() {
        return this.numOfSteps;
    }

    public void setNumOfSteps(long numstep) {
        this.numOfSteps = numstep;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }
}

