/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.plugin;

import java.awt.Color;
import java.awt.Dimension;
import java.util.Vector;
import jp.sbi.celldesigner.ComplexSpeciesAlias;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.MonoSpeciesProperty;
import jp.sbi.celldesigner.MonoSpeciesShape;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.SBModelFrame;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.plugin.PluginAntiSenseRNA;
import jp.sbi.celldesigner.plugin.PluginGene;
import jp.sbi.celldesigner.plugin.PluginInformationBox;
import jp.sbi.celldesigner.plugin.PluginListOf;
import jp.sbi.celldesigner.plugin.PluginModel;
import jp.sbi.celldesigner.plugin.PluginModification;
import jp.sbi.celldesigner.plugin.PluginProtein;
import jp.sbi.celldesigner.plugin.PluginRNA;
import jp.sbi.celldesigner.plugin.PluginSBase;
import jp.sbi.celldesigner.plugin.PluginSBaseConverter;
import jp.sbi.celldesigner.plugin.PluginSpecies;
import jp.sbi.celldesigner.plugin.PluginStructuralState;
import jp.sbi.celldesigner.plugin.util.PluginSpeciesSymbolType;
import jp.sbi.celldesigner.sbmlExtension.Modification;
import jp.sbi.celldesigner.sbmlExtension.StructuralState;
import jp.sbi.celldesigner.util.CelldUtil;
import org.sbml.libsbml.XMLNode;

public class PluginSpeciesAlias
extends PluginSBase {
    private String aliasId;
    private PluginSpecies parentSpecies;
    private String type;
    private String name;
    private int homodimer;
    private boolean hypothetical;
    private Color color;
    private double frameLineWidth;
    private double width;
    private double height;
    private double x;
    private double y;
    private PluginProtein protein;
    private PluginGene gene;
    private PluginRNA rna;
    private PluginAntiSenseRNA asrna;
    private PluginListOf modifications;
    private boolean isActive;
    private PluginListOf listOfPluginStructuralStates;
    private PluginInformationBox pluginInformationBox;
    private Vector includedPluginSpeciesAliases = null;

    public Vector getAllIncludedSpeciesAliases() {
        return this.includedPluginSpeciesAliases;
    }

    public void setAllIncludedSpeciesAliases(Vector includeds) {
        this.includedPluginSpeciesAliases = includeds;
    }

    public PluginSpeciesAlias(PluginSpecies parent, String type) {
        SBModel sbModel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
        this.aliasId = sbModel.createNewAliasId();
        this.parentSpecies = parent;
        this.name = parent.getName();
        this.frameLineWidth = 1.0;
        this.x = 0.0;
        this.y = 0.0;
        this.isActive = false;
        try {
            this.type = type;
            if (type == null || type.equals("PROTEIN")) {
                this.type = "GENERIC";
            }
            Dimension d = PluginSpeciesSymbolType.getDefaultSize(type);
            this.width = d.width;
            this.height = d.height;
            this.color = PluginSpeciesSymbolType.getDefaultColor(type);
        }
        catch (Exception e) {
            this.width = -1.0;
            this.height = -1.0;
            this.color = Color.GRAY;
        }
        this.homodimer = 1;
        this.hypothetical = false;
        this.modifications = new PluginListOf();
        this.listOfPluginStructuralStates = new PluginListOf();
        this.pluginInformationBox = new PluginInformationBox();
    }

    protected PluginSpeciesAlias(SpeciesAlias speciesAlias, PluginSpecies parent) {
        this.aliasId = speciesAlias.getName();
        this.parentSpecies = parent;
        MonoSpeciesShape mono = (MonoSpeciesShape)speciesAlias.getGFramedShape();
        this.width = mono.getFrameBounds().width;
        this.height = mono.getFrameBounds().height;
        this.x = mono.getFrameBounds().x;
        this.y = mono.getFrameBounds().y;
        this.frameLineWidth = mono.getLineWidth();
        this.color = mono.getColor();
        this.isActive = speciesAlias.isActive();
        MonoSpeciesProperty property = (MonoSpeciesProperty)mono.getProperty();
        if (property.getProtein() != null) {
            this.protein = PluginSBaseConverter.convertToPluginProtein(property.getProtein());
        } else if (property.getGene() != null) {
            this.gene = PluginSBaseConverter.convertToPluginGene(property.getGene());
        } else if (property.getRNA() != null) {
            this.rna = PluginSBaseConverter.convertToPluginRNA(property.getRNA());
        } else if (property.getAntiSenseRNA() != null) {
            this.asrna = PluginSBaseConverter.convertToPluginAntiSenseRNA(property.getAntiSenseRNA());
        }
        this.name = property.getName();
        this.homodimer = property.getHomodimer();
        this.hypothetical = property.getHypothetical();
        this.type = property.getType();
        this.modifications = new PluginListOf();
        this.listOfPluginStructuralStates = new PluginListOf();
        this.pluginInformationBox = new PluginInformationBox();
        int i = 0;
        while (i < property.getModifications().size()) {
            Modification m = (Modification)property.getModifications().get(i);
            PluginModification pm = new PluginModification();
            pm.clone(m);
            int j = 0;
            while (j < property.getStructuralStates().size()) {
                StructuralState state = (StructuralState)property.getStructuralStates().get(j);
                PluginStructuralState pstate = new PluginStructuralState();
                pstate.clone(state);
                ++j;
            }
            this.modifications.append(pm);
            ++i;
        }
    }

    public void update(PluginSpeciesAlias target) {
        this.aliasId = target.aliasId;
        this.name = target.name;
        this.type = target.type;
        this.width = target.width;
        this.height = target.height;
        this.x = target.x;
        this.y = target.y;
        this.frameLineWidth = target.frameLineWidth;
        this.color = target.color;
        this.homodimer = target.homodimer;
        this.hypothetical = target.hypothetical;
        this.protein = target.protein;
        this.gene = target.gene;
        this.rna = target.rna;
        this.asrna = target.asrna;
        this.modifications = target.getModifications();
        this.isActive = target.isActive();
        this.listOfPluginStructuralStates = target.getPluginListOfStructuralStates();
        this.pluginInformationBox = target.getPluginInformationBox();
    }

    public PluginSpecies getSpecies() {
        return this.parentSpecies;
    }

    protected void setSpecies(PluginSpecies parentSpecies) {
        this.parentSpecies = parentSpecies;
    }

    public String getType() {
        return this.type;
    }

    public String getExtensionType() {
        if (this.protein != null) {
            return this.protein.getType();
        }
        if (this.gene != null) {
            return this.gene.getType();
        }
        if (this.rna != null) {
            return this.rna.getType();
        }
        if (this.asrna != null) {
            return this.asrna.getType();
        }
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setName(String name) {
        this.name = name;
        this.parentSpecies.setName(name);
    }

    public String getName() {
        return this.name;
    }

    public String getAliasID() {
        return this.aliasId;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setFrameSize(double width, double height) {
        this.width = width;
        this.height = height;
    }

    public void setFramePosition(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public int getHomodimer() {
        return this.homodimer;
    }

    public void setHomodimer(int homodimer) {
        this.homodimer = homodimer;
    }

    public boolean getHypothetical() {
        return this.hypothetical;
    }

    public void setHypothetical(boolean hypothetical) {
        this.hypothetical = hypothetical;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public double getFrameLineWidth() {
        return this.frameLineWidth;
    }

    public void setFrameLineWidth(double lineWidth) {
        this.frameLineWidth = lineWidth;
    }

    public String getExtensionId() {
        if (this.protein != null) {
            return this.protein.getExtensionId();
        }
        if (this.gene != null) {
            return this.gene.getExtensionId();
        }
        if (this.rna != null) {
            return this.rna.getExtensionId();
        }
        if (this.asrna != null) {
            return this.asrna.getExtensionId();
        }
        return null;
    }

    public PluginAntiSenseRNA getAntiSenseRNA() {
        return this.asrna;
    }

    public void setAntiSenseRNA(PluginAntiSenseRNA asrna) {
        this.asrna = asrna;
        this.protein = null;
        this.rna = null;
        this.gene = null;
        if (asrna != null) {
            this.setType("ANTISENSE_RNA");
        }
    }

    public PluginGene getGene() {
        return this.gene;
    }

    public void setGene(PluginGene gene) {
        this.gene = gene;
        this.asrna = null;
        this.protein = null;
        this.rna = null;
        if (gene != null) {
            this.setType("GENE");
        }
    }

    public PluginProtein getProtein() {
        return this.protein;
    }

    public void setProtein(PluginProtein protein) {
        this.protein = protein;
        this.asrna = null;
        this.rna = null;
        this.gene = null;
        if (protein != null) {
            this.setType("PROTEIN");
        }
    }

    public PluginRNA getRNA() {
        return this.rna;
    }

    public void setRNA(PluginRNA rna) {
        this.rna = rna;
        this.asrna = null;
        this.protein = null;
        this.gene = null;
        if (rna != null) {
            this.setType("RNA");
        }
    }

    @Override
    public String getNotesString() {
        return " ";
    }

    @Override
    public XMLNode getNotes() {
        return new XMLNode();
    }

    public PluginListOf getModifications() {
        return this.modifications;
    }

    public void setModifications(PluginListOf modifications) {
        this.modifications = modifications;
    }

    public void setIsActive(boolean activity) {
        this.isActive = activity;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public PluginListOf getPluginListOfStructuralStates() {
        return this.listOfPluginStructuralStates;
    }

    public void setPluginListOfStructuralStates(PluginListOf _listOfPluginStructuralStates) {
        this.listOfPluginStructuralStates = _listOfPluginStructuralStates;
    }

    public PluginInformationBox getPluginInformationBox() {
        return this.pluginInformationBox;
    }

    public void setPluginInformationBox(PluginInformationBox _PluginInformationBox) {
        this.pluginInformationBox = _PluginInformationBox;
    }

    public static final Vector resetAllIncludedPluginSpeciesAliases(PluginModel pluginMode, PluginSpeciesAlias someone) {
        if (pluginMode == null) {
            return null;
        }
        if (someone == null) {
            return null;
        }
        SBModelFrame sbframe = CelldUtil.getSBModelFrame(pluginMode);
        if (sbframe == null) {
            return null;
        }
        SBModel sbModel = sbframe.getSBModel();
        if (sbModel == null) {
            return null;
        }
        return PluginSpeciesAlias.resetAllIncludedPluginSpeciesAliases(sbModel, pluginMode, someone);
    }

    private static final Vector resetAllIncludedPluginSpeciesAliases(SBModel sbModel, PluginModel pluginMode, PluginSpeciesAlias someone) {
        try {
            someone.setAllIncludedSpeciesAliases(null);
            SpeciesAlias speciesAlias = CelldUtil.getRealSpeciesAlias(sbModel, someone);
            Vector targets = null;
            if (speciesAlias instanceof ComplexSpeciesAlias) {
                ComplexSpeciesAlias complex = (ComplexSpeciesAlias)speciesAlias;
                targets = complex.getTargets();
                someone.setAllIncludedSpeciesAliases(new Vector());
                if (targets != null && targets.size() > 0) {
                    int i = 0;
                    while (i < targets.size()) {
                        SpeciesAlias aInner = (SpeciesAlias)targets.get(i);
                        PluginSpeciesAlias aPluginInner = pluginMode.getPluginSpeciesAlias(aInner.getName());
                        PluginSpeciesAlias.resetAllIncludedPluginSpeciesAliases(sbModel, pluginMode, aPluginInner);
                        someone.getAllIncludedSpeciesAliases().add(aPluginInner);
                        ++i;
                    }
                }
            }
            return someone.getAllIncludedSpeciesAliases();
        }
        catch (Exception myErr) {
            return null;
        }
    }
}

