/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.plugin;

import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.plugin.PluginAntiSenseRNA;
import jp.sbi.celldesigner.plugin.PluginGene;
import jp.sbi.celldesigner.plugin.PluginListOf;
import jp.sbi.celldesigner.plugin.PluginProtein;
import jp.sbi.celldesigner.plugin.PluginRNA;
import jp.sbi.celldesigner.plugin.PluginSBase;
import jp.sbi.celldesigner.plugin.PluginSpeciesAlias;
import org.sbml.libsbml.Species;

public class PluginSpecies
extends PluginSBase {
    private String positionToCompartment;
    private PluginListOf listOfPluginSpeciesAlias;

    public PluginSpecies(String type, String name) {
        this.sbase = new Species();
        SBModel sbModel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
        ((Species)this.sbase).setId(sbModel.createNewSpeciesId());
        ((Species)this.sbase).setName(name);
        this.setCompartment("default");
        PluginSpeciesAlias alias = new PluginSpeciesAlias(this, type);
        this.createExtensionSBase(type, alias);
        this.listOfPluginSpeciesAlias = new PluginListOf();
        this.listOfPluginSpeciesAlias.append(alias);
        this.positionToCompartment = "";
    }

    protected PluginSpecies() {
        this.sbase = new Species();
        this.setCompartment("default");
        this.listOfPluginSpeciesAlias = new PluginListOf();
    }

    public void update(PluginSpecies species) {
        this.setName(species.getName());
        this.setNotes(species.getNotes());
        this.setBoundaryCondition(species.getBoundaryCondition());
        this.setCharge(species.getCharge());
        this.setCompartment(species.getCompartment());
        this.setSpeciesType(species.getSpeciesType());
        this.setConstant(species.getConstant());
        this.setHasOnlySubstanceUnits(species.getHasOnlySubstanceUnits());
        if (species.isSetInitialAmount()) {
            this.setInitialAmount(species.getInitialAmount());
        } else if (species.isSetInitialConcentration()) {
            this.setInitialConcentration(species.getInitialConcentration());
        }
        this.setPositionToCompartment(species.getPositionToCompartment());
        this.setSubstanceUnits(species.getSubstanceUnits());
        this.setSpatialSizeUnits(species.getSpatialSizeUnits());
        this.setUnits(species.getUnits());
        this.setAnnotation(species.getAnnotation());
        this.listOfPluginSpeciesAlias = species.getListOfSpeciesAlias();
    }

    public String getId() {
        return ((Species)this.sbase).getId();
    }

    protected void setId(String id) {
        ((Species)this.sbase).setId(id);
    }

    public String getName() {
        return ((Species)this.sbase).getName();
    }

    protected void setName(String name) {
        ((Species)this.sbase).setName(name);
    }

    public String getSpeciesType() {
        return ((Species)this.sbase).getSpeciesType();
    }

    public void setSpeciesType(String strSpeciesType) {
        ((Species)this.sbase).setSpeciesType(strSpeciesType);
    }

    public String getCompartment() {
        return ((Species)this.sbase).getCompartment();
    }

    public void setCompartment(String compartment) {
        ((Species)this.sbase).setCompartment(compartment);
    }

    public double getInitialAmount() {
        return ((Species)this.sbase).getInitialAmount();
    }

    public void setInitialAmount(double initialAmount) {
        ((Species)this.sbase).setInitialAmount(initialAmount);
    }

    public double getInitialConcentration() {
        return ((Species)this.sbase).getInitialConcentration();
    }

    public void setInitialConcentration(double initialConcentration) {
        ((Species)this.sbase).setInitialConcentration(initialConcentration);
    }

    public boolean isSetInitialAmount() {
        return ((Species)this.sbase).isSetInitialAmount();
    }

    public boolean isSetInitialConcentration() {
        return ((Species)this.sbase).isSetInitialConcentration();
    }

    public boolean getBoundaryCondition() {
        return ((Species)this.sbase).getBoundaryCondition();
    }

    public void setBoundaryCondition(boolean boundaryCondition) {
        ((Species)this.sbase).setBoundaryCondition(boundaryCondition);
    }

    public int getCharge() {
        return ((Species)this.sbase).getCharge();
    }

    public void setCharge(int charge) {
        ((Species)this.sbase).setCharge(charge);
    }

    public boolean getConstant() {
        return ((Species)this.sbase).getConstant();
    }

    public void setConstant(boolean constant) {
        ((Species)this.sbase).setConstant(constant);
    }

    public boolean getHasOnlySubstanceUnits() {
        return ((Species)this.sbase).getHasOnlySubstanceUnits();
    }

    public void setHasOnlySubstanceUnits(boolean hasOnlySubstanceUnits) {
        ((Species)this.sbase).setHasOnlySubstanceUnits(hasOnlySubstanceUnits);
    }

    public String getSubstanceUnits() {
        return ((Species)this.sbase).getSubstanceUnits();
    }

    public void setSubstanceUnits(String substanceUnits) {
        ((Species)this.sbase).setSubstanceUnits(substanceUnits);
    }

    public String getSpatialSizeUnits() {
        return ((Species)this.sbase).getSpatialSizeUnits();
    }

    public void setSpatialSizeUnits(String spatialSizeUnits) {
        ((Species)this.sbase).setSpatialSizeUnits(spatialSizeUnits);
    }

    public String getUnits() {
        return ((Species)this.sbase).getUnits();
    }

    public void setUnits(String units) {
        ((Species)this.sbase).setUnits(units);
    }

    private void createExtensionSBase(String classType, PluginSpeciesAlias alias) {
        PluginSBase extensionSBase = null;
        if (classType.equals("GENERIC") || classType.equals("RECEPTOR") || classType.equals("ION_CHANNEL") || classType.equals("TRUNCATED")) {
            extensionSBase = new PluginProtein();
            extensionSBase.setType(classType);
            extensionSBase.setName(this.getName());
        } else if (classType.equals("PROTEIN")) {
            classType = "GENERIC";
            extensionSBase = new PluginProtein();
            extensionSBase.setType(classType);
            extensionSBase.setName(this.getName());
        } else if (classType.equals("GENE")) {
            extensionSBase = new PluginGene();
            ((PluginGene)extensionSBase).setType(classType);
            ((PluginGene)extensionSBase).setName(this.getName());
        } else if (classType.equals("RNA")) {
            extensionSBase = new PluginRNA();
            ((PluginRNA)extensionSBase).setType(classType);
            ((PluginRNA)extensionSBase).setName(this.getName());
        } else if (classType.equals("ANTISENSE_RNA")) {
            extensionSBase = new PluginAntiSenseRNA();
            ((PluginAntiSenseRNA)extensionSBase).setType(classType);
            ((PluginAntiSenseRNA)extensionSBase).setName(this.getName());
        } else {
            alias.setType(classType);
        }
        if (extensionSBase != null) {
            if (extensionSBase instanceof PluginProtein) {
                alias.setProtein((PluginProtein)extensionSBase);
            } else if (extensionSBase instanceof PluginGene) {
                alias.setGene((PluginGene)extensionSBase);
            } else if (extensionSBase instanceof PluginRNA) {
                alias.setRNA((PluginRNA)extensionSBase);
            } else if (extensionSBase instanceof PluginAntiSenseRNA) {
                alias.setAntiSenseRNA((PluginAntiSenseRNA)extensionSBase);
            }
        }
    }

    public String getPositionToCompartment() {
        return this.positionToCompartment;
    }

    protected void setPositionToCompartment(String positionToCompartment) {
        this.positionToCompartment = positionToCompartment;
    }

    public int getNumSpeciesAlias() {
        if (this.listOfPluginSpeciesAlias == null) {
            return 0;
        }
        return this.listOfPluginSpeciesAlias.size();
    }

    public PluginListOf getListOfSpeciesAlias() {
        return this.listOfPluginSpeciesAlias;
    }

    public PluginSpeciesAlias getSpeciesAlias(int index) {
        if (this.listOfPluginSpeciesAlias == null) {
            return null;
        }
        if (index < 0 || index >= this.listOfPluginSpeciesAlias.size()) {
            return null;
        }
        return (PluginSpeciesAlias)this.listOfPluginSpeciesAlias.get(index);
    }

    public PluginSpeciesAlias getSpeciesAlias(String aliasId) {
        if (this.listOfPluginSpeciesAlias == null) {
            return null;
        }
        if (aliasId == null) {
            return null;
        }
        int i = 0;
        while (i < this.listOfPluginSpeciesAlias.size()) {
            PluginSpeciesAlias alias = this.getSpeciesAlias(i);
            if (aliasId.equals(alias.getAliasID())) {
                return alias;
            }
            ++i;
        }
        return null;
    }

    public void addSpeciesAlias(PluginSpeciesAlias alias) {
        if (this.listOfPluginSpeciesAlias == null) {
            this.listOfPluginSpeciesAlias = new PluginListOf();
        }
        this.listOfPluginSpeciesAlias.append(alias);
        int i = 0;
        while (i < this.listOfPluginSpeciesAlias.size()) {
            PluginSpeciesAlias aliass = this.getSpeciesAlias(i);
            aliass.setSpecies(this);
            ++i;
        }
    }

    public void removeSpeciesAlias(int index) {
        if (this.listOfPluginSpeciesAlias == null) {
            return;
        }
        if (index < 0 || index >= this.listOfPluginSpeciesAlias.size()) {
            return;
        }
        this.listOfPluginSpeciesAlias.remove(index);
    }

    public void removeSpeciesAlias(String aliasId) {
        if (this.listOfPluginSpeciesAlias == null) {
            return;
        }
        if (aliasId == null) {
            return;
        }
        int i = 0;
        while (i < this.listOfPluginSpeciesAlias.size()) {
            PluginSpeciesAlias alias = this.getSpeciesAlias(i);
            if (aliasId.equals(alias.getAliasID())) {
                this.listOfPluginSpeciesAlias.remove(i);
                return;
            }
            ++i;
        }
    }

    public void setListOfSpeciesAlias(PluginListOf listOfPluginSpeciesAlias) {
        this.listOfPluginSpeciesAlias = listOfPluginSpeciesAlias;
    }
}

