/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.plugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.MiriamMainPanel;
import jp.sbi.celldesigner.ModelDescription;
import jp.sbi.celldesigner.miriam.MIRIAM;
import jp.sbi.celldesigner.miriam.MiriamUtils;
import jp.sbi.celldesigner.plugin.PluginModel;
import jp.sbi.celldesigner.sbmlExtension.ModelAnnotation;
import jp.sbi.sbml.MiriamDefinition;
import jp.sbi.sbml.MiriamSubDefinition;
import jp.sbi.sbml.util.LibSBMLUtil;
import org.sbml.libsbml.CVTerm;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.XMLAttributes;
import org.sbml.libsbml.XMLNode;
import org.sbml.libsbml.XMLTriple;

public class PluginSBase {
    protected SBase sbase;
    private PluginSBase parentSBase;
    private String notesString = "";
    private XMLNode notes = null;
    private String annotationString = "";
    private XMLNode annotation = null;
    private List CVTerms;
    private final String resourceKey = "rdf:resource";
    private final String uriKey = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";

    protected PluginSBase() {
    }

    public void setNotes(String notes) {
        this.notesString = notes;
    }

    public void setNotes(XMLNode notes) {
        this.notes = notes;
    }

    public String getNotesString() {
        return this.notesString;
    }

    public XMLNode getNotes() {
        return this.notes;
    }

    protected PluginSBase getParentSBase() {
        return this.parentSBase;
    }

    protected void setParentSBase(PluginSBase parentSBase) {
        this.parentSBase = parentSBase;
    }

    public String toSBML() {
        return this.sbase.toSBML();
    }

    public String getAnnotationString() {
        return this.annotationString;
    }

    public void setAnnotationString(String annotations) {
        XMLNode changerOfAnno = XMLNode.convertStringToXMLNode((String)annotations);
        if (changerOfAnno == null) {
            this.annotationString = "";
            this.annotation = changerOfAnno;
        } else {
            this.setCVTerm(changerOfAnno);
            this.annotationString = annotations;
            this.annotation = changerOfAnno;
        }
    }

    public XMLNode getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(XMLNode annotations) {
        this.annotation = annotations;
        if (annotations == null) {
            this.annotationString = "";
        } else {
            this.setCVTerm(annotations);
            this.annotationString = XMLNode.convertXMLNodeToString((XMLNode)annotations);
        }
    }

    protected void setCVTerm(XMLNode node) {
        if (node == null) {
            return;
        }
        Vector vecData = MiriamMainPanel.getMiriamsFromXMLNode(new Vector(), node, null);
        ArrayList<CVTerm> temCVTerms = new ArrayList<CVTerm>();
        if (vecData != null) {
            int i = 0;
            while (i < vecData.size()) {
                String[] strNameAndPrefix;
                MiriamDefinition miriamDefinition = (MiriamDefinition)vecData.get(i);
                Vector datas = miriamDefinition.getDatas();
                String strRelation = miriamDefinition.getRelation();
                if (strRelation != null && (strNameAndPrefix = strRelation.split(":")).length == 2) {
                    String strPrefix = strNameAndPrefix[0];
                    String strName = strNameAndPrefix[1];
                    XMLTriple tripleRelation = new XMLTriple(strName, "http://www.w3.org/1999/02/22-rdf-syntax-ns#", strPrefix);
                    int u = 0;
                    while (u < datas.size()) {
                        MiriamSubDefinition miriam = (MiriamSubDefinition)datas.get(u);
                        XMLTriple tripleBag = new XMLTriple("Bag", "http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf");
                        XMLTriple tripleLi = new XMLTriple("li", "http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf");
                        XMLAttributes attr = new XMLAttributes();
                        attr.add("rdf:resource", miriam.strUri);
                        XMLNode RdfLi = new XMLNode(tripleLi, attr);
                        XMLNode RdfBag = new XMLNode(tripleBag, new XMLAttributes());
                        RdfBag.addChild(RdfLi);
                        XMLNode RdfRelation = new XMLNode(tripleRelation, new XMLAttributes());
                        RdfRelation.addChild(RdfBag);
                        CVTerm tem = new CVTerm(RdfRelation);
                        temCVTerms.add(tem);
                        ++u;
                    }
                }
                ++i;
            }
        }
        this.CVTerms = temCVTerms;
    }

    public CVTerm getCVTerm(int index) {
        if (this.CVTerms != null && this.CVTerms.size() > 0 && index < this.CVTerms.size()) {
            return (CVTerm)this.CVTerms.get(index);
        }
        return null;
    }

    public int getNumCVTerms() {
        if (this.CVTerms != null) {
            return this.CVTerms.size();
        }
        return 0;
    }

    public void addCVTerm(CVTerm term) {
        if (term == null) {
            return;
        }
        if (this.CVTerms == null) {
            this.CVTerms = new ArrayList();
        }
        this.CVTerms.add(term);
        String strOtherAnno = "";
        if (this instanceof PluginModel) {
            ModelDescription md = ModelAnnotation.getDescriptionFromXMLNode(this.annotationString);
            strOtherAnno = ModelAnnotation.getOtherAnnotation(this.annotationString);
        } else {
            strOtherAnno = ModelAnnotation.getOtherAnnotation(this.annotationString);
        }
        Vector miriams = this.ChangeCVTermToMiriamDefinition(this.CVTerms);
        String strTemAnno = "";
        StringBuffer bufMiriam = LibSBMLUtil.getMiriamValueFromMiriams(new StringBuffer(), this.sbase, miriams, true);
        if (this instanceof PluginModel) {
            PluginModel temPLModel = (PluginModel)this;
            StringBuffer strBuffer = new StringBuffer();
            ModelDescription mdes = ModelAnnotation.getDescriptionFromXMLNode(this.annotationString);
            if (mdes == null) {
                mdes = new ModelDescription();
            }
            ModelAnnotation.resetModelDescriptionAnnotation(temPLModel.modelBase, strBuffer, null, mdes, miriams);
            strTemAnno = String.valueOf(strOtherAnno) + strBuffer.toString();
        } else {
            StringBuffer strBuffer = LibSBMLUtil.getMiriamValueFromMiriams(new StringBuffer(), this.sbase, miriams, true);
            strTemAnno = String.valueOf(strOtherAnno) + strBuffer.toString();
        }
        XMLNode changerOfAnno = XMLNode.convertStringToXMLNode((String)strTemAnno);
        if (changerOfAnno == null) {
            this.annotationString = "";
            this.annotation = changerOfAnno;
            this.CVTerms = new ArrayList();
        } else {
            this.setCVTerm(changerOfAnno);
            this.annotationString = strTemAnno;
            this.annotation = changerOfAnno;
        }
    }

    protected Vector ChangeCVTermToMiriamDefinition(List CVTermT) {
        Vector<MiriamDefinition> rnt = new Vector<MiriamDefinition>();
        if (CVTermT == null) {
            return rnt;
        }
        int i = 0;
        while (i < CVTermT.size()) {
            CVTerm term = (CVTerm)CVTermT.get(i);
            String strNewUri = PluginSBase.getRelationFromCVTerm(term);
            MiriamDefinition newMD = new MiriamDefinition();
            newMD.setRelation(strNewUri);
            MiriamSubDefinition newsub = new MiriamSubDefinition();
            int numRes = (int)term.getNumResources();
            int t = 0;
            while (t < numRes) {
                String strRes = term.getResourceURI((long)t);
                String[] dataTypeAndID = MiriamUtils.makeDataTypeAndIDUsingUri(strRes);
                if (dataTypeAndID != null) {
                    String strID = dataTypeAndID[1];
                    String strURL = dataTypeAndID[0];
                    if (strURL != null && !strURL.equals("") && strID != null && !strID.equals("")) {
                        Vector<MiriamSubDefinition> vecData = newMD.getDatas();
                        if (vecData == null) {
                            vecData = new Vector<MiriamSubDefinition>();
                        }
                        MiriamSubDefinition singleDate = new MiriamSubDefinition();
                        MIRIAM miriamtemp = MainWindow.getInstanceOfMIRIAM();
                        String strDataTypename = MiriamUtils.getNameOfMiriamDatatypeUsingUri(miriamtemp, strURL);
                        singleDate.strDataType = new String(strDataTypename);
                        singleDate.strId = new String(strID);
                        int iUrlLen = strURL.length();
                        singleDate.strUri = new String(String.valueOf(strURL) + strRes.substring(iUrlLen, iUrlLen + 1) + strID);
                        vecData.add(singleDate);
                        newMD.setDatas(vecData);
                    }
                }
                ++t;
            }
            rnt.add(newMD);
            ++i;
        }
        return rnt;
    }

    public static String getRelationFromCVTerm(CVTerm term) {
        if (term == null) {
            return "";
        }
        String strNewUri = "";
        if (term.getQualifierType() == 1) {
            if (term.getBiologicalQualifierType() == 0) {
                strNewUri = "bqbiol:is";
            } else if (term.getBiologicalQualifierType() == 1) {
                strNewUri = "bqbiol:hasPart";
            } else if (term.getBiologicalQualifierType() == 2) {
                strNewUri = "bqbiol:isPartOf";
            } else if (term.getBiologicalQualifierType() == 3) {
                strNewUri = "bqbiol:isVersionOf";
            } else if (term.getBiologicalQualifierType() == 4) {
                strNewUri = "bqbiol:hasVersion";
            } else if (term.getBiologicalQualifierType() == 5) {
                strNewUri = "bqbiol:isHomologTo";
            } else if (term.getBiologicalQualifierType() == 6) {
                strNewUri = "bqbiol:isDescribedBy";
            } else if (term.getBiologicalQualifierType() == 7) {
                strNewUri = "bqbiol:isEncodedBy";
            } else if (term.getBiologicalQualifierType() == 8) {
                strNewUri = "bqbiol:encodes";
            } else if (term.getBiologicalQualifierType() == 9) {
                strNewUri = "bqbiol:occursIn";
            }
        } else if (term.getQualifierType() == 0) {
            if (term.getModelQualifierType() == 0) {
                strNewUri = "bqbiol:is";
            } else if (term.getModelQualifierType() == 1) {
                strNewUri = "bqbiol:isDescribedBy";
            }
        }
        return strNewUri;
    }
}

