/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.plugin;

import java.awt.Color;
import java.util.Vector;
import jp.fric.graphics.draw.GStructure;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.ReactionLink;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.plugin.DataObject.PluginRealLineInformationDataObjOfReactionLink;
import jp.sbi.celldesigner.plugin.PluginGLogicGate;
import jp.sbi.celldesigner.plugin.PluginKineticLaw;
import jp.sbi.celldesigner.plugin.PluginListOf;
import jp.sbi.celldesigner.plugin.PluginModifierSpeciesReference;
import jp.sbi.celldesigner.plugin.PluginSBase;
import jp.sbi.celldesigner.plugin.PluginSpeciesAlias;
import jp.sbi.celldesigner.plugin.PluginSpeciesReference;
import jp.sbi.celldesigner.plugin.util.PluginSystemOutUtils;
import org.sbml.libsbml.Reaction;

public class PluginReaction
extends PluginSBase {
    private PluginListOf listOfReactants;
    private PluginListOf listOfProducts;
    private PluginListOf listOfModifiers;
    private PluginKineticLaw kineticLaw;
    private String reactionType;
    private Color lineColor;
    private double lineWidth;
    private PluginListOf listOfGLogicGates;
    private String gateType;

    public PluginReaction() {
        this.sbase = new Reaction();
        SBModel sbModel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
        ((Reaction)this.sbase).setId(sbModel.createNewReactionId());
        this.lineColor = Color.BLACK;
        this.lineWidth = 1.0;
        this.listOfReactants = new PluginListOf(this);
        this.listOfProducts = new PluginListOf(this);
        this.listOfModifiers = new PluginListOf(this);
        this.listOfGLogicGates = new PluginListOf(this);
    }

    protected PluginReaction(String id) {
        this.sbase = new Reaction();
        ((Reaction)this.sbase).setId(id);
        this.lineColor = Color.BLACK;
        this.lineWidth = 1.0;
        this.listOfReactants = new PluginListOf(this);
        this.listOfProducts = new PluginListOf(this);
        this.listOfModifiers = new PluginListOf(this);
        this.listOfGLogicGates = new PluginListOf(this);
    }

    public void update(PluginReaction reaction) {
        this.setNotes(reaction.getNotes());
        this.setName(reaction.getName());
        this.setFast(reaction.getFast());
        this.setKineticLaw(reaction.getKineticLaw());
        this.setLineColor(reaction.getLineColor());
        this.setLineWidth(reaction.getLineWidth());
        this.setListOfModifiers(reaction.getListOfModifiers());
        this.setListOfProducts(reaction.getListOfProducts());
        this.setListOfReactants(reaction.getListOfReactants());
        this.setReactionType(reaction.getReactionType());
        this.setReversible(reaction.getReversible());
        this.setListOfGLogicGates(reaction.getListOfGLogicGates());
        this.setGateType(reaction.getGateType());
        this.setAnnotation(reaction.getAnnotation());
    }

    public String getId() {
        return ((Reaction)this.sbase).getId();
    }

    public boolean getFast() {
        return ((Reaction)this.sbase).getFast();
    }

    public void setFast(boolean fast) {
        ((Reaction)this.sbase).setFast(fast);
    }

    public boolean getReversible() {
        return ((Reaction)this.sbase).getReversible();
    }

    public void setReversible(boolean reversible) {
        ((Reaction)this.sbase).setReversible(reversible);
    }

    public String getName() {
        return ((Reaction)this.sbase).getName();
    }

    public void setName(String name) {
        ((Reaction)this.sbase).setName(name);
    }

    public void addReactant(PluginSpeciesReference ref) {
        if (ref == null) {
            return;
        }
        if (this.listOfReactants == null) {
            this.listOfReactants = new PluginListOf();
        }
        ref.setReferenceType("reactant");
        this.listOfReactants.append(ref);
    }

    public void removeReactant(PluginSpeciesReference ref) {
        if (this.listOfReactants == null) {
            return;
        }
        if (ref == null) {
            return;
        }
        this.listOfReactants.remove(ref);
    }

    public void removeReactant(int index) {
        if (this.listOfReactants == null) {
            return;
        }
        if (index < 0 || index >= this.listOfReactants.size()) {
            return;
        }
        this.listOfReactants.remove(index);
    }

    public PluginSpeciesReference getReactant(int index) {
        if (this.listOfReactants == null) {
            return null;
        }
        if (index < 0 || index >= this.listOfReactants.size()) {
            return null;
        }
        return (PluginSpeciesReference)this.listOfReactants.get(index);
    }

    public void addProduct(PluginSpeciesReference ref) {
        if (ref == null) {
            return;
        }
        if (this.listOfProducts == null) {
            this.listOfProducts = new PluginListOf();
        }
        ref.setReferenceType("product");
        this.listOfProducts.append(ref);
    }

    public void removeProduct(PluginSpeciesReference ref) {
        if (this.listOfProducts == null) {
            return;
        }
        if (ref == null) {
            return;
        }
        this.listOfProducts.remove(ref);
    }

    public void removeProduct(int index) {
        if (this.listOfProducts == null) {
            return;
        }
        if (index < 0 || index >= this.listOfProducts.size()) {
            return;
        }
        this.listOfProducts.remove(index);
    }

    public PluginSpeciesReference getProduct(int index) {
        if (this.listOfProducts == null) {
            return null;
        }
        if (index < 0 || index >= this.listOfProducts.size()) {
            return null;
        }
        return (PluginSpeciesReference)this.listOfProducts.get(index);
    }

    public void addModifier(PluginModifierSpeciesReference ref) {
        if (ref == null) {
            return;
        }
        if (this.listOfModifiers == null) {
            this.listOfModifiers = new PluginListOf();
        }
        ref.setReferenceType("modifier");
        this.listOfModifiers.append(ref);
    }

    public void removeModifier(PluginModifierSpeciesReference ref) {
        if (this.listOfModifiers == null) {
            return;
        }
        if (ref == null) {
            return;
        }
        this.listOfModifiers.remove(ref);
    }

    public void removeModifier(int index) {
        if (this.listOfModifiers == null) {
            return;
        }
        if (index < 0 || index >= this.listOfModifiers.size()) {
            return;
        }
        this.listOfModifiers.remove(index);
    }

    public PluginModifierSpeciesReference getModifier(int index) {
        if (this.listOfModifiers == null) {
            return null;
        }
        if (index < 0 || index >= this.listOfModifiers.size()) {
            return null;
        }
        return (PluginModifierSpeciesReference)this.listOfModifiers.get(index);
    }

    public PluginKineticLaw getKineticLaw() {
        return this.kineticLaw;
    }

    public void setKineticLaw(PluginKineticLaw ki) {
        this.kineticLaw = ki;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    public double getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(double lineWidth) {
        this.lineWidth = lineWidth;
    }

    public PluginListOf getListOfModifiers() {
        return this.listOfModifiers;
    }

    public void setListOfModifiers(PluginListOf listOfModifiers) {
        this.listOfModifiers = listOfModifiers;
    }

    public PluginListOf getListOfProducts() {
        return this.listOfProducts;
    }

    public void setListOfProducts(PluginListOf listOfProducts) {
        this.listOfProducts = listOfProducts;
    }

    public PluginListOf getListOfReactants() {
        return this.listOfReactants;
    }

    public void setListOfReactants(PluginListOf listOfReactants) {
        this.listOfReactants = listOfReactants;
    }

    public String getReactionType() {
        return this.reactionType;
    }

    public void setReactionType(String type) {
        this.reactionType = type;
    }

    public int getNumReactants() {
        if (this.listOfReactants == null) {
            return 0;
        }
        return this.listOfReactants.size();
    }

    public int getNumProducts() {
        if (this.listOfProducts == null) {
            return 0;
        }
        return this.listOfProducts.size();
    }

    public int getNumModifiers() {
        if (this.listOfModifiers == null) {
            return 0;
        }
        return this.listOfModifiers.size();
    }

    public int getNumGLogicGates() {
        if (this.listOfGLogicGates == null) {
            return 0;
        }
        return this.listOfGLogicGates.size();
    }

    private void debugPrint() {
        System.out.println("*______________");
        System.out.println("id = " + this.getId());
        System.out.println("name = " + this.getName());
        System.out.println("type = " + this.getReactionType());
        System.out.println("color = " + this.getLineColor());
        System.out.println("width = " + this.getLineWidth());
        System.out.println("______________*");
    }

    public void addGLogicGate(PluginGLogicGate pgg) {
        if (pgg == null) {
            return;
        }
        if (this.listOfGLogicGates == null) {
            this.listOfGLogicGates = new PluginListOf();
        }
        this.listOfGLogicGates.append(pgg);
    }

    public void removeGLogicGate(int index) {
        if (this.listOfGLogicGates == null) {
            return;
        }
        if (index < 0 || index >= this.listOfGLogicGates.size()) {
            return;
        }
        this.listOfGLogicGates.remove(index);
    }

    public void removeGLogicGate(PluginGLogicGate pgg) {
        if (this.listOfGLogicGates == null) {
            return;
        }
        if (pgg == null) {
            return;
        }
        this.listOfGLogicGates.remove(pgg);
    }

    public PluginListOf getListOfGLogicGates() {
        return this.listOfGLogicGates;
    }

    public void setListOfGLogicGates(PluginListOf listOfGLogicGates) {
        this.listOfGLogicGates = listOfGLogicGates;
    }

    public PluginRealLineInformationDataObjOfReactionLink getAllMyPostionInfomations() {
        return this.getAllMyPostionInfomations(false);
    }

    public PluginRealLineInformationDataObjOfReactionLink getAllMyPostionInfomations(boolean bPrintDebugInfo) {
        PluginRealLineInformationDataObjOfReactionLink rtnLinesInfo = null;
        SBModel sbModel = null;
        GStructure gStructure = null;
        try {
            sbModel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
            gStructure = sbModel.getGStructure();
        }
        catch (Exception myErr) {
            return null;
        }
        if (sbModel == null || gStructure == null) {
            return null;
        }
        Vector vectReactionsLinkingToMe = null;
        try {
            vectReactionsLinkingToMe = gStructure.getReactionLinksWhichislinkingtoME(this);
        }
        catch (Exception myErr) {
            return null;
        }
        if (vectReactionsLinkingToMe == null) {
            return null;
        }
        try {
            ReactionLink link = gStructure.getReactionLinkUsingPluginReaction(this);
            rtnLinesInfo = PluginSystemOutUtils.setMyPostionInfomations(gStructure, link);
            if (bPrintDebugInfo) {
                System.out.println();
                String strLinkName = "";
                try {
                    strLinkName = link.getName().trim();
                    System.out.println("ReactionLink(" + link.getName().trim() + ") information output starting...");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                PluginSystemOutUtils.printDebugInfoOfRealLineInformationOfReactionLink(rtnLinesInfo, 0);
                try {
                    strLinkName = link.getName().trim();
                    System.out.println("ReactionLink(" + link.getName().trim() + ") information output end.");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.out.println();
            }
            return rtnLinesInfo;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getGateType() {
        return this.gateType;
    }

    public void setGateType(String type) {
        this.gateType = type;
    }

    public static final boolean havePhenotypeInSrouce(PluginSBase pSbase) {
        block12: {
            PluginGLogicGate plugReaction;
            block11: {
                PluginSpeciesAlias pAlias;
                PluginSBase ref;
                int i;
                if (!(pSbase instanceof PluginReaction)) break block11;
                PluginReaction plugReaction2 = (PluginReaction)pSbase;
                if (plugReaction2.listOfReactants != null) {
                    i = 0;
                    while (i < plugReaction2.listOfReactants.size()) {
                        ref = (PluginSpeciesReference)plugReaction2.listOfReactants.get(i);
                        pAlias = ref.getAlias();
                        if (pAlias.getType().equals("PHENOTYPE")) {
                            return true;
                        }
                        ++i;
                    }
                }
                if (plugReaction2.listOfModifiers != null) {
                    i = 0;
                    while (i < plugReaction2.listOfModifiers.size()) {
                        ref = (PluginModifierSpeciesReference)plugReaction2.listOfModifiers.get(i);
                        pAlias = ref.getAlias();
                        if (pAlias.getType().equals("PHENOTYPE")) {
                            return true;
                        }
                        ++i;
                    }
                }
                if (plugReaction2.listOfGLogicGates == null) break block12;
                i = 0;
                while (i < plugReaction2.listOfGLogicGates.size()) {
                    ref = (PluginGLogicGate)plugReaction2.listOfGLogicGates.get(i);
                    if (PluginReaction.havePhenotypeInSrouce(ref)) {
                        return true;
                    }
                    ++i;
                }
                break block12;
            }
            if (pSbase instanceof PluginGLogicGate && (plugReaction = (PluginGLogicGate)pSbase).getModifiers() != null) {
                int i = 0;
                while (i < plugReaction.getModifiers().size()) {
                    PluginModifierSpeciesReference ref = (PluginModifierSpeciesReference)plugReaction.getModifiers().get(i);
                    PluginSpeciesAlias pAlias = ref.getAlias();
                    if (pAlias.getType().equals("PHENOTYPE")) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }
}

