/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.plugin;

import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.plugin.PluginBindingRegion;
import jp.sbi.celldesigner.plugin.PluginListOf;
import jp.sbi.celldesigner.plugin.PluginModificationResidue;
import jp.sbi.celldesigner.plugin.PluginSBase;
import org.sbml.libsbml.Species;

public class PluginProtein
extends PluginSBase {
    private String extensionId;
    private String type;
    private String name;
    private PluginListOf listOfPluginResidue;
    private PluginListOf listOfPluginBindingRegion;
    private PluginListOf listOfPluginStructuralStates;

    protected PluginProtein() {
        this.sbase = new Species();
        SBModel sbModel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
        this.extensionId = sbModel.createNewProteinId();
        this.listOfPluginResidue = new PluginListOf();
        this.listOfPluginBindingRegion = new PluginListOf();
    }

    protected PluginProtein(String extensionId) {
        this.sbase = new Species();
        this.extensionId = extensionId;
        this.listOfPluginResidue = new PluginListOf();
        this.listOfPluginBindingRegion = new PluginListOf();
        this.listOfPluginStructuralStates = new PluginListOf();
    }

    public void update(PluginProtein rna) {
        this.setName(rna.getName());
        this.setNotes(rna.getNotes());
        this.setType(rna.getType());
        this.setAnnotation(rna.getAnnotation());
    }

    public String getExtensionId() {
        return this.extensionId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public PluginListOf getListOfPluginResidue() {
        return this.listOfPluginResidue;
    }

    public void setListOfPluginResidue(PluginListOf listOfPluginResidue) {
        this.listOfPluginResidue = listOfPluginResidue;
    }

    public void addPluginModificationResidue(PluginModificationResidue residue) {
        if (this.listOfPluginResidue == null) {
            this.listOfPluginResidue = new PluginListOf();
        }
        this.listOfPluginResidue.append(residue);
    }

    public void removePluginModificationResidue(PluginModificationResidue residue) {
        if (this.listOfPluginResidue == null) {
            return;
        }
        if (residue == null) {
            return;
        }
        this.listOfPluginResidue.remove(residue);
    }

    public void removePluginModificationResidue(int index) {
        if (this.listOfPluginResidue == null) {
            return;
        }
        if (index < 0 || index >= this.listOfPluginResidue.size()) {
            return;
        }
        this.listOfPluginResidue.remove(index);
    }

    public PluginModificationResidue getPluginModificationResidue(int index) {
        if (this.listOfPluginResidue == null) {
            return null;
        }
        if (index < 0 || index >= this.listOfPluginResidue.size()) {
            return null;
        }
        return (PluginModificationResidue)this.listOfPluginResidue.get(index);
    }

    public int getNumResidues() {
        if (this.listOfPluginResidue == null) {
            return 0;
        }
        return this.listOfPluginResidue.size();
    }

    public PluginListOf getListOfPluginBindingRegion() {
        return this.listOfPluginBindingRegion;
    }

    public void setListOfPluginBindingRegion(PluginListOf listOfPluginBindingRegion) {
        this.listOfPluginBindingRegion = listOfPluginBindingRegion;
    }

    public void addPluginBindingRegion(PluginBindingRegion bindingRegion) {
        if (this.listOfPluginBindingRegion == null) {
            this.listOfPluginBindingRegion = new PluginListOf();
        }
        this.listOfPluginBindingRegion.append(bindingRegion);
    }

    public void removePluginBindingRegion(PluginBindingRegion bindingRegion) {
        if (this.listOfPluginBindingRegion == null) {
            return;
        }
        if (bindingRegion == null) {
            return;
        }
        this.listOfPluginBindingRegion.remove(bindingRegion);
    }

    public void removePluginBindingRegion(int index) {
        if (this.listOfPluginBindingRegion == null) {
            return;
        }
        if (index < 0 || index >= this.listOfPluginBindingRegion.size()) {
            return;
        }
        this.listOfPluginBindingRegion.remove(index);
    }

    public PluginBindingRegion getPluginBindingRegion(int index) {
        if (this.listOfPluginBindingRegion == null) {
            return null;
        }
        if (index < 0 || index >= this.listOfPluginBindingRegion.size()) {
            return null;
        }
        return (PluginBindingRegion)this.listOfPluginBindingRegion.get(index);
    }

    public int getNumBindingRegions() {
        if (this.listOfPluginBindingRegion == null) {
            return 0;
        }
        return this.listOfPluginBindingRegion.size();
    }
}

