/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.plugin;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JOptionPane;
import jp.fric.graphics.multiwindow.FileManager;
import jp.fric.io.util.MyFileFilter;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.SBEventRecorder;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.plugin.PluginDoSthAbstractAction;

public abstract class PluginOpenFileAndDoSomethingAction
extends PluginDoSthAbstractAction {
    private static final String strNeedOpenXmlFileMessage = "Please open a Celldesigner XML data file.";
    private static final String strOpenXmlFileErrMessage = "Can not open your file.";
    private static final String strCannotChangeintoPluginModelErrMessage = "Can not start plugin mode.";
    private boolean bShowGuideMsgFlg = false;
    private String strOpenFilename = null;

    @Override
    public final void actionPerformed(ActionEvent e) {
        SBEventRecorder.addLog(String.valueOf(SBEventRecorder.getOperationName(30)) + "\tOBJECTLIST=[]");
        if (this.strOpenFilename != null) {
            this.doPerform(e, this.strOpenFilename);
        } else {
            this.doPerform(e, this.bShowGuideMsgFlg);
        }
    }

    private final void doPerform(ActionEvent e, boolean showGuideMsg) {
        MyFileFilter xmlFilter = new MyFileFilter(new String[]{"xml"}, "XML  Files");
        MyFileFilter[] fileFilters = new MyFileFilter[]{xmlFilter};
        boolean bNeedOpenXmlFile = true;
        SBModel currentSBModel = null;
        try {
            currentSBModel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
            bNeedOpenXmlFile = false;
        }
        catch (Exception myErr) {
            bNeedOpenXmlFile = true;
        }
        File file = null;
        if (bNeedOpenXmlFile) {
            int ret;
            if (showGuideMsg && (ret = JOptionPane.showOptionDialog(null, strNeedOpenXmlFileMessage, "Information", -1, 1, null, null, null)) == -1) {
                return;
            }
            Object objRtn = FileManager.openMyFile(MainWindow.getLastInstance().getMyFrame(), fileFilters, ".");
            if (objRtn instanceof Integer) {
                int iCancel;
                int iRtn = (Integer)objRtn;
                if (iRtn != (iCancel = 1)) {
                    JOptionPane.showMessageDialog(null, strOpenXmlFileErrMessage, "Notice", 0);
                }
                return;
            }
            if (!(objRtn instanceof File)) {
                JOptionPane.showMessageDialog(null, strOpenXmlFileErrMessage, "Notice", 0);
                return;
            }
            file = (File)objRtn;
            if (file == null) {
                JOptionPane.showMessageDialog(null, strOpenXmlFileErrMessage, "Notice", 0);
                return;
            }
        }
        if (!MainWindow.getLastInstance().setPluginStartedEvent(e, file, false, true)) {
            JOptionPane.showMessageDialog(null, strCannotChangeintoPluginModelErrMessage, "Notice", 0);
            return;
        }
        this.processMyAction(e);
    }

    public void setShowGuideMsgFlg(boolean flg) {
        this.bShowGuideMsgFlg = flg;
    }

    public boolean isShowGuideMsg() {
        return this.bShowGuideMsgFlg;
    }

    private final void doPerform(ActionEvent e, String filename) {
        if (e == null) {
            return;
        }
        if (filename == null) {
            return;
        }
        File file = null;
        try {
            file = new File(filename);
            if (!file.exists()) {
                throw new Exception();
            }
            if (file.isDirectory()) {
                throw new Exception();
            }
        }
        catch (Exception myErr) {
            JOptionPane.showMessageDialog(null, strOpenXmlFileErrMessage, "Notice", 0);
            return;
        }
        if (!MainWindow.getLastInstance().setPluginStartedEvent(e, file, false, true)) {
            JOptionPane.showMessageDialog(null, strCannotChangeintoPluginModelErrMessage, "Notice", 0);
            return;
        }
        this.processMyAction(e);
    }

    public void setOpenFilename(String str) {
        this.strOpenFilename = str;
    }

    public String getOpenFilename() {
        return this.strOpenFilename;
    }
}

