/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.plugin;

import jp.sbi.celldesigner.plugin.PluginSBase;
import jp.sbi.celldesigner.sbmlExtension.Modification;

public class PluginModification
extends PluginSBase {
    public static final String STATE_PHOSPHORYLATED = "phosphorylated";
    public static final String STATE_ACETYLATED = "acetylated";
    public static final String STATE_UBIQUITINATED = "ubiquitinated";
    public static final String STATE_METHYLATED = "methylated";
    public static final String STATE_HYDROXYLATED = "hydroxylated";
    public static final String STATE_EMPTY = "empty";
    public static final String STATE_DONT_CARE = "don't care";
    public static final String STATE_UNKNOWN = "unknown";
    public static final String STATE_GLYCOSYLATED = "glycosylated";
    public static final String STATE_MYRISTOYLATED = "myristoylated";
    public static final String STATE_PALMYTOYLATED = "palmytoylated";
    public static final String STATE_PRENYLATED = "prenylated";
    public static final String STATE_PROTONATED = "protonated";
    public static final String STATE_SULFATED = "sulfated";
    public static final String STATE_HISTON1 = "histone1";
    public static final String STATE_HISTON2 = "histone2";
    private String residue;
    private String state;

    public PluginModification() {
        this.initAttributes();
    }

    public PluginModification(String residue) {
        this.initAttributes();
        this.residue = residue;
    }

    public PluginModification(String residue, String state) {
        this.initAttributes();
        this.residue = residue;
        this.state = state;
    }

    protected void clone(Modification modification) {
        this.setResidue(modification.getResidue());
        this.setState(modification.getState());
    }

    private void initAttributes() {
        this.residue = "";
        this.state = STATE_EMPTY;
    }

    public boolean equals(PluginModification target) {
        if (!target.getResidue().equals(this.residue)) {
            return false;
        }
        return target.getState().equals(this.state);
    }

    public void setResidue(String residue) {
        this.residue = residue;
    }

    public String getResidue() {
        return this.residue;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public String getLabel() {
        if (this.state.equals(STATE_PHOSPHORYLATED)) {
            return "P";
        }
        if (this.state.equals(STATE_ACETYLATED)) {
            return "Ac";
        }
        if (this.state.equals(STATE_UBIQUITINATED)) {
            return "Ub";
        }
        if (this.state.equals(STATE_METHYLATED)) {
            return "Me";
        }
        if (this.state.equals(STATE_HYDROXYLATED)) {
            return "OH";
        }
        if (this.state.equals(STATE_EMPTY)) {
            return "";
        }
        if (this.state.equals(STATE_DONT_CARE)) {
            return "*";
        }
        if (this.state.equals(STATE_UNKNOWN)) {
            return "?";
        }
        if (this.state.equals(STATE_GLYCOSYLATED)) {
            return "G";
        }
        if (this.state.equals(STATE_MYRISTOYLATED)) {
            return "My";
        }
        if (this.state.equals(STATE_PALMYTOYLATED)) {
            return "Pa";
        }
        if (this.state.equals(STATE_PRENYLATED)) {
            return "Pr";
        }
        if (this.state.equals(STATE_PROTONATED)) {
            return "H";
        }
        if (this.state.equals(STATE_SULFATED)) {
            return "S";
        }
        return "";
    }
}

