/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.plugin;

import java.util.HashMap;
import java.util.Vector;
import jp.fric.graphics.draw.GFramedContainer;
import jp.fric.graphics.draw.GLinkedShape;
import jp.fric.graphics.draw.GPointedContainer;
import jp.sbi.celldesigner.CompartmentAlias;
import jp.sbi.celldesigner.CompartmentSymbol;
import jp.sbi.celldesigner.ReactionLink;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.plugin.PluginAlgebraicRule;
import jp.sbi.celldesigner.plugin.PluginAntiSenseRNA;
import jp.sbi.celldesigner.plugin.PluginAssignmentRule;
import jp.sbi.celldesigner.plugin.PluginCompartment;
import jp.sbi.celldesigner.plugin.PluginCompartmentType;
import jp.sbi.celldesigner.plugin.PluginConstraint;
import jp.sbi.celldesigner.plugin.PluginEvent;
import jp.sbi.celldesigner.plugin.PluginEventAssignment;
import jp.sbi.celldesigner.plugin.PluginFunctionDefinition;
import jp.sbi.celldesigner.plugin.PluginGene;
import jp.sbi.celldesigner.plugin.PluginInitialAssignment;
import jp.sbi.celldesigner.plugin.PluginKineticLaw;
import jp.sbi.celldesigner.plugin.PluginModel;
import jp.sbi.celldesigner.plugin.PluginModificationRegion;
import jp.sbi.celldesigner.plugin.PluginModificationResidue;
import jp.sbi.celldesigner.plugin.PluginModifierSpeciesReference;
import jp.sbi.celldesigner.plugin.PluginParameter;
import jp.sbi.celldesigner.plugin.PluginProtein;
import jp.sbi.celldesigner.plugin.PluginRNA;
import jp.sbi.celldesigner.plugin.PluginRateRule;
import jp.sbi.celldesigner.plugin.PluginReaction;
import jp.sbi.celldesigner.plugin.PluginRule;
import jp.sbi.celldesigner.plugin.PluginSBase;
import jp.sbi.celldesigner.plugin.PluginSpecies;
import jp.sbi.celldesigner.plugin.PluginSpeciesAlias;
import jp.sbi.celldesigner.plugin.PluginSpeciesReference;
import jp.sbi.celldesigner.plugin.PluginSpeciesType;
import jp.sbi.celldesigner.plugin.PluginUnit;
import jp.sbi.celldesigner.plugin.PluginUnitDefinition;
import jp.sbi.celldesigner.sbmlExtension.AntiSenseRNA;
import jp.sbi.celldesigner.sbmlExtension.CompartmentAnnotation;
import jp.sbi.celldesigner.sbmlExtension.Gene;
import jp.sbi.celldesigner.sbmlExtension.ModificationRegion;
import jp.sbi.celldesigner.sbmlExtension.ModificationResidue;
import jp.sbi.celldesigner.sbmlExtension.Notes;
import jp.sbi.celldesigner.sbmlExtension.Protein;
import jp.sbi.celldesigner.sbmlExtension.RNA;
import jp.sbi.celldesigner.sbmlExtension.ReactionAnnotation;
import jp.sbi.celldesigner.sbmlExtension.SpeciesAnnotation;
import jp.sbi.celldesigner.sbmlExtension.SpeciesReferenceAnnotation;
import jp.sbi.celldesigner.util.CelldUtil;
import jp.sbi.sbml.SpecInfo;
import jp.sbi.sbml.util.ConstraintDialog;
import jp.sbi.sbml.util.LibSBMLUtil;
import org.sbml.libsbml.ASTNode;
import org.sbml.libsbml.AlgebraicRule;
import org.sbml.libsbml.AssignmentRule;
import org.sbml.libsbml.Compartment;
import org.sbml.libsbml.CompartmentType;
import org.sbml.libsbml.Constraint;
import org.sbml.libsbml.Event;
import org.sbml.libsbml.EventAssignment;
import org.sbml.libsbml.FunctionDefinition;
import org.sbml.libsbml.InitialAssignment;
import org.sbml.libsbml.KineticLaw;
import org.sbml.libsbml.Model;
import org.sbml.libsbml.ModifierSpeciesReference;
import org.sbml.libsbml.Parameter;
import org.sbml.libsbml.RateRule;
import org.sbml.libsbml.Reaction;
import org.sbml.libsbml.Rule;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Species;
import org.sbml.libsbml.SpeciesReference;
import org.sbml.libsbml.SpeciesType;
import org.sbml.libsbml.Unit;
import org.sbml.libsbml.UnitDefinition;
import org.sbml.libsbml.libsbml;

public class PluginModelBuilder {
    SBModel sbmodel = null;
    SpecInfo spec = null;
    public static final String ANNOTATION = "annotation";

    public PluginModelBuilder(SBModel value) {
        this.sbmodel = value;
        long level = this.sbmodel.getSBMLDocument().getLevel();
        long version = this.sbmodel.getSBMLDocument().getVersion();
        this.spec = new SpecInfo(level, version);
    }

    public PluginSpeciesAlias convertToPluginSpeciesAlias(SpeciesAlias alias, PluginSpecies parent) {
        PluginSpeciesAlias pSbase = null;
        SpeciesAnnotation annotation = (SpeciesAnnotation)LibSBMLUtil.getAnnotation(this.sbmodel, (SBase)alias.getOriginalSpecies(), this.spec);
        Vector listOfReferingAliases = annotation.getReferingAliases();
        int k = 0;
        while (k < listOfReferingAliases.size()) {
            SpeciesAlias ref = (SpeciesAlias)listOfReferingAliases.get(k);
            if (ref == alias) {
                pSbase = new PluginSpeciesAlias(ref, parent);
                break;
            }
            ++k;
        }
        return pSbase;
    }

    public PluginSBase convertToPluginSBase(SBase sbase) {
        PluginSBase pSbase = null;
        if (sbase instanceof Model) {
            pSbase = this.convertToPluginModel((Model)sbase);
        } else if (sbase instanceof Protein) {
            Protein p = (Protein)sbase;
            pSbase = PluginModelBuilder.convertToPluginProtein(p);
        } else if (sbase instanceof Gene) {
            Gene p = (Gene)sbase;
            pSbase = this.convertToPluginGene(p);
        } else if (sbase instanceof RNA) {
            RNA p = (RNA)sbase;
            pSbase = this.convertToPluginRNA(p);
        } else if (sbase instanceof AntiSenseRNA) {
            AntiSenseRNA p = (AntiSenseRNA)sbase;
            pSbase = this.convertToPluginAntiSenseRNA(p);
        } else if (sbase instanceof Species) {
            Species sp = (Species)sbase;
            pSbase = this.convertToPluginSpecies(sp, (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)sp, null));
        } else if (sbase instanceof Reaction) {
            Reaction re = (Reaction)sbase;
            pSbase = this.convertToPluginReaction(re, (ReactionAnnotation)LibSBMLUtil.getAnnotation((SBase)re, null));
        } else if (sbase instanceof Compartment) {
            Compartment co = (Compartment)sbase;
            pSbase = this.convertToPluginCompartment(co, (CompartmentAnnotation)LibSBMLUtil.getAnnotation((SBase)co, null));
        } else if (sbase instanceof Event) {
            Event ev = (Event)sbase;
            pSbase = PluginModelBuilder.convertToPluginEvent(ev);
        } else if (sbase instanceof Parameter) {
            Parameter ev = (Parameter)sbase;
            String parentReactionID = ev.getAnnotationString();
            if (parentReactionID != null || !parentReactionID.equals("")) {
                Model model = this.sbmodel.getModel();
                Reaction re = model.getReaction(parentReactionID);
                if (re != null) {
                    PluginReaction pReaction = this.convertToPluginReaction(re, (ReactionAnnotation)LibSBMLUtil.getAnnotation((SBase)re, null));
                    PluginKineticLaw pKineticLaw = pReaction.getKineticLaw();
                    pSbase = PluginModelBuilder.convertToPluginParameter(ev, pKineticLaw);
                } else {
                    PluginModel pModel = this.convertToPluginModel(model);
                    pSbase = PluginModelBuilder.convertToPluginParameter(ev, pModel);
                }
            } else {
                Model model = this.sbmodel.getModel();
                PluginModel pModel = this.convertToPluginModel(model);
                pSbase = PluginModelBuilder.convertToPluginParameter(ev, pModel);
            }
        } else if (sbase instanceof KineticLaw) {
            KineticLaw ev = (KineticLaw)sbase;
            String parentReactionID = ev.getAnnotationString();
            Model model = this.sbmodel.getModel();
            Reaction re = model.getReaction(parentReactionID);
            PluginReaction pReaction = this.convertToPluginReaction(re, (ReactionAnnotation)LibSBMLUtil.getAnnotation((SBase)re, null));
            pSbase = pReaction.getKineticLaw();
        } else if (sbase instanceof FunctionDefinition) {
            FunctionDefinition ev = (FunctionDefinition)sbase;
            pSbase = PluginModelBuilder.convertToPluginFunctionDefinition(ev);
        } else if (sbase instanceof SpeciesReference) {
            SpeciesReference ev = (SpeciesReference)sbase;
        } else if (sbase instanceof Rule) {
            Rule ev = (Rule)sbase;
            Model model = this.sbmodel.getModel();
            PluginModel pModel = this.convertToPluginModel(model);
            pSbase = PluginModelBuilder.convertToPluginRule(ev, pModel);
        } else if (sbase instanceof UnitDefinition) {
            UnitDefinition ev = (UnitDefinition)sbase;
            pSbase = PluginModelBuilder.convertToPluginUnitDefinition(ev);
        } else if (sbase instanceof SpeciesType) {
            SpeciesType st = (SpeciesType)sbase;
            pSbase = PluginModelBuilder.convertToPluginSpeciesType(st);
        } else if (sbase instanceof CompartmentType) {
            CompartmentType ct = (CompartmentType)sbase;
            pSbase = PluginModelBuilder.convertToPluginCompartmentType(ct);
        } else if (sbase instanceof InitialAssignment) {
            InitialAssignment ia = (InitialAssignment)sbase;
            pSbase = PluginModelBuilder.convertToPluginInitialAssignment(ia);
        } else if (sbase instanceof Constraint) {
            Constraint con = (Constraint)sbase;
            pSbase = PluginModelBuilder.convertToPluginConstraint(con);
        }
        return pSbase;
    }

    public PluginModel convertToPluginModel(Model model) {
        PluginSBase pct;
        CompartmentType ct;
        PluginSBase prl;
        Rule rl;
        PluginModel newModel = new PluginModel(model);
        newModel.setName(model.getName());
        Notes notes = (Notes)this.sbmodel.getHashModelNotes().get(model.getId());
        if (notes != null) {
            newModel.setNotes(notes.getText());
        }
        int i = 0;
        while ((long)i < model.getNumSpecies()) {
            Species sp = model.getSpecies((long)i);
            PluginSpecies psp = this.convertToPluginSpecies(sp, (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)sp, null));
            newModel.addSpecies(psp);
            ++i;
        }
        i = 0;
        while ((long)i < model.getNumReactions()) {
            Reaction re = model.getReaction((long)i);
            PluginReaction pre = this.convertToPluginReaction(re, (ReactionAnnotation)LibSBMLUtil.getAnnotation((SBase)re, null));
            newModel.addReaction(pre);
            ++i;
        }
        i = 0;
        while ((long)i < model.getNumCompartments()) {
            Compartment com = model.getCompartment((long)i);
            PluginCompartment pcom = this.convertToPluginCompartment(com, (CompartmentAnnotation)LibSBMLUtil.getAnnotation((SBase)com, null));
            newModel.addCompartment(pcom);
            ++i;
        }
        i = 0;
        while ((long)i < model.getNumEvents()) {
            Event ev = model.getEvent((long)i);
            PluginEvent pev = PluginModelBuilder.convertToPluginEvent(ev);
            newModel.addEvent(pev);
            ++i;
        }
        i = 0;
        while ((long)i < model.getNumParameters()) {
            Parameter pm = model.getParameter((long)i);
            PluginParameter ppm = PluginModelBuilder.convertToPluginParameter(pm, newModel);
            newModel.addParameter(ppm);
            ++i;
        }
        i = 0;
        while ((long)i < model.getNumFunctionDefinitions()) {
            FunctionDefinition fd = model.getFunctionDefinition((long)i);
            PluginFunctionDefinition pfd = PluginModelBuilder.convertToPluginFunctionDefinition(fd);
            newModel.addFunctionDefinition(pfd);
            ++i;
        }
        i = 0;
        while ((long)i < model.getNumRules()) {
            rl = model.getRule((long)i);
            prl = PluginModelBuilder.convertToPluginRule(rl, newModel);
            newModel.addRule((PluginRule)prl);
            ++i;
        }
        i = 0;
        while ((long)i < model.getNumUnitDefinitions()) {
            rl = model.getUnitDefinition((long)i);
            prl = PluginModelBuilder.convertToPluginUnitDefinition((UnitDefinition)rl);
            newModel.addUnitDefinition((PluginUnitDefinition)prl);
            ++i;
        }
        i = 0;
        while ((long)i < model.getNumSpeciesTypes()) {
            SpeciesType st = model.getSpeciesType((long)i);
            PluginSpeciesType pst = PluginModelBuilder.convertToPluginSpeciesType(st);
            newModel.addSpeciesType(pst);
            ++i;
        }
        i = 0;
        while ((long)i < model.getNumCompartmentTypes()) {
            ct = model.getCompartmentType((long)i);
            pct = PluginModelBuilder.convertToPluginCompartmentType(ct);
            newModel.addCompartmentType((PluginCompartmentType)pct);
            ++i;
        }
        i = 0;
        while ((long)i < model.getNumInitialAssignments()) {
            InitialAssignment ia = model.getInitialAssignment((long)i);
            PluginInitialAssignment pia = PluginModelBuilder.convertToPluginInitialAssignment(ia);
            newModel.addInitialAssignment(pia);
            ++i;
        }
        i = 0;
        while ((long)i < model.getNumConstraints()) {
            ct = model.getConstraint((long)i);
            pct = PluginModelBuilder.convertToPluginConstraint((Constraint)ct);
            newModel.addConstraint((PluginConstraint)pct);
            ++i;
        }
        return newModel;
    }

    public PluginModel convertToPluginModel(Model model, SBModel sbModel) {
        PluginSBase pct;
        CompartmentType ct;
        PluginSBase prl;
        Rule rl;
        PluginModel newModel = new PluginModel(model);
        newModel.setName(model.getName());
        newModel.setNotes(model.getNotes());
        int i = 0;
        while ((long)i < model.getNumSpecies()) {
            Species sp = model.getSpecies((long)i);
            PluginSpecies psp = this.convertToPluginSpecies(sp, (SpeciesAnnotation)LibSBMLUtil.getAnnotation(sbModel, (SBase)sp, null));
            newModel.addSpecies(psp);
            ++i;
        }
        i = 0;
        while ((long)i < model.getNumReactions()) {
            Reaction re = model.getReaction((long)i);
            PluginReaction pre = this.convertToPluginReaction(re, (ReactionAnnotation)LibSBMLUtil.getAnnotation(sbModel, (SBase)re, null));
            newModel.addReaction(pre);
            ++i;
        }
        i = 0;
        while ((long)i < model.getNumCompartments()) {
            Compartment com = model.getCompartment((long)i);
            PluginCompartment pcom = this.convertToPluginCompartment(com, (CompartmentAnnotation)LibSBMLUtil.getAnnotation(sbModel, (SBase)com, null));
            newModel.addCompartment(pcom);
            ++i;
        }
        i = 0;
        while ((long)i < model.getNumEvents()) {
            Event ev = model.getEvent((long)i);
            PluginEvent pev = PluginModelBuilder.convertToPluginEvent(ev);
            newModel.addEvent(pev);
            ++i;
        }
        i = 0;
        while ((long)i < model.getNumParameters()) {
            Parameter pm = model.getParameter((long)i);
            PluginParameter ppm = PluginModelBuilder.convertToPluginParameter(pm, newModel);
            newModel.addParameter(ppm);
            ++i;
        }
        i = 0;
        while ((long)i < model.getNumFunctionDefinitions()) {
            FunctionDefinition fd = model.getFunctionDefinition((long)i);
            PluginFunctionDefinition pfd = PluginModelBuilder.convertToPluginFunctionDefinition(fd);
            newModel.addFunctionDefinition(pfd);
            ++i;
        }
        i = 0;
        while ((long)i < model.getNumRules()) {
            rl = model.getRule((long)i);
            prl = PluginModelBuilder.convertToPluginRule(rl, newModel);
            newModel.addRule((PluginRule)prl);
            ++i;
        }
        i = 0;
        while ((long)i < model.getNumUnitDefinitions()) {
            rl = model.getUnitDefinition((long)i);
            prl = PluginModelBuilder.convertToPluginUnitDefinition((UnitDefinition)rl);
            newModel.addUnitDefinition((PluginUnitDefinition)prl);
            ++i;
        }
        i = 0;
        while ((long)i < model.getNumSpeciesTypes()) {
            SpeciesType st = model.getSpeciesType((long)i);
            PluginSpeciesType pst = PluginModelBuilder.convertToPluginSpeciesType(st);
            newModel.addSpeciesType(pst);
            ++i;
        }
        i = 0;
        while ((long)i < model.getNumCompartmentTypes()) {
            ct = model.getCompartmentType((long)i);
            pct = PluginModelBuilder.convertToPluginCompartmentType(ct);
            newModel.addCompartmentType((PluginCompartmentType)pct);
            ++i;
        }
        i = 0;
        while ((long)i < model.getNumInitialAssignments()) {
            InitialAssignment ia = model.getInitialAssignment((long)i);
            PluginInitialAssignment pia = PluginModelBuilder.convertToPluginInitialAssignment(ia);
            newModel.addInitialAssignment(pia);
            ++i;
        }
        i = 0;
        while ((long)i < model.getNumConstraints()) {
            ct = model.getConstraint((long)i);
            pct = PluginModelBuilder.convertToPluginConstraint((Constraint)ct);
            newModel.addConstraint((PluginConstraint)pct);
            ++i;
        }
        return newModel;
    }

    static PluginProtein convertToPluginProtein(Protein target) {
        PluginProtein protein = new PluginProtein(target.getId());
        protein.setType(target.getType());
        protein.setName(target.getName());
        int i = 0;
        while (i < target.getListOfModificationResidues().size()) {
            ModificationResidue ms = (ModificationResidue)target.getListOfModificationResidues().get(i);
            PluginModificationResidue pms = new PluginModificationResidue(protein);
            pms.setId(ms.getId());
            pms.setName(ms.getName());
            pms.setSide(ms.getSide());
            pms.setAngle(ms.getAngle());
            protein.addPluginModificationResidue(pms);
            ++i;
        }
        Notes notes = (Notes)LibSBMLUtil.getNotes((SBase)target, null);
        if (notes != null) {
            protein.setNotes(notes.getText());
        }
        return protein;
    }

    public PluginGene convertToPluginGene(Gene target) {
        PluginGene gene = new PluginGene(target.getId());
        gene.setType(target.getType());
        gene.setName(target.getName());
        int i = 0;
        while (i < target.getListOfRegions().size()) {
            ModificationRegion ms = (ModificationRegion)target.getListOfRegions().get(i);
            PluginModificationRegion pms = new PluginModificationRegion(gene);
            pms.setId(ms.getId());
            pms.setName(ms.getName());
            pms.setPos(ms.getPos());
            pms.setSize(ms.getSize());
            pms.setType(ms.getType());
            gene.addPluginModificationRegion(pms);
            ++i;
        }
        Notes notes = (Notes)LibSBMLUtil.getNotes((SBase)target, this.spec);
        if (notes != null) {
            gene.setNotes(notes.getText());
        }
        return gene;
    }

    public PluginAntiSenseRNA convertToPluginAntiSenseRNA(AntiSenseRNA target) {
        PluginAntiSenseRNA rna = new PluginAntiSenseRNA(target.getId());
        rna.setType(target.getType());
        rna.setName(target.getName());
        int i = 0;
        while (i < target.getListOfRegions().size()) {
            ModificationRegion ms = (ModificationRegion)target.getListOfRegions().get(i);
            PluginModificationRegion pms = new PluginModificationRegion(rna);
            pms.setId(ms.getId());
            pms.setName(ms.getName());
            pms.setPos(ms.getPos());
            pms.setSize(ms.getSize());
            pms.setType(ms.getType());
            rna.addPluginModificationRegion(pms);
            ++i;
        }
        Notes notes = (Notes)LibSBMLUtil.getNotes((SBase)target, this.spec);
        if (notes != null) {
            rna.setNotes(notes.getText());
        }
        return rna;
    }

    public PluginRNA convertToPluginRNA(RNA target) {
        PluginRNA rna = new PluginRNA(target.getId());
        rna.setType(target.getType());
        rna.setName(target.getName());
        int i = 0;
        while (i < target.getListOfRegions().size()) {
            ModificationRegion ms = (ModificationRegion)target.getListOfRegions().get(i);
            PluginModificationRegion pms = new PluginModificationRegion(rna);
            pms.setId(ms.getId());
            pms.setName(ms.getName());
            pms.setPos(ms.getPos());
            pms.setSize(ms.getSize());
            pms.setType(ms.getType());
            rna.addPluginModificationRegion(pms);
            ++i;
        }
        Notes notes = (Notes)LibSBMLUtil.getNotes((SBase)target, this.spec);
        if (notes != null) {
            rna.setNotes(notes.getText());
        }
        return rna;
    }

    public PluginSpecies convertToPluginSpecies(Species species, SpeciesAnnotation annotation) {
        PluginSpecies newSpecies = null;
        newSpecies = new PluginSpecies();
        newSpecies.setId(species.getId());
        newSpecies.setName(species.getName());
        Notes notes = (Notes)LibSBMLUtil.getNotes((SBase)species, null);
        if (notes != null) {
            newSpecies.setNotes(notes.getText());
        }
        newSpecies.setBoundaryCondition(species.getBoundaryCondition());
        newSpecies.setCharge(species.getCharge());
        newSpecies.setCompartment(species.getCompartment());
        newSpecies.setSpeciesType(species.getSpeciesType());
        newSpecies.setConstant(species.getConstant());
        newSpecies.setHasOnlySubstanceUnits(species.getHasOnlySubstanceUnits());
        newSpecies.setSubstanceUnits(species.getSubstanceUnits());
        newSpecies.setUnits(species.getUnits());
        if (species.isSetInitialAmount()) {
            newSpecies.setInitialAmount(species.getInitialAmount());
        } else {
            newSpecies.setInitialConcentration(species.getInitialConcentration());
        }
        newSpecies.setPositionToCompartment(SpeciesAnnotation.getPositionString(annotation.getPositionToCompartment()));
        Vector listOfReferingAliases = annotation.getReferingAliases();
        int i = 0;
        while (i < listOfReferingAliases.size()) {
            SpeciesAlias alias = (SpeciesAlias)listOfReferingAliases.get(i);
            PluginSpeciesAlias pAlias = this.convertToPluginSpeciesAlias(alias, newSpecies);
            newSpecies.addSpeciesAlias(pAlias);
            ++i;
        }
        return newSpecies;
    }

    public PluginReaction convertToPluginReaction(Reaction reaction, ReactionAnnotation annotation) {
        PluginSpeciesReference pref;
        SpeciesReferenceAnnotation anno;
        HashMap hashSpeciesReferenceAnnotation;
        PluginSpecies psp;
        SpeciesAnnotation spanno;
        Species sp;
        SpeciesReference ref;
        PluginReaction newReaction = new PluginReaction(reaction.getId());
        newReaction.setName(reaction.getName());
        Notes notes = (Notes)LibSBMLUtil.getNotes((SBase)reaction, this.spec);
        if (notes != null) {
            newReaction.setNotes(notes.getText());
        }
        Model model = this.sbmodel.getModel();
        newReaction.setFast(reaction.getFast());
        newReaction.setReversible(reaction.getReversible());
        int i = 0;
        while ((long)i < reaction.getNumReactants()) {
            ref = reaction.getReactant((long)i);
            sp = model.getSpecies(ref.getSpecies());
            spanno = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)sp, null);
            psp = this.convertToPluginSpecies(sp, spanno);
            hashSpeciesReferenceAnnotation = this.sbmodel.getHashSpeciesReferenceReactantsAnnotation();
            anno = (SpeciesReferenceAnnotation)hashSpeciesReferenceAnnotation.get(LibSBMLUtil.getSpeciesReferenceReactantKey(reaction.getId(), i));
            if (anno == null) {
                anno = (SpeciesReferenceAnnotation)LibSBMLUtil.getAnnotation(reaction, (SBase)ref, "Reactants", i, null);
            }
            pref = PluginModelBuilder.convertToPluginSpeciesReference(ref, newReaction, anno, psp);
            newReaction.addReactant(pref);
            ++i;
        }
        i = 0;
        while ((long)i < reaction.getNumProducts()) {
            ref = reaction.getProduct((long)i);
            sp = model.getSpecies(ref.getSpecies());
            spanno = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)sp, null);
            psp = this.convertToPluginSpecies(sp, spanno);
            hashSpeciesReferenceAnnotation = this.sbmodel.getHashSpeciesReferenceProductsAnnotation();
            anno = (SpeciesReferenceAnnotation)hashSpeciesReferenceAnnotation.get(LibSBMLUtil.getSpeciesReferenceProductKey(reaction.getId(), i));
            if (anno == null) {
                anno = (SpeciesReferenceAnnotation)LibSBMLUtil.getAnnotation(reaction, (SBase)ref, "Products", i, null);
            }
            pref = PluginModelBuilder.convertToPluginSpeciesReference(ref, newReaction, anno, psp);
            newReaction.addProduct(pref);
            ++i;
        }
        i = 0;
        while ((long)i < reaction.getNumModifiers()) {
            ref = reaction.getModifier((long)i);
            if (annotation.getModificationLinks().size() > i) {
                ReactionLink link = (ReactionLink)annotation.getModificationLinks().get(i);
                Species sp2 = model.getSpecies(ref.getSpecies());
                SpeciesAnnotation spanno2 = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)sp2, null);
                PluginSpecies psp2 = this.convertToPluginSpecies(sp2, spanno2);
                HashMap hashModifierSpeciesReferenceAnnotation = this.sbmodel.getHashModifierSpeciesReferenceAnnotation();
                SpeciesReferenceAnnotation anno2 = (SpeciesReferenceAnnotation)hashModifierSpeciesReferenceAnnotation.get(LibSBMLUtil.getSpeciesReferenceModifierKey(reaction.getId(), i));
                PluginModifierSpeciesReference pref2 = PluginModelBuilder.convertToPluginModifierSpeciesReference((ModifierSpeciesReference)ref, newReaction, link, anno2, psp2);
                newReaction.addModifier(pref2);
            }
            ++i;
        }
        if (reaction.getKineticLaw() != null) {
            newReaction.setKineticLaw(this.convertToPluginKineticLaw(reaction.getKineticLaw(), newReaction));
        }
        newReaction.setReactionType(annotation.getType());
        GLinkedShape symbol = (GLinkedShape)((Object)annotation.getBaseLink().getSymbol());
        newReaction.setLineColor(symbol.getColor());
        newReaction.setLineWidth(symbol.getLineWidth());
        return newReaction;
    }

    public PluginCompartment convertToPluginCompartment(Compartment compartment, CompartmentAnnotation annotation) {
        PluginCompartment newCompartment = null;
        Vector listOfReferingAliases = annotation.getReferingAliases();
        if (listOfReferingAliases.size() > 0) {
            int i = 0;
            while (i < listOfReferingAliases.size()) {
                CompartmentAlias alias = (CompartmentAlias)listOfReferingAliases.get(i);
                newCompartment = new PluginCompartment(compartment.getId(), alias.getSymbol().getCode());
                newCompartment.setName(compartment.getName());
                Notes notes = (Notes)LibSBMLUtil.getNotes((SBase)compartment, this.spec);
                newCompartment.setNotes(notes.getText());
                newCompartment.setConstant(compartment.getConstant());
                newCompartment.setCompartmentTypeOfPanel(compartment.getCompartmentType());
                newCompartment.setOutside(compartment.getOutside());
                newCompartment.setSize(compartment.getSize());
                newCompartment.setSpatialDimensions(compartment.getSpatialDimensions());
                newCompartment.setUnits(compartment.getUnits());
                newCompartment.setVolume(compartment.getVolume());
                CompartmentSymbol symbol = (CompartmentSymbol)((Object)alias.getSymbol());
                newCompartment.setThickness(symbol.getMembrane().getThickness());
                newCompartment.setInnerWidth(symbol.getMembrane().getInnerLineWidth());
                newCompartment.setOuterWidth(symbol.getMembrane().getOuterLineWidth());
                newCompartment.setLineColor(symbol.getComparmentShapePainting().getColor());
                if (alias instanceof GPointedContainer) {
                    newCompartment.setX(((GPointedContainer)((Object)alias)).getBounds().x);
                    newCompartment.setY(((GPointedContainer)((Object)alias)).getBounds().y);
                    newCompartment.setWidth(((GPointedContainer)((Object)alias)).getBounds().width);
                    newCompartment.setHeight(((GPointedContainer)((Object)alias)).getBounds().height);
                } else {
                    newCompartment.setX(((GFramedContainer)((Object)alias)).getFramePosition().x);
                    newCompartment.setY(((GFramedContainer)((Object)alias)).getFramePosition().y);
                    newCompartment.setWidth(((GFramedContainer)((Object)alias)).getFrameSize().x);
                    newCompartment.setHeight(((GFramedContainer)((Object)alias)).getFrameSize().y);
                }
                ++i;
            }
        } else {
            newCompartment = new PluginCompartment(compartment.getId(), "default");
            newCompartment.setName(compartment.getName());
            newCompartment.setNotes(compartment.getNotes());
            newCompartment.setConstant(compartment.getConstant());
            newCompartment.setCompartmentTypeOfPanel(compartment.getCompartmentType());
            newCompartment.setOutside(compartment.getOutside());
            newCompartment.setSize(compartment.getSize());
            newCompartment.setSpatialDimensions(compartment.getSpatialDimensions());
            newCompartment.setUnits(compartment.getUnits());
            newCompartment.setVolume(compartment.getVolume());
        }
        return newCompartment;
    }

    static PluginEvent convertToPluginEvent(Event event) {
        PluginEvent newEvent = new PluginEvent(event.getId());
        if (event.getDelay() != null) {
            newEvent.setDelay(event.getDelay());
        }
        newEvent.setName(event.getName());
        newEvent.setNotes(event.getNotes());
        newEvent.setTimeUnits(event.getTimeUnits());
        newEvent.setUseValuesFromTriggerTime(event.getUseValuesFromTriggerTime());
        if (event.getTrigger() != null) {
            newEvent.setTrigger(event.getTrigger());
        }
        int i = 0;
        while ((long)i < event.getNumEventAssignments()) {
            EventAssignment ev = event.getEventAssignment((long)i);
            PluginEventAssignment pev = PluginModelBuilder.convertToPluginEventAssignment(ev, newEvent);
            newEvent.addEventAssignment(pev);
            ++i;
        }
        return newEvent;
    }

    static PluginEventAssignment convertToPluginEventAssignment(EventAssignment event, PluginEvent parent) {
        PluginEventAssignment newEvent = new PluginEventAssignment(parent);
        newEvent.setNotes(event.getNotes());
        newEvent.setMath(libsbml.parseFormula((String)libsbml.formulaToString((ASTNode)event.getMath())));
        newEvent.setVariable(event.getVariable());
        return newEvent;
    }

    public PluginKineticLaw convertToPluginKineticLaw(KineticLaw law, PluginReaction parent) {
        PluginKineticLaw newLaw = new PluginKineticLaw(parent);
        newLaw.setFormula(law.getFormula());
        Notes notes = (Notes)LibSBMLUtil.getNotes((SBase)law, this.spec);
        if (notes != null) {
            newLaw.setNotes(notes.getText());
        }
        newLaw.setSubstanceUnits(law.getSubstanceUnits());
        newLaw.setTimeUnits(law.getTimeUnits());
        int i = 0;
        while ((long)i < law.getNumParameters()) {
            Parameter param = law.getParameter((long)i);
            PluginParameter pparam = PluginModelBuilder.convertToPluginParameter(param, newLaw);
            newLaw.addParameter(pparam);
            ++i;
        }
        return newLaw;
    }

    static PluginParameter convertToPluginParameter(Parameter param, PluginKineticLaw parent) {
        PluginParameter newParam = new PluginParameter(param.getId(), parent);
        newParam.setId(param.getId());
        newParam.setName(param.getName());
        newParam.setNotes(param.getNotes());
        newParam.setUnits(param.getUnits());
        newParam.setValue(param.getValue());
        newParam.setConstant(param.getConstant());
        return newParam;
    }

    static PluginParameter convertToPluginParameter(Parameter param, PluginModel parent) {
        PluginParameter newParam = new PluginParameter(param.getId(), parent);
        newParam.setId(param.getId());
        newParam.setName(param.getName());
        newParam.setNotes(param.getNotes());
        newParam.setUnits(param.getUnits());
        newParam.setValue(param.getValue());
        newParam.setConstant(param.getConstant());
        return newParam;
    }

    static PluginSpeciesReference convertToPluginSpeciesReference(SpeciesReference ref, PluginReaction parent, SpeciesReferenceAnnotation anno, PluginSpecies psp) {
        PluginSpeciesAlias alias = new PluginSpeciesAlias(anno.getSpecieAlias(), psp);
        PluginSpeciesReference newRef = new PluginSpeciesReference(parent, alias);
        newRef.setNotes(ref.getNotes());
        newRef.setStoichiometry(ref.getStoichiometry());
        if (ref.getStoichiometryMath() != null) {
            newRef.setStoichiometryMath(ref.getStoichiometryMath());
        }
        return newRef;
    }

    static PluginModifierSpeciesReference convertToPluginModifierSpeciesReference(ModifierSpeciesReference ref, PluginReaction parent, ReactionLink link, SpeciesReferenceAnnotation anno, PluginSpecies psp) {
        PluginSpeciesAlias alias = new PluginSpeciesAlias(anno.getSpecieAlias(), psp);
        PluginModifierSpeciesReference newRef = new PluginModifierSpeciesReference(parent, alias);
        newRef.setNotes(ref.getNotes());
        newRef.setModificationType(link.getSymbol().getCode());
        return newRef;
    }

    static PluginFunctionDefinition convertToPluginFunctionDefinition(FunctionDefinition function) {
        PluginFunctionDefinition newFunction = new PluginFunctionDefinition(function.getId());
        if (function.getMath() != null) {
            newFunction.setMath(libsbml.parseFormula((String)libsbml.formulaToString((ASTNode)function.getMath())));
        }
        newFunction.setName(function.getName());
        newFunction.setNotes(function.getNotes());
        return newFunction;
    }

    static PluginRule convertToPluginRule(Rule rule, PluginModel parent) {
        if (rule instanceof AlgebraicRule) {
            PluginAlgebraicRule newRule2 = new PluginAlgebraicRule(parent);
            AlgebraicRule arule = (AlgebraicRule)rule;
            newRule2.setNotes(arule.getNotes());
            newRule2.setFormula(arule.getFormula());
            return newRule2;
        }
        if (rule instanceof AssignmentRule) {
            PluginAssignmentRule newRule2 = new PluginAssignmentRule(parent);
            AssignmentRule arule = (AssignmentRule)rule;
            newRule2.setNotes(arule.getNotes());
            newRule2.setFormula(arule.getFormula());
            newRule2.setL1TypeCode(arule.getL1TypeCode());
            newRule2.setVariable(arule.getVariable());
            return newRule2;
        }
        if (rule instanceof RateRule) {
            PluginRateRule newRule2 = new PluginRateRule(parent);
            RateRule arule = (RateRule)rule;
            newRule2.setNotes(arule.getNotes());
            newRule2.setFormula(arule.getFormula());
            newRule2.setVariable(arule.getVariable());
            return newRule2;
        }
        return null;
    }

    static PluginUnitDefinition convertToPluginUnitDefinition(UnitDefinition unit) {
        PluginUnitDefinition newUnit = new PluginUnitDefinition(unit.getId());
        newUnit.setName(unit.getName());
        newUnit.setNotes(unit.getNotes());
        int i = 0;
        while ((long)i < unit.getNumUnits()) {
            Unit un = unit.getUnit((long)i);
            PluginUnit pun = PluginModelBuilder.convertToPluginUnit(un, newUnit);
            newUnit.addUnit(pun);
            ++i;
        }
        return newUnit;
    }

    static PluginSpeciesType convertToPluginSpeciesType(SpeciesType speciesType) {
        if (speciesType == null) {
            return null;
        }
        PluginSpeciesType newSpeciesType = new PluginSpeciesType(speciesType.getId());
        newSpeciesType.setName(speciesType.getName());
        String value = "";
        try {
            Notes notes = (Notes)CelldUtil.getAimSBModel(speciesType).getHashSpeciesTypeNotes().get(speciesType.getId());
            value = notes.getText();
        }
        catch (Exception e) {
            value = "";
        }
        newSpeciesType.setNotes(value);
        return newSpeciesType;
    }

    static PluginCompartmentType convertToPluginCompartmentType(CompartmentType compartmentType) {
        if (compartmentType == null) {
            return null;
        }
        PluginCompartmentType newCompartmentType = new PluginCompartmentType(compartmentType.getId());
        newCompartmentType.setName(compartmentType.getName());
        String value = "";
        try {
            Notes notes = (Notes)CelldUtil.getAimSBModel(compartmentType).getHashCompartmentTypeNotes().get(compartmentType.getId());
            value = notes.getText();
        }
        catch (Exception e) {
            value = "";
        }
        newCompartmentType.setNotes(value);
        return newCompartmentType;
    }

    static PluginInitialAssignment convertToPluginInitialAssignment(InitialAssignment initialAssignment) {
        if (initialAssignment == null) {
            return null;
        }
        PluginInitialAssignment newInitialAssignment = new PluginInitialAssignment(initialAssignment.getSymbol());
        newInitialAssignment.setMath(libsbml.formulaToString((ASTNode)initialAssignment.getMath()));
        String value = "";
        try {
            Notes notes = (Notes)CelldUtil.getAimSBModel(initialAssignment).getHashInitialAssignmentNotes().get(initialAssignment.getSymbol());
            value = notes.getText();
        }
        catch (Exception e) {
            value = "";
        }
        newInitialAssignment.setNotes(value);
        return newInitialAssignment;
    }

    static PluginConstraint convertToPluginConstraint(Constraint constraint) {
        if (constraint == null) {
            return null;
        }
        PluginConstraint newConstraint = new PluginConstraint(libsbml.formulaToString((ASTNode)constraint.getMath()));
        newConstraint.setMessage(ConstraintDialog.getMsgStringOfConstraint(constraint));
        String value = "";
        try {
            Notes notes = (Notes)CelldUtil.getAimSBModel(constraint).getHashConstraintNotes().get(libsbml.formulaToString((ASTNode)constraint.getMath()));
            value = notes.getText();
        }
        catch (Exception e) {
            value = "";
        }
        newConstraint.setNotes(value);
        return newConstraint;
    }

    static PluginUnit convertToPluginUnit(Unit unit, PluginUnitDefinition parent) {
        PluginUnit newUnit = new PluginUnit(parent);
        newUnit.setExponent(unit.getExponent());
        newUnit.setKind(unit.getKind());
        newUnit.setMultiplier(unit.getMultiplier());
        newUnit.setNotes(unit.getNotes());
        newUnit.setOffset(unit.getOffset());
        newUnit.setScale(unit.getScale());
        return newUnit;
    }
}

