/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.plugin;

import jp.sbi.celldesigner.plugin.PluginAntiSenseRNA;
import jp.sbi.celldesigner.plugin.PluginCompartment;
import jp.sbi.celldesigner.plugin.PluginCompartmentType;
import jp.sbi.celldesigner.plugin.PluginConstraint;
import jp.sbi.celldesigner.plugin.PluginEvent;
import jp.sbi.celldesigner.plugin.PluginFunctionDefinition;
import jp.sbi.celldesigner.plugin.PluginGene;
import jp.sbi.celldesigner.plugin.PluginInitialAssignment;
import jp.sbi.celldesigner.plugin.PluginListOf;
import jp.sbi.celldesigner.plugin.PluginParameter;
import jp.sbi.celldesigner.plugin.PluginProtein;
import jp.sbi.celldesigner.plugin.PluginRNA;
import jp.sbi.celldesigner.plugin.PluginReaction;
import jp.sbi.celldesigner.plugin.PluginRule;
import jp.sbi.celldesigner.plugin.PluginSBase;
import jp.sbi.celldesigner.plugin.PluginSpecies;
import jp.sbi.celldesigner.plugin.PluginSpeciesAlias;
import jp.sbi.celldesigner.plugin.PluginSpeciesType;
import jp.sbi.celldesigner.plugin.PluginUnitDefinition;
import jp.sbi.sbml.util.LibSBMLUtil;
import org.sbml.libsbml.Model;

public class PluginModel
extends PluginSBase {
    private PluginListOf listOfSpecies;
    private PluginListOf listOfReactions;
    private PluginListOf listOfCompartments;
    private PluginListOf listOfEvents;
    private PluginListOf listOfParameters;
    private PluginListOf listOfFunctionDefinitions;
    private PluginListOf listOfRules;
    private PluginListOf listOfUnitDefinitions;
    private PluginListOf listOfProteins;
    private PluginListOf listOfGenes;
    private PluginListOf listOfRNAs;
    private PluginListOf listOfAntiSenseRNAs;
    private PluginListOf listOfSpeciesTypes;
    private PluginListOf listOfCompartmentTypes;
    private PluginListOf listOfInitialAssignments;
    private PluginListOf listOfConstraints;
    protected Model modelBase = null;

    public PluginModel(Model model) {
        if (model == null) {
            model = new Model();
            long startTime = System.currentTimeMillis();
            model.setId("PluginModelID" + startTime);
        }
        String id = model.getId();
        this.sbase = new Model();
        ((Model)this.sbase).setId(id);
        this.listOfSpecies = new PluginListOf();
        this.listOfReactions = new PluginListOf();
        this.listOfCompartments = new PluginListOf();
        this.listOfEvents = new PluginListOf();
        this.listOfParameters = new PluginListOf();
        this.listOfFunctionDefinitions = new PluginListOf();
        this.listOfRules = new PluginListOf();
        this.listOfUnitDefinitions = new PluginListOf();
        this.listOfSpeciesTypes = new PluginListOf();
        this.listOfCompartmentTypes = new PluginListOf();
        this.listOfInitialAssignments = new PluginListOf();
        this.listOfConstraints = new PluginListOf();
        this.listOfProteins = new PluginListOf();
        this.listOfGenes = new PluginListOf();
        this.listOfRNAs = new PluginListOf();
        this.listOfAntiSenseRNAs = new PluginListOf();
        this.modelBase = model;
    }

    public void update(PluginModel model) {
        this.setNotes(model.getNotes());
        this.setName(model.getName());
        this.setListOfCompartments(model.getListOfCompartments());
        this.setListOfEvents(model.getListOfEvents());
        this.setListOfFunctionDefinitions(model.getListOfFunctionDefinitions());
        this.setListOfParameters(model.getListOfParameters());
        this.setListOfReactions(model.getListOfReactions());
        this.setListOfRules(model.getListOfRules());
        this.setListOfSpecies(model.getListOfSpecies());
        this.setListOfUnitDefinitions(model.getListOfUnitDefinitions());
        this.setListOfSpeciesTypes(model.getListOfSpeciesTypes());
        this.setListOfCompartmentTypes(model.getListOfCompartmentTypes());
        this.setListOfInitialAssignments(model.getListOfInitialAssignments());
        this.setListOfConstraints(model.getListOfConstraints());
        this.setListOfAntiSenseRNAs(model.getListOfAntiSenseRNAs());
        this.setListOfGenes(model.getListOfGenes());
        this.setListOfProteins(model.getListOfProteins());
        this.setListOfRNAs(model.getListOfRNAs());
        this.setAnnotation(model.getAnnotation());
    }

    public void toSBMLString() {
        System.err.println(this.modelBase.toSBML());
    }

    public String getId() {
        return ((Model)this.sbase).getId();
    }

    public String getPureSBMLString() {
        LibSBMLUtil.unsetAnnotation(this.modelBase);
        return this.modelBase.getSBMLDocument().toSBML();
    }

    public String getName() {
        return ((Model)this.sbase).getName();
    }

    public void setName(String name) {
        ((Model)this.sbase).setName(name);
    }

    public PluginListOf getListOfCompartments() {
        return this.listOfCompartments;
    }

    public void setListOfCompartments(PluginListOf listOfCompartments) {
        this.listOfCompartments = listOfCompartments;
    }

    public PluginListOf getListOfEvents() {
        return this.listOfEvents;
    }

    public void setListOfEvents(PluginListOf listOfEvents) {
        this.listOfEvents = listOfEvents;
    }

    public PluginListOf getListOfFunctionDefinitions() {
        return this.listOfFunctionDefinitions;
    }

    public void setListOfFunctionDefinitions(PluginListOf listOfFunctionDefinitions) {
        this.listOfFunctionDefinitions = listOfFunctionDefinitions;
    }

    public PluginListOf getListOfParameters() {
        return this.listOfParameters;
    }

    public void setListOfParameters(PluginListOf listOfParameters) {
        this.listOfParameters = listOfParameters;
    }

    public PluginListOf getListOfReactions() {
        return this.listOfReactions;
    }

    public void setListOfReactions(PluginListOf listOfReactions) {
        this.listOfReactions = listOfReactions;
    }

    public PluginListOf getListOfRules() {
        return this.listOfRules;
    }

    public void setListOfRules(PluginListOf listOfRules) {
        this.listOfRules = listOfRules;
    }

    public PluginListOf getListOfSpecies() {
        return this.listOfSpecies;
    }

    public void setListOfSpecies(PluginListOf listOfSpecies) {
        this.listOfSpecies = listOfSpecies;
    }

    public PluginListOf getListOfUnitDefinitions() {
        return this.listOfUnitDefinitions;
    }

    public void setListOfUnitDefinitions(PluginListOf listOfUnitDefinitions) {
        this.listOfUnitDefinitions = listOfUnitDefinitions;
    }

    public PluginListOf getListOfSpeciesTypes() {
        return this.listOfSpeciesTypes;
    }

    public void setListOfSpeciesTypes(PluginListOf listOfSpeciesTypes) {
        this.listOfSpeciesTypes = listOfSpeciesTypes;
    }

    public PluginListOf getListOfCompartmentTypes() {
        return this.listOfCompartmentTypes;
    }

    public void setListOfCompartmentTypes(PluginListOf listOfCompartmentTypes) {
        this.listOfCompartmentTypes = listOfCompartmentTypes;
    }

    public PluginListOf getListOfInitialAssignments() {
        return this.listOfInitialAssignments;
    }

    public void setListOfInitialAssignments(PluginListOf listOfInitialAssignments) {
        this.listOfInitialAssignments = listOfInitialAssignments;
    }

    public PluginListOf getListOfConstraints() {
        return this.listOfConstraints;
    }

    public void setListOfConstraints(PluginListOf listOfConstraints) {
        this.listOfConstraints = listOfConstraints;
    }

    public void addSpecies(PluginSpecies species) {
        if (this.listOfSpecies == null) {
            this.listOfSpecies = new PluginListOf();
        }
        this.listOfSpecies.append(species);
        String classType = species.getSpeciesAlias(0).getExtensionType();
        if (classType.equals("GENERIC") || classType.equals("RECEPTOR") || classType.equals("ION_CHANNEL") || classType.equals("TRUNCATED") || classType.equals("PROTEIN")) {
            this.appendProtein(species.getSpeciesAlias(0).getProtein());
        } else if (classType.equals("GENE")) {
            this.appendGene(species.getSpeciesAlias(0).getGene());
        } else if (classType.equals("RNA")) {
            this.appendRNA(species.getSpeciesAlias(0).getRNA());
        } else if (classType.equals("ANTISENSE_RNA")) {
            this.appendAntiSenseRNA(species.getSpeciesAlias(0).getAntiSenseRNA());
        }
    }

    public void removeSpecies(String id) {
        if (this.listOfSpecies == null) {
            return;
        }
        int i = 0;
        while (i < this.listOfSpecies.size()) {
            PluginSpecies sp = this.getSpecies(i);
            if (sp.getId().equals(id)) {
                this.listOfSpecies.remove(i);
                return;
            }
            ++i;
        }
    }

    public void removeSpecies(int index) {
        if (this.listOfSpecies == null) {
            return;
        }
        if (index < 0 || index >= this.listOfSpecies.size()) {
            return;
        }
        this.listOfSpecies.remove(index);
    }

    public PluginSpecies getSpecies(int index) {
        if (this.listOfSpecies == null) {
            return null;
        }
        if (index < 0 || index >= this.listOfSpecies.size()) {
            return null;
        }
        return (PluginSpecies)this.listOfSpecies.get(index);
    }

    public PluginSpecies getSpecies(String id) {
        if (this.listOfSpecies == null) {
            return null;
        }
        int i = 0;
        while (i < this.listOfSpecies.size()) {
            PluginSpecies sp = this.getSpecies(i);
            if (sp.getId().equals(id)) {
                return sp;
            }
            ++i;
        }
        return null;
    }

    public void addCompartment(PluginCompartment compartment) {
        if (this.listOfCompartments == null) {
            this.listOfCompartments = new PluginListOf();
        }
        this.listOfCompartments.append(compartment);
    }

    public void removeCompartment(PluginCompartment compartment) {
        if (this.listOfCompartments == null) {
            return;
        }
        if (compartment == null) {
            return;
        }
        this.listOfCompartments.remove(compartment);
    }

    public void removeCompartment(String id) {
        if (this.listOfCompartments == null) {
            return;
        }
        if (id == null) {
            return;
        }
        int i = 0;
        while (i < this.listOfCompartments.size()) {
            PluginCompartment sp = this.getCompartment(i);
            if (sp.getId().equals(id)) {
                this.listOfCompartments.remove(i);
                return;
            }
            ++i;
        }
    }

    public void removeCompartment(int index) {
        if (this.listOfCompartments == null) {
            return;
        }
        if (index < 0 || index >= this.listOfCompartments.size()) {
            return;
        }
        this.listOfCompartments.remove(index);
    }

    public PluginCompartment getCompartment(int index) {
        if (this.listOfCompartments == null) {
            return null;
        }
        if (index < 0 || index >= this.listOfCompartments.size()) {
            return null;
        }
        return (PluginCompartment)this.listOfCompartments.get(index);
    }

    public PluginCompartment getCompartment(String id) {
        if (this.listOfCompartments == null) {
            return null;
        }
        if (id == null) {
            return null;
        }
        int i = 0;
        while (i < this.listOfCompartments.size()) {
            PluginCompartment sp = this.getCompartment(i);
            if (sp.getId().equals(id)) {
                return sp;
            }
            ++i;
        }
        return null;
    }

    public void addReaction(PluginReaction reaction) {
        if (this.listOfReactions == null) {
            this.listOfReactions = new PluginListOf();
        }
        this.listOfReactions.append(reaction);
    }

    public void removeReaction(PluginReaction reaction) {
        if (this.listOfReactions == null) {
            return;
        }
        if (reaction == null) {
            return;
        }
        this.listOfReactions.remove(reaction);
    }

    public void removeReaction(String id) {
        if (this.listOfReactions == null) {
            return;
        }
        if (id == null) {
            return;
        }
        int i = 0;
        while (i < this.listOfReactions.size()) {
            PluginReaction sp = this.getReaction(i);
            if (sp.getId().equals(id)) {
                this.listOfReactions.remove(i);
                return;
            }
            ++i;
        }
    }

    public void removeReaction(int index) {
        if (this.listOfReactions == null) {
            return;
        }
        if (index < 0 || index >= this.listOfReactions.size()) {
            return;
        }
        this.listOfReactions.remove(index);
    }

    public PluginReaction getReaction(int index) {
        if (this.listOfReactions == null) {
            return null;
        }
        if (index < 0 || index >= this.listOfReactions.size()) {
            return null;
        }
        return (PluginReaction)this.listOfReactions.get(index);
    }

    public PluginReaction getReaction(String id) {
        if (this.listOfReactions == null) {
            return null;
        }
        if (id == null) {
            return null;
        }
        int i = 0;
        while (i < this.listOfReactions.size()) {
            PluginReaction sp = this.getReaction(i);
            if (sp.getId().equals(id)) {
                return sp;
            }
            ++i;
        }
        return null;
    }

    public void addEvent(PluginEvent event) {
        if (this.listOfEvents == null) {
            this.listOfEvents = new PluginListOf();
        }
        this.listOfEvents.append(event);
    }

    public void removeEvent(PluginEvent event) {
        if (this.listOfEvents == null) {
            return;
        }
        if (this.listOfEvents == null) {
            return;
        }
        this.listOfEvents.remove(event);
    }

    public void removeEvent(String id) {
        if (this.listOfEvents == null) {
            return;
        }
        if (id == null) {
            return;
        }
        int i = 0;
        while (i < this.listOfEvents.size()) {
            PluginEvent sp = this.getEvent(i);
            if (sp.getId().equals(id)) {
                this.listOfEvents.remove(i);
                return;
            }
            ++i;
        }
    }

    public void removeEvent(int index) {
        if (this.listOfEvents == null) {
            return;
        }
        if (index < 0 || index >= this.listOfEvents.size()) {
            return;
        }
        this.listOfEvents.remove(index);
    }

    public PluginEvent getEvent(int index) {
        if (this.listOfEvents == null) {
            return null;
        }
        if (index < 0 || index >= this.listOfEvents.size()) {
            return null;
        }
        return (PluginEvent)this.listOfEvents.get(index);
    }

    public PluginEvent getEvent(String id) {
        if (this.listOfEvents == null) {
            return null;
        }
        if (id == null) {
            return null;
        }
        int i = 0;
        while (i < this.listOfEvents.size()) {
            PluginEvent sp = this.getEvent(i);
            if (sp.getId().equals(id)) {
                return sp;
            }
            ++i;
        }
        return null;
    }

    public void addParameter(PluginParameter parameter) {
        if (this.listOfParameters == null) {
            this.listOfParameters = new PluginListOf();
        }
        this.listOfParameters.append(parameter);
        int i = 0;
        while (i < this.listOfParameters.size()) {
            PluginParameter r = (PluginParameter)this.listOfParameters.get(i);
            r.setParentSBase(this);
            ++i;
        }
    }

    public void removeParameter(PluginParameter parameter) {
        if (this.listOfParameters == null) {
            return;
        }
        if (parameter == null) {
            return;
        }
        this.listOfParameters.remove(parameter);
    }

    public void removeParameter(String id) {
        if (this.listOfParameters == null) {
            return;
        }
        if (id == null) {
            return;
        }
        int i = 0;
        while (i < this.listOfParameters.size()) {
            PluginParameter sp = this.getParameter(i);
            if (sp.getId().equals(id)) {
                this.listOfParameters.remove(i);
                return;
            }
            ++i;
        }
    }

    public void removeParameter(int index) {
        if (this.listOfParameters == null) {
            return;
        }
        if (index < 0 || index >= this.listOfParameters.size()) {
            return;
        }
        this.listOfParameters.remove(index);
    }

    public PluginParameter getParameter(int index) {
        if (this.listOfParameters == null) {
            return null;
        }
        if (index < 0 || index >= this.listOfParameters.size()) {
            return null;
        }
        return (PluginParameter)this.listOfParameters.get(index);
    }

    public PluginParameter getParameter(String id) {
        if (this.listOfParameters == null) {
            return null;
        }
        if (id == null) {
            return null;
        }
        int i = 0;
        while (i < this.listOfParameters.size()) {
            PluginParameter sp = this.getParameter(i);
            if (sp.getId().equals(id)) {
                return sp;
            }
            ++i;
        }
        return null;
    }

    public void addFunctionDefinition(PluginFunctionDefinition function) {
        if (this.listOfFunctionDefinitions == null) {
            this.listOfFunctionDefinitions = new PluginListOf();
        }
        this.listOfFunctionDefinitions.append(function);
    }

    public void removeFunctionDefinition(PluginFunctionDefinition function) {
        if (this.listOfFunctionDefinitions == null) {
            return;
        }
        if (function == null) {
            return;
        }
        this.listOfFunctionDefinitions.remove(function);
    }

    public void removeFunctionDefinition(String id) {
        if (this.listOfFunctionDefinitions == null) {
            return;
        }
        if (id == null) {
            return;
        }
        int i = 0;
        while (i < this.listOfFunctionDefinitions.size()) {
            PluginFunctionDefinition sp = this.getFunctionDefinition(i);
            if (sp.getId().equals(id)) {
                this.listOfFunctionDefinitions.remove(i);
                return;
            }
            ++i;
        }
    }

    public void removeFunctionDefinition(int index) {
        if (this.listOfFunctionDefinitions == null) {
            return;
        }
        if (index < 0 || index >= this.listOfFunctionDefinitions.size()) {
            return;
        }
        this.listOfFunctionDefinitions.remove(index);
    }

    public PluginFunctionDefinition getFunctionDefinition(int index) {
        if (this.listOfFunctionDefinitions == null) {
            return null;
        }
        if (index < 0 || index >= this.listOfFunctionDefinitions.size()) {
            return null;
        }
        return (PluginFunctionDefinition)this.listOfFunctionDefinitions.get(index);
    }

    public PluginFunctionDefinition getFunctionDefinition(String id) {
        if (this.listOfFunctionDefinitions == null) {
            return null;
        }
        if (id == null) {
            return null;
        }
        int i = 0;
        while (i < this.listOfFunctionDefinitions.size()) {
            PluginFunctionDefinition sp = this.getFunctionDefinition(i);
            if (sp.getId().equals(id)) {
                return sp;
            }
            ++i;
        }
        return null;
    }

    public void addRule(PluginRule rule) {
        if (this.listOfRules == null) {
            this.listOfRules = new PluginListOf();
        }
        this.listOfRules.append(rule);
        int i = 0;
        while (i < this.listOfRules.size()) {
            PluginRule r = (PluginRule)this.listOfRules.get(i);
            r.setParentSBase(this);
            ++i;
        }
    }

    public void removeRule(PluginRule rule) {
        if (this.listOfRules == null) {
            return;
        }
        if (rule == null) {
            return;
        }
        this.listOfRules.remove(rule);
    }

    public void removeRule(int index) {
        if (this.listOfRules == null) {
            return;
        }
        if (index < 0 || index >= this.listOfRules.size()) {
            return;
        }
        this.listOfRules.remove(index);
    }

    public PluginRule getRule(int index) {
        if (this.listOfRules == null) {
            return null;
        }
        if (index < 0 || index >= this.listOfRules.size()) {
            return null;
        }
        return (PluginRule)this.listOfRules.get(index);
    }

    public void addUnitDefinition(PluginUnitDefinition unit) {
        if (this.listOfUnitDefinitions == null) {
            this.listOfUnitDefinitions = new PluginListOf();
        }
        this.listOfUnitDefinitions.append(unit);
    }

    public void removeUnitDefinition(PluginUnitDefinition unit) {
        if (this.listOfUnitDefinitions == null) {
            return;
        }
        if (unit == null) {
            return;
        }
        this.listOfUnitDefinitions.remove(unit);
    }

    public void removeUnitDefinition(String id) {
        if (this.listOfUnitDefinitions == null) {
            return;
        }
        if (id == null) {
            return;
        }
        int i = 0;
        while (i < this.listOfUnitDefinitions.size()) {
            PluginUnitDefinition sp = this.getUnitDefinition(i);
            if (sp.getId().equals(id)) {
                this.listOfUnitDefinitions.remove(i);
                return;
            }
            ++i;
        }
    }

    public void removeUnitDefinition(int index) {
        if (this.listOfUnitDefinitions == null) {
            return;
        }
        if (index < 0 || index >= this.listOfUnitDefinitions.size()) {
            return;
        }
        this.listOfUnitDefinitions.remove(index);
    }

    public PluginUnitDefinition getUnitDefinition(int index) {
        if (this.listOfUnitDefinitions == null) {
            return null;
        }
        if (index < 0 || index >= this.listOfUnitDefinitions.size()) {
            return null;
        }
        return (PluginUnitDefinition)this.listOfUnitDefinitions.get(index);
    }

    public PluginUnitDefinition getUnitDefinition(String id) {
        if (this.listOfUnitDefinitions == null) {
            return null;
        }
        if (id == null) {
            return null;
        }
        int i = 0;
        while (i < this.listOfUnitDefinitions.size()) {
            PluginUnitDefinition sp = this.getUnitDefinition(i);
            if (sp.getId().equals(id)) {
                return sp;
            }
            ++i;
        }
        return null;
    }

    public void addSpeciesType(PluginSpeciesType speciesType) {
        if (this.listOfSpeciesTypes == null) {
            this.listOfSpeciesTypes = new PluginListOf();
        }
        this.listOfSpeciesTypes.append(speciesType);
    }

    public void removeSpeciesType(PluginSpeciesType speciesType) {
        if (this.listOfSpeciesTypes == null) {
            return;
        }
        if (speciesType == null) {
            return;
        }
        this.listOfSpeciesTypes.remove(speciesType);
    }

    public void removeSpeciesType(String id) {
        if (this.listOfSpeciesTypes == null) {
            return;
        }
        if (id == null) {
            return;
        }
        int i = 0;
        while (i < this.listOfSpeciesTypes.size()) {
            PluginSpeciesType st = this.getSpeciesType(i);
            if (st.getId().equals(id)) {
                this.listOfSpeciesTypes.remove(i);
                return;
            }
            ++i;
        }
    }

    public void removeSpeciesType(int index) {
        if (this.listOfSpeciesTypes == null) {
            return;
        }
        if (index < 0 || index >= this.listOfSpeciesTypes.size()) {
            return;
        }
        this.listOfSpeciesTypes.remove(index);
    }

    public PluginSpeciesType getSpeciesType(int index) {
        if (this.listOfSpeciesTypes == null) {
            return null;
        }
        if (index < 0 || index >= this.listOfSpeciesTypes.size()) {
            return null;
        }
        return (PluginSpeciesType)this.listOfSpeciesTypes.get(index);
    }

    public PluginSpeciesType getSpeciesType(String id) {
        if (this.listOfSpeciesTypes == null) {
            return null;
        }
        if (id == null) {
            return null;
        }
        int i = 0;
        while (i < this.listOfSpeciesTypes.size()) {
            PluginSpeciesType st = this.getSpeciesType(i);
            if (st.getId().equals(id)) {
                return st;
            }
            ++i;
        }
        return null;
    }

    public void addCompartmentType(PluginCompartmentType compartmentType) {
        if (this.listOfCompartmentTypes == null) {
            this.listOfCompartmentTypes = new PluginListOf();
        }
        this.listOfCompartmentTypes.append(compartmentType);
    }

    public void removeCompartmentType(PluginCompartmentType compartmentType) {
        if (this.listOfCompartmentTypes == null) {
            return;
        }
        if (compartmentType == null) {
            return;
        }
        this.listOfCompartmentTypes.remove(compartmentType);
    }

    public void removeCompartmentType(String id) {
        if (this.listOfCompartmentTypes == null) {
            return;
        }
        if (id == null) {
            return;
        }
        int i = 0;
        while (i < this.listOfCompartmentTypes.size()) {
            PluginCompartmentType st = this.getCompartmentType(i);
            if (st.getId().equals(id)) {
                this.listOfCompartmentTypes.remove(i);
                return;
            }
            ++i;
        }
    }

    public void removeCompartmentType(int index) {
        if (this.listOfCompartmentTypes == null) {
            return;
        }
        if (index < 0 || index >= this.listOfCompartmentTypes.size()) {
            return;
        }
        this.listOfCompartmentTypes.remove(index);
    }

    public PluginCompartmentType getCompartmentType(int index) {
        if (this.listOfCompartmentTypes == null) {
            return null;
        }
        if (index < 0 || index >= this.listOfCompartmentTypes.size()) {
            return null;
        }
        return (PluginCompartmentType)this.listOfCompartmentTypes.get(index);
    }

    public PluginCompartmentType getCompartmentType(String id) {
        if (this.listOfCompartmentTypes == null) {
            return null;
        }
        if (id == null) {
            return null;
        }
        int i = 0;
        while (i < this.listOfCompartmentTypes.size()) {
            PluginCompartmentType st = this.getCompartmentType(i);
            if (st.getId().equals(id)) {
                return st;
            }
            ++i;
        }
        return null;
    }

    public void addInitialAssignment(PluginInitialAssignment initialAssignment) {
        if (this.listOfInitialAssignments == null) {
            this.listOfInitialAssignments = new PluginListOf();
        }
        this.listOfInitialAssignments.append(initialAssignment);
    }

    public void removeInitialAssignment(PluginInitialAssignment initialAssignment) {
        if (this.listOfInitialAssignments == null) {
            return;
        }
        if (initialAssignment == null) {
            return;
        }
        this.listOfInitialAssignments.remove(initialAssignment);
    }

    public void removeInitialAssignment(String symbol) {
        if (this.listOfInitialAssignments == null) {
            return;
        }
        if (symbol == null) {
            return;
        }
        int i = 0;
        while (i < this.listOfInitialAssignments.size()) {
            PluginInitialAssignment st = this.getInitialAssignment(i);
            if (st.getSymbol().equals(symbol)) {
                this.listOfInitialAssignments.remove(i);
                return;
            }
            ++i;
        }
    }

    public void removeInitialAssignment(int index) {
        if (this.listOfInitialAssignments == null) {
            return;
        }
        if (index < 0 || index >= this.listOfInitialAssignments.size()) {
            return;
        }
        this.listOfInitialAssignments.remove(index);
    }

    public PluginInitialAssignment getInitialAssignment(int index) {
        if (this.listOfInitialAssignments == null) {
            return null;
        }
        if (index < 0 || index >= this.listOfInitialAssignments.size()) {
            return null;
        }
        return (PluginInitialAssignment)this.listOfInitialAssignments.get(index);
    }

    public PluginInitialAssignment getInitialAssignment(String symbol) {
        if (this.listOfInitialAssignments == null) {
            return null;
        }
        if (symbol == null) {
            return null;
        }
        int i = 0;
        while (i < this.listOfInitialAssignments.size()) {
            PluginInitialAssignment st = this.getInitialAssignment(i);
            if (st.getSymbol().equals(symbol)) {
                return st;
            }
            ++i;
        }
        return null;
    }

    public void addConstraint(PluginConstraint constraint) {
        if (this.listOfConstraints == null) {
            this.listOfConstraints = new PluginListOf();
        }
        this.listOfConstraints.append(constraint);
    }

    public void removeConstraint(PluginConstraint constraint) {
        if (constraint == null) {
            return;
        }
        if (constraint == null) {
            return;
        }
        this.listOfConstraints.remove(constraint);
    }

    public void removeConstraint(String strMath) {
        if (this.listOfConstraints == null) {
            return;
        }
        if (strMath == null) {
            return;
        }
        int i = 0;
        while (i < this.listOfConstraints.size()) {
            PluginConstraint st = this.getConstraint(i);
            if (st.getMath().equals(strMath)) {
                this.listOfConstraints.remove(i);
                return;
            }
            ++i;
        }
    }

    public void removeConstraint(int index) {
        if (this.listOfConstraints == null) {
            return;
        }
        if (index < 0 || index >= this.listOfConstraints.size()) {
            return;
        }
        this.listOfConstraints.remove(index);
    }

    public PluginConstraint getConstraint(int index) {
        if (this.listOfConstraints == null) {
            return null;
        }
        if (index < 0 || index >= this.listOfConstraints.size()) {
            return null;
        }
        return (PluginConstraint)this.listOfConstraints.get(index);
    }

    public PluginConstraint getConstraint(String strMath) {
        if (this.listOfConstraints == null) {
            return null;
        }
        if (strMath == null) {
            return null;
        }
        int i = 0;
        while (i < this.listOfConstraints.size()) {
            PluginConstraint st = this.getConstraint(i);
            if (st.getMath().equals(strMath)) {
                return st;
            }
            ++i;
        }
        return null;
    }

    public int getNumSpecies() {
        if (this.listOfSpecies == null) {
            return 0;
        }
        return this.listOfSpecies.size();
    }

    public int getNumReactions() {
        if (this.listOfReactions == null) {
            return 0;
        }
        return this.listOfReactions.size();
    }

    public int getNumCompartments() {
        if (this.listOfCompartments == null) {
            return 0;
        }
        return this.listOfCompartments.size();
    }

    public int getNumEvents() {
        if (this.listOfEvents == null) {
            return 0;
        }
        return this.listOfEvents.size();
    }

    public int getNumParameters() {
        if (this.listOfParameters == null) {
            return 0;
        }
        return this.listOfParameters.size();
    }

    public int getNumFunctionDefinitions() {
        if (this.listOfFunctionDefinitions == null) {
            return 0;
        }
        return this.listOfFunctionDefinitions.size();
    }

    public int getNumRules() {
        if (this.listOfRules == null) {
            return 0;
        }
        return this.listOfRules.size();
    }

    public int getNumUnitDefinitions() {
        if (this.listOfUnitDefinitions == null) {
            return 0;
        }
        return this.listOfUnitDefinitions.size();
    }

    public int getNumSpeciesTypes() {
        if (this.listOfSpeciesTypes == null) {
            return 0;
        }
        return this.listOfSpeciesTypes.size();
    }

    public int getNumCompartmentTypes() {
        if (this.listOfCompartmentTypes == null) {
            return 0;
        }
        return this.listOfCompartmentTypes.size();
    }

    public int getNumInitialAssignments() {
        if (this.listOfInitialAssignments == null) {
            return 0;
        }
        return this.listOfInitialAssignments.size();
    }

    public int getNumConstraints() {
        if (this.listOfConstraints == null) {
            return 0;
        }
        return this.listOfConstraints.size();
    }

    private void appendAntiSenseRNA(PluginAntiSenseRNA rna) {
        if (this.listOfAntiSenseRNAs == null) {
            this.listOfAntiSenseRNAs = new PluginListOf();
        }
        boolean isExist = false;
        int k = 0;
        while (k < this.listOfAntiSenseRNAs.size()) {
            PluginAntiSenseRNA input = (PluginAntiSenseRNA)this.listOfAntiSenseRNAs.get(k);
            if (rna.getExtensionId().equals(input.getExtensionId())) {
                isExist = true;
                break;
            }
            ++k;
        }
        if (!isExist) {
            this.listOfAntiSenseRNAs.append(rna);
        }
    }

    public PluginAntiSenseRNA getAntiSenseRNA(String id) {
        if (this.listOfAntiSenseRNAs == null) {
            return null;
        }
        if (id == null) {
            return null;
        }
        int i = 0;
        while (i < this.listOfAntiSenseRNAs.size()) {
            PluginAntiSenseRNA sp = (PluginAntiSenseRNA)this.listOfAntiSenseRNAs.get(i);
            if (sp.getExtensionId().equals(id)) {
                return sp;
            }
            ++i;
        }
        return null;
    }

    public PluginListOf getListOfAntiSenseRNAs() {
        return this.listOfAntiSenseRNAs;
    }

    public PluginListOf getListOfSpecies(PluginAntiSenseRNA rna) {
        PluginListOf listOf = new PluginListOf();
        if (this.listOfSpecies == null) {
            return listOf;
        }
        int i = 0;
        while (i < this.listOfSpecies.size()) {
            PluginSpecies sp = this.getSpecies(i);
            if (sp.getSpeciesAlias(0).getAntiSenseRNA() != null && sp.getSpeciesAlias(0).getExtensionType().equals(rna.getType()) && sp.getSpeciesAlias(0).getExtensionId().equals(rna.getExtensionId())) {
                listOf.append(sp);
            }
            ++i;
        }
        return listOf;
    }

    public void setListOfAntiSenseRNAs(PluginListOf listOfAntiSenseRNAs) {
        this.listOfAntiSenseRNAs = listOfAntiSenseRNAs;
    }

    public void removeAntiSenseRNA(PluginAntiSenseRNA rna) {
        if (this.listOfAntiSenseRNAs == null) {
            return;
        }
        if (rna == null) {
            return;
        }
        int i = 0;
        while (i < this.listOfAntiSenseRNAs.size()) {
            PluginAntiSenseRNA sp = (PluginAntiSenseRNA)this.listOfAntiSenseRNAs.get(i);
            if (sp.getExtensionId().equals(rna.getExtensionId())) {
                this.listOfAntiSenseRNAs.remove(i);
                return;
            }
            ++i;
        }
    }

    public void removeAntiSenseRNA(int index) {
        if (this.listOfAntiSenseRNAs == null) {
            return;
        }
        if (index < 0 || index >= this.listOfAntiSenseRNAs.size()) {
            return;
        }
        this.listOfAntiSenseRNAs.remove(index);
    }

    private void appendGene(PluginGene gene) {
        if (this.listOfGenes == null) {
            this.listOfGenes = new PluginListOf();
        }
        boolean isExist = false;
        int k = 0;
        while (k < this.listOfGenes.size()) {
            PluginGene input = (PluginGene)this.listOfGenes.get(k);
            if (gene.getExtensionId().equals(input.getExtensionId())) {
                isExist = true;
                break;
            }
            ++k;
        }
        if (!isExist) {
            this.listOfGenes.append(gene);
        }
    }

    public PluginGene getGene(String id) {
        if (this.listOfGenes == null) {
            return null;
        }
        if (id == null) {
            return null;
        }
        int i = 0;
        while (i < this.listOfGenes.size()) {
            PluginGene sp = (PluginGene)this.listOfGenes.get(i);
            if (sp.getExtensionId().equals(id)) {
                return sp;
            }
            ++i;
        }
        return null;
    }

    public PluginListOf getListOfGenes() {
        return this.listOfGenes;
    }

    public PluginListOf getListOfSpecies(PluginGene rna) {
        PluginListOf listOf = new PluginListOf();
        if (this.listOfSpecies == null) {
            return listOf;
        }
        int i = 0;
        while (i < this.listOfSpecies.size()) {
            PluginSpecies sp = this.getSpecies(i);
            if (sp.getSpeciesAlias(0).getGene() != null && sp.getSpeciesAlias(0).getExtensionType().equals(rna.getType()) && sp.getSpeciesAlias(0).getExtensionId().equals(rna.getExtensionId())) {
                listOf.append(sp);
            }
            ++i;
        }
        return listOf;
    }

    public void setListOfGenes(PluginListOf listOfGenes) {
        this.listOfGenes = listOfGenes;
    }

    public void removeGene(PluginGene rna) {
        if (this.listOfGenes == null) {
            return;
        }
        if (rna == null) {
            return;
        }
        int i = 0;
        while (i < this.listOfGenes.size()) {
            PluginGene sp = (PluginGene)this.listOfGenes.get(i);
            if (sp.getExtensionId().equals(rna.getExtensionId())) {
                this.listOfGenes.remove(i);
                return;
            }
            ++i;
        }
    }

    public void removeGene(int index) {
        if (this.listOfGenes == null) {
            return;
        }
        if (index < 0 || index >= this.listOfGenes.size()) {
            return;
        }
        this.listOfGenes.remove(index);
    }

    public void appendProtein(PluginProtein protein) {
        if (this.listOfProteins == null) {
            this.listOfProteins = new PluginListOf();
        }
        boolean isExist = false;
        int k = 0;
        while (k < this.listOfProteins.size()) {
            PluginProtein input = (PluginProtein)this.listOfProteins.get(k);
            if (protein.getExtensionId().equals(input.getExtensionId())) {
                isExist = true;
                break;
            }
            ++k;
        }
        if (!isExist) {
            this.listOfProteins.append(protein);
        }
    }

    public PluginProtein getProtein(String id) {
        if (this.listOfProteins == null) {
            return null;
        }
        if (id == null) {
            return null;
        }
        int i = 0;
        while (i < this.listOfProteins.size()) {
            PluginProtein sp = (PluginProtein)this.listOfProteins.get(i);
            if (sp.getExtensionId().equals(id)) {
                return sp;
            }
            ++i;
        }
        return null;
    }

    public PluginListOf getListOfProteins() {
        return this.listOfProteins;
    }

    public PluginListOf getListOfSpecies(PluginProtein rna) {
        PluginListOf listOf = new PluginListOf();
        if (this.listOfSpecies == null) {
            return listOf;
        }
        int i = 0;
        while (i < this.listOfSpecies.size()) {
            PluginSpecies sp = this.getSpecies(i);
            if (sp.getSpeciesAlias(0).getProtein() != null && sp.getSpeciesAlias(0).getExtensionType().equals(rna.getType()) && sp.getSpeciesAlias(0).getExtensionId().equals(rna.getExtensionId())) {
                listOf.append(sp);
            }
            ++i;
        }
        return listOf;
    }

    public void setListOfProteins(PluginListOf listOfProteins) {
        this.listOfProteins = listOfProteins;
    }

    public void removeProtein(PluginProtein rna) {
        if (this.listOfProteins == null) {
            return;
        }
        if (rna == null) {
            return;
        }
        int i = 0;
        while (i < this.listOfProteins.size()) {
            PluginProtein sp = (PluginProtein)this.listOfProteins.get(i);
            if (sp.getExtensionId().equals(rna.getExtensionId())) {
                this.listOfProteins.remove(i);
                return;
            }
            ++i;
        }
    }

    public void removeProtein(int index) {
        if (this.listOfProteins == null) {
            return;
        }
        if (index < 0 || index >= this.listOfProteins.size()) {
            return;
        }
        this.listOfProteins.remove(index);
    }

    private void appendRNA(PluginRNA rna) {
        if (this.listOfRNAs == null) {
            this.listOfRNAs = new PluginListOf();
        }
        boolean isExist = false;
        int k = 0;
        while (k < this.listOfRNAs.size()) {
            PluginRNA input = (PluginRNA)this.listOfRNAs.get(k);
            if (rna.getExtensionId().equals(input.getExtensionId())) {
                isExist = true;
                break;
            }
            ++k;
        }
        if (!isExist) {
            this.listOfRNAs.append(rna);
        }
    }

    public PluginRNA getRNA(String id) {
        if (this.listOfRNAs == null) {
            return null;
        }
        if (id == null) {
            return null;
        }
        int i = 0;
        while (i < this.listOfRNAs.size()) {
            PluginRNA sp = (PluginRNA)this.listOfRNAs.get(i);
            if (sp.getExtensionId().equals(id)) {
                return sp;
            }
            ++i;
        }
        return null;
    }

    public PluginListOf getListOfRNAs() {
        return this.listOfRNAs;
    }

    public PluginListOf getListOfSpecies(PluginRNA rna) {
        PluginListOf listOf = new PluginListOf();
        if (this.listOfSpecies == null) {
            return listOf;
        }
        int i = 0;
        while (i < this.listOfSpecies.size()) {
            PluginSpecies sp = this.getSpecies(i);
            if (sp.getSpeciesAlias(0).getRNA() != null && sp.getSpeciesAlias(0).getExtensionType().equals(rna.getType()) && sp.getSpeciesAlias(0).getExtensionId().equals(rna.getExtensionId())) {
                listOf.append(sp);
            }
            ++i;
        }
        return listOf;
    }

    public void setListOfRNAs(PluginListOf listOfRNAs) {
        this.listOfRNAs = listOfRNAs;
    }

    public void removeRNA(PluginRNA rna) {
        if (this.listOfRNAs == null) {
            return;
        }
        if (rna == null) {
            return;
        }
        int i = 0;
        while (i < this.listOfRNAs.size()) {
            PluginRNA sp = (PluginRNA)this.listOfRNAs.get(i);
            if (sp.getExtensionId().equals(rna.getExtensionId())) {
                this.listOfRNAs.remove(i);
                return;
            }
            ++i;
        }
    }

    public void removeRNA(int index) {
        if (this.listOfRNAs == null) {
            return;
        }
        if (index < 0 || index >= this.listOfRNAs.size()) {
            return;
        }
        this.listOfRNAs.remove(index);
    }

    public PluginListOf getListOfAllSpeciesAlias() {
        PluginListOf listOf = new PluginListOf();
        if (this.listOfSpecies == null) {
            return listOf;
        }
        int i = 0;
        while (i < this.listOfSpecies.size()) {
            PluginSpecies sp = this.getSpecies(i);
            int k = 0;
            while (k < sp.getListOfSpeciesAlias().size()) {
                listOf.append(sp.getSpeciesAlias(k));
                ++k;
            }
            ++i;
        }
        return listOf;
    }

    public PluginSpeciesAlias getPluginSpeciesAlias(String aliasID) {
        if (this.listOfSpecies == null) {
            return null;
        }
        if (aliasID == null) {
            return null;
        }
        int i = 0;
        while (i < this.listOfSpecies.size()) {
            PluginSpecies sp = this.getSpecies(i);
            int k = 0;
            while (k < sp.getListOfSpeciesAlias().size()) {
                PluginSpeciesAlias alias = sp.getSpeciesAlias(k);
                if (alias.getAliasID().equals(aliasID)) {
                    return alias;
                }
                ++k;
            }
            ++i;
        }
        return null;
    }

    public PluginListOf getListOfAllSpeciesAlias(String speciesid) {
        PluginListOf listOf = new PluginListOf();
        if (this.listOfSpecies == null) {
            return listOf;
        }
        if (speciesid == null || speciesid.trim().equals("")) {
            return listOf;
        }
        int i = 0;
        while (i < this.listOfSpecies.size()) {
            PluginSpecies sp = (PluginSpecies)this.listOfSpecies.get(i);
            if (speciesid.equals(sp.getId())) {
                int k = 0;
                while (k < sp.getListOfSpeciesAlias().size()) {
                    listOf.append(sp.getSpeciesAlias(k));
                    ++k;
                }
                break;
            }
            ++i;
        }
        return listOf;
    }

    public boolean isReferenceSameModel(PluginSBase any) {
        if (!(any instanceof PluginModel)) {
            return false;
        }
        if (this.modelBase == null) {
            return false;
        }
        return this.modelBase == ((PluginModel)any).modelBase;
    }

    public boolean isSameModel(Model any) {
        if (this.modelBase == null && any == null) {
            return true;
        }
        if (this.modelBase == null && any != null) {
            return false;
        }
        if (this.modelBase != null && any == null) {
            return false;
        }
        return this.modelBase == any;
    }
}

