/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.plugin;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import javax.swing.JOptionPane;
import jp.fric.graphics.multiwindow.FileManager;
import jp.fric.io.util.MyFileFilter;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.SBEventRecorder;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.plugin.InfoCenter.InfoUI.MappingArrayMassShowerMainWinFrm;
import jp.sbi.celldesigner.plugin.InfoCenter.InfoUI.RsltDtBindingFrm;
import jp.sbi.celldesigner.plugin.InfoCenter.InfoUI.RsltDtTpMdlSelectFrm;
import jp.sbi.celldesigner.plugin.PluginDoSthAbstractAction;
import jp.sbi.celldesigner.util.CelldUtil;

public abstract class PluginMassShowerAction
extends PluginDoSthAbstractAction {
    private static final String strNeedOpenXmlFileMessage = "Please open a Celldesigner XML data file.";
    private static final String strCreateModelErrMessage = "Can not create Model.";
    private static final String strOpenXmlFileErrMessage = "Can not open your file.";
    public static final String OpenXlsFileErrorMsg = "The excel file you selected is not satisfied.";
    private static final String strCannotChangeintoPluginModelErrMessage = "Can not start plugin mode.";
    private boolean bShowGuideMsgFlg = false;

    @Override
    public final void actionPerformed(ActionEvent e) {
        RsltDtBindingFrm rdfrm;
        RsltDtTpMdlSelectFrm mdlselectfrm;
        block27: {
            File xlsfile;
            MainWindow mainwin;
            SBEventRecorder.addLog(String.valueOf(SBEventRecorder.getOperationName(30)) + "\tOBJECTLIST=[]");
            boolean canuseCurrMdl = false;
            MainWindow parentfrm = mainwin = MainWindow.getLastInstance();
            try {
                MainWindow.getLastInstance().getCurrentModel().getSBModel();
                if (!MappingArrayMassShowerMainWinFrm.havehadAMappingArrayMassShowerMainWinFrmInstanceInCurrentGStructure(false)) {
                    canuseCurrMdl = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            mdlselectfrm = new RsltDtTpMdlSelectFrm(parentfrm);
            mdlselectfrm.initDialog(false, 0, 0, canuseCurrMdl);
            mdlselectfrm.setVisible(true);
            if (mdlselectfrm.isCanceled()) {
                return;
            }
            boolean bNeedNewModel = mdlselectfrm.getNewModelRadioButton().isSelected();
            boolean bNeedCurrModel = mdlselectfrm.getCurrentModelRadioButton().isSelected();
            boolean bNeedOpenXmlFile = mdlselectfrm.getOpenXmlFileRadioButton().isSelected();
            if (bNeedCurrModel && MappingArrayMassShowerMainWinFrm.havehadAMappingArrayMassShowerMainWinFrmInstanceInCurrentGStructure(true)) {
                return;
            }
            int modelType = -1;
            if (bNeedNewModel) {
                modelType = 1;
            } else if (bNeedCurrModel) {
                modelType = 2;
            } else if (bNeedOpenXmlFile) {
                modelType = 3;
            }
            File xmlfile = null;
            if (bNeedOpenXmlFile) {
                MyFileFilter xmlFilter = new MyFileFilter(new String[]{"xml"}, "XML  Files");
                MyFileFilter[] fileFilters = new MyFileFilter[]{xmlFilter};
                if (bNeedOpenXmlFile) {
                    Object objRtn;
                    if (this.bShowGuideMsgFlg) {
                        JOptionPane.showOptionDialog(parentfrm, strNeedOpenXmlFileMessage, "Information", -1, 1, null, null, null);
                    }
                    if ((objRtn = FileManager.openMyFile(MainWindow.getLastInstance().getMyFrame(), fileFilters, ".")) instanceof Integer) {
                        int iCancel;
                        int iRtn = (Integer)objRtn;
                        if (iRtn != (iCancel = 1)) {
                            JOptionPane.showMessageDialog(parentfrm, strOpenXmlFileErrMessage, "Notice", 0);
                        }
                        return;
                    }
                    if (!(objRtn instanceof File)) {
                        JOptionPane.showMessageDialog(parentfrm, strOpenXmlFileErrMessage, "Notice", 0);
                        return;
                    }
                    xmlfile = (File)objRtn;
                    if (xmlfile == null) {
                        JOptionPane.showMessageDialog(parentfrm, strOpenXmlFileErrMessage, "Notice", 0);
                        return;
                    }
                }
            }
            int dataType = mdlselectfrm.getmicroArrayRadioButton().isSelected() ? 1 : 2;
            if (this.bShowGuideMsgFlg) {
                String stype = "microarray";
                if (dataType == 2) {
                    stype = "proteomics";
                }
                String strNeedOpenDataFileMessage = "Please open a " + stype + " data file.";
                JOptionPane.showOptionDialog(parentfrm, strNeedOpenDataFileMessage, "Information", -1, 1, null, null, null);
            }
            if ((xlsfile = RsltDtBindingFrm.openXlsFile(parentfrm)) == null) {
                return;
            }
            List datas = CelldUtil.getDataFromExcelFile(xlsfile);
            if (datas == null || datas.size() == 0) {
                JOptionPane.showMessageDialog(parentfrm, OpenXlsFileErrorMsg, "Error", 0);
                return;
            }
            rdfrm = new RsltDtBindingFrm(parentfrm, xlsfile, datas, dataType, modelType);
            rdfrm.setVisible(true);
            if (rdfrm.isCanceled()) {
                return;
            }
            if (bNeedNewModel) {
                try {
                    xmlfile = SBModel.getBaseModelXmlFile(null);
                    if (!MainWindow.getLastInstance().setPluginStartedEvent(e, xmlfile, true, false)) {
                        throw new Exception();
                    }
                    break block27;
                }
                catch (Exception myErr) {
                    JOptionPane.showMessageDialog(parentfrm, strCreateModelErrMessage, "Error", 0);
                    return;
                }
            }
            if (!bNeedCurrModel && bNeedOpenXmlFile && !MainWindow.getLastInstance().setPluginStartedEvent(e, xmlfile, false, true)) {
                JOptionPane.showMessageDialog(parentfrm, strCannotChangeintoPluginModelErrMessage, "Notice", 0);
                return;
            }
        }
        MappingArrayMassShowerMainWinFrm showerfrm = new MappingArrayMassShowerMainWinFrm(mdlselectfrm, rdfrm, this.bShowGuideMsgFlg);
        showerfrm.setFirstRun(false);
    }

    public void setShowGuideMsgFlg(boolean flg) {
        this.bShowGuideMsgFlg = flg;
    }

    public boolean isShowGuideMsg() {
        return this.bShowGuideMsgFlg;
    }
}

