/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.plugin;

import jp.sbi.celldesigner.plugin.PluginListOf;
import jp.sbi.celldesigner.plugin.PluginParameter;
import jp.sbi.celldesigner.plugin.PluginReaction;
import jp.sbi.celldesigner.plugin.PluginSBase;
import org.sbml.libsbml.ASTNode;
import org.sbml.libsbml.KineticLaw;
import org.sbml.libsbml.libsbml;

public class PluginKineticLaw
extends PluginSBase {
    private PluginListOf listOfParameters;

    public PluginKineticLaw(PluginReaction parent) {
        this.sbase = new KineticLaw();
        this.setParentSBase(parent);
        this.listOfParameters = new PluginListOf(this);
    }

    public void update(PluginKineticLaw kineticLaw) {
        this.setNotes(kineticLaw.getNotes());
        this.setFormula(kineticLaw.getFormula());
        this.setListOfParameters(kineticLaw.getListOfParameters());
        if (kineticLaw.getMath() != null) {
            this.setMath(libsbml.parseFormula((String)libsbml.formulaToString((ASTNode)kineticLaw.getMath())));
        }
        this.setSubstanceUnits(kineticLaw.getSubstanceUnits());
        this.setTimeUnits(kineticLaw.getTimeUnits());
        this.setAnnotation(kineticLaw.getAnnotation());
    }

    public PluginListOf getListOfParameters() {
        return this.listOfParameters;
    }

    public void setListOfParameters(PluginListOf listOfParameters) {
        this.listOfParameters = listOfParameters;
    }

    public void addParameter(PluginParameter param) {
        if (this.listOfParameters == null) {
            this.listOfParameters = new PluginListOf();
        }
        this.listOfParameters.append(param);
    }

    public void removeParameter(PluginParameter param) {
        if (this.listOfParameters == null) {
            return;
        }
        if (param == null) {
            return;
        }
        this.listOfParameters.remove(param);
    }

    public void removeParameter(int index) {
        if (this.listOfParameters == null) {
            return;
        }
        if (index < 0 || index >= this.listOfParameters.size()) {
            return;
        }
        this.listOfParameters.remove(index);
    }

    public PluginParameter getParameter(int index) {
        if (this.listOfParameters == null) {
            return null;
        }
        if (index < 0 || index >= this.listOfParameters.size()) {
            return null;
        }
        return (PluginParameter)this.listOfParameters.get(index);
    }

    public void clear() {
        if (this.listOfParameters == null) {
            return;
        }
        this.listOfParameters.clear();
    }

    public String getFormula() {
        return ((KineticLaw)this.sbase).getFormula();
    }

    public void setFormula(String fomula) {
        ((KineticLaw)this.sbase).setFormula(fomula);
    }

    public ASTNode getMath() {
        return ((KineticLaw)this.sbase).getMath();
    }

    public void setMath(ASTNode math) {
        ((KineticLaw)this.sbase).setMath(math);
    }

    public void setFormulaFromMath() {
    }

    public void setMathFromFormula() {
    }

    public String getSubstanceUnits() {
        return ((KineticLaw)this.sbase).getSubstanceUnits();
    }

    public void setSubstanceUnits(String unit) {
        ((KineticLaw)this.sbase).setSubstanceUnits(unit);
    }

    public String getTimeUnits() {
        return ((KineticLaw)this.sbase).getTimeUnits();
    }

    public void setTimeUnits(String unit) {
        ((KineticLaw)this.sbase).setTimeUnits(unit);
    }

    public String getParentReactionID() {
        if (this.getParentSBase() instanceof PluginReaction) {
            return ((PluginReaction)this.getParentSBase()).getId();
        }
        return null;
    }

    public PluginReaction getParentReaction() {
        if (this.getParentSBase() instanceof PluginReaction) {
            return (PluginReaction)this.getParentSBase();
        }
        return null;
    }

    public int getNumParameters() {
        if (this.listOfParameters == null) {
            return 0;
        }
        return this.listOfParameters.size();
    }
}

