/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.plugin;

import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.plugin.PluginListOf;
import jp.sbi.celldesigner.plugin.PluginModificationRegion;
import jp.sbi.celldesigner.plugin.PluginSBase;
import org.sbml.libsbml.Species;

public class PluginGene
extends PluginSBase {
    private String extensionId;
    private String type;
    private String name;
    private PluginListOf listOfPluginRegion;

    protected PluginGene() {
        this.sbase = new Species();
        SBModel sbModel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
        this.extensionId = sbModel.createNewGeneId();
        this.listOfPluginRegion = new PluginListOf();
    }

    protected PluginGene(String extensionId) {
        this.sbase = new Species();
        this.extensionId = extensionId;
        this.listOfPluginRegion = new PluginListOf();
    }

    public void update(PluginGene rna) {
        this.setName(rna.getName());
        this.setNotes(rna.getNotes());
        this.setType(rna.getType());
        this.setAnnotation(rna.getAnnotation());
    }

    public String getExtensionId() {
        return this.extensionId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public PluginListOf getListOfPluginRegion() {
        return this.listOfPluginRegion;
    }

    public void setListOfPluginRegion(PluginListOf listOfPluginRegion) {
        this.listOfPluginRegion = listOfPluginRegion;
    }

    public void addPluginModificationRegion(PluginModificationRegion residue) {
        if (this.listOfPluginRegion == null) {
            this.listOfPluginRegion = new PluginListOf();
        }
        this.listOfPluginRegion.append(residue);
    }

    public void removePluginModificationRegion(PluginModificationRegion residue) {
        if (this.listOfPluginRegion == null) {
            return;
        }
        if (residue == null) {
            return;
        }
        this.listOfPluginRegion.remove(residue);
    }

    public void removePluginModificationRegion(int index) {
        if (this.listOfPluginRegion == null) {
            return;
        }
        if (index < 0 || index >= this.listOfPluginRegion.size()) {
            return;
        }
        this.listOfPluginRegion.remove(index);
    }

    public PluginModificationRegion getPluginModificationRegion(int index) {
        if (this.listOfPluginRegion == null) {
            return null;
        }
        if (index < 0 || index >= this.listOfPluginRegion.size()) {
            return null;
        }
        return (PluginModificationRegion)this.listOfPluginRegion.get(index);
    }

    public int getNumRegions() {
        if (this.listOfPluginRegion == null) {
            return 0;
        }
        return this.listOfPluginRegion.size();
    }
}

