/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.plugin;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import jp.fric.graphics.draw.GLinkedShape;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.ReactionLink;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.plugin.PluginListOf;
import jp.sbi.celldesigner.plugin.PluginModifierSpeciesReference;
import jp.sbi.celldesigner.plugin.PluginReaction;
import jp.sbi.celldesigner.plugin.PluginSBase;
import jp.sbi.celldesigner.plugin.PluginSBaseConverter;
import jp.sbi.celldesigner.plugin.PluginSpecies;
import jp.sbi.celldesigner.plugin.PluginSpeciesAlias;
import jp.sbi.celldesigner.sbmlExtension.ReactionAnnotation;
import jp.sbi.celldesigner.symbol.reaction.GLogicGate;
import jp.sbi.sbml.util.LibSBMLUtil;
import org.sbml.libsbml.Model;
import org.sbml.libsbml.Reaction;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Species;

public class PluginGLogicGate
extends PluginSBase {
    private ArrayList al_modifiers;
    private String modificationType;
    private String gLogicGateType;
    private Vector vctSpeciesAliases = new Vector();
    private ReactionLink gateLink = null;
    private PluginModifierSpeciesReference[] modRef = null;
    private Color gateColor;
    private double lineWidth;
    private PluginReaction parent;
    private boolean isStarted = false;
    private SBModel sbml;
    private PluginListOf refsOfGateInReaction = new PluginListOf();

    public PluginGLogicGate(PluginReaction parent, Vector vctSpecs) {
        this(parent, vctSpecs, "BOOLEAN_LOGIC_GATE_AND", "CATALYSIS");
    }

    public PluginGLogicGate(PluginReaction parent, Vector vctSpecs, String strGateType) {
        this(parent, vctSpecs, strGateType, "CATALYSIS");
    }

    public PluginGLogicGate(PluginReaction pParent, Vector vctSpecs, String strGateType, String sModType) {
        this.sbml = MainWindow.getLastInstance().getCurrentModel().getSBModel();
        this.al_modifiers = new ArrayList();
        this.parent = pParent;
        this.modificationType = sModType;
        this.gLogicGateType = strGateType;
        if (vctSpecs != null) {
            this.vctSpeciesAliases.clear();
            this.modRef = new PluginModifierSpeciesReference[vctSpecs.size()];
            int i = 0;
            while (i < vctSpecs.size()) {
                if (vctSpecs.get(i) instanceof PluginSpeciesAlias) {
                    this.modRef[i] = new PluginModifierSpeciesReference(this.parent, (PluginSpeciesAlias)vctSpecs.get(i));
                    this.vctSpeciesAliases.add((PluginSpeciesAlias)vctSpecs.get(i));
                } else if (vctSpecs.get(i) instanceof PluginSpecies) {
                    this.modRef[i] = new PluginModifierSpeciesReference(this.parent, ((PluginSpecies)vctSpecs.get(i)).getSpeciesAlias(0));
                    this.vctSpeciesAliases.add(((PluginSpecies)vctSpecs.get(i)).getSpeciesAlias(0));
                }
                this.modRef[i].setModificationType(this.modificationType);
                this.addModifiers(this.modRef[i]);
                ++i;
            }
        }
        this.gateColor = Color.BLACK;
        this.lineWidth = 1.0;
    }

    public void setGLogicGateType(String gLogicGateType) {
        this.gLogicGateType = gLogicGateType;
    }

    public String getGLogicGateType() {
        return this.gLogicGateType;
    }

    public Color getColor() {
        return this.gateColor;
    }

    public void setColor(Color gateColor) {
        this.gateColor = gateColor;
    }

    public double getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(double lineWidth) {
        this.lineWidth = lineWidth;
    }

    public PluginReaction getParentReaction() {
        return this.parent;
    }

    public void setParentReaction(PluginReaction parent) {
        this.parent = parent;
    }

    public void setGateLink(ReactionLink link) {
        this.gateLink = link;
    }

    public void setGateSpeciesAliasesAndModificationType() {
        try {
            if (this.vctSpeciesAliases == null) {
                this.vctSpeciesAliases = new Vector();
            } else {
                this.vctSpeciesAliases.clear();
            }
            PluginListOf refs = this.getRefsOfGateInReaction();
            int i = 0;
            while (i < refs.size()) {
                PluginModifierSpeciesReference ref = (PluginModifierSpeciesReference)refs.get(i);
                this.addSpeciesAlias(ref.getAlias());
                if (this.modificationType == null && GLogicGate.isModificationType(ref.getModificationType())) {
                    this.modificationType = ref.getModificationType();
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setRefsOfGateInReaction(SBModel sbml, PluginGLogicGate pGate) {
        Model model = sbml.getModel();
        try {
            PluginReaction pRet = pGate.getParentReaction();
            Reaction target = model.getReaction(pRet.getId());
            ReactionAnnotation rannotation = (ReactionAnnotation)LibSBMLUtil.getAnnotation((SBase)target, null);
            List list = rannotation.getModificationLinks();
            PluginListOf refs = pRet.getListOfModifiers();
            ReactionLink link = this.getGateLink();
            GLinkedShape shape = link.getGLinkedShape();
            Vector children = ((GLogicGate)shape).getChildrenLink();
            int i = 0;
            while (i < children.size()) {
                ReactionLink mlink = (ReactionLink)children.get(i);
                int j = 0;
                block3: while (j < list.size()) {
                    ReactionLink tmpLink = (ReactionLink)list.get(j);
                    if (mlink.getName().equals(tmpLink.getName())) {
                        SpeciesAlias source = (SpeciesAlias)tmpLink.getTargetAt(0);
                        int k = 0;
                        while (k < refs.size()) {
                            Species targetSpecies;
                            PluginModifierSpeciesReference ref = (PluginModifierSpeciesReference)refs.get(k);
                            SpeciesAlias tmpSrc = sbml.getSpeciesAliasByRefAndSpecies(ref, targetSpecies = model.getSpecies(ref.getSpecies()));
                            if (tmpSrc.getName().equals(source.getName())) {
                                this.refsOfGateInReaction.append(ref);
                                break block3;
                            }
                            ++k;
                        }
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public PluginListOf getRefsOfGateInReaction() {
        if (this.refsOfGateInReaction.size() == 0) {
            this.setRefsOfGateInReaction(this.sbml, this);
        }
        return this.refsOfGateInReaction;
    }

    public ReactionLink getGateLink() {
        return this.gateLink;
    }

    public void addSpecies(PluginSpecies species) {
        this.vctSpeciesAliases.add(species.getSpeciesAlias(0));
    }

    public void addSpeciesAlias(PluginSpeciesAlias alias) {
        this.vctSpeciesAliases.add(alias);
    }

    public boolean addSpecies(String id) {
        if (this.vctSpeciesAliases == null || this.vctSpeciesAliases.size() == 0) {
            this.setGateSpeciesAliasesAndModificationType();
        }
        int i = 0;
        while (i < this.vctSpeciesAliases.size()) {
            String tmpId = ((PluginSpeciesAlias)this.vctSpeciesAliases.get(i)).getSpecies().getId();
            if (tmpId.equals(id)) {
                return false;
            }
            ++i;
        }
        Model model = this.sbml.getModel();
        Species targetSpecies = model.getSpecies(id);
        PluginSpecies pSpecies = (PluginSpecies)PluginSBaseConverter.convertToPluginSBase((SBase)targetSpecies);
        try {
            this.addSpeciesAlias(pSpecies.getSpeciesAlias(0));
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public Vector getSpeciesAliases() {
        return this.vctSpeciesAliases;
    }

    public void removeSpeciesAlias(int index) {
        if (this.vctSpeciesAliases != null && index >= 0 && index < this.vctSpeciesAliases.size()) {
            this.vctSpeciesAliases.remove(index);
        }
    }

    public boolean removeSpecies(String id) {
        boolean flag = false;
        if (this.vctSpeciesAliases == null || this.vctSpeciesAliases.size() == 0) {
            this.setGateSpeciesAliasesAndModificationType();
        }
        Vector tmpVct = new Vector();
        int i = 0;
        while (i < this.vctSpeciesAliases.size()) {
            String tmpId = ((PluginSpeciesAlias)this.vctSpeciesAliases.get(i)).getSpecies().getId();
            if (!tmpId.equals(id)) {
                tmpVct.add(this.vctSpeciesAliases.get(i));
            } else {
                flag = true;
            }
            ++i;
        }
        this.vctSpeciesAliases = tmpVct;
        return flag;
    }

    public void removeSpecies(PluginSpecies species) {
        if (this.vctSpeciesAliases != null && species != null) {
            String id = species.getId();
            this.removeSpecies(id);
        }
    }

    public void addModifiers(PluginModifierSpeciesReference pmsr1) {
        if (this.al_modifiers == null) {
            this.al_modifiers = new ArrayList();
        }
        this.al_modifiers.add(pmsr1);
    }

    public ArrayList getModifiers() {
        return this.al_modifiers;
    }

    public void setModificationType(String _modificationType) {
        this.modificationType = _modificationType;
    }

    public String getModificationType() {
        return this.modificationType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPluginGLogicGateEventStart() {
        PluginGLogicGate pluginGLogicGate = this;
        synchronized (pluginGLogicGate) {
            this.sbml.eventGroupBegan(null);
            if (!this.isStarted) {
                this.isStarted = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPluginGLogicGateEventEnd() {
        PluginGLogicGate pluginGLogicGate = this;
        synchronized (pluginGLogicGate) {
            try {
                this.sbml.eventGroupEnded(null);
                if (this.isStarted) {
                    this.isStarted = false;
                }
            }
            catch (Exception ex) {
                this.isStarted = false;
            }
        }
    }
}

