/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.plugin;

import java.awt.Color;
import jp.sbi.celldesigner.CompartmentAlias;
import jp.sbi.celldesigner.CompartmentSymbol;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.SBFactory;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.plugin.PluginInformationBox;
import jp.sbi.celldesigner.plugin.PluginSBase;
import jp.sbi.celldesigner.symbol.compartment.Membrane;
import org.sbml.libsbml.Compartment;

public class PluginCompartment
extends PluginSBase {
    private String type;
    private double x;
    private double y;
    private double width;
    private double height;
    private double thickness;
    private Color lineColor;
    private double outerWidth;
    private double innerWidth;
    private double nameX;
    private double nameY;
    private PluginInformationBox pluginInformationBox;

    public PluginCompartment(String _type) {
        this.sbase = new Compartment();
        this.type = _type;
        SBModel sbModel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
        ((Compartment)this.sbase).setId(sbModel.createNewCompartmentId());
        this.setDefaultValues(_type);
        this.pluginInformationBox = new PluginInformationBox();
    }

    protected PluginCompartment(String id, String _type) {
        this.sbase = new Compartment();
        this.type = _type;
        this.setDefaultValues(_type);
        ((Compartment)this.sbase).setId(id);
        this.pluginInformationBox = new PluginInformationBox();
    }

    public void update(PluginCompartment compartment) {
        this.setName(compartment.getName());
        this.setCompartmentTypeOfPanel(compartment.getCompartmentTypeOfPanel());
        this.setNotes(compartment.getNotes());
        this.setCompartmentType(compartment.getCompartmentType());
        this.setConstant(compartment.getConstant());
        this.setHeight(compartment.getHeight());
        this.setInnerWidth(compartment.getInnerWidth());
        this.setLineColor(compartment.getLineColor());
        this.setOuterWidth(compartment.getOuterWidth());
        this.setOutside(compartment.getOutside());
        this.setSize(compartment.getSize());
        this.setSpatialDimensions(compartment.getSpatialDimensions());
        this.setThickness(compartment.getThickness());
        this.setUnits(compartment.getUnits());
        this.setVolume(compartment.getVolume());
        this.setWidth(compartment.getWidth());
        this.setX(compartment.getX());
        this.setY(compartment.getY());
        this.setNamePositionX(compartment.getNamePositionX());
        this.setNamePositionY(compartment.getNamePositionY());
        this.pluginInformationBox = compartment.getPluginInformationBox();
        this.setAnnotation(compartment.getAnnotation());
    }

    public String getId() {
        return ((Compartment)this.sbase).getId();
    }

    public String getName() {
        return ((Compartment)this.sbase).getName();
    }

    public void setName(String name) {
        ((Compartment)this.sbase).setName(name);
    }

    public String getCompartmentTypeOfPanel() {
        return ((Compartment)this.sbase).getCompartmentType();
    }

    public void setCompartmentTypeOfPanel(String strCompartmentType) {
        ((Compartment)this.sbase).setCompartmentType(strCompartmentType);
    }

    public boolean getConstant() {
        return ((Compartment)this.sbase).getConstant();
    }

    public void setConstant(boolean constant) {
        ((Compartment)this.sbase).setConstant(constant);
    }

    public String getOutside() {
        return ((Compartment)this.sbase).getOutside();
    }

    public void setOutside(String outside) {
        ((Compartment)this.sbase).setOutside(outside);
    }

    public double getSize() {
        return ((Compartment)this.sbase).getSize();
    }

    public void setSize(double size) {
        ((Compartment)this.sbase).setSize(size);
    }

    public long getSpatialDimensions() {
        return ((Compartment)this.sbase).getSpatialDimensions();
    }

    public void setSpatialDimensions(long spatialDimensions) {
        ((Compartment)this.sbase).setSpatialDimensions(spatialDimensions);
    }

    public String getUnits() {
        return ((Compartment)this.sbase).getUnits();
    }

    public void setUnits(String unit) {
        ((Compartment)this.sbase).setUnits(unit);
    }

    public double getVolume() {
        return ((Compartment)this.sbase).getVolume();
    }

    public void setVolume(double volume) {
        ((Compartment)this.sbase).setVolume(volume);
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public double getInnerWidth() {
        return this.innerWidth;
    }

    public void setInnerWidth(double innerWidth) {
        this.innerWidth = innerWidth;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    public double getOuterWidth() {
        return this.outerWidth;
    }

    public void setOuterWidth(double outerWidth) {
        this.outerWidth = outerWidth;
    }

    public double getThickness() {
        return this.thickness;
    }

    public void setThickness(double thickness) {
        this.thickness = thickness;
    }

    public String getCompartmentType() {
        return this.type;
    }

    public void setCompartmentType(String type) {
        this.type = type;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    private void setDefaultValues(String _type) {
        CompartmentSymbol compartmentSymbol = (CompartmentSymbol)((Object)SBFactory.createSymbol(_type));
        SBFactory factory = new SBFactory();
        CompartmentAlias ca = (CompartmentAlias)factory.createObject(_type);
        String id = this.getId();
        this.setName(id);
        if (_type != "default") {
            Membrane membrane = ((CompartmentSymbol)((Object)ca.getSymbol())).getMembrane();
            this.innerWidth = membrane.getInnerLineWidth();
            this.outerWidth = membrane.getOuterLineWidth();
            this.thickness = membrane.getThickness();
            this.lineColor = compartmentSymbol.getComparmentShapePainting().getColor();
            ca.setCompartmentName(this.getName());
        }
    }

    public void setNamePositionX(double x2) {
        this.nameX = x2;
    }

    public void setNamePositionY(double y2) {
        this.nameY = y2;
    }

    public double getNamePositionX() {
        return this.nameX;
    }

    public double getNamePositionY() {
        return this.nameY;
    }

    public PluginInformationBox getPluginInformationBox() {
        return this.pluginInformationBox;
    }

    public void setPluginInformationBox(PluginInformationBox _PluginInformationBox) {
        this.pluginInformationBox = _PluginInformationBox;
    }
}

