/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.plugin.InfoCenter.InfoUI;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import jp.fric.graphics.multiwindow.FileManager;
import jp.fric.io.util.FileSuffixFilter;
import jp.fric.io.util.MyFileFilter;
import jp.sbi.celldesigner.Application;
import jp.sbi.celldesigner.miriam.MIRIAM;
import jp.sbi.celldesigner.plugin.InfoCenter.InfoUI.MappingArrayMassShowerMainWinFrm;
import jp.sbi.celldesigner.util.CelldUtil;
import jp.sbi.sbml.MiriamDefinition;
import jp.sbi.sbml.MiriamSubDefinition;
import jp.sbi.sbml.SId;

public class RsltDtBindingFrm
extends JDialog {
    private static final String separator = System.getProperty("file.separator");
    private static final String sColsNameSpecifiedForMiriamRelation = "One or more column name can be specified for a [MIRIAMRelation].<BR>An example:   d,f,g";
    private static final KeyStroke tab = KeyStroke.getKeyStroke(9, 0);
    private static final KeyStroke shiftTab = KeyStroke.getKeyStroke(9, 1);
    private static final KeyStroke up = KeyStroke.getKeyStroke(38, 0);
    private static final KeyStroke down = KeyStroke.getKeyStroke(40, 0);
    private static final KeyStroke pageup = KeyStroke.getKeyStroke(33, 0);
    private static final KeyStroke pagedown = KeyStroke.getKeyStroke(34, 0);
    private static final KeyStroke ctrlHome = KeyStroke.getKeyStroke(36, 2);
    private static final KeyStroke ctrlEnd = KeyStroke.getKeyStroke(35, 2, false);
    private static final int iMaxInputDataColumns = 101;
    private static final int iMinInputDataColumns = 2;
    public static final String strID = "ID";
    public static final String strName = "Name";
    public static final int iSpIColNum = 0;
    public static final int iSpNColNum = 1;
    public static final int iCmpColNum = 2;
    public static final int iMpkColNum = 3;
    public static final int iSptColNum = 4;
    public static final int iMcsColNum = 5;
    public static final int iNSpColNum = 6;
    private JPanel jPanelMain = null;
    private JPanel dataFilePanel = null;
    private JPanel conditionPanel = null;
    private JPanel keyRowPanel = null;
    private JPanel miriamPanel = null;
    private JPanel tabelPanel = null;
    private JButton FileSelectButton = null;
    private JButton clearMrmdttpsButton = null;
    private JButton resetMrmInfoButton = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private JComboBox SheetSelectComboBox = null;
    private JComboBox SpeciesIdComboBox = null;
    private JComboBox SpeciesNameComboBox = null;
    private JComboBox dataColSelectComboBox = null;
    private JComboBox SpeciesTypeComboBox = null;
    private JComboBox mappingKeyComboBox = null;
    private JComboBox mrmdataTypeRowComboBox = null;
    private JComboBox timeLabelComboBox = null;
    private JComboBox keyRowComboBox = null;
    private JComboBox dataRowSelectComboBox = null;
    private JComboBox clusterComboBox = null;
    private JComboBox miriamrelComboBox = null;
    private JLabel FileNameLabel = null;
    private JLabel SheetNameLabel = null;
    private JLabel timeLabel = null;
    private JLabel keyRowLabel = null;
    private JLabel dataRowSelectLabel = null;
    private JLabel SpeciesIDLabel = null;
    private JLabel SpeciesNameLabel = null;
    private JLabel dataColSelectLabel = null;
    private JLabel NewSpeciesTypeLabel = null;
    private JLabel mappingKeyLabel = null;
    private JLabel timeMustInputLabel = null;
    private JLabel keyRowMustInputLabel = null;
    private JLabel dataRowMustInputLabel = null;
    private JLabel dataColMustInputLabel = null;
    private JLabel speciesIdMustInputLabel = null;
    private JLabel speciesNameMustInputLabel = null;
    private JLabel mappingMustInputLabel = null;
    private JLabel newSpeciesMustInputLabel = null;
    private JLabel clusterLabel = null;
    private JLabel miriamRelationLabel = null;
    private JLabel mrmdataTypeRowLabel = null;
    private JLabel dataColsLabel = null;
    private JLabel noticeLabel = null;
    private JScrollPane jScrollPane = null;
    private JTable dataTable = null;
    private JTable rowNumTable = null;
    private AbstractTableModel dataModel = null;
    private AbstractTableModel rowHeadModel = null;
    private JTextField FileNameTextField = null;
    private JCheckBox sameKeyCheckBox = null;
    private JRadioButton addRadioButton = null;
    private JRadioButton deleteRadioButton = null;
    private JTextField txtfldMiriamdatatypeCols = null;
    private int dataType;
    private int modelType;
    private List<Object> datasFromFile;
    private List<List<Object>> datasOfCurrentSheet;
    private File file;
    private List listRelationAndIDCol;
    private int miriamRelationBak = 0;
    private static final String strBufferKey = "_Text";
    private String selectedCulomnName = "";
    private int rowIndexOfRowTable = -1;
    private JComponent dragTo;
    private boolean isDragingTabelHead = false;
    private boolean isDragingTabelRowHead = false;
    private boolean bCanceled = false;
    private String[][] strDataFromFile;
    private String[][] strAuxDatas;
    private Vector[] miriamDatas;
    private static final String strSheetName = "sheetName";
    private static final String strFileName = "fileName";
    private static final String strBrowse = "Browse";
    private static final String strCluster = "cluster";
    private static final String strTimeLabel = "timeLabel";
    private static final String strKeyRow = "keyRow";
    private static final String strDataRowSelect = "dataRow";
    private static final String strDataColSelect = "dataCol";
    private static final String strMappingKey = "mappingKey";
    private static final String strSpeciesID = "speciesID";
    private static final String strSpeciesType = "type";
    private static final String strSpeciesName = "speciesName";
    private static final String strDtaTypeRow = "dataTypeRow";
    private static final String strDataCols = "dataCols";
    private static final String strError = "Error";
    private static final String strXls = "xls";
    private static final String strInptMustMark = "*";

    public RsltDtBindingFrm(Frame owner, File file, List datas, int dataType, int modelType) {
        super(owner);
        this.setFile(file);
        this.setDatasOfAllSheet(datas);
        this.setDataType(dataType);
        this.initialize();
        this.setModelType(modelType);
    }

    private void initialize() {
        this.setDefaultCloseOperation(0);
        this.setModal(true);
        this.setResizable(false);
        this.setSize(new Dimension(640, 660));
        this.setLocation(80, 15);
        this.setTitle("Binding");
        this.setContentPane(this.getJPanelMain());
    }

    private JPanel getJPanelMain() {
        if (this.jPanelMain == null) {
            this.jPanelMain = new JPanel();
            this.jPanelMain.setLayout(null);
            this.jPanelMain.add((Component)this.getDataFilePanel(), null);
            this.jPanelMain.add((Component)this.getTabelPanel(), null);
            this.jPanelMain.add((Component)this.getConditionPanel(), null);
            this.jPanelMain.add((Component)this.getMiriamPanel(), null);
            this.jPanelMain.add((Component)this.getOkButton(), null);
            this.jPanelMain.add((Component)this.getCancelButton(), null);
        }
        return this.jPanelMain;
    }

    private JPanel getDataFilePanel() {
        if (this.dataFilePanel == null) {
            this.SheetNameLabel = new JLabel();
            this.SheetNameLabel.setBounds(new Rectangle(5, 35, 100, 20));
            this.SheetNameLabel.setText(strSheetName);
            this.FileNameLabel = new JLabel();
            this.FileNameLabel.setBounds(new Rectangle(5, 10, 100, 20));
            this.FileNameLabel.setText(strFileName);
            this.dataFilePanel = new JPanel();
            this.dataFilePanel.setLayout(null);
            this.dataFilePanel.setBounds(new Rectangle(5, 10, 620, 65));
            this.dataFilePanel.add((Component)this.FileNameLabel, null);
            this.dataFilePanel.add((Component)this.SheetNameLabel, null);
            this.dataFilePanel.add((Component)this.getFileNameTextField(), null);
            this.dataFilePanel.add((Component)this.getSheetSelectComboBox(), null);
            this.dataFilePanel.add((Component)this.getFileSelectButton(), null);
            this.dataFilePanel.setBorder(BorderFactory.createEtchedBorder(1));
        }
        return this.dataFilePanel;
    }

    private JTextField getFileNameTextField() {
        if (this.FileNameTextField == null) {
            this.FileNameTextField = new JTextField();
            this.FileNameTextField.setBounds(new Rectangle(105, 10, 400, 20));
            this.FileNameTextField.setEditable(false);
            if (this.getFile() != null) {
                this.FileNameTextField.setText(this.getFile().getPath());
                this.FileNameTextField.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        if (RsltDtBindingFrm.this.isDragingTabelRowHead || RsltDtBindingFrm.this.isDragingTabelHead) {
                            Cursor c = DragSource.DefaultMoveNoDrop;
                            RsltDtBindingFrm.this.FileNameTextField.setCursor(c);
                        } else {
                            Cursor c = Cursor.getDefaultCursor();
                            RsltDtBindingFrm.this.FileNameTextField.setCursor(c);
                        }
                    }
                });
            }
        }
        return this.FileNameTextField;
    }

    private JComboBox getSheetSelectComboBox() {
        if (this.SheetSelectComboBox == null) {
            this.SheetSelectComboBox = new JComboBox();
            this.SheetSelectComboBox.setBounds(new Rectangle(105, 35, 330, 20));
            this.SheetSelectComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    RsltDtBindingFrm.this.sheetSelectComboBox_itemStateChanged();
                }
            });
            this.initSheetSelectComboBoxValue();
        }
        return this.SheetSelectComboBox;
    }

    private void initSheetSelectComboBoxValue() {
        if (this.SheetSelectComboBox != null) {
            this.SheetSelectComboBox.removeAllItems();
            if (this.datasFromFile != null && this.datasFromFile.size() > 0) {
                try {
                    int i = 0;
                    while (i < this.datasFromFile.size()) {
                        HashMap sheetData = (HashMap)this.datasFromFile.get(i);
                        if (sheetData != null) {
                            for (Object key : sheetData.keySet()) {
                                if (key == null || "".equals(key)) continue;
                                this.SheetSelectComboBox.addItem(key.toString());
                            }
                        }
                        ++i;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.SheetSelectComboBox.getItemCount() > 0) {
                    this.SheetSelectComboBox.setSelectedIndex(0);
                    this.setDatasOfCurrentSheet(this.SheetSelectComboBox.getItemAt(0).toString());
                }
            }
        }
    }

    private JButton getFileSelectButton() {
        if (this.FileSelectButton == null) {
            this.FileSelectButton = new JButton();
            this.FileSelectButton.setBounds(new Rectangle(510, 10, 100, 20));
            this.FileSelectButton.setText(strBrowse);
            this.FileSelectButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RsltDtBindingFrm.this.fileSelectButton_actionPerformed();
                }
            });
        }
        return this.FileSelectButton;
    }

    private JPanel getConditionPanel() {
        if (this.conditionPanel == null) {
            this.miriamRelationLabel = new JLabel();
            this.miriamRelationLabel.setText("MIRIAMRelation");
            this.miriamRelationLabel.setBounds(new Rectangle(5, 15, 100, 20));
            this.clusterLabel = new JLabel();
            this.clusterLabel.setBounds(new Rectangle(320, 115, 100, 20));
            this.clusterLabel.setText(strCluster);
            this.timeLabel = new JLabel();
            this.timeLabel.setBounds(new Rectangle(5, 15, 100, 20));
            this.timeLabel.setText(strTimeLabel);
            this.timeMustInputLabel = new JLabel();
            this.timeMustInputLabel.setBounds(new Rectangle(280, 15, 20, 20));
            this.timeMustInputLabel.setText(strInptMustMark);
            this.keyRowLabel = new JLabel();
            this.keyRowLabel.setBounds(new Rectangle(5, 40, 100, 20));
            this.keyRowLabel.setText(strKeyRow);
            this.keyRowMustInputLabel = new JLabel();
            this.keyRowMustInputLabel.setBounds(new Rectangle(280, 40, 20, 20));
            this.keyRowMustInputLabel.setText(strInptMustMark);
            this.keyRowMustInputLabel.setVisible(false);
            this.dataRowSelectLabel = new JLabel();
            this.dataRowSelectLabel.setBounds(new Rectangle(5, 115, 100, 20));
            this.dataRowSelectLabel.setText(strDataRowSelect);
            this.dataRowMustInputLabel = new JLabel();
            this.dataRowMustInputLabel.setBounds(new Rectangle(280, 115, 20, 20));
            this.dataRowMustInputLabel.setText(strInptMustMark);
            this.dataColSelectLabel = new JLabel();
            this.dataColSelectLabel.setBounds(new Rectangle(5, 90, 100, 20));
            this.dataColSelectLabel.setText(strDataColSelect);
            this.dataColMustInputLabel = new JLabel();
            this.dataColMustInputLabel.setBounds(new Rectangle(280, 90, 20, 20));
            this.dataColMustInputLabel.setText(strInptMustMark);
            this.mappingKeyLabel = new JLabel();
            this.mappingKeyLabel.setBounds(new Rectangle(320, 65, 100, 20));
            this.mappingKeyLabel.setText(strMappingKey);
            this.mappingMustInputLabel = new JLabel();
            this.mappingMustInputLabel.setBounds(new Rectangle(595, 65, 20, 20));
            this.mappingMustInputLabel.setText(strInptMustMark);
            this.mappingMustInputLabel.setVisible(false);
            this.SpeciesIDLabel = new JLabel();
            this.SpeciesIDLabel.setBounds(new Rectangle(320, 15, 100, 20));
            this.SpeciesIDLabel.setText(strSpeciesID);
            this.speciesIdMustInputLabel = new JLabel();
            this.speciesIdMustInputLabel.setBounds(new Rectangle(595, 15, 20, 20));
            this.speciesIdMustInputLabel.setText(strInptMustMark);
            this.NewSpeciesTypeLabel = new JLabel();
            this.NewSpeciesTypeLabel.setBounds(new Rectangle(320, 90, 100, 20));
            this.NewSpeciesTypeLabel.setText(strSpeciesType);
            this.newSpeciesMustInputLabel = new JLabel();
            this.newSpeciesMustInputLabel.setBounds(new Rectangle(595, 90, 20, 20));
            this.SpeciesNameLabel = new JLabel();
            this.SpeciesNameLabel.setBounds(new Rectangle(320, 40, 100, 20));
            this.SpeciesNameLabel.setText(strSpeciesName);
            this.speciesNameMustInputLabel = new JLabel();
            this.speciesNameMustInputLabel.setBounds(new Rectangle(595, 40, 20, 20));
            this.speciesNameMustInputLabel.setText(strInptMustMark);
            this.speciesNameMustInputLabel.setVisible(false);
            this.conditionPanel = new JPanel();
            this.conditionPanel.setLayout(null);
            this.conditionPanel.setBounds(new Rectangle(5, 80, 620, 145));
            this.conditionPanel.add((Component)this.timeLabel, null);
            this.conditionPanel.add((Component)this.getTimeLabelComboBox(), null);
            this.conditionPanel.add((Component)this.timeMustInputLabel, null);
            this.conditionPanel.add((Component)this.keyRowLabel, null);
            this.conditionPanel.add((Component)this.getKeyRowPanel(), null);
            this.conditionPanel.add((Component)this.keyRowMustInputLabel, null);
            this.conditionPanel.add((Component)this.dataRowSelectLabel, null);
            this.conditionPanel.add((Component)this.getDataRowSelectComboBox(), null);
            this.conditionPanel.add((Component)this.dataRowMustInputLabel, null);
            this.conditionPanel.add((Component)this.dataColSelectLabel, null);
            this.conditionPanel.add((Component)this.getDataColSelectComboBox(), null);
            this.conditionPanel.add((Component)this.dataColMustInputLabel, null);
            this.conditionPanel.add((Component)this.SpeciesIDLabel, null);
            this.conditionPanel.add((Component)this.getSpeciesIdComboBox(), null);
            this.conditionPanel.add((Component)this.speciesIdMustInputLabel, null);
            this.conditionPanel.add((Component)this.SpeciesNameLabel, null);
            this.conditionPanel.add((Component)this.getSpeciesNameComboBox(), null);
            this.conditionPanel.add((Component)this.speciesNameMustInputLabel, null);
            this.conditionPanel.add((Component)this.NewSpeciesTypeLabel, null);
            this.conditionPanel.add((Component)this.getSpeciesTypeComboBox(), null);
            this.conditionPanel.add((Component)this.newSpeciesMustInputLabel, null);
            this.conditionPanel.add((Component)this.mappingKeyLabel, null);
            this.conditionPanel.add((Component)this.getMappingKeyComboBox(), null);
            this.conditionPanel.add((Component)this.mappingMustInputLabel, null);
            this.conditionPanel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(1), "Set Data"));
            this.conditionPanel.add((Component)this.clusterLabel, null);
            this.conditionPanel.add((Component)this.getClusterComboBox(), null);
        }
        return this.conditionPanel;
    }

    private void setMustInputLabelVisible(boolean visible) {
        this.timeMustInputLabel.setVisible(visible);
        this.dataRowMustInputLabel.setVisible(visible);
        this.dataColMustInputLabel.setVisible(visible);
        this.mappingMustInputLabel.setVisible(visible);
        this.speciesIdMustInputLabel.setVisible(visible);
        this.newSpeciesMustInputLabel.setVisible(visible);
    }

    private JComboBox getTimeLabelComboBox() {
        if (this.timeLabelComboBox == null) {
            this.timeLabelComboBox = new JComboBox();
            this.timeLabelComboBox.setBounds(new Rectangle(105, 15, 170, 20));
            this.init_RowComboBox_addListener(this.timeLabelComboBox);
            this.initRowLabelComboBoxValue(this.timeLabelComboBox);
        }
        return this.timeLabelComboBox;
    }

    private JPanel getKeyRowPanel() {
        if (this.keyRowPanel == null) {
            this.keyRowPanel = new JPanel();
            this.keyRowPanel.setLayout(null);
            this.keyRowPanel.setBounds(new Rectangle(105, 39, 170, 48));
            this.keyRowPanel.setBorder(BorderFactory.createEtchedBorder(1));
            this.keyRowPanel.add(this.getKeyRowComboBox());
            this.keyRowPanel.add(this.getSameKeyCheckBox());
        }
        return this.keyRowPanel;
    }

    private JComboBox getKeyRowComboBox() {
        if (this.keyRowComboBox == null) {
            this.keyRowComboBox = new JComboBox();
            this.keyRowComboBox.setBounds(new Rectangle(2, 2, 165, 20));
            this.init_RowComboBox_addListener(this.keyRowComboBox);
            this.initRowLabelComboBoxValue(this.keyRowComboBox);
        }
        return this.keyRowComboBox;
    }

    private JCheckBox getSameKeyCheckBox() {
        if (this.sameKeyCheckBox == null) {
            this.sameKeyCheckBox = new JCheckBox();
            this.sameKeyCheckBox.setText("use dataCol key only");
            this.sameKeyCheckBox.setForeground(Color.RED);
            this.sameKeyCheckBox.setBounds(new Rectangle(2, 25, 165, 20));
            this.sameKeyCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RsltDtBindingFrm.this.keyRowMustInputLabel.setVisible(RsltDtBindingFrm.this.sameKeyCheckBox.isSelected());
                }
            });
        }
        return this.sameKeyCheckBox;
    }

    private JComboBox getDataRowSelectComboBox() {
        if (this.dataRowSelectComboBox == null) {
            this.dataRowSelectComboBox = new JComboBox();
            this.dataRowSelectComboBox.setBounds(new Rectangle(105, 115, 170, 20));
            this.init_RowComboBox_addListener(this.dataRowSelectComboBox);
            this.initRowLabelComboBoxValue(this.dataRowSelectComboBox);
        }
        return this.dataRowSelectComboBox;
    }

    private void initRowLabelComboBoxValue(JComboBox jComboBox) {
        if (jComboBox != null) {
            jComboBox.removeAllItems();
            jComboBox.addItem("");
            jComboBox.setSelectedIndex(0);
            if (this.dataModel != null && this.dataModel.getRowCount() > 0) {
                int i = 1;
                while (i <= this.dataModel.getRowCount()) {
                    jComboBox.addItem(i);
                    ++i;
                }
            }
        }
    }

    private JComboBox getSpeciesIdComboBox() {
        if (this.SpeciesIdComboBox == null) {
            this.SpeciesIdComboBox = new JComboBox();
            this.SpeciesIdComboBox.setBounds(new Rectangle(420, 15, 170, 20));
            this.init_ColComboBox_addListener(this.SpeciesIdComboBox);
            this.initColComboBoxValue(this.SpeciesIdComboBox);
        }
        return this.SpeciesIdComboBox;
    }

    private JComboBox getSpeciesNameComboBox() {
        if (this.SpeciesNameComboBox == null) {
            this.SpeciesNameComboBox = new JComboBox();
            this.SpeciesNameComboBox.setBounds(new Rectangle(420, 40, 170, 20));
            this.init_ColComboBox_addListener(this.SpeciesNameComboBox);
            this.initColComboBoxValue(this.SpeciesNameComboBox);
        }
        return this.SpeciesNameComboBox;
    }

    private JComboBox getClusterComboBox() {
        if (this.clusterComboBox == null) {
            this.clusterComboBox = new JComboBox();
            this.clusterComboBox.setBounds(new Rectangle(420, 115, 170, 20));
            this.init_ColComboBox_addListener(this.clusterComboBox);
            this.initColComboBoxValue(this.clusterComboBox);
        }
        return this.clusterComboBox;
    }

    private JComboBox getMiriamrelComboBox() {
        if (this.miriamrelComboBox == null) {
            this.miriamrelComboBox = new JComboBox();
            this.miriamrelComboBox.setBounds(new Rectangle(105, 15, 200, 20));
            this.miriamrelComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RsltDtBindingFrm.this.MiriamComboBox_actionPerformed();
                }
            });
            this.initMiriamComboBoxValue();
        }
        return this.miriamrelComboBox;
    }

    private void initMiriamComboBoxValue() {
        if (this.miriamrelComboBox != null) {
            this.miriamrelComboBox.removeAllItems();
            this.miriamrelComboBox.addItem("");
            Vector<String> relation = MIRIAM.vectEnumerationRelationOfMIRIAM;
            if (relation != null) {
                int i = 0;
                while (i < relation.size()) {
                    String strrelation = relation.get(i).toString();
                    this.miriamrelComboBox.addItem(strrelation);
                    ++i;
                }
            }
            this.miriamrelComboBox.setSelectedIndex(0);
        }
    }

    private JComboBox getDataColSelectComboBox() {
        if (this.dataColSelectComboBox == null) {
            this.dataColSelectComboBox = new JComboBox();
            this.dataColSelectComboBox.setBounds(new Rectangle(105, 90, 170, 20));
            this.init_ColComboBox_addListener(this.dataColSelectComboBox);
            this.initColComboBoxValue(this.dataColSelectComboBox);
        }
        return this.dataColSelectComboBox;
    }

    public JComboBox getSpeciesTypeComboBox() {
        if (this.SpeciesTypeComboBox == null) {
            this.SpeciesTypeComboBox = new JComboBox();
            this.SpeciesTypeComboBox.setBounds(new Rectangle(420, 90, 170, 20));
            this.SpeciesTypeComboBox.removeAllItems();
            this.SpeciesTypeComboBox.addItem("GENE");
            this.SpeciesTypeComboBox.addItem("PROTEIN");
            this.SpeciesTypeComboBox.addItem("RNA");
            this.SpeciesTypeComboBox.setSelectedIndex(0);
        }
        return this.SpeciesTypeComboBox;
    }

    public JComboBox getMappingKeyComboBox() {
        if (this.mappingKeyComboBox == null) {
            this.mappingKeyComboBox = new JComboBox();
            this.mappingKeyComboBox.setBounds(new Rectangle(420, 65, 170, 20));
            this.mappingKeyComboBox.removeAllItems();
            this.mappingKeyComboBox.addItem(strID);
            this.mappingKeyComboBox.addItem(strName);
            this.mappingKeyComboBox.setSelectedIndex(0);
            this.mappingKeyComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (RsltDtBindingFrm.strID.equals(RsltDtBindingFrm.this.mappingKeyComboBox.getSelectedItem())) {
                        RsltDtBindingFrm.this.speciesIdMustInputLabel.setVisible(true);
                        RsltDtBindingFrm.this.speciesNameMustInputLabel.setVisible(false);
                    } else if (RsltDtBindingFrm.strName.equals(RsltDtBindingFrm.this.mappingKeyComboBox.getSelectedItem())) {
                        RsltDtBindingFrm.this.speciesIdMustInputLabel.setVisible(false);
                        RsltDtBindingFrm.this.speciesNameMustInputLabel.setVisible(true);
                    }
                }
            });
        }
        return this.mappingKeyComboBox;
    }

    private void initColComboBoxValue(JComboBox iComboBox) {
        if (iComboBox != null) {
            iComboBox.removeAllItems();
            iComboBox.addItem("");
            iComboBox.setSelectedIndex(0);
            if (this.dataModel != null && this.dataModel.getColumnCount() > 0) {
                int i = 0;
                while (i < this.dataModel.getColumnCount()) {
                    String item = this.dataModel.getColumnName(i);
                    if (item != null) {
                        iComboBox.addItem(item);
                    }
                    ++i;
                }
            }
        }
    }

    private JPanel getTabelPanel() {
        if (this.tabelPanel == null) {
            this.tabelPanel = new JPanel();
            this.tabelPanel.setLayout(null);
            this.tabelPanel.setBounds(new Rectangle(5, 335, 620, 240));
            this.tabelPanel.add((Component)this.getJScrollPane(), null);
            this.tabelPanel.setBorder(BorderFactory.createEtchedBorder(1));
        }
        return this.tabelPanel;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setBounds(new Rectangle(0, 0, 620, 240));
            JTable dataTbl = this.getdataTable();
            this.jScrollPane.setViewportView(dataTbl);
            JViewport viewport = new JViewport();
            JTable rowNumTbl = this.getrowNumTable();
            viewport.setView(rowNumTbl);
            viewport.setScrollMode(1);
            viewport.setPreferredSize(rowNumTbl.getPreferredSize());
            this.jScrollPane.setRowHeaderView(viewport);
            this.jScrollPane.setCorner("UPPER_LEFT_CORNER", rowNumTbl.getTableHeader());
            rowNumTbl.setInputMap(1, null);
            dataTbl.setInputMap(1, null);
            this.jScrollPane.setInputMap(1, null);
        }
        return this.jScrollPane;
    }

    private void disableKeyInput(Component cmpnt) {
        if (cmpnt == null) {
            return;
        }
        KeyListener[] klsnr = cmpnt.getKeyListeners();
        if (klsnr == null || klsnr.length <= 0) {
            return;
        }
        int i = 0;
        while (i < klsnr.length) {
            cmpnt.removeKeyListener(klsnr[i]);
            ++i;
        }
    }

    private void disableSomeKeyInput(InputMap inputmap) {
        inputmap.put(tab, "none");
        inputmap.put(shiftTab, "none");
        inputmap.put(up, "none");
        inputmap.put(down, "none");
        inputmap.put(pageup, "none");
        inputmap.put(pagedown, "none");
        inputmap.put(ctrlHome, "none");
        inputmap.put(ctrlEnd, "none");
    }

    private JTable getrowNumTable() {
        if (this.rowNumTable == null) {
            this.rowHeadModel = new AbstractTableModel(){
                String[] fixcolumnNames = new String[]{""};

                @Override
                public String getColumnName(int column) {
                    if (this.fixcolumnNames[column] != null) {
                        return this.fixcolumnNames[column];
                    }
                    return "";
                }

                @Override
                public int getRowCount() {
                    if (RsltDtBindingFrm.this.datasOfCurrentSheet == null) {
                        return 0;
                    }
                    return RsltDtBindingFrm.this.datasOfCurrentSheet.size();
                }

                @Override
                public int getColumnCount() {
                    return this.fixcolumnNames.length;
                }

                @Override
                public Object getValueAt(int row, int col) {
                    if (RsltDtBindingFrm.this.datasOfCurrentSheet == null) {
                        return null;
                    }
                    return row + 1;
                }
            };
            this.rowNumTable = new JTable(this.rowHeadModel);
            this.init_rowNumTable_addListener();
            this.rowNumTable.setAutoResizeMode(0);
            this.rowNumTable.setSelectionMode(0);
            this.rowNumTable.getTableHeader().setReorderingAllowed(false);
            this.rowNumTable.getTableHeader().setResizingAllowed(false);
            DefaultTableCellRenderer rederer = new DefaultTableCellRenderer();
            rederer.setHorizontalAlignment(0);
            this.rowNumTable.getColumnModel().getColumn(0).setCellRenderer(rederer);
        }
        return this.rowNumTable;
    }

    private JTable getdataTable() {
        if (this.dataTable == null) {
            this.dataModel = new AbstractTableModel(){

                @Override
                public String getColumnName(int column) {
                    return super.getColumnName(column);
                }

                @Override
                public int getRowCount() {
                    if (RsltDtBindingFrm.this.datasOfCurrentSheet == null) {
                        return 0;
                    }
                    return RsltDtBindingFrm.this.datasOfCurrentSheet.size();
                }

                @Override
                public int getColumnCount() {
                    if (RsltDtBindingFrm.this.datasOfCurrentSheet != null && RsltDtBindingFrm.this.datasOfCurrentSheet.size() > 0) {
                        List list = (List)RsltDtBindingFrm.this.datasOfCurrentSheet.get(0);
                        if (list == null) {
                            return 0;
                        }
                        return list.size();
                    }
                    return 0;
                }

                @Override
                public Object getValueAt(int row, int col) {
                    try {
                        List mr = (List)RsltDtBindingFrm.this.datasOfCurrentSheet.get(row);
                        return mr.get(col);
                    }
                    catch (Exception myErr) {
                        return null;
                    }
                }
            };
            this.dataTable = new JTable(this.dataModel);
            this.init_dataTable_addListener();
            this.dataTable.setSelectionMode(0);
            this.dataTable.setAutoscrolls(false);
            this.dataTable.setColumnSelectionAllowed(false);
            this.dataTable.getTableHeader().setReorderingAllowed(false);
            this.dataTable.setAutoResizeMode(0);
            TableCellRenderer cellRendererOfDataTable = this.dataTable.getTableHeader().getDefaultRenderer();
            if (cellRendererOfDataTable instanceof DefaultTableCellRenderer) {
                DefaultTableCellRenderer defaultcellRendererOfDataTable = (DefaultTableCellRenderer)cellRendererOfDataTable;
                defaultcellRendererOfDataTable.setHorizontalAlignment(0);
            }
        }
        return this.dataTable;
    }

    private void fixSelection(boolean isFixedTable) {
        if (this.rowNumTable == null) {
            return;
        }
        if (this.dataTable == null) {
            return;
        }
        if (isFixedTable) {
            int[] fixedSelectedIndex = this.rowNumTable.getSelectedRows();
            this.dataTable.clearSelection();
            this.dataTable.setRowSelectionInterval(fixedSelectedIndex[fixedSelectedIndex.length - 1], fixedSelectedIndex[fixedSelectedIndex.length - 1]);
        } else {
            int[] dataTableSelected = this.dataTable.getSelectedRows();
            this.rowNumTable.clearSelection();
            this.rowNumTable.setRowSelectionInterval(dataTableSelected[dataTableSelected.length - 1], dataTableSelected[dataTableSelected.length - 1]);
        }
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setBounds(new Rectangle(160, 590, 80, 30));
            this.okButton.setText("Ok");
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RsltDtBindingFrm.this.ok_actionPerformed();
                }
            });
        }
        return this.okButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setBounds(new Rectangle(370, 590, 120, 30));
            this.cancelButton.setText("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RsltDtBindingFrm.this.cancel_actionPerformed();
                }
            });
        }
        return this.cancelButton;
    }

    private JPanel getMiriamPanel() {
        if (this.miriamPanel == null) {
            this.noticeLabel = new JLabel();
            this.noticeLabel.setBounds(new Rectangle(310, 65, 200, 20));
            this.noticeLabel.setText("(can specify multiple columns)");
            this.noticeLabel.setForeground(Color.RED);
            this.dataColsLabel = new JLabel();
            this.dataColsLabel.setBounds(new Rectangle(5, 65, 100, 20));
            this.dataColsLabel.setText(strDataCols);
            this.mrmdataTypeRowLabel = new JLabel();
            this.mrmdataTypeRowLabel.setBounds(new Rectangle(5, 40, 100, 20));
            this.mrmdataTypeRowLabel.setText(strDtaTypeRow);
            this.miriamPanel = new JPanel();
            this.miriamPanel.setLayout(null);
            this.miriamPanel.setBounds(new Rectangle(5, 230, 620, 95));
            this.miriamPanel.add((Component)this.miriamRelationLabel, null);
            this.miriamPanel.add((Component)this.getMiriamrelComboBox(), null);
            this.miriamPanel.add((Component)this.getMrmdataTypeRowComboBox(), null);
            this.miriamPanel.add((Component)this.getAddRadioButton(), null);
            this.miriamPanel.add((Component)this.getDeleteRadioButton(), null);
            this.miriamPanel.add((Component)this.getTxtfldMiriamdatatypeCols(), null);
            this.miriamPanel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(1), "Add annotation"));
            this.miriamPanel.add((Component)this.mrmdataTypeRowLabel, null);
            this.miriamPanel.add((Component)this.getClearMrmdttpsButton(), null);
            this.miriamPanel.add((Component)this.getResetMrmInfoButton(), null);
            this.miriamPanel.add((Component)this.dataColsLabel, null);
            this.miriamPanel.add((Component)this.noticeLabel, null);
        }
        return this.miriamPanel;
    }

    private JComboBox getMrmdataTypeRowComboBox() {
        if (this.mrmdataTypeRowComboBox == null) {
            this.mrmdataTypeRowComboBox = new JComboBox();
            this.mrmdataTypeRowComboBox.setBounds(new Rectangle(105, 40, 200, 20));
            this.init_RowComboBox_addListener(this.mrmdataTypeRowComboBox);
            this.initRowLabelComboBoxValue(this.mrmdataTypeRowComboBox);
        }
        return this.mrmdataTypeRowComboBox;
    }

    private JRadioButton getAddRadioButton() {
        if (this.addRadioButton == null) {
            this.addRadioButton = new JRadioButton();
            this.addRadioButton.setBounds(new Rectangle(1, 30, 50, 20));
            this.addRadioButton.setText("add");
            this.addRadioButton.setVisible(false);
        }
        return this.addRadioButton;
    }

    private JRadioButton getDeleteRadioButton() {
        if (this.deleteRadioButton == null) {
            this.deleteRadioButton = new JRadioButton();
            this.deleteRadioButton.setBounds(new Rectangle(50, 30, 65, 20));
            this.deleteRadioButton.setText("delete");
            this.deleteRadioButton.setVisible(false);
        }
        return this.deleteRadioButton;
    }

    private JTextField getTxtfldMiriamdatatypeCols() {
        if (this.txtfldMiriamdatatypeCols == null) {
            this.txtfldMiriamdatatypeCols = new JTextField();
            this.txtfldMiriamdatatypeCols.setBounds(new Rectangle(105, 65, 200, 20));
            String tooltip = CelldUtil.getHtmlText(sColsNameSpecifiedForMiriamRelation);
            this.txtfldMiriamdatatypeCols.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (RsltDtBindingFrm.this.isDragingTabelRowHead || RsltDtBindingFrm.this.isDragingTabelHead) {
                        Cursor c = DragSource.DefaultMoveNoDrop;
                        RsltDtBindingFrm.this.txtfldMiriamdatatypeCols.setCursor(c);
                    } else {
                        Cursor c = Cursor.getDefaultCursor();
                        RsltDtBindingFrm.this.txtfldMiriamdatatypeCols.setCursor(c);
                    }
                }
            });
        }
        return this.txtfldMiriamdatatypeCols;
    }

    private JButton getResetMrmInfoButton() {
        if (this.resetMrmInfoButton == null) {
            this.resetMrmInfoButton = new JButton();
            this.resetMrmInfoButton.setText("Reset");
            this.resetMrmInfoButton.setBounds(new Rectangle(535, 15, 80, 25));
            this.resetMrmInfoButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RsltDtBindingFrm.this.resetMiriamPanel();
                }
            });
        }
        return this.resetMrmInfoButton;
    }

    private JButton getClearMrmdttpsButton() {
        if (this.clearMrmdttpsButton == null) {
            this.clearMrmdttpsButton = new JButton();
            this.clearMrmdttpsButton.setText("Clear");
            this.clearMrmdttpsButton.setBounds(new Rectangle(515, 65, 100, 20));
            this.clearMrmdttpsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (RsltDtBindingFrm.this.txtfldMiriamdatatypeCols != null) {
                        RsltDtBindingFrm.this.txtfldMiriamdatatypeCols.setText("");
                    }
                    String strRelation = RsltDtBindingFrm.this.miriamrelComboBox.getItemAt(RsltDtBindingFrm.this.getOldmiriamRelationIndex()).toString();
                    if (RsltDtBindingFrm.this.listRelationAndIDCol != null) {
                        int i = 0;
                        while (i < RsltDtBindingFrm.this.listRelationAndIDCol.size()) {
                            HashMap singleRelation = (HashMap)RsltDtBindingFrm.this.listRelationAndIDCol.get(i);
                            if (singleRelation.containsKey(strRelation)) {
                                RsltDtBindingFrm.this.listRelationAndIDCol.remove(singleRelation);
                                break;
                            }
                            ++i;
                        }
                    }
                }
            });
        }
        return this.clearMrmdttpsButton;
    }

    private void MiriamComboBox_actionPerformed() {
        try {
            if (this.getOldmiriamRelationIndex() != 0) {
                this.checkDataColsOfMiriam();
                if (this.txtfldMiriamdatatypeCols != null) {
                    this.txtfldMiriamdatatypeCols.setText("");
                }
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), strError, 0);
            this.miriamrelComboBox.setSelectedIndex(this.getOldmiriamRelationIndex());
            return;
        }
        String strRelation = this.miriamrelComboBox.getSelectedItem().toString();
        List lsRelations = this.getRelationsAndIDCols();
        if (lsRelations != null) {
            int i = 0;
            while (i < lsRelations.size()) {
                HashMap singleRelation = (HashMap)lsRelations.get(i);
                if (singleRelation.containsKey(strRelation) && singleRelation.containsKey(String.valueOf(strRelation) + strBufferKey)) {
                    String strDataColeText = (String)singleRelation.get(String.valueOf(strRelation) + strBufferKey);
                    this.txtfldMiriamdatatypeCols.setText(strDataColeText);
                }
                ++i;
            }
        }
        this.setOldmiriamRelationIndex(this.miriamrelComboBox.getSelectedIndex());
    }

    private void fileSelectButton_actionPerformed() {
        File xlsfile = RsltDtBindingFrm.openXlsFile(this);
        if (xlsfile == null) {
            return;
        }
        List datas = CelldUtil.getDataFromExcelFile(xlsfile);
        if (datas == null || datas.size() == 0) {
            JOptionPane.showMessageDialog(this, "It seems there are some errors in the input file.", strError, 0);
            return;
        }
        this.setFile(xlsfile);
        this.setDatasOfAllSheet(datas);
        this.initSheetSelectComboBoxValue();
        this.getFileNameTextField().setText(xlsfile.getPath());
        this.resetDialog();
    }

    private void ok_actionPerformed() {
        String sheetName = this.SheetSelectComboBox.getSelectedItem().toString();
        String timeLabel = this.timeLabelComboBox.getSelectedItem().toString();
        String keyRow = this.keyRowComboBox.getSelectedItem().toString();
        String dataRowSelect = this.dataRowSelectComboBox.getSelectedItem().toString();
        String dataColSelect = this.dataColSelectComboBox.getSelectedItem().toString();
        String speciesId = this.SpeciesIdComboBox.getSelectedItem().toString();
        String speciesName = this.SpeciesNameComboBox.getSelectedItem().toString();
        String speciesType = this.SpeciesTypeComboBox.getSelectedItem().toString();
        String mappingKey = this.mappingKeyComboBox.getSelectedItem().toString();
        String cluster = this.clusterComboBox.getSelectedItem().toString();
        String miriam = this.miriamrelComboBox.getSelectedItem().toString();
        String dataTypeRow = this.mrmdataTypeRowComboBox.getSelectedItem().toString();
        boolean sameKey = this.sameKeyCheckBox.isSelected();
        try {
            this.checkInputForMustInput(timeLabel, keyRow, dataRowSelect, dataColSelect, sheetName, speciesId, speciesName, speciesType, mappingKey, cluster, miriam, dataTypeRow);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), strError, 0);
            return;
        }
        int count = this.dataTable.getColumnCount();
        int dataColSelectColNum = -1;
        int speciedsIdColNum = -1;
        int speciedsNameColNum = -1;
        int clusterNum = -1;
        boolean speciedsIdFlag = false;
        boolean speciedsNameFlag = false;
        boolean rowSelectFlag = false;
        boolean clusterFlag = false;
        int i = 0;
        while (i < count) {
            if (speciedsIdFlag && speciedsNameFlag && rowSelectFlag && clusterFlag) break;
            String obj = this.dataTable.getColumnName(i);
            if (obj != null) {
                String colName = obj.toString();
                if (colName.equals(speciesId)) {
                    speciedsIdColNum = i;
                    speciedsIdFlag = true;
                }
                if (colName.equals(speciesName)) {
                    speciedsNameColNum = i;
                    speciedsNameFlag = true;
                }
                if (colName.equals(dataColSelect)) {
                    dataColSelectColNum = i;
                    rowSelectFlag = true;
                }
                if (colName.equals(cluster)) {
                    clusterNum = i;
                    clusterFlag = true;
                }
            }
            ++i;
        }
        int inttimeLabel = Integer.parseInt(timeLabel);
        int dataTypeRowNum = dataTypeRow == null || "".equals(dataTypeRow) ? -1 : Integer.parseInt(dataTypeRow);
        int intdataRowSelect = Integer.parseInt(dataRowSelect);
        int intkeyRow = -1;
        if (keyRow != null && !"".equals(keyRow)) {
            intkeyRow = Integer.parseInt(keyRow);
        }
        try {
            this.checkInputForBusiness(speciedsIdColNum, mappingKey, clusterNum, intdataRowSelect);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), strError, 0);
            return;
        }
        try {
            int miriamSize;
            if (speciedsIdColNum < 0) {
                speciedsIdColNum = speciedsNameColNum;
            }
            Vector vecData = this.getMappingArrayMassData(inttimeLabel, intkeyRow, intdataRowSelect, dataColSelectColNum, speciedsIdColNum, speciedsNameColNum, sameKey);
            String[][] rtn = this.checkDatas(vecData);
            this.setMassDatas(rtn);
            String[][] newSpeciesDatas = this.getNewSpeciesDatas(speciedsIdColNum, speciedsNameColNum, clusterNum, intdataRowSelect);
            this.setAuxDatas(newSpeciesDatas);
            Vector[] miriamDatas = this.getMiriamInfodata(speciedsIdColNum, intdataRowSelect, dataTypeRowNum);
            int auxDataSize = newSpeciesDatas.length;
            if (miriamDatas == null) {
                miriamDatas = new Vector[auxDataSize];
            }
            if (auxDataSize != (miriamSize = miriamDatas.length)) {
                throw new Exception();
            }
            this.setMiriamDatas(miriamDatas);
        }
        catch (Exception ec) {
            String dataread_errormsg = "An error occurred while making the experimental data.\nPlease retry it or try other.";
            JOptionPane.showMessageDialog(this, dataread_errormsg, strError, 0);
            return;
        }
        this.setVisible(false);
    }

    private void checkInputForMustInput(String timeLabel, String keyRow, String dataRowSelect, String dataColSelect, String sheetName, String speciesId, String speciesName, String speciesType, String mappingKey, String cluster, String miriam, String dataTypeRow) throws Exception {
        if (timeLabel == null || "".equals(timeLabel)) {
            throw new Exception("[timeLabel] is not selected.");
        }
        if (this.sameKeyCheckBox != null && this.sameKeyCheckBox.isSelected() && (keyRow == null || "".equals(keyRow))) {
            throw new Exception("[keyRow] is not selected.");
        }
        if (dataRowSelect == null || "".equals(dataRowSelect)) {
            throw new Exception("[dataRow] is not selected.");
        }
        if (dataColSelect == null || "".equals(dataColSelect)) {
            throw new Exception("[dataCol] is not selected.");
        }
        if (speciesType == null || "".equals(speciesType)) {
            throw new Exception("[type] is not selected.");
        }
        if (mappingKey == null || "".equals(mappingKey)) {
            throw new Exception("[mappingKey] is not selected.");
        }
        if (strID.equals(mappingKey) && (speciesId == null || "".equals(speciesId))) {
            throw new Exception("[speciesID] is not selected.");
        }
        if (strName.equals(mappingKey) && (speciesName == null || "".equals(speciesName))) {
            throw new Exception("[speciesName] is not selected.");
        }
        if (miriam != null && !"".equals(miriam.trim())) {
            if (dataTypeRow == null || "".equals(dataTypeRow.trim())) {
                throw new Exception("[dataTypeRow] is not selected.");
            }
            if (this.txtfldMiriamdatatypeCols == null || this.txtfldMiriamdatatypeCols.getText() == null || "".equals(this.txtfldMiriamdatatypeCols.getText().trim())) {
                if (this.listRelationAndIDCol == null || this.listRelationAndIDCol.size() <= 0) {
                    throw new Exception("[dataCols] is not inputed.");
                }
            } else {
                this.checkDataColsOfMiriam();
            }
        }
    }

    private void checkInputForBusiness(int speciedsIdColNum, String mappingKey, int clusterNum, int intdataRowSelect) throws Exception {
        block17: {
            if (speciedsIdColNum < 0 && strID.equals(mappingKey)) {
                throw new Exception("[speciesID] Col is not satisfied.");
            }
            if (intdataRowSelect < 2) {
                throw new Exception("[dataRow] Row is not satisfied.");
            }
            int dataIndex = intdataRowSelect - 1;
            try {
                if (this.datasOfCurrentSheet == null || this.datasOfCurrentSheet.size() <= dataIndex) break block17;
                int ut = dataIndex;
                while (ut < this.datasOfCurrentSheet.size()) {
                    block19: {
                        List<Object> row;
                        block18: {
                            row = this.datasOfCurrentSheet.get(ut);
                            try {
                                if (speciedsIdColNum < 0) break block18;
                                if (row != null && row.size() > speciedsIdColNum) {
                                    Object obj = row.get(speciedsIdColNum);
                                    if (obj != null) {
                                        String speciesID = obj.toString();
                                        if (!"".equals(speciesID)) {
                                            try {
                                                SId.check(speciesID);
                                                break block18;
                                            }
                                            catch (Exception ee) {
                                                throw new Exception();
                                            }
                                        }
                                        throw new Exception();
                                    }
                                    throw new Exception();
                                }
                                throw new Exception();
                            }
                            catch (Exception ex) {
                                throw new Exception("[speciesID] Col is not satisfied.");
                            }
                        }
                        try {
                            if (clusterNum < 0) break block19;
                            if (row != null && row.size() > clusterNum) {
                                Object objCluster = row.get(clusterNum);
                                if (objCluster != null) {
                                    String cluster = objCluster.toString();
                                    if ("".equals(cluster)) {
                                        throw new Exception();
                                    }
                                    break block19;
                                }
                                throw new Exception();
                            }
                            throw new Exception();
                        }
                        catch (Exception ex) {
                            throw new Exception("[cluster] Col is not satisfied.");
                        }
                    }
                    ++ut;
                }
            }
            catch (Exception ex) {
                throw new Exception(ex.getMessage());
            }
        }
    }

    private Vector getMappingArrayMassData(int timeLabel, int keyRow, int dataRowSelect, int dataColSelect, int speciesId, int speciesName, boolean sameKey) {
        Vector<String[]> vecData = new Vector<String[]>();
        this.getRowDataForMappingArrayMassData(timeLabel, timeLabel, dataColSelect, true, -1, vecData);
        this.getRowDataForMappingArrayMassData(dataRowSelect, this.datasOfCurrentSheet.size(), dataColSelect, false, speciesId, vecData);
        if (sameKey) {
            String[] keys;
            Vector<String[]> selectedKeyRowDatas = new Vector<String[]>();
            this.getRowDataForMappingArrayMassData(keyRow, keyRow, dataColSelect, false, -1, selectedKeyRowDatas);
            if (selectedKeyRowDatas != null && selectedKeyRowDatas.size() > 0 && (keys = selectedKeyRowDatas.get(selectedKeyRowDatas.size() - 1)) != null && keys.length >= 3) {
                String strKey = keys[1];
                ArrayList<Integer> lstIndex = new ArrayList<Integer>();
                lstIndex.add(0);
                lstIndex.add(1);
                int i = 2;
                while (i < keys.length) {
                    String temp = keys[i];
                    if (strKey.trim().equals(temp.trim())) {
                        lstIndex.add(i);
                    }
                    ++i;
                }
                Vector<String[]> tempData = new Vector<String[]>();
                if (vecData != null && vecData.size() > 0) {
                    int ct = 0;
                    while (ct < vecData.size()) {
                        String[] rowdata = vecData.get(ct);
                        String[] newRowData = new String[lstIndex.size()];
                        int cnt = 0;
                        while (cnt < lstIndex.size()) {
                            newRowData[cnt] = rowdata[Integer.parseInt(lstIndex.get(cnt).toString())];
                            ++cnt;
                        }
                        tempData.add(newRowData);
                        ++ct;
                    }
                    vecData = tempData;
                }
            }
        }
        return vecData;
    }

    private void getRowDataForMappingArrayMassData(int RowNum, int maxRowNum, int dataColSelect, boolean CompensateBlank, int MappingArrayMassDataKeyIndex, Vector<String[]> dataVec) {
        if (this.datasOfCurrentSheet == null || this.datasOfCurrentSheet.size() <= 0) {
            return;
        }
        if (dataColSelect <= 0) {
            return;
        }
        if (RowNum < 1 || RowNum > maxRowNum) {
            return;
        }
        if (dataVec == null) {
            dataVec = new Vector();
        }
        try {
            int ut = RowNum;
            while (ut <= maxRowNum) {
                List<Object> row = this.datasOfCurrentSheet.get(ut - 1);
                ArrayList<Object> rowClone = new ArrayList<Object>();
                rowClone.addAll(row);
                int tm = 0;
                while (tm < rowClone.size()) {
                    Object object = rowClone.get(tm);
                    if (tm != 0) {
                        if (CompensateBlank) {
                            if (object == null || "".equals(object)) {
                                int ttm = tm - 1;
                                while (ttm >= 0) {
                                    Object obj1 = rowClone.get(ttm);
                                    if (obj1 != null && !"".equals(obj1)) {
                                        rowClone.set(tm, obj1.toString());
                                        break;
                                    }
                                    --ttm;
                                }
                            } else {
                                rowClone.set(tm, object.toString());
                            }
                        } else {
                            rowClone.set(tm, object.toString());
                        }
                    }
                    ++tm;
                }
                int cnt = dataColSelect - 1;
                while (cnt >= 0) {
                    rowClone.remove(cnt);
                    --cnt;
                }
                if (MappingArrayMassDataKeyIndex >= 0 && row.size() > MappingArrayMassDataKeyIndex) {
                    Object obj = row.get(MappingArrayMassDataKeyIndex);
                    String strSpeceis = null;
                    if (obj != null) {
                        strSpeceis = new String(obj.toString());
                    }
                    rowClone.add(0, strSpeceis);
                } else {
                    rowClone.add(0, "");
                }
                dataVec.add(rowClone.toArray(new String[rowClone.size()]));
                ++ut;
            }
        }
        catch (Exception ex) {
            return;
        }
    }

    private String[][] getNewSpeciesDatas(int speciedsId, int speciedsName, int cluster, int dataRowSelect) throws Exception {
        if (this.datasOfCurrentSheet == null || this.datasOfCurrentSheet.size() == 0) {
            throw new Exception();
        }
        if (speciedsId < 0 || dataRowSelect < 1 || dataRowSelect > this.datasOfCurrentSheet.size()) {
            throw new Exception();
        }
        int size = this.datasOfCurrentSheet.size() - dataRowSelect + 1 + 1;
        String[][] newSpeciesDatas = new String[size][7];
        try {
            newSpeciesDatas[0][0] = "";
            newSpeciesDatas[0][1] = "";
            newSpeciesDatas[0][2] = "";
            newSpeciesDatas[0][3] = "";
            newSpeciesDatas[0][4] = "";
            newSpeciesDatas[0][5] = "";
            newSpeciesDatas[0][6] = "";
            int count = 1;
            int i = dataRowSelect - 1;
            while (i < this.datasOfCurrentSheet.size()) {
                List<Object> rowdata = this.datasOfCurrentSheet.get(i);
                if (rowdata != null) {
                    String mpkey;
                    Object objSpeciesID = null;
                    try {
                        objSpeciesID = rowdata.get(speciedsId);
                    }
                    catch (Exception myErr) {
                        objSpeciesID = null;
                    }
                    Object objSpeciesName = null;
                    try {
                        objSpeciesName = rowdata.get(speciedsName);
                    }
                    catch (Exception myErr) {
                        objSpeciesName = null;
                    }
                    Object objCluster = null;
                    if (cluster >= 0 && rowdata.size() > cluster) {
                        objCluster = rowdata.get(cluster);
                    }
                    if (objCluster == null) {
                        objCluster = "";
                    }
                    newSpeciesDatas[count][0] = strID.equals(mpkey = this.mappingKeyComboBox.getSelectedItem().toString().trim()) ? objSpeciesID.toString().trim() : "";
                    newSpeciesDatas[count][1] = objSpeciesName != null ? objSpeciesName.toString().trim() : (strID.equals(mpkey) ? objSpeciesID.toString().trim() : "");
                    newSpeciesDatas[count][2] = objCluster.toString().trim();
                    newSpeciesDatas[count][3] = mpkey;
                    newSpeciesDatas[count][4] = this.SpeciesTypeComboBox.getSelectedItem().toString();
                    newSpeciesDatas[count][5] = "";
                    newSpeciesDatas[count][6] = "";
                    ++count;
                }
                ++i;
            }
        }
        catch (Exception ee) {
            throw new Exception();
        }
        return newSpeciesDatas;
    }

    private String[][] checkDatas(Vector datas) throws Exception {
        String[] tmp;
        if (datas == null || datas.size() < 2) {
            throw new Exception();
        }
        String[][] strInputFromDataFile = null;
        int iNumOfRows = datas.size();
        int iNumOfCols = ((String[])datas.get(0)).length;
        if (iNumOfCols > 101) {
            throw new Exception();
        }
        if (iNumOfCols < 2) {
            throw new Exception();
        }
        int i = 1;
        while (i < datas.size()) {
            tmp = (String[])datas.get(i);
            if (iNumOfCols != tmp.length) {
                throw new Exception();
            }
            ++i;
        }
        strInputFromDataFile = new String[iNumOfRows][iNumOfCols];
        i = 0;
        while (i < datas.size()) {
            tmp = (String[])datas.get(i);
            int j = 0;
            while (j < tmp.length) {
                if (i == 0 || j == 0) {
                    strInputFromDataFile[i][j] = tmp[j] == null ? "" : tmp[j].trim();
                } else {
                    try {
                        String strTmp = tmp[j].trim().replace(",", "");
                        if ("".equals(strTmp)) {
                            strInputFromDataFile[i][j] = "";
                        } else {
                            double input = Double.parseDouble(strTmp);
                            if (Double.isInfinite(input)) {
                                throw new Exception();
                            }
                            strInputFromDataFile[i][j] = "" + input;
                        }
                    }
                    catch (Exception myErr) {
                        throw new Exception();
                    }
                }
                ++j;
            }
            ++i;
        }
        return strInputFromDataFile;
    }

    private void sheetSelectComboBox_itemStateChanged() {
        Object ob = this.SheetSelectComboBox.getSelectedItem();
        if (ob != null) {
            String strSheetName = this.SheetSelectComboBox.getSelectedItem().toString();
            this.setDatasOfCurrentSheet(strSheetName);
            this.resetDialog();
        }
    }

    private void resetDialog() {
        if (this.rowHeadModel == null || this.dataModel == null) {
            return;
        }
        this.rowHeadModel.fireTableStructureChanged();
        this.dataModel.fireTableStructureChanged();
        TableCellRenderer cellRendererOfRowNumTable = this.rowNumTable.getTableHeader().getDefaultRenderer();
        if (cellRendererOfRowNumTable instanceof DefaultTableCellRenderer) {
            DefaultTableCellRenderer defaultcellRendererOfRowNumTable = (DefaultTableCellRenderer)cellRendererOfRowNumTable;
            defaultcellRendererOfRowNumTable.setHorizontalAlignment(0);
        }
        DefaultTableCellRenderer rederer = new DefaultTableCellRenderer();
        rederer.setHorizontalAlignment(0);
        this.rowNumTable.getColumnModel().getColumn(0).setCellRenderer(rederer);
        TableCellRenderer cellRendererOfDataTable = this.dataTable.getTableHeader().getDefaultRenderer();
        if (cellRendererOfDataTable instanceof DefaultTableCellRenderer) {
            DefaultTableCellRenderer defaultcellRendererOfDataTable = (DefaultTableCellRenderer)cellRendererOfDataTable;
            defaultcellRendererOfDataTable.setHorizontalAlignment(0);
        }
        this.initColComboBoxValue(this.SpeciesIdComboBox);
        this.initColComboBoxValue(this.SpeciesNameComboBox);
        this.initColComboBoxValue(this.dataColSelectComboBox);
        this.initColComboBoxValue(this.clusterComboBox);
        this.initRowLabelComboBoxValue(this.keyRowComboBox);
        this.initRowLabelComboBoxValue(this.timeLabelComboBox);
        this.initRowLabelComboBoxValue(this.dataRowSelectComboBox);
        this.initRowLabelComboBoxValue(this.mrmdataTypeRowComboBox);
        this.SpeciesTypeComboBox.setSelectedIndex(0);
        this.sameKeyCheckBox.setSelected(false);
        this.keyRowMustInputLabel.setVisible(false);
        this.mappingKeyComboBox.setSelectedItem(strID);
        this.speciesIdMustInputLabel.setVisible(true);
        this.speciesNameMustInputLabel.setVisible(false);
        this.resetMiriamPanel();
        JViewport viewport = new JViewport();
        JTable rowNumTbl = this.getrowNumTable();
        viewport.setView(rowNumTbl);
        viewport.setScrollMode(1);
        viewport.setPreferredSize(rowNumTbl.getPreferredSize());
        this.jScrollPane.setRowHeaderView(viewport);
        this.releaseDragDrop();
    }

    private void resetMiriamPanel() {
        this.listRelationAndIDCol = new ArrayList();
        if (this.miriamrelComboBox != null) {
            this.setOldmiriamRelationIndex(0);
            this.miriamrelComboBox.setSelectedIndex(0);
        }
        if (this.mrmdataTypeRowComboBox != null) {
            this.mrmdataTypeRowComboBox.setSelectedIndex(0);
        }
        if (this.txtfldMiriamdatatypeCols != null) {
            this.txtfldMiriamdatatypeCols.setText("");
        }
    }

    private void cancel_actionPerformed() {
        this.bCanceled = true;
        this.setVisible(false);
    }

    public boolean isCanceled() {
        return this.bCanceled;
    }

    private void setSelectedColumnName(String selection) {
        this.selectedCulomnName = selection;
    }

    private String getSelectedColumnName() {
        return this.selectedCulomnName;
    }

    private void setPressRowIndexOfRowTable(int rowSelectionCulomnIndex) {
        this.rowIndexOfRowTable = rowSelectionCulomnIndex;
    }

    private int getPressRowIndexOfRowTable() {
        return this.rowIndexOfRowTable;
    }

    private void init_rowNumTable_addListener() {
        if (this.rowNumTable == null) {
            return;
        }
        this.rowNumTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    return;
                }
                RsltDtBindingFrm.this.rowNumTable_mousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    return;
                }
                RsltDtBindingFrm.this.rowNumTable_mouseReleased(e);
            }
        });
        this.rowNumTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    return;
                }
                RsltDtBindingFrm.this.rowNumTable_mouseDrag(e);
            }
        });
    }

    private void rowNumTable_mousePressed(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        if (this.dataTable == null) {
            return;
        }
        try {
            if (e.getSource() instanceof JTable) {
                JTable table = (JTable)e.getSource();
                int index = table.getSelectionModel().getMaxSelectionIndex() + 1;
                this.setPressRowIndexOfRowTable(index);
            }
        }
        catch (Exception ex) {
            return;
        }
        if (e.getSource() == this.rowNumTable) {
            this.fixSelection(true);
        } else if (e.getSource() == this.dataTable) {
            this.fixSelection(false);
        }
    }

    private void rowNumTable_mouseReleased(MouseEvent e) {
        if (this.dataTable == null) {
            return;
        }
        JComponent selection = this.getDragTo();
        int index = this.getPressRowIndexOfRowTable();
        Cursor c = Cursor.getDefaultCursor();
        this.jPanelMain.setCursor(c);
        this.setCursorBySpecification(c);
        if (selection != null && selection instanceof JComboBox) {
            JComboBox combo = (JComboBox)selection;
            if (index >= 1) {
                combo.setSelectedIndex(index);
            }
            combo.setCursor(c);
        }
        this.releaseDragDrop();
        this.rowNumTable.clearSelection();
        this.rowNumTable.setRowSelectionInterval(index - 1, index - 1);
        if (e.getSource() == this.rowNumTable) {
            this.fixSelection(true);
        } else if (e.getSource() == this.dataTable) {
            this.fixSelection(false);
        }
    }

    private void releaseDragDrop() {
        this.isDragingTabelHead = false;
        this.isDragingTabelRowHead = false;
        this.setDragTo(null);
    }

    private void rowNumTable_mouseDrag(MouseEvent e) {
        if (this.dataTable == null) {
            return;
        }
        int index = this.getPressRowIndexOfRowTable();
        this.rowNumTable.clearSelection();
        this.rowNumTable.setRowSelectionInterval(index - 1, index - 1);
        this.dataTable.clearSelection();
        this.dataTable.setRowSelectionInterval(index - 1, index - 1);
        Cursor c = DragSource.DefaultMoveNoDrop;
        this.jPanelMain.setCursor(c);
        this.isDragingTabelRowHead = true;
        if (Application.isMacOSX) {
            JComponent seleceted = null;
            Point ePoint = e.getComponent().getLocationOnScreen();
            Point newePoint = new Point((int)(ePoint.getX() + (double)e.getX()), (int)(ePoint.getY() + (double)e.getY()));
            seleceted = this.getSelectedComponentByCursorOver(this.dataRowSelectComboBox, newePoint, seleceted);
            seleceted = this.getSelectedComponentByCursorOver(this.keyRowComboBox, newePoint, seleceted);
            seleceted = this.getSelectedComponentByCursorOver(this.mrmdataTypeRowComboBox, newePoint, seleceted);
            seleceted = this.getSelectedComponentByCursorOver(this.timeLabelComboBox, newePoint, seleceted);
            this.setDragTo(seleceted);
            if (seleceted != null) {
                Cursor c1 = DragSource.DefaultCopyDrop;
                seleceted.setCursor(c1);
            } else {
                Cursor c1 = new Cursor(12);
                this.jPanelMain.setCursor(c1);
                this.setCursorBySpecification(c1);
            }
        }
    }

    private void init_dataTable_addListener() {
        if (this.dataTable == null) {
            return;
        }
        this.dataTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    return;
                }
                RsltDtBindingFrm.this.rowNumTable_mousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    return;
                }
                RsltDtBindingFrm.this.rowNumTable_mouseReleased(e);
            }
        });
        this.dataTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    return;
                }
                RsltDtBindingFrm.this.rowNumTable_mouseDrag(e);
            }
        });
        this.dataTable.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    return;
                }
                RsltDtBindingFrm.this.dataTable_TableHeader_mousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    return;
                }
                RsltDtBindingFrm.this.dataTable_TableHeader_mouseReleased();
            }
        });
        this.dataTable.getTableHeader().addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    return;
                }
                RsltDtBindingFrm.this.dataTable_TableHeader_mouseDragged(e);
            }
        });
    }

    private void dataTable_TableHeader_mousePressed(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        try {
            if (e.getSource() instanceof JTableHeader) {
                JTableHeader header = (JTableHeader)e.getSource();
                int index = header.getColumnModel().getColumnIndexAtX(e.getX());
                String colName = String.valueOf(header.getColumnModel().getColumn(index).getHeaderValue());
                this.setSelectedColumnName(colName);
            }
        }
        catch (Exception ex) {
            return;
        }
    }

    private void dataTable_TableHeader_mouseDragged(MouseEvent e) {
        if (this.dataTable == null) {
            return;
        }
        Cursor c = DragSource.DefaultMoveNoDrop;
        this.jPanelMain.setCursor(c);
        this.isDragingTabelHead = true;
        if (Application.isMacOSX) {
            JComponent seleceted = null;
            Point ePoint = e.getComponent().getLocationOnScreen();
            Point newePoint = new Point((int)(ePoint.getX() + (double)e.getX()), (int)(ePoint.getY() + (double)e.getY()));
            seleceted = this.getSelectedComponentByCursorOver(this.clusterComboBox, newePoint, seleceted);
            seleceted = this.getSelectedComponentByCursorOver(this.dataColSelectComboBox, newePoint, seleceted);
            seleceted = this.getSelectedComponentByCursorOver(this.SpeciesIdComboBox, newePoint, seleceted);
            seleceted = this.getSelectedComponentByCursorOver(this.SpeciesNameComboBox, newePoint, seleceted);
            this.setDragTo(seleceted);
            if (seleceted != null) {
                Cursor c1 = DragSource.DefaultCopyDrop;
                seleceted.setCursor(c1);
            } else {
                Cursor c1 = new Cursor(12);
                this.jPanelMain.setCursor(c1);
                this.setCursorBySpecification(c1);
            }
        }
    }

    private void dataTable_TableHeader_mouseReleased() {
        if (this.dataTable == null) {
            return;
        }
        JComponent selection = this.getDragTo();
        String colu = this.getSelectedColumnName();
        Cursor c = Cursor.getDefaultCursor();
        this.jPanelMain.setCursor(c);
        this.setCursorBySpecification(c);
        if (selection != null && selection instanceof JComboBox) {
            JComboBox combo = (JComboBox)selection;
            if (colu != null && !"".equals(colu)) {
                int bak = combo.getSelectedIndex();
                combo.setSelectedItem(colu);
                if (combo.getSelectedIndex() == -1) {
                    combo.setSelectedIndex(bak);
                }
            }
            combo.setCursor(c);
        }
        this.releaseDragDrop();
    }

    private JComponent getSelectedComponentByCursorOver(JComboBox comboBox, Point point, JComponent selectedCombo) {
        if (comboBox == null) {
            return null;
        }
        if (selectedCombo != null) {
            return selectedCombo;
        }
        Point pointCluster = comboBox.getLocationOnScreen();
        Rectangle rectangle = (Rectangle)comboBox.getBounds().clone();
        rectangle.setFrame(pointCluster.getX(), pointCluster.getY(), rectangle.getWidth(), rectangle.getHeight());
        if (rectangle.contains(point)) {
            return comboBox;
        }
        return null;
    }

    public void setCursorBySpecification(Cursor c1) {
        if (c1 == null) {
            return;
        }
        this.dataRowSelectComboBox.setCursor(c1);
        this.keyRowComboBox.setCursor(c1);
        this.mrmdataTypeRowComboBox.setCursor(c1);
        this.timeLabelComboBox.setCursor(c1);
        this.clusterComboBox.setCursor(c1);
        this.dataColSelectComboBox.setCursor(c1);
        this.SpeciesIdComboBox.setCursor(c1);
        this.SpeciesNameComboBox.setCursor(c1);
        this.FileNameTextField.setCursor(c1);
        this.txtfldMiriamdatatypeCols.setCursor(c1);
    }

    private void setDragTo(JComponent component) {
        this.dragTo = component;
    }

    private JComponent getDragTo() {
        return this.dragTo;
    }

    private void init_ColComboBox_addListener(JComboBox combo) {
        combo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (!(e.getSource() instanceof JComponent)) {
                    return;
                }
                JComponent combo = (JComponent)e.getSource();
                if (RsltDtBindingFrm.this.isDragingTabelHead) {
                    RsltDtBindingFrm.this.setDragTo(combo);
                    Cursor c = DragSource.DefaultMoveDrop;
                    combo.setCursor(c);
                } else if (RsltDtBindingFrm.this.isDragingTabelRowHead) {
                    Cursor c = DragSource.DefaultMoveNoDrop;
                    combo.setCursor(c);
                } else {
                    Cursor c = Cursor.getDefaultCursor();
                    combo.setCursor(c);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                RsltDtBindingFrm.this.setDragTo(null);
            }
        });
    }

    private void init_RowComboBox_addListener(JComboBox combo) {
        combo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (!(e.getSource() instanceof JComponent)) {
                    return;
                }
                JComponent combo = (JComponent)e.getSource();
                if (RsltDtBindingFrm.this.isDragingTabelRowHead) {
                    RsltDtBindingFrm.this.setDragTo(combo);
                    Cursor c = DragSource.DefaultMoveDrop;
                    combo.setCursor(c);
                } else if (RsltDtBindingFrm.this.isDragingTabelHead) {
                    Cursor c = DragSource.DefaultMoveNoDrop;
                    combo.setCursor(c);
                } else {
                    Cursor c = Cursor.getDefaultCursor();
                    combo.setCursor(c);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                RsltDtBindingFrm.this.setDragTo(null);
            }
        });
    }

    public void setDataType(int dataType) {
        this.dataType = dataType;
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public void setDatasOfAllSheet(List datas) {
        this.datasFromFile = datas;
    }

    public List getDatasOfAllSheet() {
        return this.datasFromFile;
    }

    private void setDatasOfCurrentSheet(String strSheetName) {
        this.datasOfCurrentSheet = new ArrayList<List<Object>>();
        try {
            int i = 0;
            while (i < this.datasFromFile.size()) {
                HashMap sheetData = (HashMap)this.datasFromFile.get(i);
                if (sheetData != null && sheetData.containsKey(strSheetName)) {
                    this.datasOfCurrentSheet = (List)sheetData.get(strSheetName);
                    break;
                }
                ++i;
            }
        }
        catch (Exception ex) {
            this.datasOfCurrentSheet = new ArrayList<List<Object>>();
        }
    }

    public List getDatasOfCurrentSheet() {
        return this.datasOfCurrentSheet;
    }

    public static final File openXlsFile(Component parentfrm) {
        Object objRtn;
        int last;
        JTextField txtfld;
        File rtn = null;
        File xlsfile = null;
        String[] filetyps = new String[]{strXls};
        FileSuffixFilter suffixFilter = new FileSuffixFilter(filetyps);
        MyFileFilter xmlFilter = new MyFileFilter(filetyps, "Excel Files");
        MyFileFilter[] fileFilters = new MyFileFilter[]{xmlFilter};
        String dir = ".";
        RsltDtBindingFrm bndfrm = null;
        if (parentfrm instanceof MappingArrayMassShowerMainWinFrm) {
            MappingArrayMassShowerMainWinFrm massfrm = (MappingArrayMassShowerMainWinFrm)parentfrm;
            bndfrm = massfrm.getRsltDtBindingFrm();
        } else if (parentfrm instanceof RsltDtBindingFrm) {
            bndfrm = (RsltDtBindingFrm)parentfrm;
        }
        if (bndfrm != null && (txtfld = bndfrm.getFileNameTextField()).getText() != null && !txtfld.getText().trim().equals("") && (last = (dir = txtfld.getText()).lastIndexOf(separator)) > 0) {
            dir = String.valueOf(dir.substring(0, last)) + separator;
        }
        if ((objRtn = FileManager.openMyFile(parentfrm, fileFilters, dir)) instanceof Integer) {
            return rtn;
        }
        if (objRtn instanceof File) {
            xlsfile = (File)objRtn;
            if (!suffixFilter.accept(xlsfile)) {
                JOptionPane.showOptionDialog(parentfrm, "The excel file you selected is not satisfied.", strError, -1, 0, null, null, null);
                return rtn;
            }
        } else {
            JOptionPane.showOptionDialog(parentfrm, "The excel file you selected is not satisfied.", strError, -1, 0, null, null, null);
            return rtn;
        }
        return xlsfile;
    }

    public String[][] getMassDatas() {
        return this.strDataFromFile;
    }

    public void setMassDatas(String[][] datas) {
        this.strDataFromFile = datas;
    }

    public String[][] getAuxDatas() {
        return this.strAuxDatas;
    }

    public void setAuxDatas(String[][] datas) {
        this.strAuxDatas = datas;
    }

    public void setModelType(int modelType) {
        this.modelType = modelType;
    }

    public int getModelType() {
        return this.modelType;
    }

    public int getOldmiriamRelationIndex() {
        return this.miriamRelationBak;
    }

    public void setOldmiriamRelationIndex(int miriamRelationBak) {
        this.miriamRelationBak = miriamRelationBak;
    }

    public Vector[] getMiriamDatas() {
        return this.miriamDatas;
    }

    public void setMiriamDatas(Vector[] miriamDatas) {
        this.miriamDatas = miriamDatas;
    }

    public List getRelationsAndIDCols() {
        return this.listRelationAndIDCol;
    }

    private void setRelationsAndIDCols(String strRelation, List IDCols, String strText) {
        if (strRelation == null || "".equals(strRelation) || IDCols == null || strText == null) {
            return;
        }
        if (this.listRelationAndIDCol == null) {
            this.listRelationAndIDCol = new ArrayList();
        }
        boolean inContains = false;
        int i = 0;
        while (i < this.listRelationAndIDCol.size()) {
            HashMap singleRelation = (HashMap)this.listRelationAndIDCol.get(i);
            if (singleRelation.containsKey(strRelation) && singleRelation.containsKey(String.valueOf(strRelation) + strBufferKey)) {
                singleRelation.put(strRelation, IDCols);
                singleRelation.put(String.valueOf(strRelation) + strBufferKey, strText);
                inContains = true;
                break;
            }
            ++i;
        }
        if (!inContains) {
            HashMap<String, Object> temp = new HashMap<String, Object>();
            temp.put(strRelation, IDCols);
            temp.put(String.valueOf(strRelation) + strBufferKey, strText);
            this.listRelationAndIDCol.add(temp);
        }
    }

    private Vector[] getMiriamInfodata(int speciesIDNum, int dataRowselectNum, int dataTypeRow) {
        List lsRelation = this.getRelationsAndIDCols();
        if (lsRelation == null || lsRelation.size() <= 0) {
            return null;
        }
        if (this.datasOfCurrentSheet == null || this.datasOfCurrentSheet.size() == 0) {
            return null;
        }
        if (speciesIDNum < 0 || dataRowselectNum < 1 || dataTypeRow < 1 || dataRowselectNum > this.datasOfCurrentSheet.size() || dataTypeRow > this.datasOfCurrentSheet.size()) {
            return null;
        }
        int size = this.datasOfCurrentSheet.size() - dataRowselectNum + 1 + 1;
        int count = 0;
        Vector[] miriams = new Vector[size];
        miriams[count++] = new Vector();
        List<Object> dataTypeRowData = this.datasOfCurrentSheet.get(dataTypeRow - 1);
        int i = dataRowselectNum - 1;
        while (i < this.datasOfCurrentSheet.size()) {
            List<Object> rowdata = this.datasOfCurrentSheet.get(i);
            Vector<MiriamDefinition> lsmiriams = new Vector<MiriamDefinition>();
            if (rowdata != null) {
                int ct = 0;
                while (ct < lsRelation.size()) {
                    MiriamDefinition miriam = new MiriamDefinition();
                    Vector<MiriamSubDefinition> datas = new Vector<MiriamSubDefinition>();
                    HashMap singleRelation = (HashMap)lsRelation.get(ct);
                    for (Object key : singleRelation.keySet()) {
                        if (key == null || "".equals(key) || key.toString().endsWith(strBufferKey)) continue;
                        miriam.setRelation(key.toString());
                        List dataCols = (List)singleRelation.get(key);
                        int cnt = 0;
                        while (cnt < dataCols.size()) {
                            MiriamSubDefinition singleDate = new MiriamSubDefinition();
                            int colIndex = Integer.parseInt(dataCols.get(cnt).toString());
                            if (colIndex < dataTypeRowData.size()) {
                                String strDataType = dataTypeRowData.get(colIndex).toString();
                                singleDate.strDataType = new String(strDataType);
                            }
                            if (colIndex < rowdata.size()) {
                                String strMiriamId = rowdata.get(colIndex).toString();
                                singleDate.strId = new String(strMiriamId);
                            }
                            datas.add(singleDate);
                            ++cnt;
                        }
                    }
                    miriam.setDatas(datas);
                    lsmiriams.add(miriam);
                    ++ct;
                }
            }
            miriams[count] = lsmiriams;
            ++count;
            ++i;
        }
        return miriams;
    }

    private void checkDataColsOfMiriam() throws Exception {
        if (this.getOldmiriamRelationIndex() <= 0) {
            return;
        }
        String strRelation = this.miriamrelComboBox.getItemAt(this.getOldmiriamRelationIndex()).toString();
        String dataColOfMiriam = this.txtfldMiriamdatatypeCols.getText();
        if (dataColOfMiriam != null && !"".equals(dataColOfMiriam.trim())) {
            Object[] strColNums;
            Vector<String> tmpCols = new Vector<String>();
            String aHead = "";
            int i = 0;
            while (i < dataColOfMiriam.length()) {
                char achar = dataColOfMiriam.charAt(i);
                String astr = new String(new char[]{achar});
                if (astr.matches("[a-zA-Z]")) {
                    aHead = String.valueOf(aHead) + astr;
                } else {
                    if (astr.matches("[0-9]")) {
                        throw new Exception("The format of [dataCols] is not satisfied.");
                    }
                    if (!"".equals(aHead.trim())) {
                        tmpCols.add(aHead.trim());
                    }
                    aHead = "";
                }
                ++i;
            }
            if (!"".equals(aHead.trim())) {
                tmpCols.add(aHead);
            }
            if ((strColNums = tmpCols.toArray()) != null && strColNums.length > 0 && this.dataModel != null) {
                int size = this.dataModel.getColumnCount();
                ArrayList<String> lsColNames = new ArrayList<String>();
                int i2 = 0;
                while (i2 < size) {
                    lsColNames.add(this.dataModel.getColumnName(i2).toLowerCase());
                    ++i2;
                }
                ArrayList<Integer> dataColNums = new ArrayList<Integer>();
                int ct = 0;
                while (ct < strColNums.length) {
                    String colNum = strColNums[ct].toString();
                    if (!lsColNames.contains(colNum.trim().toLowerCase())) {
                        throw new Exception("The name in [dataCols] is not satisfied.");
                    }
                    int idx = lsColNames.indexOf(colNum.trim().toLowerCase());
                    if (!dataColNums.contains(idx)) {
                        dataColNums.add(idx);
                    }
                    ++ct;
                }
                this.setRelationsAndIDCols(strRelation, dataColNums, dataColOfMiriam);
            }
        }
    }
}

