/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.plugin.InfoCenter.InfoUI;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.fric.graphics.multiwindow.FileManager;
import jp.fric.io.util.MyFileFilter;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.plugin.InfoCenter.InfoUI.MappingArrayMassShowerMainWinFrm;

public class MassAnimOutputOptionFrm
extends JDialog {
    private static final String strGifFileExtName = "gif";
    private static final String strMovFileExtName = "mov";
    private static final String separator = System.getProperty("file.separator");
    private boolean bCanceled = false;
    private JButton jButtonCancel = null;
    private JButton jButtonGifFileSelect = null;
    private JButton jButtonMovFileSelect = null;
    private JButton jButtonOk = null;
    private JCheckBox jCheckBoxAutoResizeGif = null;
    private JCheckBox jCheckBoxAutoResizeMov = null;
    private JCheckBox jCheckBoxGifOut = null;
    private JCheckBox jCheckBoxMovOut = null;
    private JPanel jPanelMain = null;
    private JPanel jPanelGif = null;
    private JPanel jPanelMov = null;
    private JTextField jTextFieldGifFileName = null;
    private JTextField jTextFieldMovFileName = null;

    public MassAnimOutputOptionFrm(JFrame parent) {
        super(parent);
        this.initialize();
    }

    private void initialize() {
        this.setDefaultCloseOperation(0);
        this.setTitle("Output file type");
        this.setModal(true);
        this.setResizable(false);
        this.setSize(new Dimension(440, 300));
        this.setContentPane(this.getJPanelMain());
    }

    private JPanel getJPanelMain() {
        if (this.jPanelMain == null) {
            this.jPanelMain = new JPanel();
            this.jPanelMain.setLayout(null);
            this.jPanelMain.add((Component)this.getJPanelGif(), null);
            this.jPanelMain.add((Component)this.getJPanelMov(), null);
            this.jPanelMain.add((Component)this.getJButtonOk(), null);
            this.jPanelMain.add((Component)this.getJButtonCancel(), null);
        }
        return this.jPanelMain;
    }

    private JPanel getJPanelGif() {
        if (this.jPanelGif == null) {
            this.jPanelGif = new JPanel();
            this.jPanelGif.setLayout(null);
            this.jPanelGif.setBounds(new Rectangle(5, 5, 420, 100));
            this.jPanelGif.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1));
            this.jPanelGif.add((Component)this.getJCheckBoxGifOut(), null);
            this.jPanelGif.add((Component)this.getJButtonGifFileSelect(), null);
            this.jPanelGif.add((Component)this.getJTextFieldGifFileName(), null);
            this.jPanelGif.add((Component)this.getJCheckBoxAutoResizeGif(), null);
        }
        return this.jPanelGif;
    }

    private JPanel getJPanelMov() {
        if (this.jPanelMov == null) {
            this.jPanelMov = new JPanel();
            this.jPanelMov.setLayout(null);
            this.jPanelMov.setBounds(new Rectangle(5, 110, 420, 100));
            this.jPanelMov.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1));
            this.jPanelMov.add((Component)this.getJCheckBoxMovOut(), null);
            this.jPanelMov.add((Component)this.getJButtonMovFileSelect(), null);
            this.jPanelMov.add((Component)this.getJCheckBoxAutoResizeMov(), null);
            this.jPanelMov.add((Component)this.getJTextFieldMovFileName(), null);
        }
        return this.jPanelMov;
    }

    public JCheckBox getJCheckBoxGifOut() {
        if (this.jCheckBoxGifOut == null) {
            this.jCheckBoxGifOut = new JCheckBox();
            this.jCheckBoxGifOut.setText("output gif file");
            this.jCheckBoxGifOut.setBounds(new Rectangle(10, 10, 120, 20));
        }
        return this.jCheckBoxGifOut;
    }

    public JCheckBox getJCheckBoxMovOut() {
        if (this.jCheckBoxMovOut == null) {
            this.jCheckBoxMovOut = new JCheckBox();
            this.jCheckBoxMovOut.setText("output mov file");
            this.jCheckBoxMovOut.setBounds(new Rectangle(10, 10, 140, 20));
        }
        return this.jCheckBoxMovOut;
    }

    public JCheckBox getJCheckBoxAutoResizeGif() {
        if (this.jCheckBoxAutoResizeGif == null) {
            this.jCheckBoxAutoResizeGif = new JCheckBox();
            this.jCheckBoxAutoResizeGif.setText("auto resize");
            this.jCheckBoxAutoResizeGif.setBounds(new Rectangle(30, 70, 180, 20));
        }
        return this.jCheckBoxAutoResizeGif;
    }

    public JCheckBox getJCheckBoxAutoResizeMov() {
        if (this.jCheckBoxAutoResizeMov == null) {
            this.jCheckBoxAutoResizeMov = new JCheckBox();
            this.jCheckBoxAutoResizeMov.setText("auto resize");
            this.jCheckBoxAutoResizeMov.setBounds(new Rectangle(30, 70, 180, 20));
        }
        return this.jCheckBoxAutoResizeMov;
    }

    private JButton getJButtonGifFileSelect() {
        if (this.jButtonGifFileSelect == null) {
            this.jButtonGifFileSelect = new JButton();
            this.jButtonGifFileSelect.setText("Browse");
            this.jButtonGifFileSelect.setBounds(new Rectangle(30, 40, 90, 20));
            this.jButtonGifFileSelect.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MassAnimOutputOptionFrm.this.getFileName(MassAnimOutputOptionFrm.strGifFileExtName, MassAnimOutputOptionFrm.this.jTextFieldGifFileName);
                }
            });
        }
        return this.jButtonGifFileSelect;
    }

    private JButton getJButtonMovFileSelect() {
        if (this.jButtonMovFileSelect == null) {
            this.jButtonMovFileSelect = new JButton();
            this.jButtonMovFileSelect.setText("Browse");
            this.jButtonMovFileSelect.setBounds(new Rectangle(30, 40, 90, 20));
            this.jButtonMovFileSelect.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MassAnimOutputOptionFrm.this.getFileName(MassAnimOutputOptionFrm.strMovFileExtName, MassAnimOutputOptionFrm.this.jTextFieldMovFileName);
                }
            });
        }
        return this.jButtonMovFileSelect;
    }

    public JTextField getJTextFieldGifFileName() {
        if (this.jTextFieldGifFileName == null) {
            this.jTextFieldGifFileName = new JTextField();
            this.jTextFieldGifFileName.setEnabled(false);
            this.jTextFieldGifFileName.setEditable(false);
            this.jTextFieldGifFileName.setBounds(new Rectangle(130, 40, 280, 20));
        }
        return this.jTextFieldGifFileName;
    }

    public JTextField getJTextFieldMovFileName() {
        if (this.jTextFieldMovFileName == null) {
            this.jTextFieldMovFileName = new JTextField();
            this.jTextFieldMovFileName.setEnabled(false);
            this.jTextFieldMovFileName.setEditable(false);
            this.jTextFieldMovFileName.setBounds(new Rectangle(130, 40, 280, 20));
        }
        return this.jTextFieldMovFileName;
    }

    private JButton getJButtonOk() {
        if (this.jButtonOk == null) {
            this.jButtonOk = new JButton();
            this.jButtonOk.setBounds(new Rectangle(130, 220, 70, 30));
            this.jButtonOk.setText("Ok");
            this.jButtonOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MassAnimOutputOptionFrm.this.setVisible(false);
                }
            });
        }
        return this.jButtonOk;
    }

    private JButton getJButtonCancel() {
        if (this.jButtonCancel == null) {
            this.jButtonCancel = new JButton();
            this.jButtonCancel.setBounds(new Rectangle(260, 220, 90, 30));
            this.jButtonCancel.setText("Cancel");
            this.jButtonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MassAnimOutputOptionFrm.this.bCanceled = true;
                    MassAnimOutputOptionFrm.this.setVisible(false);
                }
            });
        }
        return this.jButtonCancel;
    }

    public boolean isCanceled() {
        return this.bCanceled;
    }

    public void initDialog() {
        this.getJPanelMain();
        this.jCheckBoxGifOut.setSelected(false);
        this.jTextFieldGifFileName.setText("");
        this.jCheckBoxAutoResizeGif.setSelected(false);
        this.jCheckBoxMovOut.setSelected(false);
        this.jTextFieldMovFileName.setText("");
        this.jCheckBoxAutoResizeMov.setSelected(false);
        this.bCanceled = false;
    }

    public void initDialogUsing(MappingArrayMassShowerMainWinFrm value) {
        this.initDialog();
        if (value == null) {
            return;
        }
        Date now = new Date();
        this.jCheckBoxGifOut.setSelected(value.isOutputGif());
        String oldfilename = value.getOutputGifFileName();
        this.jTextFieldGifFileName.setText(this.getOutputFileName(oldfilename, strGifFileExtName, now, value));
        this.jCheckBoxAutoResizeGif.setSelected(value.isScaleOutputGif());
        this.jCheckBoxMovOut.setSelected(value.isOutputMovie());
        oldfilename = value.getOutputMovFileName();
        this.jTextFieldMovFileName.setText(this.getOutputFileName(oldfilename, strMovFileExtName, now, value));
        this.jCheckBoxAutoResizeMov.setSelected(value.isScaleOutputMovie());
    }

    private String getOutputFileName(String oldfilename, String fileExtName, Date now, MappingArrayMassShowerMainWinFrm massfrm) {
        String strModelName;
        if (oldfilename != null && !oldfilename.trim().equals("")) {
            return oldfilename;
        }
        String dir = null;
        try {
            dir = massfrm.getRsltDtBindingFrm().getFile().getAbsolutePath();
            int last = dir.lastIndexOf(separator);
            if (last > 0) {
                dir = dir.substring(0, last);
            }
        }
        catch (Exception myErr) {
            dir = null;
        }
        if (dir == null || dir.trim().equals("")) {
            dir = System.getProperty("user.dir");
        }
        if (!dir.endsWith(separator)) {
            dir = String.valueOf(dir) + separator;
        }
        if ((strModelName = MainWindow.getLastInstance().getCurrentModel().getFilename()).endsWith(".xml")) {
            strModelName = strModelName.substring(0, strModelName.length() - 4);
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        String strDatetime = df.format(now);
        String strAnimiName = MappingArrayMassShowerMainWinFrm.giveMeOutputFileName(String.valueOf(strModelName) + "Mass" + strDatetime, fileExtName);
        return String.valueOf(dir) + strAnimiName;
    }

    private void getFileName(String type, JTextField txtfld) {
        Object objRtn;
        int last;
        if (txtfld == null) {
            return;
        }
        String tp = strGifFileExtName;
        if (strMovFileExtName.equals(type)) {
            tp = strMovFileExtName;
        }
        MyFileFilter filterGif = new MyFileFilter(new String[]{strGifFileExtName}, "Gif  Files");
        MyFileFilter filterMov = new MyFileFilter(new String[]{strMovFileExtName}, "Mov  Files");
        MyFileFilter filter = filterGif;
        if (strMovFileExtName.equals(tp)) {
            filter = filterMov;
        }
        MyFileFilter[] fileFilters = new MyFileFilter[]{filter};
        String dir = ".";
        if (txtfld.getText() != null && !txtfld.getText().trim().equals("") && (last = (dir = txtfld.getText()).lastIndexOf(separator)) > 0) {
            dir = String.valueOf(dir.substring(0, last)) + separator;
        }
        if ((objRtn = FileManager.selectTargetFile(this, fileFilters, dir)) != null && !(objRtn instanceof Integer) && objRtn instanceof File) {
            File file = (File)objRtn;
            file.exists();
            txtfld.setText(MappingArrayMassShowerMainWinFrm.giveMeOutputFileName(file.getAbsolutePath(), tp));
        }
    }
}

