/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.plugin.InfoCenter.InfoUI;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.fric.graphics.draw.GStructure;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.SBModelFrame;
import jp.sbi.celldesigner.animationutil.AnimatedGifEncoder;
import jp.sbi.celldesigner.animationutil.JpegImagesToMovie;
import jp.sbi.celldesigner.plugin.InfoCenter.InfoShower.InformationShowerMappingArrayMass;
import jp.sbi.celldesigner.plugin.InfoCenter.InfoUI.MappingArrayMassShowerConfigWinFrm;
import jp.sbi.celldesigner.plugin.InfoCenter.InfoUI.MassAnimOutputOptionFrm;
import jp.sbi.celldesigner.plugin.InfoCenter.InfoUI.MassOutputAnimationTask;
import jp.sbi.celldesigner.plugin.InfoCenter.InfoUI.RsltDtBindingFrm;
import jp.sbi.celldesigner.plugin.InfoCenter.InfoUI.RsltDtTpMdlSelectFrm;
import jp.sbi.celldesigner.util.CelldUtil;
import jp.sbi.celldesigner.util.ProcessBarFrm;
import jp.sbi.celldesigner.util.ReturnValue;

public class MappingArrayMassShowerMainWinFrm
extends JFrame {
    private static final String strJpgFileExtName = "jpg";
    private static final String strGifFileExtName = "gif";
    private static final String strMovFileExtName = "mov";
    private static final Dimension dimMovieMaxArea = new Dimension(640, 480);
    private static final Dimension dimGifMaxArea = new Dimension(1280, 1024);
    private boolean bOutputGif = true;
    private boolean bOutputMovie = true;
    private boolean bScaleOutputGif = true;
    private boolean bScaleOutputMovie = true;
    private String strOutputGifFileName = "";
    private String strOutputMovFileName = "";
    private static final Dimension dimFrmDefaultInWinOS = new Dimension(660, 270);
    private static final String strHavehadThisInstanceInCurrentGStructureErrMessage = "You can not get another controller, because you are having one.";
    private static final String strSystemErrMessage = "It cannot be shown, because the system error occurred.";
    private static final String strPrefixJTimeLableMessage = "Time value is [";
    private static final String strSuffixJTimeLableMessage = "] now.";
    private static final String strPrefixMaxValueLableMessage = "Max value is [";
    private static final String strSuffixMaxValueLableMessage = "] .";
    private static final String strPrefixMinValueLableMessage = "Min value is [";
    private static final String strSuffixMinValueLableMessage = "] .";
    private static final int iInitPercentOnJSliderBar = 0;
    private static final String strDataLineSplit = "\t";
    private static final int iMaxInputDataRows = 2001;
    private static final int iMaxInputDataColumns = 101;
    private static final int iMinInputDataColumns = 2;
    private static final int iMinDeltaPercentOnJSliderBarForShowLabel = 10;
    private static final int iTotalCharsOfJSliderBarLabel = 8;
    private String[][] strDataFromFile;
    private String[][] strAuxDatas = null;
    private GStructure gstructureTarget = null;
    private JPanel jPanelMain = null;
    private JLabel jLabel = null;
    private JSlider jSliderPercent = null;
    private JButton jButtonLoadData = null;
    private JButton jButtonSaveAnimation = null;
    private JButton jButtonConfig = null;
    private JButton jButtonClose = null;
    private JLabel jLabelEndTimeTitle = null;
    private JLabel jLabelEndTimeValue = null;
    private JLabel jLabelStartTimeTitle = null;
    private JLabel jLabelStartTimeValue = null;
    private JPanel jPanelPreviewMaxColor = null;
    private JPanel jPanelPreviewMinColor = null;
    private JLabel jLabelMaxValue = null;
    private JLabel jLabelMinValue = null;
    private InformationShowerMappingArrayMass mappingmass = null;
    private int iCurrPercentOnJSliderBar = 0;
    public static final Color colorDefaultMax = Color.RED;
    public static final Color colorDefaultMid = Color.YELLOW;
    public static final Color colorDefaultMin = Color.GREEN;
    private Color colorMax = colorDefaultMax;
    private Color colorMid = colorDefaultMid;
    private Color colorMin = colorDefaultMin;
    private double lMax = 100.0;
    private double lMin = 0.0;
    private double lMid = (this.lMax + this.lMin) / 2.0;
    private double dMaxInputed = 1.0;
    private double dMinInputed = 0.0;
    private boolean showGuideMsg = true;
    protected boolean firstRun = true;
    private MappingArrayMassShowerConfigWinFrm showerSettingWin = null;
    private ProcessBarFrm processFrm = new ProcessBarFrm(this);
    private MassAnimOutputOptionFrm massAnimOutputOptionFrm = new MassAnimOutputOptionFrm(MainWindow.getLastInstance());
    private boolean bProcessingAnimOutput = false;
    private RsltDtTpMdlSelectFrm rsltDtTpMdlSelectFrm = null;
    private RsltDtBindingFrm rsltDtBindingFrm = null;

    private MappingArrayMassShowerMainWinFrm() {
        this.initialize();
        this.initGUI();
    }

    public GStructure getReferenceGStructure() {
        return this.gstructureTarget;
    }

    public Color getMaxVauleColor() {
        return this.colorMax;
    }

    public void setMaxVauleColor(Color color) {
        if (color != null) {
            this.colorMax = color;
        }
    }

    public Color getMidVauleColor() {
        return this.colorMid;
    }

    public void setMidVauleColor(Color color) {
        if (color != null) {
            this.colorMid = color;
        }
    }

    public Color getMinVauleColor() {
        return this.colorMin;
    }

    public void setMinVauleColor(Color color) {
        if (color != null) {
            this.colorMin = color;
        }
    }

    public double getMidVaule() {
        return this.lMid;
    }

    public double getMaxVaule() {
        return this.lMax;
    }

    public void setMaxVaule(double val) {
        this.lMax = val;
        this.lMid = (this.lMax + this.lMin) / 2.0;
    }

    public double getMinVaule() {
        return this.lMin;
    }

    public void setMinVaule(double val) {
        this.lMin = val;
        this.lMid = (this.lMax + this.lMin) / 2.0;
    }

    public MappingArrayMassShowerConfigWinFrm getMappingArrayMassShowerConfigWinFrm() {
        if (this.showerSettingWin == null) {
            this.showerSettingWin = new MappingArrayMassShowerConfigWinFrm();
        }
        return this.showerSettingWin;
    }

    public void initMappingArrayMassShowerConfigWinFrm(Color colorMax, Color colorMid, Color colorMin, double lMax, double lMin) {
        this.showerSettingWin.setMaxVauleColor(colorMax);
        this.showerSettingWin.setMidVauleColor(colorMid);
        this.showerSettingWin.setMinVauleColor(colorMin);
        this.showerSettingWin.setMaxVaule(lMax);
        this.showerSettingWin.setMinVaule(lMin);
        this.showerSettingWin.repaintPreviewColor();
    }

    private void initialize() {
        this.setSize((Dimension)dimFrmDefaultInWinOS.clone());
        this.setTitle("Mapping Array Mass Shower");
        this.setResizable(false);
        this.setContentPane(this.getJPanelMain());
        this.massAnimOutputOptionFrm.setLocation(200, 200);
        this.processFrm.setLocation(200, 200);
        this.processFrm.resetJProgressBarFrm(false);
    }

    private JPanel getJPanelMain() {
        if (this.jPanelMain == null) {
            this.jLabelMinValue = new JLabel();
            this.jLabelMinValue.setBounds(new Rectangle(40, 45, 605, 25));
            this.jLabelMinValue.setText("");
            this.jLabelMaxValue = new JLabel();
            this.jLabelMaxValue.setBounds(new Rectangle(40, 10, 606, 25));
            this.jLabelMaxValue.setText("");
            this.jLabelStartTimeValue = new JLabel();
            this.jLabelStartTimeValue.setBounds(new Rectangle(5, 145, 60, 20));
            this.jLabelStartTimeValue.setHorizontalTextPosition(4);
            this.jLabelStartTimeValue.setHorizontalAlignment(4);
            this.jLabelStartTimeValue.setVerticalAlignment(1);
            this.jLabelStartTimeValue.setVerticalTextPosition(1);
            this.jLabelStartTimeTitle = new JLabel();
            this.jLabelStartTimeTitle.setBounds(new Rectangle(15, 120, 50, 20));
            this.jLabelStartTimeTitle.setHorizontalAlignment(4);
            this.jLabelStartTimeTitle.setHorizontalTextPosition(4);
            this.jLabelStartTimeTitle.setVerticalAlignment(3);
            this.jLabelStartTimeTitle.setVerticalTextPosition(3);
            this.jLabelStartTimeTitle.setText("Start");
            this.jLabelEndTimeValue = new JLabel();
            this.jLabelEndTimeValue.setBounds(new Rectangle(585, 145, 60, 20));
            this.jLabelEndTimeValue.setVerticalAlignment(1);
            this.jLabelEndTimeValue.setVerticalTextPosition(1);
            this.jLabelEndTimeTitle = new JLabel();
            this.jLabelEndTimeTitle.setBounds(new Rectangle(585, 120, 50, 20));
            this.jLabelEndTimeTitle.setVerticalAlignment(3);
            this.jLabelEndTimeTitle.setVerticalTextPosition(3);
            this.jLabelEndTimeTitle.setText("End");
            this.jLabel = new JLabel();
            this.jLabel.setBounds(new Rectangle(15, 80, 630, 25));
            this.jLabel.setText("");
            this.jPanelMain = new JPanel();
            this.jPanelMain.setLayout(null);
            this.jPanelMain.add((Component)this.jLabel, null);
            this.jPanelMain.add((Component)this.getJSliderPercent(), null);
            this.jPanelMain.add((Component)this.getJButtonLoadData(), null);
            this.jPanelMain.add((Component)this.getJButtonSaveAnimation(), null);
            this.jPanelMain.add((Component)this.getJButtonConfig(), null);
            this.jPanelMain.add((Component)this.getJButtonClose(), null);
            this.jPanelMain.add((Component)this.jLabelEndTimeTitle, null);
            this.jPanelMain.add((Component)this.jLabelEndTimeValue, null);
            this.jPanelMain.add((Component)this.jLabelStartTimeTitle, null);
            this.jPanelMain.add((Component)this.jLabelStartTimeValue, null);
            this.jPanelMain.add((Component)this.getJPanelPreviewMaxColor(), null);
            this.jPanelMain.add((Component)this.getJPanelPreviewMinColor(), null);
            this.jPanelMain.add((Component)this.jLabelMaxValue, null);
            this.jPanelMain.add((Component)this.jLabelMinValue, null);
        }
        return this.jPanelMain;
    }

    private JSlider getJSliderPercent() {
        if (this.jSliderPercent == null) {
            this.jSliderPercent = new JSlider();
            this.jSliderPercent.setBounds(new Rectangle(75, 120, 500, 50));
            this.jSliderPercent.setPaintTicks(false);
            this.jSliderPercent.setFocusable(false);
            this.jSliderPercent.setEnabled(false);
            this.jSliderPercent.setMinorTickSpacing(1);
            this.jSliderPercent.setMajorTickSpacing(5);
            this.setLabelOfSliderPercent(this.jSliderPercent, null, 10);
            this.jSliderPercent.setValue(0);
            this.jSliderPercent.addChangeListener(new ChangeListener(){

                @Override
                public synchronized void stateChanged(ChangeEvent e) {
                    MappingArrayMassShowerMainWinFrm.this.doStateChanged();
                }
            });
        }
        return this.jSliderPercent;
    }

    private JButton getJButtonLoadData() {
        if (this.jButtonLoadData == null) {
            this.jButtonLoadData = new JButton();
            this.jButtonLoadData.setBounds(new Rectangle(80, 190, 80, 30));
            this.jButtonLoadData.setText("Load");
            this.jButtonLoadData.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MappingArrayMassShowerMainWinFrm parentfrm = MappingArrayMassShowerMainWinFrm.this;
                    File xlsfile = RsltDtBindingFrm.openXlsFile(parentfrm);
                    if (xlsfile == null) {
                        return;
                    }
                    List datas = CelldUtil.getDataFromExcelFile(xlsfile);
                    if (datas == null || datas.size() == 0) {
                        JOptionPane.showMessageDialog(parentfrm, "The excel file you selected is not satisfied.", "Error", 0);
                        return;
                    }
                    int dataType = MappingArrayMassShowerMainWinFrm.this.rsltDtTpMdlSelectFrm.getmicroArrayRadioButton().isSelected() ? 1 : 2;
                    int modelType = -1;
                    if (MappingArrayMassShowerMainWinFrm.this.rsltDtTpMdlSelectFrm.getNewModelRadioButton().isSelected()) {
                        modelType = 1;
                    } else if (MappingArrayMassShowerMainWinFrm.this.rsltDtTpMdlSelectFrm.getCurrentModelRadioButton().isSelected()) {
                        modelType = 2;
                    } else if (MappingArrayMassShowerMainWinFrm.this.rsltDtTpMdlSelectFrm.getOpenXmlFileRadioButton().isSelected()) {
                        modelType = 3;
                    }
                    RsltDtBindingFrm rdfrm = new RsltDtBindingFrm(parentfrm, xlsfile, datas, dataType, modelType);
                    rdfrm.setVisible(true);
                    if (rdfrm.isCanceled()) {
                        return;
                    }
                    MappingArrayMassShowerMainWinFrm.this.rsltDtBindingFrm = rdfrm;
                    MappingArrayMassShowerMainWinFrm.this.strDataFromFile = MappingArrayMassShowerMainWinFrm.this.rsltDtBindingFrm.getMassDatas();
                    MappingArrayMassShowerMainWinFrm.this.strAuxDatas = MappingArrayMassShowerMainWinFrm.this.rsltDtBindingFrm.getAuxDatas();
                    MappingArrayMassShowerMainWinFrm.this.strOutputGifFileName = "";
                    MappingArrayMassShowerMainWinFrm.this.strOutputMovFileName = "";
                    MappingArrayMassShowerMainWinFrm.this.showUsingLoadedData(MappingArrayMassShowerMainWinFrm.this.showGuideMsg);
                }
            });
        }
        return this.jButtonLoadData;
    }

    private JButton getJButtonConfig() {
        if (this.jButtonConfig == null) {
            this.jButtonConfig = new JButton();
            this.jButtonConfig.setBounds(new Rectangle(190, 190, 110, 30));
            this.jButtonConfig.setText("Configure");
            this.jButtonConfig.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (MappingArrayMassShowerMainWinFrm.this.bProcessingAnimOutput) {
                        return;
                    }
                    MappingArrayMassShowerMainWinFrm.this.getMappingArrayMassShowerConfigWinFrm();
                    MappingArrayMassShowerMainWinFrm.this.initMappingArrayMassShowerConfigWinFrm(MappingArrayMassShowerMainWinFrm.this.colorMax, MappingArrayMassShowerMainWinFrm.this.colorMid, MappingArrayMassShowerMainWinFrm.this.colorMin, MappingArrayMassShowerMainWinFrm.this.lMax, MappingArrayMassShowerMainWinFrm.this.lMin);
                    if (!MappingArrayMassShowerMainWinFrm.this.showerSettingWin.IsWinBeenUsing()) {
                        MappingArrayMassShowerMainWinFrm.this.showerSettingWin.setIsWinBeenUsing(true);
                        MappingArrayMassShowerMainWinFrm.this.setAlwaysOnTop(false);
                        MappingArrayMassShowerMainWinFrm.this.showerSettingWin.setAlwaysOnTop(true);
                        MappingArrayMassShowerMainWinFrm.this.showerSettingWin.setVisible(true);
                        MappingArrayMassShowerMainWinFrm.this.showerSettingWin.setEnabled(true);
                        MappingArrayMassShowerMainWinFrm.this.setMaxVauleColor(MappingArrayMassShowerMainWinFrm.this.showerSettingWin.getMaxVauleColor());
                        MappingArrayMassShowerMainWinFrm.this.setMidVauleColor(MappingArrayMassShowerMainWinFrm.this.showerSettingWin.getMidVauleColor());
                        MappingArrayMassShowerMainWinFrm.this.setMinVauleColor(MappingArrayMassShowerMainWinFrm.this.showerSettingWin.getMinVauleColor());
                        MappingArrayMassShowerMainWinFrm.this.setMaxVaule(MappingArrayMassShowerMainWinFrm.this.showerSettingWin.getMaxVaule());
                        MappingArrayMassShowerMainWinFrm.this.setMinVaule(MappingArrayMassShowerMainWinFrm.this.showerSettingWin.getMinVaule());
                        MappingArrayMassShowerMainWinFrm.this.repaintPreviewColor();
                        MappingArrayMassShowerMainWinFrm.this.setGraphicDisplayerFromInputData(MappingArrayMassShowerMainWinFrm.this.strDataFromFile, MappingArrayMassShowerMainWinFrm.this.strAuxDatas, MappingArrayMassShowerMainWinFrm.this.iCurrPercentOnJSliderBar, MappingArrayMassShowerMainWinFrm.this.getMinVauleColor(), MappingArrayMassShowerMainWinFrm.this.getMidVauleColor(), MappingArrayMassShowerMainWinFrm.this.getMaxVauleColor(), MappingArrayMassShowerMainWinFrm.this.showGuideMsg);
                        MappingArrayMassShowerMainWinFrm.this.showerSettingWin.setAlwaysOnTop(false);
                        MappingArrayMassShowerMainWinFrm.this.setAlwaysOnTop(true);
                    }
                }
            });
        }
        return this.jButtonConfig;
    }

    private JButton getJButtonClose() {
        if (this.jButtonClose == null) {
            this.jButtonClose = new JButton();
            this.jButtonClose.setBounds(new Rectangle(500, 190, 80, 30));
            this.jButtonClose.setText("Close");
            this.jButtonClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MappingArrayMassShowerMainWinFrm.this.doCancelClose();
                }
            });
        }
        return this.jButtonClose;
    }

    private JPanel getJPanelPreviewMaxColor() {
        if (this.jPanelPreviewMaxColor == null) {
            this.jPanelPreviewMaxColor = new JPanel();
            this.jPanelPreviewMaxColor.setLayout(new GridBagLayout());
            this.jPanelPreviewMaxColor.setBounds(new Rectangle(15, 10, 20, 25));
            this.jPanelPreviewMaxColor.setOpaque(true);
        }
        return this.jPanelPreviewMaxColor;
    }

    private JPanel getJPanelPreviewMinColor() {
        if (this.jPanelPreviewMinColor == null) {
            this.jPanelPreviewMinColor = new JPanel();
            this.jPanelPreviewMinColor.setLayout(new GridBagLayout());
            this.jPanelPreviewMinColor.setBounds(new Rectangle(15, 45, 20, 25));
            this.jPanelPreviewMinColor.setOpaque(true);
        }
        return this.jPanelPreviewMinColor;
    }

    private JButton getJButtonSaveAnimation() {
        if (this.jButtonSaveAnimation == null) {
            this.jButtonSaveAnimation = new JButton();
            this.jButtonSaveAnimation.setBounds(new Rectangle(330, 190, 140, 30));
            this.jButtonSaveAnimation.setText("Save animation");
            this.jButtonSaveAnimation.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    5 var2_2 = this;
                    synchronized (var2_2) {
                        if (MappingArrayMassShowerMainWinFrm.this.strDataFromFile == null) {
                            return;
                        }
                        MainWindow parentfrm = MainWindow.getLastInstance();
                        MappingArrayMassShowerMainWinFrm showerfrm = MappingArrayMassShowerMainWinFrm.this;
                        if (MappingArrayMassShowerMainWinFrm.this.bProcessingAnimOutput) {
                            return;
                        }
                        try {
                            try {
                                showerfrm.setAlwaysOnTop(false);
                                MappingArrayMassShowerMainWinFrm.this.massAnimOutputOptionFrm.initDialogUsing(showerfrm);
                                MappingArrayMassShowerMainWinFrm.this.massAnimOutputOptionFrm.setVisible(true);
                            }
                            catch (Exception myErr) {
                                showerfrm.setAlwaysOnTop(true);
                                return;
                            }
                        }
                        finally {
                            showerfrm.setAlwaysOnTop(true);
                        }
                        if (MappingArrayMassShowerMainWinFrm.this.massAnimOutputOptionFrm.isCanceled()) {
                            return;
                        }
                        MappingArrayMassShowerMainWinFrm.this.bOutputGif = MappingArrayMassShowerMainWinFrm.this.massAnimOutputOptionFrm.getJCheckBoxGifOut().isSelected();
                        MappingArrayMassShowerMainWinFrm.this.bScaleOutputGif = MappingArrayMassShowerMainWinFrm.this.massAnimOutputOptionFrm.getJCheckBoxAutoResizeGif().isSelected();
                        MappingArrayMassShowerMainWinFrm.this.strOutputGifFileName = MappingArrayMassShowerMainWinFrm.this.massAnimOutputOptionFrm.getJTextFieldGifFileName().getText();
                        MappingArrayMassShowerMainWinFrm.this.bOutputMovie = MappingArrayMassShowerMainWinFrm.this.massAnimOutputOptionFrm.getJCheckBoxMovOut().isSelected();
                        MappingArrayMassShowerMainWinFrm.this.bScaleOutputMovie = MappingArrayMassShowerMainWinFrm.this.massAnimOutputOptionFrm.getJCheckBoxAutoResizeMov().isSelected();
                        MappingArrayMassShowerMainWinFrm.this.strOutputMovFileName = MappingArrayMassShowerMainWinFrm.this.massAnimOutputOptionFrm.getJTextFieldMovFileName().getText();
                        MappingArrayMassShowerMainWinFrm.this.bProcessingAnimOutput = true;
                        long lStarttime = System.currentTimeMillis();
                        boolean showGuideMsgBak = MappingArrayMassShowerMainWinFrm.this.showGuideMsg;
                        int iPercBak = MappingArrayMassShowerMainWinFrm.this.iCurrPercentOnJSliderBar;
                        MappingArrayMassShowerMainWinFrm.this.processFrm.resetJProgressBarFrm(true);
                        restoreUI oldv = new restoreUI(lStarttime, showGuideMsgBak, MappingArrayMassShowerMainWinFrm.this.getJSliderPercent().isEnabled(), iPercBak);
                        MappingArrayMassShowerMainWinFrm.this.getJSliderPercent().setEnabled(false);
                        MassOutputAnimationTask animtask = new MassOutputAnimationTask(parentfrm, showerfrm, MappingArrayMassShowerMainWinFrm.this.processFrm, oldv);
                        animtask.fireTask();
                    }
                }
            });
        }
        return this.jButtonSaveAnimation;
    }

    public MappingArrayMassShowerMainWinFrm(RsltDtTpMdlSelectFrm mdlsltfrm, RsltDtBindingFrm bingfrm, boolean showmsg) {
        if (MappingArrayMassShowerMainWinFrm.havehadAMappingArrayMassShowerMainWinFrmInstanceInCurrentGStructure(true)) {
            return;
        }
        if (mdlsltfrm == null) {
            return;
        }
        if (bingfrm == null) {
            return;
        }
        this.rsltDtTpMdlSelectFrm = mdlsltfrm;
        this.rsltDtBindingFrm = bingfrm;
        this.strDataFromFile = bingfrm.getMassDatas();
        this.strAuxDatas = bingfrm.getAuxDatas();
        this.strOutputGifFileName = "";
        this.strOutputMovFileName = "";
        this.initialize();
        this.initGUI();
        if (!this.setTargetGStructure()) {
            JOptionPane.showMessageDialog((JFrame)MappingArrayMassShowerMainWinFrm.getMappingArrayMassShowerMainWinFrmInstanceInCurrentGStructure(), strSystemErrMessage, "Notice", 0);
            return;
        }
        this.colorMax = colorDefaultMax;
        this.colorMid = colorDefaultMid;
        this.colorMin = colorDefaultMin;
        this.repaintPreviewColor();
        this.setVisible(true);
        Boolean rtn = this.showUsingLoadedData(showmsg);
        if (rtn == null) {
            this.doCancelClose();
        }
    }

    public MappingArrayMassShowerMainWinFrm(Color colorMax, Color colorMid, Color colorMin) {
        this.initialize();
        this.initGUI();
        this.colorMax = colorMax != null ? colorMax : colorDefaultMax;
        this.colorMid = colorMid != null ? colorMid : colorDefaultMid;
        this.colorMin = colorMin != null ? colorMin : colorDefaultMin;
        this.repaintPreviewColor();
    }

    private void initGUI() {
        try {
            this.setDefaultCloseOperation(0);
            this.pack();
            this.setSize((Dimension)dimFrmDefaultInWinOS.clone());
            this.setLocation(300, 400);
            this.setAlwaysOnTop(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void resetDataAndCompentsInThisWinFrm() {
        this.strDataFromFile = null;
        this.jSliderPercent.setEnabled(true);
        this.jSliderPercent.setValue(0);
        this.jSliderPercent.setEnabled(false);
        this.jLabelStartTimeValue.setText("");
        this.jLabelEndTimeValue.setText("");
    }

    private void setLabelOfSliderPercent(JSlider slider, String[][] strInputs, int iDeltaPercent) {
        slider.setVisible(false);
        slider.setPaintLabels(false);
        slider.setLabelTable(null);
        this.jLabel.setText("");
        this.jLabelStartTimeTitle.setVisible(false);
        this.jLabelEndTimeTitle.setVisible(false);
        this.jLabelStartTimeValue.setText("");
        this.jLabelEndTimeValue.setText("");
        if (strInputs == null) {
            return;
        }
        if (strInputs[0].length <= 2) {
            return;
        }
        int iDeltaPercentLocal = 100;
        if (strInputs[0].length > 2) {
            iDeltaPercentLocal = (int)(100.0 / (double)(strInputs[0].length - 2));
        }
        if (iDeltaPercentLocal < iDeltaPercent) {
            iDeltaPercentLocal = iDeltaPercent;
        }
        Hashtable<Integer, JLabel> hstbLables = new Hashtable<Integer, JLabel>();
        int iPercent = 0;
        while (iPercent <= 100 - iDeltaPercentLocal) {
            int iPtr = InformationShowerMappingArrayMass.calcArrayPtrFromPercent(strInputs, iPercent);
            this.makeMemberLabelOfSliderPercent(hstbLables, strInputs[0][iPtr], iPercent);
            iPercent += iDeltaPercentLocal;
        }
        this.makeMemberLabelOfSliderPercent(hstbLables, strInputs[0][strInputs[0].length - 1], 100);
        slider.setLabelTable(hstbLables);
        slider.setVisible(true);
        this.jLabelStartTimeTitle.setVisible(true);
        this.jLabelEndTimeTitle.setVisible(true);
        this.jLabelStartTimeValue.setText(this.makeLabelOfSliderPercent(strInputs[0][1], "", ""));
        int iEndP = strInputs[0].length - 1;
        String strEnd = strInputs[0][iEndP];
        this.jLabelEndTimeValue.setText(this.makeLabelOfSliderPercent(strEnd, "", ""));
    }

    private void makeMemberLabelOfSliderPercent(Hashtable<Integer, JLabel> table, String strLabel, int iPercent) {
        if (strLabel == null) {
            strLabel = "";
        } else if (strLabel.length() > 8) {
            strLabel = strLabel.substring(0, 8);
        }
        int i = 0;
        while (i < strLabel.length()) {
            if (strLabel.charAt(i) > '\u007f') {
                strLabel = "";
                break;
            }
            ++i;
        }
        table.put(new Integer(iPercent), new JLabel(strLabel));
    }

    private String makeLabelOfSliderPercent(String strInputLabel, String strPrefix, String strSuffix) {
        String strLabel = null;
        strLabel = strInputLabel == null ? "" : new String(strInputLabel);
        if (strLabel.length() > 8) {
            strLabel = strLabel.substring(0, 8);
        }
        int i = 0;
        while (i < strLabel.length()) {
            if (strLabel.charAt(i) > '\u007f') {
                strLabel = "";
                break;
            }
            ++i;
        }
        if (!strLabel.equals("")) {
            if (strPrefix != null) {
                strLabel = String.valueOf(strPrefix) + strLabel;
            }
            if (strSuffix != null) {
                strLabel = String.valueOf(strLabel) + strSuffix;
            }
        }
        return strLabel;
    }

    public static final Object getMappingArrayMassShowerMainWinFrmInstanceInCurrentGStructure() {
        try {
            SBModelFrame sbmodelfrm = MainWindow.getLastInstance().getCurrentModel();
            GStructure gstructure = sbmodelfrm.getSBModel().getGStructure();
            if (gstructure.getCurrentInformationShowersControlFrame() != null && gstructure.getCurrentInformationShowersControlFrame() instanceof MappingArrayMassShowerMainWinFrm) {
                return gstructure.getCurrentInformationShowersControlFrame();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static final boolean havehadAMappingArrayMassShowerMainWinFrmInstanceInCurrentGStructure(boolean showmsg) {
        Object rtn = MappingArrayMassShowerMainWinFrm.getMappingArrayMassShowerMainWinFrmInstanceInCurrentGStructure();
        if (rtn != null && rtn instanceof MappingArrayMassShowerMainWinFrm) {
            if (showmsg) {
                JOptionPane.showMessageDialog((JFrame)MappingArrayMassShowerMainWinFrm.getMappingArrayMassShowerMainWinFrmInstanceInCurrentGStructure(), strHavehadThisInstanceInCurrentGStructureErrMessage, "Error", 0);
            }
            return true;
        }
        return false;
    }

    public boolean haveInputedData() {
        return this.strDataFromFile != null;
    }

    public boolean setGraphicDisplayerFromInputData(String[][] strDataFromFile, String[][] strInputAuxDatas, boolean showmsg) {
        this.showGuideMsg = showmsg;
        return this.setGraphicDisplayerFromInputData(strDataFromFile, strInputAuxDatas, 0, this.getMinVauleColor(), this.getMidVauleColor(), this.getMaxVauleColor(), showmsg);
    }

    public boolean setGraphicDisplayerFromInputData(String[][] strDataFromFile, String[][] strInputAuxDatas, int percent, Color colorstart, Color colormid, Color colorend, boolean showmsg) {
        GStructure gstructure;
        SBModelFrame sbmodelfrm;
        block3: {
            try {
                this.showGuideMsg = showmsg;
                sbmodelfrm = MainWindow.getLastInstance().getCurrentModel();
                gstructure = sbmodelfrm.getSBModel().getGStructure();
                if (gstructure == this.gstructureTarget) break block3;
                return false;
            }
            catch (Exception myErr) {
                JOptionPane.showMessageDialog((JFrame)MappingArrayMassShowerMainWinFrm.getMappingArrayMassShowerMainWinFrmInstanceInCurrentGStructure(), "It seems there are some errors in the input file.\nPlease check your file and try once again.", "Data error", 0);
                return false;
            }
        }
        gstructure.removeInformationShower(this.mappingmass);
        this.mappingmass = null;
        int iPtr = InformationShowerMappingArrayMass.calcArrayPtrFromPercent(strDataFromFile, percent);
        this.mappingmass = new InformationShowerMappingArrayMass(sbmodelfrm, this, strDataFromFile, strInputAuxDatas, percent, iPtr, colorstart, colormid, colorend, this.lMin, this.lMax);
        gstructure.addInformationShower(this.mappingmass);
        gstructure.callbyuserRepaint(sbmodelfrm.getLogicalViewArea());
        return true;
    }

    public void repaintPreviewColor() {
        if (this.jPanelPreviewMaxColor != null) {
            this.jPanelPreviewMaxColor.setBackground(this.colorMax);
        }
        if (this.jLabelMaxValue != null) {
            this.jLabelMaxValue.setText(strPrefixMaxValueLableMessage + this.lMax + "] .");
        }
        if (this.jPanelPreviewMinColor != null) {
            this.jPanelPreviewMinColor.setBackground(this.colorMin);
        }
        if (this.jLabelMinValue != null) {
            this.jLabelMinValue.setText(strPrefixMinValueLableMessage + this.lMin + "] .");
        }
        this.repaint();
    }

    public boolean setTargetGStructure() {
        GStructure gstructure;
        block3: {
            try {
                SBModelFrame sbmodelfrm = MainWindow.getLastInstance().getCurrentModel();
                gstructure = sbmodelfrm.getSBModel().getGStructure();
                if (!(gstructure.getCurrentInformationShowersControlFrame() instanceof MappingArrayMassShowerMainWinFrm)) break block3;
                return false;
            }
            catch (Exception myErr) {
                return false;
            }
        }
        this.gstructureTarget = gstructure;
        this.gstructureTarget.setCurrentInformationShowersControlFrame(this);
        return true;
    }

    private void setCurrTimeStringOfSliderToJLabel(String[][] arrInputedData, int iPercent, JLabel label) {
        try {
            int iPtr = InformationShowerMappingArrayMass.calcArrayPtrFromPercent(arrInputedData, iPercent);
            label.setText(this.makeLabelOfSliderPercent(arrInputedData[0][iPtr], strPrefixJTimeLableMessage, strSuffixJTimeLableMessage));
        }
        catch (Exception myErr) {
            label.setText("");
        }
    }

    private void doCancelClose() {
        if (this.bProcessingAnimOutput) {
            return;
        }
        this.setAlwaysOnTop(false);
        this.dispose();
        try {
            SBModelFrame sbmodelfrm = MainWindow.getLastInstance().getCurrentModel();
            GStructure gstructure = sbmodelfrm.getSBModel().getGStructure();
            JFrame shower = gstructure.getCurrentInformationShowersControlFrame();
            if (shower != null && shower == this) {
                gstructure.setCurrentInformationShowersControlFrame(null);
            }
            gstructure.callbyuserRepaint(sbmodelfrm.getLogicalViewArea());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.doCancelClose();
        }
        super.processWindowEvent(e);
    }

    public synchronized void doStateChanged() {
        if (this.bProcessingAnimOutput) {
            return;
        }
        if (this.strDataFromFile == null) {
            return;
        }
        if (!this.isVisible() || !this.isEnabled()) {
            return;
        }
        if (!(this.strDataFromFile[0].length <= 2 || this.jSliderPercent.isVisible() && this.jSliderPercent.isEnabled())) {
            return;
        }
        if (!this.jSliderPercent.getValueIsAdjusting()) {
            this.jSliderPercent.setEnabled(false);
            if (!this.setGraphicDisplayerFromInputData(this.strDataFromFile, this.strAuxDatas, this.iCurrPercentOnJSliderBar, this.getMinVauleColor(), this.getMidVauleColor(), this.getMaxVauleColor(), this.showGuideMsg)) {
                this.resetDataAndCompentsInThisWinFrm();
            } else if (this.strDataFromFile[0].length > 2) {
                this.jSliderPercent.setEnabled(true);
            }
        } else {
            this.iCurrPercentOnJSliderBar = this.jSliderPercent.getValue();
            this.setCurrTimeStringOfSliderToJLabel(this.strDataFromFile, this.iCurrPercentOnJSliderBar, this.jLabel);
        }
    }

    public synchronized void stateChangedToPercent(int percent, boolean showMsg) {
        if (this.strDataFromFile == null) {
            return;
        }
        if (!this.isVisible() || !this.isEnabled()) {
            return;
        }
        if (!(this.strDataFromFile[0].length <= 2 || this.jSliderPercent.isVisible() && this.jSliderPercent.isEnabled())) {
            return;
        }
        this.setGraphicDisplayerFromInputData(this.strDataFromFile, this.strAuxDatas, percent, this.getMinVauleColor(), this.getMidVauleColor(), this.getMaxVauleColor(), showMsg);
    }

    public boolean isOutputGif() {
        return this.bOutputGif;
    }

    public boolean isOutputMovie() {
        return this.bOutputMovie;
    }

    public boolean isScaleOutputGif() {
        return this.bScaleOutputGif;
    }

    public boolean isScaleOutputMovie() {
        return this.bScaleOutputMovie;
    }

    public String getOutputGifFileName() {
        return this.strOutputGifFileName;
    }

    public String getOutputMovFileName() {
        return this.strOutputMovFileName;
    }

    public static final String giveMeOutputFileName(String flname, String extname) {
        String rtn = "";
        if (flname == null || flname.trim().equals("")) {
            return rtn;
        }
        if (extname == null || extname.trim().equals("")) {
            return rtn;
        }
        rtn = !flname.toLowerCase().endsWith("." + extname) ? String.valueOf(flname) + "." + extname : flname;
        return rtn;
    }

    protected boolean generateGif() {
        this.bProcessingAnimOutput = true;
        File fileAnimi = null;
        AnimatedGifEncoder gifEncoder = null;
        SBModelFrame sbmodelfrm = MainWindow.getLastInstance().getCurrentModel();
        double relative = 0.98;
        try {
            try {
                this.processFrm.setHeadMsg("output gif file ...");
                Rectangle2D.Double maxArea = sbmodelfrm.getSBModel().getGStructure().getMaxDrawSize();
                double outputscale = 1.0;
                if (this.bScaleOutputGif && (maxArea.width > (double)MappingArrayMassShowerMainWinFrm.dimGifMaxArea.width || maxArea.height > (double)MappingArrayMassShowerMainWinFrm.dimGifMaxArea.height)) {
                    double dScaleW = (double)MappingArrayMassShowerMainWinFrm.dimGifMaxArea.width / maxArea.width;
                    double dScaleH = (double)MappingArrayMassShowerMainWinFrm.dimGifMaxArea.height / maxArea.height;
                    outputscale = dScaleW > dScaleH ? dScaleH : dScaleW;
                }
                int iPercent = 0;
                int iPtrOld = -1;
                String strModelName = sbmodelfrm.getFilename();
                if (strModelName.endsWith(".xml")) {
                    strModelName = strModelName.substring(0, strModelName.length() - 4);
                }
                Date date = new Date();
                SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
                String strDatetime = df.format(date);
                String strAnimiName = MappingArrayMassShowerMainWinFrm.giveMeOutputFileName(String.valueOf(strModelName) + "Mass" + strDatetime, strGifFileExtName);
                try {
                    if (this.strOutputGifFileName != null && !this.strOutputGifFileName.trim().equals("")) {
                        this.strOutputGifFileName = MappingArrayMassShowerMainWinFrm.giveMeOutputFileName(this.strOutputGifFileName, strGifFileExtName);
                        new File(this.strOutputGifFileName);
                        strAnimiName = this.strOutputGifFileName;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                fileAnimi = new File(strAnimiName);
                gifEncoder = new AnimatedGifEncoder();
                gifEncoder.start(fileAnimi.getAbsolutePath());
                gifEncoder.setDelay(1000);
                while (iPercent <= 100) {
                    if (this.processFrm.isCanceled()) break;
                    int iPtr = InformationShowerMappingArrayMass.calcArrayPtrFromPercent(this.strDataFromFile, iPercent);
                    if (iPtr != iPtrOld) {
                        new InformationShowerMappingArrayMass(sbmodelfrm, this, this.strDataFromFile, this.strAuxDatas, iPercent, iPtr, this.colorMin, this.colorMid, this.colorMax, this.lMin, this.lMax);
                        BufferedImage bufimage = sbmodelfrm.getExportBufferedImage(outputscale);
                        String prefix = "";
                        if (iPercent < 10) {
                            prefix = "  ";
                        } else if (iPercent < 100) {
                            prefix = " ";
                        }
                        String txt = String.valueOf(prefix) + iPercent + "/100";
                        gifEncoder.addFrame(bufimage);
                        this.processFrm.setJProgressBarValueMsg((double)iPercent * 0.98, "prepare frames", true, false);
                    }
                    iPtrOld = iPtr;
                    ++iPercent;
                }
                if (!this.processFrm.isCanceled()) {
                    this.processFrm.setJProgressBarValueMsg(98.0, "write to file", true, true);
                    gifEncoder.finish();
                    this.processFrm.setJProgressBarValueMsg(100.0, "finish", true, true);
                }
            }
            catch (Exception myErr) {
                try {
                    gifEncoder.finish();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (this.processFrm.isCanceled()) {
                        fileAnimi.delete();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.processFrm.setEndedFlg(true);
                this.bProcessingAnimOutput = false;
                return false;
            }
        }
        finally {
            try {
                gifEncoder.finish();
            }
            catch (Exception exception) {}
            try {
                if (this.processFrm.isCanceled()) {
                    fileAnimi.delete();
                }
            }
            catch (Exception exception) {}
            this.processFrm.setEndedFlg(true);
            this.bProcessingAnimOutput = false;
        }
        return true;
    }

    protected boolean generateMovie() {
        this.bProcessingAnimOutput = true;
        String absoluteOutputPath = null;
        SBModelFrame sbmodelfrm = MainWindow.getLastInstance().getCurrentModel();
        double relative1 = 0.7;
        double relative2 = 0.98;
        try {
            try {
                String strModelName;
                this.processFrm.setHeadMsg("output mov file ...");
                Rectangle2D.Double maxArea = sbmodelfrm.getSBModel().getGStructure().getMaxDrawSize();
                double outputscale = 1.0;
                if (this.bScaleOutputMovie && (maxArea.width > (double)MappingArrayMassShowerMainWinFrm.dimMovieMaxArea.width || maxArea.height > (double)MappingArrayMassShowerMainWinFrm.dimMovieMaxArea.height)) {
                    double dScaleW = (double)MappingArrayMassShowerMainWinFrm.dimMovieMaxArea.width / maxArea.width;
                    double dScaleH = (double)MappingArrayMassShowerMainWinFrm.dimMovieMaxArea.height / maxArea.height;
                    outputscale = dScaleW > dScaleH ? dScaleH : dScaleW;
                }
                if ((strModelName = sbmodelfrm.getFilename()).endsWith(".xml")) {
                    strModelName = strModelName.substring(0, strModelName.length() - 4);
                }
                Date date = new Date();
                SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
                String strDatetime = df.format(date);
                String strMovFileName = String.valueOf(strModelName) + "Mass" + strDatetime + ".mov";
                try {
                    if (this.strOutputMovFileName != null && !this.strOutputMovFileName.trim().equals("")) {
                        this.strOutputMovFileName = MappingArrayMassShowerMainWinFrm.giveMeOutputFileName(this.strOutputMovFileName, strMovFileExtName);
                        new File(this.strOutputMovFileName);
                        strMovFileName = this.strOutputMovFileName;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                File fileAnimi = new File(strMovFileName);
                absoluteOutputPath = fileAnimi.getAbsolutePath();
                int iPictureCnt = 1;
                Vector<String> vFileName = new Vector<String>();
                int iPercent = 0;
                int iPtrOld = -1;
                while (iPercent <= 100) {
                    if (this.processFrm.isCanceled()) break;
                    int iPtr = InformationShowerMappingArrayMass.calcArrayPtrFromPercent(this.strDataFromFile, iPercent);
                    if (iPtr != iPtrOld) {
                        new InformationShowerMappingArrayMass(sbmodelfrm, this, this.strDataFromFile, this.strAuxDatas, iPercent, iPtr, this.colorMin, this.colorMid, this.colorMax, this.lMin, this.lMax);
                        String prefix = "";
                        if (iPictureCnt < 10) {
                            prefix = "0000";
                        } else if (iPictureCnt < 100) {
                            prefix = "000";
                        } else if (iPictureCnt < 1000) {
                            prefix = "00";
                        } else if (iPictureCnt < 10000) {
                            prefix = "0";
                        }
                        String strAnimiFileName = String.valueOf(strModelName) + "Mass" + strDatetime + prefix + iPictureCnt;
                        String strAnimiFileFullName = String.valueOf(strAnimiFileName) + "." + strJpgFileExtName;
                        vFileName.add(strAnimiFileFullName);
                        sbmodelfrm.setExportPicImageFileName(".", strAnimiFileName, strJpgFileExtName);
                        sbmodelfrm.exportImage(true, outputscale);
                        ++iPictureCnt;
                        this.processFrm.setJProgressBarValueMsg((double)iPercent * 0.7, "prepare frames, write to temp files", true, false);
                    }
                    iPtrOld = iPtr;
                    ++iPercent;
                }
                try {
                    if (!this.processFrm.isCanceled()) {
                        this.processFrm.setJProgressBarValueMsg(70.0, "generate movie using temp files", true, false);
                        int w = (int)Math.ceil(maxArea.width * outputscale);
                        int h = (int)Math.ceil(maxArea.height * outputscale);
                        String strUrl = absoluteOutputPath;
                        if (!absoluteOutputPath.startsWith("file:")) {
                            strUrl = "file:" + absoluteOutputPath;
                        }
                        JpegImagesToMovie.generateJpegImagesToMovie(w, h, 1, vFileName, strUrl);
                    }
                }
                catch (Exception w) {
                    // empty catch block
                }
                this.processFrm.setJProgressBarValueMsg(98.0, "delete temp files", true, true);
                int i = 0;
                while (i < vFileName.size()) {
                    try {
                        File file = new File((String)vFileName.get(i));
                        file.delete();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i;
                }
                this.processFrm.setJProgressBarValueMsg(100.0, "finish", true, true);
            }
            catch (Exception myErr) {
                try {
                    if (this.processFrm.isCanceled()) {
                        new File(absoluteOutputPath).delete();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.processFrm.setEndedFlg(true);
                this.bProcessingAnimOutput = false;
                return false;
            }
        }
        catch (Throwable throwable) {
            try {
                if (this.processFrm.isCanceled()) {
                    new File(absoluteOutputPath).delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.processFrm.setEndedFlg(true);
            this.bProcessingAnimOutput = false;
            throw throwable;
        }
        try {
            if (this.processFrm.isCanceled()) {
                new File(absoluteOutputPath).delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.processFrm.setEndedFlg(true);
        this.bProcessingAnimOutput = false;
        return true;
    }

    public void restoreUIafterAnimOut(restoreUI oldvalue) {
        if (oldvalue == null) {
            return;
        }
        this.iCurrPercentOnJSliderBar = oldvalue.iPercBak;
        this.getJSliderPercent().setValue(this.iCurrPercentOnJSliderBar);
        this.getJSliderPercent().setEnabled(oldvalue.sldbarEnable);
        this.repaint();
        this.stateChangedToPercent(this.iCurrPercentOnJSliderBar, false);
        this.showGuideMsg = oldvalue.shwGuideMsg;
    }

    public void setFirstRun(boolean firstRun) {
        this.firstRun = firstRun;
    }

    private Boolean showUsingLoadedData(boolean showmsg) {
        if (this.bProcessingAnimOutput) {
            return false;
        }
        boolean hadErr = true;
        try {
            try {
                this.setAlwaysOnTop(false);
                MainWindow mwin = null;
                SBModel sbmdl = null;
                if (this.strDataFromFile != null) {
                    try {
                        mwin = MainWindow.getLastInstance();
                        sbmdl = mwin.getCurrentModel().getSBModel();
                        ReturnValue rt = sbmdl.createMassPluginCompartmentSpecies(this.strDataFromFile, this.rsltDtBindingFrm);
                        if (rt.bError) {
                            throw new Exception();
                        }
                    }
                    catch (Exception myErr) {
                        this.strDataFromFile = null;
                    }
                }
                if (this.strDataFromFile == null) {
                    this.jSliderPercent.setEnabled(false);
                } else {
                    this.jSliderPercent.setEnabled(true);
                }
                this.jSliderPercent.setValue(0);
                if (!this.setGraphicDisplayerFromInputData(this.strDataFromFile, this.strAuxDatas, showmsg)) {
                    this.resetDataAndCompentsInThisWinFrm();
                }
                this.setLabelOfSliderPercent(this.jSliderPercent, this.strDataFromFile, 10);
                this.setCurrTimeStringOfSliderToJLabel(this.strDataFromFile, 0, this.jLabel);
                hadErr = false;
            }
            catch (Exception myErr) {
                if (!this.firstRun || !hadErr) {
                    this.setAlwaysOnTop(true);
                }
                return null;
            }
        }
        finally {
            if (!this.firstRun || !hadErr) {
                this.setAlwaysOnTop(true);
            }
        }
        return true;
    }

    public RsltDtBindingFrm getRsltDtBindingFrm() {
        return this.rsltDtBindingFrm;
    }

    class restoreUI {
        public long lStarttime = -1L;
        public boolean shwGuideMsg = true;
        public boolean sldbarEnable = true;
        public int iPercBak = 0;

        restoreUI(long strtime, boolean shwGdMsg, boolean sldbEnbl, int iPerBk) {
            this.lStarttime = strtime;
            this.shwGuideMsg = shwGdMsg;
            this.sldbarEnable = sldbEnbl;
            this.iPercBak = iPerBk;
        }
    }
}

