/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.plugin.InfoCenter.InfoShower;

import java.awt.Color;
import java.util.Vector;
import javax.swing.JFrame;
import jp.fric.graphics.draw.GStructure;
import jp.sbi.celldesigner.SBModelFrame;
import jp.sbi.celldesigner.plugin.InfoCenter.InfoDisplayer.InformationDisplayerAbst;
import jp.sbi.celldesigner.plugin.InfoCenter.InfoShower.InformationShowerImpl;

public class InformationShowerMappingArrayMass
implements InformationShowerImpl {
    private static final int iDefaultInitPercent = 0;
    private static final int iMaxPercent = 100;
    private static final int iMinPercent = 0;
    private static final int iDefaultInitPtr = 1;
    public static final Color colorSystemDefaultStart = Color.GREEN;
    public static final Color colorSystemDefaultMid = Color.YELLOW;
    public static final Color colorSystemDefaultEnd = Color.RED;
    private Color colorUserDefaultStart = colorSystemDefaultStart;
    private Color colorUserDefaultMid = colorSystemDefaultMid;
    private Color colorUserDefaultEnd = colorSystemDefaultEnd;
    public static final int iMappingArrayMassRect3DDisplayerWidth = 10;
    public static final int iMappingArrayMassRect3DDisplayerHeight = 16;
    public static final int iMappingArrayMassMarginBetweenRect3DAndMsg = 3;
    private String strMyID = null;
    private static final String myName = "Mapping Array Mass";
    private JFrame frmShowerUIController = null;
    private Vector listOfDisplayers = null;
    private SBModelFrame sbmodelframe = null;
    private String[][] strDataFromFile = null;
    private String[][] strAuxDatas = null;

    public Color getUserDefaultStartColor() {
        return this.colorUserDefaultStart;
    }

    public void setUserDefaultStartColor(Color clor) {
        this.colorUserDefaultStart = clor;
    }

    public Color getUserDefaultMidColor() {
        return this.colorUserDefaultMid;
    }

    public void setUserDefaultMidColor(Color clor) {
        this.colorUserDefaultMid = clor;
    }

    public Color getUserDefaultEndColor() {
        return this.colorUserDefaultEnd;
    }

    public void setUserDefaultEndColor(Color clor) {
        this.colorUserDefaultEnd = clor;
    }

    public InformationShowerMappingArrayMass(SBModelFrame sbmfrm) {
        this.sbmodelframe = sbmfrm;
        this.giveMeNewID();
    }

    public InformationShowerMappingArrayMass(SBModelFrame sbmfrm, JFrame jfrmShowerUIController) {
        this.sbmodelframe = sbmfrm;
        this.frmShowerUIController = jfrmShowerUIController;
        this.giveMeNewID();
    }

    public InformationShowerMappingArrayMass(SBModelFrame sbmfrm, JFrame jfrmShowerUIController, String[][] strInputDataFromFile, String[][] strInputAuxDatas, double minControlValue, double maxControlValue) {
        this.sbmodelframe = sbmfrm;
        this.frmShowerUIController = jfrmShowerUIController;
        this.strDataFromFile = strInputDataFromFile;
        this.strAuxDatas = strInputAuxDatas;
        this.giveMeNewID();
        this.recreateMappingArrayMassDisplayers(strInputDataFromFile, strInputAuxDatas, 0, 1, this.colorUserDefaultStart, this.colorUserDefaultMid, this.colorUserDefaultEnd, minControlValue, maxControlValue);
    }

    public InformationShowerMappingArrayMass(SBModelFrame sbmfrm, JFrame jfrmShowerUIController, String[][] strInputDataFromFile, String[][] strInputAuxDatas, int percent, double minControlValue, double maxControlValue) {
        this.sbmodelframe = sbmfrm;
        this.frmShowerUIController = jfrmShowerUIController;
        this.strDataFromFile = strInputDataFromFile;
        this.strAuxDatas = strInputAuxDatas;
        this.giveMeNewID();
        this.recreateMappingArrayMassDisplayers(strInputDataFromFile, strInputAuxDatas, percent, 1, this.colorUserDefaultStart, this.colorUserDefaultMid, this.colorUserDefaultEnd, minControlValue, maxControlValue);
    }

    public InformationShowerMappingArrayMass(SBModelFrame sbmfrm, JFrame jfrmShowerUIController, String[][] strInputDataFromFile, String[][] strInputAuxDatas, int percent, int iPtr, double minControlValue, double maxControlValue) {
        this.sbmodelframe = sbmfrm;
        this.frmShowerUIController = jfrmShowerUIController;
        this.strDataFromFile = strInputDataFromFile;
        this.strAuxDatas = strInputAuxDatas;
        this.giveMeNewID();
        this.recreateMappingArrayMassDisplayers(strInputDataFromFile, strInputAuxDatas, percent, iPtr, this.colorUserDefaultStart, this.colorUserDefaultMid, this.colorUserDefaultEnd, minControlValue, maxControlValue);
    }

    public InformationShowerMappingArrayMass(SBModelFrame sbmfrm, JFrame jfrmShowerUIController, String[][] strInputDataFromFile, String[][] strInputAuxDatas, int percent, int iPtr, Color colorstart, Color colormid, Color colorend, double minControlValue, double maxControlValue) {
        this.sbmodelframe = sbmfrm;
        this.frmShowerUIController = jfrmShowerUIController;
        this.strDataFromFile = strInputDataFromFile;
        this.strAuxDatas = strInputAuxDatas;
        this.giveMeNewID();
        this.recreateMappingArrayMassDisplayers(strInputDataFromFile, strInputAuxDatas, percent, iPtr, colorstart, colormid, colorend, minControlValue, maxControlValue);
    }

    @Override
    public String getInformationShowerReadOnlyPK() {
        return this.strMyID;
    }

    @Override
    public String getInformationShowerName() {
        return myName;
    }

    @Override
    public boolean isVisible(SBModelFrame sbf, GStructure gstructure) {
        if (sbf == null && gstructure == null) {
            return false;
        }
        if (this.frmShowerUIController == null) {
            return false;
        }
        if (!this.frmShowerUIController.isVisible() || !this.frmShowerUIController.isEnabled()) {
            return false;
        }
        if (this.strMyID == null) {
            return false;
        }
        if (this.strMyID.trim().equals("")) {
            return false;
        }
        if (this.sbmodelframe == null) {
            return false;
        }
        if (this.sbmodelframe.getSBModel() == null) {
            return false;
        }
        if (this.sbmodelframe.getSBModel().getGStructure() == null) {
            return false;
        }
        if (sbf != null && this.sbmodelframe != sbf) {
            return false;
        }
        if (gstructure != null && this.sbmodelframe.getSBModel().getGStructure() != gstructure) {
            return false;
        }
        if (this.strDataFromFile == null) {
            return false;
        }
        return this.strAuxDatas != null;
    }

    public void dropDisplayers() {
        this.listOfDisplayers = null;
    }

    public void renewDisplayersArray() {
        this.listOfDisplayers = new Vector();
    }

    public void addMember(InformationDisplayerAbst member) {
        if (member == null) {
            return;
        }
        if (this.listOfDisplayers == null) {
            this.listOfDisplayers = new Vector();
        }
        this.listOfDisplayers.add(member);
    }

    @Override
    public Vector getListOfDisplayers() {
        return this.listOfDisplayers;
    }

    public void setSBModelFrameController(SBModelFrame sbf) {
        this.sbmodelframe = sbf;
    }

    public void setFrmController(JFrame jfrm) {
        this.frmShowerUIController = jfrm;
    }

    public JFrame getFrmController() {
        return this.frmShowerUIController;
    }

    protected void giveMeNewID() {
        String strTime;
        if (this.sbmodelframe == null) {
            return;
        }
        if (this.sbmodelframe.getSBModel() == null) {
            return;
        }
        if (this.sbmodelframe.getSBModel().getGStructure() == null) {
            return;
        }
        do {
            long time = System.currentTimeMillis();
            strTime = "" + time;
        } while (this.sbmodelframe.getSBModel().getGStructure().havehadInformationShowerID(strTime));
        this.strMyID = strTime;
    }

    public void recreateMappingArrayMassDisplayers(String[][] strInputDataFromFile, String[][] strInputAuxDatas, int percent, int iPtr, Color colorstart, Color colormid, Color colorend, double minControlValue, double maxControlValue) {
        this.listOfDisplayers = null;
        if (this.sbmodelframe == null) {
            return;
        }
        if (this.sbmodelframe.getSBModel() == null) {
            return;
        }
        if (this.sbmodelframe.getSBModel().getGStructure() == null) {
            return;
        }
        Color colorStart = this.colorUserDefaultStart;
        if (colorstart != null) {
            colorStart = colorstart;
        }
        Color colorMid = this.colorUserDefaultMid;
        if (colormid != null) {
            colorMid = colormid;
        }
        Color colorEnd = this.colorUserDefaultEnd;
        if (colorend != null) {
            colorEnd = colorend;
        }
        this.listOfDisplayers = this.sbmodelframe.getSBModel().getGStructure().recreateMappingArrayMassDisplayers(strInputDataFromFile, strInputAuxDatas, percent, iPtr, colorStart, colorMid, colorEnd, minControlValue, maxControlValue);
    }

    public static final int calcArrayPtrFromPercent(String[][] strInputDataFromFile, int percent) {
        if (strInputDataFromFile == null) {
            return -1;
        }
        if (strInputDataFromFile.length == 1) {
            return -1;
        }
        if (strInputDataFromFile[1].length == 1) {
            return -1;
        }
        if (strInputDataFromFile[1].length == 2) {
            return 1;
        }
        if (percent < 0 || percent > 100) {
            return -1;
        }
        int iDataTotalCols = strInputDataFromFile[1].length - 1;
        int iDataTotalSpans = iDataTotalCols - 1;
        int iPrt01 = (int)((double)iDataTotalSpans * ((double)percent / 100.0));
        int iPrt02 = iPrt01 + 1;
        double dPercent01 = (double)iPrt01 / (double)iDataTotalSpans * 100.0;
        double dPercent02 = (double)iPrt02 / (double)iDataTotalSpans * 100.0;
        double dDlta01 = (double)percent - dPercent01;
        double dDlta02 = (double)percent - dPercent02;
        int iPrt = iPrt01;
        if (dPercent02 <= 100.0 && Math.abs(dDlta02) < Math.abs(dDlta01)) {
            iPrt = iPrt02;
        }
        if (++iPrt < 1) {
            iPrt = 1;
        } else if (iPrt > iDataTotalCols) {
            iPrt = iDataTotalCols;
        }
        return iPrt;
    }
}

