/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.plugin;

import java.util.Vector;
import jp.fric.graphics.draw.GElement;
import jp.sbi.celldesigner.CompartmentAlias;
import jp.sbi.celldesigner.CompartmentAliasPopupMenu;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.ReactionLink;
import jp.sbi.celldesigner.ReactionLinkPopupMenu;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.SBModelFrame;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.SpeciesAliasPopupMenu;
import jp.sbi.celldesigner.plugin.CellDesignerPlug;
import jp.sbi.celldesigner.plugin.PluginCompartment;
import jp.sbi.celldesigner.plugin.PluginListOf;
import jp.sbi.celldesigner.plugin.PluginMenu;
import jp.sbi.celldesigner.plugin.PluginModel;
import jp.sbi.celldesigner.plugin.PluginReaction;
import jp.sbi.celldesigner.plugin.PluginSBase;
import jp.sbi.celldesigner.plugin.PluginSBaseConverter;
import jp.sbi.celldesigner.plugin.PluginSpecies;
import jp.sbi.celldesigner.plugin.PluginSpeciesAlias;
import jp.sbi.celldesigner.sbmlExtension.CompartmentAnnotation;
import jp.sbi.celldesigner.sbmlExtension.ReactionAnnotation;
import jp.sbi.celldesigner.sbmlExtension.SpeciesAnnotation;
import jp.sbi.sbml.util.LibSBMLUtil;
import org.sbml.libsbml.Compartment;
import org.sbml.libsbml.Model;
import org.sbml.libsbml.Reaction;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Species;

public abstract class CellDesignerPlugin
implements CellDesignerPlug {
    PluginModel modelAim = null;
    private boolean isStarted;

    public void addCellDesignerPluginMenu(PluginMenu menu) {
        MainWindow.getLastInstance().getJMenuBar().getMenu(MainWindow.getLastInstance().getJMenuBar().getMenuCount() - 5).add(menu.getJMenu());
    }

    public void addSpeciesPopupMenu(PluginMenu menu) {
        SpeciesAliasPopupMenu.getInstance().add(menu.getJMenu());
    }

    public void addSpeciesPopupMenuSeparator() {
        SpeciesAliasPopupMenu.getInstance().addSeparator();
    }

    public void addReactionPopupMenu(PluginMenu menu) {
        ReactionLinkPopupMenu.getInstance().add(menu.getJMenu());
    }

    public void addReactionPopupMenuSeparator() {
        ReactionLinkPopupMenu.getInstance().addSeparator();
    }

    public void addCompartmentPopupMenu(PluginMenu menu) {
        CompartmentAliasPopupMenu.getInstance().add(menu.getJMenu());
    }

    public void addCompartmentPopupMenuSeparator() {
        CompartmentAliasPopupMenu.getInstance().addSeparator();
    }

    public PluginModel getSelectedModel() {
        try {
            PluginModel newModel;
            this.modelAim = null;
            Model model = MainWindow.getLastInstance().getCurrentModel().getSBModel().getModel();
            this.modelAim = newModel = PluginSBaseConverter.convertToPluginModel(model);
            return newModel;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public PluginModel getModel(String id) {
        Vector listOfModels = MainWindow.getLastInstance().getModels();
        int i = 0;
        while (i < listOfModels.size()) {
            SBModelFrame sbmodelframe = (SBModelFrame)listOfModels.get(i);
            Model model = sbmodelframe.getSBModel().getModel();
            if (model.getId().equals(id)) {
                PluginModel newModel = PluginSBaseConverter.convertToPluginModel(model, sbmodelframe.getSBModel());
                return newModel;
            }
            ++i;
        }
        return null;
    }

    @Deprecated
    public PluginListOf getAllModels() {
        PluginListOf listOfNewModels = new PluginListOf();
        Vector listOfModels = MainWindow.getLastInstance().getModels();
        int i = 0;
        while (i < listOfModels.size()) {
            SBModelFrame sbmodelframe = (SBModelFrame)listOfModels.get(i);
            Model model = sbmodelframe.getSBModel().getModel();
            PluginModel newModel = PluginSBaseConverter.convertToPluginModel(model, sbmodelframe.getSBModel());
            listOfNewModels.append(newModel);
            ++i;
        }
        return listOfNewModels;
    }

    public PluginListOf getSelectedSpeciesNode() {
        PluginListOf listOfSBase = new PluginListOf();
        SBModel sbmodel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
        Vector listOfSelected = sbmodel.getGStructure().getSelecteds();
        int j = 0;
        while (j < listOfSelected.size()) {
            GElement element = (GElement)listOfSelected.get(j);
            if (element instanceof SpeciesAlias) {
                SpeciesAlias alias = (SpeciesAlias)element;
                SpeciesAnnotation annotation = (SpeciesAnnotation)LibSBMLUtil.getAnnotation(sbmodel, (SBase)alias.getOriginalSpecies(), null);
                Vector listOfReferingAliases = annotation.getReferingAliases();
                int k = 0;
                while (k < listOfReferingAliases.size()) {
                    SpeciesAlias ref = (SpeciesAlias)listOfReferingAliases.get(k);
                    if (ref == alias) {
                        PluginSpecies parent = PluginSBaseConverter.convertToPluginSpecies(alias.getOriginalSpecies(), annotation);
                        PluginSpeciesAlias palias = new PluginSpeciesAlias(alias, parent);
                        listOfSBase.append(palias);
                    }
                    ++k;
                }
            }
            ++j;
        }
        return listOfSBase;
    }

    public PluginListOf getSelectedSpeciesNode(PluginModel pluginModel) {
        PluginListOf listOfSBase = new PluginListOf();
        SBModel sbmodel = MainWindow.getLastInstance().getModel(pluginModel.getId());
        Vector listOfSelected = sbmodel.getGStructure().getSelecteds();
        int j = 0;
        while (j < listOfSelected.size()) {
            GElement element = (GElement)listOfSelected.get(j);
            if (element instanceof SpeciesAlias) {
                SpeciesAlias alias = (SpeciesAlias)element;
                SpeciesAnnotation annotation = (SpeciesAnnotation)LibSBMLUtil.getAnnotation(sbmodel, (SBase)alias.getOriginalSpecies(), null);
                Vector listOfReferingAliases = annotation.getReferingAliases();
                int k = 0;
                while (k < listOfReferingAliases.size()) {
                    SpeciesAlias ref = (SpeciesAlias)listOfReferingAliases.get(k);
                    if (ref == alias) {
                        PluginSpeciesAlias palias = pluginModel.getPluginSpeciesAlias(ref.getName());
                        listOfSBase.append(palias);
                    }
                    ++k;
                }
            }
            ++j;
        }
        return listOfSBase;
    }

    public PluginListOf getAllSpeciesNodes() {
        SBModel sbmodel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
        Model model = sbmodel.getModel();
        PluginListOf listOfSpecies = new PluginListOf();
        int i = 0;
        while ((long)i < model.getNumSpecies()) {
            Species sp = model.getSpecies((long)i);
            SpeciesAnnotation annotation = (SpeciesAnnotation)LibSBMLUtil.getAnnotation(sbmodel, (SBase)sp, null);
            Vector listOfReferingAliases = annotation.getReferingAliases();
            int k = 0;
            while (k < listOfReferingAliases.size()) {
                PluginSpecies parent = PluginSBaseConverter.convertToPluginSpecies(sp, annotation);
                SpeciesAlias ref = (SpeciesAlias)listOfReferingAliases.get(k);
                PluginSpeciesAlias palias = new PluginSpeciesAlias(ref, parent);
                listOfSpecies.append(palias);
                ++k;
            }
            ++i;
        }
        return listOfSpecies;
    }

    public PluginListOf getSelectedReactionNode() {
        PluginListOf listOfSBase = new PluginListOf();
        SBModel sbmodel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
        Vector listOfSelected = sbmodel.getGStructure().getSelecteds();
        int j = 0;
        while (j < listOfSelected.size()) {
            GElement element = (GElement)listOfSelected.get(j);
            PluginReaction sbase = null;
            if (element instanceof ReactionLink) {
                ReactionLink alias = (ReactionLink)element;
                Reaction reaction = alias.getParentReaction();
                sbase = PluginSBaseConverter.convertToPluginReaction(reaction, (ReactionAnnotation)LibSBMLUtil.getAnnotation(sbmodel, (SBase)reaction, null));
                listOfSBase.append(sbase);
            }
            ++j;
        }
        return listOfSBase;
    }

    public PluginListOf getSelectedReactionNode(PluginModel pluginModel) {
        PluginListOf listOfSBase = new PluginListOf();
        SBModel sbmodel = MainWindow.getLastInstance().getModel(pluginModel.getId());
        Vector listOfSelected = sbmodel.getGStructure().getSelecteds();
        int j = 0;
        while (j < listOfSelected.size()) {
            GElement element = (GElement)listOfSelected.get(j);
            PluginReaction sbase = null;
            if (element instanceof ReactionLink) {
                ReactionLink alias = (ReactionLink)element;
                Reaction reaction = alias.getParentReaction();
                sbase = pluginModel.getReaction(reaction.getId());
                listOfSBase.append(sbase);
            }
            ++j;
        }
        return listOfSBase;
    }

    public PluginListOf getSelectedCompartmentNode() {
        PluginListOf listOfSBase = new PluginListOf();
        SBModel sbmodel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
        Vector listOfSelected = sbmodel.getGStructure().getSelecteds();
        int j = 0;
        while (j < listOfSelected.size()) {
            GElement element = (GElement)listOfSelected.get(j);
            PluginCompartment sbase = null;
            if (element instanceof CompartmentAlias) {
                CompartmentAlias alias = (CompartmentAlias)((Object)element);
                Compartment compartment = alias.getOriginalCompartment();
                sbase = PluginSBaseConverter.convertToPluginCompartment(compartment, (CompartmentAnnotation)LibSBMLUtil.getAnnotation(sbmodel, (SBase)compartment, null));
                listOfSBase.append(sbase);
            }
            ++j;
        }
        return listOfSBase;
    }

    public PluginListOf getSelectedCompartmentNode(PluginModel pluginModel) {
        PluginListOf listOfSBase = new PluginListOf();
        SBModel sbmodel = MainWindow.getLastInstance().getModel(pluginModel.getId());
        Vector listOfSelected = sbmodel.getGStructure().getSelecteds();
        int j = 0;
        while (j < listOfSelected.size()) {
            GElement element = (GElement)listOfSelected.get(j);
            PluginCompartment sbase = null;
            if (element instanceof CompartmentAlias) {
                CompartmentAlias alias = (CompartmentAlias)((Object)element);
                Compartment compartment = alias.getOriginalCompartment();
                sbase = pluginModel.getCompartment(compartment.getId());
                listOfSBase.append(sbase);
            }
            ++j;
        }
        return listOfSBase;
    }

    public PluginListOf getSelectedAllNode() {
        PluginListOf listOfSBase = new PluginListOf();
        SBModel sbmodel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
        Vector listOfSelected = sbmodel.getGStructure().getSelecteds();
        int j = 0;
        while (j < listOfSelected.size()) {
            Object alias;
            GElement element = (GElement)listOfSelected.get(j);
            PluginSBase sbase = null;
            if (element instanceof SpeciesAlias) {
                alias = (SpeciesAlias)element;
                SpeciesAnnotation annotation = (SpeciesAnnotation)LibSBMLUtil.getAnnotation(sbmodel, (SBase)alias.getOriginalSpecies(), null);
                Vector listOfReferingAliases = annotation.getReferingAliases();
                int k = 0;
                while (k < listOfReferingAliases.size()) {
                    SpeciesAlias ref = (SpeciesAlias)listOfReferingAliases.get(k);
                    if (ref == alias) {
                        PluginSpecies parent = PluginSBaseConverter.convertToPluginSpecies(alias.getOriginalSpecies(), annotation);
                        PluginSpeciesAlias palias = new PluginSpeciesAlias(ref, parent);
                        listOfSBase.append(palias);
                    }
                    ++k;
                }
            } else if (element instanceof CompartmentAlias) {
                alias = (CompartmentAlias)((Object)element);
                Compartment compartment = alias.getOriginalCompartment();
                sbase = PluginSBaseConverter.convertToPluginCompartment(compartment, (CompartmentAnnotation)LibSBMLUtil.getAnnotation(sbmodel, (SBase)compartment, null));
            } else if (element instanceof ReactionLink) {
                alias = (ReactionLink)element;
                Reaction reaction = ((ReactionLink)alias).getParentReaction();
                sbase = PluginSBaseConverter.convertToPluginReaction(reaction, (ReactionAnnotation)LibSBMLUtil.getAnnotation(sbmodel, (SBase)reaction, null));
            }
            if (sbase != null) {
                listOfSBase.append(sbase);
            }
            ++j;
        }
        return listOfSBase;
    }

    public PluginListOf getSelectedAllNode(PluginModel pluginModel) {
        PluginListOf listOfSBase = new PluginListOf();
        SBModel sbmodel = MainWindow.getLastInstance().getModel(pluginModel.getId());
        Vector listOfSelected = sbmodel.getGStructure().getSelecteds();
        int j = 0;
        while (j < listOfSelected.size()) {
            Object alias;
            GElement element = (GElement)listOfSelected.get(j);
            PluginSBase sbase = null;
            if (element instanceof SpeciesAlias) {
                alias = (SpeciesAlias)element;
                SpeciesAnnotation annotation = (SpeciesAnnotation)LibSBMLUtil.getAnnotation(sbmodel, (SBase)alias.getOriginalSpecies(), null);
                Vector listOfReferingAliases = annotation.getReferingAliases();
                int k = 0;
                while (k < listOfReferingAliases.size()) {
                    SpeciesAlias ref = (SpeciesAlias)listOfReferingAliases.get(k);
                    if (ref == alias) {
                        sbase = pluginModel.getPluginSpeciesAlias(ref.getName());
                        listOfSBase.append(sbase);
                    }
                    ++k;
                }
            } else if (element instanceof CompartmentAlias) {
                alias = (CompartmentAlias)((Object)element);
                Compartment compartment = alias.getOriginalCompartment();
                sbase = pluginModel.getCompartment(compartment.getId());
            } else if (element instanceof ReactionLink) {
                alias = (ReactionLink)element;
                Reaction reaction = ((ReactionLink)alias).getParentReaction();
                sbase = pluginModel.getReaction(reaction.getId());
            }
            if (sbase != null) {
                listOfSBase.append(sbase);
            }
            ++j;
        }
        return listOfSBase;
    }

    protected String createNewSpeciesId() {
        if (MainWindow.getLastInstance().getCurrentModel() == null) {
            return null;
        }
        SBModel model = MainWindow.getLastInstance().getCurrentModel().getSBModel();
        return model.createNewSpeciesId();
    }

    protected String createNewCompartmentId() {
        SBModel model = MainWindow.getLastInstance().getCurrentModel().getSBModel();
        return model.createNewCompartmentId();
    }

    protected String createNewReactionId() {
        SBModel model = MainWindow.getLastInstance().getCurrentModel().getSBModel();
        return model.createNewReactionId();
    }

    protected String createNewAliasId() {
        SBModel model = MainWindow.getLastInstance().getCurrentModel().getSBModel();
        return model.createNewAliasId();
    }

    @Override
    public void SBaseAdded(SBase sbase) {
        PluginSBase pSbase = PluginSBaseConverter.convertToPluginSBase(sbase);
        this.SBaseAdded(pSbase);
    }

    @Override
    public void SBaseAdded(SpeciesAlias sbase, Species parent) {
        PluginSpecies psp = (PluginSpecies)PluginSBaseConverter.convertToPluginSBase((SBase)parent);
        PluginSpeciesAlias pSbase = PluginSBaseConverter.convertToPluginSpeciesAlias(sbase, psp);
        this.SBaseAdded(pSbase);
    }

    @Override
    public void SBaseChanged(SBase sbase) {
        PluginSBase pSbase = PluginSBaseConverter.convertToPluginSBase(sbase);
        this.SBaseChanged(pSbase);
    }

    @Override
    public void SBaseChanged(SpeciesAlias sbase, Species parent) {
        PluginSpecies psp = (PluginSpecies)PluginSBaseConverter.convertToPluginSBase((SBase)parent);
        PluginSpeciesAlias pSbase = PluginSBaseConverter.convertToPluginSpeciesAlias(sbase, psp);
        this.SBaseChanged(pSbase);
    }

    @Override
    public void SBaseDeleted(SBase sbase) {
        PluginSBase pSbase = PluginSBaseConverter.convertToPluginSBase(sbase);
        this.SBaseDeleted(pSbase);
    }

    @Override
    public void SBaseDeleted(SpeciesAlias sbase, Species parent) {
        PluginSpecies psp = (PluginSpecies)PluginSBaseConverter.convertToPluginSBase((SBase)parent);
        PluginSpeciesAlias pSbase = PluginSBaseConverter.convertToPluginSpeciesAlias(sbase, psp);
        this.SBaseDeleted(pSbase);
    }

    @Override
    public void modelOpened(SBase sbase) {
        PluginSBase pSbase = PluginSBaseConverter.convertToPluginSBase(sbase);
        this.modelOpened(pSbase);
    }

    @Override
    public void modelSelectChanged(SBase sbase) {
        PluginSBase pSbase = PluginSBaseConverter.convertToPluginSBase(sbase);
        this.modelSelectChanged(pSbase);
    }

    @Override
    public void modelClosed(SBase sbase) {
        PluginSBase pSbase = PluginSBaseConverter.convertToPluginSBase(sbase);
        this.modelClosed(pSbase);
    }

    @Override
    public boolean notifySBaseAdded(PluginSBase sbase) {
        MainWindow.currentPluginInstance = this;
        boolean isSuccessed = false;
        try {
            isSuccessed = MainWindow.getLastInstance().getCurrentModel().getSBModel().notifySBaseAdded(sbase);
        }
        catch (Exception exception) {
            // empty catch block
        }
        MainWindow.currentPluginInstance = null;
        return isSuccessed;
    }

    @Override
    public boolean notifySBaseChanged(PluginSBase sbase) {
        MainWindow.currentPluginInstance = this;
        boolean isSuccessed = false;
        try {
            isSuccessed = MainWindow.getLastInstance().getCurrentModel().getSBModel().notifySBaseChanged(sbase);
        }
        catch (Exception exception) {
            // empty catch block
        }
        MainWindow.currentPluginInstance = null;
        return isSuccessed;
    }

    @Override
    public boolean notifySBaseDeleted(PluginSBase sbase) {
        MainWindow.currentPluginInstance = this;
        boolean isSuccessed = false;
        try {
            isSuccessed = MainWindow.getLastInstance().getCurrentModel().getSBModel().notifySBaseDeleted(sbase);
        }
        catch (Exception exception) {
            // empty catch block
        }
        MainWindow.currentPluginInstance = null;
        return isSuccessed;
    }

    @Override
    public boolean isStarted() {
        return this.isStarted;
    }

    public void setStarted(boolean isStarted) {
        this.isStarted = isStarted;
    }

    public boolean exportDrawAreaToImageFile(String strOutputFileDirName, String strOutputFileName, String strOutputFileExtention) {
        try {
            MainWindow.getLastInstance().getCurrentModel().getSBModel().exportDrawAreaToImageFile(strOutputFileDirName, strOutputFileName, strOutputFileExtention);
        }
        catch (Exception myErr) {
            return false;
        }
        return true;
    }

    public boolean doCircularLayout() {
        return this.doAutoLayout("Circular");
    }

    private boolean doAutoLayout(String type) {
        block7: {
            SBModelFrame sbmdl;
            block6: {
                block5: {
                    sbmdl = null;
                    try {
                        if (type != null) break block5;
                        return false;
                    }
                    catch (Exception myErr) {
                        return false;
                    }
                }
                sbmdl = MainWindow.getLastInstance().getCurrentModel();
                if (sbmdl != null) break block6;
                return false;
            }
            if (type.equals("Circular")) {
                sbmdl.doCircularLayout();
                break block7;
            }
            return false;
        }
        return true;
    }

    public boolean cloneCurrModel() {
        MainWindow mwin = MainWindow.getLastInstance();
        if (mwin == null) {
            return false;
        }
        SBModelFrame sbmdl = mwin.getCurrentModel();
        if (sbmdl == null) {
            return false;
        }
        try {
            mwin.cloneCurrentSBModeFile(sbmdl, true);
        }
        catch (Exception myErr) {
            return false;
        }
        return true;
    }

    @Override
    public boolean SBaseSelected() {
        return true;
    }
}

