/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.miriam;

import java.util.Vector;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.SBMLFiler;
import jp.sbi.celldesigner.miriam.MIRIAM;
import jp.sbi.celldesigner.miriam.MiriamUri;
import org.sbml.libsbml.Model;
import org.sbml.libsbml.SBase;

public class MiriamUtils {
    public static final int iDonotHaveThisName = -1;

    public static final Vector<String> getNamesOfMIRIAM(MIRIAM miriam) {
        Vector<String> rtn = new Vector<String>();
        if (miriam == null) {
            return rtn;
        }
        if (miriam.getDatatypes() == null) {
            return rtn;
        }
        int i = 0;
        while (i < miriam.getDatatypes().size()) {
            rtn.add(miriam.getDatatype((int)i).name);
            ++i;
        }
        return rtn;
    }

    public static final String getDefinitionOfMiriamDatatype(MIRIAM miriam, String name) {
        String rtn = "";
        if (miriam == null) {
            return rtn;
        }
        if (miriam.NamesOfMIRIAM == null) {
            return rtn;
        }
        if (name == null) {
            return rtn;
        }
        if (!miriam.NamesOfMIRIAM.contains(name)) {
            return rtn;
        }
        int i = 0;
        while (i < miriam.getDatatypes().size()) {
            if (miriam.getDatatype((int)i).name.toLowerCase().equals(name.trim().toLowerCase())) {
                return miriam.getDatatype((int)i).definition;
            }
            ++i;
        }
        return rtn;
    }

    public static final Vector<String> getUrisOfMiriamDatatype(MIRIAM miriam, String name) {
        Vector<String> rtn = new Vector<String>();
        if (miriam == null) {
            return rtn;
        }
        if (miriam.NamesOfMIRIAM == null) {
            return rtn;
        }
        if (name == null) {
            return rtn;
        }
        if (!miriam.NamesOfMIRIAM.contains(name)) {
            return rtn;
        }
        int i = 0;
        while (i < miriam.getDatatypes().size()) {
            if (miriam.getDatatype((int)i).name.toLowerCase().equals(name.trim().toLowerCase())) {
                int sizeUris = miriam.getDatatype((int)i).uris.size();
                int j = 0;
                while (j < sizeUris) {
                    rtn.add(miriam.getDatatype((int)i).uris.get((int)j).uri);
                    ++j;
                }
                break;
            }
            ++i;
        }
        return rtn;
    }

    public static final Vector<String> getDataEntrysOfMiriamDatatype(MIRIAM miriam, String name) {
        Vector<String> rtn = new Vector<String>();
        if (miriam == null) {
            return rtn;
        }
        if (miriam.NamesOfMIRIAM == null) {
            return rtn;
        }
        if (name == null) {
            return rtn;
        }
        if (!miriam.NamesOfMIRIAM.contains(name)) {
            return rtn;
        }
        int i = 0;
        while (i < miriam.getDatatypes().size()) {
            if (miriam.getDatatype((int)i).name.toLowerCase().equals(name.trim().toLowerCase())) {
                int sizeResources = miriam.getDatatype((int)i).resources.size();
                int j = 0;
                while (j < sizeResources) {
                    rtn.add(miriam.getDatatype((int)i).resources.get((int)j).dataEntry);
                    ++j;
                }
                break;
            }
            ++i;
        }
        return rtn;
    }

    public static final String getNameOfMiriamDatatypeUsingUri(MIRIAM miriam, String uri) {
        String rtn = "";
        if (miriam == null) {
            return rtn;
        }
        if (miriam.getDatatypes() == null) {
            return rtn;
        }
        if (uri == null) {
            return rtn;
        }
        int i = 0;
        while (i < miriam.getDatatypes().size()) {
            int sizeUris = miriam.getDatatype((int)i).uris.size();
            int j = 0;
            while (j < sizeUris) {
                if (miriam.getDatatype((int)i).uris.get((int)j).uri.toLowerCase().equals(uri.toLowerCase())) {
                    return miriam.getDatatype((int)i).name;
                }
                ++j;
            }
            ++i;
        }
        return rtn;
    }

    public static final String makeUriUsingNameAndID(MIRIAM miriam, String name, String id) {
        String rtn = "";
        if (id == null || id.trim().equals("")) {
            return rtn;
        }
        int iIndex = MiriamUtils.getIndexOfNameInMiriam(miriam, name);
        if (iIndex == -1) {
            return rtn;
        }
        Vector<MiriamUri> vUris = miriam.getDatatype((int)iIndex).uris;
        if (vUris == null || vUris.size() <= 0) {
            return rtn;
        }
        if (vUris.get((int)0).type.toUpperCase().equals("URN")) {
            rtn = String.valueOf(vUris.get((int)0).uri) + ":" + id;
        } else if (vUris.get((int)0).type.toUpperCase().equals("URL")) {
            rtn = String.valueOf(vUris.get((int)0).uri) + "#" + id;
        }
        return rtn;
    }

    public static final String makeDataEntryUsingNameAndID(MIRIAM miriam, String name, String id, int index) {
        Vector<String> dataentrys;
        String rtn = "";
        if (id == null || id.trim().equals("")) {
            id = "";
        }
        if ((dataentrys = MiriamUtils.getDataEntrysOfMiriamDatatype(miriam, name)) == null || dataentrys.size() <= 0) {
            return rtn;
        }
        int idx = index;
        if (index < 0) {
            idx = 0;
        } else if (index >= dataentrys.size()) {
            idx = 0;
        }
        return dataentrys.get(idx).replace("$id", id);
    }

    public static final boolean checkMiriamDatatypeID(MIRIAM miriam, String name, String id) {
        if (miriam == null) {
            return false;
        }
        if (miriam.getDatatypes() == null) {
            return false;
        }
        if (name == null || name.trim().equals("")) {
            return false;
        }
        if (id == null || id.trim().equals("")) {
            return false;
        }
        if (miriam.NamesOfMIRIAM == null) {
            return false;
        }
        if (!miriam.NamesOfMIRIAM.contains(name)) {
            return false;
        }
        String sPattern = null;
        int i = 0;
        while (i < miriam.getDatatypes().size()) {
            if (miriam.getDatatype((int)i).name.toLowerCase().equals(name.trim().toLowerCase())) {
                sPattern = miriam.getDatatype((int)i).pattern;
                break;
            }
            ++i;
        }
        if (sPattern == null) {
            return false;
        }
        String asciiId = MiriamUtils.changeMiriamIdFormat(id, false);
        return asciiId.matches(sPattern);
    }

    public static final int getIndexOfNameInMiriam(MIRIAM miriam, String name) {
        if (miriam == null) {
            return -1;
        }
        if (name == null || name.trim().equals("")) {
            return -1;
        }
        if (miriam.NamesOfMIRIAM == null) {
            return -1;
        }
        if (!miriam.NamesOfMIRIAM.contains(name)) {
            return -1;
        }
        int i = 0;
        while (i < miriam.NamesOfMIRIAM.size()) {
            if (miriam.NamesOfMIRIAM.get(i).toLowerCase().equals(name.trim().toLowerCase())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final String[] makeDataTypeAndIDUsingUri(String strUriInput) {
        int iStart;
        String strURL;
        String strID;
        Vector<String> uris = MainWindow.getInstanceOfMIRIAM().UrisOfMIRIAM;
        if (uris == null || uris.size() <= 0) {
            return null;
        }
        if (strUriInput == null || strUriInput.trim().equals("")) {
            return null;
        }
        String strUri = strUriInput.trim();
        int iMinLength = MainWindow.getInstanceOfMIRIAM().iMinLengthOfUrisOfMIRIAM;
        if (strUri.length() <= iMinLength) {
            return null;
        }
        if (strUri.contains("#")) {
            strID = strUri.substring(strUri.lastIndexOf("#") + 1);
            strURL = strUri.substring(0, strUri.lastIndexOf("#"));
            if (strURL != null && uris.contains(strURL)) {
                String utfId = MiriamUtils.changeMiriamIdFormat(strID, true);
                return new String[]{strURL, utfId};
            }
        } else if (strUri.contains(":")) {
            strID = strUri.substring(strUri.lastIndexOf(":") + 1);
            strURL = strUri.substring(0, strUri.lastIndexOf(":"));
            if (strURL != null && uris.contains(strURL)) {
                String utfId = MiriamUtils.changeMiriamIdFormat(strID, true);
                return new String[]{strURL, utfId};
            }
        }
        if ((iStart = strUriInput.length() - 2) > MainWindow.getInstanceOfMIRIAM().iMaxLengthOfUrisOfMIRIAM) {
            iStart = MainWindow.getInstanceOfMIRIAM().iMaxLengthOfUrisOfMIRIAM;
        }
        int i = iStart;
        while (i >= iMinLength) {
            String strURL2 = strUriInput.substring(0, i);
            String strID2 = strUriInput.substring(i);
            if (strURL2 != null && uris.contains(strURL2)) {
                if ((strID2 = strID2.substring(1)) != null && !strID2.equals("")) {
                    String utfId = MiriamUtils.changeMiriamIdFormat(strID2, true);
                    return new String[]{strURL2, utfId};
                }
                return null;
            }
            --i;
        }
        return null;
    }

    public static final String changeMiriamIdFormat(String id, boolean toUtf) {
        String rtn = null;
        if (id == null) {
            return rtn;
        }
        rtn = toUtf ? id.replace(":", "%3A").replace("%3a", "%3A").replace("/", "%2F").replace("%2f", "%2F") : id.replace("%3A", ":").replace("%3a", ":").replace("%2F", "/").replace("%2f", "/");
        return rtn;
    }

    public static final boolean canSeemAsSameMiriamId(String idA, String idB) {
        if (idA == null || idB == null) {
            return false;
        }
        String id1 = new String(idA);
        String id2 = new String(idB);
        return (id1 = MiriamUtils.changeMiriamIdFormat(id1, false)).equals(id2 = MiriamUtils.changeMiriamIdFormat(id2, false));
    }

    public static final void changeMiriamIdFormat(Model model) {
        if (model == null) {
            return;
        }
        try {
            try {
                SBMLFiler.resetAnnotationOfMiriam((SBase)model);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int i = 0;
            while ((long)i < model.getNumCompartments()) {
                try {
                    SBMLFiler.resetAnnotationOfMiriam((SBase)model.getCompartment((long)i));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
            i = 0;
            while ((long)i < model.getNumSpecies()) {
                try {
                    SBMLFiler.resetAnnotationOfMiriam((SBase)model.getSpecies((long)i));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
            i = 0;
            while ((long)i < model.getNumReactions()) {
                try {
                    SBMLFiler.resetAnnotationOfMiriam((SBase)model.getReaction((long)i));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
            i = 0;
            while ((long)i < model.getNumParameters()) {
                try {
                    SBMLFiler.resetAnnotationOfMiriam((SBase)model.getParameter((long)i));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
            i = 0;
            while ((long)i < model.getNumFunctionDefinitions()) {
                try {
                    SBMLFiler.resetAnnotationOfMiriam((SBase)model.getFunctionDefinition((long)i));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
            i = 0;
            while ((long)i < model.getNumUnitDefinitions()) {
                try {
                    SBMLFiler.resetAnnotationOfMiriam((SBase)model.getUnitDefinition((long)i));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
            i = 0;
            while ((long)i < model.getNumRules()) {
                try {
                    SBMLFiler.resetAnnotationOfMiriam((SBase)model.getRule((long)i));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
            i = 0;
            while ((long)i < model.getNumEvents()) {
                try {
                    SBMLFiler.resetAnnotationOfMiriam((SBase)model.getEvent((long)i));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final Vector<String> getDataResourcesOfMiriamDatatype(MIRIAM miriam, String name) {
        Vector<String> rtn = new Vector<String>();
        if (miriam == null) {
            return rtn;
        }
        if (miriam.NamesOfMIRIAM == null) {
            return rtn;
        }
        if (name == null) {
            return rtn;
        }
        if (!miriam.NamesOfMIRIAM.contains(name)) {
            return rtn;
        }
        int i = 0;
        while (i < miriam.getDatatypes().size()) {
            if (miriam.getDatatype((int)i).name.toLowerCase().equals(name.trim().toLowerCase())) {
                int sizeResources = miriam.getDatatype((int)i).resources.size();
                int j = 0;
                while (j < sizeResources) {
                    rtn.add(miriam.getDatatype((int)i).resources.get((int)j).dataResource);
                    ++j;
                }
                break;
            }
            ++i;
        }
        return rtn;
    }
}

