/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.miriam;

import java.util.Vector;
import jp.sbi.celldesigner.miriam.MiriamDatatype;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MiriamAnnotationFormat {
    protected String name = null;
    protected Vector<String> elements = null;

    public Vector<String> getElements() {
        return this.elements;
    }

    public String getElement(int i) {
        if (this.elements == null || this.elements.size() <= 0 || i < 0 || i > this.elements.size() - 1) {
            return null;
        }
        return this.elements.get(i);
    }

    public void setElements(Vector<String> elements) {
        this.elements = elements;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static final MiriamAnnotationFormat readingDOMTree(Element sourcedoc) throws Exception {
        if (sourcedoc == null) {
            return null;
        }
        MiriamAnnotationFormat format = null;
        if (sourcedoc.getNodeType() == 1) {
            Element elem = sourcedoc;
            String nodename = sourcedoc.getNodeName();
            if ("format".equals(nodename)) {
                format = new MiriamAnnotationFormat();
                NamedNodeMap map = elem.getAttributes();
                if (map != null) {
                    int k = 0;
                    while (k < map.getLength()) {
                        Node item = map.item(k);
                        if ("name".equals(item.getNodeName())) {
                            format.setName(item.getNodeValue());
                        }
                        ++k;
                    }
                }
                NodeList childlist1 = elem.getChildNodes();
                int childsize1 = childlist1.getLength();
                int i = 0;
                while (i < childsize1) {
                    Node node1 = childlist1.item(i);
                    if (node1.getNodeType() == 1) {
                        Element elem1 = (Element)node1;
                        String nodename1 = node1.getNodeName();
                        if ("elements".equals(nodename1)) {
                            Vector<String> elmns = MiriamDatatype.readingStringListFromDOMTree("element", elem1);
                            format.setElements(elmns);
                        }
                    }
                    ++i;
                }
            }
        }
        return format;
    }
}

