/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.miriam;

import java.io.BufferedInputStream;
import java.io.File;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jp.fric.util.Debug;
import jp.sbi.celldesigner.Application;
import jp.sbi.celldesigner.exception.MiriamException;
import jp.sbi.celldesigner.miriam.MiriamAnnotationFormat;
import jp.sbi.celldesigner.miriam.MiriamDatatype;
import jp.sbi.celldesigner.miriam.MiriamDocumentation;
import jp.sbi.celldesigner.miriam.MiriamResource;
import jp.sbi.celldesigner.miriam.MiriamUri;
import jp.sbi.celldesigner.miriam.MiriamUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MIRIAM {
    private static final String strResourceDir = "/jp/sbi/celldesigner/miriam/resource/miriam.xml";
    private static final int iMaxNumbersOfTabInPrintString = 20;
    public static final String strBqmodel = "bqmodel";
    public static final String strBqbiol = "bqbiol";
    public static final String strRelHasPart = "hasPart";
    public static final String strRelHasVersion = "hasVersion";
    public static final String strRelIs = "is";
    public static final String strRelIsDescribedBy = "isDescribedBy";
    public static final String strRelIsHomologTo = "isHomologTo";
    public static final String strRelIsPartOf = "isPartOf";
    public static final String strRelIsVersionOf = "isVersionOf";
    public static final String strRelIsEncodedBy = "isEncodedBy";
    public static final String strRelEncodes = "encodes";
    public static final String strRelOccursIn = "occursIn";
    public static final String strUriTypeURN = "URN";
    public static final String strUriTypeURL = "URL";
    public static final String strSeparator = ":";
    public static final String strSharp = "#";
    public static final String strIdVariable = "$id";
    public static final Vector<String> vectEnumerationRelation = new Vector();
    public static final Vector<String> vectEnumerationRelationOfMIRIAM = new Vector();
    protected static MIRIAM lastInstance;
    protected Vector<String> NamesOfMIRIAM = null;
    protected Vector<String> UrisOfMIRIAM = null;
    protected int iMinLengthOfUrisOfMIRIAM = Integer.MAX_VALUE;
    protected int iMaxLengthOfUrisOfMIRIAM = 0;
    protected String date = null;
    protected String dataversion = null;
    protected Vector<MiriamDatatype> datatypes = null;

    static {
        vectEnumerationRelation.add(strRelHasPart);
        vectEnumerationRelation.add(strRelHasVersion);
        vectEnumerationRelation.add(strRelIs);
        vectEnumerationRelation.add(strRelIsDescribedBy);
        vectEnumerationRelation.add(strRelIsHomologTo);
        vectEnumerationRelation.add(strRelIsPartOf);
        vectEnumerationRelation.add(strRelIsVersionOf);
        vectEnumerationRelation.add(strRelIsEncodedBy);
        vectEnumerationRelation.add(strRelEncodes);
        vectEnumerationRelation.add(strRelOccursIn);
        vectEnumerationRelationOfMIRIAM.add("bqmodel:is");
        vectEnumerationRelationOfMIRIAM.add("bqmodel:isDescribedBy");
        vectEnumerationRelationOfMIRIAM.add("bqbiol:is");
        vectEnumerationRelationOfMIRIAM.add("bqbiol:hasPart");
        vectEnumerationRelationOfMIRIAM.add("bqbiol:isPartOf");
        vectEnumerationRelationOfMIRIAM.add("bqbiol:isVersionOf");
        vectEnumerationRelationOfMIRIAM.add("bqbiol:hasVersion");
        vectEnumerationRelationOfMIRIAM.add("bqbiol:isHomologTo");
        vectEnumerationRelationOfMIRIAM.add("bqbiol:isDescribedBy");
        vectEnumerationRelationOfMIRIAM.add("bqbiol:isEncodedBy");
        vectEnumerationRelationOfMIRIAM.add("bqbiol:encodes");
        vectEnumerationRelationOfMIRIAM.add("bqbiol:occursIn");
        lastInstance = null;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getDataversion() {
        return this.dataversion;
    }

    public void setDataversion(String dataversion) {
        this.dataversion = dataversion;
    }

    public Vector<MiriamDatatype> getDatatypes() {
        return this.datatypes;
    }

    public MiriamDatatype getDatatype(int i) {
        if (this.datatypes == null || this.datatypes.size() <= 0 || i < 0 || i > this.datatypes.size() - 1) {
            return null;
        }
        return this.datatypes.get(i);
    }

    public void setDatatypes(Vector<MiriamDatatype> datatypes) {
        this.datatypes = datatypes;
    }

    public static final MIRIAM getLastInstance() throws Exception {
        if (lastInstance == null) {
            try {
                lastInstance = MIRIAM.getMIRIAMValueFromXmlFile();
                MIRIAM.lastInstance.NamesOfMIRIAM = MiriamUtils.getNamesOfMIRIAM(lastInstance);
                MIRIAM.lastInstance.UrisOfMIRIAM = new Vector();
                int i = 0;
                while (i < lastInstance.getDatatypes().size()) {
                    int sizeUris = MIRIAM.lastInstance.getDatatype((int)i).uris.size();
                    int j = 0;
                    while (j < sizeUris) {
                        String uri = MIRIAM.lastInstance.getDatatype((int)i).uris.get((int)j).uri;
                        MIRIAM.lastInstance.UrisOfMIRIAM.add(uri);
                        if (uri.length() < MIRIAM.lastInstance.iMinLengthOfUrisOfMIRIAM) {
                            MIRIAM.lastInstance.iMinLengthOfUrisOfMIRIAM = uri.length();
                        }
                        if (uri.length() > MIRIAM.lastInstance.iMaxLengthOfUrisOfMIRIAM) {
                            MIRIAM.lastInstance.iMaxLengthOfUrisOfMIRIAM = uri.length();
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            catch (MiriamException myErr) {
                lastInstance = null;
                throw myErr;
            }
            catch (Exception myErr) {
                lastInstance = null;
                throw new MiriamException("Can not read miriam.xml file, system exit.");
            }
        }
        return lastInstance;
    }

    private static final MIRIAM getMIRIAMValueFromXmlFile() throws Exception {
        MIRIAM tempMIRIAM = new MIRIAM();
        Document doc = null;
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setIgnoringElementContentWhitespace(true);
        try {
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            InputSource sourceFile = new InputSource(new BufferedInputStream(Application.class.getResourceAsStream(strResourceDir)));
            if (sourceFile == null) {
                throw new Exception();
            }
            doc = docBuilder.parse(sourceFile);
            if (doc == null) {
                throw new Exception();
            }
            Element root = doc.getDocumentElement();
            if (root instanceof Node) {
                Debug.outputDebugMessage("f", "******************** Print [node] starting ... ********************", 0);
                MIRIAM.quickviewerNode(root);
                Debug.outputDebugMessage("f", "******************** Print [node] End.         ********************", 0);
            }
            MIRIAM.setValueByReadingDOMTree(tempMIRIAM, root);
            MIRIAM.quickviewerMIRIAM(tempMIRIAM);
        }
        catch (SAXException myErr) {
            tempMIRIAM = null;
            throw new MiriamException("There are some wrong in miriam.xml file, system exit.");
        }
        catch (Exception myErr) {
            tempMIRIAM = null;
            throw new MiriamException("Can not read miriam.xml file, system exit.");
        }
        return tempMIRIAM;
    }

    private static final void setValueByReadingDOMTree(MIRIAM targetMIRIAM, Element sourcedoc) throws Exception {
        if (targetMIRIAM == null) {
            targetMIRIAM = new MIRIAM();
        }
        if (sourcedoc == null) {
            return;
        }
        if (sourcedoc.getNodeType() == 1) {
            NamedNodeMap map;
            Element elem = sourcedoc;
            String nodename = sourcedoc.getNodeName();
            if ("miriam".equals(nodename) && (map = elem.getAttributes()) != null) {
                int k = 0;
                while (k < map.getLength()) {
                    Node item = map.item(k);
                    if ("date".equals(item.getNodeName())) {
                        targetMIRIAM.setDate(item.getNodeValue());
                    } else if ("data-version".equals(item.getNodeName())) {
                        targetMIRIAM.setDataversion(item.getNodeValue());
                    }
                    ++k;
                }
            }
        }
        NodeList childlist1 = sourcedoc.getChildNodes();
        int childsize1 = childlist1.getLength();
        int i = 0;
        while (i < childsize1) {
            Element elem1;
            String nodename1;
            Node node1 = childlist1.item(i);
            if (node1.getNodeType() == 1 && "datatype".equals(nodename1 = (elem1 = (Element)node1).getNodeName())) {
                MiriamDatatype.readingDOMTree(targetMIRIAM, elem1);
            }
            ++i;
        }
    }

    public static File findTargetFile(File node, String filename, boolean isSearchingForDir) {
        if (node == null) {
            return null;
        }
        if (filename == null) {
            return null;
        }
        if (node.isDirectory()) {
            if (isSearchingForDir) {
                if (filename.equals(node.getName())) {
                    return node;
                }
            } else {
                File[] fileList = node.listFiles();
                int index = 0;
                while (index < fileList.length) {
                    File rtn = MIRIAM.findTargetFile(fileList[index], filename, isSearchingForDir);
                    if (rtn != null) {
                        return rtn;
                    }
                    ++index;
                }
            }
        } else {
            try {
                if (!isSearchingForDir && filename.equals(node.getName())) {
                    return node;
                }
            }
            catch (Exception myErr) {
                return null;
            }
        }
        return null;
    }

    public static final String getElementValue(Node elem) {
        if (elem != null && elem.hasChildNodes()) {
            Node kid = elem.getFirstChild();
            while (kid != null) {
                if (kid.getNodeType() == 3) {
                    return kid.getNodeValue();
                }
                kid = kid.getNextSibling();
            }
        }
        return "";
    }

    private static final String givePrefixSpaces(int iTabIndex) {
        String strTabs = "";
        if (iTabIndex <= 0) {
            iTabIndex = 0;
        } else if (iTabIndex >= 20) {
            iTabIndex = 20;
        }
        int i = 0;
        while (i < iTabIndex) {
            strTabs = String.valueOf(strTabs) + "\t";
            ++i;
        }
        return strTabs;
    }

    public static final void quickviewerNode(Node node) {
        MIRIAM.quickviewerNode(node, 0);
    }

    private static final void quickviewerNode(Node node, int indent) {
        if (node == null) {
            Debug.outputDebugMessage("f", "There are nothing in [node].", 0);
        }
        String nodeName = node.getNodeName();
        String nodeValue = MIRIAM.getElementValue(node);
        NamedNodeMap attributes = node.getAttributes();
        Debug.outputDebugMessage("f", String.valueOf(MIRIAM.givePrefixSpaces(indent)) + "nodeName :[" + nodeName + "], nodeValue :[" + nodeValue + "]", 0);
        int iAttrLen = attributes.getLength();
        int i = 0;
        while (i < iAttrLen) {
            Node attribute = attributes.item(i);
            Debug.outputDebugMessage("f", String.valueOf(MIRIAM.givePrefixSpaces(indent + 3)) + "attrName :[" + attribute.getNodeName() + "], attrValue :[" + attribute.getNodeValue() + "]", 0);
            ++i;
        }
        NodeList kids = node.getChildNodes();
        int iKidsSize = kids.getLength();
        int i2 = 0;
        while (i2 < iKidsSize) {
            Node child = kids.item(i2);
            if (child.getNodeType() == 1) {
                MIRIAM.quickviewerNode(child, indent + 1);
            }
            ++i2;
        }
    }

    public static final void quickviewerMIRIAM(MIRIAM miriam) {
        Debug.outputDebugMessage("f", "******************** Print [miriam] starting ... ********************", 0);
        if (miriam == null) {
            Debug.outputDebugMessage("f", "There are nothing in [miriam].", 0);
        } else {
            int indent = 0;
            Debug.outputDebugMessage("f", String.valueOf(MIRIAM.givePrefixSpaces(indent)) + "date :[" + MIRIAM.replaceNullToMark(miriam.date) + "]", 0);
            Debug.outputDebugMessage("f", String.valueOf(MIRIAM.givePrefixSpaces(indent)) + "dataversion :[" + MIRIAM.replaceNullToMark(miriam.dataversion) + "]", 0);
            ++indent;
            if (miriam.datatypes != null && miriam.datatypes.size() > 0) {
                int i = 0;
                while (i < miriam.datatypes.size()) {
                    MiriamDatatype datatype = miriam.datatypes.get(i);
                    MIRIAM.quickviewerMiriamDatatype(datatype, indent);
                    ++i;
                }
            }
        }
        Debug.outputDebugMessage("f", "******************** Print [miriam] End.         ********************", 0);
    }

    public static final void quickviewerMiriamDatatype(MiriamDatatype datatype, int iTabIndex) {
        int j;
        int subindent;
        if (datatype == null) {
            return;
        }
        int indent = iTabIndex;
        if (iTabIndex <= 0) {
            indent = 0;
        } else if (iTabIndex >= 20) {
            indent = 20;
        }
        Debug.outputDebugMessage("f", String.valueOf(MIRIAM.givePrefixSpaces(indent)) + "id          :[" + MIRIAM.replaceNullToMark(datatype.id) + "]", 0);
        Debug.outputDebugMessage("f", String.valueOf(MIRIAM.givePrefixSpaces(indent)) + "pattern     :[" + MIRIAM.replaceNullToMark(datatype.pattern) + "]", 0);
        Debug.outputDebugMessage("f", String.valueOf(MIRIAM.givePrefixSpaces(indent)) + "obsolete    :[" + MIRIAM.replaceNullToMark(datatype.obsolete) + "]", 0);
        Debug.outputDebugMessage("f", String.valueOf(MIRIAM.givePrefixSpaces(indent)) + "replacement :[" + MIRIAM.replaceNullToMark(datatype.replacement) + "]", 0);
        Debug.outputDebugMessage("f", String.valueOf(MIRIAM.givePrefixSpaces(indent)) + "comment     :[" + MIRIAM.replaceNullToMark(datatype.comment) + "]", 0);
        Debug.outputDebugMessage("f", String.valueOf(MIRIAM.givePrefixSpaces(indent)) + "name        :[" + MIRIAM.replaceNullToMark(datatype.name) + "]", 0);
        if (datatype.synonyms != null && datatype.synonyms.size() > 0) {
            subindent = indent + 1;
            Debug.outputDebugMessage("f", String.valueOf(MIRIAM.givePrefixSpaces(indent)) + "Vector of [synonyms]", 0);
            j = 0;
            while (j < datatype.synonyms.size()) {
                String synonym = datatype.synonyms.get(j);
                Debug.outputDebugMessage("f", String.valueOf(MIRIAM.givePrefixSpaces(subindent)) + "synonym :[" + MIRIAM.replaceNullToMark(synonym) + "]", 0);
                ++j;
            }
        }
        Debug.outputDebugMessage("f", String.valueOf(MIRIAM.givePrefixSpaces(indent)) + "definition  :[" + MIRIAM.replaceNullToMark(datatype.definition) + "]", 0);
        if (datatype.uris != null && datatype.uris.size() > 0) {
            subindent = indent + 1;
            Debug.outputDebugMessage("f", String.valueOf(MIRIAM.givePrefixSpaces(indent)) + "Vector of [uris]", 0);
            j = 0;
            while (j < datatype.uris.size()) {
                MiriamUri uri = datatype.uris.get(j);
                Debug.outputDebugMessage("f", String.valueOf(MIRIAM.givePrefixSpaces(subindent)) + "type       :[" + MIRIAM.replaceNullToMark(uri.type) + "]", 0);
                Debug.outputDebugMessage("f", String.valueOf(MIRIAM.givePrefixSpaces(subindent)) + "deprecated :[" + uri.deprecated + "]", 0);
                Debug.outputDebugMessage("f", String.valueOf(MIRIAM.givePrefixSpaces(subindent)) + "uri        :[" + MIRIAM.replaceNullToMark(uri.uri) + "]", 0);
                ++j;
            }
        }
        if (datatype.documentations != null && datatype.documentations.size() > 0) {
            subindent = indent + 1;
            Debug.outputDebugMessage("f", String.valueOf(MIRIAM.givePrefixSpaces(indent)) + "Vector of [documentations]", 0);
            j = 0;
            while (j < datatype.documentations.size()) {
                MiriamDocumentation documentation = datatype.documentations.get(j);
                Debug.outputDebugMessage("f", String.valueOf(MIRIAM.givePrefixSpaces(subindent)) + "type          :[" + MIRIAM.replaceNullToMark(documentation.type) + "]", 0);
                Debug.outputDebugMessage("f", String.valueOf(MIRIAM.givePrefixSpaces(subindent)) + "documentation :[" + MIRIAM.replaceNullToMark(documentation.documentation) + "]", 0);
                ++j;
            }
        }
        if (datatype.resources != null && datatype.resources.size() > 0) {
            subindent = indent + 1;
            Debug.outputDebugMessage("f", String.valueOf(MIRIAM.givePrefixSpaces(indent)) + "Vector of [resources]", 0);
            j = 0;
            while (j < datatype.resources.size()) {
                MiriamResource resources = datatype.resources.get(j);
                Debug.outputDebugMessage("f", String.valueOf(MIRIAM.givePrefixSpaces(subindent)) + "id                :[" + MIRIAM.replaceNullToMark(resources.id) + "]", 0);
                Debug.outputDebugMessage("f", String.valueOf(MIRIAM.givePrefixSpaces(subindent)) + "dataResource      :[" + MIRIAM.replaceNullToMark(resources.dataResource) + "]", 0);
                Debug.outputDebugMessage("f", String.valueOf(MIRIAM.givePrefixSpaces(subindent)) + "dataEntityExample :[" + MIRIAM.replaceNullToMark(resources.dataEntityExample) + "]", 0);
                Debug.outputDebugMessage("f", String.valueOf(MIRIAM.givePrefixSpaces(subindent)) + "dataEntry         :[" + MIRIAM.replaceNullToMark(resources.dataEntry) + "]", 0);
                Debug.outputDebugMessage("f", String.valueOf(MIRIAM.givePrefixSpaces(subindent)) + "dataInfo          :[" + MIRIAM.replaceNullToMark(resources.dataInfo) + "]", 0);
                Debug.outputDebugMessage("f", String.valueOf(MIRIAM.givePrefixSpaces(subindent)) + "dataInstitution   :[" + MIRIAM.replaceNullToMark(resources.dataInstitution) + "]", 0);
                Debug.outputDebugMessage("f", String.valueOf(MIRIAM.givePrefixSpaces(subindent)) + "dataLocation      :[" + MIRIAM.replaceNullToMark(resources.dataLocation) + "]", 0);
                ++j;
            }
        }
        if (datatype.tags != null && datatype.tags.size() > 0) {
            subindent = indent + 1;
            Debug.outputDebugMessage("f", String.valueOf(MIRIAM.givePrefixSpaces(indent)) + "Vector of [tags]", 0);
            j = 0;
            while (j < datatype.tags.size()) {
                String tag = datatype.tags.get(j);
                Debug.outputDebugMessage("f", String.valueOf(MIRIAM.givePrefixSpaces(subindent)) + "tag :[" + MIRIAM.replaceNullToMark(tag) + "]", 0);
                ++j;
            }
        }
        if (datatype.annotation != null && datatype.annotation.formats != null && datatype.annotation.formats.size() > 0) {
            subindent = indent + 1;
            Debug.outputDebugMessage("f", String.valueOf(MIRIAM.givePrefixSpaces(indent)) + "formats of [annotation]", 0);
            j = 0;
            while (j < datatype.annotation.formats.size()) {
                MiriamAnnotationFormat format = datatype.annotation.formats.get(j);
                Debug.outputDebugMessage("f", String.valueOf(MIRIAM.givePrefixSpaces(subindent)) + "name :[" + MIRIAM.replaceNullToMark(format.name) + "]", 0);
                if (format.elements != null && format.elements.size() > 0) {
                    int subindent2 = subindent + 1;
                    Debug.outputDebugMessage("f", String.valueOf(MIRIAM.givePrefixSpaces(subindent)) + "Vector of [elements]", 0);
                    int k = 0;
                    while (k < format.elements.size()) {
                        String element = format.elements.get(k);
                        Debug.outputDebugMessage("f", String.valueOf(MIRIAM.givePrefixSpaces(subindent2)) + "element :[" + MIRIAM.replaceNullToMark(element) + "]", 0);
                        ++k;
                    }
                }
                ++j;
            }
        }
    }

    public static final String replaceNullToMark(String input) {
        if (input == null) {
            return "---";
        }
        return input;
    }
}

